/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.impl;

import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.exist.management.impl.DatabaseMBean;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;

public class Database
implements DatabaseMBean {
    private static String[] itemNames = new String[]{"owner", "referenceCount"};
    private static String[] itemDescriptions = new String[]{"Name of the thread owning the broker", "Number of references held by the thread"};
    private static String[] indexNames = new String[]{"owner"};
    private BrokerPool pool;

    public Database(BrokerPool pool) {
        this.pool = pool;
    }

    public String getInstanceId() {
        return this.pool.getId();
    }

    public int getMaxBrokers() {
        return this.pool.getMax();
    }

    public int getAvailableBrokers() {
        return this.pool.available();
    }

    public int getActiveBrokers() {
        return this.pool.active();
    }

    public TabularData getActiveBrokersMap() {
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        try {
            CompositeType infoType = new CompositeType("brokerInfo", "Provides information on a broker instance.", itemNames, itemDescriptions, itemTypes);
            TabularType tabularType = new TabularType("activeBrokers", "Lists all threads currently using a broker instance", infoType, indexNames);
            TabularDataSupport data = new TabularDataSupport(tabularType);
            for (Map.Entry entry : this.pool.getActiveBrokers().entrySet()) {
                Thread thread = (Thread)entry.getKey();
                DBBroker broker = (DBBroker)entry.getValue();
                Object[] itemValues = new Object[]{thread.getName(), broker.getReferenceCount()};
                data.put(new CompositeDataSupport(infoType, itemNames, itemValues));
            }
            return data;
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getReservedMem() {
        return this.pool.getReservedMem();
    }

    public long getCacheMem() {
        return this.pool.getCacheManager().getTotalMem();
    }

    public long getCollectionCacheMem() {
        return this.pool.getCollectionCacheMgr().getMaxTotal();
    }
}

