/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.exist.management.Agent;
import org.exist.management.impl.Database;
import org.exist.management.impl.LockManager;
import org.exist.management.impl.ProcessReport;
import org.exist.management.impl.SanityReport;
import org.exist.storage.BrokerPool;
import org.exist.util.DatabaseConfigurationException;

public class JMXAgent
implements Agent {
    private static final Logger LOG = Logger.getLogger(JMXAgent.class);
    private static Agent agent = null;
    private MBeanServer server;
    private Map registeredMBeans = new HashMap();
    private Map beanInstances = new HashMap();

    public static Agent getInstance() {
        if (agent == null) {
            agent = new JMXAgent();
        }
        return agent;
    }

    public JMXAgent() {
        ArrayList<MBeanServer> servers;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Creating the JMX MBeanServer.");
        }
        this.server = (servers = MBeanServerFactory.findMBeanServer(null)).size() > 0 ? servers.get(0) : MBeanServerFactory.createMBeanServer();
        this.registerSystemMBeans();
    }

    public synchronized void registerSystemMBeans() {
        try {
            ObjectName name = new ObjectName("org.exist.management:type=LockManager");
            this.addMBean(name, new LockManager());
        }
        catch (MalformedObjectNameException e) {
            LOG.warn((Object)"Exception while registering cache mbean.", (Throwable)e);
        }
        catch (DatabaseConfigurationException e) {
            LOG.warn((Object)"Exception while registering cache mbean.", (Throwable)e);
        }
    }

    public void initDBInstance(BrokerPool instance) {
        try {
            this.addMBean(instance.getId(), "org.exist.management." + instance.getId() + ":type=Database", new Database(instance));
            this.addMBean(instance.getId(), "org.exist.management." + instance.getId() + ".tasks:type=SanityReport", new SanityReport(instance));
            this.addMBean(instance.getId(), "org.exist.management." + instance.getId() + ":type=ProcessReport", new ProcessReport(instance));
        }
        catch (DatabaseConfigurationException e) {
            LOG.warn((Object)"Exception while registering database mbean.", (Throwable)e);
        }
    }

    public synchronized void closeDBInstance(BrokerPool instance) {
        try {
            Stack stack = (Stack)this.registeredMBeans.get(instance.getId());
            while (!stack.isEmpty()) {
                ObjectName on = (ObjectName)stack.pop();
                LOG.debug((Object)("deregistering JMX MBean: " + on));
                if (!this.server.isRegistered(on)) continue;
                this.server.unregisterMBean(on);
            }
        }
        catch (InstanceNotFoundException e) {
            LOG.warn((Object)"Problem found while unregistering JMX", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            LOG.warn((Object)"Problem found while unregistering JMX", (Throwable)e);
        }
    }

    public synchronized void addMBean(String dbInstance, String name, Object mbean) throws DatabaseConfigurationException {
        try {
            ObjectName on = new ObjectName(name);
            this.addMBean(on, mbean);
            if (dbInstance != null) {
                Stack<ObjectName> stack = (Stack<ObjectName>)this.registeredMBeans.get(dbInstance);
                if (stack == null) {
                    stack = new Stack<ObjectName>();
                    this.registeredMBeans.put(dbInstance, stack);
                }
                stack.push(on);
            }
            this.beanInstances.put(on, mbean);
        }
        catch (MalformedObjectNameException e) {
            LOG.warn((Object)("Problem registering mbean: " + e.getMessage()), (Throwable)e);
            throw new DatabaseConfigurationException("Exception while registering JMX mbean: " + e.getMessage());
        }
    }

    private void addMBean(ObjectName name, Object mbean) throws DatabaseConfigurationException {
        try {
            if (!this.server.isRegistered(name)) {
                this.server.registerMBean(mbean, name);
            }
        }
        catch (InstanceAlreadyExistsException e) {
            LOG.warn((Object)("Problem registering mbean: " + e.getMessage()), (Throwable)e);
            throw new DatabaseConfigurationException("Exception while registering JMX mbean: " + e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            LOG.warn((Object)("Problem registering mbean: " + e.getMessage()), (Throwable)e);
            throw new DatabaseConfigurationException("Exception while registering JMX mbean: " + e.getMessage());
        }
        catch (NotCompliantMBeanException e) {
            LOG.warn((Object)("Problem registering mbean: " + e.getMessage()), (Throwable)e);
            throw new DatabaseConfigurationException("Exception while registering JMX mbean: " + e.getMessage());
        }
    }

    public synchronized void updateErrors(BrokerPool instance, List errorList, long startTime) {
        try {
            ObjectName name = new ObjectName("org.exist.management." + instance.getId() + ".tasks:type=SanityReport");
            SanityReport report = (SanityReport)this.beanInstances.get(name);
            if (report != null) {
                report.updateErrors(errorList, startTime);
            }
        }
        catch (MalformedObjectNameException e) {
            LOG.warn((Object)("Problem calling mbean: " + e.getMessage()), (Throwable)e);
        }
    }
}

