/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.impl;

import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.exist.management.impl.LockManagerMBean;
import org.exist.storage.lock.DeadlockDetection;
import org.exist.storage.lock.LockInfo;

public class LockManager
implements LockManagerMBean {
    private static String[] itemNames = new String[]{"waitingThread", "lockType", "lockMode", "id", "owner", "waitingForRead", "waitingForWrite"};
    private static String[] itemDescriptions = new String[]{"Name of the thread waiting for the lock", "Type of the lock (COLLECTION or RESOURCE)", "Mode of the lock (READ or WRITE)", "Id of the lock (resource or collection path)", "The names of the threads currently holding the lock", "Names of threads currently waiting for a read lock", "Names of threads currently waiting for a write lock"};
    private static String[] indexNames = new String[]{"waitingThread"};

    public TabularData getWaitingThreads() {
        Map map = DeadlockDetection.getWaitingThreads();
        try {
            return this.lockMapToComposite(map);
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    private TabularData lockMapToComposite(Map map) throws OpenDataException {
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, new ArrayType(1, SimpleType.STRING), new ArrayType(1, SimpleType.STRING), new ArrayType(1, SimpleType.STRING)};
        CompositeType lockType = new CompositeType("lockInfo", "Provides information on a thread waiting for a lock", itemNames, itemDescriptions, itemTypes);
        TabularType tabularType = new TabularType("waitingThreads", "Lists all threads waiting for a lock", lockType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        for (Map.Entry entry : map.entrySet()) {
            LockInfo info = (LockInfo)entry.getValue();
            Object[] itemValues = new Object[]{entry.getKey(), info.getLockType(), info.getLockMode(), info.getId(), info.getOwners(), info.getWaitingForRead(), info.getWaitingForWrite()};
            data.put(new CompositeDataSupport(lockType, itemNames, itemValues));
        }
        return data;
    }
}

