/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.impl;

import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.log4j.Logger;
import org.exist.management.impl.ProcessReportMBean;
import org.exist.storage.BrokerPool;
import org.exist.storage.ProcessMonitor;
import org.exist.xquery.XQueryWatchDog;

public class ProcessReport
implements ProcessReportMBean {
    private static final Logger LOG = Logger.getLogger(ProcessReport.class);
    private static String[] pItemNames = new String[]{"id", "action", "info"};
    private static String[] pItemDescriptions = new String[]{"Process ID", "Description of the current action", "Additional info provided by thread"};
    private static String[] pIndexNames = new String[]{"id"};
    private static String[] qItemNames = new String[]{"id", "sourceType", "sourceKey", "terminating"};
    private static String[] qItemDescriptions = new String[]{"XQuery ID", "Type of the query source", "Description of the source", "Is query terminating?"};
    private static String[] qIndexNames = new String[]{"id"};
    private ProcessMonitor processMonitor;

    public ProcessReport(BrokerPool pool) {
        this.processMonitor = pool.getProcessMonitor();
    }

    public TabularData getRunningJobs() {
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
        try {
            CompositeType infoType = new CompositeType("runningJobs", "Lists currently running jobs in eXist", pItemNames, pItemDescriptions, itemTypes);
            TabularType tabularType = new TabularType("jobList", "List of currently running jobs", infoType, pIndexNames);
            TabularDataSupport data = new TabularDataSupport(tabularType);
            ProcessMonitor.JobInfo[] jobs = this.processMonitor.runningJobs();
            for (int i = 0; i < jobs.length; ++i) {
                Object[] itemValues = new Object[]{jobs[i].getThread().getName(), jobs[i].getAction(), jobs[i].getAddInfo().toString()};
                data.put(new CompositeDataSupport(infoType, pItemNames, itemValues));
            }
            return data;
        }
        catch (OpenDataException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public TabularData getRunningQueries() {
        OpenType[] itemTypes = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN};
        try {
            CompositeType infoType = new CompositeType("runningQueries", "Lists currently running XQueries", qItemNames, qItemDescriptions, itemTypes);
            TabularType tabularType = new TabularType("jobList", "List of currently running XQueries", infoType, qIndexNames);
            TabularDataSupport data = new TabularDataSupport(tabularType);
            XQueryWatchDog[] watchdogs = this.processMonitor.getRunningXQueries();
            for (int i = 0; i < watchdogs.length; ++i) {
                Object[] itemValues = new Object[]{new Integer(watchdogs[i].getContext().hashCode()), watchdogs[i].getContext().getSourceType(), watchdogs[i].getContext().getSourceKey(), watchdogs[i].isTerminating()};
                data.put(new CompositeDataSupport(infoType, qItemNames, itemValues));
            }
            return data;
        }
        catch (OpenDataException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

