/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management.impl;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.backup.ErrorReport;
import org.exist.management.impl.SanityReportMBean;
import org.exist.storage.BrokerPool;
import org.exist.storage.ConsistencyCheckTask;
import org.exist.storage.SystemTask;

public class SanityReport
extends NotificationBroadcasterSupport
implements SanityReportMBean {
    private static final Logger LOG = Logger.getLogger((String)SanityReport.class.getName());
    public static final String STATUS_OK = "OK";
    public static final String STATUS_FAIL = "FAIL";
    private static String[] itemNames = new String[]{"errcode", "description"};
    private static String[] itemDescriptions = new String[]{"Error code", "Description of the error"};
    private static String[] indexNames = new String[]{"errcode"};
    private static List NO_ERRORS = new LinkedList();
    private int seqNum = 0;
    private Date lastCheckStart = null;
    private Date lastCheckEnd = null;
    private String status = "OK";
    private List errors = NO_ERRORS;
    private BrokerPool pool;

    public SanityReport(BrokerPool pool) {
        this.pool = pool;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"jmx.attribute.change"};
        String name = AttributeChangeNotification.class.getName();
        String description = "The status attribute of this MBean has changed";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, description);
        return new MBeanNotificationInfo[]{info};
    }

    public Date getLastCheckEnd() {
        return this.lastCheckEnd;
    }

    public Date getLastCheckStart() {
        return this.lastCheckStart;
    }

    public String getStatus() {
        return this.status;
    }

    public TabularData getErrors() {
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
        try {
            CompositeType infoType = new CompositeType("errorInfo", "Provides information on a consistency check error", itemNames, itemDescriptions, itemTypes);
            TabularType tabularType = new TabularType("errorList", "List of consistency check errors", infoType, indexNames);
            TabularDataSupport data = new TabularDataSupport(tabularType);
            for (int i = 0; i < this.errors.size(); ++i) {
                ErrorReport error = (ErrorReport)this.errors.get(i);
                Object[] itemValues = new Object[]{error.getErrcodeString(), error.getMessage()};
                data.put(new CompositeDataSupport(infoType, itemNames, itemValues));
            }
            return data;
        }
        catch (OpenDataException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void triggerCheck() {
        try {
            ConsistencyCheckTask task = new ConsistencyCheckTask();
            Properties properties = new Properties();
            task.configure(this.pool.getConfiguration(), properties);
            this.pool.triggerSystemTask((SystemTask)task);
        }
        catch (EXistException e) {
            LOG.warn((Object)("Failed to trigger db sanity check: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void updateErrors(List errorList, long startTime) {
        long endTime = System.currentTimeMillis();
        String oldStatus = this.status;
        if (errorList == null || errorList.isEmpty()) {
            this.status = STATUS_OK;
            this.errors = NO_ERRORS;
        } else {
            this.errors = errorList;
            this.status = STATUS_FAIL;
        }
        this.lastCheckStart = new Date(startTime);
        this.lastCheckEnd = new Date(endTime);
        AttributeChangeNotification event = new AttributeChangeNotification(this, this.seqNum++, endTime, "Consistency errors found", "status", "String", oldStatus, this.status);
        event.setUserData(this.status);
        this.sendNotification(event);
    }
}

