/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.OpenEstateUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class AbstractImplItem {
    private static final Logger LOGGER = Logger.getLogger(AbstractImplItem.class);
    private HashMap<String, Object> values = new HashMap();

    protected AbstractImplItem() {
    }

    public Object getValue(String string) {
        return this.getValue(string, null);
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    protected Object getValue(String string, Object object) {
        return this.values.containsKey(string) ? this.values.get(string) : object;
    }

    public void merge(AbstractImplItem abstractImplItem) {
        this.getValues().putAll(abstractImplItem.getValues());
    }

    protected void putValue(String string, Object object) {
        if (object == null) {
            if (this.values.containsKey(string)) {
                this.values.remove(string);
            }
        } else {
            this.values.put(string, object);
        }
    }

    public static String selectAttribute(Element element, String string) {
        return AbstractImplItem.selectAttribute(element, string, null);
    }

    public static String selectAttribute(Element element, String string, String string2) {
        Node node = element.selectSingleNode("@" + string);
        return node != null ? node.getStringValue() : string2;
    }

    public static Boolean selectAttributeAsBoolean(Element element, String string) {
        return AbstractImplItem.selectAttributeAsBoolean(element, string, null);
    }

    public static Boolean selectAttributeAsBoolean(Element element, String string, Boolean bl) {
        try {
            String string2 = AbstractImplItem.selectAttribute(element, string, null);
            return string2 != null ? Boolean.valueOf(string2) : bl;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("invalid boolean for " + element.getName() + " = "));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
            return bl;
        }
    }

    public static Currency selectAttributeAsCurrency(Element element, String string) {
        return AbstractImplItem.selectAttributeAsCurrency(element, string, null);
    }

    public static Currency selectAttributeAsCurrency(Element element, String string, Currency currency) {
        try {
            String string2 = AbstractImplItem.selectAttribute(element, string, null);
            return string2 != null ? Currency.getInstance(string2) : currency;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("invalid currency for " + element.getName() + " = "));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
            return currency;
        }
    }

    public static Date selectAttributeAsDate(Element element, String string) {
        return AbstractImplItem.selectAttributeAsDate(element, string, null);
    }

    public static Date selectAttributeAsDate(Element element, String string, Date date) {
        try {
            String string2 = AbstractImplItem.selectAttribute(element, string, null);
            return string2 != null ? OpenEstateUtils.getXsdDateFormat().parse(string2) : date;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("invalid currency for " + element.getName() + " = "));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
            return date;
        }
    }

    public static Date selectAttributeAsDateTime(Element element, String string) {
        return AbstractImplItem.selectAttributeAsDateTime(element, string, null);
    }

    public static Date selectAttributeAsDateTime(Element element, String string, Date date) {
        try {
            String string2 = AbstractImplItem.selectAttribute(element, string, null);
            return string2 != null ? OpenEstateUtils.getXsdDateTimeFormat().parse(string2) : date;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("invalid currency for " + element.getName() + " = "));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
            return date;
        }
    }

    public static Double selectAttributeAsDouble(Element element, String string) {
        return AbstractImplItem.selectAttributeAsDouble(element, string, null);
    }

    public static Double selectAttributeAsDouble(Element element, String string, Double d) {
        try {
            String string2 = AbstractImplItem.selectAttribute(element, string, null);
            return string2 != null ? Double.valueOf(string2) : d;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("invalid float for " + element.getName() + " = "));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
            return d;
        }
    }

    public static Float selectAttributeAsFloat(Element element, String string) {
        return AbstractImplItem.selectAttributeAsFloat(element, string, null);
    }

    public static Float selectAttributeAsFloat(Element element, String string, Float f) {
        try {
            String string2 = AbstractImplItem.selectAttribute(element, string, null);
            return string2 != null ? Float.valueOf(string2) : f;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("invalid float for " + element.getName() + " = "));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
            return f;
        }
    }

    public static URL selectAttributeAsURL(Element element, String string) {
        return AbstractImplItem.selectAttributeAsURL(element, string, null);
    }

    public static URL selectAttributeAsURL(Element element, String string, URL uRL) {
        try {
            String string2 = AbstractImplItem.selectAttribute(element, string, null);
            return string2 != null ? new URL(string2) : uRL;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("invalid URL for " + element.getName() + " = "));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
            return uRL;
        }
    }

    public static List<Node> selectChildElements(Element element) {
        if (element == null) {
            return null;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.addAll(element.selectNodes("*"));
        return arrayList;
    }
}

