/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.CompanyAdressImpl;
import com.openindex.openestate.impl.CustomValuesImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;

public class AgentImpl
extends AbstractImplItem
implements SerializableXmlElement {
    private static final String XML_ATTRIB_ID = "Id";
    public static final String XML_ELEMENT = "Agent";
    private static final String XML_ELEMENT_COMPANY = "Company";
    private static final String XML_ELEMENT_TERMS = "Terms";
    private static final String XML_ELEMENT_TERMS_TEXT = "Text";
    private static final String XML_ELEMENT_TERMS_LANGUAGE = "Language";
    public static final String XML_ELEMENT_VALUES = "CustomValues";
    private CompanyAdressImpl company = new CompanyAdressImpl();
    private CustomValuesImpl customValues = new CustomValuesImpl();
    private Map<String, String> terms = new HashMap<String, String>();

    public AgentImpl() {
    }

    public AgentImpl(Document document) throws DocumentException {
        this();
        this.build(document);
    }

    private void build(Document document) throws DocumentException {
        this.readFromXml(document);
    }

    public CompanyAdressImpl getCompany() {
        return this.company;
    }

    public CustomValuesImpl getCustomValues() {
        return this.customValues;
    }

    public String getId() {
        return (String)this.getValue(XML_ATTRIB_ID);
    }

    @Deprecated
    public String getTerms() {
        return this.getTerms((String)null);
    }

    public String getTerms(Locale locale) {
        return this.getTerms(locale.getLanguage());
    }

    public String getTerms(String string) {
        if (string != null && this.terms.containsKey(string)) {
            return this.terms.get(string);
        }
        return null;
    }

    @Override
    public void merge(AbstractImplItem abstractImplItem) {
        super.merge(abstractImplItem);
        if (abstractImplItem instanceof AgentImpl) {
            this.company.merge(((AgentImpl)abstractImplItem).getCompany());
            this.customValues.merge(((AgentImpl)abstractImplItem).getCustomValues());
        }
    }

    @Override
    public void readFromXml(Document document) throws DocumentException {
        this.readFromXml(document.getRootElement());
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        this.setId(AgentImpl.selectAttribute(element, null));
        for (Node node : AgentImpl.selectChildElements(element)) {
            if (XML_ELEMENT_COMPANY.equals(node.getName())) {
                this.getCompany().readFromXml((Element)node);
                continue;
            }
            if (XML_ELEMENT_TERMS.equals(node.getName())) {
                if (((Element)node).isTextOnly()) {
                    String string = node.getStringValue();
                    this.setTerms(string != null ? OpenEstateUtils.parseString(string) : null);
                    continue;
                }
                for (Node node2 : AgentImpl.selectChildElements((Element)node)) {
                    if (!XML_ELEMENT_TERMS_TEXT.equals(node2.getName())) continue;
                    String string = AgentImpl.selectAttribute((Element)node2, XML_ELEMENT_TERMS_LANGUAGE);
                    String string2 = node2.getStringValue();
                    if (string == null || string.length() != 2) continue;
                    if (string2 != null && string2.trim().length() > 0) {
                        this.setTerms(StringEscapeUtils.unescapeHtml((String)string2.trim()), string);
                        continue;
                    }
                    this.setTerms(null, string);
                }
                continue;
            }
            if (!XML_ELEMENT_VALUES.equals(node.getName())) continue;
            this.getCustomValues().readFromXml((Element)node);
        }
    }

    @Override
    public void serializeToXml(Document document) throws DocumentException {
        Element element = DocumentFactory.getInstance().createElement(XML_ELEMENT, "http://www.openestate.org/1.0/");
        this.serializeToXml(element);
        document.setRootElement(element);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        element.addAttribute(XML_ATTRIB_ID, this.getId() != null ? this.getId() : "0");
        this.company.serializeToXml(element.addElement(XML_ELEMENT_COMPANY));
        Element element2 = element.addElement(XML_ELEMENT_TERMS);
        for (String string : this.terms.keySet()) {
            Element element3 = element2.addElement(XML_ELEMENT_TERMS_TEXT);
            element3.addAttribute(XML_ELEMENT_TERMS_LANGUAGE, string);
            String string2 = this.terms.get(string);
            if (string2.contains("\n") || string2.contains("\r")) {
                element3.addCDATA(StringEscapeUtils.unescapeHtml((String)string2));
                continue;
            }
            element3.setText(string2);
        }
        if (!this.getCustomValues().getValueMap().isEmpty()) {
            this.getCustomValues().serializeToXml(element.addElement(XML_ELEMENT_VALUES));
        }
    }

    public void setId(String string) {
        this.putValue(XML_ATTRIB_ID, string);
    }

    public void setCompany(CompanyAdressImpl companyAdressImpl) {
        this.company = companyAdressImpl;
    }

    public void setCustomValues(CustomValuesImpl customValuesImpl) {
        this.customValues = customValuesImpl;
    }

    @Deprecated
    public void setTerms(String string) {
        this.setTerms(string, OpenEstateUtils.DEFAULT_LOCALE);
    }

    public void setTerms(String string, Locale locale) {
        this.setTerms(string, locale.getLanguage());
    }

    public void setTerms(String string, String string2) {
        if (string2 == null || string2.trim().length() != 2) {
            throw new IllegalArgumentException("Invalid language!");
        }
        if (string == null || string.trim().length() == 0) {
            if (this.terms.containsKey(string2)) {
                this.terms.remove(string2);
            }
        } else {
            this.terms.put(string2, string);
        }
    }
}

