/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.CustomValueImpl;
import com.openindex.openestate.impl.SerializableXmlElement;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;

public class CustomValuesImpl
extends AbstractImplItem
implements SerializableXmlElement {
    public static final String XML_ELEMENT = "CustomValues";
    public static final String XML_ELEMENT_VALUE = "CustomValue";
    private Map<String, CustomValueImpl> customValues = new TreeMap<String, CustomValueImpl>();

    public CustomValueImpl getCustomValue(String string) {
        return this.hasCustomValue(string) ? this.customValues.get(string) : null;
    }

    public Map<String, CustomValueImpl> getValueMap() {
        return this.customValues;
    }

    public boolean hasCustomValue(String string) {
        return this.customValues.containsKey(string);
    }

    @Override
    public void merge(AbstractImplItem abstractImplItem) {
        if (abstractImplItem instanceof CustomValuesImpl) {
            this.getValueMap().putAll(((CustomValuesImpl)abstractImplItem).getValueMap());
        } else {
            super.merge(abstractImplItem);
        }
    }

    public void putCustomValue(String string, Object object, int n) {
        if (this.hasCustomValue(string)) {
            if (object == null) {
                this.getValueMap().remove(string);
            } else {
                this.getValueMap().get(string).setObject(object, n);
            }
        } else if (object != null) {
            this.getValueMap().put(string, new CustomValueImpl(string, object, n));
        }
    }

    @Override
    public void readFromXml(Document document) throws DocumentException {
        this.readFromXml(document.getRootElement());
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        this.customValues.clear();
        for (Node node : CustomValuesImpl.selectChildElements(element)) {
            if (!XML_ELEMENT_VALUE.equals(node.getName())) continue;
            CustomValueImpl customValueImpl = new CustomValueImpl();
            customValueImpl.readFromXml((Element)node);
            this.customValues.put(customValueImpl.getObjectKey(), customValueImpl);
        }
    }

    @Override
    public void serializeToXml(Document document) throws DocumentException {
        Element element = DocumentFactory.getInstance().createElement(XML_ELEMENT, "http://www.openestate.org/1.0/");
        this.serializeToXml(element);
        document.setRootElement(element);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        for (CustomValueImpl customValueImpl : this.customValues.values()) {
            if (customValueImpl.getObject() == null) continue;
            customValueImpl.serializeToXml(element.addElement(XML_ELEMENT_VALUE));
        }
    }
}

