/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.CustomValuesImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlType;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class EstateAttachmentImpl
extends AbstractImplItem
implements SerializableXmlType {
    private static final Logger LOGGER = Logger.getLogger(EstateAttachmentImpl.class);
    private static final Base64 BASE64 = new Base64();
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final String MIME_BMP = "image/bmp";
    public static final String MIME_GIF = "image/gif";
    public static final String MIME_JPG = "image/jpeg";
    public static final String MIME_PDF = "application/pdf";
    public static final String MIME_PNG = "image/png";
    public static final String TYPE_IMAGE = "IMAGE";
    public static final String TYPE_IMAGE_INNER_VIEW = "IMAGE_INNER_VIEW";
    public static final String TYPE_IMAGE_OUTER_VIEW = "IMAGE_OUTER_VIEW";
    public static final String TYPE_IMAGE_GROUNDPLAN = "IMAGE_GROUNDPLAN";
    public static final String TYPE_IMAGE_MAP = "IMAGE_MAP";
    public static final String TYPE_IMAGE_PANORAMA = "IMAGE_PANORAMA";
    @Deprecated
    private static final String XML_ATTRIB_TITLE = "Title";
    private static final String XML_ATTRIB_MIME_TYPE = "MimeType";
    private static final String XML_ATTRIB_PUBLISHED = "Published";
    private static final String XML_ATTRIB_TYPE = "Type";
    private static final String XML_ELEMENT_TITLE = "Title";
    private static final String XML_ELEMENT_TITLE_TEXT = "Text";
    private static final String XML_ELEMENT_TITLE_LANGUAGE = "Language";
    private static final String XML_ELEMENT_BASE64 = "Base64";
    private static final String XML_ELEMENT_NAME = "Name";
    private static final String XML_ELEMENT_URL = "URL";
    private static final String XML_ELEMENT_VALUES = "CustomValues";
    private Map<String, String> titles;
    private CustomValuesImpl customValues = new CustomValuesImpl();

    public EstateAttachmentImpl() {
        this.titles = new HashMap<String, String>();
    }

    public CustomValuesImpl getCustomValues() {
        return this.customValues;
    }

    public byte[] getFileAsBase64() {
        return (byte[])this.getValue(XML_ELEMENT_BASE64);
    }

    public String getFileAsName() {
        return (String)this.getValue(XML_ELEMENT_NAME);
    }

    public URL getFileAsUrl() {
        return (URL)this.getValue(XML_ELEMENT_URL);
    }

    public String getMimeType() {
        return (String)this.getValue(XML_ATTRIB_MIME_TYPE);
    }

    public String getTitle() {
        return this.getTitle(OpenEstateUtils.DEFAULT_LOCALE);
    }

    public String getTitle(Locale locale) {
        return this.getTitle(locale.getLanguage());
    }

    public String getTitle(String string) {
        if (string != null && this.titles.containsKey(string)) {
            return this.titles.get(string);
        }
        return null;
    }

    public Collection<String> getTitleLanguages() {
        return this.titles.keySet();
    }

    public String getType() {
        return (String)this.getValue(XML_ATTRIB_TYPE);
    }

    public static String[] getTypes() {
        return new String[]{TYPE_IMAGE, TYPE_IMAGE_INNER_VIEW, TYPE_IMAGE_OUTER_VIEW, TYPE_IMAGE_GROUNDPLAN, TYPE_IMAGE_MAP, TYPE_IMAGE_PANORAMA};
    }

    public boolean isBase64() {
        return this.getValue(XML_ELEMENT_BASE64) != null;
    }

    public boolean isName() {
        return this.getValue(XML_ELEMENT_NAME) != null;
    }

    public boolean isPublished() {
        Object object = this.getValue(XML_ATTRIB_PUBLISHED);
        return object != null ? Boolean.TRUE.equals(object) : true;
    }

    public boolean isUrl() {
        return this.getValue(XML_ELEMENT_URL) != null;
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        this.setMimeType(EstateAttachmentImpl.selectAttribute(element, XML_ATTRIB_MIME_TYPE));
        this.setType(EstateAttachmentImpl.selectAttribute(element, XML_ATTRIB_TYPE));
        this.setPublished(EstateAttachmentImpl.selectAttributeAsBoolean(element, XML_ATTRIB_PUBLISHED));
        this.setTitle(EstateAttachmentImpl.selectAttribute(element, "Title"));
        for (Node node : EstateAttachmentImpl.selectChildElements(element)) {
            String string = node.getStringValue();
            if ("Title".equals(node.getName()) && string != null) {
                for (Node node2 : EstateAttachmentImpl.selectChildElements((Element)node)) {
                    if (!XML_ELEMENT_TITLE_TEXT.equals(node2.getName())) continue;
                    String string2 = EstateAttachmentImpl.selectAttribute((Element)node2, XML_ELEMENT_TITLE_LANGUAGE);
                    String string3 = node2.getStringValue();
                    if (string2 == null || string2.length() != 2) continue;
                    if (string3 != null && string3.trim().length() > 0) {
                        this.setTitle(StringEscapeUtils.unescapeHtml((String)string3.trim()), string2);
                        continue;
                    }
                    this.setTitle(null, string2);
                }
                continue;
            }
            if (XML_ELEMENT_BASE64.equals(node.getName()) && string != null) {
                try {
                    this.setFile(BASE64.decode(string.trim().getBytes(US_ASCII.name())));
                    continue;
                }
                catch (Exception exception) {
                    throw new DocumentException("could not encode base64: " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            if (XML_ELEMENT_NAME.equals(node.getName()) && string != null) {
                this.setFile(string.trim());
                continue;
            }
            if (XML_ELEMENT_URL.equals(node.getName()) && string != null) {
                try {
                    this.setFile(new URL(string.trim()));
                }
                catch (MalformedURLException malformedURLException) {
                    this.setFile((String)null);
                    LOGGER.warn((Object)"invalid attachment-url!");
                    LOGGER.warn((Object)("> " + string.toString()));
                    LOGGER.warn((Object)("> " + malformedURLException.getLocalizedMessage()));
                }
                continue;
            }
            if (!XML_ELEMENT_VALUES.equals(node.getName())) continue;
            this.customValues.readFromXml((Element)node);
        }
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        element.addAttribute(XML_ATTRIB_MIME_TYPE, this.getMimeType());
        element.addAttribute(XML_ATTRIB_PUBLISHED, String.valueOf(this.isPublished()));
        if (this.getType() != null) {
            element.addAttribute(XML_ATTRIB_TYPE, this.getType());
        }
        Element element2 = element.addElement("Title");
        for (String string : this.titles.keySet()) {
            Element element3 = element2.addElement(XML_ELEMENT_TITLE_TEXT);
            element3.addAttribute(XML_ELEMENT_TITLE_LANGUAGE, string);
            String string2 = this.titles.get(string);
            if (string2.contains("\n") || string2.contains("\r")) {
                element3.addCDATA(StringEscapeUtils.unescapeHtml((String)string2));
                continue;
            }
            element3.setText(string2);
        }
        if (this.isBase64()) {
            String string;
            Object object = BASE64.encode(this.getFileAsBase64());
            string = US_ASCII.decode(ByteBuffer.wrap((byte[])object)).toString();
            element.addElement(XML_ELEMENT_BASE64).setText(string);
        } else if (this.isName()) {
            element.addElement(XML_ELEMENT_NAME).setText(this.getFileAsName());
        } else if (this.isUrl()) {
            element.addElement(XML_ELEMENT_URL).setText(this.getFileAsUrl().toString());
        }
        if (!this.customValues.getValueMap().isEmpty()) {
            this.customValues.serializeToXml(element.addElement(XML_ELEMENT_VALUES));
        }
    }

    public void setFile(byte[] byArray) {
        this.putValue(XML_ELEMENT_BASE64, byArray);
        this.putValue(XML_ELEMENT_NAME, null);
        this.putValue(XML_ELEMENT_URL, null);
    }

    public void setFile(String string) {
        this.putValue(XML_ELEMENT_BASE64, null);
        this.putValue(XML_ELEMENT_NAME, string);
        this.putValue(XML_ELEMENT_URL, null);
    }

    public void setFile(URL uRL) {
        this.putValue(XML_ELEMENT_BASE64, null);
        this.putValue(XML_ELEMENT_NAME, null);
        this.putValue(XML_ELEMENT_URL, uRL);
    }

    public void setMimeType(String string) {
        this.putValue(XML_ATTRIB_MIME_TYPE, string);
    }

    public void setPublished(Boolean bl) {
        this.putValue(XML_ATTRIB_PUBLISHED, bl != null ? bl : Boolean.TRUE);
    }

    public void setTitle(String string) {
        this.setTitle(string, OpenEstateUtils.DEFAULT_LOCALE);
    }

    public void setTitle(String string, Locale locale) {
        this.setTitle(string, locale.getLanguage());
    }

    public void setTitle(String string, String string2) {
        if (string2 == null || string2.trim().length() != 2) {
            throw new IllegalArgumentException("Invalid language!");
        }
        if (string == null || string.trim().length() == 0) {
            if (this.titles.containsKey(string2)) {
                this.titles.remove(string2);
            }
        } else {
            this.titles.put(string2, string);
        }
    }

    public void setType(String string) {
        if (string == null) {
            this.putValue(XML_ATTRIB_TYPE, null);
            return;
        }
        for (String string2 : EstateAttachmentImpl.getTypes()) {
            if (!string2.equals(string)) continue;
            this.putValue(XML_ATTRIB_TYPE, string);
            return;
        }
        this.putValue(XML_ATTRIB_TYPE, null);
    }
}

