/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.CustomValuesImpl;
import com.openindex.openestate.impl.EstateAdressImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.ValueImpl;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.tree.DefaultElement;

public class EstateImpl
extends AbstractImplItem
implements SerializableXmlElement {
    private static final Logger LOGGER = Logger.getLogger(EstateImpl.class);
    public static final String XML_ATTRIB_ID = "Id";
    public static final String XML_ATTRIB_CONTACT_ID = "ContactId";
    public static final String XML_ATTRIB_CURRENCY = "Currency";
    public static final String XML_ATTRIB_HIDDEN_PRICES = "HiddenPrices";
    public static final String XML_ATTRIB_LANGUAGES = "Languages";
    public static final String XML_ATTRIB_PUBLIC_ID = "PublicId";
    public static final String XML_ATTRIB_PUBLISH_BEGIN = "PublishBegin";
    public static final String XML_ATTRIB_PUBLISH_END = "PublishEnd";
    @Deprecated
    private static final String XML_ATTRIB_TITLE = "Title";
    public static final String XML_ELEMENT = "Estate";
    public static final String XML_ELEMENT_ADRESS = "Adress";
    public static final String XML_ELEMENT_TITLE = "Title";
    public static final String XML_ELEMENT_TITLE_TEXT = "Text";
    public static final String XML_ELEMENT_TITLE_LANGUAGE = "Language";
    public static final String XML_ELEMENT_ATTACHMENT = "Attachment";
    public static final String XML_ELEMENT_ACTION = "Action";
    public static final String XML_ELEMENT_ATTRIBUTES = "Attributes";
    public static final String XML_ELEMENT_VALUES = "CustomValues";
    private String action = null;
    private OpenEstateType type = null;
    private EstateAdressImpl adress = new EstateAdressImpl();
    private Map<String, ValueImpl> attributes = new HashMap<String, ValueImpl>();
    private Map<String, String> titles;
    private List<String> languages;
    private List<EstateAttachmentImpl> attachments = new ArrayList<EstateAttachmentImpl>();
    private CustomValuesImpl customValues = new CustomValuesImpl();

    public EstateImpl() {
        this.titles = new HashMap<String, String>();
        this.languages = new ArrayList<String>();
    }

    public EstateImpl(Document document) throws DocumentException {
        this();
        this.build(document);
    }

    private void build(Document document) throws DocumentException {
        this.readFromXml(document);
    }

    public String getAction() {
        return this.action;
    }

    public EstateAdressImpl getAdress() {
        return this.adress;
    }

    public List<EstateAttachmentImpl> getAttachments() {
        return this.attachments;
    }

    public ValueImpl getAttribute(String string) {
        return this.attributes.containsKey(string) ? this.attributes.get(string) : null;
    }

    public ValueImpl getAttribute(String string, String string2) {
        return this.getAttribute(string + "." + string2);
    }

    public Set<String> getAttributeKeys() {
        return this.attributes.keySet();
    }

    public Collection<ValueImpl> getAttributes() {
        return this.attributes.values();
    }

    public String getContactId() {
        return (String)this.getValue(XML_ATTRIB_CONTACT_ID);
    }

    public Currency getCurrency() {
        return (Currency)this.getValue(XML_ATTRIB_CURRENCY);
    }

    public CustomValuesImpl getCustomValues() {
        return this.customValues;
    }

    public String getId() {
        return (String)this.getValue(XML_ATTRIB_ID);
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public String getPublicId() {
        return (String)this.getValue(XML_ATTRIB_PUBLIC_ID);
    }

    public Date getPublishBegin() {
        return (Date)this.getValue(XML_ATTRIB_PUBLISH_BEGIN);
    }

    public Date getPublishEnd() {
        return (Date)this.getValue(XML_ATTRIB_PUBLISH_END);
    }

    public String getTitle() {
        return this.getTitle(OpenEstateUtils.DEFAULT_LOCALE);
    }

    public String getTitle(Locale locale) {
        return this.getTitle(locale.getLanguage());
    }

    public String getTitle(String string) {
        if (string != null && this.titles.containsKey(string)) {
            return this.titles.get(string);
        }
        return null;
    }

    public String[] getTitleLanguages() {
        return this.titles.keySet().toArray(new String[this.titles.size()]);
    }

    public OpenEstateType getType() {
        return this.type;
    }

    public boolean hasAttribute(ValueImpl valueImpl) {
        return this.hasAttribute(valueImpl.getGroupName() + "." + valueImpl.getAttribName());
    }

    public boolean hasAttribute(String string, String string2) {
        return this.hasAttribute(string + "." + string2);
    }

    public boolean hasAttribute(String string) {
        return this.attributes.containsKey(string);
    }

    public boolean isAdressPublished() {
        return this.getAdress().isAdressPublished();
    }

    public boolean isHiddenPrices() {
        return (Boolean)this.getValue(XML_ATTRIB_HIDDEN_PRICES, Boolean.FALSE);
    }

    @Override
    public void merge(AbstractImplItem abstractImplItem) {
        super.merge(abstractImplItem);
        if (abstractImplItem instanceof EstateImpl) {
            EstateImpl estateImpl = (EstateImpl)abstractImplItem;
            this.action = estateImpl.getAction();
            this.titles.putAll(estateImpl.titles);
            this.languages.addAll(estateImpl.languages);
            this.type = estateImpl.getType();
            this.adress.merge(estateImpl.getAdress());
            this.attributes.putAll(estateImpl.attributes);
            this.attachments.addAll(estateImpl.getAttachments());
            this.customValues.merge(estateImpl.getCustomValues());
        }
    }

    public void putAttribute(OpenEstateAttrib openEstateAttrib, ValueImpl valueImpl) {
        this.putAttribute(openEstateAttrib.getKey(), valueImpl);
    }

    public void putAttribute(String string, ValueImpl valueImpl) {
        if (valueImpl == null) {
            if (this.attributes.containsKey(string)) {
                this.attributes.remove(string);
            }
        } else {
            this.attributes.put(string, valueImpl);
        }
    }

    @Override
    public void readFromXml(Document document) throws DocumentException {
        this.readFromXml(document.getRootElement());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readFromXml(Element element) throws DocumentException {
        void var8_15;
        Object object;
        Object object2;
        Node node3;
        Object object5;
        String[] stringArray;
        this.setId(EstateImpl.selectAttribute(element, XML_ATTRIB_ID, null));
        this.setPublicId(EstateImpl.selectAttribute(element, XML_ATTRIB_PUBLIC_ID, null));
        this.setContactId(EstateImpl.selectAttribute(element, XML_ATTRIB_CONTACT_ID, ""));
        this.setCurrency(EstateImpl.selectAttributeAsCurrency(element, XML_ATTRIB_CURRENCY));
        this.setPublishBegin(EstateImpl.selectAttributeAsDate(element, XML_ATTRIB_PUBLISH_BEGIN));
        this.setPublishEnd(EstateImpl.selectAttributeAsDate(element, XML_ATTRIB_PUBLISH_END));
        this.setHiddenPrices(EstateImpl.selectAttributeAsBoolean(element, XML_ATTRIB_HIDDEN_PRICES, Boolean.FALSE));
        this.getLanguages().clear();
        String string = EstateImpl.selectAttribute(element, XML_ATTRIB_LANGUAGES);
        boolean bl = false;
        if (string != null) {
            bl = true;
            stringArray = string.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                object5 = stringArray[i];
                String object42 = ((String)object5).trim();
                if (object42.length() != 2) continue;
                this.getLanguages().add(object42.toLowerCase());
            }
        }
        if ((stringArray = EstateImpl.selectAttribute(element, "Title", "")) != null && stringArray.trim().length() > 0) {
            this.setTitle((String)stringArray);
        }
        this.attachments.clear();
        DefaultElement defaultElement = null;
        OpenEstateType openEstateType = null;
        for (Node node2 : EstateImpl.selectChildElements(element)) {
            if (XML_ELEMENT_ADRESS.equals(node2.getName())) {
                this.getAdress().readFromXml((Element)node2);
                continue;
            }
            if ("Title".equals(node2.getName())) {
                for (Node node3 : EstateImpl.selectChildElements((Element)node2)) {
                    if (!XML_ELEMENT_TITLE_TEXT.equals(node3.getName())) continue;
                    object2 = EstateImpl.selectAttribute((Element)node3, XML_ELEMENT_TITLE_LANGUAGE, "").trim().toLowerCase();
                    object = node3.getStringValue();
                    if (object2 == null || ((String)object2).length() != 2) continue;
                    if (object != null && ((String)object).trim().length() > 0) {
                        this.setTitle(StringEscapeUtils.unescapeHtml((String)((String)object).trim()), (String)object2);
                    } else {
                        this.setTitle(null, (String)object2);
                    }
                    if (bl) continue;
                    this.getLanguages().add((String)object2);
                }
                continue;
            }
            if (XML_ELEMENT_ATTACHMENT.equals(node2.getName())) {
                EstateAttachmentImpl estateAttachmentImpl = new EstateAttachmentImpl();
                estateAttachmentImpl.readFromXml((Element)node2);
                this.attachments.add(estateAttachmentImpl);
                continue;
            }
            if (XML_ELEMENT_VALUES.equals(node2.getName())) {
                this.customValues.readFromXml((Element)node2);
                continue;
            }
            String string2 = OpenEstateUtils.makeUnCamelCase(node2.getName());
            try {
                defaultElement = (DefaultElement)node2;
                openEstateType = OpenEstateType.newInstance(string2);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"invalid estate-type!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
                throw new DocumentException(exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if (defaultElement == null) {
            throw new DocumentException("estate-type-node not found!");
        }
        if (openEstateType == null) {
            throw new DocumentException("estate-type not found!");
        }
        object5 = new ArrayList<Node>();
        for (Node node4 : EstateImpl.selectChildElements(defaultElement)) {
            if (XML_ELEMENT_ACTION.equals(node4.getName())) {
                node3 = node4.selectSingleNode("*");
                object2 = node3.getName().toUpperCase();
                this.setType(openEstateType, (String)object2);
                ((ArrayList)object5).addAll(EstateImpl.selectChildElements((Element)node3));
                continue;
            }
            if (XML_ELEMENT_ATTRIBUTES.equals(node4.getName())) {
                ((ArrayList)object5).addAll(EstateImpl.selectChildElements((Element)node4));
                continue;
            }
            throw new DocumentException("unknown tag '" + node4.getName() + "'");
        }
        Object var8_14 = null;
        Iterator iterator = ((ArrayList)object5).iterator();
        while (iterator.hasNext()) {
            node3 = (Node)iterator.next();
            object2 = (DefaultElement)node3;
            object = object2.getName().split("_");
            if (object == null || ((String[])object).length <= 1) continue;
            String string3 = OpenEstateUtils.makeUnCamelCase(object[0]);
            String string4 = OpenEstateUtils.makeUnCamelCase(object[1]);
            try {
                Object object3;
                if ("UMFELD".equals(string3) && "LAGE_GEBIET".equals(string4)) {
                    object3 = element.getStringValue();
                    if ("A-LAGE".equalsIgnoreCase((String)object3)) {
                        String string5 = "A_LAGE";
                    } else if ("B-LAGE".equalsIgnoreCase((String)object3)) {
                        String string6 = "B_LAGE";
                    } else if ("EINKAUFSZENTRUM".equalsIgnoreCase((String)object3)) {
                        String string7 = "EINKAUFSZENTRUM";
                    } else if ("FUSSGAENGERZONE".equalsIgnoreCase((String)object3)) {
                        String string8 = "FUSSGAENGERZONE";
                    }
                }
                object3 = null;
                object3 = "VERWALTUNG".equals(string3) && "BARRIEREFREI".equals(string4) ? this.getType().getAttrib("AUSSTATTUNG", "BARRIEREFREI") : ("VERWALTUNG".equals(string3) && "LAUFZEIT_PACHT".equals(string4) ? this.getType().getAttrib("VERWALTUNG", "ERBPACHT_DAUER") : ("VERWALTUNG".equals(string3) && "ENERGIEPASS_ART".equals(string4) ? this.getType().getAttrib("ENERGIEPASS", "ART") : ("VERWALTUNG".equals(string3) && "ENERGIEPASS_GUELTIG_BIS".equals(string4) ? this.getType().getAttrib("ENERGIEPASS", "ABLAUF_DATUM") : ("VERWALTUNG".equals(string3) && "ENERGIEPASS_VERBRAUCH_WERT".equals(string4) ? this.getType().getAttrib("ENERGIEPASS", "VERBRAUCH_GESAMT") : ("VERWALTUNG".equals(string3) && "ENERGIEPASS_BEDARF_WERT".equals(string4) ? this.getType().getAttrib("ENERGIEPASS", "BEDARF_GESAMT") : ("VERWALTUNG".equals(string3) && "ENERGIEPASS_INKL_WARMWASSER".equals(string4) ? this.getType().getAttrib("ENERGIEPASS", "VERBRAUCH_INKL_WARMWASSER") : ("VERWALTUNG".equals(string3) && "ENERGIEPASS_HWB".equals(string4) ? this.getType().getAttrib("ENERGIEPASS", "AUSTRIA_HWB") : ("VERWALTUNG".equals(string3) && "ENERGIEPASS_FGEE".equals(string4) ? this.getType().getAttrib("ENERGIEPASS", "AUSTRIA_FGEE") : ("VERWALTUNG".equals(string3) && "ENERGIEKLASSE".equals(string4) ? this.getType().getAttrib("ENERGIEPASS", "KLASSE") : ("VERWALTUNG".equals(string3) && "ENERGIEVERBRAUCH".equals(string4) ? this.getType().getAttrib("ENERGIEPASS", "VERBRAUCH_GESAMT") : ("VERWALTUNG".equals(string3) && "ENERGIEVERBRAUCH_ZERTIFIZIERT".equals(string4) ? this.getType().getAttrib("ENERGIEPASS", "VORHANDEN") : this.getType().getAttrib(string3, string4))))))))))));
                if (object3 == null) {
                    LOGGER.warn((Object)("Unknown attribute '" + string4 + "' in group '" + string3 + "'!"));
                    continue;
                }
                if (!this.getType().hasAttrib(((OpenEstateAttrib)object3).getGroup(), ((OpenEstateAttrib)object3).getName())) continue;
                ValueImpl valueImpl = ((OpenEstateAttrib)object3).createValue();
                valueImpl.readFromXml((Element)object2);
                this.putAttribute(((OpenEstateAttrib)object3).getKey(), valueImpl);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Invalid estate attribute!");
                LOGGER.warn((Object)("> attribute: " + string3 + " / " + string4));
                if (this.getType() != null) {
                    LOGGER.warn((Object)("> estate type: " + this.getType().getName()));
                }
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
            }
        }
        if (var8_15 != null && var8_15.trim().length() > 0) {
            if (!this.hasAttribute("UMFELD", "LAGE_GEWERBE")) {
                OpenEstateAttrib openEstateAttrib = this.getType().getAttrib("UMFELD", "LAGE_GEWERBE");
                this.putAttribute(openEstateAttrib, openEstateAttrib.createValue());
            }
            this.getAttribute("UMFELD", "LAGE_GEWERBE").setValue(var8_15.trim());
        }
    }

    @Override
    public void serializeToXml(Document document) throws DocumentException {
        Element element = DocumentFactory.getInstance().createElement(XML_ELEMENT, "http://www.openestate.org/1.0/");
        this.serializeToXml(element);
        document.setRootElement(element);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        String string;
        Object object;
        Element element2;
        String string22;
        DateFormat dateFormat = OpenEstateUtils.getXsdDateFormat();
        element.addAttribute(XML_ATTRIB_ID, this.getId());
        element.addAttribute(XML_ATTRIB_HIDDEN_PRICES, Boolean.valueOf(this.isHiddenPrices()).toString());
        if (this.getPublicId() != null) {
            element.addAttribute(XML_ATTRIB_PUBLIC_ID, this.getPublicId());
        }
        if (this.getContactId() != null) {
            element.addAttribute(XML_ATTRIB_CONTACT_ID, this.getContactId());
        }
        if (this.getCurrency() != null) {
            element.addAttribute(XML_ATTRIB_CURRENCY, this.getCurrency().getCurrencyCode());
        }
        if (this.getPublishBegin() != null) {
            element.addAttribute(XML_ATTRIB_PUBLISH_BEGIN, dateFormat.format(this.getPublishBegin()));
        }
        if (this.getPublishEnd() != null) {
            element.addAttribute(XML_ATTRIB_PUBLISH_END, dateFormat.format(this.getPublishEnd()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String object22 : this.getLanguages()) {
            if (object22 == null || (string22 = object22.trim().toLowerCase()).length() != 2) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string22);
        }
        element.addAttribute(XML_ATTRIB_LANGUAGES, stringBuilder.toString());
        this.getAdress().serializeToXml(element.addElement(XML_ELEMENT_ADRESS));
        Element element3 = element.addElement("Title");
        for (String string22 : this.titles.keySet()) {
            element2 = element3.addElement(XML_ELEMENT_TITLE_TEXT);
            element2.addAttribute(XML_ELEMENT_TITLE_LANGUAGE, string22);
            object = this.titles.get(string22);
            if (((String)object).contains("\n") || ((String)object).contains("\r")) {
                element2.addCDATA(StringEscapeUtils.unescapeHtml((String)object));
                continue;
            }
            element2.setText((String)object);
        }
        Element element4 = element.addElement(OpenEstateUtils.makeCamelCase(this.getType().getName()));
        string22 = element4.addElement(XML_ELEMENT_ACTION);
        element2 = string22.addElement(OpenEstateUtils.makeCamelCase(this.getAction()));
        object = new TreeMap();
        for (OpenEstateAttrib openEstateAttrib : this.type.getAttribsByAction(this.getAction())) {
            if (!this.attributes.containsKey(openEstateAttrib.getKey())) continue;
            string = OpenEstateUtils.makeCamelCase(openEstateAttrib.getGroup()) + "_" + OpenEstateUtils.makeCamelCase(openEstateAttrib.getName());
            object.put(string, openEstateAttrib.getKey());
        }
        for (Map.Entry estateAttachmentImpl : object.entrySet()) {
            this.attributes.get(estateAttachmentImpl.getValue()).serializeToXml(element2.addElement((String)estateAttachmentImpl.getKey()));
        }
        element2 = element4.addElement(XML_ELEMENT_ATTRIBUTES);
        object.clear();
        for (OpenEstateAttrib openEstateAttrib : this.type.getAttribs()) {
            if (!this.attributes.containsKey(openEstateAttrib.getKey())) continue;
            string = OpenEstateUtils.makeCamelCase(openEstateAttrib.getGroup()) + "_" + OpenEstateUtils.makeCamelCase(openEstateAttrib.getName());
            object.put(string, openEstateAttrib.getKey());
        }
        for (Map.Entry entry : object.entrySet()) {
            this.attributes.get(entry.getValue()).serializeToXml(element2.addElement((String)entry.getKey()));
        }
        for (EstateAttachmentImpl estateAttachmentImpl : this.attachments) {
            estateAttachmentImpl.serializeToXml(element.addElement(XML_ELEMENT_ATTACHMENT));
        }
        if (!this.customValues.getValueMap().isEmpty()) {
            this.customValues.serializeToXml(element.addElement(XML_ELEMENT_VALUES));
        }
    }

    public void setAdressPublished(boolean bl) {
        this.getAdress().setAdressPublished(bl);
    }

    public void setContactId(String string) {
        this.putValue(XML_ATTRIB_CONTACT_ID, string);
    }

    public void setCurrency(Currency currency) {
        this.putValue(XML_ATTRIB_CURRENCY, currency);
    }

    public void setCustomValues(CustomValuesImpl customValuesImpl) {
        this.customValues = customValuesImpl;
    }

    public void setHiddenPrices(Boolean bl) {
        this.putValue(XML_ATTRIB_HIDDEN_PRICES, bl);
    }

    public void setId(String string) {
        this.putValue(XML_ATTRIB_ID, string);
    }

    public void setPublicId(String string) {
        this.putValue(XML_ATTRIB_PUBLIC_ID, string);
    }

    public void setPublishBegin(Date date) {
        this.putValue(XML_ATTRIB_PUBLISH_BEGIN, date);
    }

    public void setPublishEnd(Date date) {
        this.putValue(XML_ATTRIB_PUBLISH_END, date);
    }

    public void setTitle(String string) {
        this.setTitle(string, OpenEstateUtils.DEFAULT_LOCALE);
    }

    public void setTitle(String string, Locale locale) {
        this.setTitle(string, locale.getLanguage());
    }

    public void setTitle(String string, String string2) {
        if (string2 == null || string2.trim().length() != 2) {
            throw new IllegalArgumentException("Invalid language!");
        }
        if (string == null || string.trim().length() == 0) {
            if (this.titles.containsKey(string2)) {
                this.titles.remove(string2);
            }
        } else {
            this.titles.put(string2, string);
        }
    }

    public void setType(String string, String string2) throws OpenEstateException {
        this.setType(OpenEstateType.newInstance(string), string2);
    }

    public void setType(OpenEstateType openEstateType, String string) {
        if (!openEstateType.hasAction(string)) {
            throw new IllegalArgumentException("estate-action '" + string + "' is not supported by estate-type '" + openEstateType.getName() + "'!");
        }
        this.type = openEstateType;
        this.action = string;
        for (String object : this.attributes.keySet().toArray(new String[this.attributes.size()])) {
            if (openEstateType.hasAttrib(object, string)) continue;
            this.attributes.remove(object);
        }
        for (OpenEstateAttrib openEstateAttrib : this.type.getAttribsByAction(this.getAction())) {
            if (!this.type.isAttribRequired(openEstateAttrib, this.getAction()) || this.attributes.containsKey(openEstateAttrib.getKey())) continue;
            this.putAttribute(openEstateAttrib, openEstateAttrib.createValue());
        }
        for (OpenEstateAttrib openEstateAttrib : this.type.getAttribs()) {
            if (!this.type.isAttribRequired(openEstateAttrib, this.getAction()) || this.attributes.containsKey(openEstateAttrib.getKey())) continue;
            this.putAttribute(openEstateAttrib, openEstateAttrib.createValue());
        }
    }
}

