/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.GeoCountryImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;

public class GeoImpl
extends AbstractImplItem
implements SerializableXmlElement {
    public static final String XML_ATTRIB_BUILDTIME = "BuildTime";
    public static final String XML_ATTRIB_NAME = "Name";
    public static final String XML_ATTRIB_PROVIDER = "Provider";
    public static final String XML_ELEMENT = "Geo";
    private static final String XML_ELEMENT_COUNTRY = "Country";
    private List<GeoCountryImpl> countries = new ArrayList<GeoCountryImpl>();

    public Date getBuildTime() {
        return (Date)this.getValue(XML_ATTRIB_BUILDTIME);
    }

    public List<GeoCountryImpl> getCountries() {
        return this.countries;
    }

    public String getName() {
        return (String)this.getValue(XML_ATTRIB_NAME);
    }

    public String getProvider() {
        return (String)this.getValue(XML_ATTRIB_PROVIDER);
    }

    @Override
    public void readFromXml(Document document) throws DocumentException {
        this.readFromXml(document.getRootElement());
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        this.setBuildTime(GeoImpl.selectAttributeAsDateTime(element, XML_ATTRIB_BUILDTIME));
        this.setName(GeoImpl.selectAttribute(element, XML_ATTRIB_NAME));
        this.setProvider(GeoImpl.selectAttribute(element, XML_ATTRIB_PROVIDER));
        for (Node node : GeoImpl.selectChildElements(element)) {
            if (!XML_ELEMENT_COUNTRY.equals(node.getName())) continue;
            GeoCountryImpl geoCountryImpl = new GeoCountryImpl();
            geoCountryImpl.readFromXml((Element)node);
            this.countries.add(geoCountryImpl);
        }
    }

    public void readFromXmlNonRecursive(Document document) throws DocumentException {
        this.readFromXmlNonRecursive(document.getRootElement());
    }

    public void readFromXmlNonRecursive(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        this.setBuildTime(GeoImpl.selectAttributeAsDateTime(element, XML_ATTRIB_BUILDTIME));
        this.setName(GeoImpl.selectAttribute(element, XML_ATTRIB_NAME));
        this.setProvider(GeoImpl.selectAttribute(element, XML_ATTRIB_PROVIDER));
    }

    @Override
    public void serializeToXml(Document document) throws DocumentException {
        Element element = DocumentFactory.getInstance().createElement(XML_ELEMENT, "http://www.openestate.org/1.0/");
        this.serializeToXml(element);
        document.setRootElement(element);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        if (this.getBuildTime() != null) {
            element.addAttribute(XML_ATTRIB_BUILDTIME, OpenEstateUtils.getXsdDateTimeFormat().format(this.getBuildTime()));
        }
        if (this.getName() != null) {
            element.addAttribute(XML_ATTRIB_NAME, this.getName());
        }
        if (this.getProvider() != null) {
            element.addAttribute(XML_ATTRIB_PROVIDER, this.getProvider());
        }
        for (GeoCountryImpl geoCountryImpl : this.getCountries()) {
            geoCountryImpl.serializeToXml(element.addElement(XML_ELEMENT_COUNTRY));
        }
    }

    public void setBuildTime(Date date) {
        this.putValue(XML_ATTRIB_BUILDTIME, date);
    }

    public void setName(String string) {
        this.putValue(XML_ATTRIB_NAME, string);
    }

    public void setProvider(String string) {
        this.putValue(XML_ATTRIB_PROVIDER, string);
    }
}

