/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class OpenEstateConverter {
    private static final Logger LOGGER = Logger.getLogger(OpenEstateConverter.class);
    private Map<String, String> errorMap = new TreeMap<String, String>();
    private Locale openEstateLanguage = OpenEstateUtils.DEFAULT_LOCALE;
    private String xmlLineSeparator = "<br/>";

    protected OpenEstateConverter() {
    }

    public Map<String, String> getErrorMap() {
        return this.errorMap;
    }

    public Locale getOpenEstateLanguage() {
        return this.openEstateLanguage;
    }

    public Object getEstateValue(String string, String string2, EstateImpl estateImpl) {
        try {
            String string3 = string + "." + string2;
            return estateImpl.hasAttribute(string3) ? estateImpl.getAttribute(string3).getValueObject(this.getOpenEstateLanguage()) : null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public BigDecimal getEstateValueAsBigDecimal(String string, String string2, EstateImpl estateImpl) {
        try {
            Object object = this.getEstateValue(string, string2, estateImpl);
            if (object instanceof BigDecimal) {
                return (BigDecimal)object;
            }
            if (object instanceof Number) {
                return new BigDecimal(((Number)object).toString());
            }
            if (object instanceof String) {
                return ((String)object).length() > 0 ? new BigDecimal((String)object) : null;
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read bigdecimal attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public BigInteger getEstateValueAsBigInteger(String string, String string2, EstateImpl estateImpl) {
        try {
            Object object = this.getEstateValue(string, string2, estateImpl);
            if (object instanceof BigInteger) {
                return (BigInteger)object;
            }
            if (object instanceof Number) {
                return BigInteger.valueOf(((Number)object).longValue());
            }
            if (object instanceof String) {
                return ((String)object).length() > 0 ? BigInteger.valueOf(Double.valueOf((String)object).longValue()) : null;
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read biginteger attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public Boolean getEstateValueAsBoolean(String string, String string2, EstateImpl estateImpl) {
        try {
            Object object = this.getEstateValue(string, string2, estateImpl);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object != null) {
                return Boolean.valueOf(object.toString());
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read boolean attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public Calendar getEstateValueAsCalendar(String string, String string2, EstateImpl estateImpl) {
        try {
            Object object = this.getEstateValue(string, string2, estateImpl);
            if (object instanceof Calendar) {
                return (Calendar)object;
            }
            if (object instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)object);
                return calendar;
            }
            if (object instanceof Number) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(((Number)object).longValue());
                return calendar;
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read calendar attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public Date getEstateValueAsDate(String string, String string2, EstateImpl estateImpl) {
        try {
            Object object = this.getEstateValue(string, string2, estateImpl);
            if (object instanceof Date) {
                return (Date)object;
            }
            if (object instanceof Calendar) {
                return ((Calendar)object).getTime();
            }
            if (object instanceof Number) {
                Date date = new Date();
                date.setTime(((Number)object).longValue());
                return date;
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read date attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public Double getEstateValueAsDouble(String string, String string2, EstateImpl estateImpl) {
        try {
            Object object = this.getEstateValue(string, string2, estateImpl);
            if (object instanceof Double) {
                return (Double)object;
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            if (object instanceof String) {
                return ((String)object).length() > 0 ? Double.valueOf((String)object) : null;
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read double attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public Float getEstateValueAsFloat(String string, String string2, EstateImpl estateImpl) {
        try {
            Object object = this.getEstateValue(string, string2, estateImpl);
            if (object instanceof Float) {
                return (Float)object;
            }
            if (object instanceof Number) {
                return Float.valueOf(((Number)object).floatValue());
            }
            if (object instanceof String) {
                return ((String)object).length() > 0 ? Float.valueOf((String)object) : null;
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read float attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public Integer getEstateValueAsInteger(String string, String string2, EstateImpl estateImpl) {
        try {
            Object object = this.getEstateValue(string, string2, estateImpl);
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            if (object instanceof String) {
                return ((String)object).length() > 0 ? Integer.valueOf(Float.valueOf((String)object).intValue()) : null;
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read integer attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public List<String> getEstateValueAsList(String string, String string2, EstateImpl estateImpl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Object object = this.getEstateValue(string, string2, estateImpl);
            if (object instanceof String) {
                arrayList.add(OpenEstateUtils.serializeString((String)object, this.getXmlLineSeparator()));
            } else if (object instanceof String[]) {
                String[] stringArray;
                for (String string3 : stringArray = (String[])object) {
                    arrayList.add(OpenEstateUtils.serializeString(string3, this.getXmlLineSeparator()));
                }
            } else if (object != null) {
                arrayList.add(OpenEstateUtils.serializeString(object.toString()));
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read list attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        return arrayList;
    }

    public Long getEstateValueAsLong(String string, String string2, EstateImpl estateImpl) {
        try {
            Object object = this.getEstateValue(string, string2, estateImpl);
            if (object instanceof Long) {
                return (Long)object;
            }
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
            if (object instanceof String) {
                return ((String)object).length() > 0 ? Long.valueOf((String)object) : null;
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read long attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public String getEstateValueAsNonEmptyString(String string, String string2, EstateImpl estateImpl) {
        String string3 = this.getEstateValueAsString(string, string2, estateImpl);
        return StringUtils.trimToNull((String)string3);
    }

    public String getEstateValueAsString(String string, String string2, EstateImpl estateImpl) {
        try {
            Object object = this.getEstateValue(string, string2, estateImpl);
            if (object instanceof String) {
                return OpenEstateUtils.serializeString((String)object, this.getXmlLineSeparator());
            }
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                return stringArray.length > 0 ? OpenEstateUtils.serializeString(stringArray[0], this.getXmlLineSeparator()) : null;
            }
            if (object != null) {
                return OpenEstateUtils.serializeString(object.toString());
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read string attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public String getFormattedEstateValue(String string, String string2, EstateImpl estateImpl) {
        try {
            String string3 = string + "." + string2;
            String string4 = estateImpl.hasAttribute(string3) ? estateImpl.getAttribute(string3).writeValue(this.getOpenEstateLanguage(), estateImpl.getCurrency()) : null;
            return !StringUtils.isEmpty(string4) ? string4 : null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public Number getNumber(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        try {
            return Double.valueOf(string.trim());
        }
        catch (Exception exception) {
            try {
                return NumberFormat.getNumberInstance().parse(string.trim());
            }
            catch (Exception exception2) {
                LOGGER.warn((Object)"Zahlenwert konnte nicht ermittelt werden!");
                LOGGER.warn((Object)("> " + string));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
                LOGGER.warn((Object)("> " + exception2.getLocalizedMessage()));
                return null;
            }
        }
    }

    public String getXmlLineSeparator() {
        return this.xmlLineSeparator;
    }

    public Boolean hasEstateValue(String string, String string2, Object object, EstateImpl estateImpl) {
        Object object2 = this.getEstateValue(string, string2, estateImpl);
        if (object2 == null || object == null) {
            return null;
        }
        if (object2 instanceof String[]) {
            String[] stringArray;
            for (String string3 : stringArray = (String[])object2) {
                if (!string3.equals(object)) continue;
                return true;
            }
            return false;
        }
        return object2.equals(object);
    }

    public void putErrors(String string, List<String> list) {
        LOGGER.info((Object)("logged errors for estate #" + string));
        for (String charSequence2 : list) {
            LOGGER.info((Object)("> " + charSequence2));
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(++n).append(". ").append(string2);
        }
        this.getErrorMap().put(string, stringBuilder.toString());
    }

    public void putEstateValue(String string, String string2, Object object, EstateImpl estateImpl) {
        this.putEstateValue(string, string2, object, estateImpl, this.getOpenEstateLanguage());
    }

    public void putEstateValue(String string, String string2, Object object, EstateImpl estateImpl, Locale locale) {
        Object object2 = null;
        object2 = object instanceof BigDecimal ? Float.valueOf(((BigDecimal)object).floatValue()) : (object instanceof BigInteger ? Long.valueOf(((BigInteger)object).longValue()) : (object instanceof Calendar ? ((Calendar)object).getTime() : object));
        String string3 = string + "." + string2;
        OpenEstateAttrib openEstateAttrib = estateImpl.getType().getAttrib(string, string2);
        if (openEstateAttrib == null) {
            return;
        }
        if (!openEstateAttrib.isComplex()) {
            if (estateImpl.hasAttribute(string3)) {
                if (object2 == null) {
                    estateImpl.getAttributes().remove(estateImpl.getAttribute(string3));
                } else {
                    estateImpl.getAttribute(string3).setValue(object2, locale);
                }
            } else {
                if (object2 == null) {
                    return;
                }
                ValueImpl valueImpl = openEstateAttrib.createValue(null);
                valueImpl.setValue(object2, locale);
                estateImpl.putAttribute(string3, valueImpl);
            }
        } else if (openEstateAttrib instanceof ComplexEnumAttrib) {
            if (object2 == null) {
                return;
            }
            String[] stringArray = ((ComplexEnumAttrib)openEstateAttrib).getOptions();
            List<String> list = Arrays.asList(stringArray);
            if (!list.contains(object2.toString())) {
                LOGGER.warn((Object)"unsupported value!");
                LOGGER.warn((Object)("> " + string + "." + string2));
                LOGGER.warn((Object)("> " + object2));
                return;
            }
            if (estateImpl.hasAttribute(string3)) {
                String[] stringArray2 = (String[])estateImpl.getAttribute(string3).getValueObject();
                ArrayList<String> arrayList = new ArrayList<String>();
                if (stringArray2 != null && stringArray2.length > 0) {
                    arrayList.addAll(Arrays.asList(stringArray2));
                }
                if (!arrayList.contains(object2.toString())) {
                    arrayList.add(object2.toString());
                }
                estateImpl.getAttribute(string3).setValue((Object)arrayList.toArray(new String[arrayList.size()]), locale);
            } else {
                ValueImpl valueImpl = openEstateAttrib.createValue();
                valueImpl.setValue((Object)new String[]{(String)object2}, locale);
                estateImpl.putAttribute(string3, valueImpl);
            }
        }
    }

    public void setOpenEstateLanguage(Locale locale) {
        this.openEstateLanguage = locale;
    }

    public void setXmlLineSeparator(String string) {
        if (string == null) {
            throw new NullPointerException("line-separator may not be null!");
        }
        this.xmlLineSeparator = string;
    }
}

