/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public abstract class OpenEstateType {
    private static final Logger LOGGER = Logger.getLogger(OpenEstateType.class);
    private final List<String> typeActions = new ArrayList<String>();
    private final Map<String, List<String>> typeAttribs = new LinkedHashMap<String, List<String>>();
    private final List<String> typeAttribsGeneral = new ArrayList<String>();
    private final Map<String, Boolean> typeAttribsGeneralRequired = new LinkedHashMap<String, Boolean>();
    private final Map<String, List<String>> typeActionAttribs = new LinkedHashMap<String, List<String>>();
    private final String typeName;
    private final String typeParent;
    private final String[] typeChildren;
    private static Map<String, OpenEstateType> TYPES;

    protected OpenEstateType(String string, String string2, String[] stringArray) {
        OpenEstateUtils.init();
        this.typeName = string;
        this.typeParent = string2;
        this.typeChildren = stringArray;
    }

    public final String[] getActions() {
        return this.typeActions != null ? this.typeActions.toArray(new String[this.typeActions.size()]) : new String[]{};
    }

    public final String[] getAttribGroups() {
        return this.typeAttribs != null ? this.typeAttribs.keySet().toArray(new String[this.typeAttribs.size()]) : new String[]{};
    }

    public final OpenEstateAttrib getAttrib(String string, String string2) {
        return this.hasAttrib(string, string2) ? OpenEstateUtils.getAvailableAttribute(string + "." + string2) : null;
    }

    public final String[] getAttribNames(String string) {
        return this.hasAttribGroup(string) ? this.typeAttribs.get(string).toArray(new String[this.typeAttribs.get(string).size()]) : new String[]{};
    }

    public final OpenEstateAttrib[] getAttribs() {
        return this.getAttribs(null);
    }

    public final OpenEstateAttrib[] getAttribs(String string) {
        ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
        for (String string2 : this.typeAttribs.keySet()) {
            for (String string3 : this.typeAttribs.get(string2)) {
                OpenEstateAttrib openEstateAttrib = OpenEstateUtils.getAvailableAttribute(string2 + "." + string3);
                if (this.typeAttribsGeneral.contains(openEstateAttrib.getKey())) {
                    arrayList.add(openEstateAttrib);
                    continue;
                }
                if (string == null || !this.typeActionAttribs.containsKey(string) || !this.typeActionAttribs.get(string).contains(openEstateAttrib.getKey())) continue;
                arrayList.add(openEstateAttrib);
            }
        }
        return arrayList.toArray(new OpenEstateAttrib[arrayList.size()]);
    }

    public final OpenEstateAttrib[] getAttribsByAction(String string) {
        if (!this.typeActionAttribs.containsKey(string)) {
            return new OpenEstateAttrib[0];
        }
        ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
        for (String string2 : this.typeActionAttribs.get(string)) {
            String[] stringArray = string2.split("\\.");
            if (stringArray.length < 2 || !this.typeAttribs.containsKey(stringArray[0]) || !this.typeAttribs.get(stringArray[0]).contains(stringArray[1])) continue;
            OpenEstateAttrib openEstateAttrib = OpenEstateUtils.getAvailableAttribute(stringArray[0] + "." + stringArray[1]);
            arrayList.add(openEstateAttrib);
        }
        return arrayList.toArray(new OpenEstateAttrib[arrayList.size()]);
    }

    public final OpenEstateAttrib[] getAttribsByGroup(String string) {
        if (!this.typeAttribs.containsKey(string)) {
            return new OpenEstateAttrib[0];
        }
        ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
        for (String string2 : this.typeAttribs.get(string)) {
            OpenEstateAttrib openEstateAttrib = OpenEstateUtils.getAvailableAttribute(string + "." + string2);
            if (openEstateAttrib == null) continue;
            arrayList.add(openEstateAttrib);
        }
        return arrayList.toArray(new OpenEstateAttrib[arrayList.size()]);
    }

    public final String[] getChildren() {
        return (String[])ArrayUtils.clone((Object[])this.typeChildren);
    }

    public final String getName() {
        return this.typeName;
    }

    public final String getParent() {
        return this.typeParent;
    }

    public final boolean hasAction(String string) {
        return this.typeActions != null && this.typeActions.contains(string);
    }

    public final boolean hasAttrib(String string, String string2) {
        return this.typeAttribs != null && this.typeAttribs.containsKey(string) && this.typeAttribs.get(string).contains(string2);
    }

    public final boolean hasAttribGroup(String string) {
        return this.typeAttribs != null && this.typeAttribs.containsKey(string);
    }

    public final boolean hasChildren() {
        return this.typeChildren != null && this.typeChildren.length > 0;
    }

    public final boolean hasParent() {
        return this.typeParent != null && this.typeParent.trim().length() > 0;
    }

    public final boolean isAttribGeneral(OpenEstateAttrib openEstateAttrib) {
        return this.isAttribGeneral(openEstateAttrib.getGroup(), openEstateAttrib.getName());
    }

    public final boolean isAttribGeneral(String string, String string2) {
        return this.typeAttribsGeneral.contains(string + "." + string2);
    }

    public final boolean isAttribRequired(OpenEstateAttrib openEstateAttrib, String string) {
        return this.isAttribRequired(openEstateAttrib.getGroup(), openEstateAttrib.getName(), string);
    }

    public final boolean isAttribRequired(String string, String string2, String string3) {
        OpenEstateAttrib openEstateAttrib = this.getAttrib(string, string2);
        if (openEstateAttrib == null) {
            return false;
        }
        if (this.typeAttribsGeneralRequired.containsKey(openEstateAttrib.getKey())) {
            return this.typeAttribsGeneralRequired.get(openEstateAttrib.getKey());
        }
        return false;
    }

    public static synchronized OpenEstateType newInstance(String string) throws OpenEstateException {
        if (TYPES == null) {
            TYPES = new LinkedHashMap<String, OpenEstateType>();
        }
        if (TYPES.containsKey(string)) {
            return TYPES.get(string);
        }
        try {
            String string2 = "com.openindex.openestate.impl.types." + OpenEstateUtils.makeCamelCase(string);
            TYPES.put(string, (OpenEstateType)Class.forName(string2).newInstance());
            return TYPES.get(string);
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            throw new OpenEstateException("could not load openestate-type '" + string + "': " + exception.getLocalizedMessage(), exception);
        }
    }

    protected void registerAction(String string) {
        this.typeActions.add(string);
    }

    protected void registerAttrib(String string, String string2, boolean bl) {
        this.registerAttrib(string, string2, null, bl);
    }

    protected void registerAttrib(String string, String string2, String[] stringArray, Boolean bl) {
        String string3 = string + '.' + string2;
        OpenEstateAttrib openEstateAttrib = OpenEstateUtils.getAvailableAttribute(string3);
        if (openEstateAttrib == null) {
            throw new NullPointerException("attribute '" + string3 + "' not found!");
        }
        if (!this.typeAttribs.containsKey(openEstateAttrib.getGroup())) {
            this.typeAttribs.put(openEstateAttrib.getGroup(), new ArrayList());
        }
        this.typeAttribs.get(openEstateAttrib.getGroup()).add(openEstateAttrib.getName());
        if (bl != null) {
            this.typeAttribsGeneralRequired.put(openEstateAttrib.getKey(), bl);
        }
        if (stringArray != null && stringArray.length > 0) {
            for (String string4 : stringArray) {
                if (!this.typeActionAttribs.containsKey(string4)) {
                    this.typeActionAttribs.put(string4, new ArrayList());
                }
                if (this.typeActionAttribs.get(string4).contains(openEstateAttrib.getKey())) continue;
                this.typeActionAttribs.get(string4).add(openEstateAttrib.getKey());
            }
        } else if (!this.typeAttribsGeneral.contains(openEstateAttrib.getKey())) {
            this.typeAttribsGeneral.add(openEstateAttrib.getKey());
        }
    }
}

