/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroups;
import com.openindex.openestate.impl.OpenEstateAttribsEnergiepass;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateTranslator;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateTypes;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.impl.utils.UTF8ResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OpenEstateUtils {
    private static final Logger LOGGER = Logger.getLogger(OpenEstateUtils.class);
    public static final String RESOURCE_PATH = "/com/openindex/openestate/impl/resources/";
    public static final String OPENESTATE_ENCODING = "UTF-8";
    public static final String OPENESTATE_NAMESPACE = "http://www.openestate.org/1.0/";
    public static final String OPENESTATE_VERSION = "1.0";
    public static final Locale DEFAULT_LOCALE = Locale.GERMANY;
    private static boolean initialized = false;
    private static String serializationLineBreak = null;
    private static final Map<String, ResourceBundle> resources = new HashMap<String, ResourceBundle>();
    private static final Map<String, OpenEstateAttrib> attributes = new HashMap<String, OpenEstateAttrib>();

    private OpenEstateUtils() {
    }

    public static String appendTextToDescription(String string, String string2, String string3, int n, boolean bl) {
        int n2;
        string3 = string3 != null ? string3 : SystemUtils.LINE_SEPARATOR;
        string = StringUtils.trimToEmpty((String)string);
        int n3 = n2 = bl ? StringEscapeUtils.escapeXml((String)string).length() : string.length();
        if (n > 0 && n2 > 0 && n2 > n) {
            String string4 = string = n > 3 ? StringUtils.abbreviate((String)string, (int)n) : string.substring(0, n);
        }
        if ((string2 = StringUtils.trimToNull((String)string2)) != null) {
            int n4;
            int n5 = n4 = bl ? StringEscapeUtils.escapeXml((String)string).length() : string.length();
            if (n > 0) {
                int n6;
                int n7 = bl ? StringEscapeUtils.escapeXml((String)string2).length() : string2.length();
                int n8 = bl ? StringEscapeUtils.escapeXml((String)string3).length() : string3.length();
                int n9 = n6 = n4 > 0 ? n4 + n8 + n8 + n7 : n7;
                if (n6 > n) {
                    int n10 = n4 - n7;
                    string = n10 > 3 ? StringUtils.abbreviate((String)string, (int)n10) : string.substring(0, n10);
                }
            }
            string = n4 > 0 ? string + string3 + string3 + string2 : string2;
        }
        return StringUtils.trimToNull((String)string);
    }

    public static Locale buildLocale(String string) {
        if (string == null) {
            throw new NullPointerException("locale-code may not be null!");
        }
        String[] stringArray = string.split("_");
        if (stringArray.length == 1) {
            return new Locale(stringArray[0].toLowerCase());
        }
        if (stringArray.length == 2) {
            return new Locale(stringArray[0].toLowerCase(), stringArray[1].toUpperCase());
        }
        return new Locale(stringArray[0].toLowerCase(), stringArray[1].toUpperCase(), stringArray[2].toUpperCase());
    }

    public static String convertToIso2Country(String string) {
        for (String string2 : Locale.getISOCountries()) {
            Locale locale = new Locale(string2, string2);
            String string3 = null;
            try {
                string3 = locale.getISO3Country();
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (string3 == null || !string3.equalsIgnoreCase(string)) continue;
            return locale.getCountry();
        }
        return null;
    }

    public static String convertToIso3Country(String string) {
        for (String string2 : Locale.getISOCountries()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            Locale locale = new Locale(string, string);
            try {
                return locale.getISO3Country();
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String[] getAllEstateSubtypes(OpenEstateType openEstateType) throws OpenEstateException {
        if (openEstateType == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : openEstateType.getChildren()) {
            OpenEstateType openEstateType2 = OpenEstateType.newInstance(string);
            arrayList.add(openEstateType2.getName());
            String[] stringArray = OpenEstateUtils.getAllEstateSubtypes(openEstateType2);
            if (stringArray.length <= 0) continue;
            arrayList.addAll(Arrays.asList(stringArray));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static OpenEstateAttrib getAvailableAttribute(String string) {
        return attributes.containsKey(string) ? attributes.get(string) : null;
    }

    public static String[] getAvailableAttributes() {
        return attributes.keySet().toArray(new String[attributes.size()]);
    }

    public static Locale[] getAvailableLocales() {
        HashMap<String, Locale> hashMap = new HashMap<String, Locale>();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(RESOURCE_PATH.substring(1) + "translators");
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            Locale locale;
            String[] stringArray = enumeration.nextElement().toString().split("\\.");
            if (stringArray.length < 2 || hashMap.containsKey((locale = OpenEstateUtils.buildLocale(stringArray[1])).toString())) continue;
            hashMap.put(locale.toString(), locale);
        }
        return hashMap.values().toArray(new Locale[hashMap.size()]);
    }

    public static String getEnergyCertificateClass(Number number, String string) {
        if (number == null) {
            return null;
        }
        double d = number.doubleValue();
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        if ("de".equalsIgnoreCase(string)) {
            if (d < 0.0) {
                return null;
            }
            if (d < 30.0) {
                return "A_PLUS";
            }
            if (d < 50.0) {
                return "A";
            }
            if (d < 75.0) {
                return "B";
            }
            if (d < 100.0) {
                return "C";
            }
            if (d < 130.0) {
                return "D";
            }
            if (d < 160.0) {
                return "E";
            }
            if (d < 200.0) {
                return "F";
            }
            if (d < 250.0) {
                return "G";
            }
            return "H";
        }
        if ("it".equalsIgnoreCase(string)) {
            if (d < 0.0) {
                return null;
            }
            if (d <= 15.0) {
                return "A_PLUS";
            }
            if (d <= 30.0) {
                return "A";
            }
            if (d <= 50.0) {
                return "B";
            }
            if (d <= 70.0) {
                return "C";
            }
            if (d <= 90.0) {
                return "D";
            }
            if (d <= 120.0) {
                return "E";
            }
            if (d <= 160.0) {
                return "F";
            }
            return "G";
        }
        return null;
    }

    public static String[] getEstateTypePath(OpenEstateType openEstateType) throws OpenEstateException {
        if (openEstateType == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (openEstateType.getParent() != null && openEstateType.getParent().trim().length() > 0) {
            arrayList.addAll(Arrays.asList(OpenEstateUtils.getEstateTypePath(OpenEstateType.newInstance(openEstateType.getParent()))));
        }
        arrayList.add(openEstateType.getName());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static OpenEstateType[] getEstateTypesOnRoot() throws OpenEstateException {
        ArrayList<OpenEstateType> arrayList = new ArrayList<OpenEstateType>();
        for (String string : OpenEstateTypes.getValues()) {
            OpenEstateType openEstateType = OpenEstateType.newInstance(string);
            if (openEstateType.hasParent()) continue;
            arrayList.add(openEstateType);
        }
        return arrayList.toArray(new OpenEstateType[arrayList.size()]);
    }

    public static ImageIcon getFlagIcon(Locale locale) {
        return OpenEstateUtils.getFlagIcon(locale.getLanguage());
    }

    public static ImageIcon getFlagIcon(String string) {
        try {
            URL uRL = OpenEstateUtils.class.getResource("/com/openindex/openestate/impl/resources/flags/" + string.toLowerCase() + ".png");
            if (uRL == null) {
                return null;
            }
            ImageIcon imageIcon = new ImageIcon(uRL);
            return imageIcon;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load country-flag!");
            if (string != null) {
                LOGGER.warn((Object)("> code: " + string));
            }
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public static ResourceBundle getResources(Locale locale) {
        Locale locale2;
        Locale locale3 = locale2 = locale != null ? locale : DEFAULT_LOCALE;
        if (resources.containsKey(locale2.getLanguage())) {
            return resources.get(locale2.getLanguage());
        }
        try {
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle(RESOURCE_PATH.substring(1) + "openestate", locale2);
            }
            catch (MissingResourceException missingResourceException) {
                LOGGER.warn((Object)"could not load openestate-locale!");
                LOGGER.warn((Object)("> " + missingResourceException.getLocalizedMessage()), (Throwable)missingResourceException);
                resourceBundle = ResourceBundle.getBundle(RESOURCE_PATH.substring(1) + "openestate");
            }
            ResourceBundle resourceBundle2 = UTF8ResourceBundle.createUtf8PropertyResourceBundle(resourceBundle);
            if (resourceBundle2 == null) {
                return null;
            }
            resources.put(locale.getLanguage(), resourceBundle2);
            return resourceBundle2;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load openestate-resource-bundle!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public static String getSerializationLineBreak() {
        return serializationLineBreak;
    }

    public static Double getTotalRent(EstateImpl estateImpl) {
        Number number;
        ValueImpl valueImpl = estateImpl.getAttribute("PREISE", "WARMMIETE");
        Number number2 = number = valueImpl != null ? (Number)((Number)valueImpl.getValueObject()) : (Number)null;
        if (number != null) {
            return number.doubleValue();
        }
        valueImpl = estateImpl.getAttribute("PREISE", "KALTMIETE");
        Number number3 = number = valueImpl != null ? (Number)((Number)valueImpl.getValueObject()) : (Number)null;
        if (number != null) {
            boolean bl;
            Number number4;
            double d = number.doubleValue();
            valueImpl = estateImpl.getAttribute("PREISE", "NEBENKOSTEN");
            Number number5 = number4 = valueImpl != null ? (Number)((Number)valueImpl.getValueObject()) : (Number)null;
            if (number4 != null) {
                d += number4.doubleValue();
            }
            boolean bl2 = bl = (valueImpl = estateImpl.getAttribute("PREISE", "NEBENKOSTEN_INKL_HEIZKOSTEN")) != null && Boolean.TRUE.equals(valueImpl.getValueObject());
            if (!bl) {
                Number number6;
                valueImpl = estateImpl.getAttribute("PREISE", "HEIZKOSTEN");
                Number number7 = number6 = valueImpl != null ? (Number)((Number)valueImpl.getValueObject()) : (Number)null;
                if (number6 != null) {
                    d += number6.doubleValue();
                }
            }
            return d;
        }
        return null;
    }

    public static DateFormat getXsdDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static DateFormat getXsdDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    }

    public static DateFormat getXsdTimeFormat() {
        return new SimpleDateFormat("hh:mm:ss");
    }

    public static String hash(String string) throws NoSuchAlgorithmException {
        return OpenEstateUtils.hash(string, "SHA1");
    }

    public static String hash(String string, String string2) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string2);
        messageDigest.reset();
        messageDigest.update(string.getBytes());
        byte[] byArray = messageDigest.digest();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(Integer.toHexString(0xFF & byArray[i]));
        }
        return stringBuilder.toString();
    }

    public static File initLogging() throws IOException, ParserConfigurationException, SAXException {
        File file = new File(System.getProperty("basedir", "").trim());
        File file2 = new File(file.getAbsolutePath() + File.separator + "log");
        String string = file2.toURI().toURL().getPath();
        String string2 = OpenEstateUtils.readResource(RESOURCE_PATH.substring(1) + "log4j.xml");
        String string3 = string2.replaceAll(Pattern.quote("${logDir}"), string);
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        org.w3c.dom.Document document = documentBuilder.parse(new InputSource(new StringReader(string3)));
        DOMConfigurator.configure((Element)document.getDocumentElement());
        if (!file2.exists() && !file2.mkdirs()) {
            LOGGER.error((Object)"could not create log-directory!");
            LOGGER.error((Object)("> " + file2.getPath()));
            return null;
        }
        if (!file2.isDirectory()) {
            LOGGER.error((Object)"log-directory is invalid!");
            LOGGER.error((Object)("> " + file2.getPath()));
            return null;
        }
        if (!file2.canWrite()) {
            LOGGER.error((Object)"log-directory is not writable!");
            LOGGER.error((Object)("> " + file2.getPath()));
            return null;
        }
        return file2;
    }

    public static Document loadDocument(Reader reader) throws DocumentException {
        SAXReader sAXReader = new SAXReader();
        return sAXReader.read(reader);
    }

    public static Document loadDocument(InputStream inputStream) throws DocumentException {
        SAXReader sAXReader = new SAXReader();
        return sAXReader.read(inputStream);
    }

    public static Document loadDocumentFromResource(String string) throws DocumentException {
        return OpenEstateUtils.loadDocument(OpenEstateUtils.class.getResourceAsStream(string));
    }

    public static Document loadDocumentFromXmlString(String string) throws DocumentException {
        return OpenEstateUtils.loadDocument(new StringReader(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, OpenEstateTranslator> loadTranslatorsByLanguage() throws IOException {
        Object object;
        Object object2;
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = OpenEstateUtils.class.getResourceAsStream("/com/openindex/openestate/impl/resources/translators.properties");
            properties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        TreeMap<String, Locale> treeMap = new TreeMap<String, Locale>();
        Object object3 = properties.propertyNames();
        while (object3.hasMoreElements()) {
            String string = (String)object3.nextElement();
            if (!string.startsWith("translator.")) continue;
            String[] object4 = string.split("\\.");
            object2 = object4[1].split("_");
            object = null;
            if (((String[])object2).length == 1) {
                object = new Locale(object2[0]);
            } else if (((String[])object2).length == 2) {
                object = new Locale(object2[0], object2[1]);
            } else if (((String[])object2).length > 2) {
                object = new Locale(object2[0], object2[1], object2[2]);
            } else {
                LOGGER.warn((Object)"cant load locale from key!");
                LOGGER.warn((Object)("> " + (String)string));
                continue;
            }
            treeMap.put(((Locale)object).toString(), (Locale)object);
        }
        object3 = new TreeMap();
        for (Map.Entry entry : treeMap.entrySet()) {
            object2 = properties.getProperty("translator." + (String)entry.getKey() + ".name");
            object = properties.getProperty("translator." + (String)entry.getKey() + ".link");
            ((TreeMap)object3).put(entry.getKey(), new OpenEstateTranslator((String)object2, (String)object, (Locale)entry.getValue()));
        }
        return object3;
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        OpenEstateAttribGroups.init();
    }

    public static String makeCamelCase(String string) {
        if (string == null) {
            return null;
        }
        if (string.contains("_")) {
            String[] stringArray;
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray = string.split("_")) {
                stringBuilder.append(OpenEstateUtils.makeCamelCase(string2));
            }
            return stringBuilder.toString();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }

    public static String makeUnCamelCase(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            String string2 = String.valueOf(string.charAt(i));
            if (i > 0 && !string2.toLowerCase().equals(string2)) {
                stringBuilder.append('_');
            }
            stringBuilder.append(string2.toUpperCase());
        }
        return stringBuilder.toString();
    }

    public static Date parseDate(String string) throws ParseException {
        return !StringUtils.isBlank((String)string) ? DateUtils.parseDateStrictly((String)string.trim(), (String[])new String[]{"dd.MM.yyyy", "dd.MM.yy", "dd/MM/yyyy", "dd/MM/yy", "dd-MM-yyyy", "dd-MMM-yyyy", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy-D", "MMM yyyy", "MMMMM yyyy"}) : null;
    }

    public static Date parseDateTime(String string) throws ParseException {
        return !StringUtils.isBlank((String)string) ? DateUtils.parseDateStrictly((String)string.trim(), (String[])new String[]{"yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd'T'hh:mm"}) : null;
    }

    public static String parseString(String string) {
        Pattern pattern = Pattern.compile("<br\\s*/?>", 2);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        return matcher.replaceAll("\n");
    }

    public static Date parseTime(String string) throws ParseException {
        return !StringUtils.isBlank((String)string) ? DateUtils.parseDateStrictly((String)string.trim(), (String[])new String[]{"hh:mm:ss", "hh:mm"}) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResource(String string) throws IOException {
        BufferedReader bufferedReader = null;
        InputStream inputStream = null;
        try {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
            if (inputStream == null) {
                throw new IOException("resource '" + string + "' not found!");
            }
            StringBuilder stringBuilder = new StringBuilder();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while (bufferedReader.ready()) {
                stringBuilder.append(bufferedReader.readLine()).append(SystemUtils.LINE_SEPARATOR);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public static void registerAttrib(OpenEstateAttrib openEstateAttrib) {
        attributes.put(openEstateAttrib.getKey(), openEstateAttrib);
    }

    public static String serializeString(String string) {
        return OpenEstateUtils.serializeString(string, OpenEstateUtils.getSerializationLineBreak());
    }

    public static String serializeString(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "<br/>";
        }
        Pattern pattern = Pattern.compile("^(.*)$", 8);
        Matcher matcher = pattern.matcher(string.trim());
        StringBuilder stringBuilder = new StringBuilder();
        while (matcher.find()) {
            stringBuilder.append(matcher.group());
            if (matcher.hitEnd()) continue;
            stringBuilder.append(string2);
        }
        return stringBuilder.toString().trim();
    }

    public static void serializeToXML(SerializableXmlElement serializableXmlElement, Writer writer, boolean bl) throws IOException, DocumentException {
        OpenEstateUtils.serializeToXML(serializableXmlElement, writer, bl, OPENESTATE_ENCODING, null);
    }

    public static void serializeToXML(SerializableXmlElement serializableXmlElement, Writer writer, boolean bl, String string) throws IOException, DocumentException {
        OpenEstateUtils.serializeToXML(serializableXmlElement, writer, bl, OPENESTATE_ENCODING, null);
    }

    public static synchronized void serializeToXML(SerializableXmlElement serializableXmlElement, Writer writer, boolean bl, String string, String string2) throws IOException, DocumentException {
        Document document = DocumentFactory.getInstance().createDocument(string);
        serializationLineBreak = string2 != null ? string2 : "<br/>";
        serializableXmlElement.serializeToXml(document);
        serializationLineBreak = null;
        OutputFormat outputFormat = bl ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
        outputFormat.setEncoding(string);
        XMLWriter xMLWriter = new XMLWriter(writer, outputFormat);
        xMLWriter.write(document);
        xMLWriter.flush();
    }

    public static String translate(String string) {
        return OpenEstateUtils.translate(string, null, Locale.getDefault());
    }

    public static String translate(String string, String string2) {
        return OpenEstateUtils.translate(string, string2, Locale.getDefault());
    }

    public static String translate(String string, Locale locale) {
        return OpenEstateUtils.translate(string, null, locale);
    }

    public static String translate(String string, String string2, Locale locale) {
        String string3 = string2;
        try {
            string3 = OpenEstateUtils.getResources(locale).getString(string);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not translate");
            LOGGER.warn((Object)("> " + string));
            if (locale != null) {
                LOGGER.warn((Object)("> locale " + locale));
            }
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
        }
        return string3;
    }

    public static String translateAction(String string) {
        return OpenEstateUtils.translateAction(string, Locale.getDefault());
    }

    public static String translateAction(String string, Locale locale) {
        return OpenEstateUtils.translate("ACTION." + string, locale);
    }

    public static String translateAttachment(String string) {
        return OpenEstateUtils.translateAttachment(string, Locale.getDefault());
    }

    public static String translateAttachment(String string, Locale locale) {
        return OpenEstateUtils.translate("ATTACHMENT." + string, locale);
    }

    public static String translateAttribute(String string) {
        return OpenEstateUtils.translateAttribute(string, Locale.getDefault());
    }

    public static String translateAttribute(String string, Locale locale) {
        return OpenEstateUtils.translate("ATTRIBUTE." + string, locale);
    }

    public static String translateAttribute(String string, String string2) {
        return OpenEstateUtils.translateAttribute(string, string2, Locale.getDefault());
    }

    public static String translateAttribute(String string, String string2, Locale locale) {
        return OpenEstateUtils.translate("ATTRIBUTE." + string + "." + string2, locale);
    }

    public static String translateAttribute(String string, String string2, String string3) {
        return OpenEstateUtils.translateAttribute(string, string2, string3, Locale.getDefault());
    }

    public static String translateAttribute(String string, String string2, String string3, Locale locale) {
        return OpenEstateUtils.translate("ATTRIBUTE." + string + "." + string2 + "." + string3, locale);
    }

    public static String translateAttributeByCountry(String string, Locale locale, String string2) {
        return OpenEstateUtils.translateAttribute(string, locale);
    }

    public static String translateAttributeByCountry(String string, String string2, Locale locale, String string3) {
        if ("it".equalsIgnoreCase(string3) && locale != null && "PREISE".equals(string) && "HAUSGELD".equals(string2) && Locale.GERMAN.getLanguage().equalsIgnoreCase(locale.getLanguage())) {
            return "Kondominiumsspesen";
        }
        return OpenEstateUtils.translateAttribute(string, string2, locale);
    }

    public static String translateAttributeByCountry(String string, String string2, String string3, Locale locale, String string4) {
        return OpenEstateUtils.translateAttribute(string, string2, string3, locale);
    }

    public static String translateConst(String string) {
        return OpenEstateUtils.translateConst(string, Locale.getDefault());
    }

    public static String translateConst(String string, Locale locale) {
        return OpenEstateUtils.translate("CONST." + string, locale);
    }

    public static String translateEstate(String string) {
        return OpenEstateUtils.translateEstate(string, Locale.getDefault());
    }

    public static String translateEstate(String string, Locale locale) {
        return OpenEstateUtils.translate("ESTATE." + string, locale);
    }

    public static String writeEstateEnergyCertificate(EstateImpl estateImpl) {
        return OpenEstateUtils.writeEstateEnergyCertificate(estateImpl, null, null);
    }

    public static String writeEstateEnergyCertificate(EstateImpl estateImpl, Locale locale) {
        return OpenEstateUtils.writeEstateEnergyCertificate(estateImpl, locale, null);
    }

    public static String writeEstateEnergyCertificate(EstateImpl estateImpl, Locale locale, String string) {
        if (estateImpl == null) {
            return null;
        }
        OpenEstateType openEstateType = estateImpl.getType();
        if (openEstateType == null || !openEstateType.hasAttrib("ENERGIEPASS", "VORHANDEN")) {
            return null;
        }
        locale = locale != null ? locale : Locale.getDefault();
        string = string != null ? string : SystemUtils.LINE_SEPARATOR;
        StringBuilder stringBuilder = new StringBuilder();
        ValueImpl valueImpl = estateImpl.getAttribute("ENERGIEPASS", "VORHANDEN");
        if (valueImpl == null || !Boolean.FALSE.equals(valueImpl.getValueObject())) {
            for (String string2 : OpenEstateAttribsEnergiepass.getValues()) {
                if ("VORHANDEN".equals(string2)) continue;
                valueImpl = estateImpl.getAttribute("ENERGIEPASS", string2);
                OpenEstateUtils.writeEstateEnergyCertificateValue(stringBuilder, valueImpl, locale, string, estateImpl.getCurrency());
            }
        }
        if (stringBuilder.length() < 1) {
            stringBuilder.append(string);
            stringBuilder.append(OpenEstateUtils.translateConst("NO_ENERGY_CERTIFICATE", locale));
        } else {
            valueImpl = estateImpl.getAttribute("AUSSTATTUNG", "HEIZUNGSART");
            OpenEstateUtils.writeEstateEnergyCertificateValue(stringBuilder, valueImpl, locale, string, estateImpl.getCurrency());
            valueImpl = estateImpl.getAttribute("AUSSTATTUNG", "BEFEUERUNG");
            OpenEstateUtils.writeEstateEnergyCertificateValue(stringBuilder, valueImpl, locale, string, estateImpl.getCurrency());
            valueImpl = estateImpl.getAttribute("ZUSTAND", "BAUJAHR");
            OpenEstateUtils.writeEstateEnergyCertificateValue(stringBuilder, valueImpl, locale, string, estateImpl.getCurrency());
        }
        String string3 = StringUtils.trimToNull((String)OpenEstateUtils.translateAttribute("ENERGIEPASS", locale));
        if (string3 != null) {
            stringBuilder.insert(0, StringUtils.upperCase((String)string3, (Locale)locale) + string);
        }
        return StringUtils.trimToNull((String)stringBuilder.toString());
    }

    private static void writeEstateEnergyCertificateValue(StringBuilder stringBuilder, ValueImpl valueImpl, Locale locale, String string, Currency currency) {
        if (valueImpl == null) {
            return;
        }
        stringBuilder.append(string);
        stringBuilder.append("- ");
        stringBuilder.append(OpenEstateUtils.translateAttribute(valueImpl.getGroupName(), valueImpl.getAttribName(), locale));
        stringBuilder.append(": ");
        stringBuilder.append(valueImpl.writeValue(locale, currency));
    }

    public static String writeException(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

