/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.SimpleAdressImpl;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public class PersonAdressImpl
extends SimpleAdressImpl {
    public static final String XML_ATTRIB_PERSON_FIRST_NAME = "PersonFirstName";
    public static final String XML_ATTRIB_PERSON_MIDDLE_NAME = "PersonMiddleName";
    public static final String XML_ATTRIB_PERSON_LAST_NAME = "PersonLastName";
    public static final String XML_ATTRIB_PERSON_TITLE = "PersonTitle";
    public static final String XML_ATTRIB_PERSON_GENDER = "PersonGender";
    public static final String XML_ATTRIB_PERSON_MAIL = "PersonMail";
    public static final String XML_ATTRIB_PERSON_PHONE = "PersonPhone";
    public static final String XML_ATTRIB_PERSON_MOBILE_PHONE = "PersonMobilePhone";
    public static final String XML_ATTRIB_PERSON_FAX = "PersonFax";
    public static final String PERSONADRESS_XML_ELEMENT = "PersonAdress";
    public static final String GENDER_FEMALE = "FEMALE";
    public static final String GENDER_MALE = "MALE";

    public PersonAdressImpl() {
    }

    public PersonAdressImpl(Document document) throws DocumentException {
        this();
        this.build(document);
    }

    private void build(Document document) throws DocumentException {
        this.readFromXml(document);
    }

    public String getPersonFax() {
        return (String)this.getValue(XML_ATTRIB_PERSON_FAX);
    }

    public String getPersonFirstName() {
        return (String)this.getValue(XML_ATTRIB_PERSON_FIRST_NAME);
    }

    public String getPersonGender() {
        return (String)this.getValue(XML_ATTRIB_PERSON_GENDER);
    }

    public String getPersonLastName() {
        return (String)this.getValue(XML_ATTRIB_PERSON_LAST_NAME);
    }

    public String getPersonMail() {
        return (String)this.getValue(XML_ATTRIB_PERSON_MAIL);
    }

    public String getPersonMiddleName() {
        return (String)this.getValue(XML_ATTRIB_PERSON_MIDDLE_NAME);
    }

    public String getPersonMobilePhone() {
        return (String)this.getValue(XML_ATTRIB_PERSON_MOBILE_PHONE);
    }

    public String getPersonPhone() {
        return (String)this.getValue(XML_ATTRIB_PERSON_PHONE);
    }

    public String getPersonTitle() {
        return (String)this.getValue(XML_ATTRIB_PERSON_TITLE);
    }

    public boolean isFemale() {
        return GENDER_FEMALE.equalsIgnoreCase(this.getPersonGender());
    }

    public boolean isMale() {
        return GENDER_MALE.equalsIgnoreCase(this.getPersonGender());
    }

    @Override
    public void readFromXml(Document document) throws DocumentException {
        this.readFromXml((Element)document.selectSingleNode(PERSONADRESS_XML_ELEMENT));
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        super.readFromXml(element);
        this.setPersonFax(PersonAdressImpl.selectAttribute(element, XML_ATTRIB_PERSON_FAX));
        this.setPersonFirstName(PersonAdressImpl.selectAttribute(element, XML_ATTRIB_PERSON_FIRST_NAME));
        this.setPersonGender(PersonAdressImpl.selectAttribute(element, XML_ATTRIB_PERSON_GENDER));
        this.setPersonLastName(PersonAdressImpl.selectAttribute(element, XML_ATTRIB_PERSON_LAST_NAME));
        this.setPersonMail(PersonAdressImpl.selectAttribute(element, XML_ATTRIB_PERSON_MAIL));
        this.setPersonMiddleName(PersonAdressImpl.selectAttribute(element, XML_ATTRIB_PERSON_MIDDLE_NAME));
        this.setPersonMobilePhone(PersonAdressImpl.selectAttribute(element, XML_ATTRIB_PERSON_MOBILE_PHONE));
        this.setPersonPhone(PersonAdressImpl.selectAttribute(element, XML_ATTRIB_PERSON_PHONE));
        this.setPersonTitle(PersonAdressImpl.selectAttribute(element, XML_ATTRIB_PERSON_TITLE));
    }

    @Override
    public void serializeToXml(Document document) throws DocumentException {
        Element element = DocumentFactory.getInstance().createElement(PERSONADRESS_XML_ELEMENT, "http://www.openestate.org/1.0/");
        this.serializeToXml(element);
        document.add(element);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        super.serializeToXml(element);
        if (this.getPersonFax() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_FAX, this.getPersonFax());
        }
        if (this.getPersonFirstName() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_FIRST_NAME, this.getPersonFirstName());
        }
        if (this.getPersonGender() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_GENDER, this.getPersonGender());
        }
        if (this.getPersonLastName() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_LAST_NAME, this.getPersonLastName());
        }
        if (this.getPersonMail() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_MAIL, this.getPersonMail());
        }
        if (this.getPersonMiddleName() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_MIDDLE_NAME, this.getPersonMiddleName());
        }
        if (this.getPersonMobilePhone() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_MOBILE_PHONE, this.getPersonMobilePhone());
        }
        if (this.getPersonPhone() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_PHONE, this.getPersonPhone());
        }
        if (this.getPersonTitle() != null) {
            element.addAttribute(XML_ATTRIB_PERSON_TITLE, this.getPersonTitle());
        }
    }

    public void setPersonFax(String string) {
        this.putValue(XML_ATTRIB_PERSON_FAX, string);
    }

    public void setPersonFirstName(String string) {
        this.putValue(XML_ATTRIB_PERSON_FIRST_NAME, string);
    }

    public void setPersonGender(String string) {
        this.putValue(XML_ATTRIB_PERSON_GENDER, string);
    }

    public void setPersonLastName(String string) {
        this.putValue(XML_ATTRIB_PERSON_LAST_NAME, string);
    }

    public void setPersonMail(String string) {
        this.putValue(XML_ATTRIB_PERSON_MAIL, string);
    }

    public void setPersonMiddleName(String string) {
        this.putValue(XML_ATTRIB_PERSON_MIDDLE_NAME, string);
    }

    public void setPersonMobilePhone(String string) {
        this.putValue(XML_ATTRIB_PERSON_MOBILE_PHONE, string);
    }

    public void setPersonPhone(String string) {
        this.putValue(XML_ATTRIB_PERSON_PHONE, string);
    }

    public void setPersonTitle(String string) {
        this.putValue(XML_ATTRIB_PERSON_TITLE, string);
    }

    public String writePersonFullName() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        string = StringUtils.trimToNull((String)this.getPersonTitle());
        if (string != null) {
            arrayList.add(string);
        }
        if ((string = StringUtils.trimToNull((String)this.getPersonFirstName())) != null) {
            arrayList.add(string);
        }
        if ((string = StringUtils.trimToNull((String)this.getPersonMiddleName())) != null) {
            arrayList.add(string);
        }
        if ((string = StringUtils.trimToNull((String)this.getPersonLastName())) != null) {
            arrayList.add(string);
        }
        return StringUtils.join(arrayList, (String)" ");
    }
}

