/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.CustomValuesImpl;
import com.openindex.openestate.impl.SerializableXmlElement;
import java.util.Locale;
import org.apache.commons.lang.SystemUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;

public class SimpleAdressImpl
extends AbstractImplItem
implements SerializableXmlElement {
    public static final String XML_ATTRIB_STREET = "Street";
    public static final String XML_ATTRIB_STREET_2 = "Street2";
    public static final String XML_ATTRIB_STREET_NR = "StreetNr";
    public static final String XML_ATTRIB_POSTAL_CODE = "PostalCode";
    public static final String XML_ATTRIB_CITY = "City";
    public static final String XML_ATTRIB_CITY_PART = "CityPart";
    public static final String XML_ATTRIB_COUNTRY = "Country";
    public static final String XML_ATTRIB_REGION = "Region";
    public static final String XML_ATTRIB_LATITUDE = "Latitude";
    public static final String XML_ATTRIB_LONGITUDE = "Longitude";
    public static final String SIMPLEADRESS_XML_ELEMENT = "SimpleAdress";
    private static final String XML_ELEMENT_VALUES = "CustomValues";
    private CustomValuesImpl customValues = new CustomValuesImpl();

    public SimpleAdressImpl() {
    }

    public SimpleAdressImpl(Document document) throws DocumentException {
        this();
        this.build(document);
    }

    private void build(Document document) throws DocumentException {
        this.readFromXml(document);
    }

    public String getCity() {
        return (String)this.getValue(XML_ATTRIB_CITY);
    }

    public String getCityPart() {
        return (String)this.getValue(XML_ATTRIB_CITY_PART);
    }

    public String getCountry() {
        return (String)this.getValue(XML_ATTRIB_COUNTRY);
    }

    public CustomValuesImpl getCustomValues() {
        return this.customValues;
    }

    public Double getLatitude() {
        return (Double)this.getValue(XML_ATTRIB_LATITUDE);
    }

    public Double getLongitude() {
        return (Double)this.getValue(XML_ATTRIB_LONGITUDE);
    }

    public String getPostalCode() {
        return (String)this.getValue(XML_ATTRIB_POSTAL_CODE);
    }

    public String getRegion() {
        return (String)this.getValue(XML_ATTRIB_REGION);
    }

    public String getStreet() {
        return (String)this.getValue(XML_ATTRIB_STREET);
    }

    public String getStreet2() {
        return (String)this.getValue(XML_ATTRIB_STREET_2);
    }

    public String getStreetNr() {
        return (String)this.getValue(XML_ATTRIB_STREET_NR);
    }

    @Override
    public void merge(AbstractImplItem abstractImplItem) {
        super.merge(abstractImplItem);
        if (abstractImplItem instanceof SimpleAdressImpl) {
            this.customValues.merge(((SimpleAdressImpl)abstractImplItem).getCustomValues());
        }
    }

    @Override
    public void readFromXml(Document document) throws DocumentException {
        this.readFromXml((Element)document.selectSingleNode(SIMPLEADRESS_XML_ELEMENT));
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        this.setStreet(SimpleAdressImpl.selectAttribute(element, XML_ATTRIB_STREET));
        this.setStreet2(SimpleAdressImpl.selectAttribute(element, XML_ATTRIB_STREET_2));
        this.setStreetNr(SimpleAdressImpl.selectAttribute(element, XML_ATTRIB_STREET_NR));
        this.setPostalCode(SimpleAdressImpl.selectAttribute(element, XML_ATTRIB_POSTAL_CODE));
        this.setCity(SimpleAdressImpl.selectAttribute(element, XML_ATTRIB_CITY));
        this.setCityPart(SimpleAdressImpl.selectAttribute(element, XML_ATTRIB_CITY_PART));
        this.setCountry(SimpleAdressImpl.selectAttribute(element, XML_ATTRIB_COUNTRY));
        this.setRegion(SimpleAdressImpl.selectAttribute(element, XML_ATTRIB_REGION));
        this.setLatitude(SimpleAdressImpl.selectAttributeAsDouble(element, XML_ATTRIB_LATITUDE));
        this.setLongitude(SimpleAdressImpl.selectAttributeAsDouble(element, XML_ATTRIB_LONGITUDE));
        for (Node node : SimpleAdressImpl.selectChildElements(element)) {
            if (!XML_ELEMENT_VALUES.equals(node.getName())) continue;
            this.customValues.readFromXml((Element)node);
        }
    }

    @Override
    public void serializeToXml(Document document) throws DocumentException {
        Element element = DocumentFactory.getInstance().createElement(SIMPLEADRESS_XML_ELEMENT, "http://www.openestate.org/1.0/");
        this.serializeToXml(element);
        document.add(element);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        if (this.getStreet() != null) {
            element.addAttribute(XML_ATTRIB_STREET, this.getStreet());
        }
        if (this.getStreet2() != null) {
            element.addAttribute(XML_ATTRIB_STREET_2, this.getStreet2());
        }
        if (this.getStreetNr() != null) {
            element.addAttribute(XML_ATTRIB_STREET_NR, this.getStreetNr());
        }
        if (this.getPostalCode() != null) {
            element.addAttribute(XML_ATTRIB_POSTAL_CODE, this.getPostalCode());
        }
        if (this.getCity() != null) {
            element.addAttribute(XML_ATTRIB_CITY, this.getCity());
        }
        if (this.getCityPart() != null) {
            element.addAttribute(XML_ATTRIB_CITY_PART, this.getCityPart());
        }
        if (this.getCountry() != null) {
            element.addAttribute(XML_ATTRIB_COUNTRY, this.getCountry());
        }
        if (this.getRegion() != null) {
            element.addAttribute(XML_ATTRIB_REGION, this.getRegion());
        }
        if (this.getLatitude() != null) {
            element.addAttribute(XML_ATTRIB_LATITUDE, this.getLatitude().toString());
        }
        if (this.getLongitude() != null) {
            element.addAttribute(XML_ATTRIB_LONGITUDE, this.getLongitude().toString());
        }
        if (!this.customValues.getValueMap().isEmpty()) {
            this.customValues.serializeToXml(element.addElement(XML_ELEMENT_VALUES));
        }
    }

    public void setCity(String string) {
        this.putValue(XML_ATTRIB_CITY, string);
    }

    public void setCityPart(String string) {
        this.putValue(XML_ATTRIB_CITY_PART, string);
    }

    public void setCountry(String string) {
        this.putValue(XML_ATTRIB_COUNTRY, string);
    }

    public void setCustomValues(CustomValuesImpl customValuesImpl) {
        this.customValues = customValuesImpl;
    }

    public void setLatitude(Double d) {
        this.putValue(XML_ATTRIB_LATITUDE, d);
    }

    public void setLongitude(Double d) {
        this.putValue(XML_ATTRIB_LONGITUDE, d);
    }

    public void setPostalCode(String string) {
        this.putValue(XML_ATTRIB_POSTAL_CODE, string);
    }

    public void setRegion(String string) {
        this.putValue(XML_ATTRIB_REGION, string);
    }

    public void setStreet(String string) {
        this.putValue(XML_ATTRIB_STREET, string);
    }

    public void setStreet2(String string) {
        this.putValue(XML_ATTRIB_STREET_2, string);
    }

    public void setStreetNr(String string) {
        this.putValue(XML_ATTRIB_STREET_NR, string);
    }

    public String writeCountry() {
        return this.writeCountry(Locale.getDefault());
    }

    public String writeCountry(Locale locale) {
        return this.getCountry() != null && this.getCountry().trim().length() > 0 ? SimpleAdressImpl.writeCountry(this.getCountry(), locale) : "";
    }

    public static String writeCountry(String string) {
        return SimpleAdressImpl.writeCountry(string, Locale.getDefault());
    }

    public static String writeCountry(String string, Locale locale) {
        if (string == null) {
            return "";
        }
        return new Locale(string.toLowerCase(), string.toUpperCase()).getDisplayCountry(locale);
    }

    public final String writeFullAdress() {
        return this.writeFullAdress(SystemUtils.LINE_SEPARATOR, Locale.getDefault());
    }

    public final String writeFullAdress(Locale locale) {
        return this.writeFullAdress(SystemUtils.LINE_SEPARATOR, locale);
    }

    public String writeFullAdress(String string) {
        return this.writeFullAdress(string, Locale.getDefault());
    }

    public String writeFullAdress(String string, Locale locale) {
        String string2 = this.writeStreet();
        String string3 = this.writePostal();
        String string4 = this.writeCountry(locale);
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null && string2.trim().length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string2.trim());
        }
        if (string3 != null && string3.trim().length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string3.trim());
        }
        if (string4 != null && string4.trim().length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    public String writePostal() {
        String string = this.getCountry();
        String string2 = this.getPostalCode();
        String string3 = this.getCity();
        String string4 = this.getCityPart();
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null && string2.trim().length() > 0 || string3 != null && string3.trim().length() > 0) {
            if (string2 != null) {
                if (string != null) {
                    stringBuilder.append(string.trim()).append('-');
                }
                stringBuilder.append(string2.trim());
            }
            if (string3 != null) {
                stringBuilder.append(' ').append(string3.trim());
            }
            if (string4 != null) {
                stringBuilder.append(' ').append(string4.trim());
            }
        }
        return stringBuilder.toString().trim();
    }

    public String writeStreet() {
        String string = this.getStreet();
        String string2 = this.getStreetNr();
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.trim().length() > 0) {
            stringBuilder.append(this.getStreet());
            if (string2 != null) {
                stringBuilder.append(' ').append(string2.trim());
            }
        }
        return stringBuilder.toString().trim();
    }
}

