/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.CustomValuesImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.SerializableXmlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class TransferAgencyImpl
extends AbstractImplItem
implements SerializableXmlType {
    public static final String XML_ELEMENT_AGENT = "Agent";
    public static final String XML_ELEMENT_CONTACT = "Contact";
    public static final String XML_ELEMENT_REMOVE_ESTATE = "RemoveEstate";
    public static final String XML_ELEMENT_REMOVE_UNMODIFIED_ESTATES = "RemoveUnmodifiedEstates";
    public static final String XML_ELEMENT_SAVE_ESTATE = "SaveEstate";
    public static final String XML_ELEMENT_VALUES = "CustomValues";
    private AgentImpl transferAgent = new AgentImpl();
    private Map<String, AgentContactImpl> transferContacts = new HashMap<String, AgentContactImpl>();
    private List<EstateImpl> transferEstateToSave = new ArrayList<EstateImpl>();
    private List<String> transferEstatesToRemove = new ArrayList<String>();
    private CustomValuesImpl customValues = new CustomValuesImpl();

    public AgentImpl getAgent() {
        return this.transferAgent;
    }

    public Map<String, AgentContactImpl> getContacts() {
        return this.transferContacts;
    }

    public CustomValuesImpl getCustomValues() {
        return this.customValues;
    }

    public List<String> getEstateIdsToRemove() {
        return this.transferEstatesToRemove;
    }

    public List<EstateImpl> getEstatesToSave() {
        return this.transferEstateToSave;
    }

    public boolean isRemoveUnmodifiedEstates() {
        return (Boolean)this.getValue(XML_ELEMENT_REMOVE_UNMODIFIED_ESTATES, Boolean.FALSE);
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        for (Node node : TransferAgencyImpl.selectChildElements(element)) {
            AbstractImplItem abstractImplItem;
            if (XML_ELEMENT_AGENT.equals(node.getName())) {
                this.getAgent().readFromXml((Element)node);
                continue;
            }
            if (XML_ELEMENT_CONTACT.equals(node.getName())) {
                abstractImplItem = new AgentContactImpl();
                ((AgentContactImpl)abstractImplItem).readFromXml((Element)node);
                this.getContacts().put(((AgentContactImpl)abstractImplItem).getId(), (AgentContactImpl)abstractImplItem);
                continue;
            }
            if (XML_ELEMENT_SAVE_ESTATE.equals(node.getName())) {
                abstractImplItem = new EstateImpl();
                ((EstateImpl)abstractImplItem).readFromXml((Element)node);
                this.getEstatesToSave().add((EstateImpl)abstractImplItem);
                continue;
            }
            if (XML_ELEMENT_REMOVE_ESTATE.equals(node.getName())) {
                this.getEstateIdsToRemove().add(node.getStringValue());
                continue;
            }
            if (XML_ELEMENT_REMOVE_UNMODIFIED_ESTATES.equals(node.getName())) {
                this.setRemoveUnmodifiedEstates(Boolean.valueOf(node.getStringValue()));
                continue;
            }
            if (!XML_ELEMENT_VALUES.equals(node.getName())) continue;
            this.getCustomValues().readFromXml((Element)node);
        }
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        this.getAgent().serializeToXml(element.addElement(XML_ELEMENT_AGENT));
        for (AgentContactImpl object : this.transferContacts.values()) {
            object.serializeToXml(element.addElement(XML_ELEMENT_CONTACT));
        }
        for (EstateImpl estateImpl : this.transferEstateToSave) {
            estateImpl.serializeToXml(element.addElement(XML_ELEMENT_SAVE_ESTATE));
        }
        if (this.isRemoveUnmodifiedEstates()) {
            element.addElement(XML_ELEMENT_REMOVE_UNMODIFIED_ESTATES).setText(Boolean.TRUE.toString());
        } else {
            for (String string : this.transferEstatesToRemove) {
                element.addElement(XML_ELEMENT_REMOVE_ESTATE).setText(string);
            }
        }
        if (!this.getCustomValues().getValueMap().isEmpty()) {
            this.getCustomValues().serializeToXml(element.addElement(XML_ELEMENT_VALUES));
        }
    }

    public void setAgent(AgentImpl agentImpl) {
        this.transferAgent = agentImpl;
    }

    public void setCustomValues(CustomValuesImpl customValuesImpl) {
        this.customValues = customValuesImpl;
    }

    public void setRemoveUnmodifiedEstates(boolean bl) {
        if (bl) {
            this.transferEstatesToRemove.clear();
        }
        this.putValue(XML_ELEMENT_REMOVE_UNMODIFIED_ESTATES, bl);
    }
}

