/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.CustomValuesImpl;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;

public class TransferImpl
extends AbstractImplItem
implements SerializableXmlElement {
    public static final String XML_ATTRIB_SENDER_SOFTWARE_MAIL = "SenderSoftwareMail";
    public static final String XML_ATTRIB_SENDER_SOFTWARE_NAME = "SenderSoftwareName";
    public static final String XML_ATTRIB_SENDER_SOFTWARE_VERSION = "SenderSoftwareVersion";
    public static final String XML_ELEMENT = "Transfer";
    public static final String XML_ELEMENT_AGENCY = "TransferAgency";
    public static final String XML_ELEMENT_VALUES = "CustomValues";
    private List<TransferAgencyImpl> transferAgencies = new ArrayList<TransferAgencyImpl>();
    private CustomValuesImpl customValues = new CustomValuesImpl();

    public TransferImpl() {
    }

    public TransferImpl(Document document) throws DocumentException {
        this();
        this.build(document);
    }

    private void build(Document document) throws DocumentException {
        this.readFromXml(document);
    }

    public List<TransferAgencyImpl> getAgencies() {
        return this.transferAgencies;
    }

    public CustomValuesImpl getCustomValues() {
        return this.customValues;
    }

    public String getSenderSoftwareMail() {
        return (String)this.getValue(XML_ATTRIB_SENDER_SOFTWARE_MAIL);
    }

    public String getSenderSoftwareName() {
        return (String)this.getValue(XML_ATTRIB_SENDER_SOFTWARE_NAME);
    }

    public String getSenderSoftwareVersion() {
        return (String)this.getValue(XML_ATTRIB_SENDER_SOFTWARE_VERSION);
    }

    @Override
    public void readFromXml(Document document) throws DocumentException {
        this.readFromXml(document.getRootElement());
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        this.setSenderSoftwareMail(TransferImpl.selectAttribute(element, XML_ATTRIB_SENDER_SOFTWARE_MAIL));
        this.setSenderSoftwareName(TransferImpl.selectAttribute(element, XML_ATTRIB_SENDER_SOFTWARE_NAME));
        this.setSenderSoftwareVersion(TransferImpl.selectAttribute(element, XML_ATTRIB_SENDER_SOFTWARE_VERSION));
        for (Node node : TransferImpl.selectChildElements(element)) {
            if (XML_ELEMENT_AGENCY.equals(node.getName())) {
                TransferAgencyImpl transferAgencyImpl = new TransferAgencyImpl();
                transferAgencyImpl.readFromXml((Element)node);
                this.getAgencies().add(transferAgencyImpl);
                continue;
            }
            if (!XML_ELEMENT_VALUES.equals(node.getName())) continue;
            this.getCustomValues().readFromXml((Element)node);
        }
    }

    @Override
    public void serializeToXml(Document document) throws DocumentException {
        Element element = DocumentFactory.getInstance().createElement(XML_ELEMENT, "http://www.openestate.org/1.0/");
        this.serializeToXml(element);
        document.setRootElement(element);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        element.addAttribute(XML_ATTRIB_SENDER_SOFTWARE_MAIL, this.getSenderSoftwareMail());
        element.addAttribute(XML_ATTRIB_SENDER_SOFTWARE_NAME, this.getSenderSoftwareName());
        element.addAttribute(XML_ATTRIB_SENDER_SOFTWARE_VERSION, this.getSenderSoftwareVersion());
        for (TransferAgencyImpl transferAgencyImpl : this.transferAgencies) {
            transferAgencyImpl.serializeToXml(element.addElement(XML_ELEMENT_AGENCY));
        }
        if (!this.getCustomValues().getValueMap().isEmpty()) {
            this.getCustomValues().serializeToXml(element.addElement(XML_ELEMENT_VALUES));
        }
    }

    public void setCustomValues(CustomValuesImpl customValuesImpl) {
        this.customValues = customValuesImpl;
    }

    public void setSenderSoftwareMail(String string) {
        this.putValue(XML_ATTRIB_SENDER_SOFTWARE_MAIL, string);
    }

    public void setSenderSoftwareName(String string) {
        this.putValue(XML_ATTRIB_SENDER_SOFTWARE_NAME, string);
    }

    public void setSenderSoftwareVersion(String string) {
        this.putValue(XML_ATTRIB_SENDER_SOFTWARE_VERSION, string);
    }
}

