/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlType;
import com.openindex.openestate.impl.attribs.ComplexAttrib;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleAttrib;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleNumericAttrib;
import com.openindex.openestate.impl.attribs.SimpleStringAttrib;
import com.openindex.openestate.impl.attribs.SimpleTimeAttrib;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class ValueImpl
extends AbstractImplItem
implements SerializableXmlType {
    private static final Logger LOGGER = Logger.getLogger(ValueImpl.class);
    public static final String XML_ATTRIB_LANGUAGE = "Language";
    public static final String XML_ELEMENT_TEXT = "Text";
    private String attribName;
    private String groupName;
    private Map<String, Object> values = null;
    private OpenEstateAttrib type = null;

    public ValueImpl(OpenEstateAttrib openEstateAttrib) {
        this.type = openEstateAttrib;
        this.attribName = openEstateAttrib.getName();
        this.groupName = openEstateAttrib.getGroup();
        this.values = new HashMap<String, Object>();
    }

    public OpenEstateAttrib getAttrib() {
        return this.type;
    }

    public String getAttribName() {
        return this.attribName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String[] getLangages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.values.keySet()) {
            if (string == null || string.length() <= 0) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getTagName() {
        return OpenEstateUtils.makeCamelCase(this.getGroupName()) + "_" + OpenEstateUtils.makeCamelCase(this.getAttribName());
    }

    public Object getValueObject() {
        if (this.type.isManuallyTranslated()) {
            return this.getValueObject(OpenEstateUtils.DEFAULT_LOCALE);
        }
        return this.getValueObject("");
    }

    public Object getValueObject(Locale locale) {
        if (this.type.isManuallyTranslated()) {
            return this.getValueObject(locale.getLanguage());
        }
        return this.getValueObject("");
    }

    public Object getValueObject(String string) {
        String string2 = this.type.isManuallyTranslated() ? string : "";
        return this.values.containsKey(string2) ? this.values.get(string2) : null;
    }

    public boolean hasLanguage(String string) {
        return this.values.containsKey(string != null ? string : "");
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        try {
            if (element.isTextOnly()) {
                if (!this.type.isComplex()) {
                    SimpleAttrib simpleAttrib = (SimpleAttrib)this.type;
                    String string = StringEscapeUtils.unescapeHtml((String)element.getStringValue());
                    this.setValue(simpleAttrib.parseValue(string));
                } else {
                    ComplexAttrib complexAttrib = (ComplexAttrib)this.type;
                    this.setValue(complexAttrib.parseNode((Node)element));
                }
            } else if (!this.type.isComplex()) {
                SimpleAttrib simpleAttrib = (SimpleAttrib)this.type;
                for (Node node : ValueImpl.selectChildElements(element)) {
                    String string;
                    if (!node.getName().equals(XML_ELEMENT_TEXT) || (string = ((Element)node).attributeValue(XML_ATTRIB_LANGUAGE)) == null) continue;
                    this.setValue(simpleAttrib.parseValue(StringEscapeUtils.unescapeHtml((String)node.getStringValue())), string);
                }
            } else {
                ComplexAttrib complexAttrib = (ComplexAttrib)this.type;
                for (Node node : ValueImpl.selectChildElements(element)) {
                    String string;
                    if (!node.getName().equals(XML_ELEMENT_TEXT) || (string = ((Element)node).attributeValue(XML_ATTRIB_LANGUAGE)) == null) continue;
                    this.setValue((Object)complexAttrib.parseNode((Node)element), string);
                }
            }
        }
        catch (ParseException parseException) {
            throw new DocumentException(parseException.getLocalizedMessage(), (Throwable)parseException);
        }
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        block9: {
            block7: {
                Object object;
                ComplexAttrib complexAttrib;
                block10: {
                    block8: {
                        if (this.type.isManuallyTranslated()) break block7;
                        if (this.type.isComplex()) break block8;
                        SimpleAttrib simpleAttrib = (SimpleAttrib)this.type;
                        String string = simpleAttrib.serializeValue(this.getValueObject());
                        if (string.contains("\n") || string.contains("\r")) {
                            element.addCDATA(StringEscapeUtils.unescapeHtml((String)string));
                        } else {
                            element.setText(string);
                        }
                        break block9;
                    }
                    complexAttrib = (ComplexAttrib)this.type;
                    object = this.getValueObject();
                    if (!(object instanceof String[])) break block10;
                    complexAttrib.serializeNode(element, (String[])object);
                    break block9;
                }
                if (object == null) break block9;
                complexAttrib.serializeNode(element, new String[]{object.toString()});
                break block9;
            }
            if (!this.type.isComplex()) {
                SimpleAttrib simpleAttrib = (SimpleAttrib)this.type;
                for (String string : this.getLangages()) {
                    Element element2 = element.addElement(XML_ELEMENT_TEXT);
                    element2.addAttribute(XML_ATTRIB_LANGUAGE, string);
                    String string2 = simpleAttrib.serializeValue(this.getValueObject(string));
                    if (string2.contains("\n") || string2.contains("\r")) {
                        element2.addCDATA(StringEscapeUtils.unescapeHtml((String)string2));
                        continue;
                    }
                    element2.setText(string2);
                }
            } else {
                ComplexAttrib complexAttrib = (ComplexAttrib)this.type;
                for (String string : this.getLangages()) {
                    Element element3 = element.addElement(XML_ELEMENT_TEXT);
                    element3.addAttribute(XML_ATTRIB_LANGUAGE, string);
                    complexAttrib.serializeNode(element3, (String[])this.getValueObject(string));
                }
            }
        }
    }

    public void setAttribName(String string) {
        this.attribName = string;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public void setType(OpenEstateAttrib openEstateAttrib) {
        this.type = openEstateAttrib;
    }

    public void setValue(Object object) {
        if (this.type.isManuallyTranslated()) {
            this.setValue(object, OpenEstateUtils.DEFAULT_LOCALE);
        } else {
            this.setValue(object, "");
        }
    }

    public void setValue(Object object, Locale locale) {
        this.setValue(object, locale != null ? locale.getLanguage() : OpenEstateUtils.DEFAULT_LOCALE.getLanguage());
    }

    public void setValue(Object object, String string) {
        block10: {
            String string2;
            String string3 = string2 = this.type != null && this.type.isManuallyTranslated() ? string : "";
            if (string2 == null) {
                throw new IllegalArgumentException("invalid language code!");
            }
            if (object == null) {
                if (this.values.containsKey(string2)) {
                    this.values.remove(string2);
                }
                return;
            }
            if (this.type == null) {
                LOGGER.warn((Object)"undefined value-type!");
                if (this.values.containsKey(string2)) {
                    this.values.remove(string2);
                }
                return;
            }
            if (!this.type.isComplex()) {
                try {
                    SimpleAttrib simpleAttrib = (SimpleAttrib)this.type;
                    Object object2 = simpleAttrib.parseValue(simpleAttrib.serializeValue(object));
                    if (object2 != null) {
                        this.values.put(string2, object2);
                    }
                    break block10;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not set value!");
                    LOGGER.warn((Object)("> " + object));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    if (this.values.containsKey(string2)) {
                        this.values.remove(string2);
                    }
                    break block10;
                }
            }
            this.values.put(string2, object);
        }
    }

    public String writeValue() {
        return ValueImpl.writeValue(this, null, null);
    }

    public String writeValue(Locale locale) {
        return ValueImpl.writeValue(this, locale, null);
    }

    public String writeValue(Currency currency) {
        return ValueImpl.writeValue(this, null, currency);
    }

    public String writeValue(Locale locale, Currency currency) {
        return ValueImpl.writeValue(this, locale, currency);
    }

    public static String writeValue(ValueImpl valueImpl, Locale locale) {
        return ValueImpl.writeValue(valueImpl, locale, null);
    }

    public static String writeValue(ValueImpl valueImpl, Currency currency) {
        return ValueImpl.writeValue(valueImpl, null, currency);
    }

    public static String writeValue(ValueImpl valueImpl, Locale locale, Currency currency) {
        String string;
        if (valueImpl == null) {
            LOGGER.warn((Object)"undefined value!");
            return "";
        }
        if (valueImpl.getAttrib() == null) {
            LOGGER.warn((Object)"undefined schema-type!");
            LOGGER.warn((Object)("> " + valueImpl.getGroupName() + "." + valueImpl.getAttribName()));
            return "";
        }
        String string2 = valueImpl.getAttrib().isManuallyTranslated() ? (locale != null ? locale.getLanguage() : OpenEstateUtils.DEFAULT_LOCALE.getLanguage()) : (string = "");
        if (valueImpl.getValueObject(string) == null) {
            return "";
        }
        if (currency == null && (currency = Currency.getInstance(new Locale(SystemUtils.USER_LANGUAGE, SystemUtils.USER_COUNTRY))) == null) {
            LOGGER.error((Object)"unknown currency!");
            return "";
        }
        if (valueImpl.getAttrib().isComplex()) {
            ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)valueImpl.getAttrib();
            String[] stringArray = (String[])valueImpl.getValueObject(string);
            String[] stringArray2 = complexEnumAttrib.getOptions();
            List<String> list = Arrays.asList(stringArray2);
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : stringArray) {
                String string4;
                if (!list.contains(string3)) {
                    LOGGER.warn((Object)"unknown value-option!");
                    LOGGER.warn((Object)("> " + string3));
                    LOGGER.warn((Object)("> " + valueImpl.getGroupName() + "." + valueImpl.getAttribName()));
                    continue;
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((string4 = OpenEstateUtils.translateAttribute(valueImpl.getGroupName(), valueImpl.getAttribName(), string3, locale)) != null ? string4 : string3);
            }
            return stringBuilder.toString();
        }
        SimpleAttrib simpleAttrib = (SimpleAttrib)valueImpl.getAttrib();
        try {
            if (simpleAttrib instanceof SimpleEnumAttrib) {
                SimpleEnumAttrib simpleEnumAttrib = (SimpleEnumAttrib)simpleAttrib;
                String[] stringArray = simpleEnumAttrib.getOptions();
                String string5 = valueImpl.getValueObject(string).toString();
                List<String> list = Arrays.asList(stringArray);
                if (list.contains(string5)) {
                    String string6 = OpenEstateUtils.translateAttribute(valueImpl.getGroupName(), valueImpl.getAttribName(), string5, locale);
                    return string6 != null ? string6 : valueImpl.getValueObject(string).toString();
                }
                LOGGER.warn((Object)"unknown value-option!");
                LOGGER.warn((Object)("> " + string5));
                LOGGER.warn((Object)("> " + valueImpl.getGroupName() + "." + valueImpl.getAttribName()));
                return "";
            }
            if (simpleAttrib instanceof SimpleStringAttrib) {
                return OpenEstateUtils.parseString(valueImpl.getValueObject(string).toString());
            }
            if (simpleAttrib instanceof SimpleNumericAttrib) {
                NumberFormat numberFormat = ((SimpleNumericAttrib)simpleAttrib).getNumberFormat();
                String string7 = numberFormat.format(Float.valueOf(valueImpl.getValueObject(string).toString()).floatValue());
                if (((SimpleNumericAttrib)simpleAttrib).isAreaUnit()) {
                    string7 = OpenEstateUtils.translateConst("APPROX", locale) + " " + string7 + " m\u00b2";
                } else if (((SimpleNumericAttrib)simpleAttrib).isLengthUnit()) {
                    string7 = OpenEstateUtils.translateConst("APPROX", locale) + " " + string7 + " m";
                } else if (((SimpleNumericAttrib)simpleAttrib).isVolumeUnit()) {
                    string7 = OpenEstateUtils.translateConst("APPROX", locale) + " " + string7 + " m\u00b3";
                } else if ("PREISE".equals(valueImpl.getGroupName()) && "HAUSGELD".equals(valueImpl.getAttribName())) {
                    string7 = OpenEstateUtils.translateConst("APPROX", locale) + " " + string7 + " " + currency.getSymbol();
                } else if (((SimpleNumericAttrib)simpleAttrib).isCurrencyUnit()) {
                    string7 = string7 + " " + currency.getSymbol();
                }
                return string7;
            }
            if (simpleAttrib instanceof SimpleBooleanAttrib) {
                if (Boolean.TRUE.equals(valueImpl.getValueObject(string))) {
                    return OpenEstateUtils.translateConst("YES", locale);
                }
                if (Boolean.FALSE.equals(valueImpl.getValueObject(string))) {
                    return OpenEstateUtils.translateConst("NO", locale);
                }
                return "";
            }
            if (simpleAttrib instanceof SimpleTimeAttrib) {
                if (((SimpleTimeAttrib)simpleAttrib).isDate()) {
                    return DateFormat.getDateInstance(2).format((Date)valueImpl.getValueObject(string));
                }
                if (((SimpleTimeAttrib)simpleAttrib).isTime()) {
                    return DateFormat.getTimeInstance(3).format((Date)valueImpl.getValueObject(string));
                }
                return DateFormat.getDateTimeInstance(2, 3).format((Date)valueImpl.getValueObject(string));
            }
            LOGGER.warn((Object)"unknown value-base-type!");
            LOGGER.warn((Object)("> " + simpleAttrib.getClass().getName()));
            LOGGER.warn((Object)("> " + valueImpl.getGroupName() + "." + valueImpl.getAttribName()));
            return "";
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not write value!");
            LOGGER.warn((Object)("> " + valueImpl.getGroupName() + "." + valueImpl.getAttribName()));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return "";
        }
    }
}

