/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.impl.attribs.ComplexAttrib;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class ComplexEnumAttrib
extends ComplexAttrib {
    private final List<String> attribOptions;

    public ComplexEnumAttrib(String string, String string2, String[] stringArray, String[] stringArray2) {
        super(string, string2, false, stringArray2);
        this.attribOptions = Arrays.asList(stringArray);
    }

    @Override
    public ValueImpl createValue(Object object) {
        ValueImpl valueImpl = new ValueImpl(this);
        valueImpl.setAttribName(this.getName());
        valueImpl.setGroupName(this.getGroup());
        String[] stringArray = null;
        stringArray = object != null ? (object instanceof String[] ? (String[])object : object.toString().split(",")) : null;
        valueImpl.setValue(stringArray);
        return valueImpl;
    }

    public String[] getOptions() {
        return this.attribOptions.toArray(new String[this.attribOptions.size()]);
    }

    @Override
    public Object getDefaultValue() {
        return new String[0];
    }

    @Override
    public void serializeNode(Element element, Object object) {
        String[] stringArray = (String[])object;
        List<String> list = Arrays.asList(stringArray);
        for (String string : this.attribOptions) {
            element.addAttribute(string, Boolean.valueOf(list.contains(string)).toString());
        }
    }

    @Override
    public String[] parseNode(Node node) throws ParseException {
        String string = node.getStringValue();
        if (string != null && this.attribOptions.contains(string)) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.attribOptions) {
            Node node2 = node.selectSingleNode("@" + string2);
            if (node2 == null || !Boolean.valueOf(node2.getStringValue()).equals(Boolean.TRUE)) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

