/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.attribs.SimpleAttrib;
import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.commons.lang.StringUtils;

public class SimpleNumericAttrib
extends SimpleAttrib {
    public static final String UNIT_AREA = "AREA";
    public static final String UNIT_CURRENCY = "CURRENCY";
    public static final String UNIT_LENGTH = "LENGTH";
    public static final String UNIT_VOLUME = "VOLUME";
    private Integer attribPrecision;
    private Long attribMaximum;
    private Long attribMinimum;
    private String attribUnit;
    private Boolean attribFormatted;

    public SimpleNumericAttrib(String string, String string2, Integer n, Boolean bl, String[] stringArray) {
        this(string, string2, n, null, null, bl, stringArray);
    }

    public SimpleNumericAttrib(String string, String string2, Integer n, Long l, Long l2, Boolean bl, String[] stringArray) {
        this(string, string2, n, l, l2, null, bl, stringArray);
    }

    public SimpleNumericAttrib(String string, String string2, Integer n, Long l, Long l2, String string3, Boolean bl, String[] stringArray) {
        super(string, string2, false, stringArray);
        this.attribPrecision = n;
        this.attribMaximum = l;
        this.attribMinimum = l2;
        this.attribUnit = string3;
        this.attribFormatted = bl;
    }

    @Override
    public Object getDefaultValue() {
        if (this.getPrecision() <= 0) {
            return 0L;
        }
        if (this.getPrecision() <= 4) {
            return Float.valueOf(0.0f);
        }
        return 0.0;
    }

    public Long getMaximum() {
        return this.attribMaximum;
    }

    public Long getMinimum() {
        return this.attribMinimum;
    }

    public NumberFormat getNumberFormat() {
        NumberFormat numberFormat;
        if (this.isCurrencyUnit()) {
            numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(2);
        } else {
            int n = this.getPrecision();
            numberFormat = n < 1 ? NumberFormat.getIntegerInstance() : NumberFormat.getNumberInstance();
            numberFormat.setGroupingUsed(this.isFormatted());
            if (n > 0) {
                numberFormat.setMaximumFractionDigits(n);
                numberFormat.setMinimumFractionDigits(0);
            }
        }
        return numberFormat;
    }

    public int getPrecision() {
        return this.attribPrecision != null ? this.attribPrecision : 0;
    }

    public String getUnit() {
        return this.attribUnit;
    }

    public boolean isAreaUnit() {
        return UNIT_AREA.equalsIgnoreCase(this.getUnit());
    }

    public boolean isCurrencyUnit() {
        return UNIT_CURRENCY.equalsIgnoreCase(this.getUnit());
    }

    public boolean isFormatted() {
        return !Boolean.FALSE.equals(this.attribFormatted);
    }

    public boolean isLengthUnit() {
        return UNIT_LENGTH.equalsIgnoreCase(this.getUnit());
    }

    public boolean isVolumeUnit() {
        return UNIT_VOLUME.equalsIgnoreCase(this.getUnit());
    }

    @Override
    public Object parseValue(String string) throws ParseException {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        if (string.contains(",") && !string.contains(".")) {
            string = StringUtils.replace((String)string, (String)",", (String)".");
        }
        if (this.getPrecision() < 1) {
            return Float.valueOf(string).longValue();
        }
        if (this.getPrecision() < 5) {
            return Float.valueOf(string);
        }
        return Double.valueOf(string);
    }

    @Override
    public String serializeValue(Object object) {
        return object != null ? object.toString() : "";
    }
}

