/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.SimpleAttrib;
import java.text.ParseException;

public class SimpleStringAttrib
extends SimpleAttrib {
    private final int attribMaxLength;

    public SimpleStringAttrib(String string, String string2, int n, String[] stringArray) {
        super(string, string2, true, stringArray);
        this.attribMaxLength = n > 0 ? n : 0;
    }

    @Override
    public Object getDefaultValue() {
        return "";
    }

    public int getMaxLength() {
        return this.attribMaxLength;
    }

    public boolean isString() {
        return this.getMaxLength() > 0 && this.getMaxLength() < 256;
    }

    public boolean isText() {
        return !this.isString();
    }

    @Override
    public Object parseValue(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        String string2 = OpenEstateUtils.parseString(string);
        int n = this.getMaxLength();
        if (n > 0 && string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    @Override
    public String serializeValue(Object object) {
        return this.serializeValue(object, OpenEstateUtils.getSerializationLineBreak());
    }

    public String serializeValue(Object object, String string) {
        String string2 = object != null ? object.toString() : "";
        int n = this.getMaxLength();
        if (n > 0 && string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        return OpenEstateUtils.serializeString(string2, string);
    }
}

