/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.SimpleAttrib;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class SimpleTimeAttrib
extends SimpleAttrib {
    public static final int TYPE_DATE = 0;
    public static final int TYPE_TIME = 1;
    public static final int TYPE_DATETIME = 2;
    private final int attribType;

    public SimpleTimeAttrib(String string, String string2, int n, String[] stringArray) {
        super(string, string2, false, stringArray);
        this.attribType = n;
    }

    @Override
    public Object getDefaultValue() {
        return new Date();
    }

    public int getType() {
        return this.attribType;
    }

    public boolean isDate() {
        return this.getType() == 0;
    }

    public boolean isDateTime() {
        return this.getType() == 2;
    }

    public boolean isTime() {
        return this.getType() == 1;
    }

    @Override
    public Object parseValue(String string) throws ParseException {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.isDate()) {
            return OpenEstateUtils.parseDate(string);
        }
        if (this.isTime()) {
            return OpenEstateUtils.parseTime(string);
        }
        if (this.isDateTime()) {
            return OpenEstateUtils.parseDateTime(string);
        }
        return null;
    }

    @Override
    public String serializeValue(Object object) {
        Date date = null;
        if (object instanceof Date) {
            date = (Date)object;
        } else if (object instanceof Calendar) {
            date = ((Calendar)object).getTime();
        } else {
            return "";
        }
        if (this.isDate()) {
            return OpenEstateUtils.getXsdDateFormat().format(date);
        }
        if (this.isTime()) {
            return OpenEstateUtils.getXsdTimeFormat().format(date);
        }
        if (this.isDateTime()) {
            return OpenEstateUtils.getXsdDateTimeFormat().format(date);
        }
        return "";
    }
}

