/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateConverter;
import com.openindex.openestate.impl.SerializableXmlElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;

public abstract class CSVReader
extends OpenEstateConverter {
    private static final Logger LOGGER = Logger.getLogger(CSVReader.class);

    public AgentContactImpl createEmptyContact() {
        return new AgentContactImpl();
    }

    public EstateImpl createEmptyEstate() {
        return new EstateImpl();
    }

    public static char getChar(int n, String[] stringArray) {
        return CSVReader.getChar(n, stringArray, '-');
    }

    public static char getChar(int n, String[] stringArray, char c) {
        if (n < 0 || stringArray.length <= n) {
            return c;
        }
        String string = stringArray[n];
        if (string.trim().length() <= 0) {
            return c;
        }
        return string.toUpperCase().trim().toCharArray()[0];
    }

    public String getCharset() {
        return Charset.defaultCharset().name();
    }

    public static Float getFloat(int n, String[] stringArray) {
        return CSVReader.getFloat(n, stringArray, null);
    }

    public static Float getFloat(int n, String[] stringArray, Float f) {
        try {
            if (n < 0 || stringArray.length <= n) {
                return f;
            }
            String string = stringArray[n].replace(',', '.');
            if (string.startsWith(".")) {
                string = "0" + string;
            }
            if (string.trim().length() <= 0) {
                return f;
            }
            return Float.valueOf(Double.valueOf(string.trim()).floatValue());
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("could not parse integer at field " + n));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
            return f;
        }
    }

    public static Integer getInt(int n, String[] stringArray) {
        return CSVReader.getInt(n, stringArray, null);
    }

    public static Integer getInt(int n, String[] stringArray, Integer n2) {
        try {
            if (n < 0 || stringArray.length <= n) {
                return n2;
            }
            String string = stringArray[n];
            if (string.trim().length() <= 0) {
                return n2;
            }
            return Double.valueOf(string.trim()).intValue();
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("could not parse integer at field " + n));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
            return n2;
        }
    }

    public static Long getLong(int n, String[] stringArray) {
        return CSVReader.getLong(n, stringArray, null);
    }

    public static Long getLong(int n, String[] stringArray, Long l) {
        try {
            if (n < 0 || stringArray.length <= n) {
                return l;
            }
            String string = stringArray[n];
            if (string.trim().length() <= 0) {
                return l;
            }
            return Double.valueOf(string.trim()).longValue();
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("could not parse integer at field " + n));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
            return l;
        }
    }

    public static String getString(int n, String[] stringArray) {
        return CSVReader.getString(n, stringArray, null);
    }

    public static String getString(int n, String[] stringArray, String string) {
        try {
            if (n < 0 || stringArray.length <= n) {
                return string;
            }
            String string2 = stringArray[n];
            if (string2.trim().length() <= 0) {
                return string;
            }
            return string2.replaceAll("<br>", SystemUtils.LINE_SEPARATOR).trim();
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("could not parse integer at field " + n));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
            return string;
        }
    }

    public void read(File file, SerializableXmlElement serializableXmlElement) throws IOException {
        this.read(file, serializableXmlElement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file, SerializableXmlElement serializableXmlElement, String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.read(fileInputStream, serializableXmlElement, string);
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    public void read(InputStream inputStream, SerializableXmlElement serializableXmlElement) throws IOException {
        this.read(inputStream, serializableXmlElement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream inputStream, SerializableXmlElement serializableXmlElement, String string) throws IOException {
        Reader reader = null;
        try {
            reader = new InputStreamReader(inputStream, string != null ? string : this.getCharset());
            this.read(reader, serializableXmlElement);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Reader reader, SerializableXmlElement serializableXmlElement) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(reader);
            String string = bufferedReader.readLine();
            while (string != null) {
                if (StringUtils.isBlank((String)string)) continue;
                try {
                    this.readLine(string, serializableXmlElement);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't read csv-line!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                finally {
                    string = bufferedReader.readLine();
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public abstract void readLine(String var1, SerializableXmlElement var2);
}

