/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.idx;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.csv.CSVReader;
import com.openindex.openestate.impl.csv.idx.IDXCSVSchema;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IDXCSVReader
extends CSVReader {
    private static final Logger LOGGER = Logger.getLogger(IDXCSVReader.class);
    private static final IDXCSVSchema SCHEMA = new IDXCSVSchema();

    @Override
    public String getCharset() {
        return SCHEMA.getEncoding();
    }

    protected boolean readEstate(IDXCSVSchema iDXCSVSchema, String[] stringArray, EstateImpl estateImpl) {
        try {
            iDXCSVSchema.readEstate(this, stringArray, estateImpl);
            return true;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read estate!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return false;
        }
    }

    @Override
    public void readLine(String string, SerializableXmlElement serializableXmlElement) {
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        if (!(serializableXmlElement instanceof TransferImpl) && !(serializableXmlElement instanceof AgencyImpl)) {
            throw new IllegalArgumentException("invalid destination-class!");
        }
        String string2 = string.replaceAll(Pattern.quote("##"), "# #");
        String[] stringArray = string2.concat(" ").split(Pattern.quote("#"), 183);
        if (stringArray.length != 183) {
            throw new IllegalArgumentException("invalid field-count (" + stringArray.length + "!=" + 183 + ")!");
        }
        String[] stringArray2 = new String[183];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].trim();
        }
        if (serializableXmlElement instanceof TransferImpl) {
            this.readLineValues(SCHEMA, stringArray2, (TransferImpl)serializableXmlElement);
        } else if (serializableXmlElement instanceof AgencyImpl) {
            this.readLineValues(SCHEMA, stringArray2, (AgencyImpl)serializableXmlElement);
        }
    }

    protected void readLineValues(IDXCSVSchema iDXCSVSchema, String[] stringArray, AgencyImpl agencyImpl) {
        if (agencyImpl.getAgent() == null) {
            throw new NullPointerException("no agent defined in agency!");
        }
        iDXCSVSchema.readAgent(this, stringArray, agencyImpl.getAgent());
        AgentContactImpl agentContactImpl = this.createEmptyContact();
        iDXCSVSchema.readAgentContact(this, stringArray, agentContactImpl);
        agentContactImpl.setId("NewContact." + (agencyImpl.getContacts().size() + 1));
        agencyImpl.getContacts().put(agentContactImpl.getId(), agentContactImpl);
        EstateImpl estateImpl = this.createEmptyEstate();
        if (!this.readEstate(iDXCSVSchema, stringArray, estateImpl)) {
            return;
        }
        estateImpl.setId("NewEstate." + (agencyImpl.getEstates().size() + 1));
        agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
    }

    protected void readLineValues(IDXCSVSchema iDXCSVSchema, String[] stringArray, TransferImpl transferImpl) {
        AgentImpl agentImpl = new AgentImpl();
        iDXCSVSchema.readAgent(this, stringArray, agentImpl);
        String string = agentImpl.getId();
        if (StringUtils.isEmpty((String)string)) {
            LOGGER.warn((Object)"Anbieter-ID konnte nicht ermittelt werden!");
            string = "Agency.0";
            agentImpl.setId(string);
        }
        for (TransferAgencyImpl transferAgencyImpl : transferImpl.getAgencies()) {
            if (!string.equalsIgnoreCase(transferAgencyImpl.getAgent().getId())) continue;
            this.readLineValues(iDXCSVSchema, stringArray, transferAgencyImpl);
            return;
        }
        TransferAgencyImpl transferAgencyImpl = new TransferAgencyImpl();
        transferAgencyImpl.setAgent(agentImpl);
        this.readLineValues(iDXCSVSchema, stringArray, transferAgencyImpl);
        transferImpl.getAgencies().add(transferAgencyImpl);
    }

    protected void readLineValues(IDXCSVSchema iDXCSVSchema, String[] stringArray, TransferAgencyImpl transferAgencyImpl) {
        if (transferAgencyImpl.getAgent() == null) {
            throw new NullPointerException("no agent defined in agency!");
        }
        AgentContactImpl agentContactImpl = this.createEmptyContact();
        iDXCSVSchema.readAgentContact(this, stringArray, agentContactImpl);
        agentContactImpl.setId("NewContact." + (transferAgencyImpl.getContacts().size() + 1));
        transferAgencyImpl.getContacts().put(agentContactImpl.getId(), agentContactImpl);
        EstateImpl estateImpl = this.createEmptyEstate();
        if (!this.readEstate(iDXCSVSchema, stringArray, estateImpl)) {
            return;
        }
        estateImpl.setId("NewEstate." + (transferAgencyImpl.getEstatesToSave().size() + 1));
        estateImpl.setContactId(agentContactImpl.getId());
        transferAgencyImpl.getEstatesToSave().add(estateImpl);
    }
}

