/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.idx;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.CompanyAdressImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.csv.CSVReader;
import com.openindex.openestate.impl.csv.CSVSchema;
import com.openindex.openestate.impl.csv.idx.IDXCSVReader;
import com.openindex.openestate.impl.csv.idx.IDXCSVWriter;
import java.lang.constant.Constable;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IDXCSVSchema
extends CSVSchema {
    private static final Logger LOGGER = Logger.getLogger(IDXCSVSchema.class);
    public static final String CSV_VERSION = "3.01";
    public static final String CSV_ENCODING = "ISO-8859-1";
    public static final String CSV_LINE_SEPARATOR = "\r\n";
    public static final String CSV_FIELD_SEPARATOR = "#";
    public static final int CSV_FIELD_COUNT = 183;
    public static final char YES = 'Y';
    public static final char NO = 'N';
    public static final String ATTACH_SUFFIX_AVI = ".avi";
    public static final String ATTACH_SUFFIX_DOC = ".doc";
    public static final String ATTACH_SUFFIX_FLV = ".flv";
    public static final String ATTACH_SUFFIX_GIF = ".gif";
    public static final String ATTACH_SUFFIX_JPG = ".jpg";
    public static final String ATTACH_SUFFIX_JPEG = ".jpeg";
    public static final String ATTACH_SUFFIX_MP4 = ".mp4";
    public static final String ATTACH_SUFFIX_MPG = ".mpg";
    public static final String ATTACH_SUFFIX_MPEG = ".mpeg";
    public static final String ATTACH_SUFFIX_MOV = ".mov";
    public static final String ATTACH_SUFFIX_PDF = ".pdf";
    public static final String ATTACH_SUFFIX_RPM = ".rpm";
    public static final String ATTACH_SUFFIX_RTF = ".rtf";
    public static final String ATTACH_SUFFIX_WMV = ".wmv";
    public static final int FIELD_VERSION = 0;
    public static final String VERSION_3_01 = "IDX3.01";
    public static final int FIELD_SENDER_ID = 1;
    public static final int FIELD_OBJECT_CATEGORY = 2;
    public static final String OBJECT_CATEGORY_AGRI = "AGRI";
    public static final String OBJECT_CATEGORY_APPT = "APPT";
    public static final String OBJECT_CATEGORY_GASTRO = "GASTRO";
    public static final String OBJECT_CATEGORY_HOUSE = "HOUSE";
    public static final String OBJECT_CATEGORY_INDUS = "INDUS";
    public static final String OBJECT_CATEGORY_PARK = "PARK";
    public static final String OBJECT_CATEGORY_PROP = "PROP";
    public static final String OBJECT_CATEGORY_SECONDARY = "SECONDARY";
    public static final String OBJECT_CATEGORY_GARDEN = "GARDEN";
    public static final int FIELD_OBJECT_TYPE = 3;
    public static final int OBJECT_TYPE_AGRI_GENERAL = 1;
    public static final int OBJECT_TYPE_AGRI_ALPINE = 2;
    public static final int OBJECT_TYPE_AGRI_FARM = 3;
    public static final int OBJECT_TYPE_APPT_GENERAL = 1;
    public static final int OBJECT_TYPE_APPT_DUPLEX = 2;
    public static final int OBJECT_TYPE_APPT_ATTIC_FLAT = 3;
    public static final int OBJECT_TYPE_APPT_ROOF_FLAT = 4;
    public static final int OBJECT_TYPE_APPT_STUDIO = 5;
    public static final int OBJECT_TYPE_APPT_SINGLE_ROOM = 6;
    public static final int OBJECT_TYPE_APPT_FURNISHED_FLAT = 7;
    public static final int OBJECT_TYPE_APPT_TERRACE_FLAT = 8;
    public static final int OBJECT_TYPE_APPT_BACHERLOR_FLAT = 9;
    public static final int OBJECT_TYPE_APPT_LOFT = 10;
    public static final int OBJECT_TYPE_APPT_ATTIC = 11;
    public static final int OBJECT_TYPE_GARDEN_GENERAL = 1;
    public static final int OBJECT_TYPE_GASTRO_HOTEL = 1;
    public static final int OBJECT_TYPE_GASTRO_RESTAURANT = 2;
    public static final int OBJECT_TYPE_GASTRO_CAFE = 3;
    public static final int OBJECT_TYPE_GASTRO_BAR = 4;
    public static final int OBJECT_TYPE_GASTRO_CLUB_DISCO = 5;
    public static final int OBJECT_TYPE_GASTRO_CASINO = 6;
    public static final int OBJECT_TYPE_GASTRO_CINEMA_THEATRE = 7;
    public static final int OBJECT_TYPE_GASTRO_SQUASH_BADMINTON = 8;
    public static final int OBJECT_TYPE_GASTRO_INDOOR_TENNIS = 9;
    public static final int OBJECT_TYPE_GASTRO_OUTDOOR_TENNIS = 10;
    public static final int OBJECT_TYPE_GASTRO_SPORTS_HALL = 11;
    public static final int OBJECT_TYPE_GASTRO_CAMPING = 12;
    public static final int OBJECT_TYPE_GASTRO_OUTDOOR_SWIMMING = 13;
    public static final int OBJECT_TYPE_GASTRO_INDOOR_SWIMMING = 14;
    public static final int OBJECT_TYPE_GASTRO_GOLF = 15;
    public static final int OBJECT_TYPE_GASTRO_MOTEL = 16;
    public static final int OBJECT_TYPE_GASTRO_PUB = 17;
    public static final int OBJECT_TYPE_HOUSE_SINGLE_FAMILY = 1;
    public static final int OBJECT_TYPE_HOUSE_ROW = 2;
    public static final int OBJECT_TYPE_HOUSE_DUPLEX = 3;
    public static final int OBJECT_TYPE_HOUSE_TERRACE = 4;
    public static final int OBJECT_TYPE_HOUSE_VILLA = 5;
    public static final int OBJECT_TYPE_HOUSE_FARM = 6;
    public static final int OBJECT_TYPE_HOUSE_MULTI_FAMILY = 7;
    public static final int OBJECT_TYPE_HOUSE_CAVE_HOUSE = 9;
    public static final int OBJECT_TYPE_HOUSE_CASTLE = 10;
    public static final int OBJECT_TYPE_HOUSE_GRANNY_FLAT = 11;
    public static final int OBJECT_TYPE_HOUSE_CHALET = 12;
    public static final int OBJECT_TYPE_HOUSE_RUSTICO = 13;
    public static final int OBJECT_TYPE_INDUS_OFFICE = 1;
    public static final int OBJECT_TYPE_INDUS_SHOP = 2;
    public static final int OBJECT_TYPE_INDUS_ADVERTISING = 3;
    public static final int OBJECT_TYPE_INDUS_COMMERCIAL = 4;
    public static final int OBJECT_TYPE_INDUS_STORAGE = 5;
    public static final int OBJECT_TYPE_INDUS_SURGERY = 6;
    public static final int OBJECT_TYPE_INDUS_KIOSK = 7;
    public static final int OBJECT_TYPE_INDUS_GARDENING = 8;
    public static final int OBJECT_TYPE_INDUS_FUEL_STATION = 9;
    public static final int OBJECT_TYPE_INDUS_GARAGE = 10;
    public static final int OBJECT_TYPE_INDUS_CHEESE_FACTORY = 11;
    public static final int OBJECT_TYPE_INDUS_BUTCHER = 12;
    public static final int OBJECT_TYPE_INDUS_BAKERY = 13;
    public static final int OBJECT_TYPE_INDUS_HAIRDRESSER = 14;
    public static final int OBJECT_TYPE_INDUS_SHOPPING_CENTRE = 15;
    public static final int OBJECT_TYPE_INDUS_FACTORY = 16;
    public static final int OBJECT_TYPE_INDUS_INDUSTRY = 17;
    public static final int OBJECT_TYPE_INDUS_ARCADE = 18;
    public static final int OBJECT_TYPE_INDUS_ATELIER = 19;
    public static final int OBJECT_TYPE_INDUS_LIVING_COMMERCIAL = 20;
    public static final int OBJECT_TYPE_INDUS_LIBRARY = 21;
    public static final int OBJECT_TYPE_INDUS_HOSPITAL = 22;
    public static final int OBJECT_TYPE_INDUS_LABORATORY = 23;
    public static final int OBJECT_TYPE_INDUS_MINI_GOLF = 24;
    public static final int OBJECT_TYPE_INDUS_NURSING = 25;
    public static final int OBJECT_TYPE_INDUS_RIDING_HALL = 26;
    public static final int OBJECT_TYPE_INDUS_SANATORIUM = 27;
    public static final int OBJECT_TYPE_INDUS_WORKSHOP = 28;
    public static final int OBJECT_TYPE_INDUS_PARTY_ROOM = 29;
    public static final int OBJECT_TYPE_INDUS_SAUNA = 30;
    public static final int OBJECT_TYPE_INDUS_SOLARIUM = 31;
    public static final int OBJECT_TYPE_INDUS_CARPENTRY = 32;
    public static final int OBJECT_TYPE_INDUS_OLD_AGE_HOME = 33;
    public static final int OBJECT_TYPE_INDUS_DEPARTMENT_STORE = 34;
    public static final int OBJECT_TYPE_INDUS_HOME = 35;
    public static final int OBJECT_TYPE_INDUS_DISPLAY_WINDOW = 36;
    public static final int OBJECT_TYPE_INDUS_PARKING_GARAGE = 37;
    public static final int OBJECT_TYPE_INDUS_PARKING_SURFACE = 38;
    public static final int OBJECT_TYPE_PARK_OPEN_SLOT = 1;
    public static final int OBJECT_TYPE_PARK_COVERED_SLOT = 2;
    public static final int OBJECT_TYPE_PARK_SINGLE_GARAGE = 3;
    public static final int OBJECT_TYPE_PARK_DOUBLE_GARAGE = 4;
    public static final int OBJECT_TYPE_PARK_UNDERGROUND_SLOT = 5;
    public static final int OBJECT_TYPE_PARK_BOAT_DRY_DOCK = 7;
    public static final int OBJECT_TYPE_PARK_BOAT_LANDING_STAGE = 8;
    public static final int OBJECT_TYPE_PARK_BIKE_INDOOR = 9;
    public static final int OBJECT_TYPE_PARK_BIKE_OUTDOOR = 10;
    public static final int OBJECT_TYPE_PARK_HORSE_BOX = 11;
    public static final int OBJECT_TYPE_PARK_BOAT_MOORING = 12;
    public static final int OBJECT_TYPE_PROP_BUILDING = 1;
    public static final int OBJECT_TYPE_PROP_AGRICULTURAL = 2;
    public static final int OBJECT_TYPE_PROP_COMMERCIAL = 3;
    public static final int OBJECT_TYPE_PROP_INDUSTRIAL = 4;
    public static final int OBJECT_TYPE_SECONDARY_HOBBY_ROOM = 0;
    public static final int OBJECT_TYPE_SECONDARY_CELLAR_PART = 1;
    public static final int OBJECT_TYPE_SECONDARY_ATTIC_COMPARTMENT = 2;
    public static final int FIELD_OFFER_TYPE = 4;
    public static final String OFFER_TYPE_RENT = "RENT";
    public static final String OFFER_TYPE_SALE = "SALE";
    public static final int FIELD_REF_PROPERTY = 5;
    public static final int FIELD_REF_HOUSE = 6;
    public static final int FIELD_REF_OBJECT = 7;
    public static final int FIELD_OBJECT_STREET = 8;
    public static final int FIELD_OBJECT_ZIP = 9;
    public static final int FIELD_OBJECT_CITY = 10;
    public static final int FIELD_OBJECT_STATE = 11;
    public static final int FIELD_OBJECT_COUNTRY = 12;
    public static final int FIELD_OBJECT_SITUATION = 14;
    public static final int FIELD_AVAILABLE_FROM = 15;
    public static final int FIELD_OBJECT_TITLE = 16;
    public static final int FIELD_OBJECT_DESCRIPTION = 17;
    public static final int FIELD_SELLING_PRICE = 18;
    public static final int FIELD_RENT_NET = 19;
    public static final int FIELD_RENT_EXTRA = 20;
    public static final int FIELD_PRICE_UNIT = 21;
    public static final String PRICE_UNIT_SELL = "SELL";
    public static final String PRICE_UNIT_SELLM2 = "SELLM2";
    public static final String PRICE_UNIT_YEARLY = "YEARLY";
    public static final String PRICE_UNIT_M2YEARLY = "M2YEARLY";
    public static final String PRICE_UNIT_MONTHLY = "MONTHLY";
    public static final String PRICE_UNIT_WEEKLY = "WEEKLY";
    public static final String PRICE_UNIT_DAILY = "DAILY";
    public static final int FIELD_CURRENCY = 22;
    public static final int FIELD_GROSS_PREMIUM = 23;
    public static final String GROSS_PREMIUM_2_3 = "2-3";
    public static final String GROSS_PREMIUM_3_4 = "3-4";
    public static final String GROSS_PREMIUM_4_5 = "4-5";
    public static final String GROSS_PREMIUM_5_6 = "5-6";
    public static final String GROSS_PREMIUM_6_7 = "6-7";
    public static final String GROSS_PREMIUM_7_8 = "7-8";
    public static final String GROSS_PREMIUM_8_PLUS = "8+";
    public static final int FIELD_FLOOR = 24;
    public static final int FIELD_COUNT_ROOMS = 25;
    public static final int FIELD_COUNT_APARTMENTS = 26;
    public static final int FIELD_AREA_LIVING = 27;
    public static final int FIELD_AREA_PROPERTY = 28;
    public static final int FIELD_AREA_USABLE = 29;
    public static final int FIELD_VOLUME = 30;
    public static final int FIELD_YEAR_OF_BUILDING = 31;
    public static final int FIELD_HAS_VIEW = 32;
    public static final int FIELD_HAS_FIREPLACE = 33;
    public static final int FIELD_HAS_CABLETV = 34;
    public static final int FIELD_HAS_ELEVATOR = 35;
    public static final int FIELD_IS_CHILD_FRIENDLY = 36;
    public static final int FIELD_HAS_PARKING = 37;
    public static final int FIELD_HAS_GARAGE = 38;
    public static final int FIELD_HAS_BALCONY = 39;
    public static final int FIELD_DISTANCE_TO_PUBLIC_TRANSPORT = 41;
    public static final int FIELD_DISTANCE_TO_SHOPPING = 42;
    public static final int FIELD_DISTANCE_TO_KINDERGARDEN = 43;
    public static final int FIELD_DISTANCE_TO_SCHOOL1 = 44;
    public static final int FIELD_DISTANCE_TO_SCHOOL2 = 45;
    public static final int FIELD_PICTURE_1_FILE = 46;
    public static final int FIELD_PICTURE_1_TITLE = 51;
    public static final int FIELD_PICTURE_1_TEXT = 56;
    public static final int FIELD_PICTURE_1_URL = 99;
    public static final int FIELD_PICTURE_2_FILE = 47;
    public static final int FIELD_PICTURE_2_TITLE = 52;
    public static final int FIELD_PICTURE_2_TEXT = 57;
    public static final int FIELD_PICTURE_2_URL = 100;
    public static final int FIELD_PICTURE_3_FILE = 48;
    public static final int FIELD_PICTURE_3_TITLE = 53;
    public static final int FIELD_PICTURE_3_TEXT = 58;
    public static final int FIELD_PICTURE_3_URL = 101;
    public static final int FIELD_PICTURE_4_FILE = 49;
    public static final int FIELD_PICTURE_4_TITLE = 54;
    public static final int FIELD_PICTURE_4_TEXT = 59;
    public static final int FIELD_PICTURE_4_URL = 102;
    public static final int FIELD_PICTURE_5_FILE = 50;
    public static final int FIELD_PICTURE_5_TITLE = 55;
    public static final int FIELD_PICTURE_5_TEXT = 60;
    public static final int FIELD_PICTURE_5_URL = 103;
    public static final int FIELD_PICTURE_6_FILE = 87;
    public static final int FIELD_PICTURE_6_TITLE = 91;
    public static final int FIELD_PICTURE_6_TEXT = 95;
    public static final int FIELD_PICTURE_6_URL = 104;
    public static final int FIELD_PICTURE_7_FILE = 88;
    public static final int FIELD_PICTURE_7_TITLE = 92;
    public static final int FIELD_PICTURE_7_TEXT = 96;
    public static final int FIELD_PICTURE_7_URL = 105;
    public static final int FIELD_PICTURE_8_FILE = 89;
    public static final int FIELD_PICTURE_8_TITLE = 93;
    public static final int FIELD_PICTURE_8_TEXT = 97;
    public static final int FIELD_PICTURE_8_URL = 106;
    public static final int FIELD_PICTURE_9_FILE = 90;
    public static final int FIELD_PICTURE_9_TITLE = 94;
    public static final int FIELD_PICTURE_9_TEXT = 98;
    public static final int FIELD_PICTURE_9_URL = 107;
    public static final int FIELD_PICTURE_10_FILE = 142;
    public static final int FIELD_PICTURE_10_TITLE = 146;
    public static final int FIELD_PICTURE_10_TEXT = 150;
    public static final int FIELD_PICTURE_10_URL = 154;
    public static final int FIELD_PICTURE_11_FILE = 143;
    public static final int FIELD_PICTURE_11_TITLE = 147;
    public static final int FIELD_PICTURE_11_TEXT = 151;
    public static final int FIELD_PICTURE_11_URL = 155;
    public static final int FIELD_PICTURE_12_FILE = 144;
    public static final int FIELD_PICTURE_12_TITLE = 148;
    public static final int FIELD_PICTURE_12_TEXT = 152;
    public static final int FIELD_PICTURE_12_URL = 156;
    public static final int FIELD_PICTURE_13_FILE = 145;
    public static final int FIELD_PICTURE_13_TITLE = 149;
    public static final int FIELD_PICTURE_13_TEXT = 153;
    public static final int FIELD_PICTURE_13_URL = 157;
    public static final int FIELD_MOVIE_FILE = 61;
    public static final int FIELD_MOVIE_TITLE = 62;
    public static final int FIELD_DOCUMENT_FILE = 64;
    public static final int FIELD_DOCUMENT_TITLE = 65;
    public static final int FIELD_URL = 67;
    public static final int FIELD_AGENCY_ID = 68;
    public static final int FIELD_AGENCY_NAME = 69;
    public static final int FIELD_AGENCY_NAME2 = 70;
    public static final int FIELD_AGENCY_REFERENCE = 71;
    public static final int FIELD_AGENCY_STREET = 72;
    public static final int FIELD_AGENCY_ZIP = 73;
    public static final int FIELD_AGENCY_CITY = 74;
    public static final int FIELD_AGENCY_COUNTRY = 75;
    public static final int FIELD_AGENCY_PHONE = 76;
    public static final int FIELD_AGENCY_FAX = 78;
    public static final int FIELD_AGENCY_EMAIL = 79;
    public static final int FIELD_VISIT_NAME = 81;
    public static final int FIELD_VISIT_PHONE = 82;
    public static final int FIELD_VISIT_REMARK = 84;
    public static final int FIELD_DISTANCE_TO_MOTORWAY = 108;
    public static final int FIELD_CEILING_HEIGHT = 109;
    public static final int FIELD_HALL_HEIGHT = 110;
    public static final int FIELD_MAX_FLOOR_LOADING = 111;
    public static final int FIELD_MAX_CRANE_LOADING = 112;
    public static final int FIELD_MAX_ELEVATOR_LOADING = 113;
    public static final int FIELD_HAS_ISDN = 114;
    public static final int FIELD_IS_WHEELCHAIR_ACCESSIBLE = 115;
    public static final int FIELD_IS_ANIMALS_ALLOWED = 116;
    public static final int FIELD_HAS_RAMP = 117;
    public static final int FIELD_HAS_LIFTING_PLATFORM = 118;
    public static final int FIELD_HAS_RAILWAY_ACCESS = 119;
    public static final int FIELD_HAS_RESTROOM = 120;
    public static final int FIELD_HAS_WATER_SUPPLY = 121;
    public static final int FIELD_HAS_SEWAGE_SUPPLY = 122;
    public static final int FIELD_HAS_POWER_SUPPLY = 123;
    public static final int FIELD_HAS_GAS_SUPPLY = 124;
    public static final int FIELD_HOMEGATE_URL = 126;
    public static final int FIELD_HOMEGATE_BILLING_SALUTATION = 127;
    public static final int HOMEGATE_BILLING_SALUTATION_FEMALE = 1;
    public static final int HOMEGATE_BILLING_SALUTATION_MALE = 2;
    public static final int HOMEGATE_BILLING_SALUTATION_COMPANY = 3;
    public static final int FIELD_HOMEGATE_BILLING_FIRSTNAME = 128;
    public static final int FIELD_HOMEGATE_BILLING_LASTNAME = 129;
    public static final int FIELD_HOMEGATE_BILLING_COMPANY = 130;
    public static final int FIELD_HOMEGATE_BILLING_STREET = 131;
    public static final int FIELD_HOMEGATE_BILLING_STREET2 = 132;
    public static final int FIELD_HOMEGATE_BILLING_ZIP = 133;
    public static final int FIELD_HOMEGATE_BILLING_CITY = 134;
    public static final int FIELD_HOMEGATE_BILLING_COUNTRY = 135;
    public static final int FIELD_HOMEGATE_BILLING_PHONE = 136;
    public static final int FIELD_HOMEGATE_BILLING_PHONE2 = 137;
    public static final int FIELD_HOMEGATE_BILLING_MOBILE = 138;
    public static final int FIELD_HOMEGATE_BILLING_LANGUAGE = 139;
    public static final int HOMEGATE_BILLING_LANGUAGE_GERMAN = 1;
    public static final int HOMEGATE_BILLING_LANGUAGE_FRENCH = 2;
    public static final int HOMEGATE_BILLING_LANGUAGE_ITALIAN = 3;
    public static final int HOMEGATE_BILLING_LANGUAGE_ENGLISH = 4;
    public static final int FIELD_PUBLISHING_ID = 140;
    public static final int FIELD_DELIVERY_ID = 141;
    public static final int FIELD_COUNT_FLOORS = 162;
    public static final int FIELD_YEAR_OF_RENOVATION = 163;
    public static final int FIELD_IS_FLAT_SHARE = 164;
    public static final int FIELD_IS_CORNER_HOUSE = 165;
    public static final int FIELD_IS_MIDDLE_HOUSE = 166;
    public static final int FIELD_IS_PARCEL_INCLUDED = 167;
    public static final int FIELD_HAS_GARDENHOUSE = 168;
    public static final int FIELD_IS_RAISED_GROUND = 169;
    public static final int FIELD_IS_NEW_BUILDING = 170;
    public static final int FIELD_IS_OLD_BUILDING = 171;
    public static final int FIELD_IS_UNDER_BUILDING_LAWS = 172;
    public static final int FIELD_IS_UNDER_ROOF = 173;
    public static final int FIELD_HAS_SWIMMINGPOOL = 174;
    public static final int FIELD_FITS_ENERGY_STANDARDS = 175;
    public static final int FIELD_HAS_ENERGY_CERTIFICATION = 176;
    public static final int FIELD_LAST_MODIFICATION = 177;
    public static final int FIELD_ADVERTISEMENT_ID = 178;

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat("dd.MM.yyyy");
    }

    public static DateFormat getDateTimeFormat() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    }

    @Override
    public String getEncoding() {
        return CSV_ENCODING;
    }

    @Override
    public int getFieldCount() {
        return 183;
    }

    @Override
    public String getFieldSeparator() {
        return CSV_FIELD_SEPARATOR;
    }

    @Override
    public String getLineSeparator() {
        return CSV_LINE_SEPARATOR;
    }

    @Override
    public String getVersion() {
        return CSV_VERSION;
    }

    public static boolean isDocument(String string) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        String string2 = string.toLowerCase().trim();
        return string2.endsWith(ATTACH_SUFFIX_PDF) || string2.endsWith(ATTACH_SUFFIX_RTF) || string2.endsWith(ATTACH_SUFFIX_DOC);
    }

    public static boolean isImage(String string) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        String string2 = string.toLowerCase().trim();
        return string2.endsWith(ATTACH_SUFFIX_JPEG) || string2.endsWith(ATTACH_SUFFIX_JPG) || string2.endsWith(ATTACH_SUFFIX_GIF);
    }

    public static boolean isMovie(String string) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        String string2 = string.toLowerCase().trim();
        return string2.endsWith(ATTACH_SUFFIX_MOV) || string2.endsWith(ATTACH_SUFFIX_AVI) || string2.endsWith(ATTACH_SUFFIX_RPM) || string2.endsWith(ATTACH_SUFFIX_MPG) || string2.endsWith(ATTACH_SUFFIX_MPEG) || string2.endsWith(ATTACH_SUFFIX_WMV) || string2.endsWith(ATTACH_SUFFIX_MP4) || string2.endsWith(ATTACH_SUFFIX_FLV);
    }

    public void readAgent(IDXCSVReader iDXCSVReader, String[] stringArray, AgentImpl agentImpl) {
        agentImpl.setId(CSVReader.getString(68, stringArray));
        if (agentImpl.getCompany() == null) {
            agentImpl.setCompany(new CompanyAdressImpl());
        }
        agentImpl.getCompany().setCompanyName(CSVReader.getString(69, stringArray));
        agentImpl.getCompany().setCompanyNameAddition(CSVReader.getString(70, stringArray));
    }

    public void readAgentContact(IDXCSVReader iDXCSVReader, String[] stringArray, AgentContactImpl agentContactImpl) {
        agentContactImpl.setPersonLastName(CSVReader.getString(71, stringArray));
        agentContactImpl.setStreet(CSVReader.getString(72, stringArray));
        agentContactImpl.setPostalCode(CSVReader.getString(73, stringArray));
        agentContactImpl.setCity(CSVReader.getString(74, stringArray));
        agentContactImpl.setPersonPhone(CSVReader.getString(76, stringArray));
        agentContactImpl.setPersonFax(CSVReader.getString(78, stringArray));
        agentContactImpl.setPersonMail(CSVReader.getString(79, stringArray));
        String string = CSVReader.getString(75, stringArray);
        if (string != null) {
            string = string.trim();
        }
        if (string != null && string.length() == 3) {
            agentContactImpl.setCountry(OpenEstateUtils.convertToIso2Country(string));
        } else if (string != null && string.length() == 2) {
            agentContactImpl.setCountry(string);
        }
    }

    public static EstateAttachmentImpl readAttachment(int n, int n2, int n3, int n4, String string, Locale locale, String[] stringArray) {
        String string2;
        URL uRL;
        String string3;
        String string4;
        block36: {
            string4 = n > -1 ? CSVReader.getString(n, stringArray, "").trim() : "";
            String string5 = n4 > -1 ? CSVReader.getString(n4, stringArray, "").trim() : "";
            String string6 = string3 = n2 > -1 ? CSVReader.getString(n2, stringArray, "").trim() : "";
            if (string4.length() < 1 && string5.length() < 1) {
                return null;
            }
            uRL = null;
            if (string5.length() > 0) {
                try {
                    uRL = new URL(string5);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)("Can't build URL from: " + string5));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    if (string4.length() >= 1) break block36;
                    return null;
                }
            }
        }
        EstateAttachmentImpl estateAttachmentImpl = new EstateAttachmentImpl();
        if (string3.length() > 0) {
            estateAttachmentImpl.setTitle(string3.trim(), locale);
        }
        if (string != null) {
            estateAttachmentImpl.setType(string);
        }
        if (uRL != null) {
            estateAttachmentImpl.setFile(uRL);
        } else {
            estateAttachmentImpl.setFile(string4);
        }
        String string7 = string2 = uRL != null ? uRL.getFile().toLowerCase() : string4.toLowerCase();
        if (string2.endsWith(ATTACH_SUFFIX_AVI)) {
            estateAttachmentImpl.setMimeType("video/x-msvideo");
        } else if (string2.endsWith(ATTACH_SUFFIX_DOC)) {
            estateAttachmentImpl.setMimeType("application/msword");
        } else if (string2.endsWith(ATTACH_SUFFIX_FLV)) {
            estateAttachmentImpl.setMimeType("video/x-flv");
        } else if (string2.endsWith(ATTACH_SUFFIX_GIF)) {
            estateAttachmentImpl.setMimeType("image/gif");
        } else if (string2.endsWith(ATTACH_SUFFIX_JPEG)) {
            estateAttachmentImpl.setMimeType("image/jpeg");
        } else if (string2.endsWith(ATTACH_SUFFIX_JPG)) {
            estateAttachmentImpl.setMimeType("image/jpeg");
        } else if (string2.endsWith(ATTACH_SUFFIX_MOV)) {
            estateAttachmentImpl.setMimeType("video/quicktime");
        } else if (string2.endsWith(ATTACH_SUFFIX_MP4)) {
            estateAttachmentImpl.setMimeType("video/mp4");
        } else if (string2.endsWith(ATTACH_SUFFIX_MPEG)) {
            estateAttachmentImpl.setMimeType("video/mpeg");
        } else if (string2.endsWith(ATTACH_SUFFIX_MPG)) {
            estateAttachmentImpl.setMimeType("video/mpeg");
        } else if (string2.endsWith(ATTACH_SUFFIX_PDF)) {
            estateAttachmentImpl.setMimeType("application/pdf");
        } else if (string2.endsWith(ATTACH_SUFFIX_RPM)) {
            estateAttachmentImpl.setMimeType("video/vnd.rn-realvideo");
        } else if (string2.endsWith(ATTACH_SUFFIX_RTF)) {
            estateAttachmentImpl.setMimeType("application/rtf");
        } else if (string2.endsWith(ATTACH_SUFFIX_WMV)) {
            estateAttachmentImpl.setMimeType("video/x-ms-wmv");
        } else {
            estateAttachmentImpl.setMimeType("application/octet-stream");
        }
        return estateAttachmentImpl;
    }

    public static Boolean readBoolean(int n, String[] stringArray) {
        return IDXCSVSchema.readBoolean(n, stringArray, null);
    }

    public static Boolean readBoolean(int n, String[] stringArray, Boolean bl) {
        if (n < 0 || stringArray.length <= n) {
            return bl;
        }
        String string = stringArray[n];
        if (StringUtils.isBlank((String)string)) {
            return bl;
        }
        char c = string.toUpperCase().charAt(0);
        if (c == 'Y') {
            return true;
        }
        if (c == 'N') {
            return false;
        }
        return null;
    }

    public Date readDate(int n, String[] stringArray) {
        String string = stringArray[n];
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        try {
            return IDXCSVSchema.getDateFormat().parse(string);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Can't parse date: " + string));
            LOGGER.warn((Object)(">" + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public void readEstate(IDXCSVReader iDXCSVReader, String[] stringArray, EstateImpl estateImpl) throws OpenEstateException {
        Object object;
        String string = stringArray[2];
        int n = Integer.valueOf(stringArray[3]);
        String string2 = null;
        if (OBJECT_CATEGORY_AGRI.equalsIgnoreCase(string)) {
            string2 = n == 3 ? "MAIN_LANDWIRTSCHAFT" : (n == 3 ? "BAUERNHOF" : (n == 1 ? "MAIN_LANDWIRTSCHAFT" : "MAIN_LANDWIRTSCHAFT"));
        } else if (OBJECT_CATEGORY_APPT.equalsIgnoreCase(string)) {
            if (Boolean.TRUE.equals(IDXCSVSchema.readBoolean(164, stringArray))) {
                string2 = "WG";
            } else if (Boolean.TRUE.equals(IDXCSVSchema.readBoolean(169, stringArray))) {
                string2 = "HOCHPARTERRE";
            } else if (n == 3) {
                string2 = "WOHNUNG";
            } else if (n == 3) {
                string2 = "DACHWOHNUNG";
            } else if (n == 9) {
                string2 = "WOHNUNG";
            } else if (n == 2) {
                string2 = "MAISONETTWOHNUNG";
            } else if (n == 1) {
                string2 = "WOHNUNG";
            } else if (n == 10) {
                string2 = "LOFTWOHNUNG";
            } else if (n == 4) {
                string2 = "DACHWOHNUNG";
            } else if (n == 6) {
                string2 = "ZIMMER";
            } else if (n == 5) {
                string2 = "STUDIOWOHNUNG";
            } else if (n == 8) {
                string2 = "TERRASSENWOHNUNG";
            } else if (n == 7) {
                string2 = "WOHNUNG";
                iDXCSVReader.putEstateValue("AUSSTATTUNG", "MOEBLIERT", "JA", estateImpl);
            } else {
                string2 = "WOHNUNG";
            }
        } else if (OBJECT_CATEGORY_GARDEN.equalsIgnoreCase(string)) {
            string2 = n == 1 ? "GARTENGRUND" : "GARTENGRUND";
        } else if (OBJECT_CATEGORY_GASTRO.equalsIgnoreCase(string)) {
            string2 = n == 4 ? "BAR" : (n == 3 ? "BISTRO" : (n == 12 ? "FREIZEIT_SPORT" : (n == 6 ? "FREIZEIT_SPORT" : (n == 7 ? "FREIZEIT_SPORT" : (n == 5 ? "DISKO" : (n == 15 ? "SPORTANLAGE" : (n == 1 ? "HOTEL" : (n == 14 ? "SPORTANLAGE" : (n == 9 ? "SPORTANLAGE" : (n == 16 ? "HOTEL" : (n == 13 ? "SPORTANLAGE" : (n == 10 ? "SPORTANLAGE" : (n == 17 ? "BAR" : (n == 2 ? "RESTAURANT" : (n == 11 ? "SPORTANLAGE" : (n == 8 ? "SPORTANLAGE" : "GASTRONOMIE"))))))))))))))));
        } else if (OBJECT_CATEGORY_HOUSE.equalsIgnoreCase(string)) {
            string2 = Boolean.TRUE.equals(IDXCSVSchema.readBoolean(165, stringArray)) ? "REIHENECKHAUS" : (Boolean.TRUE.equals(IDXCSVSchema.readBoolean(166, stringArray)) ? "REIHENMITTELHAUS" : (n == 10 ? "SCHLOSS" : (n == 9 ? "HAUS" : (n == 12 ? "CHALET" : (n == 3 ? "DOPPELHAUS" : (n == 6 ? "BAUERNHAUS" : (n == 11 ? "WOHNUNG" : (n == 7 ? "MFH" : (n == 2 ? "REIHENHAUS" : (n == 13 ? "LANDHAUS" : (n == 1 ? "EFH" : (n == 4 ? "HAUS" : (n == 5 ? "VILLA" : "HAUS")))))))))))));
        } else if (OBJECT_CATEGORY_INDUS.equalsIgnoreCase(string)) {
            string2 = n == 3 ? "AUSSTELLUNGSFLAECHE" : (n == 18 ? "MAIN_GEWERBE" : (n == 19 ? "ATELIERWOHNUNG" : (n == 13 ? "PRODUKTION" : (n == 12 ? "PRODUKTION" : (n == 32 ? "PRODUKTION" : (n == 11 ? "PRODUKTION" : (n == 4 ? "PRODUKTIONSFLAECHE" : (n == 34 ? "GESCHAEFTSHAUS" : (n == 36 ? "AUSSTELLUNGSFLAECHE" : (n == 16 ? "PRODUKTIONSFLAECHE" : (n == 9 ? "TANKSTELLE" : (n == 10 ? "GARAGE" : (n == 8 ? "GARTENBAU" : (n == 14 ? "PRODUKTION" : (n == 35 ? "WOHNANLAGE" : (n == 22 ? "KRANKENHAUS" : (n == 17 ? "INDUSTRIEANLAGE" : (n == 7 ? "KIOSK" : (n == 23 ? "MAIN_GEWERBE" : (n == 21 ? "MAIN_GEWERBE" : (n == 20 ? "WOHNANLAGE" : (n == 24 ? "SPORTANLAGE" : (n == 25 ? "WOHNANLAGE" : (n == 1 ? "BUERO" : (n == 33 ? "WOHNANLAGE_FUER_SENIOREN" : (n == 37 ? "PARKHAUS" : (n == 38 ? "MAIN_STELLPLATZ" : (n == 29 ? "MAIN_GEWERBE" : (n == 26 ? "REITERHOF" : (n == 27 ? "SANATORIUM" : (n == 30 ? "FREIZEIT_SPORT" : (n == 2 ? "LADEN" : (n == 15 ? "EINKAUFSZENTRUM" : (n == 31 ? "SONNENSTUDIO" : (n == 5 ? "HALLE_LAGER" : (n == 6 ? "PRAXIS" : (n == 28 ? "WERKSTATT" : "MAIN_GEWERBE")))))))))))))))))))))))))))))))))))));
        } else if (OBJECT_CATEGORY_PARK.equalsIgnoreCase(string)) {
            string2 = n == 9 ? "MAIN_STELLPLATZ" : (n == 10 ? "AUSSENSTELLPLATZ" : (n == 7 ? "MAIN_STELLPLATZ" : (n == 8 ? "MAIN_STELLPLATZ" : (n == 12 ? "MAIN_STELLPLATZ" : (n == 2 ? "CARPORT" : (n == 4 ? "DOPPELGARAGE" : (n == 11 ? "MAIN_STELLPLATZ" : (n == 1 ? "AUSSENSTELLPLATZ" : (n == 3 ? "GARAGE" : (n == 5 ? "TIEFGARAGE" : "MAIN_STELLPLATZ"))))))))));
        } else if (OBJECT_CATEGORY_PROP.equalsIgnoreCase(string)) {
            string2 = n == 2 ? "LAND_FORSTGRUND" : (n == 1 ? "MAIN_GRUND" : (n == 3 ? "GEWERBEGRUND" : (n == 4 ? "INDUSTRIEGRUND" : "MAIN_GRUND")));
        } else {
            throw new OpenEstateException("Unknown category: " + string);
        }
        if (string2 == null) {
            throw new OpenEstateException("Unknown estate-type!");
        }
        OpenEstateType openEstateType = OpenEstateType.newInstance(string2);
        String string3 = null;
        if (OFFER_TYPE_SALE.equalsIgnoreCase(stringArray[4])) {
            string3 = "KAUF";
        } else if (OFFER_TYPE_RENT.equalsIgnoreCase(stringArray[4])) {
            if (openEstateType.hasAction("MIETE")) {
                string3 = "MIETE";
            } else if (openEstateType.hasAction("PACHT")) {
                string3 = "PACHT";
            } else if (openEstateType.hasAction("ERBPACHT")) {
                string3 = "ERBPACHT";
            } else if (openEstateType.hasAction("WAZ")) {
                string3 = "WAZ";
            }
        }
        if (string3 == null) {
            throw new OpenEstateException("Unknown estate-action!");
        }
        estateImpl.setType(openEstateType, string3);
        String string4 = "";
        if (!StringUtils.isBlank((String)stringArray[5])) {
            if (string4.length() > 0) {
                string4 = string4 + "|";
            }
            string4 = string4 + stringArray[5];
        }
        if (!StringUtils.isBlank((String)stringArray[6])) {
            if (string4.length() > 0) {
                string4 = string4 + "|";
            }
            string4 = string4 + stringArray[6];
        }
        if (!StringUtils.isBlank((String)stringArray[7])) {
            if (string4.length() > 0) {
                string4 = string4 + "|";
            }
            string4 = string4 + stringArray[7];
        }
        estateImpl.setPublicId(string4);
        estateImpl.getCustomValues().putCustomValue("homegate.id", stringArray[178], 5);
        estateImpl.getCustomValues().putCustomValue("homegate.url", stringArray[126], 5);
        estateImpl.getAdress().setStreet(CSVReader.getString(8, stringArray, ""));
        estateImpl.getAdress().setPostalCode(CSVReader.getString(9, stringArray, ""));
        estateImpl.getAdress().setCity(CSVReader.getString(10, stringArray, ""));
        estateImpl.getAdress().setRegion(CSVReader.getString(11, stringArray, ""));
        String string5 = CSVReader.getString(12, stringArray, "");
        if (string5 != null) {
            string5 = string5.trim();
        }
        if (string5 != null && string5.length() == 3) {
            estateImpl.getAdress().setCountry(OpenEstateUtils.convertToIso2Country(string5));
        } else if (string5 != null && string5.length() == 2) {
            estateImpl.getAdress().setCountry(string5);
        }
        iDXCSVReader.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", this.readDate(15, stringArray), estateImpl);
        estateImpl.setTitle(CSVReader.getString(16, stringArray, "Immobilienangebot"), iDXCSVReader.getOpenEstateLanguage());
        iDXCSVReader.putEstateValue("FREITEXTE", "OBJEKT_BESCHR", CSVReader.getString(17, stringArray), estateImpl);
        try {
            estateImpl.setCurrency(Currency.getInstance(CSVReader.getString(22, stringArray, "EUR")));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)exception.getLocalizedMessage());
            estateImpl.setCurrency(Currency.getInstance(Locale.GERMANY));
        }
        if ("KAUF".equals(estateImpl.getAction())) {
            object = stringArray[21];
            if (PRICE_UNIT_SELLM2.equalsIgnoreCase((String)object)) {
                iDXCSVReader.putEstateValue("PREISE", "KAUFPREIS_QM", CSVReader.getFloat(18, stringArray), estateImpl);
            } else {
                iDXCSVReader.putEstateValue("PREISE", "KAUFPREIS", CSVReader.getFloat(18, stringArray), estateImpl);
            }
        } else if ("PACHT".equals(estateImpl.getAction()) || "ERBPACHT".equals(estateImpl.getAction())) {
            iDXCSVReader.putEstateValue("PREISE", "PACHT", CSVReader.getFloat(18, stringArray), estateImpl);
        } else if ("MIETE".equals(estateImpl.getAction())) {
            iDXCSVReader.putEstateValue("PREISE", "WARMMIETE", CSVReader.getFloat(18, stringArray), estateImpl);
            iDXCSVReader.putEstateValue("PREISE", "KALTMIETE", CSVReader.getFloat(19, stringArray), estateImpl);
        } else if ("WAZ".equals(estateImpl.getAction())) {
            iDXCSVReader.putEstateValue("PREISE", "PAUSCHALMIETE", CSVReader.getFloat(18, stringArray), estateImpl);
            object = stringArray[21];
            String string6 = null;
            if (PRICE_UNIT_DAILY.equalsIgnoreCase((String)object)) {
                string6 = "TAG";
            } else if (PRICE_UNIT_WEEKLY.equalsIgnoreCase((String)object)) {
                string6 = "WOCHE";
            } else if (PRICE_UNIT_MONTHLY.equalsIgnoreCase((String)object)) {
                string6 = "MONAT";
            } else if (PRICE_UNIT_YEARLY.equalsIgnoreCase((String)object)) {
                string6 = "JAHR";
            }
            if (string6 != null) {
                iDXCSVReader.putEstateValue("PREISE", "MIETE_PRO", string6, estateImpl);
            }
        }
        iDXCSVReader.putEstateValue("PREISE", "NEBENKOSTEN", CSVReader.getFloat(20, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("AUSSTATTUNG", "ETAGE", CSVReader.getFloat(24, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", CSVReader.getFloat(162, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("FLAECHEN", "ANZ_ZIMMER", CSVReader.getFloat(25, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("FLAECHEN", "ANZ_WOHNEINHEITEN", CSVReader.getFloat(26, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("FLAECHEN", "WOHNFLAECHE", CSVReader.getFloat(27, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", CSVReader.getFloat(28, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("FLAECHEN", "GESAMTFLAECHE", CSVReader.getFloat(29, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("FLAECHEN", "KUBATUR", CSVReader.getFloat(30, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("ZUSTAND", "BAUJAHR", CSVReader.getInt(31, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("ZUSTAND", "SANIERUNG", CSVReader.getInt(163, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("AUSSTATTUNG", "HALLENHOEHE", CSVReader.getFloat(110, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("AUSSTATTUNG", "BODENBELASTUNG", CSVReader.getFloat(111, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("AUSSTATTUNG", "KRAN_GEWICHT", CSVReader.getFloat(112, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("AUSSTATTUNG", "LAST_LIFT_GEWICHT", CSVReader.getFloat(113, stringArray), estateImpl);
        if (Boolean.TRUE.equals(IDXCSVSchema.readBoolean(167, stringArray))) {
            iDXCSVReader.putEstateValue("ZUSTAND", "ERSCHLIESSUNG", "VOLLERSCHLOSSEN", estateImpl);
        }
        iDXCSVReader.putEstateValue("AUSSTATTUNG", "KAMIN", IDXCSVSchema.readBoolean(33, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("AUSSTATTUNG", "BALKON_TERRASSE", IDXCSVSchema.readBoolean(39, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("AUSSTATTUNG", "RAMPE", IDXCSVSchema.readBoolean(117, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("AUSSTATTUNG", "HEBEBUEHNE", IDXCSVSchema.readBoolean(118, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("AUSSTATTUNG", "SWIMMINGPOOL", IDXCSVSchema.readBoolean(174, stringArray), estateImpl);
        if (Boolean.TRUE.equals(IDXCSVSchema.readBoolean(34, stringArray))) {
            iDXCSVReader.putEstateValue("AUSSTATTUNG", "TECHNIK", "KABEL_TV", estateImpl);
        }
        if (Boolean.TRUE.equals(IDXCSVSchema.readBoolean(35, stringArray))) {
            if (openEstateType.hasAttrib("AUSSTATTUNG", "PERS_LIFT")) {
                iDXCSVReader.putEstateValue("AUSSTATTUNG", "PERS_LIFT", Boolean.TRUE, estateImpl);
            } else if (openEstateType.hasAttrib("AUSSTATTUNG", "LAST_LIFT")) {
                iDXCSVReader.putEstateValue("AUSSTATTUNG", "LAST_LIFT", Boolean.TRUE, estateImpl);
            }
        }
        if (Boolean.TRUE.equals(IDXCSVSchema.readBoolean(37, stringArray))) {
            iDXCSVReader.putEstateValue("FLAECHEN", "STELLPLATZART", "STELLPLATZ", estateImpl);
        }
        if (Boolean.TRUE.equals(IDXCSVSchema.readBoolean(38, stringArray))) {
            iDXCSVReader.putEstateValue("FLAECHEN", "STELLPLATZART", "GARAGE", estateImpl);
        }
        if (Boolean.TRUE.equals(IDXCSVSchema.readBoolean(115, stringArray))) {
            iDXCSVReader.putEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl);
        }
        if (Boolean.TRUE.equals(IDXCSVSchema.readBoolean(116, stringArray))) {
            iDXCSVReader.putEstateValue("VERWALTUNG", "HAUSTIERE", "JA", estateImpl);
        } else if (Boolean.FALSE.equals(IDXCSVSchema.readBoolean(116, stringArray))) {
            iDXCSVReader.putEstateValue("VERWALTUNG", "HAUSTIERE", "NEIN", estateImpl);
        }
        if (Boolean.TRUE.equals(IDXCSVSchema.readBoolean(120, stringArray))) {
            iDXCSVReader.putEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl);
        }
        if (Boolean.TRUE.equals(IDXCSVSchema.readBoolean(170, stringArray))) {
            iDXCSVReader.putEstateValue("ZUSTAND", "ALTER", "NEUBAU", estateImpl);
        } else if (Boolean.TRUE.equals(IDXCSVSchema.readBoolean(171, stringArray))) {
            iDXCSVReader.putEstateValue("ZUSTAND", "ALTER", "ALTBAU", estateImpl);
        }
        iDXCSVReader.putEstateValue("UMFELD", "DISTANZ_KITA", CSVReader.getFloat(43, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("UMFELD", "DISTANZ_AUTOBAHN", CSVReader.getFloat(108, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("UMFELD", "DISTANZ_BUS", CSVReader.getFloat(41, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("UMFELD", "DISTANZ_GRUNDSCHULE", CSVReader.getFloat(44, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("UMFELD", "DISTANZ_HOCHSCHULE", CSVReader.getFloat(45, stringArray), estateImpl);
        iDXCSVReader.putEstateValue("UMFELD", "DISTANZ_EINKAUF", CSVReader.getFloat(42, stringArray), estateImpl);
        object = null;
        object = IDXCSVSchema.readAttachment(46, 51, 56, 99, "IMAGE", iDXCSVReader.getOpenEstateLanguage(), stringArray);
        if (object != null) {
            estateImpl.getAttachments().add((EstateAttachmentImpl)object);
        }
        if ((object = IDXCSVSchema.readAttachment(47, 52, 57, 100, "IMAGE", iDXCSVReader.getOpenEstateLanguage(), stringArray)) != null) {
            estateImpl.getAttachments().add((EstateAttachmentImpl)object);
        }
        if ((object = IDXCSVSchema.readAttachment(48, 53, 58, 101, "IMAGE", iDXCSVReader.getOpenEstateLanguage(), stringArray)) != null) {
            estateImpl.getAttachments().add((EstateAttachmentImpl)object);
        }
        if ((object = IDXCSVSchema.readAttachment(49, 54, 59, 102, "IMAGE", iDXCSVReader.getOpenEstateLanguage(), stringArray)) != null) {
            estateImpl.getAttachments().add((EstateAttachmentImpl)object);
        }
        if ((object = IDXCSVSchema.readAttachment(50, 55, 60, 103, "IMAGE", iDXCSVReader.getOpenEstateLanguage(), stringArray)) != null) {
            estateImpl.getAttachments().add((EstateAttachmentImpl)object);
        }
        if ((object = IDXCSVSchema.readAttachment(87, 91, 95, 104, "IMAGE", iDXCSVReader.getOpenEstateLanguage(), stringArray)) != null) {
            estateImpl.getAttachments().add((EstateAttachmentImpl)object);
        }
        if ((object = IDXCSVSchema.readAttachment(88, 92, 96, 105, "IMAGE", iDXCSVReader.getOpenEstateLanguage(), stringArray)) != null) {
            estateImpl.getAttachments().add((EstateAttachmentImpl)object);
        }
        if ((object = IDXCSVSchema.readAttachment(89, 93, 97, 106, "IMAGE", iDXCSVReader.getOpenEstateLanguage(), stringArray)) != null) {
            estateImpl.getAttachments().add((EstateAttachmentImpl)object);
        }
        if ((object = IDXCSVSchema.readAttachment(90, 94, 98, 107, "IMAGE", iDXCSVReader.getOpenEstateLanguage(), stringArray)) != null) {
            estateImpl.getAttachments().add((EstateAttachmentImpl)object);
        }
        if ((object = IDXCSVSchema.readAttachment(142, 146, 150, 154, "IMAGE", iDXCSVReader.getOpenEstateLanguage(), stringArray)) != null) {
            estateImpl.getAttachments().add((EstateAttachmentImpl)object);
        }
        if ((object = IDXCSVSchema.readAttachment(143, 147, 151, 155, "IMAGE", iDXCSVReader.getOpenEstateLanguage(), stringArray)) != null) {
            estateImpl.getAttachments().add((EstateAttachmentImpl)object);
        }
        if ((object = IDXCSVSchema.readAttachment(144, 148, 152, 156, "IMAGE", iDXCSVReader.getOpenEstateLanguage(), stringArray)) != null) {
            estateImpl.getAttachments().add((EstateAttachmentImpl)object);
        }
        if ((object = IDXCSVSchema.readAttachment(145, 149, 153, 157, "IMAGE", iDXCSVReader.getOpenEstateLanguage(), stringArray)) != null) {
            estateImpl.getAttachments().add((EstateAttachmentImpl)object);
        }
        if ((object = IDXCSVSchema.readAttachment(64, 65, -1, -1, null, iDXCSVReader.getOpenEstateLanguage(), stringArray)) != null) {
            estateImpl.getAttachments().add((EstateAttachmentImpl)object);
        }
        if ((object = IDXCSVSchema.readAttachment(61, 62, -1, -1, null, iDXCSVReader.getOpenEstateLanguage(), stringArray)) != null) {
            estateImpl.getAttachments().add((EstateAttachmentImpl)object);
        }
    }

    public static String writeDate(Date date) {
        return date != null ? IDXCSVSchema.getDateFormat().format(date) : null;
    }

    public static String writeNumber(Number number, int n, int n2) {
        if (number == null) {
            return null;
        }
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumIntegerDigits(n);
        numberFormat.setMaximumFractionDigits(n2);
        return n2 > 0 ? numberFormat.format(number.doubleValue()) : numberFormat.format(number.longValue());
    }

    public static String writeString(String string, int n) {
        if (string == null) {
            return null;
        }
        return string.length() > n ? string.substring(n) : string;
    }

    protected String[] writeValues(IDXCSVWriter iDXCSVWriter, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl) throws OpenEstateException {
        Constable constable;
        Object object;
        String string;
        String[] stringArray = new String[183];
        stringArray[0] = VERSION_3_01;
        stringArray[1] = "OpenEstate-Impl";
        stringArray[68] = IDXCSVSchema.writeString(agentImpl.getId(), 10);
        stringArray[7] = IDXCSVSchema.writeString(estateImpl.getId(), 80);
        List<String> list = Arrays.asList(OpenEstateUtils.getEstateTypePath(estateImpl.getType()));
        if (list.contains("ATELIERWOHNUNG")) {
            stringArray[2] = OBJECT_CATEGORY_INDUS;
            stringArray[3] = String.valueOf(19);
        } else if (list.contains("GARTENBAU")) {
            stringArray[2] = OBJECT_CATEGORY_INDUS;
            stringArray[3] = String.valueOf(8);
        } else if (list.contains("GARTENHAUS") || list.contains("GARTENGRUND")) {
            stringArray[2] = OBJECT_CATEGORY_GARDEN;
            stringArray[3] = String.valueOf(1);
        } else if (list.contains("PARKHAUS")) {
            stringArray[2] = OBJECT_CATEGORY_INDUS;
            stringArray[3] = String.valueOf(37);
        } else if (list.contains("MAIN_STELLPLATZ")) {
            stringArray[2] = OBJECT_CATEGORY_PARK;
            if (list.contains("CARPORT")) {
                stringArray[3] = String.valueOf(2);
            } else if (list.contains("DOPPELGARAGE")) {
                stringArray[3] = String.valueOf(4);
            } else if (list.contains("AUSSENSTELLPLATZ")) {
                stringArray[3] = String.valueOf(1);
            } else if (list.contains("GARAGE")) {
                stringArray[3] = String.valueOf(3);
            } else if (list.contains("TIEFGARAGE")) {
                stringArray[3] = String.valueOf(5);
            } else {
                stringArray[2] = OBJECT_CATEGORY_INDUS;
                stringArray[3] = String.valueOf(38);
            }
        } else if (list.contains("MAIN_LANDWIRTSCHAFT")) {
            stringArray[2] = OBJECT_CATEGORY_AGRI;
            stringArray[3] = list.contains("BAUERNHOF") ? String.valueOf(3) : (list.contains("AUSSIEDLERHOF") ? String.valueOf(3) : String.valueOf(1));
        } else if (list.contains("MAIN_GRUND")) {
            stringArray[2] = OBJECT_CATEGORY_PROP;
            stringArray[3] = list.contains("LAND_FORSTGRUND") ? String.valueOf(2) : (list.contains("GEWERBEGRUND") ? String.valueOf(3) : (list.contains("INDUSTRIEGRUND") ? String.valueOf(4) : String.valueOf(1)));
        } else if (list.contains("MAIN_WOHNEN")) {
            if (list.contains("HAUS")) {
                stringArray[2] = OBJECT_CATEGORY_HOUSE;
                stringArray[3] = list.contains("SCHLOSS") ? String.valueOf(10) : (list.contains("CHALET") ? String.valueOf(12) : (list.contains("DOPPELHAUS") ? String.valueOf(3) : (list.contains("BAUERNHAUS") ? String.valueOf(6) : (list.contains("MFH") ? String.valueOf(7) : (list.contains("REIHENHAUS") ? String.valueOf(2) : (list.contains("LANDHAUS") ? String.valueOf(13) : (list.contains("EFH") ? String.valueOf(1) : (list.contains("VILLA") ? String.valueOf(5) : String.valueOf(1)))))))));
            } else {
                string = iDXCSVWriter.getEstateValueAsString("AUSSTATTUNG", "MOEBLIERT", estateImpl);
                stringArray[2] = OBJECT_CATEGORY_APPT;
                stringArray[3] = list.contains("DACHWOHNUNG") ? String.valueOf(3) : (list.contains("MAISONETTWOHNUNG") ? String.valueOf(2) : (list.contains("LOFTWOHNUNG") ? String.valueOf(10) : (list.contains("ZIMMER") ? String.valueOf(6) : (list.contains("STUDIOWOHNUNG") ? String.valueOf(5) : (list.contains("TERRASSENWOHNUNG") ? String.valueOf(8) : ("JA".equals(string) || "TEIL".equals(string) ? String.valueOf(7) : String.valueOf(1)))))));
            }
        } else if (list.contains("MAIN_GEWERBE")) {
            if (list.contains("GASTRONOMIE") || list.contains("FREIZEIT_SPORT")) {
                stringArray[2] = OBJECT_CATEGORY_GASTRO;
                stringArray[3] = list.contains("BAR") ? String.valueOf(4) : (list.contains("BISTRO") ? String.valueOf(3) : (list.contains("DISKO") ? String.valueOf(5) : (list.contains("HOTEL") ? String.valueOf(1) : (list.contains("HOSTEL") ? String.valueOf(16) : (list.contains("BAR") ? String.valueOf(17) : (list.contains("RESTAURANT") ? String.valueOf(2) : (list.contains("FREIZEIT_SPORT") ? String.valueOf(11) : String.valueOf(2))))))));
            } else {
                stringArray[2] = OBJECT_CATEGORY_INDUS;
                stringArray[3] = list.contains("AUSSTELLUNGSFLAECHE") ? String.valueOf(3) : (list.contains("BUERO_GESCHAEFTSHAUS") ? String.valueOf(34) : (list.contains("INDUSTRIEANLAGE") ? String.valueOf(17) : (list.contains("INDUSTRIEHALLE") ? String.valueOf(17) : (list.contains("PRODUKTION") ? String.valueOf(16) : (list.contains("TANKSTELLE") ? String.valueOf(9) : (list.contains("WOHNANLAGE_FUER_SENIOREN") ? String.valueOf(33) : (list.contains("WOHNANLAGE") ? String.valueOf(35) : (list.contains("SANATORIUM") ? String.valueOf(27) : (list.contains("KRANKENHAUS") ? String.valueOf(22) : (list.contains("KIOSK") ? String.valueOf(7) : (list.contains("WOHN_GESCHAEFTSHAUS") ? String.valueOf(20) : (list.contains("PRAXIS") ? String.valueOf(6) : (list.contains("PRAXISETAGE") ? String.valueOf(6) : (list.contains("BUERO_PRAXIS") ? String.valueOf(1) : (list.contains("REITERHOF") ? String.valueOf(26) : (list.contains("LADENLOKAL") ? String.valueOf(2) : (list.contains("VERKAUFSFLAECHE") ? String.valueOf(2) : (list.contains("GESCHAEFTSLOKAL") ? String.valueOf(2) : (list.contains("EINKAUFSZENTRUM") ? String.valueOf(15) : (list.contains("VERBRAUCHERMARKT") ? String.valueOf(15) : (list.contains("VERKAUFSHALLE") ? String.valueOf(15) : (list.contains("SB_MARKT") ? String.valueOf(15) : (list.contains("SONNENSTUDIO") ? String.valueOf(31) : (list.contains("HALLE_LAGER") ? String.valueOf(5) : (list.contains("WERKSTATT") ? String.valueOf(28) : String.valueOf(4))))))))))))))))))))))))));
            }
        }
        stringArray[169] = list.contains("HOCHPARTERRE") ? String.valueOf('Y') : null;
        stringArray[164] = list.contains("WG") ? String.valueOf('Y') : null;
        stringArray[165] = list.contains("REIHENECKHAUS") ? String.valueOf('Y') : null;
        stringArray[166] = list.contains("REIHENMITTELHAUS") ? String.valueOf('Y') : null;
        stringArray[168] = list.contains("GARTENHAUS") ? String.valueOf('Y') : null;
        stringArray[4] = null;
        if ("KAUF".equals(estateImpl.getAction())) {
            stringArray[4] = OFFER_TYPE_SALE;
        } else if ("ERBPACHT".equals(estateImpl.getAction())) {
            stringArray[4] = OFFER_TYPE_RENT;
        } else if ("MIETE".equals(estateImpl.getAction())) {
            stringArray[4] = OFFER_TYPE_RENT;
        } else if ("PACHT".equals(estateImpl.getAction())) {
            stringArray[4] = OFFER_TYPE_RENT;
        } else if ("WAZ".equals(estateImpl.getAction())) {
            stringArray[4] = OFFER_TYPE_RENT;
        }
        stringArray[8] = IDXCSVSchema.writeString(estateImpl.getAdress().writeStreet(), 200);
        stringArray[9] = IDXCSVSchema.writeString(estateImpl.getAdress().getPostalCode(), 10);
        stringArray[10] = IDXCSVSchema.writeString(estateImpl.getAdress().getCity(), 200);
        stringArray[12] = IDXCSVSchema.writeString(estateImpl.getAdress().getCountry(), 2);
        stringArray[14] = IDXCSVSchema.writeString(estateImpl.getAdress().getRegion(), 50);
        stringArray[15] = IDXCSVSchema.writeDate(iDXCSVWriter.getEstateValueAsDate("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        string = estateImpl.getTitle(iDXCSVWriter.getOpenEstateLanguage());
        if (StringUtils.isBlank((String)string)) {
            string = OpenEstateUtils.translateEstate(estateImpl.getType().getName(), iDXCSVWriter.getOpenEstateLanguage()) + " / " + OpenEstateUtils.translateAction(estateImpl.getAction(), iDXCSVWriter.getOpenEstateLanguage());
        }
        stringArray[16] = IDXCSVSchema.writeString(string.trim(), 70);
        String string2 = iDXCSVWriter.getEstateValueAsString("FREITEXTE", "OBJEKT_BESCHR", estateImpl);
        if (StringUtils.isBlank((String)string2)) {
            string2 = iDXCSVWriter.getEstateValueAsString("FREITEXTE", "AUSSTATT_BESCHR", estateImpl);
        }
        if (StringUtils.isBlank((String)string2)) {
            string2 = iDXCSVWriter.getEstateValueAsString("FREITEXTE", "LAGE_BESCHR", estateImpl);
        }
        if (StringUtils.isBlank((String)string2)) {
            string2 = iDXCSVWriter.getEstateValueAsString("FREITEXTE", "KURZ_BESCHR", estateImpl);
        }
        if (StringUtils.isBlank((String)string2)) {
            string2 = string;
        }
        stringArray[17] = IDXCSVSchema.writeString(StringUtils.trimToNull((String)string2), 4000);
        if (iDXCSVWriter.isEnergyCertificateAppendedToDescription() && !StringUtils.isBlank((String)(object = OpenEstateUtils.writeEstateEnergyCertificate(estateImpl, iDXCSVWriter.getOpenEstateLanguage(), CSV_LINE_SEPARATOR)))) {
            stringArray[17] = OpenEstateUtils.appendTextToDescription(stringArray[17], (String)object, CSV_LINE_SEPARATOR, 4000, false);
        }
        stringArray[22] = IDXCSVSchema.writeString(estateImpl.getCurrency() != null ? estateImpl.getCurrency().getCurrencyCode() : null, 3);
        if ("KAUF".equals(estateImpl.getAction())) {
            object = iDXCSVWriter.getEstateValueAsLong("PREISE", "KAUFPREIS", estateImpl);
            constable = iDXCSVWriter.getEstateValueAsLong("PREISE", "KAUFPREIS_QM", estateImpl);
            if (object != null) {
                stringArray[18] = IDXCSVSchema.writeNumber((Number)object, 10, 0);
                stringArray[21] = PRICE_UNIT_SELL;
            } else if (constable != null) {
                stringArray[18] = IDXCSVSchema.writeNumber(constable, 10, 0);
                stringArray[21] = PRICE_UNIT_SELLM2;
            }
        } else if ("ERBPACHT".equals(estateImpl.getAction()) || "PACHT".equals(estateImpl.getAction())) {
            stringArray[21] = PRICE_UNIT_MONTHLY;
            stringArray[18] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsLong("PREISE", "PACHT", estateImpl), 10, 0);
        } else if ("MIETE".equals(estateImpl.getAction())) {
            stringArray[21] = PRICE_UNIT_MONTHLY;
            stringArray[18] = IDXCSVSchema.writeNumber(OpenEstateUtils.getTotalRent(estateImpl), 10, 0);
            stringArray[19] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsLong("PREISE", "KALTMIETE", estateImpl), 10, 0);
        } else if ("WAZ".equals(estateImpl.getAction())) {
            stringArray[18] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsLong("PREISE", "PAUSCHALMIETE", estateImpl), 10, 0);
            object = iDXCSVWriter.getEstateValueAsString("PREISE", "MIETE_PRO", estateImpl);
            if ("JAHR".equals(object)) {
                stringArray[21] = PRICE_UNIT_YEARLY;
            } else if ("MONAT".equals(object)) {
                stringArray[21] = PRICE_UNIT_MONTHLY;
            } else if ("WOCHE".equals(object)) {
                stringArray[21] = PRICE_UNIT_WEEKLY;
            } else if ("TAG".equals(object)) {
                stringArray[21] = PRICE_UNIT_DAILY;
            }
        }
        stringArray[20] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsLong("PREISE", "NEBENKOSTEN", estateImpl), 10, 0);
        stringArray[24] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsLong("AUSSTATTUNG", "ETAGE", estateImpl), 6, 0);
        stringArray[162] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsLong("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl), 2, 0);
        stringArray[25] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsFloat("FLAECHEN", "ANZ_ZIMMER", estateImpl), 5, 1);
        stringArray[26] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsFloat("FLAECHEN", "ANZ_WOHNEINHEITEN", estateImpl), 5, 1);
        stringArray[27] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsLong("FLAECHEN", "WOHNFLAECHE", estateImpl), 10, 0);
        stringArray[28] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsLong("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl), 10, 0);
        object = iDXCSVWriter.getEstateValueAsLong("FLAECHEN", "NUTZFLAECHE", estateImpl);
        if (object == null || (Long)object <= 0L) {
            object = iDXCSVWriter.getEstateValueAsLong("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        stringArray[29] = IDXCSVSchema.writeNumber((Number)object, 10, 0);
        stringArray[30] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsLong("FLAECHEN", "KUBATUR", estateImpl), 10, 0);
        stringArray[31] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsInteger("ZUSTAND", "BAUJAHR", estateImpl), 4, 0);
        stringArray[163] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsInteger("ZUSTAND", "SANIERUNG", estateImpl), 4, 0);
        constable = iDXCSVWriter.getEstateValueAsBoolean("AUSSTATTUNG", "KAMIN", estateImpl);
        List<String> list2 = iDXCSVWriter.getEstateValueAsList("AUSSTATTUNG", "KAMIN_ART", estateImpl);
        stringArray[33] = Boolean.TRUE.equals(constable) || !list2.isEmpty() ? String.valueOf('Y') : null;
        List<String> list3 = iDXCSVWriter.getEstateValueAsList("AUSSTATTUNG", "TECHNIK", estateImpl);
        stringArray[34] = list3.contains("KABEL_SAT_TV") || list3.contains("KABEL_TV") ? String.valueOf('Y') : null;
        Boolean bl = iDXCSVWriter.getEstateValueAsBoolean("AUSSTATTUNG", "PERS_LIFT", estateImpl);
        Boolean bl2 = iDXCSVWriter.getEstateValueAsBoolean("AUSSTATTUNG", "LAST_LIFT", estateImpl);
        stringArray[35] = Boolean.TRUE.equals(bl) || Boolean.TRUE.equals(bl2) ? String.valueOf('Y') : null;
        List<String> list4 = iDXCSVWriter.getEstateValueAsList("FLAECHEN", "STELLPLATZART", estateImpl);
        if (list4.contains("AUSSEN")) {
            stringArray[37] = String.valueOf('Y');
        }
        if (list4.contains("CARPORT")) {
            stringArray[37] = String.valueOf('Y');
        }
        if (list4.contains("DOPPELGARAGE")) {
            stringArray[38] = String.valueOf('Y');
        }
        if (list4.contains("DUPLEX")) {
            stringArray[38] = String.valueOf('Y');
        }
        if (list4.contains("GARAGE")) {
            stringArray[38] = String.valueOf('Y');
        }
        if (list4.contains("PARKHAUS")) {
            stringArray[37] = String.valueOf('Y');
        }
        if (list4.contains("STELLPLATZ")) {
            stringArray[37] = String.valueOf('Y');
        }
        if (list4.contains("STELLPLATZ_GEMEINSCHAFT")) {
            stringArray[37] = String.valueOf('Y');
        }
        if (list4.contains("TIEFGARAGE")) {
            stringArray[38] = String.valueOf('Y');
        }
        Boolean bl3 = iDXCSVWriter.getEstateValueAsBoolean("AUSSTATTUNG", "BALKON_TERRASSE", estateImpl);
        Integer n = iDXCSVWriter.getEstateValueAsInteger("FLAECHEN", "ANZ_BALKON_TERRASSEN", estateImpl);
        stringArray[39] = Boolean.TRUE.equals(bl3) || n != null && n > 0 ? String.valueOf('Y') : null;
        List<String> list5 = iDXCSVWriter.getEstateValueAsList("AUSSTATTUNG", "EIGNUNG", estateImpl);
        stringArray[115] = list5.contains("ROLLSTUHL") ? String.valueOf('Y') : null;
        String string3 = iDXCSVWriter.getEstateValueAsString("VERWALTUNG", "HAUSTIERE", estateImpl);
        stringArray[116] = "JA".equals(string3) ? String.valueOf('Y') : null;
        stringArray[110] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsFloat("AUSSTATTUNG", "HALLENHOEHE", estateImpl), 10, 2);
        stringArray[111] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsFloat("AUSSTATTUNG", "BODENBELASTUNG", estateImpl), 10, 1);
        stringArray[112] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsFloat("AUSSTATTUNG", "KRAN_GEWICHT", estateImpl), 10, 1);
        stringArray[113] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsFloat("AUSSTATTUNG", "LAST_LIFT_GEWICHT", estateImpl), 10, 1);
        Boolean bl4 = iDXCSVWriter.getEstateValueAsBoolean("AUSSTATTUNG", "RAMPE", estateImpl);
        stringArray[117] = Boolean.TRUE.equals(bl4) ? String.valueOf('Y') : null;
        Boolean bl5 = iDXCSVWriter.getEstateValueAsBoolean("AUSSTATTUNG", "HEBEBUEHNE", estateImpl);
        stringArray[118] = Boolean.TRUE.equals(bl5) ? String.valueOf('Y') : null;
        String string4 = iDXCSVWriter.getEstateValueAsString("ZUSTAND", "ERSCHLIESSUNG", estateImpl);
        stringArray[167] = "TEILERSCHLOSSEN".equals(string4) || "VOLLERSCHLOSSEN".equals(string4) ? String.valueOf('Y') : null;
        String string5 = iDXCSVWriter.getEstateValueAsString("ZUSTAND", "ALTER", estateImpl);
        stringArray[170] = "NEUBAU".equals(string5) ? String.valueOf('Y') : null;
        stringArray[171] = "ALTBAU".equals(string5) ? String.valueOf('Y') : null;
        Boolean bl6 = iDXCSVWriter.getEstateValueAsBoolean("AUSSTATTUNG", "SWIMMINGPOOL", estateImpl);
        stringArray[174] = Boolean.TRUE.equals(bl6) ? String.valueOf('Y') : null;
        stringArray[43] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsLong("UMFELD", "DISTANZ_KITA", estateImpl), 5, 0);
        stringArray[108] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsLong("UMFELD", "DISTANZ_AUTOBAHN", estateImpl), 5, 0);
        Long l = iDXCSVWriter.getEstateValueAsLong("UMFELD", "DISTANZ_NAHBHF", estateImpl);
        if (l == null || l <= 0L) {
            l = iDXCSVWriter.getEstateValueAsLong("UMFELD", "DISTANZ_BUS", estateImpl);
        }
        if (l == null || l <= 0L) {
            l = iDXCSVWriter.getEstateValueAsLong("UMFELD", "DISTANZ_BHF", estateImpl);
        }
        stringArray[41] = IDXCSVSchema.writeNumber(l, 5, 0);
        l = iDXCSVWriter.getEstateValueAsLong("UMFELD", "DISTANZ_EINKAUF", estateImpl);
        if (l == null || l <= 0L) {
            l = iDXCSVWriter.getEstateValueAsLong("UMFELD", "DISTANZ_ZENTRUM", estateImpl);
        }
        stringArray[42] = IDXCSVSchema.writeNumber(l, 5, 0);
        stringArray[44] = IDXCSVSchema.writeNumber(iDXCSVWriter.getEstateValueAsLong("UMFELD", "DISTANZ_GRUNDSCHULE", estateImpl), 5, 0);
        l = iDXCSVWriter.getEstateValueAsLong("UMFELD", "DISTANZ_GESAMTSCHULE", estateImpl);
        if (l == null || l <= 0L) {
            l = iDXCSVWriter.getEstateValueAsLong("UMFELD", "DISTANZ_GYMNASIUM", estateImpl);
        }
        if (l == null || l <= 0L) {
            l = iDXCSVWriter.getEstateValueAsLong("UMFELD", "DISTANZ_HAUPTSCHULE", estateImpl);
        }
        if (l == null || l <= 0L) {
            l = iDXCSVWriter.getEstateValueAsLong("UMFELD", "DISTANZ_HOCHSCHULE", estateImpl);
        }
        if (l == null || l <= 0L) {
            l = iDXCSVWriter.getEstateValueAsLong("UMFELD", "DISTANZ_REALSCHULE", estateImpl);
        }
        if (l == null || l <= 0L) {
            l = iDXCSVWriter.getEstateValueAsLong("UMFELD", "DISTANZ_UNIVERSITAET", estateImpl);
        }
        stringArray[45] = IDXCSVSchema.writeNumber(l, 5, 0);
        stringArray[69] = IDXCSVSchema.writeString(agentImpl.getCompany().getCompanyName(), 200);
        stringArray[70] = IDXCSVSchema.writeString(agentImpl.getCompany().getCompanyNameAddition(), 255);
        stringArray[71] = IDXCSVSchema.writeString(agentContactImpl != null ? agentContactImpl.writePersonFullName() : agentImpl.getCompany().writePersonFullName(), 200);
        stringArray[72] = IDXCSVSchema.writeString(agentContactImpl != null ? agentContactImpl.writeStreet() : agentImpl.getCompany().writeStreet(), 200);
        stringArray[73] = IDXCSVSchema.writeString(agentContactImpl != null ? agentContactImpl.getPostalCode() : agentImpl.getCompany().getPostalCode(), 200);
        stringArray[74] = IDXCSVSchema.writeString(agentContactImpl != null ? agentContactImpl.getCity() : agentImpl.getCompany().getCity(), 200);
        stringArray[75] = IDXCSVSchema.writeString(agentContactImpl != null ? agentContactImpl.getCountry() : agentImpl.getCompany().getCountry(), 2);
        stringArray[76] = IDXCSVSchema.writeString(agentContactImpl != null ? agentContactImpl.getPersonPhone() : agentImpl.getCompany().getCompanyPhone(), 200);
        stringArray[78] = IDXCSVSchema.writeString(agentContactImpl != null ? agentContactImpl.getPersonFax() : agentImpl.getCompany().getCompanyFax(), 200);
        stringArray[79] = IDXCSVSchema.writeString(agentContactImpl != null ? agentContactImpl.getPersonMail() : agentImpl.getCompany().getCompanyMail(), 200);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
            String string6 = estateAttachmentImpl.getFileAsName();
            if (string6 == null) continue;
            int n5 = -1;
            int n6 = -1;
            if (IDXCSVSchema.isDocument(string6)) {
                if (n4 > 0) continue;
                n5 = 64;
                n6 = 65;
                ++n4;
            } else if (IDXCSVSchema.isMovie(string6)) {
                if (n3 > 0) continue;
                n5 = 61;
                n6 = 62;
                ++n3;
            } else if (IDXCSVSchema.isImage(string6)) {
                if (n2 > 12) continue;
                switch (n2) {
                    case 0: {
                        n5 = 46;
                        n6 = 51;
                        break;
                    }
                    case 1: {
                        n5 = 47;
                        n6 = 52;
                        break;
                    }
                    case 2: {
                        n5 = 48;
                        n6 = 53;
                        break;
                    }
                    case 3: {
                        n5 = 49;
                        n6 = 54;
                        break;
                    }
                    case 4: {
                        n5 = 50;
                        n6 = 55;
                        break;
                    }
                    case 5: {
                        n5 = 87;
                        n6 = 91;
                        break;
                    }
                    case 6: {
                        n5 = 88;
                        n6 = 92;
                        break;
                    }
                    case 7: {
                        n5 = 89;
                        n6 = 93;
                        break;
                    }
                    case 8: {
                        n5 = 90;
                        n6 = 94;
                        break;
                    }
                    case 9: {
                        n5 = 142;
                        n6 = 146;
                        break;
                    }
                    case 10: {
                        n5 = 143;
                        n6 = 147;
                        break;
                    }
                    case 11: {
                        n5 = 144;
                        n6 = 148;
                        break;
                    }
                    case 12: {
                        n5 = 145;
                        n6 = 149;
                        break;
                    }
                }
                ++n2;
            }
            if (n5 <= 0 || n6 <= 0) continue;
            stringArray[n5] = IDXCSVSchema.writeString(estateAttachmentImpl.getFileAsName(), 200);
            stringArray[n6] = IDXCSVSchema.writeString(estateAttachmentImpl.getTitle(iDXCSVWriter.getOpenEstateLanguage()), 200);
        }
        return stringArray;
    }
}

