/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.idx;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.csv.CSVWriter;
import com.openindex.openestate.impl.csv.idx.IDXCSVSchema;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class IDXCSVWriter
extends CSVWriter {
    private static final Logger LOGGER = Logger.getLogger(IDXCSVWriter.class);
    private static final IDXCSVSchema SCHEMA = new IDXCSVSchema();
    private boolean energyCertificateAppendedToDescription = false;

    public IDXCSVWriter() {
    }

    public IDXCSVWriter(Locale locale) {
        this.setOpenEstateLanguage(locale);
    }

    @Override
    public String getCsvCharset() {
        return SCHEMA.getEncoding();
    }

    @Override
    public String getCsvLineSeparator() {
        return SCHEMA.getLineSeparator();
    }

    @Override
    public String getCsvValueSeparator() {
        return SCHEMA.getFieldSeparator();
    }

    protected void handleValues(String[] stringArray, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl) {
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    @Override
    protected String prepareValue(String string) {
        return super.prepareValue(string).replaceAll("<br/>", "<br>");
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    @Override
    public void write(Writer writer, SerializableXmlElement serializableXmlElement) throws IOException {
        if (serializableXmlElement == null) {
            throw new NullPointerException("empty destination object!");
        }
        if (serializableXmlElement instanceof AgencyImpl) {
            this.write(writer, (AgencyImpl)serializableXmlElement);
        } else if (serializableXmlElement instanceof TransferImpl) {
            this.write(writer, (TransferImpl)serializableXmlElement);
        } else {
            throw new IllegalArgumentException("invalid destination object: " + serializableXmlElement.getClass().getName());
        }
    }

    public void write(Writer writer, AgencyImpl agencyImpl) throws IOException {
        this.getErrorMap().clear();
        for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
            try {
                AgentContactImpl agentContactImpl = null;
                if (estateImpl.getContactId() != null && agencyImpl.getContacts().containsKey(estateImpl.getContactId())) {
                    agentContactImpl = agencyImpl.getContacts().get(estateImpl.getContactId());
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                this.write(writer, estateImpl, agencyImpl.getAgent(), agentContactImpl, arrayList);
                if (arrayList.isEmpty()) continue;
                this.putErrors(estateImpl.getId(), arrayList);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("immobilie #" + estateImpl.getId() + " konnte nicht geschrieben werden!"));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    public void write(Writer writer, TransferImpl transferImpl) throws IOException {
        this.getErrorMap().clear();
        for (TransferAgencyImpl transferAgencyImpl : transferImpl.getAgencies()) {
            this.write(writer, transferAgencyImpl);
        }
    }

    protected void write(Writer writer, TransferAgencyImpl transferAgencyImpl) throws IOException {
        for (EstateImpl estateImpl : transferAgencyImpl.getEstatesToSave()) {
            try {
                AgentContactImpl agentContactImpl = null;
                if (estateImpl.getContactId() != null && transferAgencyImpl.getContacts().containsKey(estateImpl.getContactId())) {
                    agentContactImpl = transferAgencyImpl.getContacts().get(estateImpl.getContactId());
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                this.write(writer, estateImpl, transferAgencyImpl.getAgent(), agentContactImpl, arrayList);
                if (arrayList.isEmpty()) continue;
                this.putErrors(estateImpl.getId(), arrayList);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("immobilie #" + estateImpl.getId() + " konnte nicht geschrieben werden!"));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    protected void write(Writer writer, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) throws IOException, OpenEstateException {
        String[] stringArray = SCHEMA.writeValues(this, estateImpl, agentImpl, agentContactImpl);
        if (stringArray == null) {
            LOGGER.warn((Object)("csv-werte konnten nicht erzeugt werden f\u00fcr immobilie #" + estateImpl.getId() + " / " + estateImpl.getType().getName() + " / " + estateImpl.getAction()));
            list.add("CSV-Fehler f\u00fcr " + estateImpl.getType().getName() + " / " + estateImpl.getAction());
            return;
        }
        this.handleValues(stringArray, estateImpl, agentImpl, agentContactImpl);
        this.writeValues(writer, stringArray);
    }
}

