/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.is24;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.csv.CSVReader;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchema;
import java.net.URL;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IS24CSVReader
extends CSVReader {
    private static final Logger LOGGER = Logger.getLogger(IS24CSVReader.class);

    public IS24CSVReader() {
    }

    public IS24CSVReader(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    @Override
    public String getCharset() {
        return "CP1252";
    }

    public Date parseDate(int n, String[] stringArray) {
        if (n < 0 || stringArray.length <= n) {
            return null;
        }
        try {
            String string = StringUtils.trimToNull((String)stringArray[n]);
            return string != null ? IS24CSVSchema.getCsvDateFormat().parse(string) : null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("could not parse date: " + exception.getLocalizedMessage()));
            return null;
        }
    }

    public EstateAttachmentImpl parseEstateAttachment(int n, int n2, int n3, int n4, int n5, String[] stringArray) {
        String string = CSVReader.getString(n, stringArray, "").trim();
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        String string2 = CSVReader.getString(n2, stringArray, "").trim();
        String string3 = CSVReader.getString(n3, stringArray);
        String string4 = CSVReader.getString(n5, stringArray);
        EstateAttachmentImpl estateAttachmentImpl = null;
        if ("B".equalsIgnoreCase(string3) || "GB".equalsIgnoreCase(string3)) {
            estateAttachmentImpl = new EstateAttachmentImpl();
            estateAttachmentImpl.setFile(string);
            if ("GB".equalsIgnoreCase(string3)) {
                estateAttachmentImpl.setType("IMAGE_GROUNDPLAN");
            } else {
                estateAttachmentImpl.setType("IMAGE");
            }
        } else if ("L".equalsIgnoreCase(string3)) {
            try {
                if (!string.toLowerCase().startsWith("http:") && !string.toLowerCase().startsWith("https:")) {
                    string = "http://" + string;
                }
                estateAttachmentImpl = new EstateAttachmentImpl();
                estateAttachmentImpl.setFile(new URL(string.trim()));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("invalid attachment-url: '" + string + "'"));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
                return null;
            }
        }
        if (estateAttachmentImpl == null) {
            return null;
        }
        estateAttachmentImpl.setTitle(string4 != null ? string4.trim() : null, this.getOpenEstateLanguage());
        if (".AVI".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("video/x-msvideo");
        } else if (".BMP".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("image/bmp");
        } else if (".GIF".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("image/gif");
        } else if (".JPG".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("image/jpeg");
        } else if (".MOV".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("video/quicktime");
        } else if (".MP4".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("video/mp4");
        } else if (".MPE".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("video/mpeg");
        } else if (".MPEG".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("video/mpeg");
        } else if (".MPG".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("video/mpeg");
        } else if (".PDF".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("application/pdf");
        } else if (".PNG".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("image/png");
        } else if (".QT".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("video/quicktime");
        } else if (".QTL".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("video/quicktime");
        } else if (".RM".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("application/vnd.rn-realmedia");
        } else if (".RV".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("video/vnd.rn-realvideo");
        } else if (".WMV".equalsIgnoreCase(string2)) {
            estateAttachmentImpl.setMimeType("video/x-ms-wmv");
        }
        return estateAttachmentImpl;
    }

    public Boolean parseYerOrNo(int n, String[] stringArray) {
        if (n < 0 || stringArray.length <= n) {
            return null;
        }
        char c = CSVReader.getChar(n, stringArray);
        if (c == 'J') {
            return true;
        }
        if (c == 'N') {
            return false;
        }
        return null;
    }

    protected boolean readEstate(IS24CSVSchema iS24CSVSchema, String[] stringArray, EstateImpl estateImpl) {
        iS24CSVSchema.readEstate(this, stringArray, estateImpl);
        return true;
    }

    protected void readEstateAusstattung(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = IS24CSVReader.getInt(n, stringArray, n2);
        if (n7 == n3) {
            this.putEstateValue("AUSSTATTUNG", "AUSSTATTUNG_ART", "EINFACH", estateImpl);
        } else if (n7 == n4) {
            this.putEstateValue("AUSSTATTUNG", "AUSSTATTUNG_ART", "GEHOBEN", estateImpl);
        } else if (n7 == n5) {
            this.putEstateValue("AUSSTATTUNG", "AUSSTATTUNG_ART", "LUXUS", estateImpl);
        } else if (n7 == n6) {
            this.putEstateValue("AUSSTATTUNG", "AUSSTATTUNG_ART", "NORMAL", estateImpl);
        }
    }

    protected void readEstateBauphase(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4, int n5) {
        int n6 = IS24CSVReader.getInt(n, stringArray, n2);
        if (n6 == n3) {
            this.putEstateValue("ZUSTAND", "BAUPHASE", "IN_PLANUNG", estateImpl);
        } else if (n6 == n4) {
            this.putEstateValue("ZUSTAND", "BAUPHASE", "IM_BAU", estateImpl);
        } else if (n6 == n5) {
            this.putEstateValue("ZUSTAND", "BAUPHASE", "ABGESCHLOSSEN", estateImpl);
        }
    }

    protected void readEstateBebaubarNach(String[] stringArray, EstateImpl estateImpl, int n, char c, char c2, char c3, char c4) {
        char c5 = IS24CSVReader.getChar(n, stringArray, c);
        if (c5 == c2) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_NACH", "AUSSENGEBIET", estateImpl);
        } else if (c5 == c3) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_NACH", "BEBAUUNGSPLAN", estateImpl);
        } else if (c5 == c4) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_NACH", "NACHBARBEBAUUNG", estateImpl);
        }
    }

    protected void readEstateBefeuerung(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        String[] stringArray2;
        for (String string : stringArray2 = IS24CSVReader.getString(n, stringArray, "").split(";")) {
            if ((string = StringUtils.trimToNull((String)string)) == null) continue;
            try {
                int n10 = Integer.valueOf(string.trim());
                if (n2 == n10) {
                    this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "ERDWAERME", estateImpl);
                    continue;
                }
                if (n3 == n10) {
                    this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "FERNWAERME", estateImpl);
                    continue;
                }
                if (n4 == n10) {
                    this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "GAS", estateImpl);
                    continue;
                }
                if (n5 == n10) {
                    this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "KOHLE", estateImpl);
                    continue;
                }
                if (n6 == n10) {
                    this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "OEL", estateImpl);
                    continue;
                }
                if (n7 == n10) {
                    this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "ALTERNATIV", estateImpl);
                    continue;
                }
                if (n8 == n10) {
                    this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "SOLAR", estateImpl);
                    continue;
                }
                if (n9 != n10) continue;
                this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "ELEKTRO", estateImpl);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("befeuerung konnte nicht gelesen werden: " + exception.getLocalizedMessage()));
            }
        }
    }

    protected void readEstateBodenbelag(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
        int n15 = IS24CSVReader.getInt(n, stringArray, n2);
        if (n15 == n3) {
            this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "BETON", estateImpl);
        } else if (n15 == n4) {
            this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "EPOXIDHARZ", estateImpl);
        } else if (n15 == n5) {
            this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "FLIESEN", estateImpl);
        } else if (n15 == n6) {
            this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "LAMINAT", estateImpl);
        } else if (n15 == n7) {
            this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "NACH_WUNSCH", estateImpl);
        } else if (n15 == n9) {
            this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "PARKETT", estateImpl);
        } else if (n15 == n10) {
            this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "PVC", estateImpl);
        } else if (n15 == n11) {
            this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "STEIN", estateImpl);
        } else if (n15 == n12) {
            this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "TEPPICH", estateImpl);
        } else if (n15 == n13) {
            this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "TEPPICH_ANTISTAT", estateImpl);
        } else if (n15 == n14) {
            this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "TEPPICH", estateImpl);
        }
    }

    protected void readEstateEnergiepass(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = IS24CSVReader.getInt(n, stringArray, n2);
        Float f = IS24CSVReader.getFloat(n5, stringArray);
        boolean bl = false;
        if (f != null && n7 == n3) {
            bl = true;
            this.putEstateValue("ENERGIEPASS", "ART", "BEDARF", estateImpl);
            this.putEstateValue("ENERGIEPASS", "BEDARF_GESAMT", f, estateImpl);
        } else if (f != null && n7 == n4) {
            bl = true;
            this.putEstateValue("ENERGIEPASS", "ART", "VERBRAUCH", estateImpl);
            this.putEstateValue("ENERGIEPASS", "VERBRAUCH_GESAMT", f, estateImpl);
            this.putEstateValue("ENERGIEPASS", "VERBRAUCH_INKL_WARMWASSER", this.parseYerOrNo(n6, stringArray), estateImpl);
        }
        this.putEstateValue("ENERGIEPASS", "VORHANDEN", bl, estateImpl);
        if (bl && estateImpl.getAdress() != null) {
            this.putEstateValue("ENERGIEPASS", "KLASSE", OpenEstateUtils.getEnergyCertificateClass(f, estateImpl.getAdress().getCountry()), estateImpl);
        }
    }

    protected void readEstateErschliessung(String[] stringArray, EstateImpl estateImpl, int n, char c, char c2, char c3, char c4) {
        char c5 = IS24CSVReader.getChar(n, stringArray, c);
        if (c5 == c2) {
            this.putEstateValue("ZUSTAND", "ERSCHLIESSUNG", "VOLLERSCHLOSSEN", estateImpl);
        } else if (c5 == c3) {
            this.putEstateValue("ZUSTAND", "ERSCHLIESSUNG", "TEILERSCHLOSSEN", estateImpl);
        } else if (c5 == c4) {
            this.putEstateValue("ZUSTAND", "ERSCHLIESSUNG", "UNERSCHLOSSEN", estateImpl);
        }
    }

    protected void readEstateGeschlecht(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4) {
        int n5 = IS24CSVReader.getInt(n, stringArray, n2);
        if (n5 == n3) {
            this.putEstateValue("VERWALTUNG", "GESCHLECHT", "FRAU", estateImpl);
        } else if (n5 == n4) {
            this.putEstateValue("VERWALTUNG", "GESCHLECHT", "MANN", estateImpl);
        }
    }

    protected void readEstateHaustiere(String[] stringArray, EstateImpl estateImpl, int n, char c, char c2, char c3) {
        char c4 = IS24CSVReader.getChar(n, stringArray, '-');
        if (c4 == c) {
            this.putEstateValue("VERWALTUNG", "HAUSTIERE", "JA", estateImpl);
        } else if (c4 == c2) {
            this.putEstateValue("VERWALTUNG", "HAUSTIERE", "NEIN", estateImpl);
        } else if (c4 == c3) {
            this.putEstateValue("VERWALTUNG", "HAUSTIERE", "VEREINBARUNG", estateImpl);
        }
    }

    protected void readEstateHeizungsart(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4, int n5) {
        int n6 = IS24CSVReader.getInt(n, stringArray, n2);
        if (n6 == n3) {
            this.putEstateValue("AUSSTATTUNG", "HEIZUNGSART", "ETAGE", estateImpl);
        } else if (n6 == n4) {
            this.putEstateValue("AUSSTATTUNG", "HEIZUNGSART", "OFEN", estateImpl);
        } else if (n6 == n5) {
            this.putEstateValue("AUSSTATTUNG", "HEIZUNGSART", "ZENTRAL", estateImpl);
        }
    }

    protected void readEstateKeller(String[] stringArray, EstateImpl estateImpl, int n) {
        Boolean bl = this.parseYerOrNo(n, stringArray);
        if (Boolean.TRUE.equals(bl)) {
            this.putEstateValue("AUSSTATTUNG", "UNTERKELLERT", "JA", estateImpl);
        } else if (Boolean.FALSE.equals(bl)) {
            this.putEstateValue("AUSSTATTUNG", "UNTERKELLERT", "NEIN", estateImpl);
        }
    }

    protected void readEstateMietePro(String[] stringArray, EstateImpl estateImpl, int n, char c, char c2, char c3) {
        char c4 = IS24CSVReader.getChar(n, stringArray, '-');
        if (c4 == c) {
            this.putEstateValue("PREISE", "MIETE_PRO", "TAG", estateImpl);
        } else if (c4 == c2) {
            this.putEstateValue("PREISE", "MIETE_PRO", "WOCHE", estateImpl);
        } else if (c4 == c3) {
            this.putEstateValue("PREISE", "MIETE_PRO", "MONAT", estateImpl);
        }
    }

    protected void readEstateMoebliert(String[] stringArray, EstateImpl estateImpl, int n) {
        Boolean bl = this.parseYerOrNo(n, stringArray);
        if (Boolean.TRUE.equals(bl)) {
            this.putEstateValue("AUSSTATTUNG", "MOEBLIERT", "JA", estateImpl);
        } else if (Boolean.FALSE.equals(bl)) {
            this.putEstateValue("AUSSTATTUNG", "MOEBLIERT", "NEIN", estateImpl);
        }
    }

    protected void readEstateRaucher(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4) {
        int n5 = IS24CSVReader.getInt(n, stringArray, n2);
        if (n5 == n3) {
            this.putEstateValue("VERWALTUNG", "NICHTRAUCHER", "EGAL", estateImpl);
        } else if (n5 == n4) {
            this.putEstateValue("VERWALTUNG", "NICHTRAUCHER", "JA", estateImpl);
        }
    }

    protected void readEstateStellplatz(String[] stringArray, EstateImpl estateImpl, int n, char c, char c2, char c3, char c4, char c5, char c6, char c7) {
        char c8 = IS24CSVReader.getChar(n, stringArray, c);
        if (c8 == c2) {
            this.putEstateValue("FLAECHEN", "STELLPLATZART", "STELLPLATZ", estateImpl);
        } else if (c8 == c3) {
            this.putEstateValue("FLAECHEN", "STELLPLATZART", "AUSSEN", estateImpl);
        } else if (c8 == c4) {
            this.putEstateValue("FLAECHEN", "STELLPLATZART", "CARPORT", estateImpl);
        } else if (c8 == c5) {
            this.putEstateValue("FLAECHEN", "STELLPLATZART", "GARAGE", estateImpl);
        } else if (c8 == c6) {
            this.putEstateValue("FLAECHEN", "STELLPLATZART", "PARKHAUS", estateImpl);
        } else if (c8 == c7) {
            this.putEstateValue("FLAECHEN", "STELLPLATZART", "TIEFGARAGE", estateImpl);
        }
    }

    protected void readEstateZulieferung(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = IS24CSVReader.getInt(n, stringArray, n2);
        if (n10 == n3) {
            this.putEstateValue("UMFELD", "ZULIEFERUNG", "DIREKT", estateImpl);
        } else if (n10 == n4) {
            this.putEstateValue("UMFELD", "ZULIEFERUNG", "GANZTAEGIG", estateImpl);
        } else if (n10 == n5) {
            this.putEstateValue("UMFELD", "ZULIEFERUNG", "NICHT_DIREKT", estateImpl);
        } else if (n10 == n6) {
            this.putEstateValue("UMFELD", "ZULIEFERUNG", "PKW_ZUFAHRT", estateImpl);
        } else if (n10 == n7) {
            this.putEstateValue("UMFELD", "ZULIEFERUNG", "VON_HINTEN", estateImpl);
        } else if (n10 == n8) {
            this.putEstateValue("UMFELD", "ZULIEFERUNG", "VON_VORN", estateImpl);
        } else if (n10 == n9) {
            this.putEstateValue("UMFELD", "ZULIEFERUNG", "VORMITTAGS", estateImpl);
        }
    }

    protected void readEstateZustand(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        int n14 = IS24CSVReader.getInt(n, stringArray, n2);
        if (n14 == n3) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "ABRISSOBJEKT", estateImpl);
        } else if (n14 == n4) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "ERSTBEZUG", estateImpl);
        } else if (n14 == n5) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "ERSTBEZUG_NACH_SANIERUNG", estateImpl);
        } else if (n14 == n6) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "GEPFLEGT", estateImpl);
        } else if (n14 == n7) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "MODERNISIERT", estateImpl);
        } else if (n14 == n8) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "NACH_VEREINBARUNG", estateImpl);
        } else if (n14 == n9) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "NEUWERTIG", estateImpl);
        } else if (n14 == n10) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "RENOVIERUNGSBEDARF_TEIL", estateImpl);
        } else if (n14 == n11) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "SANIERT_VOLL", estateImpl);
        } else if (n14 == n12) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "RENOVIERUNGSBEDARF_VOLL", estateImpl);
        } else if (n14 == n13) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "RENOVIERT_VOLL", estateImpl);
        }
    }

    @Override
    public void readLine(String string, SerializableXmlElement serializableXmlElement) {
        if (StringUtils.isBlank((String)string)) {
            return;
        }
        if (!(serializableXmlElement instanceof TransferImpl) && !(serializableXmlElement instanceof AgencyImpl)) {
            throw new IllegalArgumentException("invalid destination-class!");
        }
        String[] stringArray = new String[182];
        IS24CSVSchema iS24CSVSchema = IS24CSVSchema.loadSchema(string, stringArray);
        if (iS24CSVSchema == null) {
            throw new NullPointerException("no csv-schema found!");
        }
        if (stringArray == null) {
            throw new NullPointerException("no csv-values found!");
        }
        if (serializableXmlElement instanceof TransferImpl) {
            this.readLineValues(iS24CSVSchema, stringArray, (TransferImpl)serializableXmlElement);
        } else if (serializableXmlElement instanceof AgencyImpl) {
            this.readLineValues(iS24CSVSchema, stringArray, (AgencyImpl)serializableXmlElement);
        }
    }

    protected void readLineValues(IS24CSVSchema iS24CSVSchema, String[] stringArray, AgencyImpl agencyImpl) {
        char c = IS24CSVReader.getChar(0, stringArray);
        if (c == 'N') {
            LOGGER.info((Object)"ignoriere CSV-Zeile");
            return;
        }
        if (c == 'D') {
            LOGGER.info((Object)"ignoriere CSV-Zeile mit L\u00f6schung");
            return;
        }
        if (agencyImpl.getAgent() == null) {
            throw new NullPointerException("no agent defined in agency!");
        }
        iS24CSVSchema.readAgent(this, stringArray, agencyImpl.getAgent());
        AgentContactImpl agentContactImpl = this.createEmptyContact();
        iS24CSVSchema.readAgentContact(this, stringArray, agentContactImpl);
        agentContactImpl.setId("NewContact." + (agencyImpl.getContacts().size() + 1));
        agencyImpl.getContacts().put(agentContactImpl.getId(), agentContactImpl);
        EstateImpl estateImpl = this.createEmptyEstate();
        if (!this.readEstate(iS24CSVSchema, stringArray, estateImpl)) {
            return;
        }
        estateImpl.setId("NewEstate." + (agencyImpl.getEstates().size() + 1));
        agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
    }

    protected void readLineValues(IS24CSVSchema iS24CSVSchema, String[] stringArray, TransferImpl transferImpl) {
        AgentImpl agentImpl = new AgentImpl();
        iS24CSVSchema.readAgent(this, stringArray, agentImpl);
        String string = StringUtils.trimToNull((String)agentImpl.getId());
        if (string == null) {
            LOGGER.warn((Object)"Anbieter-ID konnte nicht ermittelt werden!");
            string = "Agency.0";
            agentImpl.setId(string);
        }
        for (TransferAgencyImpl transferAgencyImpl : transferImpl.getAgencies()) {
            if (!string.equalsIgnoreCase(transferAgencyImpl.getAgent().getId())) continue;
            this.readLineValues(iS24CSVSchema, stringArray, transferAgencyImpl);
            return;
        }
        TransferAgencyImpl transferAgencyImpl = new TransferAgencyImpl();
        transferAgencyImpl.setAgent(agentImpl);
        this.readLineValues(iS24CSVSchema, stringArray, transferAgencyImpl);
        transferImpl.getAgencies().add(transferAgencyImpl);
    }

    protected void readLineValues(IS24CSVSchema iS24CSVSchema, String[] stringArray, TransferAgencyImpl transferAgencyImpl) {
        if (transferAgencyImpl.getAgent() == null) {
            throw new NullPointerException("no agent defined in agency!");
        }
        char c = IS24CSVReader.getChar(0, stringArray);
        if (c == 'N') {
            LOGGER.info((Object)"ignoriere CSV-Zeile");
            return;
        }
        if (c == 'D') {
            EstateImpl estateImpl = this.createEmptyEstate();
            iS24CSVSchema.readEstate(this, stringArray, estateImpl);
            String string = StringUtils.trimToNull((String)estateImpl.getId());
            if (string == null) {
                throw new IllegalArgumentException("keine objekt-id zur l\u00f6schung angegeben!");
            }
            transferAgencyImpl.getEstateIdsToRemove().add(string);
            return;
        }
        AgentContactImpl agentContactImpl = this.createEmptyContact();
        iS24CSVSchema.readAgentContact(this, stringArray, agentContactImpl);
        agentContactImpl.setId("NewContact." + (transferAgencyImpl.getContacts().size() + 1));
        transferAgencyImpl.getContacts().put(agentContactImpl.getId(), agentContactImpl);
        EstateImpl estateImpl = this.createEmptyEstate();
        if (!this.readEstate(iS24CSVSchema, stringArray, estateImpl)) {
            return;
        }
        estateImpl.setId("NewEstate." + (transferAgencyImpl.getEstatesToSave().size() + 1));
        estateImpl.setContactId(agentContactImpl.getId());
        transferAgencyImpl.getEstatesToSave().add(estateImpl);
    }
}

