/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.is24;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.csv.CSVReader;
import com.openindex.openestate.impl.csv.CSVSchema;
import com.openindex.openestate.impl.csv.is24.IS24CSVReader;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchemaAnlage;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchemaGewerbeBueroPraxen;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchemaGewerbeEinzelhandel;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchemaGewerbeGastronomieHotel;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchemaGewerbeHalleProduktion;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchemaGewerbeSonstiges;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchemaGrundstueckGewerbe;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchemaGrundstueckWohnen;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchemaHausKauf;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchemaHausMiete;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchemaStellplatzKauf;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchemaStellplatzMiete;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchemaWohnenAufZeit;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchemaWohnungKauf;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchemaWohnungMiete;
import com.openindex.openestate.impl.csv.is24.IS24CSVWriter;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class IS24CSVSchema
extends CSVSchema {
    private static final Logger LOGGER = Logger.getLogger(IS24CSVSchema.class);
    public static final String CSV_ENCODING = "CP1252";
    public static final String CSV_VERSION = "1.4.0.4";
    public static final String CSV_LINE_SEPARATOR = "\r\n";
    public static final String CSV_FIELD_SEPARATOR = "|";
    public static final int CSV_FIELD_COUNT = 182;
    public static final char YES = 'J';
    public static final char NO = 'N';
    public static final char VEREINBARUNG = 'V';
    public static final char EMPTY = '-';
    public static final String ATTACH_SUFFIX_BMP = ".BMP";
    public static final String ATTACH_SUFFIX_GIF = ".GIF";
    public static final String ATTACH_SUFFIX_PNG = ".PNG";
    public static final String ATTACH_SUFFIX_JPG = ".JPG";
    public static final String ATTACH_SUFFIX_MOV = ".MOV";
    public static final String ATTACH_SUFFIX_QT = ".QT";
    public static final String ATTACH_SUFFIX_QTL = ".QTL";
    public static final String ATTACH_SUFFIX_RM = ".RM";
    public static final String ATTACH_SUFFIX_RV = ".RV";
    public static final String ATTACH_SUFFIX_MPE = ".MPE";
    public static final String ATTACH_SUFFIX_MPG = ".MPG";
    public static final String ATTACH_SUFFIX_MPEG = ".MPEG";
    public static final String ATTACH_SUFFIX_MP4 = ".MP4";
    public static final String ATTACH_SUFFIX_WMV = ".WMV";
    public static final String ATTACH_SUFFIX_AVI = ".AVI";
    public static final String ATTACH_SUFFIX_PDF = ".PDF";
    public static final String ATTACH_TYPE_IMAGE = "B";
    public static final String ATTACH_TYPE_VIDEO = "V";
    public static final String ATTACH_TYPE_AUDIO = "S";
    public static final String ATTACH_TYPE_LINK = "L";
    public static final String ATTACH_TYPE_GRUNDRISS_IMAGE = "GB";
    public static final String ATTACH_TYPE_GRUNDRISS_PDF = "GP";
    public static final int FIELD_MODE = 0;
    public static final char MODE_IMPORT = 'I';
    public static final char MODE_UPDATE = 'U';
    public static final char MODE_DELETE = 'D';
    public static final char MODE_IGNORE = 'N';
    public static final int FIELD_STATUS = 1;
    public static final char STATUS_INACTIVE = '0';
    public static final char STATUS_ACTIVE = '1';
    public static final int FIELD_ESTATE_TYPE = 2;
    public static final int ESTATE_TYPE_WOHNUNG_MIETE = 0;
    public static final int ESTATE_TYPE_HAUS_MIETE = 1;
    public static final int ESTATE_TYPE_WOHNUNG_KAUF = 2;
    public static final int ESTATE_TYPE_HAUS_KAUF = 3;
    public static final int ESTATE_TYPE_WOHNEN_AUF_ZEIT = 4;
    public static final int ESTATE_TYPE_GRUNDSTUECKE = 5;
    public static final int ESTATE_TYPE_GEWERBE_BUERO_PRAXEN = 7;
    public static final int ESTATE_TYPE_GEWERBE_EINZELHANDEL = 8;
    public static final int ESTATE_TYPE_GEWERBE_GASTRONOMIE_HOTEL = 9;
    public static final int ESTATE_TYPE_GEWERBE_HALLE_PRODUKTION = 10;
    public static final int ESTATE_TYPE_GEWERBE_SONSTIGES = 11;
    public static final int ESTATE_TYPE_ANLAGE = 12;
    public static final int ESTATE_TYPE_STELLPLATZ_KAUF = 17;
    public static final int ESTATE_TYPE_STELLPLATZ_MIETE = 18;
    public static final int FIELD_SCOUT_ID = 3;
    public static final int FIELD_ESTATE_ID = 7;
    public static final int FIELD_ESTATE_GROUP_ID = 8;
    public static final int FIELD_SCOUT_PUBLISH_AT = 9;
    public static final int SCOUT_PUBLISH_AT_IS24_HP_ALLEGRUPPEN = 0;
    public static final int SCOUT_PUBLISH_AT_VBM_ALLEGRUPPEN = 1;
    public static final int SCOUT_PUBLISH_AT_IS24_VBM_HP_ALLEGRUPPEN = 2;
    public static final int SCOUT_PUBLISH_AT_HP_ALLEGRUPPEN = 3;
    public static final int SCOUT_PUBLISH_AT_IS24 = 4;
    public static final int SCOUT_PUBLISH_AT_VBM_HP_ALLEGRUPPEN = 5;
    public static final int SCOUT_PUBLISH_AT_IS24_VBM_ALLEGRUPPEN = 6;
    public static final int SCOUT_PUBLISH_AT_IS24_WAHLGRUPPEN = 7;
    public static final int SCOUT_PUBLISH_AT_HP_WAHLGRUPPEN = 8;
    public static final int SCOUT_PUBLISH_AT_IS24_HP_WAHLGRUPPEN = 9;
    public static final int SCOUT_PUBLISH_AT_WAHLGRUPPEN = 10;
    public static final int FIELD_SCOUT_PUBLISH_GROUPS = 10;
    public static final int FIELD_SCOUT_API_SEARCH1 = 11;
    public static final int FIELD_SCOUT_API_SEARCH2 = 12;
    public static final int FIELD_SCOUT_API_SEARCH3 = 13;
    public static final int FIELD_SCOUT_AGENT_ID = 15;
    public static final int FIELD_CONTACT_ADDRESS = 16;
    public static final int FIELD_CONTACT_FIRSTNAME = 17;
    public static final int FIELD_CONTACT_LASTNAME = 18;
    public static final int FIELD_CONTACT_STREET = 19;
    public static final int FIELD_CONTACT_STREETNR = 20;
    public static final int FIELD_CONTACT_POSTAL = 21;
    public static final int FIELD_CONTACT_CITY = 22;
    public static final int FIELD_CONTACT_COUNTRY = 23;
    public static final int FIELD_CONTACT_PHONE = 24;
    public static final int FIELD_CONTACT_MOBILE = 25;
    public static final int FIELD_CONTACT_FAX = 26;
    public static final int FIELD_CONTACT_EMAIL = 27;
    public static final int FIELD_CONTACT_WEBSITE = 28;
    public static final int FIELD_ESTATE_ADRESS_PUBLISHED = 35;
    public static final char ESTATE_ADRESS_PUBLISHED_YES = 'J';
    public static final char ESTATE_ADRESS_PUBLISHED_NO = 'N';
    public static final int FIELD_ESTATE_TITLE = 36;
    public static final int FIELD_ESTATE_PROVISION = 37;
    public static final int FIELD_ESTATE_CURRENCY = 38;
    public static final String ESTATE_CURRENCY_DEM = "DEM";
    public static final String ESTATE_CURRENCY_EUR = "EUR";
    public static final int FIELD_ESTATE_PROVISION_REQUIRED = 39;
    public static final char ESTATE_PROVISION_REQUIRED_YES = 'J';
    public static final char ESTATE_PROVISION_REQUIRED_NO = 'N';
    public static final int FIELD_ESTATE_PROVISION_TEXT = 40;
    public static final int FIELD_ESTATE_ADRESS_STREET = 50;
    public static final int FIELD_ESTATE_ADRESS_STREETNR = 51;
    public static final int FIELD_ESTATE_ADRESS_POSTAL = 52;
    public static final int FIELD_ESTATE_ADRESS_CITY = 53;
    public static final int FIELD_ESTATE_ADRESS_COUNTRY = 54;
    public static final int FIELD_ESTATE_ADRESS_COUNTRY_AREA = 55;
    public static final int FIELD_ESTATE_TEXT_LAGE = 99;
    public static final int FIELD_ESTATE_TEXT_AUSSTATTUNG = 100;
    public static final int FIELD_ESTATE_TEXT_BESCHREIBUNG = 101;
    public static final int FIELD_ESTATE_TEXT_SONSTIGES = 102;
    public static final int FIELD_ESTATE_ATTACH0_NAME = 107;
    public static final int FIELD_ESTATE_ATTACH0_SUFFIX = 108;
    public static final int FIELD_ESTATE_ATTACH0_TYPE = 109;
    public static final int FIELD_ESTATE_ATTACH0_DURATION = 110;
    public static final int FIELD_ESTATE_ATTACH0_TEXT = 111;
    public static final int FIELD_ESTATE_ATTACH1_NAME = 112;
    public static final int FIELD_ESTATE_ATTACH1_SUFFIX = 113;
    public static final int FIELD_ESTATE_ATTACH1_TYPE = 114;
    public static final int FIELD_ESTATE_ATTACH1_DURATION = 115;
    public static final int FIELD_ESTATE_ATTACH1_TEXT = 116;
    public static final int FIELD_ESTATE_ATTACH2_NAME = 117;
    public static final int FIELD_ESTATE_ATTACH2_SUFFIX = 118;
    public static final int FIELD_ESTATE_ATTACH2_TYPE = 119;
    public static final int FIELD_ESTATE_ATTACH2_DURATION = 120;
    public static final int FIELD_ESTATE_ATTACH2_TEXT = 121;
    public static final int FIELD_ESTATE_ATTACH3_NAME = 122;
    public static final int FIELD_ESTATE_ATTACH3_SUFFIX = 123;
    public static final int FIELD_ESTATE_ATTACH3_TYPE = 124;
    public static final int FIELD_ESTATE_ATTACH3_DURATION = 125;
    public static final int FIELD_ESTATE_ATTACH3_TEXT = 126;
    public static final int FIELD_ESTATE_ATTACH4_NAME = 127;
    public static final int FIELD_ESTATE_ATTACH4_SUFFIX = 128;
    public static final int FIELD_ESTATE_ATTACH4_TYPE = 129;
    public static final int FIELD_ESTATE_ATTACH4_DURATION = 130;
    public static final int FIELD_ESTATE_ATTACH4_TEXT = 131;
    public static final int FIELD_ESTATE_ATTACH5_NAME = 132;
    public static final int FIELD_ESTATE_ATTACH5_SUFFIX = 133;
    public static final int FIELD_ESTATE_ATTACH5_TYPE = 134;
    public static final int FIELD_ESTATE_ATTACH5_DURATION = 135;
    public static final int FIELD_ESTATE_ATTACH5_TEXT = 136;
    public static final int FIELD_ESTATE_ATTACH6_NAME = 137;
    public static final int FIELD_ESTATE_ATTACH6_SUFFIX = 138;
    public static final int FIELD_ESTATE_ATTACH6_TYPE = 139;
    public static final int FIELD_ESTATE_ATTACH6_DURATION = 140;
    public static final int FIELD_ESTATE_ATTACH6_TEXT = 141;
    public static final int FIELD_ESTATE_ATTACH7_NAME = 142;
    public static final int FIELD_ESTATE_ATTACH7_SUFFIX = 143;
    public static final int FIELD_ESTATE_ATTACH7_TYPE = 144;
    public static final int FIELD_ESTATE_ATTACH7_DURATION = 145;
    public static final int FIELD_ESTATE_ATTACH7_TEXT = 146;
    public static final int FIELD_ESTATE_ATTACH8_NAME = 147;
    public static final int FIELD_ESTATE_ATTACH8_SUFFIX = 148;
    public static final int FIELD_ESTATE_ATTACH8_TYPE = 149;
    public static final int FIELD_ESTATE_ATTACH8_DURATION = 150;
    public static final int FIELD_ESTATE_ATTACH8_TEXT = 151;
    public static final int FIELD_ESTATE_ATTACH9_NAME = 152;
    public static final int FIELD_ESTATE_ATTACH9_SUFFIX = 153;
    public static final int FIELD_ESTATE_ATTACH9_TYPE = 154;
    public static final int FIELD_ESTATE_ATTACH9_DURATION = 155;
    public static final int FIELD_ESTATE_ATTACH9_TEXT = 156;
    private static Map<String, String> schemaTypeMap = null;
    private static IS24CSVSchema[] csvSchemas = new IS24CSVSchema[]{new IS24CSVSchemaAnlage(), new IS24CSVSchemaGewerbeBueroPraxen(), new IS24CSVSchemaGewerbeEinzelhandel(), new IS24CSVSchemaGewerbeGastronomieHotel(), new IS24CSVSchemaGewerbeHalleProduktion(), new IS24CSVSchemaGewerbeSonstiges(), new IS24CSVSchemaGrundstueckGewerbe(), new IS24CSVSchemaGrundstueckWohnen(), new IS24CSVSchemaHausKauf(), new IS24CSVSchemaHausMiete(), new IS24CSVSchemaStellplatzKauf(), new IS24CSVSchemaStellplatzMiete(), new IS24CSVSchemaWohnenAufZeit(), new IS24CSVSchemaWohnungKauf(), new IS24CSVSchemaWohnungMiete()};

    public static DateFormat getCsvDateFormat() {
        return new SimpleDateFormat("dd.MM.yyyy");
    }

    @Override
    public String getEncoding() {
        return CSV_ENCODING;
    }

    protected Double getFahrtwegDistanz(Long l) {
        if (l == null || l <= 0L) {
            return null;
        }
        return l.doubleValue() / 60.0 * 50.0;
    }

    protected String getFahrtwegZeit(Double d, long l) {
        if (d == null || d <= 0.0) {
            return null;
        }
        long l2 = ((Number)(d / 50.0 * 60.0)).longValue();
        return l2 > 0L && l2 < l ? String.valueOf(l2) : null;
    }

    @Override
    public int getFieldCount() {
        return 182;
    }

    @Override
    public String getFieldSeparator() {
        return CSV_FIELD_SEPARATOR;
    }

    protected Double getFusswegDistanz(Long l) {
        if (l == null || l <= 0L) {
            return null;
        }
        return l.doubleValue() / 60.0 * 3.6;
    }

    protected String getFusswegZeit(Double d, long l) {
        if (d == null || d <= 0.0) {
            return null;
        }
        long l2 = ((Number)(d / 3.6 * 60.0)).longValue();
        return l2 > 0L && l2 < l ? String.valueOf(l2) : null;
    }

    public abstract int getIS24TypeId();

    @Override
    public String getLineSeparator() {
        return CSV_LINE_SEPARATOR;
    }

    @Override
    public String getVersion() {
        return CSV_VERSION;
    }

    public static IS24CSVSchema loadSchema(String string, String[] stringArray) {
        int n;
        String[] stringArray2 = string.replaceAll(Pattern.quote("||"), "| |").concat(" ").split(Pattern.quote(CSV_FIELD_SEPARATOR), 182);
        if (stringArray2.length != stringArray.length) {
            throw new IllegalArgumentException("invalid field-count (" + stringArray2.length + "!=" + 182 + ")!");
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray[n] = stringArray2[n].trim();
        }
        try {
            n = Integer.valueOf(stringArray[2]);
            switch (n) {
                case 12: {
                    return new IS24CSVSchemaAnlage();
                }
                case 7: {
                    return new IS24CSVSchemaGewerbeBueroPraxen();
                }
                case 8: {
                    return new IS24CSVSchemaGewerbeEinzelhandel();
                }
                case 9: {
                    return new IS24CSVSchemaGewerbeGastronomieHotel();
                }
                case 10: {
                    return new IS24CSVSchemaGewerbeHalleProduktion();
                }
                case 11: {
                    return new IS24CSVSchemaGewerbeSonstiges();
                }
                case 5: {
                    char c = CSVReader.getChar(60, stringArray);
                    Integer n2 = CSVReader.getInt(61, stringArray, 56);
                    if (c == '-' || n2 == null) {
                        throw new Exception("Die Grundst\u00fccksart ist ung\u00fcltig!");
                    }
                    if (n2 == 56) {
                        return new IS24CSVSchemaGrundstueckWohnen();
                    }
                    if (n2 == 57 || n2 == 58 || n2 == 59) {
                        return new IS24CSVSchemaGrundstueckGewerbe();
                    }
                    throw new Exception("Unbekannte Grundst\u00fccksart: " + n2);
                }
                case 3: {
                    return new IS24CSVSchemaHausKauf();
                }
                case 1: {
                    return new IS24CSVSchemaHausMiete();
                }
                case 17: {
                    return new IS24CSVSchemaStellplatzKauf();
                }
                case 18: {
                    return new IS24CSVSchemaStellplatzMiete();
                }
                case 4: {
                    return new IS24CSVSchemaWohnenAufZeit();
                }
                case 2: {
                    return new IS24CSVSchemaWohnungKauf();
                }
                case 0: {
                    return new IS24CSVSchemaWohnungMiete();
                }
            }
            throw new Exception("Unbekannte Objektart: " + n);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("CSV-Schema-Error: " + exception.getLocalizedMessage(), exception);
        }
    }

    public static IS24CSVSchema loadSchema(EstateImpl estateImpl) throws IOException, OpenEstateException {
        String string = "VERWALTUNG.NUTZUNGSART";
        String[] stringArray = estateImpl.hasAttribute(string) ? (String[])estateImpl.getAttribute(string).getValueObject() : new String[]{};
        return IS24CSVSchema.loadSchema(estateImpl.getType(), estateImpl.getAction(), Arrays.asList(stringArray));
    }

    public static IS24CSVSchema loadSchema(OpenEstateType openEstateType, String string, List<String> list) throws IOException, OpenEstateException {
        if (openEstateType == null) {
            throw new NullPointerException("empty estate-type!");
        }
        if (string == null) {
            throw new NullPointerException("empty estate-action!");
        }
        List<String> list2 = Arrays.asList(OpenEstateUtils.getEstateTypePath(openEstateType));
        if (list != null && list.contains("ANLAGE") && "KAUF".equals(string) && (list2.contains("MAIN_GEWERBE") || list2.contains("MAIN_WOHNEN"))) {
            return new IS24CSVSchemaAnlage();
        }
        Object object = csvSchemas;
        int n = ((IS24CSVSchema[])object).length;
        for (int i = 0; i < n; ++i) {
            IS24CSVSchema iS24CSVSchema = object[i];
            if (!iS24CSVSchema.supportsEstateAction(string)) continue;
            for (String string2 : list2) {
                if (!iS24CSVSchema.supportsEstateType(string2)) continue;
                return iS24CSVSchema;
            }
        }
        if (list2.contains("MAIN_GEWERBE") && ((IS24CSVSchema)(object = new IS24CSVSchemaGewerbeSonstiges())).supportsEstateAction(string)) {
            return object;
        }
        if (list2.contains("MAIN_GRUND") && ((IS24CSVSchema)(object = new IS24CSVSchemaGrundstueckGewerbe())).supportsEstateAction(string)) {
            return object;
        }
        if (list2.contains("MAIN_LANDWIRTSCHAFT") && ((IS24CSVSchema)(object = new IS24CSVSchemaGewerbeSonstiges())).supportsEstateAction(string)) {
            return object;
        }
        if (list2.contains("MAIN_STELLPLATZ")) {
            if ("KAUF".equals(string)) {
                return new IS24CSVSchemaStellplatzKauf();
            }
            if ("MIETE".equals(string)) {
                return new IS24CSVSchemaStellplatzMiete();
            }
        }
        if (list2.contains("MAIN_WOHNEN")) {
            if ("KAUF".equals(string)) {
                return new IS24CSVSchemaWohnungKauf();
            }
            if ("MIETE".equals(string)) {
                return new IS24CSVSchemaWohnungMiete();
            }
        }
        return null;
    }

    public void readAgent(IS24CSVReader iS24CSVReader, String[] stringArray, AgentImpl agentImpl) {
        agentImpl.setId(CSVReader.getString(15, stringArray));
        String string = CSVReader.getString(28, stringArray, "").trim();
        if (string.length() > 0) {
            try {
                if (!string.toLowerCase().startsWith("http://") && !string.toLowerCase().startsWith("https://")) {
                    string = "http://" + string;
                }
                agentImpl.getCompany().setCompanyWebsite(new URL(string));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("could not read url: " + exception.getLocalizedMessage()), (Throwable)exception);
                agentImpl.getCompany().setCompanyWebsite(null);
            }
        }
    }

    public void readAgentContact(IS24CSVReader iS24CSVReader, String[] stringArray, AgentContactImpl agentContactImpl) {
        agentContactImpl.setPersonFirstName(CSVReader.getString(17, stringArray));
        agentContactImpl.setPersonLastName(CSVReader.getString(18, stringArray));
        agentContactImpl.setStreet(CSVReader.getString(19, stringArray));
        agentContactImpl.setStreetNr(CSVReader.getString(20, stringArray));
        agentContactImpl.setPostalCode(CSVReader.getString(21, stringArray));
        agentContactImpl.setCity(CSVReader.getString(22, stringArray));
        agentContactImpl.setPersonPhone(CSVReader.getString(24, stringArray));
        agentContactImpl.setPersonMobilePhone(CSVReader.getString(25, stringArray));
        agentContactImpl.setPersonFax(CSVReader.getString(26, stringArray));
        agentContactImpl.setPersonMail(CSVReader.getString(27, stringArray));
        String string = CSVReader.getString(16, stringArray);
        if (string == null) {
            agentContactImpl.setPersonGender(null);
        } else if (string.trim().toLowerCase().contains("frau") || string.trim().equalsIgnoreCase("FEMALE")) {
            agentContactImpl.setPersonGender("FEMALE");
        } else if (string.trim().toLowerCase().contains("herr") || string.trim().equalsIgnoreCase("MALE")) {
            agentContactImpl.setPersonGender("MALE");
        }
        String string2 = CSVReader.getString(23, stringArray);
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string2 != null && string2.length() == 3) {
            agentContactImpl.setCountry(OpenEstateUtils.convertToIso2Country(string2));
        } else if (string2 != null && string2.length() == 2) {
            agentContactImpl.setCountry(string2);
        }
    }

    public void readEstate(IS24CSVReader iS24CSVReader, String[] stringArray, EstateImpl estateImpl) {
        boolean bl;
        estateImpl.setPublicId(stringArray[7]);
        estateImpl.getCustomValues().putCustomValue("is24.api.search1", stringArray[11], 5);
        estateImpl.getCustomValues().putCustomValue("is24.api.search2", stringArray[12], 5);
        estateImpl.getCustomValues().putCustomValue("is24.api.search3", stringArray[13], 5);
        estateImpl.getCustomValues().putCustomValue("is24.agent.id", stringArray[15], 5);
        estateImpl.setTitle(CSVReader.getString(36, stringArray, "Immobilienangebot"), iS24CSVReader.getOpenEstateLanguage());
        try {
            estateImpl.setCurrency(Currency.getInstance(CSVReader.getString(38, stringArray, ESTATE_CURRENCY_EUR)));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)exception.getLocalizedMessage());
            estateImpl.setCurrency(Currency.getInstance(Locale.GERMANY));
        }
        String string = CSVReader.getString(37, stringArray, "");
        boolean bl2 = bl = CSVReader.getChar(39, stringArray, 'N') == 'J';
        if (bl) {
            iS24CSVReader.putEstateValue("PREISE", "COURTAGE_AUSSEN", string, estateImpl);
        } else {
            iS24CSVReader.putEstateValue("PREISE", "COURTAGE_INNEN", string, estateImpl);
        }
        iS24CSVReader.putEstateValue("FREITEXTE", "PROVISION_BESCHR", CSVReader.getString(40, stringArray, ""), estateImpl);
        estateImpl.getAdress().setAdressPublished(IS24CSVReader.getChar(35, stringArray, 'N') == 'J');
        estateImpl.getAdress().setStreet(IS24CSVReader.getString(50, stringArray));
        estateImpl.getAdress().setStreetNr(IS24CSVReader.getString(51, stringArray));
        estateImpl.getAdress().setPostalCode(IS24CSVReader.getString(52, stringArray));
        estateImpl.getAdress().setCity(IS24CSVReader.getString(53, stringArray));
        estateImpl.getAdress().setRegion(IS24CSVReader.getString(55, stringArray));
        String string2 = IS24CSVReader.getString(54, stringArray);
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string2 != null && string2.length() == 3) {
            estateImpl.getAdress().setCountry(OpenEstateUtils.convertToIso2Country(string2));
        } else if (string2 != null && string2.length() == 2) {
            estateImpl.getAdress().setCountry(string2);
        }
        iS24CSVReader.putEstateValue("FREITEXTE", "AUSSTATT_BESCHR", IS24CSVReader.getString(100, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FREITEXTE", "OBJEKT_BESCHR", IS24CSVReader.getString(101, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FREITEXTE", "LAGE_BESCHR", IS24CSVReader.getString(99, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FREITEXTE", "SONSTIGE_ANGABEN", IS24CSVReader.getString(102, stringArray), estateImpl);
        EstateAttachmentImpl estateAttachmentImpl = null;
        estateAttachmentImpl = iS24CSVReader.parseEstateAttachment(107, 108, 109, 110, 111, stringArray);
        if (estateAttachmentImpl != null) {
            estateImpl.getAttachments().add(estateAttachmentImpl);
        }
        if ((estateAttachmentImpl = iS24CSVReader.parseEstateAttachment(112, 113, 114, 115, 116, stringArray)) != null) {
            estateImpl.getAttachments().add(estateAttachmentImpl);
        }
        if ((estateAttachmentImpl = iS24CSVReader.parseEstateAttachment(117, 118, 119, 120, 121, stringArray)) != null) {
            estateImpl.getAttachments().add(estateAttachmentImpl);
        }
        if ((estateAttachmentImpl = iS24CSVReader.parseEstateAttachment(122, 123, 124, 125, 126, stringArray)) != null) {
            estateImpl.getAttachments().add(estateAttachmentImpl);
        }
        if ((estateAttachmentImpl = iS24CSVReader.parseEstateAttachment(127, 128, 129, 130, 131, stringArray)) != null) {
            estateImpl.getAttachments().add(estateAttachmentImpl);
        }
        if ((estateAttachmentImpl = iS24CSVReader.parseEstateAttachment(132, 133, 134, 135, 136, stringArray)) != null) {
            estateImpl.getAttachments().add(estateAttachmentImpl);
        }
        if ((estateAttachmentImpl = iS24CSVReader.parseEstateAttachment(137, 138, 139, 140, 141, stringArray)) != null) {
            estateImpl.getAttachments().add(estateAttachmentImpl);
        }
        if ((estateAttachmentImpl = iS24CSVReader.parseEstateAttachment(142, 143, 144, 145, 146, stringArray)) != null) {
            estateImpl.getAttachments().add(estateAttachmentImpl);
        }
        if ((estateAttachmentImpl = iS24CSVReader.parseEstateAttachment(147, 148, 149, 150, 151, stringArray)) != null) {
            estateImpl.getAttachments().add(estateAttachmentImpl);
        }
        if ((estateAttachmentImpl = iS24CSVReader.parseEstateAttachment(152, 153, 154, 155, 156, stringArray)) != null) {
            estateImpl.getAttachments().add(estateAttachmentImpl);
        }
    }

    protected boolean supportsEstateAction(String string) {
        return false;
    }

    protected boolean supportsEstateType(String string) {
        return false;
    }

    protected String[] writeValues(IS24CSVWriter iS24CSVWriter, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl) {
        String string;
        String string2;
        String[] stringArray = new String[182];
        stringArray[0] = String.valueOf('U');
        stringArray[9] = String.valueOf(2);
        Date date = new Date();
        Date date2 = estateImpl.getPublishBegin();
        Date date3 = estateImpl.getPublishEnd();
        stringArray[1] = date2 != null && date.before(date2) ? String.valueOf('0') : (date3 != null && date.after(date3) ? String.valueOf('0') : String.valueOf('1'));
        stringArray[2] = String.valueOf(this.getIS24TypeId());
        stringArray[7] = estateImpl.getId();
        stringArray[15] = agentImpl.getId();
        if (agentContactImpl != null) {
            if (agentContactImpl.isFemale()) {
                stringArray[16] = "Frau";
            } else if (agentContactImpl.isMale()) {
                stringArray[16] = "Herr";
            }
            stringArray[22] = agentContactImpl.getCity();
            stringArray[23] = OpenEstateUtils.convertToIso3Country(agentContactImpl.getCountry());
            stringArray[27] = agentContactImpl.getPersonMail();
            stringArray[17] = agentContactImpl.getPersonFirstName();
            stringArray[18] = agentContactImpl.getPersonLastName();
            stringArray[25] = agentContactImpl.getPersonMobilePhone();
            stringArray[24] = agentContactImpl.getPersonPhone();
            stringArray[21] = agentContactImpl.getPostalCode();
            stringArray[19] = agentContactImpl.getStreet();
            stringArray[20] = agentContactImpl.getStreetNr();
        } else {
            stringArray[23] = OpenEstateUtils.convertToIso3Country(agentImpl.getCompany().getCountry());
            stringArray[27] = agentImpl.getCompany().getCompanyMail();
            stringArray[25] = agentImpl.getCompany().getCompanyMobilePhone();
            stringArray[24] = agentImpl.getCompany().getCompanyPhone();
        }
        if (agentImpl.getCompany().getCompanyWebsite() != null) {
            stringArray[28] = agentImpl.getCompany().getCompanyWebsite().toString();
        }
        stringArray[36] = (string2 = estateImpl.getTitle(iS24CSVWriter.getOpenEstateLanguage())) != null && string2.trim().length() > 0 ? string2.trim() : "ohne titel";
        stringArray[38] = estateImpl.getCurrency() != null ? estateImpl.getCurrency().getCurrencyCode() : Currency.getInstance(Locale.GERMANY).getCurrencyCode();
        stringArray[35] = String.valueOf(estateImpl.getAdress().isAdressPublished() != false ? (char)'J' : 'N');
        stringArray[53] = estateImpl.getAdress().getCity();
        stringArray[54] = OpenEstateUtils.convertToIso3Country(estateImpl.getAdress().getCountry());
        stringArray[52] = estateImpl.getAdress().getPostalCode();
        stringArray[50] = estateImpl.getAdress().getStreet();
        stringArray[51] = estateImpl.getAdress().getStreetNr();
        if (estateImpl.hasAttribute("PREISE.COURTAGE_AUSSEN")) {
            stringArray[39] = String.valueOf('J');
            stringArray[37] = iS24CSVWriter.writeEstateValue("PREISE", "COURTAGE_AUSSEN", estateImpl);
        } else {
            stringArray[39] = String.valueOf('N');
            stringArray[37] = iS24CSVWriter.writeEstateValue("PREISE", "COURTAGE_INNEN", estateImpl);
        }
        stringArray[40] = iS24CSVWriter.writeEstateValue("FREITEXTE", "PROVISION_BESCHR", estateImpl);
        stringArray[100] = StringUtils.abbreviate((String)iS24CSVWriter.writeEstateValue("FREITEXTE", "AUSSTATT_BESCHR", estateImpl), (int)2000);
        stringArray[101] = StringUtils.abbreviate((String)iS24CSVWriter.writeEstateValue("FREITEXTE", "OBJEKT_BESCHR", estateImpl), (int)2000);
        stringArray[99] = StringUtils.abbreviate((String)iS24CSVWriter.writeEstateValue("FREITEXTE", "LAGE_BESCHR", estateImpl), (int)2000);
        stringArray[102] = StringUtils.abbreviate((String)iS24CSVWriter.writeEstateValue("FREITEXTE", "SONSTIGE_ANGABEN", estateImpl), (int)2000);
        if (iS24CSVWriter.isEnergyCertificateAppendedToDescription() && !StringUtils.isBlank((String)(string = OpenEstateUtils.writeEstateEnergyCertificate(estateImpl, iS24CSVWriter.getOpenEstateLanguage(), CSV_LINE_SEPARATOR)))) {
            stringArray[102] = OpenEstateUtils.appendTextToDescription(stringArray[102], string, CSV_LINE_SEPARATOR, 2000, false);
        }
        int n = 0;
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
            boolean bl;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            switch (n) {
                case 0: {
                    n2 = 107;
                    n3 = 108;
                    n4 = 109;
                    n5 = 110;
                    n6 = 111;
                    break;
                }
                case 1: {
                    n2 = 112;
                    n3 = 113;
                    n4 = 114;
                    n5 = 115;
                    n6 = 116;
                    break;
                }
                case 2: {
                    n2 = 117;
                    n3 = 118;
                    n4 = 119;
                    n5 = 120;
                    n6 = 121;
                    break;
                }
                case 3: {
                    n2 = 122;
                    n3 = 123;
                    n4 = 124;
                    n5 = 125;
                    n6 = 126;
                    break;
                }
                case 4: {
                    n2 = 127;
                    n3 = 128;
                    n4 = 129;
                    n5 = 130;
                    n6 = 131;
                    break;
                }
                case 5: {
                    n2 = 132;
                    n3 = 133;
                    n4 = 134;
                    n5 = 135;
                    n6 = 136;
                    break;
                }
                case 6: {
                    n2 = 137;
                    n3 = 138;
                    n4 = 139;
                    n5 = 140;
                    n6 = 141;
                    break;
                }
                case 7: {
                    n2 = 142;
                    n3 = 143;
                    n4 = 144;
                    n5 = 145;
                    n6 = 146;
                    break;
                }
                case 8: {
                    n2 = 147;
                    n3 = 148;
                    n4 = 149;
                    n5 = 150;
                    n6 = 151;
                    break;
                }
                case 9: {
                    n2 = 152;
                    n3 = 153;
                    n4 = 154;
                    n5 = 155;
                    n6 = 156;
                    break;
                }
            }
            if (!(bl = iS24CSVWriter.writeEstateAttachment(stringArray, estateAttachmentImpl, n2, n3, n4, n5, n6)) || ++n <= 9) continue;
            break;
        }
        return stringArray;
    }
}

