/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.is24;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.csv.is24.IS24CSVReader;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchema;
import com.openindex.openestate.impl.csv.is24.IS24CSVWriter;

public class IS24CSVSchemaAnlage
extends IS24CSVSchema {
    public static final int TYPE_ID = 12;
    public static final int FIELD_ESTATE_SUBTYPE = 60;
    public static final int ESTATE_SUBTYPE_EFH = 18;
    public static final int ESTATE_SUBTYPE_MFH = 21;
    public static final int ESTATE_SUBTYPE_EIGENTUMSWOHNUNG = 38;
    public static final int ESTATE_SUBTYPE_EINKAUFSZENTRUM = 70;
    public static final int ESTATE_SUBTYPE_GASTSTAETTE = 82;
    public static final int ESTATE_SUBTYPE_HOTEL = 83;
    public static final int ESTATE_SUBTYPE_FREIZEITANLAGE = 100;
    public static final int ESTATE_SUBTYPE_GEWERBEEINHEIT = 101;
    public static final int ESTATE_SUBTYPE_BUEROGEBAEUDE = 106;
    public static final int ESTATE_SUBTYPE_GAESCHAEFTSHAUS = 107;
    public static final int ESTATE_SUBTYPE_GEWERBEANWESEN = 108;
    public static final int ESTATE_SUBTYPE_HALLE_LAGER = 109;
    public static final int ESTATE_SUBTYPE_INDUSTRIEANWESEN = 110;
    public static final int ESTATE_SUBTYPE_LADEN_VERKAUFSFLAECHE = 111;
    public static final int ESTATE_SUBTYPE_SERVICECENTER = 112;
    public static final int ESTATE_SUBTYPE_SONSTIGES = 113;
    public static final int ESTATE_SUBTYPE_SUPERMARKT = 114;
    public static final int ESTATE_SUBTYPE_WOHN_GESCHAEFTSHAUS = 115;
    public static final int ESTATE_SUBTYPE_WOHNANLAGE = 116;
    public static final int ESTATE_SUBTYPE_DEFAULT = 113;
    public static final int FIELD_ESTATE_FLAECHE_GESAMT = 61;
    public static final int FIELD_ESTATE_FLAECHE_VERMIETBAR = 62;
    public static final int FIELD_ESTATE_FLAECHE_WOHNEN = 63;
    public static final int FIELD_ESTATE_FLAECHE_GEWERBE = 64;
    public static final int FIELD_ESTATE_FLAECHE_GRUNDSTUECK = 65;
    public static final int FIELD_ESTATE_FLAECHE_SONSTIGES = 66;
    public static final int FIELD_ESTATE_ETAGENZAHL = 67;
    public static final int FIELD_ESTATE_BAUJAHR = 68;
    public static final int FIELD_ESTATE_ZUSTAND = 69;
    public static final int ESTATE_ZUSTAND_EMPTY = 0;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG = 1;
    public static final int ESTATE_ZUSTAND_NEUWERTIG = 2;
    public static final int ESTATE_ZUSTAND_VOLLSTAENDIG_RENOVIERT = 3;
    public static final int ESTATE_ZUSTAND_RENOVIERUNGSBEDARF = 4;
    public static final int ESTATE_ZUSTAND_MODERNISIERT = 5;
    public static final int ESTATE_ZUSTAND_NACH_VEREINBARUNG = 6;
    public static final int ESTATE_ZUSTAND_GEPFLEGT = 7;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG_NACH_SANIERUNG = 8;
    public static final int ESTATE_ZUSTAND_SANIERT = 9;
    @Deprecated
    public static final int ESTATE_ZUSTAND_UNRENOVIERT = 10;
    public static final int ESTATE_ZUSTAND_ABBRUCHREIF = 11;
    public static final int FIELD_ESTATE_LIFT_PERSON = 70;
    public static final char ESTATE_LIFT_PERSON_YES = 'J';
    public static final char ESTATE_LIFT_PERSON_NO = 'N';
    public static final int FIELD_ESTATE_X_FACHE = 71;
    public static final int FIELD_ESTATE_MIETEINNAHMEN_IST = 72;
    public static final int FIELD_ESTATE_MIETEINNAHMEN_SOLL = 73;
    public static final int FIELD_ESTATE_ANZAHL_STELLPLAETZE = 74;
    public static final int FIELD_ESTATE_DISTANZ_OEPNV = 75;
    public static final int FIELD_ESTATE_DISTANZ_BAHNHOF = 76;
    public static final int FIELD_ESTATE_DISTANZ_AUTOBAHN = 77;
    public static final int FIELD_ESTATE_DISTANZ_FLUGHAFEN = 78;
    public static final int FIELD_ESTATE_SANIERUNGSJAHR = 80;
    public static final int FIELD_ESTATE_AUSSTATTUNG = 81;
    public static final int ESTATE_AUSSTATTUNG_EMPTY = 1;
    public static final int ESTATE_AUSSTATTUNG_LUXUS = 2;
    public static final int ESTATE_AUSSTATTUNG_GEHOBEN = 3;
    public static final int ESTATE_AUSSTATTUNG_NORMAL = 4;
    public static final int ESTATE_AUSSTATTUNG_EINFACH = 5;
    public static final int FIELD_ESTATE_BEFEUERUNG = 83;
    public static final int ESTATE_BEFEUERUNG_EMPTY = 1;
    public static final int ESTATE_BEFEUERUNG_ERDWAERME = 2;
    public static final int ESTATE_BEFEUERUNG_SOLAR = 3;
    public static final int ESTATE_BEFEUERUNG_PELLET = 4;
    public static final int ESTATE_BEFEUERUNG_GAS = 5;
    public static final int ESTATE_BEFEUERUNG_OEL = 6;
    public static final int ESTATE_BEFEUERUNG_FERNWAERME = 7;
    public static final int ESTATE_BEFEUERUNG_STROM = 8;
    public static final int ESTATE_BEFEUERUNG_KOHLE = 9;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_TYP = 84;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_EMPTY = 1;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_BEDARF = 2;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_VERBRAUCH = 3;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_WERT = 85;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER = 86;
    public static final char ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER_YES = 'J';
    public static final char ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER_NO = 'N';
    public static final int FIELD_ESTATE_HEIZUNGSART = 87;
    public static final int ESTATE_HEIZUNGSART_EMPTY = 0;
    public static final int ESTATE_HEIZUNGSART_ETAGE = 1;
    public static final int ESTATE_HEIZUNGSART_OFEN = 4;
    public static final int ESTATE_HEIZUNGSART_ZENTRAL = 5;
    public static final int FIELD_ESTATE_DENKMALSCHUTZ = 88;
    public static final char ESTATE_DENKMALSCHUTZ_YES = 'J';
    public static final char ESTATE_DENKMALSCHUTZ_NO = 'N';
    public static final int FIELD_ESTATE_KAUFPREIS = 90;
    public static final int FIELD_ESTATE_KAUFPREIS_PRO_QM = 91;
    public static final int FIELD_ESTATE_BETRIEBSKOSTEN_UMGELEGT = 92;
    public static final int FIELD_ESTATE_BETRIEBSKOSTEN_NICHT_UMGELEGT = 93;
    public static final int FIELD_ESTATE_PREIS_PRO_PARKFLAECHE = 94;

    @Override
    public int getIS24TypeId() {
        return 12;
    }

    @Override
    public void readEstate(IS24CSVReader iS24CSVReader, String[] stringArray, EstateImpl estateImpl) {
        Integer n = IS24CSVReader.getInt(60, stringArray, 113);
        if (n == null) {
            throw new NullPointerException("empty subtype!");
        }
        try {
            String string = null;
            switch (n) {
                case 106: {
                    string = "BUEROHAUS";
                    break;
                }
                case 18: {
                    string = "EFH";
                    break;
                }
                case 38: {
                    string = "WOHNUNG";
                    break;
                }
                case 70: {
                    string = "EINKAUFSZENTRUM";
                    break;
                }
                case 100: {
                    string = "FREIZEIT_SPORT";
                    break;
                }
                case 107: {
                    string = "GESCHAEFTSHAUS";
                    break;
                }
                case 82: {
                    string = "GASTRONOMIE";
                    break;
                }
                case 108: {
                    string = "GEWERBEZENTRUM";
                    break;
                }
                case 101: {
                    string = "MAIN_GEWERBE";
                    break;
                }
                case 109: {
                    string = "HALLE_LAGER";
                    break;
                }
                case 83: {
                    string = "HOTEL";
                    break;
                }
                case 110: {
                    string = "INDUSTRIEANLAGE";
                    break;
                }
                case 111: {
                    string = "VERKAUFSFLAECHE";
                    break;
                }
                case 21: {
                    string = "MFH";
                    break;
                }
                case 112: {
                    string = "SERVICECENTER";
                    break;
                }
                case 113: {
                    string = "MAIN_GEWERBE";
                    break;
                }
                case 114: {
                    string = "VERBRAUCHERMARKT";
                    break;
                }
                default: {
                    throw new Exception("unknown estate-type (" + n + ")!");
                }
            }
            estateImpl.setType(string, "KAUF");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Objektart konnte nicht ermittelt werden: " + exception.getLocalizedMessage(), exception);
        }
        super.readEstate(iS24CSVReader, stringArray, estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", IS24CSVReader.getInt(74, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("ZUSTAND", "BAUJAHR", IS24CSVReader.getInt(68, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "DENKMALGESCHUETZT", iS24CSVReader.parseYerOrNo(88, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_AUTOBAHN", this.getFahrtwegDistanz(IS24CSVReader.getLong(77, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_BHF", this.getFahrtwegDistanz(IS24CSVReader.getLong(76, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_FLUG", this.getFahrtwegDistanz(IS24CSVReader.getLong(78, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_BUS", this.getFusswegDistanz(IS24CSVReader.getLong(75, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", IS24CSVReader.getInt(67, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "GESAMTFLAECHE", IS24CSVReader.getFloat(61, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "GEWERBEFLAECHE", IS24CSVReader.getFloat(64, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", IS24CSVReader.getFloat(65, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "SONSTFLAECHE", IS24CSVReader.getFloat(66, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "VERMIETBARE_FLAECHE", IS24CSVReader.getFloat(62, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "WOHNFLAECHE", IS24CSVReader.getFloat(63, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "KAUFPREIS", IS24CSVReader.getFloat(90, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "KAUFPREIS_QM", IS24CSVReader.getFloat(91, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "PERS_LIFT", iS24CSVReader.parseYerOrNo(70, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "MIETEINNAHMEN_IST", IS24CSVReader.getFloat(72, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "MIETEINNAHMEN_SOLL", IS24CSVReader.getFloat(73, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "STELLPLATZ_PREIS", IS24CSVReader.getFloat(94, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("ZUSTAND", "SANIERUNG", IS24CSVReader.getInt(80, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "X_FACHE", IS24CSVReader.getFloat(71, stringArray), estateImpl);
        iS24CSVReader.readEstateAusstattung(stringArray, estateImpl, 81, 1, 5, 3, 2, 4);
        iS24CSVReader.readEstateBefeuerung(stringArray, estateImpl, 83, 2, 7, 5, 9, 6, 4, 3, 8);
        iS24CSVReader.readEstateEnergiepass(stringArray, estateImpl, 84, 1, 2, 3, 85, 86);
        iS24CSVReader.readEstateHeizungsart(stringArray, estateImpl, 87, 0, 1, 4, 5);
        iS24CSVReader.readEstateZustand(stringArray, estateImpl, 69, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
    }

    @Override
    protected boolean supportsEstateAction(String string) {
        return "KAUF".equalsIgnoreCase(string);
    }

    @Override
    protected boolean supportsEstateType(String string) {
        return false;
    }

    @Override
    protected String[] writeValues(IS24CSVWriter iS24CSVWriter, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl) {
        String[] stringArray = super.writeValues(iS24CSVWriter, estateImpl, agentImpl, agentContactImpl);
        int n = -1;
        String string = estateImpl.getType().getName();
        n = "BUEROHAUS".equalsIgnoreCase(string) ? 106 : ("EFH".equalsIgnoreCase(string) ? 18 : ("WOHNUNG".equalsIgnoreCase(string) ? 38 : ("EINKAUFSZENTRUM".equalsIgnoreCase(string) ? 70 : ("FREIZEIT_SPORT".equalsIgnoreCase(string) ? 100 : ("GESCHAEFTSHAUS".equalsIgnoreCase(string) ? 107 : ("GASTRONOMIE".equalsIgnoreCase(string) ? 82 : ("MAIN_GEWERBE".equalsIgnoreCase(string) ? 108 : ("HALLE_LAGER".equalsIgnoreCase(string) ? 109 : ("HOTEL".equalsIgnoreCase(string) || "HOSTEL".equalsIgnoreCase(string) ? 83 : ("INDUSTRIEANLAGE".equalsIgnoreCase(string) ? 110 : ("VERKAUFSFLAECHE".equalsIgnoreCase(string) || "LADEN".equalsIgnoreCase(string) ? 111 : ("MFH".equalsIgnoreCase(string) ? 21 : ("SERVICECENTER".equalsIgnoreCase(string) ? 112 : ("VERBRAUCHERMARKT".equalsIgnoreCase(string) || "KAUFHAUS".equalsIgnoreCase(string) ? 114 : ("WOHNANLAGE".equalsIgnoreCase(string) || "WOHNANLAGE_FUER_SENIOREN".equalsIgnoreCase(string) ? 116 : ("WOHN_GESCHAEFTSHAUS".equalsIgnoreCase(string) ? 115 : 113))))))))))))))));
        stringArray[60] = String.valueOf(n);
        stringArray[74] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl, 5, 0);
        stringArray[68] = iS24CSVWriter.writeEstateValueAsYear("ZUSTAND", "BAUJAHR", estateImpl);
        stringArray[88] = iS24CSVWriter.writeEstateValueAsYesNo("VERWALTUNG", "DENKMALGESCHUETZT", estateImpl);
        stringArray[77] = this.getFahrtwegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_AUTOBAHN", estateImpl), 1000L);
        stringArray[76] = this.getFahrtwegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_BHF", estateImpl), 100L);
        stringArray[78] = this.getFahrtwegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_FLUG", estateImpl), 1000L);
        stringArray[75] = this.getFusswegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_BUS", estateImpl), 100L);
        if (stringArray[75] == null) {
            stringArray[75] = this.getFusswegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_NAHBHF", estateImpl), 100L);
        }
        stringArray[67] = iS24CSVWriter.writeEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl);
        stringArray[61] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GESAMTFLAECHE", estateImpl, 10, 2);
        stringArray[64] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GEWERBEFLAECHE", estateImpl, 10, 2);
        stringArray[65] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl, 10, 2);
        stringArray[66] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "SONSTFLAECHE", estateImpl, 10, 2);
        stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "VERMIETBARE_FLAECHE", estateImpl, 10, 2);
        stringArray[63] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "WOHNFLAECHE", estateImpl, 10, 2);
        stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KAUFPREIS", estateImpl, 15, 2);
        stringArray[91] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KAUFPREIS_QM", estateImpl, 15, 2);
        stringArray[70] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "PERS_LIFT", estateImpl);
        stringArray[72] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "MIETEINNAHMEN_IST", estateImpl, 15, 2);
        stringArray[73] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "MIETEINNAHMEN_SOLL", estateImpl, 15, 2);
        stringArray[94] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "STELLPLATZ_PREIS", estateImpl, 15, 2);
        stringArray[80] = iS24CSVWriter.writeEstateValueAsYear("ZUSTAND", "SANIERUNG", estateImpl);
        stringArray[71] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "X_FACHE", estateImpl, 3, 1);
        iS24CSVWriter.writeEstateAusstattung(stringArray, estateImpl, 81, 1, 5, 3, 2, 4);
        iS24CSVWriter.writeEstateZustand(stringArray, estateImpl, 69, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GESAMTFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "WOHNFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GEWERBEFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = "0";
        }
        return stringArray;
    }
}

