/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.is24;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.csv.is24.IS24CSVReader;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchema;
import com.openindex.openestate.impl.csv.is24.IS24CSVWriter;

public class IS24CSVSchemaGewerbeBueroPraxen
extends IS24CSVSchema {
    public static final int TYPE_ID = 7;
    public static final int FIELD_ESTATE_ACTION = 60;
    public static final char ESTATE_ACTION_KAUF = 'K';
    public static final char ESTATE_ACTION_MIETE = 'M';
    public static final int FIELD_ESTATE_SUBTYPE = 61;
    public static final int ESTATE_SUBTYPE_LOFT = 6;
    public static final int ESTATE_SUBTYPE_ATELIER = 37;
    public static final int ESTATE_SUBTYPE_BUERO = 60;
    public static final int ESTATE_SUBTYPE_BUEROETAGE = 61;
    public static final int ESTATE_SUBTYPE_BUEROHAUS = 62;
    public static final int ESTATE_SUBTYPE_BUEROZENTRUM = 63;
    public static final int ESTATE_SUBTYPE_BUERO_UND_LAGERGEBAEUDE = 64;
    public static final int ESTATE_SUBTYPE_PRAXIS = 65;
    public static final int ESTATE_SUBTYPE_PRAXISETAGE = 66;
    public static final int ESTATE_SUBTYPE_PRAXISHAUS = 67;
    public static final int ESTATE_SUBTYPE_GEWERBEZENTRUM = 68;
    public static final int ESTATE_SUBTYPE_WOHN_GESCHAEFTSGEBAEUDE = 138;
    public static final int ESTATE_SUBTYPE_BUERO_GESCHAEFTSGEBAEUDE = 139;
    public static final int ESTATE_SUBTYPE_DEFAULT = 0;
    public static final int FIELD_ESTATE_FLAECHE_GEWERBE = 62;
    public static final int FIELD_ESTATE_FLAECHE_NEBEN = 63;
    public static final int FIELD_ESTATE_FLAECHE_GESAMT = 64;
    public static final int FIELD_ESTATE_FLAECHE_TEILBAR_AB = 65;
    public static final int FIELD_ESTATE_ANZAHL_STELLPLAETZE = 66;
    public static final int FIELD_ESTATE_ETAGENZAHL = 67;
    public static final int FIELD_ESTATE_BAUJAHR = 68;
    public static final int FIELD_ESTATE_ZUSTAND = 69;
    public static final int ESTATE_ZUSTAND_EMPTY = 0;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG = 1;
    public static final int ESTATE_ZUSTAND_NEUWERTIG = 2;
    public static final int ESTATE_ZUSTAND_VOLLSTAENDIG_RENOVIERT = 3;
    public static final int ESTATE_ZUSTAND_RENOVIERUNGSBEDARF = 4;
    public static final int ESTATE_ZUSTAND_MODERNISIERT = 5;
    public static final int ESTATE_ZUSTAND_NACH_VEREINBARUNG = 6;
    public static final int ESTATE_ZUSTAND_GEPFLEGT = 7;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG_NACH_SANIERUNG = 8;
    public static final int ESTATE_ZUSTAND_SANIERT = 9;
    @Deprecated
    public static final int ESTATE_ZUSTAND_UNRENOVIERT = 10;
    public static final int ESTATE_ZUSTAND_ABBRUCHREIF = 11;
    public static final int FIELD_ESTATE_BODENBELAG = 70;
    public static final int ESTATE_BODENBELAG_EMPTY = 0;
    public static final int ESTATE_BODENBELAG_BETON = 1;
    public static final int ESTATE_BODENBELAG_EPOXIDHARZ = 2;
    public static final int ESTATE_BODENBELAG_FLIESEN = 3;
    public static final int ESTATE_BODENBELAG_LAMINAT = 4;
    public static final int ESTATE_BODENBELAG_PARKETT = 5;
    public static final int ESTATE_BODENBELAG_PVC = 6;
    public static final int ESTATE_BODENBELAG_TEPPICH = 7;
    public static final int ESTATE_BODENBELAG_TEPPICH_ANTISTATISCH = 8;
    public static final int ESTATE_BODENBELAG_STUHLROLLENFESTE_TEPPICHFLIESEN = 9;
    public static final int ESTATE_BODENBELAG_STEIN = 10;
    public static final int ESTATE_BODENBELAG_NACH_WUNSCH = 11;
    public static final int ESTATE_BODENBELAG_OHNE_BELAG = 12;
    public static final int FIELD_ESTATE_LIFT_PERSON = 71;
    public static final char ESTATE_LIFT_PERSON_YES = 'J';
    public static final char ESTATE_LIFT_PERSON_NO = 'N';
    public static final int FIELD_ESTATE_KANTINE_CAFETERIA = 72;
    public static final char ESTATE_KANTINE_CAFETERIA_YES = 'J';
    public static final char ESTATE_KANTINE_CAFETERIA_NO = 'N';
    public static final int FIELD_ESTATE_DV_VERKABELUNG = 73;
    public static final char ESTATE_DV_VERKABELUNG_YES = 'J';
    public static final char ESTATE_DV_VERKABELUNG_NO = 'N';
    public static final char ESTATE_DV_VERKABELUNG_VB = 'V';
    public static final int FIELD_ESTATE_DISTANZ_OEPNV = 74;
    public static final int FIELD_ESTATE_DISTANZ_BAHNHOF = 75;
    public static final int FIELD_ESTATE_DISTANZ_AUTOBAHN = 76;
    public static final int FIELD_ESTATE_DISTANZ_FLUGHAFEN = 77;
    public static final int FIELD_ESTATE_VERFUEGBAR_AB = 78;
    public static final int FIELD_ESTATE_KLIMAANLAGE = 79;
    public static final char ESTATE_KLIMAANLAGE_YES = 'J';
    public static final char ESTATE_KLIMAANLAGE_NO = 'N';
    public static final char ESTATE_KLIMAANLAGE_VB = 'V';
    public static final int FIELD_ESTATE_SANIERUNGSJAHR = 80;
    public static final int FIELD_ESTATE_STARKSTROM = 81;
    public static final char ESTATE_STARKSTROM_YES = 'J';
    public static final char ESTATE_STARKSTROM_NO = 'N';
    public static final int FIELD_ESTATE_BARRIEREFREI = 82;
    public static final char ESTATE_BARRIEREFREI_YES = 'J';
    public static final char ESTATE_BARRIEREFREI_NO = 'N';
    public static final int FIELD_ESTATE_BEFEUERUNG = 83;
    public static final int ESTATE_BEFEUERUNG_EMPTY = 1;
    public static final int ESTATE_BEFEUERUNG_ERDWAERME = 2;
    public static final int ESTATE_BEFEUERUNG_SOLAR = 3;
    public static final int ESTATE_BEFEUERUNG_PELLET = 4;
    public static final int ESTATE_BEFEUERUNG_GAS = 5;
    public static final int ESTATE_BEFEUERUNG_OEL = 6;
    public static final int ESTATE_BEFEUERUNG_FERNWAERME = 7;
    public static final int ESTATE_BEFEUERUNG_STROM = 8;
    public static final int ESTATE_BEFEUERUNG_KOHLE = 9;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_TYP = 84;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_EMPTY = 1;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_BEDARF = 2;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_VERBRAUCH = 3;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_WERT = 85;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER = 86;
    public static final char ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER_YES = 'J';
    public static final char ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER_NO = 'N';
    public static final int FIELD_ESTATE_HEIZUNGSART = 87;
    public static final int ESTATE_HEIZUNGSART_EMPTY = 0;
    public static final int ESTATE_HEIZUNGSART_ETAGE = 1;
    public static final int ESTATE_HEIZUNGSART_OFEN = 4;
    public static final int ESTATE_HEIZUNGSART_ZENTRAL = 5;
    public static final int FIELD_ESTATE_DENKMALSCHUTZ = 88;
    public static final char ESTATE_DENKMALSCHUTZ_YES = 'J';
    public static final char ESTATE_DENKMALSCHUTZ_NO = 'N';
    public static final int FIELD_ESTATE_KELLER = 89;
    public static final char ESTATE_KELLER_YES = 'J';
    public static final char ESTATE_KELLER_NO = 'N';
    public static final int FIELD_ESTATE_KALTMIETE = 90;
    public static final int FIELD_ESTATE_NEBENKOSTEN = 91;
    public static final int FIELD_ESTATE_KALTMIETE_PRO = 92;
    public static final char ESTATE_KALTMIETE_PRO_MONAT = 'M';
    public static final char ESTATE_KALTMIETE_PRO_QM = 'Q';
    public static final int FIELD_ESTATE_KAUFPREIS = 93;
    public static final int FIELD_ESTATE_PREIS_PRO_PARKFLAECHE = 94;
    public static final int FIELD_ESTATE_KAUTION = 95;
    public static final int FIELD_ESTATE_AUSSTATTUNG = 96;
    public static final int ESTATE_AUSSTATTUNG_EMPTY = 1;
    public static final int ESTATE_AUSSTATTUNG_LUXUS = 2;
    public static final int ESTATE_AUSSTATTUNG_GEHOBEN = 3;
    public static final int ESTATE_AUSSTATTUNG_NORMAL = 4;
    public static final int ESTATE_AUSSTATTUNG_EINFACH = 5;
    public static final int FIELD_ESTATE_KUECHE = 97;
    public static final char ESTATE_KUECHE_YES = 'J';
    public static final char ESTATE_KUECHE_NO = 'N';

    @Override
    public int getIS24TypeId() {
        return 7;
    }

    @Override
    public void readEstate(IS24CSVReader iS24CSVReader, String[] stringArray, EstateImpl estateImpl) {
        Integer n = IS24CSVReader.getInt(61, stringArray, 0);
        if (n == null) {
            throw new NullPointerException("empty subtype!");
        }
        char c = IS24CSVReader.getChar(60, stringArray, '-');
        if (c == '-') {
            throw new NullPointerException("empty subtype!");
        }
        try {
            String string = null;
            switch (c) {
                case 'K': {
                    string = "KAUF";
                    break;
                }
                case 'M': {
                    string = "MIETE";
                    break;
                }
                default: {
                    throw new Exception("unknown estate-action (" + c + ")!");
                }
            }
            String string2 = null;
            switch (n) {
                case 37: {
                    string2 = "ATELIERWOHNUNG";
                    break;
                }
                case 60: {
                    string2 = "BUERO";
                    break;
                }
                case 61: {
                    string2 = "BUEROETAGE";
                    break;
                }
                case 62: {
                    string2 = "BUEROHAUS";
                    break;
                }
                case 63: {
                    string2 = "BUEROZENTRUM";
                    break;
                }
                case 139: {
                    string2 = "BUERO_GESCHAEFTSHAUS";
                    break;
                }
                case 64: {
                    string2 = "BUERO_GESCHAEFTSHAUS";
                    break;
                }
                case 68: {
                    string2 = "GEWERBEZENTRUM";
                    break;
                }
                case 6: {
                    string2 = "LOFTWOHNUNG";
                    break;
                }
                case 66: {
                    string2 = "PRAXISETAGE";
                    break;
                }
                case 67: {
                    string2 = "PRAXISHAUS";
                    break;
                }
                case 138: {
                    string2 = "WOHN_GESCHAEFTSHAUS";
                    break;
                }
                case 0: {
                    string2 = "BUERO_PRAXIS";
                    break;
                }
                default: {
                    throw new Exception("unknown estate-type (" + n + ")!");
                }
            }
            estateImpl.setType(string2, string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Objektart konnte nicht ermittelt werden: " + exception.getLocalizedMessage(), exception);
        }
        super.readEstate(iS24CSVReader, stringArray, estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", IS24CSVReader.getInt(66, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "BARRIEREFREI", iS24CSVReader.parseYerOrNo(82, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("ZUSTAND", "BAUJAHR", IS24CSVReader.getInt(68, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "DENKMALGESCHUETZT", iS24CSVReader.parseYerOrNo(88, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_AUTOBAHN", this.getFahrtwegDistanz(IS24CSVReader.getLong(76, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_BHF", this.getFahrtwegDistanz(IS24CSVReader.getLong(75, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_FLUG", this.getFahrtwegDistanz(IS24CSVReader.getLong(77, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_BUS", this.getFusswegDistanz(IS24CSVReader.getLong(74, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", IS24CSVReader.getInt(67, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "GESAMTFLAECHE", IS24CSVReader.getFloat(64, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "GEWERBEFLAECHE", IS24CSVReader.getFloat(62, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "SONSTFLAECHE", IS24CSVReader.getFloat(63, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "TEILBAR_AB", IS24CSVReader.getFloat(65, stringArray), estateImpl);
        if (c == 'M') {
            char c2 = IS24CSVReader.getChar(92, stringArray, '-');
            if (c2 == 'Q') {
                iS24CSVReader.putEstateValue("PREISE", "KALTMIETE_QM", IS24CSVReader.getFloat(90, stringArray), estateImpl);
            } else {
                iS24CSVReader.putEstateValue("PREISE", "KALTMIETE", IS24CSVReader.getFloat(90, stringArray), estateImpl);
            }
            iS24CSVReader.putEstateValue("PREISE", "STELLPLATZ_MIETE", IS24CSVReader.getFloat(94, stringArray), estateImpl);
        }
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "KANTINE_CAFETERIA", iS24CSVReader.parseYerOrNo(72, stringArray), estateImpl);
        if (c == 'K') {
            iS24CSVReader.putEstateValue("PREISE", "KAUFPREIS", IS24CSVReader.getFloat(93, stringArray), estateImpl);
            iS24CSVReader.putEstateValue("PREISE", "STELLPLATZ_PREIS", IS24CSVReader.getFloat(94, stringArray), estateImpl);
        }
        iS24CSVReader.putEstateValue("PREISE", "KAUTION_BETRAG", IS24CSVReader.getFloat(95, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "KLIMATISIERT", iS24CSVReader.parseYerOrNo(79, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "PERS_LIFT", iS24CSVReader.parseYerOrNo(71, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "NEBENKOSTEN", IS24CSVReader.getFloat(91, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("ZUSTAND", "SANIERUNG", IS24CSVReader.getInt(80, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", IS24CSVReader.getString(78, stringArray), estateImpl);
        iS24CSVReader.readEstateAusstattung(stringArray, estateImpl, 96, 1, 5, 3, 2, 4);
        iS24CSVReader.readEstateBefeuerung(stringArray, estateImpl, 83, 2, 7, 5, 9, 6, 4, 3, 8);
        iS24CSVReader.readEstateBodenbelag(stringArray, estateImpl, 70, 0, 1, 2, 3, 4, 11, 12, 5, 6, 10, 7, 8, 9);
        if (Boolean.TRUE.equals(iS24CSVReader.parseYerOrNo(73, stringArray))) {
            iS24CSVReader.putEstateValue("AUSSTATTUNG", "TECHNIK", "DV_VERKABELUNG", estateImpl);
        }
        iS24CSVReader.readEstateEnergiepass(stringArray, estateImpl, 84, 1, 2, 3, 85, 86);
        iS24CSVReader.readEstateHeizungsart(stringArray, estateImpl, 87, 0, 1, 4, 5);
        iS24CSVReader.readEstateKeller(stringArray, estateImpl, 89);
        if (Boolean.TRUE.equals(iS24CSVReader.parseYerOrNo(97, stringArray))) {
            iS24CSVReader.putEstateValue("AUSSTATTUNG", "KUECHE", "EINBAUKUECHE", estateImpl);
        }
        if (Boolean.TRUE.equals(iS24CSVReader.parseYerOrNo(81, stringArray))) {
            iS24CSVReader.putEstateValue("AUSSTATTUNG", "TECHNIK", "STARKSTROM", estateImpl);
        }
        iS24CSVReader.readEstateZustand(stringArray, estateImpl, 69, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
    }

    @Override
    protected boolean supportsEstateAction(String string) {
        return "KAUF".equalsIgnoreCase(string) || "MIETE".equalsIgnoreCase(string) || "PACHT".equalsIgnoreCase(string);
    }

    @Override
    protected boolean supportsEstateType(String string) {
        return "BUERO_GESCHAEFTSHAUS".equalsIgnoreCase(string) || "BUERO_PRAXIS".equalsIgnoreCase(string);
    }

    @Override
    protected String[] writeValues(IS24CSVWriter iS24CSVWriter, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl) {
        String[] stringArray = super.writeValues(iS24CSVWriter, estateImpl, agentImpl, agentContactImpl);
        int n = 45;
        if ("KAUF".equalsIgnoreCase(estateImpl.getAction())) {
            n = 75;
        } else if ("MIETE".equalsIgnoreCase(estateImpl.getAction())) {
            n = 77;
        } else if ("PACHT".equalsIgnoreCase(estateImpl.getAction())) {
            n = 77;
        } else {
            throw new IllegalArgumentException("ung\u00fcltige nutzungsart: " + estateImpl.getAction());
        }
        stringArray[60] = String.valueOf((char)n);
        int n2 = -1;
        String string = estateImpl.getType().getName();
        n2 = "ATELIERWOHNUNG".equalsIgnoreCase(string) ? 37 : ("BUERO".equalsIgnoreCase(string) ? 60 : ("BUEROETAGE".equalsIgnoreCase(string) ? 61 : ("BUEROHAUS".equalsIgnoreCase(string) ? 62 : ("BUEROZENTRUM".equalsIgnoreCase(string) ? 63 : ("GEWERBEZENTRUM".equalsIgnoreCase(string) ? 68 : ("LOFTWOHNUNG".equalsIgnoreCase(string) ? 6 : ("PRAXIS".equalsIgnoreCase(string) ? 65 : ("PRAXISETAGE".equalsIgnoreCase(string) ? 66 : ("PRAXISHAUS".equalsIgnoreCase(string) ? 67 : ("WOHN_GESCHAEFTSHAUS".equalsIgnoreCase(string) ? 138 : 0))))))))));
        stringArray[61] = String.valueOf(n2);
        stringArray[66] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl, 5, 0);
        stringArray[82] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "BARRIEREFREI", estateImpl);
        stringArray[68] = iS24CSVWriter.writeEstateValueAsYear("ZUSTAND", "BAUJAHR", estateImpl);
        stringArray[88] = iS24CSVWriter.writeEstateValueAsYesNo("VERWALTUNG", "DENKMALGESCHUETZT", estateImpl);
        stringArray[76] = this.getFahrtwegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_AUTOBAHN", estateImpl), 1000L);
        stringArray[75] = this.getFahrtwegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_BHF", estateImpl), 100L);
        stringArray[77] = this.getFahrtwegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_FLUG", estateImpl), 1000L);
        stringArray[74] = this.getFusswegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_BUS", estateImpl), 100L);
        if (stringArray[74] == null) {
            stringArray[74] = this.getFusswegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_NAHBHF", estateImpl), 100L);
        }
        if (Boolean.TRUE.equals(iS24CSVWriter.hasEstateValue("AUSSTATTUNG", "TECHNIK", "DV_VERKABELUNG", estateImpl))) {
            stringArray[73] = String.valueOf('J');
        }
        stringArray[67] = iS24CSVWriter.writeEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl);
        stringArray[64] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GESAMTFLAECHE", estateImpl, 10, 2);
        stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GEWERBEFLAECHE", estateImpl, 10, 2);
        stringArray[63] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "SONSTFLAECHE", estateImpl, 10, 2);
        stringArray[65] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "TEILBAR_AB", estateImpl, 10, 2);
        stringArray[72] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "KANTINE_CAFETERIA", estateImpl);
        stringArray[95] = iS24CSVWriter.writeEstateValue("PREISE", "KAUTION_BETRAG", estateImpl);
        stringArray[71] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "PERS_LIFT", estateImpl);
        stringArray[91] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "NEBENKOSTEN", estateImpl, 15, 2);
        stringArray[80] = iS24CSVWriter.writeEstateValueAsYear("ZUSTAND", "SANIERUNG", estateImpl);
        if (Boolean.TRUE.equals(iS24CSVWriter.hasEstateValue("AUSSTATTUNG", "TECHNIK", "STARKSTROM", estateImpl))) {
            stringArray[81] = String.valueOf('J');
        }
        stringArray[78] = iS24CSVWriter.writeEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl);
        if ("PACHT".equals(estateImpl.getAction())) {
            stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "PACHT", estateImpl, 15, 2);
            stringArray[92] = String.valueOf('M');
        } else {
            switch (n) {
                case 75: {
                    stringArray[93] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KAUFPREIS", estateImpl, 15, 2);
                    stringArray[94] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "STELLPLATZ_MIETE", estateImpl, 15, 2);
                    break;
                }
                case 77: {
                    if (estateImpl.hasAttribute("PREISE.KALTMIETE")) {
                        stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KALTMIETE", estateImpl, 15, 2);
                        stringArray[92] = String.valueOf('M');
                    } else if (estateImpl.hasAttribute("PREISE.KALTMIETE_QM")) {
                        stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KALTMIETE_QM", estateImpl, 15, 2);
                        stringArray[92] = String.valueOf('Q');
                    }
                    stringArray[94] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "STELLPLATZ_PREIS", estateImpl, 15, 2);
                    break;
                }
            }
        }
        iS24CSVWriter.writeEstateAusstattung(stringArray, estateImpl, 96, 1, 5, 3, 2, 4);
        iS24CSVWriter.writeEstateBefeuerung(stringArray, estateImpl, 83, 2, 7, 5, 9, 6, 4, 3, 8);
        iS24CSVWriter.writeEstateBodenbelag(stringArray, estateImpl, 70, 0, 1, 2, 3, 4, 11, 12, 5, 6, 10, 7, 8, 9);
        iS24CSVWriter.writeEstateEnergiepass(stringArray, estateImpl, 84, 1, 2, 3, 85, 86);
        iS24CSVWriter.writeEstateHeizungsart(stringArray, estateImpl, 87, 1, 4, 5);
        iS24CSVWriter.writeEstateKeller(stringArray, estateImpl, 89);
        iS24CSVWriter.writeEstateZustand(stringArray, estateImpl, 69, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GESAMTFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "BUEROFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "NUTZFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = "0";
        }
        return stringArray;
    }
}

