/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.is24;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.csv.is24.IS24CSVReader;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchema;
import com.openindex.openestate.impl.csv.is24.IS24CSVWriter;

public class IS24CSVSchemaGewerbeGastronomieHotel
extends IS24CSVSchema {
    public static final int TYPE_ID = 9;
    public static final int FIELD_ESTATE_ACTION = 60;
    public static final char ESTATE_ACTION_KAUF = 'K';
    public static final char ESTATE_ACTION_MIETE = 'M';
    public static final int FIELD_ESTATE_SUBTYPE = 61;
    public static final int ESTATE_SUBTYPE_BAR_LOUNGE = 78;
    public static final int ESTATE_SUBTYPE_CAFE = 79;
    public static final int ESTATE_SUBTYPE_CLUB_DISCO = 80;
    public static final int ESTATE_SUBTYPE_GAESTEHAUS = 81;
    public static final int ESTATE_SUBTYPE_GASTSTAETTE = 82;
    public static final int ESTATE_SUBTYPE_HOTEL = 83;
    public static final int ESTATE_SUBTYPE_HOTELANWESEN = 84;
    public static final int ESTATE_SUBTYPE_HOTEL_GARNI = 85;
    public static final int ESTATE_SUBTYPE_PENSION = 86;
    public static final int ESTATE_SUBTYPE_RESTAURANT = 87;
    public static final int ESTATE_SUBTYPE_FERIENBUNGALOW = 104;
    public static final int ESTATE_SUBTYPE_DEFAULT = 81;
    public static final int FIELD_ESTATE_FLAECHE_GEWERBE = 62;
    public static final int FIELD_ESTATE_FLAECHE_NEBEN = 63;
    public static final int FIELD_ESTATE_FLAECHE_GESAMT = 64;
    public static final int FIELD_ESTATE_ANZAHL_STELLPLAETZE = 65;
    public static final int FIELD_ESTATE_ETAGENZAHL = 66;
    public static final int FIELD_ESTATE_BAUJAHR = 67;
    public static final int FIELD_ESTATE_ZUSTAND = 68;
    public static final int ESTATE_ZUSTAND_EMPTY = 0;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG = 1;
    public static final int ESTATE_ZUSTAND_NEUWERTIG = 2;
    public static final int ESTATE_ZUSTAND_VOLLSTAENDIG_RENOVIERT = 3;
    public static final int ESTATE_ZUSTAND_RENOVIERUNGSBEDARF = 4;
    public static final int ESTATE_ZUSTAND_MODERNISIERT = 5;
    public static final int ESTATE_ZUSTAND_NACH_VEREINBARUNG = 6;
    public static final int ESTATE_ZUSTAND_GEPFLEGT = 7;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG_NACH_SANIERUNG = 8;
    public static final int ESTATE_ZUSTAND_SANIERT = 9;
    @Deprecated
    public static final int ESTATE_ZUSTAND_UNRENOVIERT = 10;
    public static final int ESTATE_ZUSTAND_ABBRUCHREIF = 11;
    public static final int FIELD_ESTATE_LIFT_PERSON = 69;
    public static final char ESTATE_LIFT_PERSON_YES = 'J';
    public static final char ESTATE_LIFT_PERSON_NO = 'N';
    public static final int FIELD_ESTATE_ANZAHL_GASTRAUMPLAETZE = 70;
    public static final int FIELD_ESTATE_ANZAHL_BETTEN = 71;
    public static final int FIELD_ESTATE_GASTTERRASSE = 72;
    public static final char ESTATE_GASTTERRASSE_YES = 'J';
    public static final char ESTATE_GASTTERRASSE_NO = 'N';
    public static final int FIELD_ESTATE_DISTANZ_OEPNV = 73;
    public static final int FIELD_ESTATE_DISTANZ_BAHNHOF = 74;
    public static final int FIELD_ESTATE_DISTANZ_AUTOBAHN = 75;
    public static final int FIELD_ESTATE_DISTANZ_FLUGHAFEN = 76;
    public static final int FIELD_ESTATE_VERFUEGBAR_AB = 77;
    public static final int FIELD_ESTATE_SANIERUNGSJAHR = 80;
    public static final int FIELD_ESTATE_AUSSTATTUNG = 81;
    public static final int ESTATE_AUSSTATTUNG_EMPTY = 1;
    public static final int ESTATE_AUSSTATTUNG_LUXUS = 2;
    public static final int ESTATE_AUSSTATTUNG_GEHOBEN = 3;
    public static final int ESTATE_AUSSTATTUNG_NORMAL = 4;
    public static final int ESTATE_AUSSTATTUNG_EINFACH = 5;
    public static final int FIELD_ESTATE_BEFEUERUNG = 83;
    public static final int ESTATE_BEFEUERUNG_EMPTY = 1;
    public static final int ESTATE_BEFEUERUNG_ERDWAERME = 2;
    public static final int ESTATE_BEFEUERUNG_SOLAR = 3;
    public static final int ESTATE_BEFEUERUNG_PELLET = 4;
    public static final int ESTATE_BEFEUERUNG_GAS = 5;
    public static final int ESTATE_BEFEUERUNG_OEL = 6;
    public static final int ESTATE_BEFEUERUNG_FERNWAERME = 7;
    public static final int ESTATE_BEFEUERUNG_STROM = 8;
    public static final int ESTATE_BEFEUERUNG_KOHLE = 9;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_TYP = 84;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_EMPTY = 1;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_BEDARF = 2;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_VERBRAUCH = 3;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_WERT = 85;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER = 86;
    public static final char ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER_YES = 'J';
    public static final char ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER_NO = 'N';
    public static final int FIELD_ESTATE_HEIZUNGSART = 87;
    public static final int ESTATE_HEIZUNGSART_EMPTY = 0;
    public static final int ESTATE_HEIZUNGSART_ETAGE = 1;
    public static final int ESTATE_HEIZUNGSART_OFEN = 4;
    public static final int ESTATE_HEIZUNGSART_ZENTRAL = 5;
    public static final int FIELD_ESTATE_DENKMALSCHUTZ = 88;
    public static final char ESTATE_DENKMALSCHUTZ_YES = 'J';
    public static final char ESTATE_DENKMALSCHUTZ_NO = 'N';
    public static final int FIELD_ESTATE_KELLER = 89;
    public static final char ESTATE_KELLER_YES = 'J';
    public static final char ESTATE_KELLER_NO = 'N';
    public static final int FIELD_ESTATE_PREIS = 90;
    public static final int FIELD_ESTATE_NEBENKOSTEN = 91;
    public static final int FIELD_ESTATE_PREIS_PRO_PARKFLAECHE = 92;
    public static final int FIELD_ESTATE_KAUTION = 93;

    @Override
    public int getIS24TypeId() {
        return 9;
    }

    @Override
    public void readEstate(IS24CSVReader iS24CSVReader, String[] stringArray, EstateImpl estateImpl) {
        Integer n = IS24CSVReader.getInt(61, stringArray, 81);
        if (n == null) {
            throw new NullPointerException("empty subtype!");
        }
        char c = IS24CSVReader.getChar(60, stringArray, '-');
        if (c == '-') {
            throw new NullPointerException("empty subtype!");
        }
        try {
            String string = null;
            switch (c) {
                case 'K': {
                    string = "KAUF";
                    break;
                }
                case 'M': {
                    string = "MIETE";
                    break;
                }
                default: {
                    throw new Exception("unknown estate-action (" + c + ")!");
                }
            }
            String string2 = null;
            switch (n) {
                case 78: {
                    string2 = "BAR";
                    break;
                }
                case 79: {
                    string2 = "BISTRO";
                    break;
                }
                case 80: {
                    string2 = "DISKO";
                    break;
                }
                case 104: {
                    string2 = "FERIENHAUS";
                    break;
                }
                case 81: {
                    string2 = "GAST";
                    break;
                }
                case 82: {
                    string2 = "GASTRONOMIE";
                    break;
                }
                case 83: {
                    string2 = "HOTEL";
                    break;
                }
                case 84: {
                    string2 = "HOTEL";
                    break;
                }
                case 85: {
                    string2 = "HOTEL";
                    break;
                }
                case 86: {
                    string2 = "PENSION";
                    break;
                }
                case 87: {
                    string2 = "RESTAURANT";
                    break;
                }
                default: {
                    throw new Exception("unknown estate-type (" + n + ")!");
                }
            }
            estateImpl.setType(string2, string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Objektart konnte nicht ermittelt werden: " + exception.getLocalizedMessage(), exception);
        }
        super.readEstate(iS24CSVReader, stringArray, estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_BETTEN", IS24CSVReader.getInt(71, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_GAESTEZIMMER", IS24CSVReader.getInt(70, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", IS24CSVReader.getInt(65, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("ZUSTAND", "BAUJAHR", IS24CSVReader.getInt(67, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "DENKMALGESCHUETZT", iS24CSVReader.parseYerOrNo(88, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_AUTOBAHN", this.getFahrtwegDistanz(IS24CSVReader.getLong(75, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_BHF", this.getFahrtwegDistanz(IS24CSVReader.getLong(74, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_FLUG", this.getFahrtwegDistanz(IS24CSVReader.getLong(76, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_BUS", this.getFusswegDistanz(IS24CSVReader.getLong(73, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", IS24CSVReader.getInt(66, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "GESAMTFLAECHE", IS24CSVReader.getFloat(64, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "GEWERBEFLAECHE", IS24CSVReader.getFloat(62, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "SONSTFLAECHE", IS24CSVReader.getFloat(63, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "BALKON_TERRASSE", iS24CSVReader.parseYerOrNo(72, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "KAUTION_BETRAG", IS24CSVReader.getFloat(93, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "PERS_LIFT", iS24CSVReader.parseYerOrNo(69, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "NEBENKOSTEN", IS24CSVReader.getFloat(91, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "STELLPLATZ_PREIS", IS24CSVReader.getFloat(92, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("ZUSTAND", "SANIERUNG", IS24CSVReader.getInt(80, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", IS24CSVReader.getString(77, stringArray), estateImpl);
        iS24CSVReader.readEstateAusstattung(stringArray, estateImpl, 81, 1, 5, 3, 2, 4);
        iS24CSVReader.readEstateBefeuerung(stringArray, estateImpl, 83, 2, 7, 5, 9, 6, 4, 3, 8);
        iS24CSVReader.readEstateEnergiepass(stringArray, estateImpl, 84, 1, 2, 3, 85, 86);
        iS24CSVReader.readEstateHeizungsart(stringArray, estateImpl, 87, 0, 1, 4, 5);
        iS24CSVReader.readEstateKeller(stringArray, estateImpl, 89);
        iS24CSVReader.readEstateZustand(stringArray, estateImpl, 68, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
    }

    @Override
    protected boolean supportsEstateAction(String string) {
        return "KAUF".equalsIgnoreCase(string) || "MIETE".equalsIgnoreCase(string) || "PACHT".equalsIgnoreCase(string);
    }

    @Override
    protected boolean supportsEstateType(String string) {
        return "GASTRONOMIE".equalsIgnoreCase(string) || "GAST".equalsIgnoreCase(string);
    }

    @Override
    protected String[] writeValues(IS24CSVWriter iS24CSVWriter, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl) {
        String[] stringArray = super.writeValues(iS24CSVWriter, estateImpl, agentImpl, agentContactImpl);
        int n = 45;
        if ("KAUF".equalsIgnoreCase(estateImpl.getAction())) {
            n = 75;
        } else if ("MIETE".equalsIgnoreCase(estateImpl.getAction())) {
            n = 77;
        } else if ("PACHT".equalsIgnoreCase(estateImpl.getAction())) {
            n = 77;
        } else {
            throw new IllegalArgumentException("ung\u00fcltige nutzungsart: " + estateImpl.getAction());
        }
        stringArray[60] = String.valueOf((char)n);
        int n2 = -1;
        String string = estateImpl.getType().getName();
        n2 = "BAR".equalsIgnoreCase(string) ? 78 : ("BISTRO".equalsIgnoreCase(string) ? 79 : ("DISKO".equalsIgnoreCase(string) ? 80 : ("FERIENHAUS".equalsIgnoreCase(string) ? 104 : ("GAST".equalsIgnoreCase(string) ? 81 : ("GASTRONOMIE".equalsIgnoreCase(string) || "GASTRONOMIE_MIT_WOHNUNG".equalsIgnoreCase(string) ? 82 : ("HOTEL".equalsIgnoreCase(string) || "HOSTEL".equalsIgnoreCase(string) ? 83 : ("PENSION".equalsIgnoreCase(string) ? 86 : ("RESTAURANT".equalsIgnoreCase(string) ? 87 : 81))))))));
        stringArray[61] = String.valueOf(n2);
        stringArray[71] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_BETTEN", estateImpl, 5, 0);
        stringArray[70] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_GAESTEZIMMER", estateImpl, 5, 0);
        stringArray[65] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl, 5, 0);
        stringArray[67] = iS24CSVWriter.writeEstateValueAsYear("ZUSTAND", "BAUJAHR", estateImpl);
        stringArray[88] = iS24CSVWriter.writeEstateValueAsYesNo("VERWALTUNG", "DENKMALGESCHUETZT", estateImpl);
        stringArray[75] = this.getFahrtwegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_AUTOBAHN", estateImpl), 1000L);
        stringArray[74] = this.getFahrtwegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_BHF", estateImpl), 100L);
        stringArray[76] = this.getFahrtwegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_FLUG", estateImpl), 1000L);
        stringArray[73] = this.getFusswegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_BUS", estateImpl), 100L);
        if (stringArray[73] == null) {
            stringArray[73] = this.getFusswegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_NAHBHF", estateImpl), 100L);
        }
        stringArray[66] = iS24CSVWriter.writeEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl);
        stringArray[64] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GESAMTFLAECHE", estateImpl, 10, 2);
        stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GEWERBEFLAECHE", estateImpl, 10, 2);
        stringArray[63] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "SONSTFLAECHE", estateImpl, 10, 2);
        stringArray[93] = iS24CSVWriter.writeEstateValue("PREISE", "KAUTION_BETRAG", estateImpl);
        stringArray[72] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "BALKON_TERRASSE", estateImpl);
        stringArray[69] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "PERS_LIFT", estateImpl);
        stringArray[91] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "NEBENKOSTEN", estateImpl, 15, 2);
        stringArray[80] = iS24CSVWriter.writeEstateValueAsYear("ZUSTAND", "SANIERUNG", estateImpl);
        stringArray[77] = iS24CSVWriter.writeEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl);
        if ("PACHT".equals(estateImpl.getAction())) {
            stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "PACHT", estateImpl, 15, 2);
        } else {
            switch (n) {
                case 75: {
                    stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KAUFPREIS", estateImpl, 15, 2);
                    stringArray[92] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "STELLPLATZ_MIETE", estateImpl, 15, 2);
                    break;
                }
                case 77: {
                    stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KALTMIETE", estateImpl, 15, 2);
                    stringArray[92] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "STELLPLATZ_PREIS", estateImpl, 15, 2);
                }
            }
        }
        iS24CSVWriter.writeEstateAusstattung(stringArray, estateImpl, 81, 1, 5, 3, 2, 4);
        iS24CSVWriter.writeEstateBefeuerung(stringArray, estateImpl, 83, 2, 7, 5, 9, 6, 4, 3, 8);
        iS24CSVWriter.writeEstateEnergiepass(stringArray, estateImpl, 84, 1, 2, 3, 85, 86);
        iS24CSVWriter.writeEstateHeizungsart(stringArray, estateImpl, 87, 1, 4, 5);
        iS24CSVWriter.writeEstateKeller(stringArray, estateImpl, 89);
        iS24CSVWriter.writeEstateZustand(stringArray, estateImpl, 68, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GESAMTFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "LADENFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GASTRAUMFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "NUTZFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = "0";
        }
        return stringArray;
    }
}

