/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.is24;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.csv.is24.IS24CSVReader;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchema;
import com.openindex.openestate.impl.csv.is24.IS24CSVWriter;

public class IS24CSVSchemaGewerbeHalleProduktion
extends IS24CSVSchema {
    public static final int TYPE_ID = 10;
    public static final int FIELD_ESTATE_ACTION = 60;
    public static final char ESTATE_ACTION_KAUF = 'K';
    public static final char ESTATE_ACTION_MIETE = 'M';
    public static final int FIELD_ESTATE_SUBTYPE = 61;
    public static final int ESTATE_SUBTYPE_AUSSTELLUNGSFLAECHE = 69;
    public static final int ESTATE_SUBTYPE_HALLE = 88;
    public static final int ESTATE_SUBTYPE_HOCHREGALLAGER = 89;
    public static final int ESTATE_SUBTYPE_INDUSTRIEHALLE = 90;
    public static final int ESTATE_SUBTYPE_INDUSTRIEHALLE_MIT_FREIFLAECHE = 91;
    public static final int ESTATE_SUBTYPE_KUEHLHAUS = 92;
    public static final int ESTATE_SUBTYPE_KUEHLREGALLAGER = 93;
    public static final int ESTATE_SUBTYPE_LAGER_MIT_FREIFLAECHE = 94;
    public static final int ESTATE_SUBTYPE_LAGERFLAECHE = 95;
    public static final int ESTATE_SUBTYPE_LAGERHALLE = 96;
    public static final int ESTATE_SUBTYPE_SERVICEFLAECHE = 97;
    public static final int ESTATE_SUBTYPE_SPEDITIONSLAGER = 98;
    public static final int ESTATE_SUBTYPE_WERKSTATT = 99;
    public static final int ESTATE_SUBTYPE_DEFAULT = 0;
    public static final int FIELD_ESTATE_FLAECHE_GEWERBE = 62;
    public static final int FIELD_ESTATE_FLAECHE_NEBEN = 63;
    public static final int FIELD_ESTATE_FLAECHE_GESAMT = 64;
    public static final int FIELD_ESTATE_FLAECHE_TEILBAR_AB = 65;
    public static final int FIELD_ESTATE_ANZAHL_STELLPLAETZE = 66;
    public static final int FIELD_ESTATE_ETAGENZAHL = 67;
    public static final int FIELD_ESTATE_BAUJAHR = 68;
    public static final int FIELD_ESTATE_ZUSTAND = 69;
    public static final int ESTATE_ZUSTAND_EMPTY = 0;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG = 1;
    public static final int ESTATE_ZUSTAND_NEUWERTIG = 2;
    public static final int ESTATE_ZUSTAND_VOLLSTAENDIG_RENOVIERT = 3;
    public static final int ESTATE_ZUSTAND_RENOVIERUNGSBEDARF = 4;
    public static final int ESTATE_ZUSTAND_MODERNISIERT = 5;
    public static final int ESTATE_ZUSTAND_NACH_VEREINBARUNG = 6;
    public static final int ESTATE_ZUSTAND_GEPFLEGT = 7;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG_NACH_SANIERUNG = 8;
    public static final int ESTATE_ZUSTAND_SANIERT = 9;
    @Deprecated
    public static final int ESTATE_ZUSTAND_UNRENOVIERT = 10;
    public static final int ESTATE_ZUSTAND_ABBRUCHREIF = 11;
    public static final int FIELD_ESTATE_BODENBELAG = 70;
    public static final int ESTATE_BODENBELAG_EMPTY = 0;
    public static final int ESTATE_BODENBELAG_BETON = 1;
    public static final int ESTATE_BODENBELAG_EPOXIDHARZ = 2;
    public static final int ESTATE_BODENBELAG_FLIESEN = 3;
    public static final int ESTATE_BODENBELAG_LAMINAT = 4;
    public static final int ESTATE_BODENBELAG_PARKETT = 5;
    public static final int ESTATE_BODENBELAG_PVC = 6;
    public static final int ESTATE_BODENBELAG_TEPPICH = 7;
    public static final int ESTATE_BODENBELAG_TEPPICH_ANTISTATISCH = 8;
    public static final int ESTATE_BODENBELAG_STUHLROLLENFESTE_TEPPICHFLIESEN = 9;
    public static final int ESTATE_BODENBELAG_STEIN = 10;
    public static final int ESTATE_BODENBELAG_NACH_WUNSCH = 11;
    public static final int ESTATE_BODENBELAG_OHNE_BELAG = 12;
    public static final int FIELD_ESTATE_LIFT_PERSON = 71;
    public static final char ESTATE_LIFT_PERSON_YES = 'J';
    public static final char ESTATE_LIFT_PERSON_NO = 'N';
    public static final int FIELD_ESTATE_HEBEBUEHNE = 72;
    public static final char ESTATE_HEBEBUEHNE_YES = 'J';
    public static final char ESTATE_HEBEBUEHNE_NO = 'N';
    public static final int FIELD_ESTATE_HALLENHOEHE = 73;
    public static final int FIELD_ESTATE_RAMPE = 74;
    public static final char ESTATE_RAMPE_YES = 'J';
    public static final char ESTATE_RAMPE_NO = 'N';
    public static final int FIELD_ESTATE_BODENBELASTUNG = 75;
    public static final int FIELD_ESTATE_LIFT_LASTEN = 76;
    public static final char ESTATE_LIFT_LASTEN_YES = 'J';
    public static final char ESTATE_LIFT_LASTEN_NO = 'N';
    public static final int FIELD_ESTATE_LIFT_LASTEN_TRAGKRAFT = 77;
    public static final int FIELD_ESTATE_KRANBAHN = 78;
    public static final char ESTATE_KRANBAHN_YES = 'J';
    public static final char ESTATE_KRANBAHN_NO = 'N';
    public static final int FIELD_ESTATE_KRANBAHN_TRAGKRAFT = 79;
    public static final int FIELD_ESTATE_FLAECHE_GRUNDSTUECK = 80;
    public static final int FIELD_ESTATE_STROMANSCHLUSSWERT = 81;
    public static final int FIELD_ESTATE_DISTANZ_OEPNV = 82;
    public static final int FIELD_ESTATE_DISTANZ_BAHNHOF = 83;
    public static final int FIELD_ESTATE_DISTANZ_AUTOBAHN = 84;
    public static final int FIELD_ESTATE_DISTANZ_FLUGHAFEN = 85;
    public static final int FIELD_ESTATE_VERFUEGBAR_AB = 86;
    public static final int FIELD_ESTATE_HEIZUNGSART = 87;
    public static final int ESTATE_HEIZUNGSART_EMPTY = 0;
    public static final int ESTATE_HEIZUNGSART_ETAGE = 1;
    public static final int ESTATE_HEIZUNGSART_OFEN = 4;
    public static final int ESTATE_HEIZUNGSART_ZENTRAL = 5;
    public static final int FIELD_ESTATE_SANIERUNGSJAHR = 88;
    public static final int FIELD_ESTATE_BEFEUERUNG = 89;
    public static final int ESTATE_BEFEUERUNG_EMPTY = 1;
    public static final int ESTATE_BEFEUERUNG_ERDWAERME = 2;
    public static final int ESTATE_BEFEUERUNG_SOLAR = 3;
    public static final int ESTATE_BEFEUERUNG_PELLET = 4;
    public static final int ESTATE_BEFEUERUNG_GAS = 5;
    public static final int ESTATE_BEFEUERUNG_OEL = 6;
    public static final int ESTATE_BEFEUERUNG_FERNWAERME = 7;
    public static final int ESTATE_BEFEUERUNG_STROM = 8;
    public static final int ESTATE_BEFEUERUNG_KOHLE = 9;
    public static final int FIELD_ESTATE_KALTMIETE = 90;
    public static final int FIELD_ESTATE_NEBENKOSTEN = 91;
    public static final int FIELD_ESTATE_KALTMIETE_PRO = 92;
    public static final char ESTATE_KALTMIETE_PRO_MONAT = 'M';
    public static final char ESTATE_KALTMIETE_PRO_QM = 'Q';
    public static final int FIELD_ESTATE_KAUFPREIS = 93;
    public static final int FIELD_ESTATE_PREIS_PRO_PARKFLAECHE = 94;
    public static final int FIELD_ESTATE_KAUTION = 95;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_TYP = 96;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_EMPTY = 1;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_BEDARF = 2;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_VERBRAUCH = 3;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_WERT = 97;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER = 98;
    public static final char ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER_YES = 'J';
    public static final char ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER_NO = 'N';

    @Override
    public int getIS24TypeId() {
        return 10;
    }

    @Override
    public void readEstate(IS24CSVReader iS24CSVReader, String[] stringArray, EstateImpl estateImpl) {
        Integer n = IS24CSVReader.getInt(61, stringArray, 0);
        if (n == null) {
            throw new NullPointerException("empty subtype!");
        }
        char c = IS24CSVReader.getChar(60, stringArray, '-');
        if (c == '-') {
            throw new NullPointerException("empty subtype!");
        }
        try {
            String string = null;
            switch (c) {
                case 'K': {
                    string = "KAUF";
                    break;
                }
                case 'M': {
                    string = "MIETE";
                    break;
                }
                default: {
                    throw new Exception("unknown estate-action (" + c + ")!");
                }
            }
            String string2 = null;
            switch (n) {
                case 69: {
                    string2 = "AUSSTELLUNGSFLAECHE";
                    break;
                }
                case 88: {
                    string2 = "HALLE_LAGER";
                    break;
                }
                case 89: {
                    string2 = "HOCHREGALLAGER";
                    break;
                }
                case 90: {
                    string2 = "INDUSTRIEHALLE";
                    break;
                }
                case 91: {
                    string2 = "INDUSTRIEHALLE_FREIFLAECHE";
                    break;
                }
                case 92: {
                    string2 = "KUEHLHAUS";
                    break;
                }
                case 93: {
                    string2 = "KUEHLREGALLAGER";
                    break;
                }
                case 95: {
                    string2 = "LAGERFLAECHE";
                    break;
                }
                case 96: {
                    string2 = "LAGERHALLE";
                    break;
                }
                case 94: {
                    string2 = "LAGERHALLE";
                    break;
                }
                case 97: {
                    string2 = "SERVICEFLAECHE";
                    break;
                }
                case 98: {
                    string2 = "SPEDITION";
                    break;
                }
                case 99: {
                    string2 = "WERKSTATT";
                    break;
                }
                case 0: {
                    string2 = "HALLE_LAGER";
                    break;
                }
                default: {
                    throw new Exception("unknown estate-type (" + n + ")!");
                }
            }
            estateImpl.setType(string2, string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Objektart konnte nicht ermittelt werden: " + exception.getLocalizedMessage(), exception);
        }
        super.readEstate(iS24CSVReader, stringArray, estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", IS24CSVReader.getInt(66, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("ZUSTAND", "BAUJAHR", IS24CSVReader.getInt(68, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "BODENBELASTUNG", IS24CSVReader.getFloat(75, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_AUTOBAHN", this.getFahrtwegDistanz(IS24CSVReader.getLong(84, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_BHF", this.getFahrtwegDistanz(IS24CSVReader.getLong(83, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_FLUG", this.getFahrtwegDistanz(IS24CSVReader.getLong(85, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("UMFELD", "DISTANZ_BUS", this.getFusswegDistanz(IS24CSVReader.getLong(82, stringArray)), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", IS24CSVReader.getInt(67, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "GESAMTFLAECHE", IS24CSVReader.getFloat(64, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "GEWERBEFLAECHE", IS24CSVReader.getFloat(62, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", IS24CSVReader.getFloat(80, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "SONSTFLAECHE", IS24CSVReader.getFloat(63, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "TEILBAR_AB", IS24CSVReader.getFloat(65, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "HALLENHOEHE", IS24CSVReader.getFloat(73, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "HEBEBUEHNE", iS24CSVReader.parseYerOrNo(72, stringArray), estateImpl);
        if (c == 'M') {
            char c2 = IS24CSVReader.getChar(92, stringArray, '-');
            if (c2 == 'Q') {
                iS24CSVReader.putEstateValue("PREISE", "KALTMIETE_QM", IS24CSVReader.getFloat(90, stringArray), estateImpl);
            } else {
                iS24CSVReader.putEstateValue("PREISE", "KALTMIETE", IS24CSVReader.getFloat(90, stringArray), estateImpl);
            }
        }
        if (c == 'K') {
            iS24CSVReader.putEstateValue("PREISE", "KAUFPREIS", IS24CSVReader.getFloat(93, stringArray), estateImpl);
        }
        iS24CSVReader.putEstateValue("PREISE", "KAUTION_BETRAG", IS24CSVReader.getFloat(95, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "KRAN", iS24CSVReader.parseYerOrNo(78, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "KRAN_GEWICHT", IS24CSVReader.getFloat(79, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "LAST_LIFT", iS24CSVReader.parseYerOrNo(76, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "LAST_LIFT_GEWICHT", IS24CSVReader.getFloat(77, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "PERS_LIFT", iS24CSVReader.parseYerOrNo(71, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "NEBENKOSTEN", IS24CSVReader.getFloat(91, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "STELLPLATZ_PREIS", IS24CSVReader.getFloat(94, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "RAMPE", iS24CSVReader.parseYerOrNo(74, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("ZUSTAND", "SANIERUNG", IS24CSVReader.getInt(88, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "STROMANSCHLUSSWERT", IS24CSVReader.getFloat(81, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", IS24CSVReader.getString(86, stringArray), estateImpl);
        iS24CSVReader.readEstateBefeuerung(stringArray, estateImpl, 89, 2, 7, 5, 9, 6, 4, 3, 8);
        iS24CSVReader.readEstateBodenbelag(stringArray, estateImpl, 70, 0, 1, 2, 3, 4, 11, 12, 5, 6, 10, 7, 8, 9);
        iS24CSVReader.readEstateEnergiepass(stringArray, estateImpl, 96, 1, 2, 3, 97, 98);
        iS24CSVReader.readEstateHeizungsart(stringArray, estateImpl, 87, 0, 1, 4, 5);
        iS24CSVReader.readEstateZustand(stringArray, estateImpl, 69, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
    }

    @Override
    protected boolean supportsEstateAction(String string) {
        return "KAUF".equalsIgnoreCase(string) || "MIETE".equalsIgnoreCase(string) || "PACHT".equalsIgnoreCase(string);
    }

    @Override
    protected boolean supportsEstateType(String string) {
        return "HALLE_LAGER".equalsIgnoreCase(string) || "PRODUKTION".equalsIgnoreCase(string);
    }

    @Override
    protected String[] writeValues(IS24CSVWriter iS24CSVWriter, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl) {
        String[] stringArray = super.writeValues(iS24CSVWriter, estateImpl, agentImpl, agentContactImpl);
        int n = 45;
        if ("KAUF".equalsIgnoreCase(estateImpl.getAction())) {
            n = 75;
        } else if ("MIETE".equalsIgnoreCase(estateImpl.getAction())) {
            n = 77;
        } else if ("PACHT".equalsIgnoreCase(estateImpl.getAction())) {
            n = 77;
        } else {
            throw new IllegalArgumentException("ung\u00fcltige nutzungsart: " + estateImpl.getAction());
        }
        stringArray[60] = String.valueOf((char)n);
        int n2 = -1;
        String string = estateImpl.getType().getName();
        n2 = "AUSSTELLUNGSFLAECHE".equalsIgnoreCase(string) ? 69 : ("HALLE_LAGER".equalsIgnoreCase(string) ? 88 : ("HOCHREGALLAGER".equalsIgnoreCase(string) ? 89 : ("INDUSTRIEHALLE".equalsIgnoreCase(string) ? 90 : ("INDUSTRIEHALLE_FREIFLAECHE".equalsIgnoreCase(string) ? 91 : ("KUEHLHAUS".equalsIgnoreCase(string) ? 92 : ("KUEHLREGALLAGER".equalsIgnoreCase(string) ? 93 : ("LAGERFLAECHE".equalsIgnoreCase(string) ? 95 : ("LAGERHALLE".equalsIgnoreCase(string) ? 96 : ("HALLE_LAGER".equalsIgnoreCase(string) ? 94 : ("SERVICEFLAECHE".equalsIgnoreCase(string) ? 97 : ("SPEDITION".equalsIgnoreCase(string) ? 98 : ("WERKSTATT".equalsIgnoreCase(string) ? 99 : 0))))))))))));
        stringArray[61] = String.valueOf(n2);
        stringArray[66] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl, 5, 0);
        stringArray[68] = iS24CSVWriter.writeEstateValueAsYear("ZUSTAND", "BAUJAHR", estateImpl);
        stringArray[75] = iS24CSVWriter.writeEstateValueAsNumber("AUSSTATTUNG", "BODENBELASTUNG", estateImpl, 7, 2);
        stringArray[84] = this.getFahrtwegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_AUTOBAHN", estateImpl), 1000L);
        stringArray[83] = this.getFahrtwegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_BHF", estateImpl), 100L);
        stringArray[85] = this.getFahrtwegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_FLUG", estateImpl), 1000L);
        stringArray[82] = this.getFusswegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_BUS", estateImpl), 100L);
        if (stringArray[82] == null) {
            stringArray[82] = this.getFusswegZeit(iS24CSVWriter.getEstateValueAsDouble("UMFELD", "DISTANZ_NAHBHF", estateImpl), 100L);
        }
        stringArray[67] = iS24CSVWriter.writeEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl);
        stringArray[64] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GESAMTFLAECHE", estateImpl, 10, 2);
        stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GEWERBEFLAECHE", estateImpl, 10, 2);
        stringArray[80] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl, 10, 2);
        stringArray[63] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "SONSTFLAECHE", estateImpl, 10, 2);
        stringArray[65] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "TEILBAR_AB", estateImpl, 10, 2);
        stringArray[73] = iS24CSVWriter.writeEstateValueAsNumber("AUSSTATTUNG", "HALLENHOEHE", estateImpl, 5, 2);
        stringArray[72] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "HEBEBUEHNE", estateImpl);
        stringArray[95] = iS24CSVWriter.writeEstateValue("PREISE", "KAUTION_BETRAG", estateImpl);
        stringArray[78] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "KRAN", estateImpl);
        stringArray[79] = iS24CSVWriter.writeEstateValueAsNumber("AUSSTATTUNG", "KRAN_GEWICHT", estateImpl, 7, 2);
        stringArray[76] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "LAST_LIFT", estateImpl);
        stringArray[77] = iS24CSVWriter.writeEstateValueAsNumber("AUSSTATTUNG", "LAST_LIFT_GEWICHT", estateImpl, 7, 2);
        stringArray[71] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "PERS_LIFT", estateImpl);
        stringArray[91] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "NEBENKOSTEN", estateImpl, 15, 2);
        stringArray[74] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "RAMPE", estateImpl);
        stringArray[88] = iS24CSVWriter.writeEstateValueAsYear("ZUSTAND", "SANIERUNG", estateImpl);
        stringArray[81] = iS24CSVWriter.writeEstateValueAsNumber("AUSSTATTUNG", "STROMANSCHLUSSWERT", estateImpl, 5, 0);
        stringArray[86] = iS24CSVWriter.writeEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl);
        if ("PACHT".equals(estateImpl.getAction())) {
            stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "PACHT", estateImpl, 15, 2);
            stringArray[92] = String.valueOf('M');
        } else {
            switch (n) {
                case 75: {
                    stringArray[93] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KAUFPREIS", estateImpl, 15, 2);
                    stringArray[94] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "STELLPLATZ_MIETE", estateImpl, 15, 2);
                    break;
                }
                case 77: {
                    if (estateImpl.hasAttribute("PREISE.KALTMIETE")) {
                        stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KALTMIETE", estateImpl, 15, 2);
                        stringArray[92] = String.valueOf('M');
                    } else if (estateImpl.hasAttribute("PREISE.KALTMIETE_QM")) {
                        stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KALTMIETE_QM", estateImpl, 15, 2);
                        stringArray[92] = String.valueOf('Q');
                    }
                    stringArray[94] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "STELLPLATZ_PREIS", estateImpl, 15, 2);
                    break;
                }
            }
        }
        iS24CSVWriter.writeEstateBefeuerung(stringArray, estateImpl, 89, 2, 7, 5, 9, 6, 4, 3, 8);
        iS24CSVWriter.writeEstateBodenbelag(stringArray, estateImpl, 70, 0, 1, 2, 3, 4, 11, 12, 5, 6, 10, 7, 8, 9);
        iS24CSVWriter.writeEstateEnergiepass(stringArray, estateImpl, 96, 1, 2, 3, 97, 98);
        iS24CSVWriter.writeEstateHeizungsart(stringArray, estateImpl, 87, 1, 4, 5);
        iS24CSVWriter.writeEstateZustand(stringArray, estateImpl, 69, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GESAMTFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "LAGERFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "NUTZFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = "0";
        }
        return stringArray;
    }
}

