/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.is24;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.csv.is24.IS24CSVReader;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchema;
import com.openindex.openestate.impl.csv.is24.IS24CSVWriter;
import org.apache.log4j.Logger;

public class IS24CSVSchemaGrundstueckGewerbe
extends IS24CSVSchema {
    private static final Logger LOGGER = Logger.getLogger(IS24CSVSchemaGrundstueckGewerbe.class);
    public static final int TYPE_ID = 5;
    public static final int FIELD_ESTATE_ACTION = 60;
    public static final char ESTATE_ACTION_KAUF = 'K';
    public static final char ESTATE_ACTION_MIETE = 'M';
    public static final char ESTATE_ACTION_PACHT = 'P';
    public static final char ESTATE_ACTION_ERBPACHT = 'E';
    public static final int FIELD_ESTATE_SUBTYPE = 61;
    public static final int ESTATE_SUBTYPE_GEWERBE = 57;
    public static final int ESTATE_SUBTYPE_LAND_FORST = 58;
    public static final int ESTATE_SUBTYPE_FREIZEIT = 59;
    public static final int ESTATE_SUBTYPE_DEFAULT = 57;
    public static final int FIELD_ESTATE_FLAECHE_GRUNDSTUECK = 62;
    public static final int FIELD_ESTATE_FLAECHE_TEILBAR_AB = 63;
    public static final int FIELD_ESTATE_BEBAUBAR_MIT = 64;
    public static final int ESTATE_BEBAUBAR_MIT_ACKERLAND = 1;
    public static final int ESTATE_BEBAUBAR_MIT_BAUERWARTUNGSLAND = 2;
    public static final int ESTATE_BEBAUBAR_MIT_BOOTSSTAENDE = 3;
    public static final int ESTATE_BEBAUBAR_MIT_BUERO = 4;
    public static final int ESTATE_BEBAUBAR_MIT_CAMPING = 5;
    public static final int ESTATE_BEBAUBAR_MIT_EINZELHANDEL_GROSS = 8;
    public static final int ESTATE_BEBAUBAR_MIT_EINZELHANDEL_KLEIN = 9;
    public static final int ESTATE_BEBAUBAR_MIT_GARAGEN = 10;
    public static final int ESTATE_BEBAUBAR_MIT_GARTEN = 11;
    public static final int ESTATE_BEBAUBAR_MIT_GASTRONOMIE = 12;
    public static final int ESTATE_BEBAUBAR_MIT_GEWERBE = 13;
    public static final int ESTATE_BEBAUBAR_MIT_HOTEL = 14;
    public static final int ESTATE_BEBAUBAR_MIT_INDUSTRIE = 15;
    public static final int ESTATE_BEBAUBAR_MIT_KEINE_BEBAUUNG = 16;
    public static final int ESTATE_BEBAUBAR_MIT_KLEINGEWERBE = 17;
    public static final int ESTATE_BEBAUBAR_MIT_LAGER = 18;
    public static final int ESTATE_BEBAUBAR_MIT_OBSTPFLANZUNG = 20;
    public static final int ESTATE_BEBAUBAR_MIT_PARKHAUS = 21;
    public static final int ESTATE_BEBAUBAR_MIT_PRODUKTION = 22;
    public static final int ESTATE_BEBAUBAR_MIT_STELLPLAETZE = 24;
    public static final int ESTATE_BEBAUBAR_MIT_WALD = 26;
    public static final int FIELD_ESTATE_BEBAUBAR_NACH = 65;
    public static final char ESTATE_BEBAUBAR_NACH_UNBEKANNT = 'U';
    public static final char ESTATE_BEBAUBAR_NACH_BEBAUUNGSPLAN = 'B';
    public static final char ESTATE_BEBAUBAR_NACH_NACHBARBEBAUUNG = 'N';
    public static final char ESTATE_BEBAUBAR_NACH_AUSSENGEBIET = 'A';
    public static final int FIELD_ESTATE_ERBPACHT_DAUER = 66;
    public static final int FIELD_ESTATE_BAUGENEHMIGUNG = 67;
    public static final char ESTATE_BAUGENEHMIGUNG_YES = 'J';
    public static final char ESTATE_BAUGENEHMIGUNG_NO = 'N';
    public static final int FIELD_ESTATE_ABRISS = 68;
    public static final char ESTATE_ABRISS_YES = 'J';
    public static final char ESTATE_ABRISS_NO = 'N';
    public static final int FIELD_ESTATE_GRZ = 69;
    public static final int FIELD_ESTATE_GFZ = 70;
    public static final int FIELD_ESTATE_ERSCHLIESSUNG = 71;
    public static final char ESTATE_ERSCHLIESSUNG_ERSCHLOSSEN = 'E';
    public static final char ESTATE_ERSCHLIESSUNG_TEILERSCHLOSSEN = 'T';
    public static final char ESTATE_ERSCHLIESSUNG_UNERSCHLOSSEN = 'U';
    public static final int FIELD_ESTATE_KURZFRISTIG_BEBAUBAR = 72;
    public static final char ESTATE_KURZFRISTIG_BEBAUBAR_YES = 'J';
    public static final char ESTATE_KURZFRISTIG_BEBAUBAR_NO = 'N';
    public static final int FIELD_ESTATE_VERFUEGBAR_AB = 73;
    public static final int FIELD_ESTATE_PREIS = 90;

    @Override
    public int getIS24TypeId() {
        return 5;
    }

    @Override
    public void readEstate(IS24CSVReader iS24CSVReader, String[] stringArray, EstateImpl estateImpl) {
        String[] stringArray2;
        Integer n = IS24CSVReader.getInt(61, stringArray, 57);
        if (n == null) {
            throw new NullPointerException("empty subtype!");
        }
        char c = IS24CSVReader.getChar(60, stringArray, '-');
        if (c == '-') {
            throw new NullPointerException("empty subtype!");
        }
        try {
            stringArray2 = null;
            switch (c) {
                case 'E': {
                    stringArray2 = "ERBPACHT";
                    break;
                }
                case 'K': {
                    stringArray2 = "KAUF";
                    break;
                }
                case 'M': {
                    stringArray2 = "MIETE";
                    break;
                }
                case 'P': {
                    stringArray2 = "PACHT";
                    break;
                }
                default: {
                    throw new Exception("unknown estate-action (" + c + ")!");
                }
            }
            String[] stringArray3 = null;
            switch (n) {
                case 57: {
                    stringArray3 = "GEWERBEGRUND";
                    break;
                }
                case 58: {
                    stringArray3 = "LAND_FORSTGRUND";
                    break;
                }
                case 59: {
                    stringArray3 = "FREIZEITGRUND";
                    break;
                }
                default: {
                    throw new Exception("unknown estate-type (" + n + ")!");
                }
            }
            estateImpl.setType((String)stringArray3, (String)stringArray2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Objektart konnte nicht ermittelt werden: " + exception.getLocalizedMessage(), exception);
        }
        super.readEstate(iS24CSVReader, stringArray, estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "ABRISS", iS24CSVReader.parseYerOrNo(68, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "BAUGENEHMIGUNG", iS24CSVReader.parseYerOrNo(67, stringArray), estateImpl);
        if (c == 'E') {
            iS24CSVReader.putEstateValue("VERWALTUNG", "ERBPACHT_DAUER", iS24CSVReader.parseYerOrNo(66, stringArray), estateImpl);
        }
        iS24CSVReader.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", IS24CSVReader.getFloat(62, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "TEILBAR_AB", IS24CSVReader.getFloat(63, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "GFZ", IS24CSVReader.getFloat(70, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "GRZ", IS24CSVReader.getFloat(69, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "BEBAUBAR_KURZ", iS24CSVReader.parseYerOrNo(72, stringArray), estateImpl);
        if (c == 'E' || c == 'P') {
            iS24CSVReader.putEstateValue("PREISE", "PACHT", IS24CSVReader.getFloat(90, stringArray), estateImpl);
        } else if (c == 'K') {
            iS24CSVReader.putEstateValue("PREISE", "KAUFPREIS", IS24CSVReader.getFloat(90, stringArray), estateImpl);
        } else if (c == 'M') {
            iS24CSVReader.putEstateValue("PREISE", "KALTMIETE", IS24CSVReader.getFloat(90, stringArray), estateImpl);
        }
        iS24CSVReader.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", IS24CSVReader.getString(73, stringArray), estateImpl);
        for (String string : stringArray2 = IS24CSVReader.getString(64, stringArray, "").split(";")) {
            if (string.trim().length() <= 0) continue;
            try {
                int n2 = Integer.valueOf(string.trim());
                String string2 = null;
                switch (n2) {
                    case 1: {
                        string2 = "ACKER";
                        break;
                    }
                    case 2: {
                        string2 = "BAUERWARTUNG";
                        break;
                    }
                    case 3: {
                        string2 = "BOOTSSTAENDE";
                        break;
                    }
                    case 4: {
                        string2 = "BUERO";
                        break;
                    }
                    case 5: {
                        string2 = "CAMPING";
                        break;
                    }
                    case 8: {
                        string2 = "EINZELHANDEL_GROSS";
                        break;
                    }
                    case 9: {
                        string2 = "EINZELHANDEL_KLEIN";
                        break;
                    }
                    case 10: {
                        string2 = "GARAGE";
                        break;
                    }
                    case 11: {
                        string2 = "GARTEN";
                        break;
                    }
                    case 12: {
                        string2 = "GASTRONOMIE";
                        break;
                    }
                    case 13: {
                        string2 = "GEWERBE";
                        break;
                    }
                    case 14: {
                        string2 = "HOTEL";
                        break;
                    }
                    case 15: {
                        string2 = "INDUSTRIE";
                        break;
                    }
                    case 16: {
                        string2 = "KEINE_BEBAUUNG";
                        break;
                    }
                    case 17: {
                        string2 = "KLEINGEWERBE";
                        break;
                    }
                    case 18: {
                        string2 = "LAGER";
                        break;
                    }
                    case 20: {
                        string2 = "OBSTPFLANZUNG";
                        break;
                    }
                    case 21: {
                        string2 = "PARKHAUS";
                        break;
                    }
                    case 22: {
                        string2 = "PRODUKTION";
                        break;
                    }
                    case 24: {
                        string2 = "STELLPLAETZE";
                        break;
                    }
                    case 26: {
                        string2 = "WALD";
                        break;
                    }
                }
                if (string2 == null) continue;
                iS24CSVReader.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", string2, estateImpl);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("befeuerung konnte nicht gelesen werden: " + exception.getLocalizedMessage()));
            }
        }
        iS24CSVReader.readEstateBebaubarNach(stringArray, estateImpl, 65, 'U', 'A', 'B', 'N');
        iS24CSVReader.readEstateErschliessung(stringArray, estateImpl, 71, '-', 'E', 'T', 'U');
    }

    @Override
    protected boolean supportsEstateAction(String string) {
        return "ERBPACHT".equalsIgnoreCase(string) || "KAUF".equalsIgnoreCase(string) || "MIETE".equalsIgnoreCase(string) || "PACHT".equalsIgnoreCase(string);
    }

    @Override
    protected boolean supportsEstateType(String string) {
        return "GEWERBEGRUND".equalsIgnoreCase(string) || "GEMISCHTGRUND".equalsIgnoreCase(string) || "INDUSTRIEGRUND".equalsIgnoreCase(string) || "SONDERNUTZUNG".equalsIgnoreCase(string) || "FREIZEITGRUND".equalsIgnoreCase(string) || "GARTENGRUND".equalsIgnoreCase(string) || "LAND_FORSTGRUND".equalsIgnoreCase(string);
    }

    @Override
    protected String[] writeValues(IS24CSVWriter iS24CSVWriter, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl) {
        String[] stringArray = super.writeValues(iS24CSVWriter, estateImpl, agentImpl, agentContactImpl);
        int n = 45;
        if ("ERBPACHT".equalsIgnoreCase(estateImpl.getAction())) {
            n = 69;
        } else if ("KAUF".equalsIgnoreCase(estateImpl.getAction())) {
            n = 75;
        } else if ("MIETE".equalsIgnoreCase(estateImpl.getAction())) {
            n = 77;
        } else if ("PACHT".equalsIgnoreCase(estateImpl.getAction())) {
            n = 80;
        } else {
            throw new IllegalArgumentException("ung\u00fcltige nutzungsart: " + estateImpl.getAction());
        }
        stringArray[60] = String.valueOf((char)n);
        int n2 = -1;
        String string = estateImpl.getType().getName();
        n2 = "FREIZEITGRUND".equalsIgnoreCase(string) ? 59 : ("GEWERBEGRUND".equalsIgnoreCase(string) ? 57 : ("LAND_FORSTGRUND".equalsIgnoreCase(string) ? 58 : 57));
        stringArray[61] = String.valueOf(n2);
        stringArray[68] = iS24CSVWriter.writeEstateValueAsYesNo("VERWALTUNG", "ABRISS", estateImpl);
        stringArray[67] = iS24CSVWriter.writeEstateValueAsYesNo("VERWALTUNG", "BAUGENEHMIGUNG", estateImpl);
        stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl, 10, 2);
        stringArray[63] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "TEILBAR_AB", estateImpl, 8, 0);
        stringArray[70] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GFZ", estateImpl, 3, 2);
        stringArray[69] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GRZ", estateImpl, 3, 2);
        stringArray[72] = iS24CSVWriter.writeEstateValueAsYesNo("VERWALTUNG", "BEBAUBAR_KURZ", estateImpl);
        stringArray[73] = iS24CSVWriter.writeEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl);
        switch (n) {
            case 69: {
                stringArray[66] = iS24CSVWriter.writeEstateValueAsNumber("VERWALTUNG", "ERBPACHT_DAUER", estateImpl, 3, 0);
                stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "PACHT", estateImpl, 15, 2);
                break;
            }
            case 75: {
                stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KAUFPREIS", estateImpl, 15, 2);
                break;
            }
            case 77: {
                stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KALTMIETE", estateImpl, 15, 2);
                break;
            }
            case 80: {
                stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "PACHT", estateImpl, 15, 2);
            }
        }
        String string2 = "VERWALTUNG.BEBAUBAR_MIT";
        if (estateImpl.hasAttribute(string2)) {
            String[] stringArray2 = (String[])estateImpl.getAttribute(string2).getValueObject();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : stringArray2) {
                int n3 = -1;
                if ("ACKER".equalsIgnoreCase(string3)) {
                    n3 = 1;
                } else if ("BAUERWARTUNG".equalsIgnoreCase(string3)) {
                    n3 = 2;
                } else if ("BOOTSSTAENDE".equalsIgnoreCase(string3)) {
                    n3 = 3;
                } else if ("BUERO".equalsIgnoreCase(string3)) {
                    n3 = 4;
                } else if ("CAMPING".equalsIgnoreCase(string3)) {
                    n3 = 5;
                } else if ("EINZELHANDEL_GROSS".equalsIgnoreCase(string3)) {
                    n3 = 8;
                } else if ("EINZELHANDEL_KLEIN".equalsIgnoreCase(string3)) {
                    n3 = 9;
                } else if ("GARAGE".equalsIgnoreCase(string3)) {
                    n3 = 10;
                } else if ("GARTEN".equalsIgnoreCase(string3)) {
                    n3 = 11;
                } else if ("GASTRONOMIE".equalsIgnoreCase(string3)) {
                    n3 = 12;
                } else if ("GEWERBE".equalsIgnoreCase(string3)) {
                    n3 = 13;
                } else if ("HOTEL".equalsIgnoreCase(string3)) {
                    n3 = 14;
                } else if ("INDUSTRIE".equalsIgnoreCase(string3)) {
                    n3 = 15;
                } else if ("KEINE_BEBAUUNG".equalsIgnoreCase(string3)) {
                    n3 = 16;
                } else if ("LAGER".equalsIgnoreCase(string3)) {
                    n3 = 18;
                } else if ("OBSTPFLANZUNG".equalsIgnoreCase(string3)) {
                    n3 = 20;
                } else if ("PARKHAUS".equalsIgnoreCase(string3)) {
                    n3 = 21;
                } else if ("PRODUKTION".equalsIgnoreCase(string3)) {
                    n3 = 22;
                } else if ("STELLPLAETZE".equalsIgnoreCase(string3)) {
                    n3 = 24;
                } else if ("WALD".equalsIgnoreCase(string3)) {
                    n3 = 26;
                }
                if (n3 <= -1) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(n3);
            }
            stringArray[64] = stringBuilder.toString().trim();
        }
        iS24CSVWriter.writeEstateBebaubarNach(stringArray, estateImpl, 65, 'U', 'A', 'B', 'N');
        iS24CSVWriter.writeEstateErschliessung(stringArray, estateImpl, 71, 'E', 'T', 'U');
        if (n == 69 && (stringArray[66] == null || stringArray[66].trim().length() == 0)) {
            stringArray[66] = "0";
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GESAMTFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "NUTZFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = "0";
        }
        return stringArray;
    }
}

