/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.is24;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.csv.is24.IS24CSVReader;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchema;
import com.openindex.openestate.impl.csv.is24.IS24CSVWriter;
import org.apache.log4j.Logger;

public class IS24CSVSchemaGrundstueckWohnen
extends IS24CSVSchema {
    private static final Logger LOGGER = Logger.getLogger(IS24CSVSchemaGrundstueckWohnen.class);
    public static final int TYPE_ID = 5;
    public static final int FIELD_ESTATE_ACTION = 60;
    public static final char ESTATE_ACTION_KAUF = 'K';
    public static final char ESTATE_ACTION_ERBPACHT = 'E';
    public static final char ESTATE_ACTION_MIETE = 'M';
    public static final char ESTATE_ACTION_PACHT = 'P';
    public static final int FIELD_ESTATE_SUBTYPE = 61;
    public static final int ESTATE_SUBTYPE_WOHNEN = 56;
    public static final int ESTATE_SUBTYPE_DEFAULT = 56;
    public static final int FIELD_ESTATE_FLAECHE_GRUNDSTUECK = 62;
    public static final int FIELD_ESTATE_FLAECHE_TEILBAR_AB = 63;
    public static final int FIELD_ESTATE_BEBAUBAR_MIT = 64;
    public static final int ESTATE_BEBAUBAR_MIT_BAUERWARTUNGSLAND = 2;
    public static final int ESTATE_BEBAUBAR_MIT_DOPPELHAUSHAELFTE = 6;
    public static final int ESTATE_BEBAUBAR_MIT_EINFAMILIENHAUS = 7;
    public static final int ESTATE_BEBAUBAR_MIT_GARAGEN = 10;
    public static final int ESTATE_BEBAUBAR_MIT_GARTEN = 11;
    public static final int ESTATE_BEBAUBAR_MIT_KEINE_BEBAUUNG = 16;
    public static final int ESTATE_BEBAUBAR_MIT_MFH = 19;
    public static final int ESTATE_BEBAUBAR_MIT_OBSTPFLANZUNG = 20;
    public static final int ESTATE_BEBAUBAR_MIT_REIHENHAUS = 23;
    public static final int ESTATE_BEBAUBAR_MIT_STELLPLAETZE = 24;
    public static final int ESTATE_BEBAUBAR_MIT_VILLA = 25;
    public static final int ESTATE_BEBAUBAR_MIT_WALD = 26;
    public static final int FIELD_ESTATE_BEBAUBAR_NACH = 65;
    public static final char ESTATE_BEBAUBAR_NACH_UNBEKANNT = 'U';
    public static final char ESTATE_BEBAUBAR_NACH_BEBAUUNGSPLAN = 'B';
    public static final char ESTATE_BEBAUBAR_NACH_NACHBARBEBAUUNG = 'N';
    public static final char ESTATE_BEBAUBAR_NACH_AUSSENGEBIET = 'A';
    public static final int FIELD_ESTATE_ERBPACHT_DAUER = 66;
    public static final int FIELD_ESTATE_BAUGENEHMIGUNG = 67;
    public static final char ESTATE_BAUGENEHMIGUNG_YES = 'J';
    public static final char ESTATE_BAUGENEHMIGUNG_NO = 'N';
    public static final int FIELD_ESTATE_ABRISS = 68;
    public static final char ESTATE_ABRISS_YES = 'J';
    public static final char ESTATE_ABRISS_NO = 'N';
    public static final int FIELD_ESTATE_GRZ = 69;
    public static final int FIELD_ESTATE_GFZ = 70;
    public static final int FIELD_ESTATE_ERSCHLIESSUNG = 71;
    public static final char ESTATE_ERSCHLIESSUNG_ERSCHLOSSEN = 'E';
    public static final char ESTATE_ERSCHLIESSUNG_TEILERSCHLOSSEN = 'T';
    public static final char ESTATE_ERSCHLIESSUNG_UNERSCHLOSSEN = 'U';
    public static final int FIELD_ESTATE_KURZFRISTIG_BEBAUBAR = 72;
    public static final char ESTATE_KURZFRISTIG_BEBAUBAR_YES = 'J';
    public static final char ESTATE_KURZFRISTIG_BEBAUBAR_NO = 'N';
    public static final int FIELD_ESTATE_VERFUEGBAR_AB = 73;
    public static final int FIELD_ESTATE_PREIS = 90;

    @Override
    public int getIS24TypeId() {
        return 5;
    }

    @Override
    public void readEstate(IS24CSVReader iS24CSVReader, String[] stringArray, EstateImpl estateImpl) {
        String[] stringArray2;
        char c = IS24CSVReader.getChar(60, stringArray, '-');
        if (c == '-') {
            throw new NullPointerException("empty subtype!");
        }
        try {
            String[] stringArray3 = null;
            switch (c) {
                case 'E': {
                    stringArray3 = "ERBPACHT";
                    break;
                }
                case 'K': {
                    stringArray3 = "KAUF";
                    break;
                }
                case 'M': {
                    stringArray3 = "MIETE";
                    break;
                }
                case 'P': {
                    stringArray3 = "PACHT";
                    break;
                }
            }
            estateImpl.setType("WOHNGRUND", (String)stringArray3);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Objektart konnte nicht ermittelt werden: " + exception.getLocalizedMessage(), exception);
        }
        super.readEstate(iS24CSVReader, stringArray, estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "ABRISS", iS24CSVReader.parseYerOrNo(68, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "BAUGENEHMIGUNG", iS24CSVReader.parseYerOrNo(67, stringArray), estateImpl);
        if (c == 'E') {
            iS24CSVReader.putEstateValue("VERWALTUNG", "ERBPACHT_DAUER", iS24CSVReader.parseYerOrNo(66, stringArray), estateImpl);
        }
        iS24CSVReader.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", IS24CSVReader.getFloat(62, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "TEILBAR_AB", IS24CSVReader.getFloat(63, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "GFZ", IS24CSVReader.getFloat(70, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "GRZ", IS24CSVReader.getFloat(69, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "BEBAUBAR_KURZ", iS24CSVReader.parseYerOrNo(72, stringArray), estateImpl);
        if (c == 'E' || c == 'P') {
            iS24CSVReader.putEstateValue("PREISE", "PACHT", IS24CSVReader.getFloat(90, stringArray), estateImpl);
        } else if (c == 'K') {
            iS24CSVReader.putEstateValue("PREISE", "KAUFPREIS", IS24CSVReader.getFloat(90, stringArray), estateImpl);
        } else if (c == 'M') {
            iS24CSVReader.putEstateValue("PREISE", "KALTMIETE", IS24CSVReader.getFloat(90, stringArray), estateImpl);
        }
        iS24CSVReader.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", IS24CSVReader.getString(73, stringArray), estateImpl);
        for (String string : stringArray2 = IS24CSVReader.getString(64, stringArray, "").split(";")) {
            if (string.trim().length() <= 0) continue;
            try {
                int n = Integer.valueOf(string.trim());
                String string2 = null;
                switch (n) {
                    case 2: {
                        string2 = "BAUERWARTUNG";
                        break;
                    }
                    case 6: {
                        string2 = "DOPPELHAUS";
                        break;
                    }
                    case 7: {
                        string2 = "EFH";
                        break;
                    }
                    case 10: {
                        string2 = "GARAGE";
                        break;
                    }
                    case 11: {
                        string2 = "GARTEN";
                        break;
                    }
                    case 16: {
                        string2 = "KEINE_BEBAUUNG";
                        break;
                    }
                    case 19: {
                        string2 = "MFH";
                        break;
                    }
                    case 20: {
                        string2 = "OBSTPFLANZUNG";
                        break;
                    }
                    case 23: {
                        string2 = "REIHENHAUS";
                        break;
                    }
                    case 24: {
                        string2 = "STELLPLAETZE";
                        break;
                    }
                    case 25: {
                        string2 = "VILLA";
                        break;
                    }
                    case 26: {
                        string2 = "WALD";
                        break;
                    }
                }
                if (string2 == null) continue;
                iS24CSVReader.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", string2, estateImpl);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("bebauung konnte nicht gelesen werden: " + exception.getLocalizedMessage()));
            }
        }
        iS24CSVReader.readEstateBebaubarNach(stringArray, estateImpl, 65, 'U', 'A', 'B', 'N');
        iS24CSVReader.readEstateErschliessung(stringArray, estateImpl, 71, '-', 'E', 'T', 'U');
    }

    @Override
    protected boolean supportsEstateAction(String string) {
        return "ERBPACHT".equalsIgnoreCase(string) || "KAUF".equalsIgnoreCase(string) || "MIETE".equalsIgnoreCase(string) || "PACHT".equalsIgnoreCase(string);
    }

    @Override
    protected boolean supportsEstateType(String string) {
        return "WOHNGRUND".equalsIgnoreCase(string);
    }

    @Override
    protected String[] writeValues(IS24CSVWriter iS24CSVWriter, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl) {
        String[] stringArray = super.writeValues(iS24CSVWriter, estateImpl, agentImpl, agentContactImpl);
        int n = 45;
        if ("ERBPACHT".equalsIgnoreCase(estateImpl.getAction())) {
            n = 69;
        } else if ("KAUF".equalsIgnoreCase(estateImpl.getAction())) {
            n = 75;
        } else if ("MIETE".equalsIgnoreCase(estateImpl.getAction())) {
            n = 77;
        } else if ("PACHT".equalsIgnoreCase(estateImpl.getAction())) {
            n = 80;
        } else {
            throw new IllegalArgumentException("ung\u00fcltige nutzungsart: " + estateImpl.getAction());
        }
        stringArray[60] = String.valueOf((char)n);
        stringArray[61] = String.valueOf(56);
        stringArray[68] = iS24CSVWriter.writeEstateValueAsYesNo("VERWALTUNG", "ABRISS", estateImpl);
        stringArray[67] = iS24CSVWriter.writeEstateValueAsYesNo("VERWALTUNG", "BAUGENEHMIGUNG", estateImpl);
        stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl, 10, 2);
        stringArray[63] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "TEILBAR_AB", estateImpl, 8, 0);
        stringArray[70] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GFZ", estateImpl, 1, 2);
        stringArray[69] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GRZ", estateImpl, 1, 2);
        stringArray[72] = iS24CSVWriter.writeEstateValueAsYesNo("VERWALTUNG", "BEBAUBAR_KURZ", estateImpl);
        stringArray[73] = iS24CSVWriter.writeEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl);
        switch (n) {
            case 69: {
                stringArray[66] = iS24CSVWriter.writeEstateValueAsNumber("VERWALTUNG", "ERBPACHT_DAUER", estateImpl, 3, 0);
                stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "PACHT", estateImpl, 15, 2);
                break;
            }
            case 75: {
                stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KAUFPREIS", estateImpl, 15, 2);
                break;
            }
            case 77: {
                stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KALTMIETE", estateImpl, 15, 2);
                break;
            }
            case 80: {
                stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "PACHT", estateImpl, 15, 2);
            }
        }
        String string = "VERWALTUNG.BEBAUBAR_MIT";
        if (estateImpl.hasAttribute(string)) {
            String[] stringArray2 = (String[])estateImpl.getAttribute(string).getValueObject();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray2) {
                int n2 = -1;
                if ("BAUERWARTUNG".equalsIgnoreCase(string2)) {
                    n2 = 2;
                } else if ("DOPPELHAUS".equalsIgnoreCase(string2)) {
                    n2 = 6;
                } else if ("EFH".equalsIgnoreCase(string2)) {
                    n2 = 7;
                } else if ("GARAGE".equalsIgnoreCase(string2)) {
                    n2 = 10;
                } else if ("GARTEN".equalsIgnoreCase(string2)) {
                    n2 = 11;
                } else if ("KEINE_BEBAUUNG".equalsIgnoreCase(string2)) {
                    n2 = 16;
                } else if ("MFH".equalsIgnoreCase(string2)) {
                    n2 = 19;
                } else if ("OBSTPFLANZUNG".equalsIgnoreCase(string2)) {
                    n2 = 20;
                } else if ("REIHENHAUS".equalsIgnoreCase(string2)) {
                    n2 = 23;
                } else if ("STELLPLAETZE".equalsIgnoreCase(string2)) {
                    n2 = 24;
                } else if ("VILLA".equalsIgnoreCase(string2)) {
                    n2 = 25;
                } else if ("WALD".equalsIgnoreCase(string2)) {
                    n2 = 26;
                }
                if (n2 <= -1) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(n2);
            }
            stringArray[64] = stringBuilder.toString().trim();
        }
        iS24CSVWriter.writeEstateBebaubarNach(stringArray, estateImpl, 65, 'U', 'A', 'B', 'N');
        iS24CSVWriter.writeEstateErschliessung(stringArray, estateImpl, 71, 'E', 'T', 'U');
        if (n == 69 && (stringArray[66] == null || stringArray[66].trim().length() == 0)) {
            stringArray[66] = "0";
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GESAMTFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "NUTZFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = "0";
        }
        return stringArray;
    }
}

