/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.is24;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.csv.is24.IS24CSVReader;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchema;
import com.openindex.openestate.impl.csv.is24.IS24CSVWriter;
import org.apache.commons.lang.StringUtils;

public class IS24CSVSchemaHausMiete
extends IS24CSVSchema {
    public static final int TYPE_ID = 1;
    public static final int FIELD_ESTATE_SUBTYPE = 60;
    public static final int ESTATE_SUBTYPE_BAUERNHAUS = 14;
    public static final int ESTATE_SUBTYPE_BUNGALOW = 15;
    public static final int ESTATE_SUBTYPE_DOPPELHAUSHAELFTE = 17;
    public static final int ESTATE_SUBTYPE_EFH = 18;
    public static final int ESTATE_SUBTYPE_MFH = 21;
    public static final int ESTATE_SUBTYPE_VILLA = 24;
    @Deprecated
    public static final int ESTATE_SUBTYPE_REIHENHAUS = 25;
    @Deprecated
    public static final int ESTATE_SUBTYPE_ZFH = 43;
    @Deprecated
    public static final int ESTATE_SUBTYPE_SONSTIGES = 113;
    public static final int ESTATE_SUBTYPE_BESONDERES = 119;
    public static final int ESTATE_SUBTYPE_REIHENMITTELHAUS = 123;
    public static final int ESTATE_SUBTYPE_REIHENECKHAUS = 124;
    public static final int ESTATE_SUBTYPE_SCHLOSS = 125;
    public static final int ESTATE_SUBTYPE_WOHNIMMOBILIE = 126;
    public static final int ESTATE_SUBTYPE_DEFAULT = 0;
    public static final int FIELD_ESTATE_WOHNFLAECHE = 61;
    public static final int FIELD_ESTATE_NUTZFLAECHE = 62;
    public static final int FIELD_ESTATE_ANZAHL_ZIMMER = 63;
    public static final int FIELD_ESTATE_ANZAHL_BADEZIMMER = 64;
    public static final int FIELD_ESTATE_FLAECHE_GRUNDSTUECK = 65;
    public static final int FIELD_ESTATE_ETAGENZAHL = 66;
    public static final int FIELD_ESTATE_BAUJAHR = 67;
    public static final int FIELD_ESTATE_ZUSTAND = 68;
    public static final int ESTATE_ZUSTAND_EMPTY = 0;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG = 1;
    public static final int ESTATE_ZUSTAND_NEUWERTIG = 2;
    public static final int ESTATE_ZUSTAND_VOLLSTAENDIG_RENOVIERT = 3;
    public static final int ESTATE_ZUSTAND_RENOVIERUNGSBEDARF = 4;
    public static final int ESTATE_ZUSTAND_MODERNISIERT = 5;
    public static final int ESTATE_ZUSTAND_NACH_VEREINBARUNG = 6;
    public static final int ESTATE_ZUSTAND_GEPFLEGT = 7;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG_NACH_SANIERUNG = 8;
    public static final int ESTATE_ZUSTAND_SANIERT = 9;
    @Deprecated
    public static final int ESTATE_ZUSTAND_UNRENOVIERT = 10;
    public static final int ESTATE_ZUSTAND_ABBRUCHREIF = 11;
    public static final int FIELD_ESTATE_HEIZUNGSART = 69;
    public static final int ESTATE_HEIZUNGSART_EMPTY = 0;
    public static final int ESTATE_HEIZUNGSART_ETAGE = 1;
    public static final int ESTATE_HEIZUNGSART_OFEN = 4;
    public static final int ESTATE_HEIZUNGSART_ZENTRAL = 5;
    public static final int FIELD_ESTATE_HAUSTIERE = 70;
    public static final char ESTATE_HAUSTIERE_YES = 'J';
    public static final char ESTATE_HAUSTIERE_NO = 'N';
    public static final char ESTATE_HAUSTIERE_VEREINBARUNG = 'V';
    public static final int FIELD_ESTATE_EBK = 71;
    public static final char ESTATE_EBK_YES = 'J';
    public static final char ESTATE_EBK_NO = 'N';
    public static final int FIELD_ESTATE_SENIORENGERECHT = 72;
    public static final char ESTATE_SENIORENGERECHT_YES = 'J';
    public static final char ESTATE_SENIORENGERECHT_NO = 'N';
    public static final int FIELD_ESTATE_ANZAHL_STELLPLAETZE = 73;
    public static final int FIELD_ESTATE_STELLPLATZ = 74;
    public static final char ESTATE_STELLPLATZ_EMPTY = '1';
    public static final char ESTATE_STELLPLATZ_GARAGE = '2';
    public static final char ESTATE_STELLPLATZ_AUSSEN = '3';
    public static final char ESTATE_STELLPLATZ_CARPORT = '4';
    public static final char ESTATE_STELLPLATZ_DUPLEX = '5';
    public static final char ESTATE_STELLPLATZ_PARKHAUS = '6';
    public static final char ESTATE_STELLPLATZ_TIEFGARAGE = '7';
    public static final char ESTATE_STELLPLATZ_YES = 'J';
    public static final char ESTATE_STELLPLATZ_NO = 'N';
    public static final int FIELD_ESTATE_VERFUEGBAR_AB = 75;
    @Deprecated
    public static final int FIELD_ESTATE_ROLLSTUHLGERECHT = 76;
    @Deprecated
    public static final char ESTATE_ROLLSTUHLGERECHT_YES = 'J';
    @Deprecated
    public static final char ESTATE_ROLLSTUHLGERECHT_NO = 'N';
    public static final int FIELD_ESTATE_ANZAHL_SCHLAFZIMMER = 77;
    public static final int FIELD_ESTATE_BEFEUERUNG = 78;
    public static final int ESTATE_BEFEUERUNG_EMPTY = 1;
    public static final int ESTATE_BEFEUERUNG_ERDWAERME = 2;
    public static final int ESTATE_BEFEUERUNG_SOLAR = 3;
    public static final int ESTATE_BEFEUERUNG_PELLET = 4;
    public static final int ESTATE_BEFEUERUNG_GAS = 5;
    public static final int ESTATE_BEFEUERUNG_OEL = 6;
    public static final int ESTATE_BEFEUERUNG_FERNWAERME = 7;
    public static final int ESTATE_BEFEUERUNG_STROM = 8;
    public static final int ESTATE_BEFEUERUNG_KOHLE = 9;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_TYP = 79;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_EMPTY = 1;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_BEDARF = 2;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_VERBRAUCH = 3;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_WERT = 80;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER = 81;
    public static final char ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER_YES = 'J';
    public static final char ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER_NO = 'N';
    public static final int FIELD_ESTATE_GAESTE_WC = 82;
    public static final char ESTATE_GAESTE_WC_YES = 'J';
    public static final char ESTATE_GAESTE_WC_NO = 'N';
    public static final int FIELD_ESTATE_AUSSTATTUNG = 83;
    public static final int ESTATE_AUSSTATTUNG_EMPTY = 1;
    public static final int ESTATE_AUSSTATTUNG_LUXUS = 2;
    public static final int ESTATE_AUSSTATTUNG_GEHOBEN = 3;
    public static final int ESTATE_AUSSTATTUNG_NORMAL = 4;
    public static final int ESTATE_AUSSTATTUNG_EINFACH = 5;
    public static final int FIELD_ESTATE_KELLER = 85;
    public static final char ESTATE_KELLER_YES = 'J';
    public static final char ESTATE_KELLER_NO = 'N';
    public static final int FIELD_ESTATE_BARRIEREFREI = 86;
    public static final char ESTATE_BARRIEREFREI_YES = 'J';
    public static final char ESTATE_BARRIEREFREI_NO = 'N';
    public static final int FIELD_ESTATE_SANIERUNGSJAHR = 88;
    public static final int FIELD_ESTATE_KALTMIETE = 90;
    public static final int FIELD_ESTATE_NEBENKOSTEN = 91;
    public static final int FIELD_ESTATE_WARMMIETE = 92;
    public static final int FIELD_ESTATE_STELLPLATZMIETE = 93;
    public static final int FIELD_ESTATE_KAUTION = 94;
    public static final int FIELD_ESTATE_HEIZKOSTEN = 96;
    public static final int FIELD_ESTATE_NEBENKOSTEN_INKL_HEIZKOSTEN = 97;
    public static final char ESTATE_NEBENKOSTEN_INKL_HEIZKOSTEN_YES = 'J';
    public static final char ESTATE_NEBENKOSTEN_INKL_HEIZKOSTEN_NO = 'N';

    @Override
    public int getIS24TypeId() {
        return 1;
    }

    @Override
    public void readEstate(IS24CSVReader iS24CSVReader, String[] stringArray, EstateImpl estateImpl) {
        Integer n = IS24CSVReader.getInt(60, stringArray, 0);
        if (n == null) {
            throw new NullPointerException("empty subtype!");
        }
        try {
            String string = null;
            switch (n) {
                case 14: {
                    string = "BAUERNHAUS";
                    break;
                }
                case 119: {
                    string = "BESONDERES_HAUS";
                    break;
                }
                case 15: {
                    string = "BUNGALOW";
                    break;
                }
                case 17: {
                    string = "DOPPELHAUSHAELFTE";
                    break;
                }
                case 18: {
                    string = "EFH";
                    break;
                }
                case 21: {
                    string = "MFH";
                    break;
                }
                case 124: {
                    string = "REIHENECKHAUS";
                    break;
                }
                case 25: {
                    string = "REIHENHAUS";
                    break;
                }
                case 123: {
                    string = "REIHENMITTELHAUS";
                    break;
                }
                case 125: {
                    string = "SCHLOSS";
                    break;
                }
                case 113: {
                    string = "HAUS";
                    break;
                }
                case 24: {
                    string = "VILLA";
                    break;
                }
                case 126: {
                    string = "HAUS";
                    break;
                }
                case 43: {
                    string = "ZFH";
                    break;
                }
                default: {
                    string = "HAUS";
                }
            }
            estateImpl.setType(string, "MIETE");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Objektart konnte nicht ermittelt werden: " + exception.getLocalizedMessage(), exception);
        }
        super.readEstate(iS24CSVReader, stringArray, estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_BADEZIMMER", IS24CSVReader.getInt(64, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_SCHLAFZIMMER", IS24CSVReader.getInt(77, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", IS24CSVReader.getInt(73, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_ZIMMER", IS24CSVReader.getFloat(63, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "BARRIEREFREI", iS24CSVReader.parseYerOrNo(86, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("ZUSTAND", "BAUJAHR", IS24CSVReader.getInt(67, stringArray), estateImpl);
        if (Boolean.TRUE.equals(iS24CSVReader.parseYerOrNo(71, stringArray))) {
            iS24CSVReader.putEstateValue("AUSSTATTUNG", "KUECHE", "EINBAUKUECHE", estateImpl);
        }
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", IS24CSVReader.getInt(66, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", IS24CSVReader.getFloat(65, stringArray), estateImpl);
        if (Boolean.TRUE.equals(iS24CSVReader.parseYerOrNo(82, stringArray))) {
            iS24CSVReader.putEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl);
        }
        iS24CSVReader.putEstateValue("PREISE", "HEIZKOSTEN", IS24CSVReader.getFloat(96, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("ZUSTAND", "SANIERUNG", IS24CSVReader.getInt(88, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "KALTMIETE", IS24CSVReader.getFloat(90, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "KAUTION", IS24CSVReader.getString(94, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "NEBENKOSTEN", IS24CSVReader.getFloat(91, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "NEBENKOSTEN_INKL_HEIZKOSTEN", iS24CSVReader.parseYerOrNo(97, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "NUTZFLAECHE", IS24CSVReader.getFloat(62, stringArray), estateImpl);
        if (Boolean.TRUE.equals(iS24CSVReader.parseYerOrNo(76, stringArray))) {
            iS24CSVReader.putEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl);
        }
        if (Boolean.TRUE.equals(iS24CSVReader.parseYerOrNo(72, stringArray))) {
            iS24CSVReader.putEstateValue("AUSSTATTUNG", "EIGNUNG", "SENIOREN", estateImpl);
        }
        iS24CSVReader.putEstateValue("PREISE", "STELLPLATZ_MIETE", IS24CSVReader.getFloat(93, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", IS24CSVReader.getString(75, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "WARMMIETE", IS24CSVReader.getFloat(92, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "WOHNFLAECHE", IS24CSVReader.getFloat(61, stringArray), estateImpl);
        iS24CSVReader.readEstateAusstattung(stringArray, estateImpl, 83, 1, 5, 3, 2, 4);
        iS24CSVReader.readEstateBefeuerung(stringArray, estateImpl, 78, 2, 7, 5, 9, 6, 4, 3, 8);
        iS24CSVReader.readEstateEnergiepass(stringArray, estateImpl, 79, 1, 2, 3, 80, 81);
        iS24CSVReader.readEstateHaustiere(stringArray, estateImpl, 70, 'J', 'N', 'V');
        iS24CSVReader.readEstateHeizungsart(stringArray, estateImpl, 69, 0, 1, 4, 5);
        iS24CSVReader.readEstateKeller(stringArray, estateImpl, 85);
        iS24CSVReader.readEstateStellplatz(stringArray, estateImpl, 74, '1', 'J', '3', '4', '2', '6', '7');
        iS24CSVReader.readEstateZustand(stringArray, estateImpl, 68, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
    }

    @Override
    protected boolean supportsEstateAction(String string) {
        return "MIETE".equalsIgnoreCase(string) || "PACHT".equalsIgnoreCase(string);
    }

    @Override
    protected boolean supportsEstateType(String string) {
        return "HAUS".equalsIgnoreCase(string);
    }

    @Override
    protected String[] writeValues(IS24CSVWriter iS24CSVWriter, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl) {
        String[] stringArray = super.writeValues(iS24CSVWriter, estateImpl, agentImpl, agentContactImpl);
        int n = -1;
        String string = estateImpl.getType().getName();
        n = "BAUERNHAUS".equalsIgnoreCase(string) ? 14 : ("BESONDERES_HAUS".equalsIgnoreCase(string) ? 119 : ("BUNGALOW".equalsIgnoreCase(string) ? 15 : ("DOPPELHAUSHAELFTE".equalsIgnoreCase(string) ? 17 : ("EFH".equalsIgnoreCase(string) ? 18 : ("MFH".equalsIgnoreCase(string) ? 21 : ("REIHENECKHAUS".equalsIgnoreCase(string) ? 124 : ("REIHENMITTELHAUS".equalsIgnoreCase(string) ? 123 : ("REIHENENDHAUS".equalsIgnoreCase(string) ? 123 : ("REIHENHAUS".equalsIgnoreCase(string) ? 123 : ("SCHLOSS".equalsIgnoreCase(string) ? 125 : ("SCHLOSS".equalsIgnoreCase(string) ? 24 : ("MAIN_WOHNEN".equalsIgnoreCase(string) ? 126 : 0))))))))))));
        stringArray[60] = String.valueOf(n);
        stringArray[64] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_BADEZIMMER", estateImpl, 2, 0);
        stringArray[77] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_SCHLAFZIMMER", estateImpl, 2, 0);
        stringArray[73] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl, 2, 0);
        stringArray[63] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_ZIMMER", estateImpl, 6, 2);
        stringArray[86] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "BARRIEREFREI", estateImpl);
        stringArray[67] = iS24CSVWriter.writeEstateValueAsYear("ZUSTAND", "BAUJAHR", estateImpl);
        stringArray[66] = iS24CSVWriter.writeEstateValueAsNumber("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl, 3, 0);
        stringArray[65] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl, 10, 2);
        if ("MIETE".equals(estateImpl.getAction())) {
            stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KALTMIETE", estateImpl, 15, 2);
        } else if ("PACHT".equals(estateImpl.getAction())) {
            stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "PACHT", estateImpl, 15, 2);
        }
        stringArray[94] = iS24CSVWriter.writeEstateValue("PREISE", "KAUTION", estateImpl);
        stringArray[91] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "NEBENKOSTEN", estateImpl, 15, 2);
        stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "NUTZFLAECHE", estateImpl, 10, 2);
        stringArray[88] = iS24CSVWriter.writeEstateValueAsYear("ZUSTAND", "SANIERUNG", estateImpl);
        stringArray[93] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "STELLPLATZ_MIETE", estateImpl, 15, 2);
        stringArray[75] = iS24CSVWriter.writeEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl);
        stringArray[92] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "WARMMIETE", estateImpl, 15, 2);
        stringArray[61] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "WOHNFLAECHE", estateImpl, 10, 2);
        iS24CSVWriter.writeEstateAusstattung(stringArray, estateImpl, 83, 1, 5, 3, 2, 4);
        iS24CSVWriter.writeEstateBefeuerung(stringArray, estateImpl, 78, 2, 7, 5, 9, 6, 4, 3, 8);
        iS24CSVWriter.writeEstateEbk(stringArray, estateImpl, 71);
        iS24CSVWriter.writeEstateEnergiepass(stringArray, estateImpl, 79, 1, 2, 3, 80, 81);
        iS24CSVWriter.writeEstateGaesteWc(stringArray, estateImpl, 82);
        iS24CSVWriter.writeEstateHaustiere(stringArray, estateImpl, 70, 'J', 'N', 'V');
        String string2 = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "HEIZKOSTEN", estateImpl, 15, 2);
        String string3 = iS24CSVWriter.writeEstateValueAsYesNo("PREISE", "NEBENKOSTEN_INKL_HEIZKOSTEN", estateImpl);
        if (!StringUtils.isBlank((String)string2) && !StringUtils.isBlank((String)string3)) {
            stringArray[96] = string2;
            stringArray[97] = string3;
        }
        iS24CSVWriter.writeEstateHeizungsart(stringArray, estateImpl, 69, 1, 4, 5);
        iS24CSVWriter.writeEstateKeller(stringArray, estateImpl, 85);
        iS24CSVWriter.writeEstateRollstuhl(stringArray, estateImpl, 76);
        iS24CSVWriter.writeEstateSenioren(stringArray, estateImpl, 72);
        iS24CSVWriter.writeEstateStellplatz(stringArray, estateImpl, 74, '1', 'J', '3', '4', '2', '6', '7');
        iS24CSVWriter.writeEstateZustand(stringArray, estateImpl, 68, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
        if (stringArray[63] == null || stringArray[63].trim().length() == 0) {
            stringArray[63] = "0";
        }
        if (stringArray[65] == null || stringArray[65].trim().length() == 0) {
            stringArray[65] = "0";
        }
        if (stringArray[61] == null || stringArray[61].trim().length() == 0) {
            stringArray[61] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GESAMTFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[61] == null || stringArray[61].trim().length() == 0) {
            stringArray[61] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "NUTZFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[61] == null || stringArray[61].trim().length() == 0) {
            stringArray[61] = "0";
        }
        return stringArray;
    }
}

