/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.is24;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.csv.is24.IS24CSVReader;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchema;
import com.openindex.openestate.impl.csv.is24.IS24CSVWriter;

public class IS24CSVSchemaStellplatzMiete
extends IS24CSVSchema {
    public static final int TYPE_ID = 18;
    public static final int FIELD_ESTATE_SUBTYPE = 60;
    public static final int ESTATE_SUBTYPE_GARAGE = 129;
    public static final int ESTATE_SUBTYPE_TIEFGARAGE = 130;
    public static final int ESTATE_SUBTYPE_PARKHAUS = 131;
    public static final int ESTATE_SUBTYPE_CARPORT = 132;
    public static final int ESTATE_SUBTYPE_AUSSENSTELLPLATZ = 133;
    public static final int ESTATE_SUBTYPE_DUPLEX = 134;
    public static final int ESTATE_SUBTYPE_DEFAULT = 0;
    public static final int FIELD_ESTATE_LAENGE = 61;
    public static final int FIELD_ESTATE_BREITE = 62;
    public static final int FIELD_ESTATE_HOEHE = 63;
    public static final int FIELD_ESTATE_FLAECHE = 64;
    public static final int FIELD_ESTATE_VERFUEGBAR_AB = 65;
    public static final int FIELD_ESTATE_VERFUEGBAR_BIS = 66;
    public static final int FIELD_ESTATE_SANIERUNGSJAHR = 67;
    public static final int FIELD_ESTATE_BAUJAHR = 68;
    public static final int FIELD_ESTATE_ZUSTAND = 69;
    public static final int ESTATE_ZUSTAND_EMPTY = 0;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG = 1;
    public static final int ESTATE_ZUSTAND_NEUWERTIG = 2;
    public static final int ESTATE_ZUSTAND_VOLLSTAENDIG_RENOVIERT = 3;
    public static final int ESTATE_ZUSTAND_RENOVIERUNGSBEDARF = 4;
    public static final int ESTATE_ZUSTAND_MODERNISIERT = 5;
    public static final int ESTATE_ZUSTAND_NACH_VEREINBARUNG = 6;
    public static final int ESTATE_ZUSTAND_GEPFLEGT = 7;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG_NACH_SANIERUNG = 8;
    public static final int ESTATE_ZUSTAND_SANIERT = 9;
    @Deprecated
    public static final int ESTATE_ZUSTAND_UNRENOVIERT = 10;
    public static final int ESTATE_ZUSTAND_ABBRUCHREIF = 11;
    public static final int FIELD_ESTATE_MIETE = 90;

    @Override
    public int getIS24TypeId() {
        return 18;
    }

    @Override
    public void readEstate(IS24CSVReader iS24CSVReader, String[] stringArray, EstateImpl estateImpl) {
        Integer n = IS24CSVReader.getInt(60, stringArray, 0);
        if (n == null) {
            throw new NullPointerException("empty subtype!");
        }
        try {
            String string = null;
            switch (n) {
                case 133: {
                    string = "AUSSENSTELLPLATZ";
                    break;
                }
                case 132: {
                    string = "CARPORT";
                    break;
                }
                case 134: {
                    string = "DUPLEX";
                    break;
                }
                case 129: {
                    string = "GARAGE";
                    break;
                }
                case 131: {
                    string = "PARKHAUS";
                    break;
                }
                case 130: {
                    string = "TIEFGARAGE";
                    break;
                }
                default: {
                    string = "MAIN_STELLPLATZ";
                }
            }
            estateImpl.setType(string, "MIETE");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Objektart konnte nicht ermittelt werden: " + exception.getLocalizedMessage(), exception);
        }
        super.readEstate(iS24CSVReader, stringArray, estateImpl);
        iS24CSVReader.putEstateValue("ZUSTAND", "BAUJAHR", IS24CSVReader.getInt(68, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "BREITE", IS24CSVReader.getFloat(62, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "STELLPLATZFLAECHE", IS24CSVReader.getFloat(64, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "HOEHE", IS24CSVReader.getFloat(63, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "LAENGE", IS24CSVReader.getFloat(61, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "KALTMIETE", IS24CSVReader.getFloat(90, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("ZUSTAND", "SANIERUNG", IS24CSVReader.getInt(67, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", iS24CSVReader.parseDate(65, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "VERFUEGBAR_BISDATE", iS24CSVReader.parseDate(66, stringArray), estateImpl);
        iS24CSVReader.readEstateZustand(stringArray, estateImpl, 69, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
    }

    @Override
    protected boolean supportsEstateAction(String string) {
        return "MIETE".equalsIgnoreCase(string) || "PACHT".equalsIgnoreCase(string);
    }

    @Override
    protected boolean supportsEstateType(String string) {
        return "MAIN_STELLPLATZ".equalsIgnoreCase(string);
    }

    @Override
    protected String[] writeValues(IS24CSVWriter iS24CSVWriter, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl) {
        String[] stringArray = super.writeValues(iS24CSVWriter, estateImpl, agentImpl, agentContactImpl);
        int n = -1;
        String string = estateImpl.getType().getName();
        n = "AUSSENSTELLPLATZ".equalsIgnoreCase(string) ? 133 : ("CARPORT".equalsIgnoreCase(string) ? 132 : ("DUPLEX".equalsIgnoreCase(string) ? 134 : ("GARAGE".equalsIgnoreCase(string) ? 129 : ("PARKHAUS".equalsIgnoreCase(string) ? 131 : ("TIEFGARAGE".equalsIgnoreCase(string) ? 130 : 0)))));
        stringArray[60] = String.valueOf(n);
        stringArray[68] = iS24CSVWriter.writeEstateValueAsYear("ZUSTAND", "BAUJAHR", estateImpl);
        stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "BREITE", estateImpl, 5, 2);
        stringArray[64] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "STELLPLATZFLAECHE", estateImpl, 10, 2);
        stringArray[63] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "HOEHE", estateImpl, 4, 2);
        stringArray[61] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "LAENGE", estateImpl, 5, 2);
        if ("MIETE".equals(estateImpl.getAction())) {
            stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KALTMIETE", estateImpl, 6, 2);
        } else if ("PACHT".equals(estateImpl.getAction())) {
            stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "PACHT", estateImpl, 6, 2);
        }
        stringArray[67] = iS24CSVWriter.writeEstateValueAsYear("ZUSTAND", "SANIERUNG", estateImpl);
        stringArray[65] = iS24CSVWriter.writeEstateValueAsDate("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl);
        stringArray[66] = iS24CSVWriter.writeEstateValueAsDate("VERWALTUNG", "VERFUEGBAR_BISDATE", estateImpl);
        iS24CSVWriter.writeEstateZustand(stringArray, estateImpl, 69, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
        return stringArray;
    }
}

