/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.is24;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.csv.is24.IS24CSVReader;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchema;
import com.openindex.openestate.impl.csv.is24.IS24CSVWriter;

public class IS24CSVSchemaWohnenAufZeit
extends IS24CSVSchema {
    public static final int TYPE_ID = 4;
    public static final int FIELD_ESTATE_SUBTYPE = 60;
    public static final int ESTATE_SUBTYPE_ZIMMER = 0;
    public static final int ESTATE_SUBTYPE_APPARTMENT = 1;
    public static final int ESTATE_SUBTYPE_WOHNUNG = 2;
    public static final int ESTATE_SUBTYPE_HAUS = 3;
    public static final int ESTATE_SUBTYPE_DEFAULT = 2;
    public static final int FIELD_ESTATE_WOHNFLAECHE = 61;
    public static final int FIELD_ESTATE_ANZAHL_ZIMMER = 62;
    public static final int FIELD_ESTATE_FREI_BIS = 63;
    public static final int FIELD_ESTATE_MIETDAUER_MINIMUM = 64;
    public static final int FIELD_ESTATE_MIETDAUER_MAXIMUM = 65;
    public static final int FIELD_ESTATE_ETAGE = 66;
    public static final int FIELD_ESTATE_ETAGENZAHL = 67;
    public static final int FIELD_ESTATE_ZUSTAND = 68;
    public static final int ESTATE_ZUSTAND_EMPTY = 0;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG = 1;
    public static final int ESTATE_ZUSTAND_NEUWERTIG = 2;
    public static final int ESTATE_ZUSTAND_VOLLSTAENDIG_RENOVIERT = 3;
    public static final int ESTATE_ZUSTAND_RENOVIERUNGSBEDARF = 4;
    public static final int ESTATE_ZUSTAND_MODERNISIERT = 5;
    public static final int ESTATE_ZUSTAND_NACH_VEREINBARUNG = 6;
    public static final int ESTATE_ZUSTAND_GEPFLEGT = 7;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG_NACH_SANIERUNG = 8;
    public static final int ESTATE_ZUSTAND_SANIERT = 9;
    @Deprecated
    public static final int ESTATE_ZUSTAND_UNRENOVIERT = 10;
    public static final int ESTATE_ZUSTAND_ABBRUCHREIF = 11;
    public static final int FIELD_ESTATE_HEIZUNGSART = 69;
    public static final int ESTATE_HEIZUNGSART_ETAGE = 0;
    public static final int ESTATE_HEIZUNGSART_OFEN = 1;
    public static final int ESTATE_HEIZUNGSART_ZENTRAL = 2;
    public static final int FIELD_ESTATE_AUFZUG = 70;
    public static final char ESTATE_AUFZUG_YES = 'J';
    public static final char ESTATE_AUFZUG_NO = 'N';
    public static final int FIELD_ESTATE_HAUSTIERE = 71;
    public static final char ESTATE_HAUSTIERE_YES = 'J';
    public static final char ESTATE_HAUSTIERE_NO = 'N';
    public static final char ESTATE_HAUSTIERE_VEREINBARUNG = 'V';
    public static final int FIELD_ESTATE_BALKON = 72;
    public static final char ESTATE_BALKON_YES = 'J';
    public static final char ESTATE_BALKON_NO = 'N';
    public static final int FIELD_ESTATE_GARTENNUTZUNG = 73;
    public static final char ESTATE_GARTENNUTZUNG_YES = 'J';
    public static final char ESTATE_GARTENNUTZUNG_NO = 'N';
    public static final int FIELD_ESTATE_MOEBLIERT = 74;
    public static final char ESTATE_MOEBLIERT_YES = 'J';
    public static final char ESTATE_MOEBLIERT_NO = 'N';
    public static final int FIELD_ESTATE_RAUCHER = 75;
    public static final int ESTATE_RAUCHER_NICHTRAUCHER = 0;
    public static final int ESTATE_RAUCHER_EGAL = 1;
    public static final int FIELD_ESTATE_GESCHLECHT = 76;
    public static final int ESTATE_GESCHLECHT_NUR_MANN = 0;
    public static final int ESTATE_GESCHLECHT_NUR_FRAU = 1;
    public static final int FIELD_ESTATE_ANZAHL_PERSONEN = 77;
    public static final int FIELD_ESTATE_VERFUEGBAR_AB = 78;
    public static final int FIELD_ESTATE_STELLPLATZ = 79;
    public static final char ESTATE_STELLPLATZ_EMPTY = '1';
    public static final char ESTATE_STELLPLATZ_GARAGE = '2';
    public static final char ESTATE_STELLPLATZ_AUSSEN = '3';
    public static final char ESTATE_STELLPLATZ_CARPORT = '4';
    public static final char ESTATE_STELLPLATZ_DUPLEX = '5';
    public static final char ESTATE_STELLPLATZ_PARKHAUS = '6';
    public static final char ESTATE_STELLPLATZ_TIEFGARAGE = '7';
    public static final char ESTATE_STELLPLATZ_YES = 'J';
    public static final char ESTATE_STELLPLATZ_NO = 'N';
    @Deprecated
    public static final int FIELD_ESTATE_ROLLSTUHLGERECHT = 80;
    @Deprecated
    public static final char ESTATE_ROLLSTUHLGERECHT_YES = 'J';
    @Deprecated
    public static final char ESTATE_ROLLSTUHLGERECHT_NO = 'N';
    public static final int FIELD_ESTATE_ANZAHL_STELLPLAETZE = 81;
    public static final int FIELD_ESTATE_BARRIEREFREI = 82;
    public static final char ESTATE_BARRIEREFREI_YES = 'J';
    public static final char ESTATE_BARRIEREFREI_NO = 'N';
    public static final int FIELD_ESTATE_BEFEUERUNG = 83;
    public static final int ESTATE_BEFEUERUNG_EMPTY = 1;
    public static final int ESTATE_BEFEUERUNG_ERDWAERME = 2;
    public static final int ESTATE_BEFEUERUNG_SOLAR = 3;
    public static final int ESTATE_BEFEUERUNG_PELLET = 4;
    public static final int ESTATE_BEFEUERUNG_GAS = 5;
    public static final int ESTATE_BEFEUERUNG_OEL = 6;
    public static final int ESTATE_BEFEUERUNG_FERNWAERME = 7;
    public static final int ESTATE_BEFEUERUNG_STROM = 8;
    public static final int ESTATE_BEFEUERUNG_KOHLE = 9;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_TYP = 84;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_EMPTY = 1;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_BEDARF = 2;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_VERBRAUCH = 3;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_WERT = 85;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER = 86;
    public static final char ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER_YES = 'J';
    public static final char ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER_NO = 'N';
    public static final int FIELD_ESTATE_GAESTE_WC = 87;
    public static final char ESTATE_GAESTE_WC_YES = 'J';
    public static final char ESTATE_GAESTE_WC_NO = 'N';
    public static final int FIELD_ESTATE_KELLER = 89;
    public static final char ESTATE_KELLER_YES = 'J';
    public static final char ESTATE_KELLER_NO = 'N';
    public static final int FIELD_ESTATE_PAUSCHALMIETE = 90;
    public static final int FIELD_ESTATE_PAUSCHALMIETE_PRO = 91;
    public static final char ESTATE_PAUSCHALMIETE_PRO_TAG = 'T';
    public static final char ESTATE_PAUSCHALMIETE_PRO_WOCHE = 'W';
    public static final char ESTATE_PAUSCHALMIETE_PRO_MONAT = 'M';
    public static final int FIELD_ESTATE_KALTMIETE = 92;
    public static final int FIELD_ESTATE_NEBENKOSTEN = 93;
    public static final int FIELD_ESTATE_KAUTION = 94;
    public static final int FIELD_ESTATE_STELLPLATZMIETE = 95;

    @Override
    public int getIS24TypeId() {
        return 4;
    }

    @Override
    public void readEstate(IS24CSVReader iS24CSVReader, String[] stringArray, EstateImpl estateImpl) {
        Integer n = IS24CSVReader.getInt(60, stringArray, 2);
        if (n == null) {
            throw new NullPointerException("empty subtype!");
        }
        try {
            String string = null;
            switch (n) {
                case 1: {
                    string = "APPARTMENTWOHNUNG";
                    break;
                }
                case 3: {
                    string = "HAUS";
                    break;
                }
                case 2: {
                    string = "WOHNUNG";
                    break;
                }
                case 0: {
                    string = "ZIMMER";
                    break;
                }
                default: {
                    string = "MAIN_WOHNEN";
                }
            }
            estateImpl.setType(string, "WAZ");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Objektart konnte nicht ermittelt werden: " + exception.getLocalizedMessage(), exception);
        }
        super.readEstate(iS24CSVReader, stringArray, estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "MAX_PERSONEN", IS24CSVReader.getInt(77, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", IS24CSVReader.getInt(81, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_ZIMMER", IS24CSVReader.getFloat(62, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "PERS_LIFT", iS24CSVReader.parseYerOrNo(70, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "BALKON_TERRASSE", iS24CSVReader.parseYerOrNo(72, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "BARRIEREFREI", iS24CSVReader.parseYerOrNo(82, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "ETAGE", IS24CSVReader.getInt(66, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", IS24CSVReader.getInt(67, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "VERFUEGBAR_BISDATE", iS24CSVReader.parseDate(63, stringArray), estateImpl);
        if (Boolean.TRUE.equals(iS24CSVReader.parseYerOrNo(87, stringArray))) {
            iS24CSVReader.putEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl);
        }
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "GARTENNUTZUNG", iS24CSVReader.parseYerOrNo(73, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "KALTMIETE", IS24CSVReader.getFloat(92, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "KAUTION", IS24CSVReader.getString(94, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "MAX_MIETDAUER", IS24CSVReader.getString(65, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "MIN_MIETDAUER", IS24CSVReader.getString(64, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "NEBENKOSTEN", IS24CSVReader.getFloat(93, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "PAUSCHALMIETE", IS24CSVReader.getFloat(90, stringArray), estateImpl);
        if (Boolean.TRUE.equals(iS24CSVReader.parseYerOrNo(80, stringArray))) {
            iS24CSVReader.putEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl);
        }
        iS24CSVReader.putEstateValue("PREISE", "STELLPLATZ_MIETE", IS24CSVReader.getFloat(95, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", iS24CSVReader.parseDate(78, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "WOHNFLAECHE", IS24CSVReader.getFloat(61, stringArray), estateImpl);
        iS24CSVReader.readEstateBefeuerung(stringArray, estateImpl, 83, 2, 7, 5, 9, 6, 4, 3, 8);
        iS24CSVReader.readEstateEnergiepass(stringArray, estateImpl, 84, 1, 2, 3, 85, 86);
        iS24CSVReader.readEstateGeschlecht(stringArray, estateImpl, 76, -1, 1, 0);
        iS24CSVReader.readEstateHaustiere(stringArray, estateImpl, 71, 'J', 'N', 'V');
        iS24CSVReader.readEstateHeizungsart(stringArray, estateImpl, 69, -1, 0, 1, 2);
        iS24CSVReader.readEstateKeller(stringArray, estateImpl, 89);
        iS24CSVReader.readEstateMietePro(stringArray, estateImpl, 91, 'T', 'W', 'M');
        iS24CSVReader.readEstateMoebliert(stringArray, estateImpl, 74);
        iS24CSVReader.readEstateRaucher(stringArray, estateImpl, 75, -1, 1, 0);
        iS24CSVReader.readEstateStellplatz(stringArray, estateImpl, 79, '1', 'J', '3', '4', '2', '6', '7');
        iS24CSVReader.readEstateZustand(stringArray, estateImpl, 68, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
    }

    @Override
    protected boolean supportsEstateAction(String string) {
        return "WAZ".equalsIgnoreCase(string);
    }

    @Override
    protected boolean supportsEstateType(String string) {
        return "MAIN_WOHNEN".equalsIgnoreCase(string);
    }

    @Override
    protected String[] writeValues(IS24CSVWriter iS24CSVWriter, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl) {
        String[] stringArray = super.writeValues(iS24CSVWriter, estateImpl, agentImpl, agentContactImpl);
        int n = -1;
        String string = estateImpl.getType().getName();
        n = "APPARTMENTWOHNUNG".equalsIgnoreCase(string) ? 1 : ("HAUS".equalsIgnoreCase(string) ? 3 : ("WOHNUNG".equalsIgnoreCase(string) ? 2 : ("ZIMMER".equalsIgnoreCase(string) ? 0 : 2)));
        stringArray[60] = String.valueOf(n);
        stringArray[77] = iS24CSVWriter.writeEstateValueAsNumber("VERWALTUNG", "MAX_PERSONEN", estateImpl, 2, 0);
        stringArray[81] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl, 2, 0);
        stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_ZIMMER", estateImpl, 2, 1);
        stringArray[70] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "PERS_LIFT", estateImpl);
        stringArray[72] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "BALKON_TERRASSE", estateImpl);
        stringArray[82] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "BARRIEREFREI", estateImpl);
        stringArray[66] = iS24CSVWriter.writeEstateValueAsNumber("AUSSTATTUNG", "ETAGE", estateImpl, 3, 0);
        stringArray[67] = iS24CSVWriter.writeEstateValueAsNumber("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl, 3, 0);
        stringArray[63] = iS24CSVWriter.writeEstateValueAsDate("VERWALTUNG", "VERFUEGBAR_BISDATE", estateImpl);
        stringArray[73] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "GARTENNUTZUNG", estateImpl);
        stringArray[92] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KALTMIETE", estateImpl, 15, 2);
        stringArray[94] = iS24CSVWriter.writeEstateValue("PREISE", "KAUTION", estateImpl);
        stringArray[65] = iS24CSVWriter.writeEstateValueAsNumber("VERWALTUNG", "MAX_MIETDAUER", estateImpl, 5, 2);
        stringArray[64] = iS24CSVWriter.writeEstateValueAsNumber("VERWALTUNG", "MIN_MIETDAUER", estateImpl, 5, 2);
        stringArray[93] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "NEBENKOSTEN", estateImpl, 15, 2);
        stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "PAUSCHALMIETE", estateImpl, 15, 2);
        stringArray[95] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "STELLPLATZ_MIETE", estateImpl, 15, 2);
        stringArray[78] = iS24CSVWriter.writeEstateValueAsDate("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl);
        stringArray[61] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "WOHNFLAECHE", estateImpl, 7, 2);
        iS24CSVWriter.writeEstateBefeuerung(stringArray, estateImpl, 83, 2, 7, 5, 9, 6, 4, 3, 8);
        iS24CSVWriter.writeEstateEnergiepass(stringArray, estateImpl, 84, 1, 2, 3, 85, 86);
        iS24CSVWriter.writeEstateGaesteWc(stringArray, estateImpl, 87);
        iS24CSVWriter.writeEstateGeschlecht(stringArray, estateImpl, 76, 1, 0);
        iS24CSVWriter.writeEstateHaustiere(stringArray, estateImpl, 71, 'J', 'N', 'V');
        iS24CSVWriter.writeEstateHeizungsart(stringArray, estateImpl, 69, 0, 1, 2);
        iS24CSVWriter.writeEstateKeller(stringArray, estateImpl, 89);
        iS24CSVWriter.writeEstateMietePro(stringArray, estateImpl, 91, 'T', 'W', 'M');
        iS24CSVWriter.writeEstateMoebliert(stringArray, estateImpl, 74);
        iS24CSVWriter.writeEstateRaucher(stringArray, estateImpl, 75, 1, 0);
        iS24CSVWriter.writeEstateRollstuhl(stringArray, estateImpl, 80);
        iS24CSVWriter.writeEstateStellplatz(stringArray, estateImpl, 79, '1', 'J', '3', '4', '2', '6', '7');
        iS24CSVWriter.writeEstateZustand(stringArray, estateImpl, 68, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
        if (stringArray[62] == null || stringArray[62].trim().length() == 0) {
            stringArray[62] = "0";
        }
        if (stringArray[61] == null || stringArray[61].trim().length() == 0) {
            stringArray[61] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GESAMTFLAECHE", estateImpl, 7, 2);
        }
        if (stringArray[61] == null || stringArray[61].trim().length() == 0) {
            stringArray[61] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "NUTZFLAECHE", estateImpl, 7, 2);
        }
        if (stringArray[61] == null || stringArray[61].trim().length() == 0) {
            stringArray[61] = "0";
        }
        return stringArray;
    }
}

