/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.is24;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.csv.is24.IS24CSVReader;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchema;
import com.openindex.openestate.impl.csv.is24.IS24CSVWriter;
import org.apache.commons.lang.StringUtils;

public class IS24CSVSchemaWohnungMiete
extends IS24CSVSchema {
    public static final int TYPE_ID = 0;
    public static final int FIELD_ESTATE_SUBTYPE = 60;
    public static final int ESTATE_SUBTYPE_DACHGESCHOSS = 3;
    public static final int ESTATE_SUBTYPE_LOFT = 6;
    public static final int ESTATE_SUBTYPE_MAISONETTE = 7;
    public static final int ESTATE_SUBTYPE_PENTHOUSE = 8;
    public static final int ESTATE_SUBTYPE_TERRASSE = 40;
    public static final int ESTATE_SUBTYPE_SONSTIGE = 113;
    public static final int ESTATE_SUBTYPE_ERDGESCHOSS = 117;
    public static final int ESTATE_SUBTYPE_ETAGE = 118;
    public static final int ESTATE_SUBTYPE_HOCHPARTERRE = 127;
    public static final int ESTATE_SUBTYPE_SOUTERRAIN = 128;
    public static final int ESTATE_SUBTYPE_DEFAULT = 0;
    public static final int FIELD_ESTATE_WOHNFLAECHE = 61;
    public static final int FIELD_ESTATE_NUTZFLAECHE = 62;
    public static final int FIELD_ESTATE_ANZAHL_ZIMMER = 63;
    public static final int FIELD_ESTATE_ANZAHL_BADEZIMMER = 64;
    public static final int FIELD_ESTATE_ETAGE = 65;
    public static final int FIELD_ESTATE_ETAGENZAHL = 66;
    public static final int FIELD_ESTATE_BAUJAHR = 67;
    public static final int FIELD_ESTATE_ZUSTAND = 68;
    public static final int ESTATE_ZUSTAND_EMPTY = 0;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG = 1;
    public static final int ESTATE_ZUSTAND_NEUWERTIG = 2;
    public static final int ESTATE_ZUSTAND_VOLLSTAENDIG_RENOVIERT = 3;
    public static final int ESTATE_ZUSTAND_RENOVIERUNGSBEDARF = 4;
    public static final int ESTATE_ZUSTAND_MODERNISIERT = 5;
    public static final int ESTATE_ZUSTAND_NACH_VEREINBARUNG = 6;
    public static final int ESTATE_ZUSTAND_GEPFLEGT = 7;
    public static final int ESTATE_ZUSTAND_ERSTBEZUG_NACH_SANIERUNG = 8;
    public static final int ESTATE_ZUSTAND_SANIERT = 9;
    @Deprecated
    public static final int ESTATE_ZUSTAND_UNRENOVIERT = 10;
    public static final int ESTATE_ZUSTAND_ABBRUCHREIF = 11;
    public static final int FIELD_ESTATE_HEIZUNGSART = 69;
    public static final int ESTATE_HEIZUNGSART_EMPTY = 0;
    public static final int ESTATE_HEIZUNGSART_ETAGE = 1;
    public static final int ESTATE_HEIZUNGSART_OFEN = 4;
    public static final int ESTATE_HEIZUNGSART_ZENTRAL = 5;
    public static final int FIELD_ESTATE_AUFZUG = 70;
    public static final char ESTATE_AUFZUG_YES = 'J';
    public static final char ESTATE_AUFZUG_NO = 'N';
    public static final char ESTATE_AUFZUG_VEREINBARUNG = 'V';
    public static final int FIELD_ESTATE_HAUSTIERE = 71;
    public static final char ESTATE_HAUSTIERE_YES = 'J';
    public static final char ESTATE_HAUSTIERE_NO = 'N';
    public static final char ESTATE_HAUSTIERE_VEREINBARUNG = 'V';
    public static final int FIELD_ESTATE_BALKON = 72;
    public static final char ESTATE_BALKON_YES = 'J';
    public static final char ESTATE_BALKON_NO = 'N';
    public static final int FIELD_ESTATE_GARTENNUTZUNG = 73;
    public static final char ESTATE_GARTENNUTZUNG_YES = 'J';
    public static final char ESTATE_GARTENNUTZUNG_NO = 'N';
    public static final int FIELD_ESTATE_EBK = 74;
    public static final char ESTATE_EBK_YES = 'J';
    public static final char ESTATE_EBK_NO = 'N';
    public static final int FIELD_ESTATE_SENIORENGERECHT = 75;
    public static final char ESTATE_SENIORENGERECHT_YES = 'J';
    public static final char ESTATE_SENIORENGERECHT_NO = 'N';
    public static final int FIELD_ESTATE_FOERDERUNG = 76;
    public static final char ESTATE_FOERDERUNG_YES = 'J';
    public static final char ESTATE_FOERDERUNG_NO = 'N';
    public static final int FIELD_ESTATE_ANZAHL_STELLPLAETZE = 77;
    public static final int FIELD_ESTATE_STELLPLATZ = 78;
    public static final char ESTATE_STELLPLATZ_EMPTY = '1';
    public static final char ESTATE_STELLPLATZ_GARAGE = '2';
    public static final char ESTATE_STELLPLATZ_AUSSEN = '3';
    public static final char ESTATE_STELLPLATZ_CARPORT = '4';
    public static final char ESTATE_STELLPLATZ_DUPLEX = '5';
    public static final char ESTATE_STELLPLATZ_PARKHAUS = '6';
    public static final char ESTATE_STELLPLATZ_TIEFGARAGE = '7';
    public static final char ESTATE_STELLPLATZ_YES = 'J';
    public static final char ESTATE_STELLPLATZ_NO = 'N';
    public static final int FIELD_ESTATE_VERFUEGBAR_AB = 79;
    @Deprecated
    public static final int FIELD_ESTATE_ROLLSTUHLGERECHT = 80;
    @Deprecated
    public static final char ESTATE_ROLLSTUHLGERECHT_YES = 'J';
    @Deprecated
    public static final char ESTATE_ROLLSTUHLGERECHT_NO = 'N';
    public static final int FIELD_ESTATE_ANZAHL_SCHLAFZIMMER = 81;
    public static final int FIELD_ESTATE_BARRIEREFREI = 82;
    public static final char ESTATE_BARRIEREFREI_YES = 'J';
    public static final char ESTATE_BARRIEREFREI_NO = 'N';
    public static final int FIELD_ESTATE_BEFEUERUNG = 83;
    public static final int ESTATE_BEFEUERUNG_EMPTY = 1;
    public static final int ESTATE_BEFEUERUNG_ERDWAERME = 2;
    public static final int ESTATE_BEFEUERUNG_SOLAR = 3;
    public static final int ESTATE_BEFEUERUNG_PELLET = 4;
    public static final int ESTATE_BEFEUERUNG_GAS = 5;
    public static final int ESTATE_BEFEUERUNG_OEL = 6;
    public static final int ESTATE_BEFEUERUNG_FERNWAERME = 7;
    public static final int ESTATE_BEFEUERUNG_STROM = 8;
    public static final int ESTATE_BEFEUERUNG_KOHLE = 9;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_TYP = 84;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_EMPTY = 1;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_BEDARF = 2;
    public static final int ESTATE_ENERGIEAUSWEIS_TYP_VERBRAUCH = 3;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_WERT = 85;
    public static final int FIELD_ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER = 86;
    public static final char ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER_YES = 'J';
    public static final char ESTATE_ENERGIEAUSWEIS_INKL_WARMWASSER_NO = 'N';
    public static final int FIELD_ESTATE_GAESTE_WC = 87;
    public static final char ESTATE_GAESTE_WC_YES = 'J';
    public static final char ESTATE_GAESTE_WC_NO = 'N';
    public static final int FIELD_ESTATE_SANIERUNGSJAHR = 88;
    public static final int FIELD_ESTATE_KELLER = 89;
    public static final char ESTATE_KELLER_YES = 'J';
    public static final char ESTATE_KELLER_NO = 'N';
    public static final int FIELD_ESTATE_KALTMIETE = 90;
    public static final int FIELD_ESTATE_NEBENKOSTEN = 91;
    public static final int FIELD_ESTATE_WARMMIETE = 92;
    public static final int FIELD_ESTATE_STELLPLATZMIETE = 93;
    public static final int FIELD_ESTATE_KAUTION = 94;
    public static final int FIELD_ESTATE_HEIZKOSTEN = 96;
    public static final int FIELD_ESTATE_NEBENKOSTEN_INKL_HEIZKOSTEN = 97;
    public static final char ESTATE_NEBENKOSTEN_INKL_HEIZKOSTEN_YES = 'J';
    public static final char ESTATE_NEBENKOSTEN_INKL_HEIZKOSTEN_NO = 'N';
    public static final int FIELD_ESTATE_AUSSTATTUNG = 98;
    public static final int ESTATE_AUSSTATTUNG_EMPTY = 1;
    public static final int ESTATE_AUSSTATTUNG_LUXUS = 2;
    public static final int ESTATE_AUSSTATTUNG_GEHOBEN = 3;
    public static final int ESTATE_AUSSTATTUNG_NORMAL = 4;
    public static final int ESTATE_AUSSTATTUNG_EINFACH = 5;

    @Override
    public int getIS24TypeId() {
        return 0;
    }

    @Override
    public void readEstate(IS24CSVReader iS24CSVReader, String[] stringArray, EstateImpl estateImpl) {
        Integer n = IS24CSVReader.getInt(60, stringArray, 0);
        if (n == null) {
            throw new NullPointerException("empty subtype!");
        }
        try {
            String string = null;
            switch (n) {
                case 3: {
                    string = "DACHWOHNUNG";
                    break;
                }
                case 117: {
                    string = "ERDGESCHOSSWOHNUNG";
                    break;
                }
                case 118: {
                    string = "ETAGENWOHNUNG";
                    break;
                }
                case 127: {
                    string = "HOCHPARTERRE";
                    break;
                }
                case 6: {
                    string = "LOFTWOHNUNG";
                    break;
                }
                case 7: {
                    string = "MAISONETTWOHNUNG";
                    break;
                }
                case 8: {
                    string = "PENTHOUSEWOHNUNG";
                    break;
                }
                case 113: {
                    string = "WOHNUNG";
                    break;
                }
                case 128: {
                    string = "SOUTERRAINWOHNUNG";
                    break;
                }
                case 40: {
                    string = "TERRASSENWOHNUNG";
                    break;
                }
                default: {
                    string = "WOHNUNG";
                }
            }
            estateImpl.setType(string, "MIETE");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Objektart konnte nicht ermittelt werden: " + exception.getLocalizedMessage(), exception);
        }
        super.readEstate(iS24CSVReader, stringArray, estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_BADEZIMMER", IS24CSVReader.getInt(64, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_SCHLAFZIMMER", IS24CSVReader.getInt(81, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", IS24CSVReader.getInt(77, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "ANZ_ZIMMER", IS24CSVReader.getFloat(63, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "PERS_LIFT", iS24CSVReader.parseYerOrNo(70, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "BALKON_TERRASSE", iS24CSVReader.parseYerOrNo(72, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "BARRIEREFREI", iS24CSVReader.parseYerOrNo(82, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("ZUSTAND", "BAUJAHR", IS24CSVReader.getInt(67, stringArray), estateImpl);
        if (Boolean.TRUE.equals(iS24CSVReader.parseYerOrNo(74, stringArray))) {
            iS24CSVReader.putEstateValue("AUSSTATTUNG", "KUECHE", "EINBAUKUECHE", estateImpl);
        }
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "ETAGE", IS24CSVReader.getInt(65, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", IS24CSVReader.getInt(66, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "WBS_SOZIALWOHNUNG", iS24CSVReader.parseYerOrNo(76, stringArray), estateImpl);
        if (Boolean.TRUE.equals(iS24CSVReader.parseYerOrNo(87, stringArray))) {
            iS24CSVReader.putEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl);
        }
        iS24CSVReader.putEstateValue("AUSSTATTUNG", "GARTENNUTZUNG", iS24CSVReader.parseYerOrNo(73, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "HEIZKOSTEN", IS24CSVReader.getFloat(96, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("ZUSTAND", "SANIERUNG", IS24CSVReader.getInt(88, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "KALTMIETE", IS24CSVReader.getFloat(90, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "KAUTION", IS24CSVReader.getString(94, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "NEBENKOSTEN", IS24CSVReader.getFloat(91, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "NEBENKOSTEN_INKL_HEIZKOSTEN", iS24CSVReader.parseYerOrNo(97, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "NUTZFLAECHE", IS24CSVReader.getFloat(62, stringArray), estateImpl);
        if (Boolean.TRUE.equals(iS24CSVReader.parseYerOrNo(80, stringArray))) {
            iS24CSVReader.putEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl);
        }
        if (Boolean.TRUE.equals(iS24CSVReader.parseYerOrNo(75, stringArray))) {
            iS24CSVReader.putEstateValue("AUSSTATTUNG", "EIGNUNG", "SENIOREN", estateImpl);
        }
        iS24CSVReader.putEstateValue("PREISE", "STELLPLATZ_MIETE", IS24CSVReader.getFloat(93, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", IS24CSVReader.getString(79, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("PREISE", "WARMMIETE", IS24CSVReader.getFloat(92, stringArray), estateImpl);
        iS24CSVReader.putEstateValue("FLAECHEN", "WOHNFLAECHE", IS24CSVReader.getFloat(61, stringArray), estateImpl);
        iS24CSVReader.readEstateAusstattung(stringArray, estateImpl, 98, 1, 5, 3, 2, 4);
        iS24CSVReader.readEstateBefeuerung(stringArray, estateImpl, 83, 2, 7, 5, 9, 6, 4, 3, 8);
        iS24CSVReader.readEstateEnergiepass(stringArray, estateImpl, 84, 1, 2, 3, 85, 86);
        iS24CSVReader.readEstateHaustiere(stringArray, estateImpl, 71, 'J', 'N', 'V');
        iS24CSVReader.readEstateHeizungsart(stringArray, estateImpl, 69, 0, 1, 4, 5);
        iS24CSVReader.readEstateKeller(stringArray, estateImpl, 89);
        iS24CSVReader.readEstateStellplatz(stringArray, estateImpl, 78, '1', 'J', '3', '4', '2', '6', '7');
        iS24CSVReader.readEstateZustand(stringArray, estateImpl, 68, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
    }

    @Override
    protected boolean supportsEstateAction(String string) {
        return "MIETE".equalsIgnoreCase(string) || "PACHT".equalsIgnoreCase(string);
    }

    @Override
    protected boolean supportsEstateType(String string) {
        return "WOHNUNG".equalsIgnoreCase(string);
    }

    @Override
    protected String[] writeValues(IS24CSVWriter iS24CSVWriter, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl) {
        String[] stringArray = super.writeValues(iS24CSVWriter, estateImpl, agentImpl, agentContactImpl);
        int n = -1;
        String string = estateImpl.getType().getName();
        n = "DACHWOHNUNG".equalsIgnoreCase(string) ? 3 : ("ERDGESCHOSSWOHNUNG".equalsIgnoreCase(string) ? 117 : ("ETAGENWOHNUNG".equalsIgnoreCase(string) ? 118 : ("HOCHPARTERRE".equalsIgnoreCase(string) ? 127 : ("LOFTWOHNUNG".equalsIgnoreCase(string) ? 6 : ("MAISONETTWOHNUNG".equalsIgnoreCase(string) ? 7 : ("PENTHOUSEWOHNUNG".equalsIgnoreCase(string) ? 8 : ("SOUTERRAINWOHNUNG".equalsIgnoreCase(string) ? 128 : ("TERRASSENWOHNUNG".equalsIgnoreCase(string) ? 40 : 0))))))));
        stringArray[60] = String.valueOf(n);
        stringArray[64] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_BADEZIMMER", estateImpl, 2, 0);
        stringArray[81] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_SCHLAFZIMMER", estateImpl, 2, 0);
        stringArray[77] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl, 2, 0);
        stringArray[63] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "ANZ_ZIMMER", estateImpl, 6, 2);
        stringArray[70] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "PERS_LIFT", estateImpl);
        stringArray[72] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "BALKON_TERRASSE", estateImpl);
        stringArray[82] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "BARRIEREFREI", estateImpl);
        stringArray[67] = iS24CSVWriter.writeEstateValueAsYear("ZUSTAND", "BAUJAHR", estateImpl);
        stringArray[65] = iS24CSVWriter.writeEstateValueAsNumber("AUSSTATTUNG", "ETAGE", estateImpl, 3, 0);
        stringArray[66] = iS24CSVWriter.writeEstateValueAsNumber("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl, 3, 0);
        stringArray[76] = iS24CSVWriter.writeEstateValueAsYesNo("VERWALTUNG", "WBS_SOZIALWOHNUNG", estateImpl);
        stringArray[73] = iS24CSVWriter.writeEstateValueAsYesNo("AUSSTATTUNG", "GARTENNUTZUNG", estateImpl);
        if ("MIETE".equals(estateImpl.getAction())) {
            stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "KALTMIETE", estateImpl, 15, 2);
        } else if ("PACHT".equals(estateImpl.getAction())) {
            stringArray[90] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "PACHT", estateImpl, 15, 2);
        }
        stringArray[94] = iS24CSVWriter.writeEstateValue("PREISE", "KAUTION", estateImpl);
        stringArray[91] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "NEBENKOSTEN", estateImpl, 15, 2);
        stringArray[62] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "NUTZFLAECHE", estateImpl, 10, 2);
        stringArray[88] = iS24CSVWriter.writeEstateValueAsYear("ZUSTAND", "SANIERUNG", estateImpl);
        stringArray[93] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "STELLPLATZ_MIETE", estateImpl, 15, 2);
        stringArray[79] = iS24CSVWriter.writeEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl);
        stringArray[92] = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "WARMMIETE", estateImpl, 15, 2);
        stringArray[61] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "WOHNFLAECHE", estateImpl, 10, 2);
        iS24CSVWriter.writeEstateAusstattung(stringArray, estateImpl, 98, 1, 5, 3, 2, 4);
        iS24CSVWriter.writeEstateBefeuerung(stringArray, estateImpl, 83, 2, 7, 5, 9, 6, 4, 3, 8);
        iS24CSVWriter.writeEstateEbk(stringArray, estateImpl, 74);
        iS24CSVWriter.writeEstateEnergiepass(stringArray, estateImpl, 84, 1, 2, 3, 85, 86);
        iS24CSVWriter.writeEstateGaesteWc(stringArray, estateImpl, 87);
        iS24CSVWriter.writeEstateHaustiere(stringArray, estateImpl, 71, 'J', 'N', 'V');
        String string2 = iS24CSVWriter.writeEstateValueAsNumber("PREISE", "HEIZKOSTEN", estateImpl, 15, 2);
        String string3 = iS24CSVWriter.writeEstateValueAsYesNo("PREISE", "NEBENKOSTEN_INKL_HEIZKOSTEN", estateImpl);
        if (!StringUtils.isBlank((String)string2) && !StringUtils.isBlank((String)string3)) {
            stringArray[96] = string2;
            stringArray[97] = string3;
        }
        iS24CSVWriter.writeEstateHeizungsart(stringArray, estateImpl, 69, 1, 4, 5);
        iS24CSVWriter.writeEstateKeller(stringArray, estateImpl, 89);
        iS24CSVWriter.writeEstateRollstuhl(stringArray, estateImpl, 80);
        iS24CSVWriter.writeEstateSenioren(stringArray, estateImpl, 75);
        iS24CSVWriter.writeEstateStellplatz(stringArray, estateImpl, 78, '1', 'J', '3', '4', '2', '6', '7');
        iS24CSVWriter.writeEstateZustand(stringArray, estateImpl, 68, 0, 11, 1, 8, 7, 5, 6, 2, 4, 9, 10, 3);
        if (stringArray[63] == null || stringArray[63].trim().length() == 0) {
            stringArray[63] = "0";
        }
        if (stringArray[61] == null || stringArray[61].trim().length() == 0) {
            stringArray[61] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "GESAMTFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[61] == null || stringArray[61].trim().length() == 0) {
            stringArray[61] = iS24CSVWriter.writeEstateValueAsNumber("FLAECHEN", "NUTZFLAECHE", estateImpl, 10, 2);
        }
        if (stringArray[61] == null || stringArray[61].trim().length() == 0) {
            stringArray[61] = "0";
        }
        return stringArray;
    }
}

