/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.csv.is24;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.csv.CSVWriter;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchema;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class IS24CSVWriter
extends CSVWriter {
    private static final Logger LOGGER = Logger.getLogger(IS24CSVWriter.class);
    private boolean energyCertificateAppendedToDescription = false;

    public IS24CSVWriter() {
    }

    public IS24CSVWriter(Locale locale) {
        this.setOpenEstateLanguage(locale);
    }

    @Override
    public String getCsvCharset() {
        return "CP1252";
    }

    @Override
    public String getCsvLineSeparator() {
        return "\r\n";
    }

    @Override
    public String getCsvValueSeparator() {
        return "|";
    }

    protected void handleValues(String[] stringArray, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl) {
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    @Override
    protected String prepareValue(String string) {
        return super.prepareValue(string).replaceAll("<br/>", "<br>");
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    @Override
    public void write(Writer writer, SerializableXmlElement serializableXmlElement) throws IOException {
        if (serializableXmlElement == null) {
            throw new NullPointerException("empty destination object!");
        }
        if (serializableXmlElement instanceof AgencyImpl) {
            this.write(writer, (AgencyImpl)serializableXmlElement);
        } else if (serializableXmlElement instanceof TransferImpl) {
            this.write(writer, (TransferImpl)serializableXmlElement);
        } else {
            throw new IllegalArgumentException("invalid destination object: " + serializableXmlElement.getClass().getName());
        }
    }

    public void write(Writer writer, AgencyImpl agencyImpl) throws IOException {
        this.getErrorMap().clear();
        for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
            try {
                AgentContactImpl agentContactImpl = null;
                if (estateImpl.getContactId() != null && agencyImpl.getContacts().containsKey(estateImpl.getContactId())) {
                    agentContactImpl = agencyImpl.getContacts().get(estateImpl.getContactId());
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                this.write(writer, estateImpl, agencyImpl.getAgent(), agentContactImpl, arrayList);
                if (arrayList.isEmpty()) continue;
                this.putErrors(estateImpl.getId(), arrayList);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("immobilie #" + estateImpl.getId() + " konnte nicht geschrieben werden!"));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    public void write(Writer writer, TransferImpl transferImpl) throws IOException {
        this.getErrorMap().clear();
        for (TransferAgencyImpl transferAgencyImpl : transferImpl.getAgencies()) {
            this.write(writer, transferAgencyImpl);
        }
    }

    protected void write(Writer writer, TransferAgencyImpl transferAgencyImpl) throws IOException {
        Object object;
        AbstractImplItem abstractImplItem;
        for (EstateImpl object2 : transferAgencyImpl.getEstatesToSave()) {
            try {
                abstractImplItem = null;
                if (object2.getContactId() != null && transferAgencyImpl.getContacts().containsKey(object2.getContactId())) {
                    abstractImplItem = transferAgencyImpl.getContacts().get(object2.getContactId());
                }
                object = new ArrayList<String>();
                this.write(writer, object2, transferAgencyImpl.getAgent(), (AgentContactImpl)abstractImplItem, (List<String>)object);
                if (object.isEmpty()) continue;
                this.putErrors(object2.getId(), (List<String>)object);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("immobilie #" + object2.getId() + " konnte nicht geschrieben werden!"));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        for (String string : transferAgencyImpl.getEstateIdsToRemove()) {
            abstractImplItem = new EstateImpl();
            ((EstateImpl)abstractImplItem).setId(string);
            object = new IS24CSVSchema(){

                @Override
                public int getIS24TypeId() {
                    return 0;
                }
            };
            String[] stringArray = ((IS24CSVSchema)object).writeValues(this, (EstateImpl)abstractImplItem, transferAgencyImpl.getAgent(), null);
            if (stringArray == null) {
                LOGGER.warn((Object)("l\u00f6schung konnten nicht erzeugt werden f\u00fcr immobilie #" + string));
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("L\u00f6schung konnte nicht erzeugt werden f\u00fcr " + ((EstateImpl)abstractImplItem).getType().getName() + " / " + ((EstateImpl)abstractImplItem).getAction());
                this.putErrors(((EstateImpl)abstractImplItem).getId(), arrayList);
                continue;
            }
            stringArray[0] = String.valueOf('D');
            this.writeValues(writer, stringArray);
        }
    }

    protected void write(Writer writer, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) throws IOException, OpenEstateException {
        IS24CSVSchema iS24CSVSchema = IS24CSVSchema.loadSchema(estateImpl);
        if (iS24CSVSchema == null) {
            LOGGER.warn((Object)("kein csv-schema gefunden f\u00fcr immobilie #" + estateImpl.getId() + " / " + estateImpl.getType().getName() + " / " + estateImpl.getAction()));
            list.add("Von IS24-CSV nicht unterst\u00fctzt: " + estateImpl.getType().getName() + " / " + estateImpl.getAction());
            return;
        }
        String[] stringArray = iS24CSVSchema.writeValues(this, estateImpl, agentImpl, agentContactImpl);
        if (stringArray == null) {
            LOGGER.warn((Object)("csv-werte konnten nicht erzeugt werden f\u00fcr immobilie #" + estateImpl.getId() + " / " + estateImpl.getType().getName() + " / " + estateImpl.getAction()));
            list.add("CSV-Fehler f\u00fcr " + estateImpl.getType().getName() + " / " + estateImpl.getAction());
            return;
        }
        this.handleValues(stringArray, estateImpl, agentImpl, agentContactImpl);
        this.writeValues(writer, stringArray);
    }

    protected boolean writeEstateAttachment(String[] stringArray, EstateAttachmentImpl estateAttachmentImpl, int n, int n2, int n3, int n4, int n5) {
        if (estateAttachmentImpl == null) {
            return false;
        }
        String string = estateAttachmentImpl.getMimeType();
        if (estateAttachmentImpl.isUrl()) {
            stringArray[n3] = "L";
        } else if (string.equalsIgnoreCase("application/pdf")) {
            stringArray[n3] = "IMAGE_GROUNDPLAN".equals(estateAttachmentImpl.getType()) ? "GP" : "V";
        } else if (string.startsWith("image/")) {
            stringArray[n3] = "IMAGE_GROUNDPLAN".equals(estateAttachmentImpl.getType()) ? "GB" : "B";
        } else if (string.startsWith("video/")) {
            stringArray[n3] = "V";
        } else if (string.startsWith("audio/")) {
            stringArray[n3] = "S";
        } else {
            LOGGER.warn((Object)("unsupported mime-type: " + string));
            return false;
        }
        if ("video/x-msvideo".equalsIgnoreCase(string)) {
            stringArray[n2] = ".AVI";
        } else if ("image/bmp".equalsIgnoreCase(string)) {
            stringArray[n2] = ".BMP";
        } else if ("image/gif".equalsIgnoreCase(string)) {
            stringArray[n2] = ".GIF";
        } else if ("image/jpeg".equalsIgnoreCase(string)) {
            stringArray[n2] = ".JPG";
        } else if ("video/quicktime".equalsIgnoreCase(string)) {
            stringArray[n2] = ".MOV";
        } else if ("video/mp4".equalsIgnoreCase(string)) {
            stringArray[n2] = ".MP4";
        } else if ("video/mpeg".equalsIgnoreCase(string)) {
            stringArray[n2] = ".MPE";
        } else if ("video/mpeg".equalsIgnoreCase(string)) {
            stringArray[n2] = ".MPEG";
        } else if ("video/mpeg".equalsIgnoreCase(string)) {
            stringArray[n2] = ".MPG";
        } else if ("application/pdf".equalsIgnoreCase(string)) {
            stringArray[n2] = ".PDF";
        } else if ("image/png".equalsIgnoreCase(string)) {
            stringArray[n2] = ".PNG";
        } else if ("video/quicktime".equalsIgnoreCase(string)) {
            stringArray[n2] = ".QT";
        } else if ("video/quicktime".equalsIgnoreCase(string)) {
            stringArray[n2] = ".QTL";
        } else if ("application/vnd.rn-realmedia".equalsIgnoreCase(string)) {
            stringArray[n2] = ".RM";
        } else if ("video/vnd.rn-realvideo".equalsIgnoreCase(string)) {
            stringArray[n2] = ".RV";
        } else if ("video/x-ms-wmv".equalsIgnoreCase(string)) {
            stringArray[n2] = ".WMV";
        } else {
            LOGGER.warn((Object)("can't find a suffix for mime-type: " + string));
            return false;
        }
        if (estateAttachmentImpl.isName()) {
            stringArray[n] = estateAttachmentImpl.getFileAsName();
        } else if (estateAttachmentImpl.isUrl()) {
            stringArray[n] = estateAttachmentImpl.getFileAsUrl().toString();
        } else {
            LOGGER.warn((Object)"unsupported attachment-type.");
            return false;
        }
        stringArray[n5] = estateAttachmentImpl.getTitle(this.getOpenEstateLanguage());
        return true;
    }

    protected void writeEstateAusstattung(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4, int n5, int n6) {
        String string = "AUSSTATTUNG.AUSSTATTUNG_ART";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        String string2 = (String)estateImpl.getAttribute(string).getValueObject();
        if ("EINFACH".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(n3);
        } else if ("GEHOBEN".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(n4);
        } else if ("LUXUS".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(n5);
        } else if ("NORMAL".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(n6);
        }
    }

    protected void writeEstateBauphase(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4, int n5) {
        String string = "ZUSTAND.BAUPHASE";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        String string2 = (String)estateImpl.getAttribute(string).getValueObject();
        stringArray[n] = "IN_PLANUNG".equalsIgnoreCase(string2) ? String.valueOf(n3) : ("IM_BAU".equalsIgnoreCase(string2) ? String.valueOf(n4) : ("ABGESCHLOSSEN".equalsIgnoreCase(string2) ? String.valueOf(n5) : String.valueOf(n2)));
    }

    protected void writeEstateBebaubarNach(String[] stringArray, EstateImpl estateImpl, int n, char c, char c2, char c3, char c4) {
        String string = "VERWALTUNG.BEBAUBAR_NACH";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        String string2 = (String)estateImpl.getAttribute(string).getValueObject();
        stringArray[n] = "AUSSENGEBIET".equalsIgnoreCase(string2) ? String.valueOf(c2) : ("BEBAUUNGSPLAN".equalsIgnoreCase(string2) ? String.valueOf(c3) : ("NACHBARBEBAUUNG".equalsIgnoreCase(string2) ? String.valueOf(c4) : String.valueOf(c)));
    }

    protected void writeEstateBefeuerung(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        String string = "AUSSTATTUNG.BEFEUERUNG";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        String[] stringArray2 = (String[])estateImpl.getAttribute(string).getValueObject();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray2) {
            int n10 = -1;
            if ("ERDWAERME".equalsIgnoreCase(string2)) {
                n10 = n2;
            } else if ("FERNWAERME".equalsIgnoreCase(string2)) {
                n10 = n3;
            } else if ("GAS".equalsIgnoreCase(string2)) {
                n10 = n4;
            } else if ("KOHLE".equalsIgnoreCase(string2)) {
                n10 = n5;
            } else if ("OEL".equalsIgnoreCase(string2)) {
                n10 = n6;
            } else if ("SOLAR".equalsIgnoreCase(string2)) {
                n10 = n8;
            } else if ("ELEKTRO".equalsIgnoreCase(string2)) {
                n10 = n9;
            }
            if (n10 <= -1) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(n10);
        }
        stringArray[n] = stringBuilder.toString().trim();
    }

    protected void writeEstateBodenbelag(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
        String[] stringArray2;
        String string = "AUSSTATTUNG.BEFEUERUNG";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        for (String string2 : stringArray2 = (String[])estateImpl.getAttribute(string).getValueObject()) {
            int n15 = -1;
            if ("BETON".equalsIgnoreCase(string2)) {
                n15 = n3;
            } else if ("EPOXIDHARZ".equalsIgnoreCase(string2)) {
                n15 = n4;
            } else if ("FLIESEN".equalsIgnoreCase(string2) || "KERAMIK".equalsIgnoreCase(string2) || "TERRAKOTTA".equalsIgnoreCase(string2)) {
                n15 = n5;
            } else if ("LAMINAT".equalsIgnoreCase(string2)) {
                n15 = n6;
            } else if ("NACH_WUNSCH".equalsIgnoreCase(string2)) {
                n15 = n7;
            } else if ("PARKETT".equalsIgnoreCase(string2)) {
                n15 = n9;
            } else if ("PVC".equalsIgnoreCase(string2)) {
                n15 = n10;
            } else if ("STEIN".equalsIgnoreCase(string2) || "GRANIT".equalsIgnoreCase(string2) || "MARMOR".equalsIgnoreCase(string2) || "SCHIEFER".equalsIgnoreCase(string2)) {
                n15 = n11;
            } else if ("TEPPICH".equalsIgnoreCase(string2)) {
                n15 = n12;
            } else if ("TEPPICH_ANTISTAT".equalsIgnoreCase(string2)) {
                n15 = n13;
            }
            if (n15 <= -1) continue;
            stringArray[n] = String.valueOf(n15);
            return;
        }
        stringArray[n] = String.valueOf(n2);
    }

    protected void writeEstateEbk(String[] stringArray, EstateImpl estateImpl, int n) {
        Boolean bl = this.hasEstateValue("AUSSTATTUNG", "KUECHE", "EINBAUKUECHE", estateImpl);
        if (Boolean.TRUE.equals(bl)) {
            stringArray[n] = String.valueOf('J');
        } else if (Boolean.FALSE.equals(bl)) {
            stringArray[n] = String.valueOf('N');
        }
    }

    protected void writeEstateEnergiepass(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4, int n5, int n6) {
        String string;
        String string2 = "ENERGIEPASS.ART";
        String string3 = string = estateImpl.hasAttribute(string2) ? (String)estateImpl.getAttribute(string2).getValueObject() : null;
        if ("BEDARF".equalsIgnoreCase(string)) {
            stringArray[n] = String.valueOf(n3);
            stringArray[n5] = this.writeEstateValueAsNumber("ENERGIEPASS", "BEDARF_GESAMT", estateImpl, 5, 2);
        } else if ("VERBRAUCH".equalsIgnoreCase(string)) {
            stringArray[n] = String.valueOf(n4);
            stringArray[n5] = this.writeEstateValueAsNumber("ENERGIEPASS", "VERBRAUCH_GESAMT", estateImpl, 5, 2);
            stringArray[n6] = this.writeEstateValueAsYesNo("ENERGIEPASS", "VERBRAUCH_INKL_WARMWASSER", estateImpl);
        } else {
            Double d = this.getEstateValueAsDouble("ENERGIEPASS", "VERBRAUCH_GESAMT", estateImpl);
            Boolean bl = this.getEstateValueAsBoolean("ENERGIEPASS", "VORHANDEN", estateImpl);
            if (Boolean.TRUE.equals(bl) && d != null && d > 0.0) {
                stringArray[n] = String.valueOf(n4);
                stringArray[n5] = this.writeEstateValueAsNumber("ENERGIEPASS", "VERBRAUCH_GESAMT", estateImpl, 5, 2);
                stringArray[n6] = this.writeEstateValueAsYesNo("ENERGIEPASS", "VERBRAUCH_INKL_WARMWASSER", estateImpl);
            }
        }
    }

    protected void writeEstateErschliessung(String[] stringArray, EstateImpl estateImpl, int n, char c, char c2, char c3) {
        String string = "ZUSTAND.ERSCHLIESSUNG";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        String string2 = (String)estateImpl.getAttribute(string).getValueObject();
        if ("VOLLERSCHLOSSEN".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(c);
        } else if ("TEILERSCHLOSSEN".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(c2);
        } else if ("UNERSCHLOSSEN".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(c3);
        }
    }

    protected void writeEstateGaesteWc(String[] stringArray, EstateImpl estateImpl, int n) {
        Boolean bl = this.hasEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl);
        if (Boolean.TRUE.equals(bl)) {
            stringArray[n] = String.valueOf('J');
        } else if (Boolean.FALSE.equals(bl)) {
            stringArray[n] = String.valueOf('N');
        }
    }

    protected void writeEstateGeschlecht(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3) {
        String string = "VERWALTUNG.GESCHLECHT";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        String string2 = (String)estateImpl.getAttribute(string).getValueObject();
        if ("FRAU".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(n2);
        } else if ("MANN".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(n3);
        }
    }

    protected void writeEstateHaustiere(String[] stringArray, EstateImpl estateImpl, int n, char c, char c2, char c3) {
        String string = "VERWALTUNG.HAUSTIERE";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        String string2 = (String)estateImpl.getAttribute(string).getValueObject();
        if ("JA".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(c);
        } else if ("NEIN".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(c2);
        } else if ("VEREINBARUNG".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(c3);
        }
    }

    protected void writeEstateHeizungsart(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4) {
        String[] stringArray2;
        String string = "AUSSTATTUNG.HEIZUNGSART";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        for (String string2 : stringArray2 = (String[])estateImpl.getAttribute(string).getValueObject()) {
            if ("ETAGE".equalsIgnoreCase(string2)) {
                stringArray[n] = String.valueOf(n2);
                return;
            }
            if ("OFEN".equalsIgnoreCase(string2)) {
                stringArray[n] = String.valueOf(n3);
                return;
            }
            if (!"ZENTRAL".equalsIgnoreCase(string2)) continue;
            stringArray[n] = String.valueOf(n4);
            return;
        }
        stringArray[n] = "";
    }

    protected void writeEstateKeller(String[] stringArray, EstateImpl estateImpl, int n) {
        String string = "AUSSTATTUNG.UNTERKELLERT";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        String string2 = (String)estateImpl.getAttribute(string).getValueObject();
        if ("JA".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf('J');
        } else if ("TEIL".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf('J');
        } else if ("NEIN".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf('N');
        }
    }

    protected void writeEstateMietePro(String[] stringArray, EstateImpl estateImpl, int n, char c, char c2, char c3) {
        String string = "PREISE.MIETE_PRO";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        String string2 = (String)estateImpl.getAttribute(string).getValueObject();
        if ("TAG".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(c);
        } else if ("WOCHE".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(c2);
        } else if ("MONAT".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(c3);
        }
    }

    protected void writeEstateMoebliert(String[] stringArray, EstateImpl estateImpl, int n) {
        String string = "AUSSTATTUNG.MOEBLIERT";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        String string2 = (String)estateImpl.getAttribute(string).getValueObject();
        if ("JA".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf('J');
        } else if ("NEIN".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf('N');
        }
    }

    protected void writeEstateRaucher(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3) {
        String string = "VERWALTUNG.NICHTRAUCHER";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        String string2 = (String)estateImpl.getAttribute(string).getValueObject();
        if ("JA".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(n3);
        } else if ("EGAL".equalsIgnoreCase(string2)) {
            stringArray[n] = String.valueOf(n2);
        }
    }

    protected void writeEstateRollstuhl(String[] stringArray, EstateImpl estateImpl, int n) {
        Boolean bl = this.hasEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl);
        if (Boolean.TRUE.equals(bl)) {
            stringArray[n] = String.valueOf('J');
        } else if (Boolean.FALSE.equals(bl)) {
            stringArray[n] = String.valueOf('N');
        }
    }

    protected void writeEstateSenioren(String[] stringArray, EstateImpl estateImpl, int n) {
        Boolean bl = this.hasEstateValue("AUSSTATTUNG", "EIGNUNG", "SENIOREN", estateImpl);
        if (Boolean.TRUE.equals(bl)) {
            stringArray[n] = String.valueOf('J');
        } else if (Boolean.FALSE.equals(bl)) {
            stringArray[n] = String.valueOf('N');
        }
    }

    protected void writeEstateStellplatz(String[] stringArray, EstateImpl estateImpl, int n, char c, char c2, char c3, char c4, char c5, char c6, char c7) {
        String[] stringArray2;
        String string = "FLAECHEN.STELLPLATZART";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        for (String string2 : stringArray2 = (String[])estateImpl.getAttribute(string).getValueObject()) {
            if ("AUSSEN".equalsIgnoreCase(string2)) {
                stringArray[n] = String.valueOf(c3);
                return;
            }
            if ("CARPORT".equalsIgnoreCase(string2)) {
                stringArray[n] = String.valueOf(c4);
                return;
            }
            if ("GARAGE".equalsIgnoreCase(string2)) {
                stringArray[n] = String.valueOf(c5);
                return;
            }
            if ("PARKHAUS".equalsIgnoreCase(string2)) {
                stringArray[n] = String.valueOf(c6);
                return;
            }
            if (!"TIEFGARAGE".equalsIgnoreCase(string2)) continue;
            stringArray[n] = String.valueOf(c7);
            return;
        }
        stringArray[n] = String.valueOf(stringArray2.length > 0 ? c2 : c);
    }

    protected String writeEstateValue(String string, String string2, EstateImpl estateImpl) {
        try {
            Object object;
            String string3 = string + "." + string2;
            Object object2 = object = estateImpl.hasAttribute(string3) ? estateImpl.getAttribute(string3).getValueObject() : null;
            if (object == null) {
                return null;
            }
            if (object instanceof Number) {
                return object.toString().replace('.', ',');
            }
            return object.toString();
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not write attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    protected String writeEstateValueAsDate(String string, String string2, EstateImpl estateImpl) {
        try {
            String string3 = string + "." + string2;
            Object object = estateImpl.hasAttribute(string3) ? estateImpl.getAttribute(string3).getValueObject() : null;
            return IS24CSVSchema.getCsvDateFormat().format((Date)object);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not write date-attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    protected String writeEstateValueAsNumber(String string, String string2, EstateImpl estateImpl, int n, int n2) {
        try {
            Object object;
            String string3 = string + "." + string2;
            Object object2 = object = estateImpl.hasAttribute(string3) ? estateImpl.getAttribute(string3).getValueObject() : null;
            if (object == null) {
                return null;
            }
            Number number = null;
            if (object instanceof Number) {
                number = (Number)object;
            } else if (object instanceof String) {
                try {
                    number = Double.valueOf(object.toString());
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not parse attribute as number");
                    LOGGER.warn((Object)("> estate #" + estateImpl.getId()));
                    LOGGER.warn((Object)("> " + string + "." + string2 + " = " + object.toString()));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
                    return null;
                }
            } else {
                LOGGER.warn((Object)"could not convert attribute to number");
                LOGGER.warn((Object)("> estate #" + estateImpl.getId()));
                LOGGER.warn((Object)("> " + string + "." + string2 + " = " + object.toString()));
                return null;
            }
            double d = Math.pow(10.0, n);
            if (number.doubleValue() >= d) {
                LOGGER.warn((Object)"number is bigger than allowed!");
                LOGGER.warn((Object)("> value: " + number));
                LOGGER.warn((Object)("> limit: " + d));
                return null;
            }
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setGroupingSize(0);
            decimalFormat.setMaximumFractionDigits(n2);
            decimalFormat.setMaximumIntegerDigits(n);
            decimalFormat.setParseIntegerOnly(n2 <= 0);
            decimalFormat.getDecimalFormatSymbols().setDecimalSeparator(',');
            return decimalFormat.format(number.doubleValue());
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not write attribute!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    protected String writeEstateValueAsYear(String string, String string2, EstateImpl estateImpl) {
        return this.writeEstateValueAsNumber(string, string2, estateImpl, 4, 0);
    }

    protected String writeEstateValueAsYesNo(String string, String string2, EstateImpl estateImpl) {
        String string3 = this.writeEstateValue(string, string2, estateImpl);
        if (String.valueOf('J').equalsIgnoreCase(string3) || Boolean.TRUE.toString().equalsIgnoreCase(string3)) {
            return String.valueOf('J');
        }
        if (String.valueOf('N').equalsIgnoreCase(string3) || Boolean.FALSE.toString().equalsIgnoreCase(string3)) {
            return String.valueOf('N');
        }
        return null;
    }

    protected void writeEstateZulieferung(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        String string = "UMFELD.ZULIEFERUNG";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        String[] stringArray2 = (String[])estateImpl.getAttribute(string).getValueObject();
        stringArray[n] = String.valueOf(n2);
        for (String string2 : stringArray2) {
            if ("DIREKT".equalsIgnoreCase(string2)) {
                stringArray[n] = String.valueOf(n3);
            } else if ("GANZTAEGIG".equalsIgnoreCase(string2)) {
                stringArray[n] = String.valueOf(n4);
            } else if ("NICHT_DIREKT".equalsIgnoreCase(string2)) {
                stringArray[n] = String.valueOf(n5);
            } else if ("PKW_ZUFAHRT".equalsIgnoreCase(string2)) {
                stringArray[n] = String.valueOf(n6);
            } else if ("VON_HINTEN".equalsIgnoreCase(string2)) {
                stringArray[n] = String.valueOf(n7);
            } else if ("VON_VORN".equalsIgnoreCase(string2)) {
                stringArray[n] = String.valueOf(n8);
            } else if ("VORMITTAGS".equalsIgnoreCase(string2)) {
                stringArray[n] = String.valueOf(n9);
            }
            if (stringArray[n].equals(String.valueOf(n2))) continue;
            return;
        }
    }

    protected void writeEstateZustand(String[] stringArray, EstateImpl estateImpl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        String string = "ZUSTAND.ZUSTAND";
        if (!estateImpl.hasAttribute(string)) {
            return;
        }
        String string2 = (String)estateImpl.getAttribute(string).getValueObject();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("ABRISSOBJEKT", n3);
        hashMap.put("AUSGEZEICHNET", n6);
        hashMap.put("ERSTBEZUG", n4);
        hashMap.put("ERSTBEZUG_NACH_SANIERUNG", n5);
        hashMap.put("GEPFLEGT", n6);
        hashMap.put("GUT", n6);
        hashMap.put("MODERNISIERT", n7);
        hashMap.put("NACH_VEREINBARUNG", n8);
        hashMap.put("NEUWERTIG", n9);
        hashMap.put("RENOVIERT_VOLL", n13);
        hashMap.put("RENOVIERUNGSBEDARF_TEIL", n10);
        hashMap.put("RENOVIERUNGSBEDARF_VOLL", n12);
        hashMap.put("SANIERT_VOLL", n11);
        stringArray[n] = hashMap.containsKey(string2) ? ((Integer)hashMap.get(string2)).toString() : String.valueOf(n2);
    }
}

