/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.windows.WindowsLookAndFeel;
import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateTranslator;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleNumericAttrib;
import com.openindex.openestate.impl.attribs.SimpleStringAttrib;
import com.openindex.openestate.impl.attribs.SimpleTimeAttrib;
import com.openindex.openestate.impl.csv.is24.IS24CSVReader;
import com.openindex.openestate.impl.csv.is24.IS24CSVWriter;
import com.openindex.openestate.impl.utils.ExampleFactory;
import com.openindex.openestate.impl.utils.JEstateActionItem;
import com.openindex.openestate.impl.utils.JEstateTypeTreeModel;
import com.openindex.openestate.impl.utils.JEstateTypeTreeNode;
import com.openindex.openestate.impl.utils.OpenEstateLocaleComboBox;
import com.openindex.openestate.impl.utils.UTF8ResourceBundle;
import com.openindex.openestate.impl.xml.IS24XmlReader;
import com.openindex.openestate.impl.xml.IS24XmlUtils;
import com.openindex.openestate.impl.xml.IS24XmlWriter;
import com.openindex.openestate.impl.xml.ImmoXmlReader;
import com.openindex.openestate.impl.xml.ImmoXmlUtils;
import com.openindex.openestate.impl.xml.ImmoXmlWriter;
import com.openindex.openestate.impl.xml.ImmobiliareUtils;
import com.openindex.openestate.impl.xml.ImmobiliareWriter;
import com.openindex.openestate.impl.xml.OpenImmoReader;
import com.openindex.openestate.impl.xml.OpenImmoUtils;
import com.openindex.openestate.impl.xml.OpenImmoWriter;
import com.openindex.openestate.impl.xml.TrovitUtils;
import com.openindex.openestate.impl.xml.TrovitWriter;
import com.openindex.openestate.impl.xml.immoxml.Immoxml;
import com.openindex.openestate.impl.xml.is24.ImmobilienTransferTyp;
import com.openindex.openestate.impl.xml.openimmo.Openimmo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class DevelopmentTool
extends JFrame {
    public static final String RESOURCE_PATH = "/com/openindex/openestate/impl/utils/resources/";
    private static final Logger LOGGER = Logger.getLogger(DevelopmentTool.class);
    private static final Locale DEFAULT_TRANSLATION = Locale.ENGLISH;
    private static Locale estateLocale = null;
    private static Locale resourceLocale = null;
    private static ResourceBundle resourceLocaleBundle = null;
    private static Map<String, Locale> resourceLocales = null;
    private static final int OPENESTATE = 0;
    private static final int OPENIMMO = 1;
    private static final int IMMOXML = 2;
    private static final int IS24_XML = 3;
    private static final int IS24_CSV = 4;
    private static final int ATTRIBS_COLUMN_GROUP = 0;
    private static final int ATTRIBS_COLUMN_ATTRIB = 1;
    private static final int ATTRIBS_COLUMN_TRANSLATION = 2;
    private static final int ATTRIBS_COLUMN_TYPE = 3;
    private static final int ATTRIBS_COLUMN_TYPE_OPTIONS = 4;
    private static final int ATTRIBS_COLUMN_IS_REQUIRED = 5;
    private static final int ATTRIBS_COLUMN_IS_COMPLEX = 6;
    private static final Map<Integer, String> ATTRIBS_COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> ATTRIBS_COLUMN_CLASSES;
    private DefaultComboBoxModel estateActionBoxModel = null;
    private DefaultTableModel translationsTableModel = null;
    private OpenEstateType selectedEstateType = null;
    private JEditorPane aboutAuthorsEditor;
    private JScrollPane aboutAuthorsScroller;
    private JEditorPane aboutDescriptionEditor;
    private JScrollPane aboutDescriptionScroller;
    private JEditorPane aboutLibrariesEditor;
    private JScrollPane aboutLibrariesScroller;
    private JPanel aboutPanel;
    private JEditorPane aboutPartnersEditor;
    private JScrollPane aboutPartnersScroller;
    private JTabbedPane aboutTabPanel;
    private JEditorPane aboutTermsEditor;
    private JScrollPane aboutTermsScroller;
    private JLabel aboutTitleLabel;
    private JMenu convertIS24CSVMenu;
    private JMenu convertIS24XMLMenu;
    private JMenu convertImmoXmlMenu;
    private JMenu convertOpenEstateAgencyMenu;
    private JMenu convertOpenEstateTransferMenu;
    private JMenu convertOpenImmoMenu;
    private JMenuItem convert_IS24CSV_to_OEA;
    private JMenuItem convert_IS24CSV_to_OET;
    private JMenuItem convert_IS24XML_to_OEA;
    private JMenuItem convert_IS24XML_to_OET;
    private JMenuItem convert_IX_to_OEA;
    private JMenuItem convert_IX_to_OET;
    private JMenuItem convert_OEA_to_IS24CSV;
    private JMenuItem convert_OEA_to_IS24XML;
    private JMenuItem convert_OEA_to_IX;
    private JMenuItem convert_OEA_to_Immobiliare;
    private JMenuItem convert_OEA_to_OI;
    private JMenuItem convert_OEA_to_Trovit;
    private JMenuItem convert_OET_to_IS24CSV;
    private JMenuItem convert_OET_to_IS24XML;
    private JMenuItem convert_OET_to_IX;
    private JMenuItem convert_OET_to_Immobiliare;
    private JMenuItem convert_OET_to_OI;
    private JMenuItem convert_OET_to_Trovit;
    private JMenuItem convert_OI_to_OEA;
    private JMenuItem convert_OI_to_OET;
    private JButton converterButton;
    private JPopupMenu converterMenu;
    private JButton defaultTranslationButton;
    private JComboBox defaultTranslationLanguageBox;
    private JComboBox estateActionBox;
    private JTabbedPane estateAttribsTabPanel;
    private JButton estateExampleButton;
    private JComboBox estateLanguageBox;
    private JPanel estateTypePanel;
    private JScrollPane estateTypeScrollPane;
    private JTree estateTypeTree;
    private JMenuItem example_Agency;
    private JMenuItem example_Agent;
    private JMenuItem example_Estate;
    private JMenuItem example_TransferFull;
    private JMenuItem example_TransferPart;
    private JButton examplesButton;
    private JPopupMenu examplesPopupMenu;
    private JMenuBar mainMenuBar;
    private JTabbedPane mainTabPanel;
    private JButton openTranslationButton;
    private JMenu programLanguageMenu;
    private JMenu programMenu;
    private JMenuItem programQuitMenuItem;
    private JButton saveTranslationButton;
    private JButton serializationButton;
    private JScrollPane serializationInputScrollPane;
    private RSyntaxTextArea serializationInputTextArea;
    private JPopupMenu serializationMenu;
    private JScrollPane serializationOutputScrollPane;
    private RSyntaxTextArea serializationOutputTextArea;
    private JMenuItem serialize_IS24CSV;
    private JMenuItem serialize_IS24XML;
    private JMenuItem serialize_IX;
    private JMenuItem serialize_OE;
    private JMenuItem serialize_OI;
    private JPanel translationsPanel;
    private JScrollPane translationsScrollPane;
    private JTable translationsTable;
    private JPanel xmlExamplePanel;
    private JScrollPane xmlExampleScrollPane;
    private RSyntaxTextArea xmlExampleTextArea = new RSyntaxTextArea();
    private JPanel xmlSerializationPanel;
    private JSplitPane xmlSerializationSplitter;

    private DevelopmentTool() throws DocumentException, OpenEstateException, IOException {
        Object object;
        this.xmlExampleScrollPane = new RTextScrollPane((Component)this.xmlExampleTextArea);
        this.serializationInputTextArea = new RSyntaxTextArea();
        this.serializationInputScrollPane = new RTextScrollPane((Component)this.serializationInputTextArea);
        this.serializationOutputTextArea = new RSyntaxTextArea();
        this.serializationOutputScrollPane = new RTextScrollPane((Component)this.serializationOutputTextArea);
        this.initComponents();
        this.setLocationRelativeTo(null);
        try {
            object = "/com/openindex/openestate/impl/utils/resources/DevTool.png";
            this.setIconImage(ImageIO.read(DevelopmentTool.class.getResource((String)object)));
        }
        catch (Exception exception) {
            this.setIconImage(null);
            LOGGER.warn((Object)"could not load frame-icon!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.serializationInputTextArea.setSyntaxEditingStyle("text/xml");
        this.serializationInputTextArea.add((Component)new Gutter((RTextArea)this.serializationInputTextArea));
        this.serializationOutputTextArea.setSyntaxEditingStyle("text/xml");
        this.xmlExampleTextArea.setSyntaxEditingStyle("text/xml");
        object = null;
        ButtonGroup buttonGroup = new ButtonGroup();
        for (final Locale locale : resourceLocales.values()) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(locale.getDisplayLanguage(locale));
            jRadioButtonMenuItem.setSelected(locale.getLanguage().equals(Locale.getDefault().getLanguage()));
            jRadioButtonMenuItem.setIcon(OpenEstateUtils.getFlagIcon(locale));
            if (jRadioButtonMenuItem.isSelected()) {
                this.initResources(Locale.getDefault());
            }
            if (locale.getLanguage().equals(DEFAULT_TRANSLATION.getLanguage())) {
                object = jRadioButtonMenuItem;
            }
            buttonGroup.add(jRadioButtonMenuItem);
            this.programLanguageMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DevelopmentTool.this.initResources(locale);
                }
            });
        }
        if (buttonGroup.getSelection() == null || !buttonGroup.getSelection().isSelected()) {
            LOGGER.debug((Object)"fallback to default language...");
            if (object == null) {
                throw new OpenEstateException("could not find default translation!");
            }
            ((AbstractButton)object).setSelected(true);
            this.initResources(null);
        }
        this.estateActionBoxModel = new DefaultComboBoxModel();
        this.estateActionBox.setModel(this.estateActionBoxModel);
        this.estateActionBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DevelopmentTool.this.estateActionBox.getSelectedIndex();
                if (n <= 0) {
                    DevelopmentTool.this.estateExampleButton.setEnabled(false);
                    return;
                }
                DevelopmentTool.this.estateExampleButton.setEnabled(true);
            }
        });
        this.estateTypeTree.setRootVisible(false);
        this.estateTypeTree.setModel(new JEstateTypeTreeModel());
        this.estateTypeTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (DevelopmentTool.this.estateTypeTree.getSelectionPath() == null) {
                    return;
                }
                JEstateTypeTreeNode jEstateTypeTreeNode = (JEstateTypeTreeNode)DevelopmentTool.this.estateTypeTree.getSelectionPath().getLastPathComponent();
                if (jEstateTypeTreeNode == null) {
                    return;
                }
                DevelopmentTool.this.loadEstateType(jEstateTypeTreeNode.getEstateType());
            }
        });
        for (Locale locale : OpenEstateUtils.getAvailableLocales()) {
            if (!locale.getLanguage().equals(resourceLocaleBundle.getLocale().getLanguage())) continue;
            this.estateLanguageBox.setSelectedIndex(this.estateLanguageBox.getItemCount() - 1);
            this.defaultTranslationLanguageBox.setSelectedIndex(this.defaultTranslationLanguageBox.getItemCount() - 1);
            this.initEstateResources(locale);
        }
        this.translationsTableModel = (DefaultTableModel)this.translationsTable.getModel();
        this.loadTranslationFromResource();
        HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType())) {
                    DevelopmentTool.this.openURL(hyperlinkEvent.getURL());
                }
            }
        };
        this.aboutAuthorsEditor.addHyperlinkListener(hyperlinkListener);
        this.aboutDescriptionEditor.addHyperlinkListener(hyperlinkListener);
        this.aboutLibrariesEditor.addHyperlinkListener(hyperlinkListener);
        this.aboutPartnersEditor.addHyperlinkListener(hyperlinkListener);
        this.aboutTermsEditor.addHyperlinkListener(hyperlinkListener);
        this.examplesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopmentTool.this.examplesPopupMenu.show(DevelopmentTool.this.examplesButton, ((DevelopmentTool)DevelopmentTool.this).examplesButton.getSize().width / 3, ((DevelopmentTool)DevelopmentTool.this).examplesButton.getSize().height);
            }
        });
        this.example_Agency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopmentTool.this.loadExampleAgency();
            }
        });
        this.example_Agent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopmentTool.this.loadExampleAgent();
            }
        });
        this.example_Estate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DevelopmentTool.this.loadExampleEstate();
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Example-Error!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        });
        this.estateExampleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DevelopmentTool.this.selectedEstateType != null && DevelopmentTool.this.estateActionBox.getSelectedIndex() > 0) {
                    try {
                        String string = ((JEstateActionItem)DevelopmentTool.this.estateActionBox.getSelectedItem()).getKey();
                        EstateImpl estateImpl = ExampleFactory.createEstate(DevelopmentTool.this.selectedEstateType, string);
                        DevelopmentTool.this.loadExampleEstate(estateImpl);
                        DevelopmentTool.this.mainTabPanel.setSelectedIndex(2);
                    }
                    catch (Exception exception) {
                        LOGGER.error((Object)"Example-Error!");
                        LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                }
            }
        });
        this.example_TransferPart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopmentTool.this.loadExampleTransfer(false);
            }
        });
        this.example_TransferFull.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopmentTool.this.loadExampleTransfer(true);
            }
        });
        this.serializationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopmentTool.this.serializationMenu.show(DevelopmentTool.this.serializationButton, 0, ((DevelopmentTool)DevelopmentTool.this).serializationButton.getSize().height);
            }
        });
        this.serialize_OE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopmentTool.this.loadXMLSerialization(0);
            }
        });
        this.serialize_OI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopmentTool.this.loadXMLSerialization(1);
            }
        });
        this.serialize_IX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopmentTool.this.loadXMLSerialization(2);
            }
        });
        this.serialize_IS24XML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopmentTool.this.loadXMLSerialization(3);
            }
        });
        this.serialize_IS24CSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopmentTool.this.loadXMLSerialization(4);
            }
        });
        this.converterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopmentTool.this.converterMenu.show(DevelopmentTool.this.converterButton, 0, ((DevelopmentTool)DevelopmentTool.this).converterButton.getSize().height);
            }
        });
        this.convert_OEA_to_OI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    Object object2;
                    AgencyImpl agencyImpl = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    if (string.length() == 0) {
                        agencyImpl = new AgencyImpl();
                    } else {
                        object2 = new SAXReader();
                        object = object2.read((Reader)new StringReader(string));
                        agencyImpl = new AgencyImpl((Document)object);
                    }
                    object2 = new OpenImmoWriter().write(agencyImpl);
                    object = new StringWriter();
                    OpenImmoUtils.createMarshaller().marshal(object2, (Writer)object);
                    DevelopmentTool.this.serializationOutputTextArea.setText(((StringWriter)object).toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert openestate-agency => openindex");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_OET_to_OI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    Object object2;
                    TransferImpl transferImpl = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    if (string.length() == 0) {
                        transferImpl = new TransferImpl();
                    } else {
                        object2 = new SAXReader();
                        object = object2.read((Reader)new StringReader(string));
                        transferImpl = new TransferImpl((Document)object);
                    }
                    object2 = new OpenImmoWriter().write(transferImpl);
                    object = new StringWriter();
                    OpenImmoUtils.createMarshaller().marshal(object2, (Writer)object);
                    DevelopmentTool.this.serializationOutputTextArea.setText(((StringWriter)object).toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert openestate-transfer => openindex");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_OI_to_OEA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Openimmo openimmo = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    openimmo = string.length() == 0 ? OpenImmoUtils.getFactory().createOpenimmo() : (Openimmo)OpenImmoUtils.unmarshallWithoutNamespace(new StringReader(string));
                    AgencyImpl agencyImpl = new OpenImmoReader().readAgency(openimmo);
                    StringWriter stringWriter = new StringWriter();
                    OpenEstateUtils.serializeToXML(agencyImpl, stringWriter, true);
                    DevelopmentTool.this.serializationOutputTextArea.setText(stringWriter.toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert openindex => openestate-agency");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_OI_to_OET.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Openimmo openimmo = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    openimmo = string.length() == 0 ? OpenImmoUtils.getFactory().createOpenimmo() : (Openimmo)OpenImmoUtils.unmarshallWithoutNamespace(new StringReader(string));
                    TransferImpl transferImpl = new OpenImmoReader().readTransfer(openimmo);
                    StringWriter stringWriter = new StringWriter();
                    OpenEstateUtils.serializeToXML(transferImpl, stringWriter, true);
                    DevelopmentTool.this.serializationOutputTextArea.setText(stringWriter.toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert openindex => openestate-transfer");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_OEA_to_IX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    Object object2;
                    AgencyImpl agencyImpl = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    if (string.length() == 0) {
                        agencyImpl = new AgencyImpl();
                    } else {
                        object2 = new SAXReader();
                        object = object2.read((Reader)new StringReader(string));
                        agencyImpl = new AgencyImpl((Document)object);
                    }
                    object2 = new ImmoXmlWriter().write(agencyImpl);
                    object = new StringWriter();
                    ImmoXmlUtils.createMarshaller().marshal(object2, (Writer)object);
                    DevelopmentTool.this.serializationOutputTextArea.setText(((StringWriter)object).toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert openestate-agency => immoxml");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_OET_to_IX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    Object object2;
                    TransferImpl transferImpl = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    if (string.length() == 0) {
                        transferImpl = new TransferImpl();
                    } else {
                        object2 = new SAXReader();
                        object = object2.read((Reader)new StringReader(string));
                        transferImpl = new TransferImpl((Document)object);
                    }
                    object2 = new ImmoXmlWriter().write(transferImpl);
                    object = new StringWriter();
                    ImmoXmlUtils.createMarshaller().marshal(object2, (Writer)object);
                    DevelopmentTool.this.serializationOutputTextArea.setText(((StringWriter)object).toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert openestate-transfer => immoxml");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_IX_to_OEA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Immoxml immoxml = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    immoxml = string.length() == 0 ? ImmoXmlUtils.getFactory().createImmoxml() : (Immoxml)ImmoXmlUtils.createUnmarshaller().unmarshal((Reader)new StringReader(string));
                    AgencyImpl agencyImpl = new ImmoXmlReader().readAgency(immoxml);
                    StringWriter stringWriter = new StringWriter();
                    OpenEstateUtils.serializeToXML(agencyImpl, stringWriter, true);
                    DevelopmentTool.this.serializationOutputTextArea.setText(stringWriter.toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert immoxml => openestate-agency");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_IX_to_OET.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Immoxml immoxml = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    immoxml = string.length() == 0 ? ImmoXmlUtils.getFactory().createImmoxml() : (Immoxml)ImmoXmlUtils.createUnmarshaller().unmarshal((Reader)new StringReader(string));
                    TransferImpl transferImpl = new ImmoXmlReader().readTransfer(immoxml);
                    StringWriter stringWriter = new StringWriter();
                    OpenEstateUtils.serializeToXML(transferImpl, stringWriter, true);
                    DevelopmentTool.this.serializationOutputTextArea.setText(stringWriter.toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert immoxml => openestate-transfer");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_OEA_to_IS24CSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    AgencyImpl agencyImpl = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    if (string.length() == 0) {
                        agencyImpl = new AgencyImpl();
                    } else {
                        object = new SAXReader();
                        Document document = object.read((Reader)new StringReader(string));
                        agencyImpl = new AgencyImpl(document);
                    }
                    object = new StringWriter();
                    new IS24CSVWriter().write((Writer)object, agencyImpl);
                    DevelopmentTool.this.serializationOutputTextArea.setText(((StringWriter)object).toString());
                    DevelopmentTool.this.serializationOutputTextArea.setCaretPosition(0);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert openestate-agency => is24-csv");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_OET_to_IS24CSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    TransferImpl transferImpl = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    if (string.length() == 0) {
                        transferImpl = new TransferImpl();
                    } else {
                        object = new SAXReader();
                        Document document = object.read((Reader)new StringReader(string));
                        transferImpl = new TransferImpl(document);
                    }
                    object = new StringWriter();
                    new IS24CSVWriter().write((Writer)object, transferImpl);
                    DevelopmentTool.this.serializationOutputTextArea.setText(((StringWriter)object).toString());
                    DevelopmentTool.this.serializationOutputTextArea.setCaretPosition(0);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert openestate-transfer => is24-csv");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_IS24CSV_to_OEA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AgencyImpl agencyImpl = new AgencyImpl();
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    if (string.length() > 0) {
                        new IS24CSVReader().read(new StringReader(string), (SerializableXmlElement)agencyImpl);
                    }
                    StringWriter stringWriter = new StringWriter();
                    OpenEstateUtils.serializeToXML(agencyImpl, stringWriter, true);
                    DevelopmentTool.this.serializationOutputTextArea.setText(stringWriter.toString());
                    DevelopmentTool.this.serializationOutputTextArea.setCaretPosition(0);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert is24-csv => openestate-agency");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_IS24CSV_to_OET.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TransferImpl transferImpl = new TransferImpl();
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    if (string.length() > 0) {
                        new IS24CSVReader().read(new StringReader(string), (SerializableXmlElement)transferImpl);
                    }
                    StringWriter stringWriter = new StringWriter();
                    OpenEstateUtils.serializeToXML(transferImpl, stringWriter, true);
                    DevelopmentTool.this.serializationOutputTextArea.setText(stringWriter.toString());
                    DevelopmentTool.this.serializationOutputTextArea.setCaretPosition(0);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert is24-csv => openestate-transfer");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_OEA_to_IS24XML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    Object object2;
                    AgencyImpl agencyImpl = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    if (string.length() == 0) {
                        agencyImpl = new AgencyImpl();
                    } else {
                        object2 = new SAXReader();
                        object = object2.read((Reader)new StringReader(string));
                        agencyImpl = new AgencyImpl((Document)object);
                    }
                    object2 = new IS24XmlWriter().write(agencyImpl);
                    object = new StringWriter();
                    IS24XmlUtils.createMarshaller().marshal(object2, (Writer)object);
                    DevelopmentTool.this.serializationOutputTextArea.setText(((StringWriter)object).toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert openestate-agency => is24-xml");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_OET_to_IS24XML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    Object object2;
                    TransferImpl transferImpl = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    if (string.length() == 0) {
                        transferImpl = new TransferImpl();
                    } else {
                        object2 = new SAXReader();
                        object = object2.read((Reader)new StringReader(string));
                        transferImpl = new TransferImpl((Document)object);
                    }
                    object2 = new IS24XmlWriter().write(transferImpl);
                    object = new StringWriter();
                    IS24XmlUtils.createMarshaller().marshal(object2, (Writer)object);
                    DevelopmentTool.this.serializationOutputTextArea.setText(((StringWriter)object).toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert openestate-transfer => is24-xml");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_IS24XML_to_OEA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JAXBElement jAXBElement = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    jAXBElement = string.length() == 0 ? new JAXBElement(new QName("http://www.immobilienscout24.de/immobilientransfer", "IS24ImmobilienTransfer"), ImmobilienTransferTyp.class, (Object)IS24XmlUtils.getFactory().createImmobilienTransferTyp()) : (JAXBElement)IS24XmlUtils.createUnmarshaller().unmarshal((Reader)new StringReader(string));
                    AgencyImpl agencyImpl = new IS24XmlReader().readAgency((ImmobilienTransferTyp)jAXBElement.getValue());
                    StringWriter stringWriter = new StringWriter();
                    OpenEstateUtils.serializeToXML(agencyImpl, stringWriter, true);
                    DevelopmentTool.this.serializationOutputTextArea.setText(stringWriter.toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert is24-xml => openestate-agency");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_IS24XML_to_OET.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JAXBElement jAXBElement = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    jAXBElement = string.length() == 0 ? new JAXBElement(new QName("http://www.immobilienscout24.de/immobilientransfer", "IS24ImmobilienTransfer"), ImmobilienTransferTyp.class, (Object)IS24XmlUtils.getFactory().createImmobilienTransferTyp()) : (JAXBElement)IS24XmlUtils.createUnmarshaller().unmarshal((Reader)new StringReader(string));
                    TransferImpl transferImpl = new IS24XmlReader().readTransfer((ImmobilienTransferTyp)jAXBElement.getValue());
                    StringWriter stringWriter = new StringWriter();
                    OpenEstateUtils.serializeToXML(transferImpl, stringWriter, true);
                    DevelopmentTool.this.serializationOutputTextArea.setText(stringWriter.toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert is24-xml => openestate-transfer");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_OEA_to_Trovit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    Object object2;
                    AgencyImpl agencyImpl = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    if (string.length() == 0) {
                        agencyImpl = new AgencyImpl();
                    } else {
                        object2 = new SAXReader();
                        object = object2.read((Reader)new StringReader(string));
                        agencyImpl = new AgencyImpl((Document)object);
                    }
                    object2 = new TrovitWriter().write(agencyImpl);
                    object = new StringWriter();
                    TrovitUtils.marshallWithCDATA(TrovitUtils.createMarshaller(), object2, (Writer)object);
                    DevelopmentTool.this.serializationOutputTextArea.setText(((StringWriter)object).toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert openestate-agency => immoxml");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_OET_to_Trovit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    Object object2;
                    TransferImpl transferImpl = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    if (string.length() == 0) {
                        transferImpl = new TransferImpl();
                    } else {
                        object2 = new SAXReader();
                        object = object2.read((Reader)new StringReader(string));
                        transferImpl = new TransferImpl((Document)object);
                    }
                    object2 = new TrovitWriter().write(transferImpl);
                    object = new StringWriter();
                    TrovitUtils.marshallWithCDATA(TrovitUtils.createMarshaller(), object2, (Writer)object);
                    DevelopmentTool.this.serializationOutputTextArea.setText(((StringWriter)object).toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert openestate-transfer => immoxml");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_OEA_to_Immobiliare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    Object object2;
                    AgencyImpl agencyImpl = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    if (string.length() == 0) {
                        agencyImpl = new AgencyImpl();
                    } else {
                        object2 = new SAXReader();
                        object = object2.read((Reader)new StringReader(string));
                        agencyImpl = new AgencyImpl((Document)object);
                    }
                    object2 = new ImmobiliareWriter().write(agencyImpl);
                    object = new StringWriter();
                    ImmobiliareUtils.createMarshaller().marshal(object2, (Writer)object);
                    DevelopmentTool.this.serializationOutputTextArea.setText(((StringWriter)object).toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert openestate-agency => immoxml");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.convert_OET_to_Immobiliare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    Object object2;
                    TransferImpl transferImpl = null;
                    String string = DevelopmentTool.this.serializationInputTextArea.getText().trim();
                    if (string.length() == 0) {
                        transferImpl = new TransferImpl();
                    } else {
                        object2 = new SAXReader();
                        object = object2.read((Reader)new StringReader(string));
                        transferImpl = new TransferImpl((Document)object);
                    }
                    object2 = new ImmobiliareWriter().write(transferImpl);
                    object = new StringWriter();
                    ImmobiliareUtils.createMarshaller().marshal(object2, (Writer)object);
                    DevelopmentTool.this.serializationOutputTextArea.setText(((StringWriter)object).toString());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not convert openestate-transfer => immoxml");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    DevelopmentTool.this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
                }
            }
        });
        this.defaultTranslationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(null, DevelopmentTool.this.getResourceValue("question.reallyLoadDefaultTranslation"));
                if (n != 0) {
                    return;
                }
                DevelopmentTool.this.loadTranslationFromResource();
            }
        });
        this.openTranslationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopmentTool.this.loadTranslationFromFile();
            }
        });
        this.saveTranslationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopmentTool.this.saveTranslation();
            }
        });
        this.programQuitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.estateLanguageBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevelopmentTool.this.initEstateResources((Locale)DevelopmentTool.this.estateLanguageBox.getSelectedItem());
            }
        });
    }

    private String buildAuthorsPage() {
        try {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            HashMap<String, URL> hashMap = new HashMap<String, URL>();
            for (OpenEstateTranslator object2 : OpenEstateUtils.loadTranslatorsByLanguage().values()) {
                String string = object2.getName();
                if (!treeMap.containsKey(string)) {
                    treeMap.put(string, object2.getLocale().getDisplayLanguage());
                    try {
                        hashMap.put(string, new URL(object2.getWebsite()));
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"invalid translator-website!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                    continue;
                }
                treeMap.put(string, (String)treeMap.get(string) + ", " + object2.getLocale().getDisplayLanguage());
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry : treeMap.entrySet()) {
                String string = "-";
                if (hashMap.containsKey(entry.getKey())) {
                    URL uRL = (URL)hashMap.get(entry.getKey());
                    String string2 = uRL.getHost();
                    if (uRL.getPath().length() > 1) {
                        string2 = string2 + uRL.getPath();
                    }
                    string = "<a href=\"" + uRL.toString() + "\">" + string2 + "</a>";
                }
                stringBuilder.append("<li>").append((String)entry.getKey()).append(" (").append((String)entry.getValue()).append(")").append("<br>&raquo; ").append(string).append("</li>");
            }
            String string = this.replaceVars(OpenEstateUtils.readResource(this.getResourceValue("DevelopmentTool.aboutAuthors")), this.getHtmlVar("DevelopmentTool.aboutAuthorsScroller.TabConstraints.tabTitle"));
            return string.replaceAll(Pattern.quote("%DEVELOPER%"), this.getHtmlVar("DevelopmentTool.aboutAuthors.developers")).replaceAll(Pattern.quote("%DEVELOPER_TXT%"), this.getHtmlVar("DevelopmentTool.aboutAuthors.developers.text")).replaceAll(Pattern.quote("%LOGO%"), this.getHtmlVar("DevelopmentTool.aboutAuthors.logo")).replaceAll(Pattern.quote("%LOGO_TXT%"), this.getHtmlVar("DevelopmentTool.aboutAuthors.logo.text")).replaceAll(Pattern.quote("%ICONS%"), this.getHtmlVar("DevelopmentTool.aboutAuthors.icons")).replaceAll(Pattern.quote("%ICONS_TXT%"), this.getHtmlVar("DevelopmentTool.aboutAuthors.icons.text")).replaceAll(Pattern.quote("%I18N%"), this.getHtmlVar("DevelopmentTool.aboutAuthors.translators")).replaceAll(Pattern.quote("%I18N_TXT%"), this.getHtmlVar("DevelopmentTool.aboutAuthors.translators.text")).replaceAll(Pattern.quote("%I18N_LIST%"), stringBuilder.toString());
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return "<html><h1>ERROR</h1>" + OpenEstateUtils.writeException(exception).replaceAll("\\n", "<br>") + "</html>";
        }
    }

    private String buildDescriptionPage() {
        try {
            String string = this.replaceVars(OpenEstateUtils.readResource(this.getResourceValue("DevelopmentTool.aboutDescription")), this.getHtmlVar("DevelopmentTool.aboutDescription.title"));
            return string;
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return "<html><h1>ERROR</h1>" + OpenEstateUtils.writeException(exception).replaceAll("\\n", "<br>") + "</html>";
        }
    }

    private String buildLibrariesPage() {
        try {
            String string = this.replaceVars(OpenEstateUtils.readResource(this.getResourceValue("DevelopmentTool.aboutLibraries")), this.getHtmlVar("DevelopmentTool.aboutLibraries.title"));
            return string.replaceAll(Pattern.quote("%DEPENDENCIES%"), this.getHtmlVar("DevelopmentTool.aboutLibraries.dependencies")).replaceAll(Pattern.quote("%DEPENDENCIES_LICENSE%"), this.getHtmlVar("DevelopmentTool.aboutLibraries.dependencies.license")).replaceAll(Pattern.quote("%UTILITIES%"), this.getHtmlVar("DevelopmentTool.aboutLibraries.utilities")).replaceAll(Pattern.quote("%REMARKS%"), this.getHtmlVar("DevelopmentTool.aboutLibraries.remarks")).replaceAll(Pattern.quote("%REMARKS_TEXT%"), this.getHtmlVar("DevelopmentTool.aboutLibraries.remarks.text"));
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return "<html><h1>ERROR</h1>" + OpenEstateUtils.writeException(exception).replaceAll("\\n", "<br>") + "</html>";
        }
    }

    private String buildLicensePage() {
        try {
            String string = this.replaceVars(OpenEstateUtils.readResource(this.getResourceValue("DevelopmentTool.aboutTerms")), this.getHtmlVar("DevelopmentTool.aboutTerms.title"));
            return string.replaceAll(Pattern.quote("%NOTES%"), this.getHtmlVar("DevelopmentTool.aboutTerms.notes")).replaceAll(Pattern.quote("%NOTES_TEXT%"), this.getHtmlVar("DevelopmentTool.aboutTerms.notes.text"));
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return "<html><h1>ERROR</h1>" + OpenEstateUtils.writeException(exception).replaceAll("\\n", "<br>") + "</html>";
        }
    }

    private String buildPartnersPage() {
        try {
            String string = this.replaceVars(OpenEstateUtils.readResource(this.getResourceValue("DevelopmentTool.aboutPartners")), this.getHtmlVar("DevelopmentTool.aboutPartners.title"));
            return string.replaceAll(Pattern.quote("%YOU%"), this.getHtmlVar("DevelopmentTool.aboutPartners.you")).replaceAll(Pattern.quote("%YOU_TEXT%"), this.getHtmlVar("DevelopmentTool.aboutPartners.you.text"));
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return "<html><h1>ERROR</h1>" + OpenEstateUtils.writeException(exception).replaceAll("\\n", "<br>") + "</html>";
        }
    }

    private JPanel buildEstateAttribsPanel(OpenEstateAttrib[] openEstateAttribArray, OpenEstateType openEstateType, String string) {
        AttribTableModel attribTableModel = new AttribTableModel();
        for (OpenEstateAttrib openEstateAttrib : openEstateAttribArray) {
            attribTableModel.addAttrib(openEstateAttrib, openEstateType, string);
        }
        JTable jTable = new JTable(attribTableModel);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.revalidate();
        jPanel.repaint();
        return jPanel;
    }

    private String getHtmlVar(String string) {
        return StringEscapeUtils.escapeHtml((String)this.getResourceValue(string));
    }

    private String getResourceValue(String string) {
        String string2 = resourceLocaleBundle.getString(string);
        return string2 != null && string2.trim().length() > 0 ? string2.trim() : "???";
    }

    private void initEstateResources(Locale locale) {
        DevelopmentTool.setEstateLocale(locale);
        ((JEstateTypeTreeModel)this.estateTypeTree.getModel()).setLocale(estateLocale);
        this.estateTypeTree.revalidate();
        this.estateTypeTree.repaint();
        if (this.estateTypeTree.getSelectionPath() == null) {
            return;
        }
        JEstateTypeTreeNode jEstateTypeTreeNode = (JEstateTypeTreeNode)this.estateTypeTree.getSelectionPath().getLastPathComponent();
        if (jEstateTypeTreeNode == null) {
            return;
        }
        this.loadEstateType(jEstateTypeTreeNode.getEstateType());
    }

    private void initResources(Locale locale) {
        DevelopmentTool.setResourceLocale(locale);
        this.example_Agency.setText(this.getResourceValue("DevelopmentTool.example_Agency.text"));
        this.example_Agent.setText(this.getResourceValue("DevelopmentTool.example_Agent.text"));
        this.example_Estate.setText(this.getResourceValue("DevelopmentTool.example_Estate.text"));
        this.example_TransferPart.setText(this.getResourceValue("DevelopmentTool.example_TransferPart.text"));
        this.example_TransferFull.setText(this.getResourceValue("DevelopmentTool.example_TransferFull.text"));
        this.serialize_OE.setText(this.getResourceValue("DevelopmentTool.serialize_OE.text"));
        this.serialize_OI.setText(this.getResourceValue("DevelopmentTool.serialize_OI.text"));
        this.serialize_IX.setText(this.getResourceValue("DevelopmentTool.serialize_IX.text"));
        this.serialize_IS24XML.setText(this.getResourceValue("DevelopmentTool.serialize_IS24XML.text"));
        this.serialize_IS24CSV.setText(this.getResourceValue("DevelopmentTool.serialize_IS24CSV.text"));
        this.convertOpenEstateAgencyMenu.setText(this.getResourceValue("DevelopmentTool.convertOpenEstateAgencyMenu.text"));
        this.convert_OEA_to_OI.setText(this.getResourceValue("DevelopmentTool.convert_OEA_to_OI.text"));
        this.convert_OEA_to_IX.setText(this.getResourceValue("DevelopmentTool.convert_OEA_to_IX.text"));
        this.convert_OEA_to_IS24XML.setText(this.getResourceValue("DevelopmentTool.convert_OEA_to_IS24XML.text"));
        this.convert_OEA_to_IS24CSV.setText(this.getResourceValue("DevelopmentTool.convert_OEA_to_IS24CSV.text"));
        this.convert_OEA_to_Trovit.setText(this.getResourceValue("DevelopmentTool.convert_OEA_to_Trovit.text"));
        this.convert_OEA_to_Immobiliare.setText(this.getResourceValue("DevelopmentTool.convert_OEA_to_Immobiliare.text"));
        this.convertOpenEstateTransferMenu.setText(this.getResourceValue("DevelopmentTool.convertOpenEstateTransferMenu.text"));
        this.convert_OET_to_OI.setText(this.getResourceValue("DevelopmentTool.convert_OET_to_OI.text"));
        this.convert_OET_to_IX.setText(this.getResourceValue("DevelopmentTool.convert_OET_to_IX.text"));
        this.convert_OET_to_IS24XML.setText(this.getResourceValue("DevelopmentTool.convert_OET_to_IS24XML.text"));
        this.convert_OET_to_IS24CSV.setText(this.getResourceValue("DevelopmentTool.convert_OET_to_IS24CSV.text"));
        this.convert_OET_to_Trovit.setText(this.getResourceValue("DevelopmentTool.convert_OET_to_Trovit.text"));
        this.convert_OET_to_Immobiliare.setText(this.getResourceValue("DevelopmentTool.convert_OET_to_Immobiliare.text"));
        this.convertOpenImmoMenu.setText(this.getResourceValue("DevelopmentTool.convertOpenImmoMenu.text"));
        this.convert_OI_to_OEA.setText(this.getResourceValue("DevelopmentTool.convert_OI_to_OEA.text"));
        this.convert_OI_to_OET.setText(this.getResourceValue("DevelopmentTool.convert_OI_to_OET.text"));
        this.convertImmoXmlMenu.setText(this.getResourceValue("DevelopmentTool.convertImmoXmlMenu.text"));
        this.convert_IX_to_OEA.setText(this.getResourceValue("DevelopmentTool.convert_IX_to_OEA.text"));
        this.convert_IX_to_OET.setText(this.getResourceValue("DevelopmentTool.convert_IX_to_OET.text"));
        this.convertIS24XMLMenu.setText(this.getResourceValue("DevelopmentTool.convertIS24XMLMenu.text"));
        this.convert_IS24XML_to_OEA.setText(this.getResourceValue("DevelopmentTool.convert_IS24XML_to_OEA.text"));
        this.convert_IS24XML_to_OET.setText(this.getResourceValue("DevelopmentTool.convert_IS24XML_to_OET.text"));
        this.convertIS24CSVMenu.setText(this.getResourceValue("DevelopmentTool.convertIS24CSVMenu.text"));
        this.convert_IS24CSV_to_OEA.setText(this.getResourceValue("DevelopmentTool.convert_IS24CSV_to_OEA.text"));
        this.convert_IS24CSV_to_OET.setText(this.getResourceValue("DevelopmentTool.convert_IS24CSV_to_OET.text"));
        this.mainTabPanel.setTitleAt(0, this.getResourceValue("DevelopmentTool.aboutPanel.TabConstraints.tabTitle"));
        this.mainTabPanel.setTitleAt(1, this.getResourceValue("DevelopmentTool.estateTypePanel.TabConstraints.tabTitle"));
        this.mainTabPanel.setTitleAt(2, this.getResourceValue("DevelopmentTool.xmlExamplePanel.TabConstraints.tabTitle"));
        this.mainTabPanel.setTitleAt(3, this.getResourceValue("DevelopmentTool.xmlSerializationPanel.TabConstraints.tabTitle"));
        this.mainTabPanel.setTitleAt(4, this.getResourceValue("DevelopmentTool.translationsPanel.TabConstraints.tabTitle"));
        this.aboutTabPanel.setTitleAt(0, this.getResourceValue("DevelopmentTool.aboutDescriptionScroller.TabConstraints.tabTitle"));
        this.aboutTabPanel.setTitleAt(1, this.getResourceValue("DevelopmentTool.aboutAuthorsScroller.TabConstraints.tabTitle"));
        this.aboutTabPanel.setTitleAt(2, this.getResourceValue("DevelopmentTool.aboutLibrariesScroller.TabConstraints.tabTitle"));
        this.aboutTabPanel.setTitleAt(3, this.getResourceValue("DevelopmentTool.aboutTermsScroller.TabConstraints.tabTitle"));
        this.aboutTabPanel.setTitleAt(4, this.getResourceValue("DevelopmentTool.aboutPartnersScroller.TabConstraints.tabTitle"));
        this.estateExampleButton.setText(this.getResourceValue("DevelopmentTool.estateExampleButton.text"));
        this.examplesButton.setText(this.getResourceValue("DevelopmentTool.examplesButton.text"));
        this.serializationButton.setText(this.getResourceValue("DevelopmentTool.serializationButton.text"));
        this.converterButton.setText(this.getResourceValue("DevelopmentTool.converterButton.text"));
        this.xmlExampleScrollPane.setBorder(BorderFactory.createTitledBorder(this.getResourceValue("DevelopmentTool.xmlExampleScrollPane.border.title")));
        this.serializationInputScrollPane.setBorder(BorderFactory.createTitledBorder(this.getResourceValue("DevelopmentTool.serializationInputScrollPane.border.title")));
        this.serializationOutputScrollPane.setBorder(BorderFactory.createTitledBorder(this.getResourceValue("DevelopmentTool.serializationOutputScrollPane.border.title")));
        this.defaultTranslationButton.setText(this.getResourceValue("DevelopmentTool.defaultTranslationButton.text"));
        this.openTranslationButton.setText(this.getResourceValue("DevelopmentTool.openTranslationButton.text"));
        this.saveTranslationButton.setText(this.getResourceValue("DevelopmentTool.saveTranslationButton.text"));
        this.programMenu.setText(this.getResourceValue("DevelopmentTool.programMenu.text"));
        this.programLanguageMenu.setText(this.getResourceValue("DevelopmentTool.programLanguageMenu.text"));
        this.programQuitMenuItem.setText(this.getResourceValue("DevelopmentTool.programQuitMenuItem.text"));
        this.setTitle(this.getResourceValue("Application.title") + " v" + this.getResourceValue("Application.version"));
        this.translationsTable.getColumnModel().getColumn(0).setHeaderValue(this.getResourceValue("col.translations.id"));
        this.translationsTable.getColumnModel().getColumn(1).setHeaderValue(this.getResourceValue("col.translations.text"));
        this.aboutTitleLabel.setText("<html><h2>" + this.getTitle() + "</h2>" + this.getResourceValue("Application.info") + "</html>");
        this.aboutAuthorsEditor.setText(this.buildAuthorsPage());
        this.aboutAuthorsEditor.setCaretPosition(0);
        this.aboutDescriptionEditor.setText(this.buildDescriptionPage());
        this.aboutDescriptionEditor.setCaretPosition(0);
        this.aboutLibrariesEditor.setText(this.buildLibrariesPage());
        this.aboutLibrariesEditor.setCaretPosition(0);
        this.aboutTermsEditor.setText(this.buildLicensePage());
        this.aboutTermsEditor.setCaretPosition(0);
        this.aboutPartnersEditor.setText(this.buildPartnersPage());
        this.aboutPartnersEditor.setCaretPosition(0);
    }

    private void loadEstateType(OpenEstateType openEstateType) {
        this.selectedEstateType = openEstateType;
        this.estateAttribsTabPanel.removeAll();
        String string = this.getResourceValue("label.estateActionForType").replace("%s", OpenEstateUtils.translateEstate(openEstateType.getName(), estateLocale));
        this.estateActionBoxModel.removeAllElements();
        this.estateActionBoxModel.addElement("[ " + string + " ]");
        for (String string2 : openEstateType.getActions()) {
            this.estateActionBoxModel.addElement(new JEstateActionItem(string2));
        }
        this.estateActionBox.setSelectedIndex(0);
        this.estateActionBox.setEnabled(true);
        ArrayList arrayList = new ArrayList();
        for (OpenEstateAttrib object : openEstateType.getAttribs()) {
            if (!openEstateType.isAttribGeneral(object.getGroup(), object.getName())) continue;
            arrayList.add(object);
        }
        this.estateAttribsTabPanel.addTab(this.getResourceValue("label.generalAttributes"), this.buildEstateAttribsPanel(arrayList.toArray(new OpenEstateAttrib[arrayList.size()]), openEstateType, null));
        for (String string2 : openEstateType.getActions()) {
            this.estateAttribsTabPanel.addTab(this.getResourceValue("label.attributesForAction").replace("%s", OpenEstateUtils.translateAction(string2, estateLocale)), this.buildEstateAttribsPanel(openEstateType.getAttribsByAction(string2), openEstateType, string2));
        }
    }

    private void loadExampleAgency() {
        try {
            StringWriter stringWriter = new StringWriter();
            OpenEstateUtils.serializeToXML(ExampleFactory.createAgency(), stringWriter, true);
            this.xmlExampleTextArea.setText(stringWriter.toString());
            this.xmlExampleTextArea.setCaretPosition(0);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load example agency!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            this.xmlExampleTextArea.setText(OpenEstateUtils.writeException(exception));
            this.xmlExampleTextArea.setCaretPosition(0);
        }
    }

    private void loadExampleAgent() {
        try {
            StringWriter stringWriter = new StringWriter();
            OpenEstateUtils.serializeToXML(ExampleFactory.createAgent(), stringWriter, true);
            this.xmlExampleTextArea.setText(stringWriter.toString());
            this.xmlExampleTextArea.setCaretPosition(0);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load example agent!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            this.xmlExampleTextArea.setText(OpenEstateUtils.writeException(exception));
            this.xmlExampleTextArea.setCaretPosition(0);
        }
    }

    private void loadExampleEstate() throws OpenEstateException {
        this.loadExampleEstate(ExampleFactory.createEstate());
    }

    private void loadExampleEstate(EstateImpl estateImpl) {
        try {
            StringWriter stringWriter = new StringWriter();
            OpenEstateUtils.serializeToXML(estateImpl, stringWriter, true);
            this.xmlExampleTextArea.setText(stringWriter.toString());
            this.xmlExampleTextArea.setCaretPosition(0);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load example estate!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            this.xmlExampleTextArea.setText(OpenEstateUtils.writeException(exception));
            this.xmlExampleTextArea.setCaretPosition(0);
        }
    }

    private void loadExampleTransfer(boolean bl) {
        try {
            StringWriter stringWriter = new StringWriter();
            OpenEstateUtils.serializeToXML(ExampleFactory.createTransfer(bl), stringWriter, true);
            this.xmlExampleTextArea.setText(stringWriter.toString());
            this.xmlExampleTextArea.setCaretPosition(0);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load example transfer!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            this.xmlExampleTextArea.setText(OpenEstateUtils.writeException(exception));
            this.xmlExampleTextArea.setCaretPosition(0);
        }
    }

    private void loadTranslation(ResourceBundle resourceBundle) {
        while (this.translationsTableModel.getRowCount() > 0) {
            this.translationsTableModel.removeRow(0);
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        Enumeration<String> enumeration = OpenEstateUtils.getResources(resourceBundle.getLocale()).getKeys();
        while (enumeration.hasMoreElements()) {
            treeSet.add(enumeration.nextElement().toString());
        }
        for (String string : treeSet) {
            this.translationsTableModel.addRow(new String[]{string, resourceBundle.getString(string)});
        }
    }

    private void loadTranslationFromFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.getResourceValue("label.selectTranslation"));
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        try {
            File file = jFileChooser.getSelectedFile();
            ResourceBundle resourceBundle = UTF8ResourceBundle.createUtf8PropertyResourceBundle(new PropertyResourceBundle(new FileInputStream(file)));
            this.loadTranslation(resourceBundle);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant load translation!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            JOptionPane.showMessageDialog(this, "<html><b>" + this.getResourceValue("error.cantLoadTranslation") + "</b>" + "<br>" + exception.getLocalizedMessage() + "</html>");
        }
    }

    private void loadTranslationFromResource() {
        Locale locale = (Locale)this.defaultTranslationLanguageBox.getSelectedItem();
        this.loadTranslation(OpenEstateUtils.getResources(locale));
    }

    private void loadXMLSerialization(int n) {
        try {
            StringWriter stringWriter = new StringWriter();
            if (n == 0) {
                String string = this.serializationInputTextArea.getText().trim();
                if (string.length() > 0) {
                    SAXReader sAXReader = new SAXReader();
                    Document document = sAXReader.read((Reader)new StringReader(string));
                    String string2 = document.getRootElement().getName();
                    AbstractImplItem abstractImplItem = null;
                    if ("Estate".equals(string2)) {
                        abstractImplItem = new EstateImpl(document);
                    } else if ("Agent".equals(string2)) {
                        abstractImplItem = new AgentImpl(document);
                    } else if ("Agency".equals(string2)) {
                        abstractImplItem = new AgencyImpl(document);
                    } else if ("Transfer".equals(string2)) {
                        abstractImplItem = new TransferImpl(document);
                    } else {
                        throw new Exception("unknown root-node '" + abstractImplItem + "'");
                    }
                    OpenEstateUtils.serializeToXML(abstractImplItem, stringWriter, true);
                }
            } else if (n == 1) {
                String string = this.serializationInputTextArea.getText().trim();
                if (string.length() > 0) {
                    Openimmo openimmo = (Openimmo)OpenImmoUtils.unmarshallWithoutNamespace(new StringReader(string));
                    OpenImmoUtils.createMarshaller().marshal((Object)openimmo, (Writer)stringWriter);
                }
            } else if (n == 2) {
                String string = this.serializationInputTextArea.getText().trim();
                if (string.length() > 0) {
                    Immoxml immoxml = (Immoxml)ImmoXmlUtils.createUnmarshaller().unmarshal((Reader)new StringReader(string));
                    ImmoXmlUtils.createMarshaller().marshal((Object)immoxml, (Writer)stringWriter);
                }
            } else if (n == 3) {
                String string = this.serializationInputTextArea.getText().trim();
                if (string.length() > 0) {
                    Object object = IS24XmlUtils.createUnmarshaller().unmarshal((Reader)new StringReader(string));
                    IS24XmlUtils.createMarshaller().marshal(object, (Writer)stringWriter);
                }
            } else if (n == 4) {
                String string = this.serializationInputTextArea.getText().trim();
                if (string.length() > 0) {
                    TransferImpl transferImpl = new TransferImpl();
                    new IS24CSVReader().read(new StringReader(string), (SerializableXmlElement)transferImpl);
                    new IS24CSVWriter().write((Writer)stringWriter, transferImpl);
                }
            } else {
                throw new Exception("invalid serialization-type " + n + "!");
            }
            this.serializationOutputTextArea.setText(stringWriter.toString());
            this.serializationOutputTextArea.setCaretPosition(0);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not serialize xml");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            this.serializationOutputTextArea.setText(OpenEstateUtils.writeException(exception));
        }
    }

    private void openURL(URL uRL) {
        try {
            if (SystemUtils.IS_OS_MAC) {
                Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                Method method = clazz.getDeclaredMethod("openURL", String.class);
                method.invoke(null, uRL.toString());
            } else if (SystemUtils.IS_OS_WINDOWS) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + uRL.toString());
            } else {
                String[] stringArray = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String string = null;
                for (int i = 0; i < stringArray.length && string == null && (Runtime.getRuntime().exec(new String[]{"which", stringArray[i]}).waitFor() != 0 || (string = stringArray[i]) == null); ++i) {
                }
                if (string == null) {
                    throw new Exception("no browser found!");
                }
                Runtime.getRuntime().exec(new String[]{string, uRL.toString()});
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not open url!");
            LOGGER.error((Object)("> " + uRL.toString()));
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    private String replaceVars(String string, String string2) {
        try {
            return string.replaceAll(Pattern.quote("%TITLE%"), string2 != null ? string2 : "").replaceAll(Pattern.quote("%OpenEstate-Impl.jar%"), new File("OpenEstate-Impl.jar").getAbsolutePath()).replaceAll(Pattern.quote("%OpenEstate-Tool.jar%"), new File("OpenEstate-Tool.jar").getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            return "<html><h1>ERROR</h1>" + OpenEstateUtils.writeException(exception).replaceAll("\\n", "<br>") + "</html>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTranslation() {
        String string = JOptionPane.showInputDialog(this.getResourceValue("label.enterLanguageCode"));
        if (string == null) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.getResourceValue("label.saveTranslation"));
        jFileChooser.setSelectedFile(new File("openestate_" + string + ".properties"));
        int n = jFileChooser.showSaveDialog(this);
        if (n != 0) {
            return;
        }
        Writer writer = null;
        try {
            File file = jFileChooser.getSelectedFile();
            writer = new FileWriter(file);
            for (int i = 0; i < this.translationsTableModel.getRowCount(); ++i) {
                writer.write(this.translationsTableModel.getValueAt(i, 0).toString());
                writer.write("=");
                writer.write(this.translationsTableModel.getValueAt(i, 1).toString());
                writer.write(System.getProperty("line.separator"));
            }
            writer.flush();
            JOptionPane.showMessageDialog(this, this.getResourceValue("label.saveTranslationSuccess"));
        }
        catch (Exception exception) {
            LOGGER.error((Object)"cant save translation!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()));
            JOptionPane.showMessageDialog(this, this.getResourceValue("error.cantSaveTranslation"));
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {
                LOGGER.warn((Object)"Can't close writer!");
                LOGGER.warn((Object)("> " + iOException.getLocalizedMessage()), (Throwable)iOException);
            }
        }
    }

    private static synchronized void setEstateLocale(Locale locale) {
        estateLocale = locale;
    }

    private static synchronized void setResourceLocale(Locale locale) {
        if (resourceLocale != locale) {
            resourceLocale = locale;
            resourceLocaleBundle = null;
            try {
                resourceLocale = locale != null ? locale : DEFAULT_TRANSLATION;
                Locale.setDefault(resourceLocale);
                resourceLocaleBundle = resourceLocale != null ? ResourceBundle.getBundle(RESOURCE_PATH.substring(1) + "DevelopmentTool", resourceLocale) : ResourceBundle.getBundle(RESOURCE_PATH.substring(1) + "DevelopmentTool");
                if (resourceLocaleBundle == null) {
                    throw new Exception("resource-bundle not found!");
                }
            }
            catch (Exception exception) {
                LOGGER.error((Object)"could not load resources!");
                if (resourceLocale != null) {
                    LOGGER.error((Object)("> locale: " + resourceLocale.toString()));
                }
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                throw new RuntimeException(exception);
            }
        }
    }

    private void initComponents() {
        this.examplesPopupMenu = new JPopupMenu();
        this.example_Agency = new JMenuItem();
        this.example_Agent = new JMenuItem();
        this.example_Estate = new JMenuItem();
        this.example_TransferPart = new JMenuItem();
        this.example_TransferFull = new JMenuItem();
        this.serializationMenu = new JPopupMenu();
        this.serialize_OE = new JMenuItem();
        this.serialize_OI = new JMenuItem();
        this.serialize_IX = new JMenuItem();
        this.serialize_IS24XML = new JMenuItem();
        this.serialize_IS24CSV = new JMenuItem();
        this.converterMenu = new JPopupMenu();
        this.convertOpenEstateAgencyMenu = new JMenu();
        this.convert_OEA_to_OI = new JMenuItem();
        this.convert_OEA_to_IX = new JMenuItem();
        this.convert_OEA_to_IS24XML = new JMenuItem();
        this.convert_OEA_to_IS24CSV = new JMenuItem();
        this.convert_OEA_to_Trovit = new JMenuItem();
        this.convert_OEA_to_Immobiliare = new JMenuItem();
        this.convertOpenEstateTransferMenu = new JMenu();
        this.convert_OET_to_OI = new JMenuItem();
        this.convert_OET_to_IX = new JMenuItem();
        this.convert_OET_to_IS24XML = new JMenuItem();
        this.convert_OET_to_IS24CSV = new JMenuItem();
        this.convert_OET_to_Trovit = new JMenuItem();
        this.convert_OET_to_Immobiliare = new JMenuItem();
        this.convertOpenImmoMenu = new JMenu();
        this.convert_OI_to_OEA = new JMenuItem();
        this.convert_OI_to_OET = new JMenuItem();
        this.convertImmoXmlMenu = new JMenu();
        this.convert_IX_to_OEA = new JMenuItem();
        this.convert_IX_to_OET = new JMenuItem();
        this.convertIS24XMLMenu = new JMenu();
        this.convert_IS24XML_to_OEA = new JMenuItem();
        this.convert_IS24XML_to_OET = new JMenuItem();
        this.convertIS24CSVMenu = new JMenu();
        this.convert_IS24CSV_to_OEA = new JMenuItem();
        this.convert_IS24CSV_to_OET = new JMenuItem();
        this.mainTabPanel = new JTabbedPane();
        this.aboutPanel = new JPanel();
        this.aboutTitleLabel = new JLabel();
        this.aboutTabPanel = new JTabbedPane();
        this.aboutDescriptionScroller = new JScrollPane();
        this.aboutDescriptionEditor = new JEditorPane();
        this.aboutAuthorsScroller = new JScrollPane();
        this.aboutAuthorsEditor = new JEditorPane();
        this.aboutLibrariesScroller = new JScrollPane();
        this.aboutLibrariesEditor = new JEditorPane();
        this.aboutTermsScroller = new JScrollPane();
        this.aboutTermsEditor = new JEditorPane();
        this.aboutPartnersScroller = new JScrollPane();
        this.aboutPartnersEditor = new JEditorPane();
        this.estateTypePanel = new JPanel();
        this.estateLanguageBox = new OpenEstateLocaleComboBox(false);
        this.estateTypeScrollPane = new JScrollPane();
        this.estateTypeTree = new JTree();
        this.estateActionBox = new JComboBox();
        this.estateExampleButton = new JButton();
        this.estateAttribsTabPanel = new JTabbedPane();
        this.xmlExamplePanel = new JPanel();
        this.xmlExampleScrollPane = this.xmlExampleScrollPane;
        this.xmlExampleTextArea = this.xmlExampleTextArea;
        this.examplesButton = new JButton();
        this.xmlSerializationPanel = new JPanel();
        this.serializationButton = new JButton();
        this.converterButton = new JButton();
        this.xmlSerializationSplitter = new JSplitPane();
        this.serializationInputScrollPane = this.serializationInputScrollPane;
        this.serializationInputTextArea = this.serializationInputTextArea;
        this.serializationOutputScrollPane = this.serializationOutputScrollPane;
        this.serializationOutputTextArea = this.serializationOutputTextArea;
        this.translationsPanel = new JPanel();
        this.translationsScrollPane = new JScrollPane();
        this.translationsTable = new JTable();
        this.defaultTranslationLanguageBox = new OpenEstateLocaleComboBox(false);
        this.defaultTranslationButton = new JButton();
        this.openTranslationButton = new JButton();
        this.saveTranslationButton = new JButton();
        this.mainMenuBar = new JMenuBar();
        this.programMenu = new JMenu();
        this.programLanguageMenu = new JMenu();
        this.programQuitMenuItem = new JMenuItem();
        this.examplesPopupMenu.setName("examplesPopupMenu");
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com/openindex/openestate/impl/utils/resources/DevelopmentTool");
        this.example_Agency.setText(resourceBundle.getString("DevelopmentTool.example_Agency.text"));
        this.example_Agency.setName("example_Agency");
        this.examplesPopupMenu.add(this.example_Agency);
        this.example_Agent.setText(resourceBundle.getString("DevelopmentTool.example_Agent.text"));
        this.example_Agent.setName("example_Agent");
        this.examplesPopupMenu.add(this.example_Agent);
        this.example_Estate.setText(resourceBundle.getString("DevelopmentTool.example_Estate.text"));
        this.example_Estate.setName("example_Estate");
        this.examplesPopupMenu.add(this.example_Estate);
        this.example_TransferPart.setText(resourceBundle.getString("DevelopmentTool.example_TransferPart.text"));
        this.example_TransferPart.setName("example_TransferPart");
        this.examplesPopupMenu.add(this.example_TransferPart);
        this.example_TransferFull.setText(resourceBundle.getString("DevelopmentTool.example_TransferFull.text"));
        this.example_TransferFull.setName("example_TransferFull");
        this.examplesPopupMenu.add(this.example_TransferFull);
        this.serializationMenu.setName("serializationMenu");
        this.serialize_OE.setText(resourceBundle.getString("DevelopmentTool.serialize_OE.text"));
        this.serialize_OE.setName("serialize_OE");
        this.serializationMenu.add(this.serialize_OE);
        this.serialize_OI.setText(resourceBundle.getString("DevelopmentTool.serialize_OI.text"));
        this.serialize_OI.setName("serialize_OI");
        this.serializationMenu.add(this.serialize_OI);
        this.serialize_IX.setText(resourceBundle.getString("DevelopmentTool.serialize_IX.text"));
        this.serialize_IX.setName("serialize_IX");
        this.serializationMenu.add(this.serialize_IX);
        this.serialize_IS24XML.setText(resourceBundle.getString("DevelopmentTool.serialize_IS24XML.text"));
        this.serialize_IS24XML.setName("serialize_IS24XML");
        this.serializationMenu.add(this.serialize_IS24XML);
        this.serialize_IS24CSV.setText(resourceBundle.getString("DevelopmentTool.serialize_IS24CSV.text"));
        this.serialize_IS24CSV.setName("serialize_IS24CSV");
        this.serializationMenu.add(this.serialize_IS24CSV);
        this.converterMenu.setName("converterMenu");
        this.convertOpenEstateAgencyMenu.setText(resourceBundle.getString("DevelopmentTool.convertOpenEstateAgencyMenu.text"));
        this.convertOpenEstateAgencyMenu.setName("convertOpenEstateAgencyMenu");
        this.convert_OEA_to_OI.setText(resourceBundle.getString("DevelopmentTool.convert_OEA_to_OI.text"));
        this.convert_OEA_to_OI.setName("convert_OEA_to_OI");
        this.convertOpenEstateAgencyMenu.add(this.convert_OEA_to_OI);
        this.convert_OEA_to_IX.setText(resourceBundle.getString("DevelopmentTool.convert_OEA_to_IX.text"));
        this.convert_OEA_to_IX.setName("convert_OEA_to_IX");
        this.convertOpenEstateAgencyMenu.add(this.convert_OEA_to_IX);
        this.convert_OEA_to_IS24XML.setText(resourceBundle.getString("DevelopmentTool.convert_OEA_to_IS24XML.text"));
        this.convert_OEA_to_IS24XML.setName("convert_OEA_to_IS24XML");
        this.convertOpenEstateAgencyMenu.add(this.convert_OEA_to_IS24XML);
        this.convert_OEA_to_IS24CSV.setText(resourceBundle.getString("DevelopmentTool.convert_OEA_to_IS24CSV.text"));
        this.convert_OEA_to_IS24CSV.setName("convert_OEA_to_IS24CSV");
        this.convertOpenEstateAgencyMenu.add(this.convert_OEA_to_IS24CSV);
        this.convert_OEA_to_Trovit.setText(resourceBundle.getString("DevelopmentTool.convert_OEA_to_Trovit.text"));
        this.convert_OEA_to_Trovit.setName("convert_OEA_to_Trovit");
        this.convertOpenEstateAgencyMenu.add(this.convert_OEA_to_Trovit);
        this.convert_OEA_to_Immobiliare.setText(resourceBundle.getString("DevelopmentTool.convert_OEA_to_Immobiliare.text"));
        this.convert_OEA_to_Immobiliare.setName("convert_OEA_to_Immobiliare");
        this.convertOpenEstateAgencyMenu.add(this.convert_OEA_to_Immobiliare);
        this.converterMenu.add(this.convertOpenEstateAgencyMenu);
        this.convertOpenEstateTransferMenu.setText(resourceBundle.getString("DevelopmentTool.convertOpenEstateTransferMenu.text"));
        this.convertOpenEstateTransferMenu.setName("convertOpenEstateTransferMenu");
        this.convert_OET_to_OI.setText(resourceBundle.getString("DevelopmentTool.convert_OET_to_OI.text"));
        this.convert_OET_to_OI.setName("convert_OET_to_OI");
        this.convertOpenEstateTransferMenu.add(this.convert_OET_to_OI);
        this.convert_OET_to_IX.setText(resourceBundle.getString("DevelopmentTool.convert_OET_to_IX.text"));
        this.convert_OET_to_IX.setName("convert_OET_to_IX");
        this.convertOpenEstateTransferMenu.add(this.convert_OET_to_IX);
        this.convert_OET_to_IS24XML.setText(resourceBundle.getString("DevelopmentTool.convert_OET_to_IS24XML.text"));
        this.convert_OET_to_IS24XML.setName("convert_OET_to_IS24XML");
        this.convertOpenEstateTransferMenu.add(this.convert_OET_to_IS24XML);
        this.convert_OET_to_IS24CSV.setText(resourceBundle.getString("DevelopmentTool.convert_OET_to_IS24CSV.text"));
        this.convert_OET_to_IS24CSV.setName("convert_OET_to_IS24CSV");
        this.convertOpenEstateTransferMenu.add(this.convert_OET_to_IS24CSV);
        this.convert_OET_to_Trovit.setText(resourceBundle.getString("DevelopmentTool.convert_OET_to_Trovit.text"));
        this.convert_OET_to_Trovit.setName("convert_OET_to_Trovit");
        this.convertOpenEstateTransferMenu.add(this.convert_OET_to_Trovit);
        this.convert_OET_to_Immobiliare.setText(resourceBundle.getString("DevelopmentTool.convert_OET_to_Immobiliare.text"));
        this.convert_OET_to_Immobiliare.setName("convert_OET_to_Immobiliare");
        this.convertOpenEstateTransferMenu.add(this.convert_OET_to_Immobiliare);
        this.converterMenu.add(this.convertOpenEstateTransferMenu);
        this.convertOpenImmoMenu.setText(resourceBundle.getString("DevelopmentTool.convertOpenImmoMenu.text"));
        this.convertOpenImmoMenu.setName("convertOpenImmoMenu");
        this.convert_OI_to_OEA.setText(resourceBundle.getString("DevelopmentTool.convert_OI_to_OEA.text"));
        this.convert_OI_to_OEA.setName("convert_OI_to_OEA");
        this.convertOpenImmoMenu.add(this.convert_OI_to_OEA);
        this.convert_OI_to_OET.setText(resourceBundle.getString("DevelopmentTool.convert_OI_to_OET.text"));
        this.convert_OI_to_OET.setName("convert_OI_to_OET");
        this.convertOpenImmoMenu.add(this.convert_OI_to_OET);
        this.converterMenu.add(this.convertOpenImmoMenu);
        this.convertImmoXmlMenu.setText(resourceBundle.getString("DevelopmentTool.convertImmoXmlMenu.text"));
        this.convertImmoXmlMenu.setName("convertImmoXmlMenu");
        this.convert_IX_to_OEA.setText(resourceBundle.getString("DevelopmentTool.convert_IX_to_OEA.text"));
        this.convert_IX_to_OEA.setName("convert_IX_to_OEA");
        this.convertImmoXmlMenu.add(this.convert_IX_to_OEA);
        this.convert_IX_to_OET.setText(resourceBundle.getString("DevelopmentTool.convert_IX_to_OET.text"));
        this.convert_IX_to_OET.setName("convert_IX_to_OET");
        this.convertImmoXmlMenu.add(this.convert_IX_to_OET);
        this.converterMenu.add(this.convertImmoXmlMenu);
        this.convertIS24XMLMenu.setText(resourceBundle.getString("DevelopmentTool.convertIS24XMLMenu.text"));
        this.convertIS24XMLMenu.setName("convertIS24XMLMenu");
        this.convert_IS24XML_to_OEA.setText(resourceBundle.getString("DevelopmentTool.convert_IS24XML_to_OEA.text"));
        this.convert_IS24XML_to_OEA.setName("convert_IS24XML_to_OEA");
        this.convertIS24XMLMenu.add(this.convert_IS24XML_to_OEA);
        this.convert_IS24XML_to_OET.setText(resourceBundle.getString("DevelopmentTool.convert_IS24XML_to_OET.text"));
        this.convert_IS24XML_to_OET.setName("convert_IS24XML_to_OET");
        this.convertIS24XMLMenu.add(this.convert_IS24XML_to_OET);
        this.converterMenu.add(this.convertIS24XMLMenu);
        this.convertIS24CSVMenu.setText(resourceBundle.getString("DevelopmentTool.convertIS24CSVMenu.text"));
        this.convertIS24CSVMenu.setName("convertIS24CSVMenu");
        this.convert_IS24CSV_to_OEA.setText(resourceBundle.getString("DevelopmentTool.convert_IS24CSV_to_OEA.text"));
        this.convert_IS24CSV_to_OEA.setName("convert_IS24CSV_to_OEA");
        this.convertIS24CSVMenu.add(this.convert_IS24CSV_to_OEA);
        this.convert_IS24CSV_to_OET.setText(resourceBundle.getString("DevelopmentTool.convert_IS24CSV_to_OET.text"));
        this.convert_IS24CSV_to_OET.setName("convert_IS24CSV_to_OET");
        this.convertIS24CSVMenu.add(this.convert_IS24CSV_to_OET);
        this.converterMenu.add(this.convertIS24CSVMenu);
        this.setDefaultCloseOperation(3);
        this.setName("Form");
        this.mainTabPanel.setName("mainTabPanel");
        this.aboutPanel.setName("aboutPanel");
        this.aboutTitleLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/openindex/openestate/impl/resources/logos/openestate.png")));
        this.aboutTitleLabel.setText("aboutTitleLabel");
        this.aboutTitleLabel.setIconTextGap(15);
        this.aboutTitleLabel.setName("aboutTitleLabel");
        this.aboutTitleLabel.setVerticalTextPosition(1);
        this.aboutTabPanel.setName("aboutTabPanel");
        this.aboutDescriptionScroller.setName("aboutDescriptionScroller");
        this.aboutDescriptionEditor.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.aboutDescriptionEditor.setContentType("text/html");
        this.aboutDescriptionEditor.setEditable(false);
        this.aboutDescriptionEditor.setName("aboutDescriptionEditor");
        this.aboutDescriptionScroller.setViewportView(this.aboutDescriptionEditor);
        this.aboutTabPanel.addTab(resourceBundle.getString("DevelopmentTool.aboutDescriptionScroller.TabConstraints.tabTitle"), this.aboutDescriptionScroller);
        this.aboutAuthorsScroller.setName("aboutAuthorsScroller");
        this.aboutAuthorsEditor.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.aboutAuthorsEditor.setContentType("text/html");
        this.aboutAuthorsEditor.setEditable(false);
        this.aboutAuthorsEditor.setName("aboutAuthorsEditor");
        this.aboutAuthorsScroller.setViewportView(this.aboutAuthorsEditor);
        this.aboutTabPanel.addTab(resourceBundle.getString("DevelopmentTool.aboutAuthorsScroller.TabConstraints.tabTitle"), this.aboutAuthorsScroller);
        this.aboutLibrariesScroller.setName("aboutLibrariesScroller");
        this.aboutLibrariesEditor.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.aboutLibrariesEditor.setContentType("text/html");
        this.aboutLibrariesEditor.setEditable(false);
        this.aboutLibrariesEditor.setName("aboutLibrariesEditor");
        this.aboutLibrariesScroller.setViewportView(this.aboutLibrariesEditor);
        this.aboutTabPanel.addTab(resourceBundle.getString("DevelopmentTool.aboutLibrariesScroller.TabConstraints.tabTitle"), this.aboutLibrariesScroller);
        this.aboutTermsScroller.setName("aboutTermsScroller");
        this.aboutTermsEditor.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.aboutTermsEditor.setContentType("text/html");
        this.aboutTermsEditor.setEditable(false);
        this.aboutTermsEditor.setName("aboutTermsEditor");
        this.aboutTermsScroller.setViewportView(this.aboutTermsEditor);
        this.aboutTabPanel.addTab(resourceBundle.getString("DevelopmentTool.aboutTermsScroller.TabConstraints.tabTitle"), this.aboutTermsScroller);
        this.aboutPartnersScroller.setName("aboutPartnersScroller");
        this.aboutPartnersEditor.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.aboutPartnersEditor.setContentType("text/html");
        this.aboutPartnersEditor.setEditable(false);
        this.aboutPartnersEditor.setName("aboutPartnersEditor");
        this.aboutPartnersScroller.setViewportView(this.aboutPartnersEditor);
        this.aboutTabPanel.addTab(resourceBundle.getString("DevelopmentTool.aboutPartnersScroller.TabConstraints.tabTitle"), this.aboutPartnersScroller);
        GroupLayout groupLayout = new GroupLayout(this.aboutPanel);
        this.aboutPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.aboutTabPanel, GroupLayout.Alignment.LEADING, -1, 712, Short.MAX_VALUE).addComponent(this.aboutTitleLabel, GroupLayout.Alignment.LEADING, -1, 712, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.aboutTitleLabel).addGap(18, 18, 18).addComponent(this.aboutTabPanel, -1, 432, Short.MAX_VALUE).addContainerGap()));
        this.mainTabPanel.addTab(resourceBundle.getString("DevelopmentTool.aboutPanel.TabConstraints.tabTitle"), this.aboutPanel);
        this.estateTypePanel.setName("estateTypePanel");
        this.estateLanguageBox.setName("estateLanguageBox");
        this.estateTypeScrollPane.setName("estateTypeScrollPane");
        this.estateTypeTree.setName("estateTypeTree");
        this.estateTypeScrollPane.setViewportView(this.estateTypeTree);
        this.estateActionBox.setEnabled(false);
        this.estateActionBox.setName("estateActionBox");
        this.estateExampleButton.setText(resourceBundle.getString("DevelopmentTool.estateExampleButton.text"));
        this.estateExampleButton.setEnabled(false);
        this.estateExampleButton.setName("estateExampleButton");
        this.estateAttribsTabPanel.setName("estateAttribsTabPanel");
        GroupLayout groupLayout2 = new GroupLayout(this.estateTypePanel);
        this.estateTypePanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.estateLanguageBox, 0, -1, Short.MAX_VALUE).addComponent(this.estateTypeScrollPane, -1, 230, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.estateActionBox, 0, 415, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateExampleButton)).addComponent(this.estateAttribsTabPanel, -1, 476, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.estateActionBox, -2, -1, -2).addComponent(this.estateExampleButton).addComponent(this.estateLanguageBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.estateTypeScrollPane, GroupLayout.Alignment.TRAILING, -1, 478, Short.MAX_VALUE).addComponent(this.estateAttribsTabPanel, GroupLayout.Alignment.TRAILING, -1, 478, Short.MAX_VALUE)).addContainerGap()));
        this.mainTabPanel.addTab(resourceBundle.getString("DevelopmentTool.estateTypePanel.TabConstraints.tabTitle"), this.estateTypePanel);
        this.xmlExamplePanel.setName("xmlExamplePanel");
        this.xmlExampleScrollPane.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("DevelopmentTool.xmlExampleScrollPane.border.title")));
        this.xmlExampleScrollPane.setName("xmlExampleScrollPane");
        this.xmlExampleTextArea.setColumns(20);
        this.xmlExampleTextArea.setEditable(false);
        this.xmlExampleTextArea.setRows(5);
        this.xmlExampleTextArea.setName("xmlExampleTextArea");
        this.xmlExampleScrollPane.setViewportView((Component)this.xmlExampleTextArea);
        this.examplesButton.setText(resourceBundle.getString("DevelopmentTool.examplesButton.text"));
        this.examplesButton.setName("examplesButton");
        GroupLayout groupLayout3 = new GroupLayout(this.xmlExamplePanel);
        this.xmlExamplePanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.xmlExampleScrollPane, -1, 712, Short.MAX_VALUE).addComponent(this.examplesButton)).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.xmlExampleScrollPane, -1, 478, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.examplesButton).addContainerGap()));
        this.mainTabPanel.addTab(resourceBundle.getString("DevelopmentTool.xmlExamplePanel.TabConstraints.tabTitle"), this.xmlExamplePanel);
        this.xmlSerializationPanel.setName("xmlSerializationPanel");
        this.serializationButton.setText(resourceBundle.getString("DevelopmentTool.serializationButton.text"));
        this.serializationButton.setName("serializationButton");
        this.converterButton.setText(resourceBundle.getString("DevelopmentTool.converterButton.text"));
        this.converterButton.setName("converterButton");
        this.xmlSerializationSplitter.setBorder(null);
        this.xmlSerializationSplitter.setDividerLocation(200);
        this.xmlSerializationSplitter.setOrientation(0);
        this.xmlSerializationSplitter.setName("xmlSerializationSplitter");
        this.serializationInputScrollPane.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("DevelopmentTool.serializationInputScrollPane.border.title")));
        this.serializationInputScrollPane.setName("serializationInputScrollPane");
        this.serializationInputTextArea.setColumns(20);
        this.serializationInputTextArea.setRows(5);
        this.serializationInputTextArea.setName("serializationInputTextArea");
        this.serializationInputScrollPane.setViewportView((Component)this.serializationInputTextArea);
        this.xmlSerializationSplitter.setLeftComponent(this.serializationInputScrollPane);
        this.serializationOutputScrollPane.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("DevelopmentTool.serializationOutputScrollPane.border.title")));
        this.serializationOutputScrollPane.setName("serializationOutputScrollPane");
        this.serializationOutputTextArea.setColumns(20);
        this.serializationOutputTextArea.setEditable(false);
        this.serializationOutputTextArea.setRows(5);
        this.serializationOutputTextArea.setName("serializationOutputTextArea");
        this.serializationOutputScrollPane.setViewportView((Component)this.serializationOutputTextArea);
        this.xmlSerializationSplitter.setRightComponent(this.serializationOutputScrollPane);
        GroupLayout groupLayout4 = new GroupLayout(this.xmlSerializationPanel);
        this.xmlSerializationPanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.xmlSerializationSplitter, GroupLayout.Alignment.LEADING, -1, 712, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout4.createSequentialGroup().addComponent(this.serializationButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.converterButton))).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.xmlSerializationSplitter, -1, 466, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serializationButton).addComponent(this.converterButton)).addContainerGap()));
        this.mainTabPanel.addTab(resourceBundle.getString("DevelopmentTool.xmlSerializationPanel.TabConstraints.tabTitle"), this.xmlSerializationPanel);
        this.translationsPanel.setName("translationsPanel");
        this.translationsScrollPane.setName("translationsScrollPane");
        this.translationsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"id", "text"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.translationsTable.setName("translationsTable");
        this.translationsScrollPane.setViewportView(this.translationsTable);
        this.defaultTranslationLanguageBox.setName("defaultTranslationLanguageBox");
        this.defaultTranslationButton.setText(resourceBundle.getString("DevelopmentTool.defaultTranslationButton.text"));
        this.defaultTranslationButton.setName("defaultTranslationButton");
        this.openTranslationButton.setText(resourceBundle.getString("DevelopmentTool.openTranslationButton.text"));
        this.openTranslationButton.setName("openTranslationButton");
        this.saveTranslationButton.setText(resourceBundle.getString("DevelopmentTool.saveTranslationButton.text"));
        this.saveTranslationButton.setName("saveTranslationButton");
        GroupLayout groupLayout5 = new GroupLayout(this.translationsPanel);
        this.translationsPanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.translationsScrollPane, GroupLayout.Alignment.LEADING, -1, 712, Short.MAX_VALUE).addGroup(groupLayout5.createSequentialGroup().addComponent(this.defaultTranslationLanguageBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.defaultTranslationButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 503, Short.MAX_VALUE).addComponent(this.openTranslationButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveTranslationButton))).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.translationsScrollPane, -1, 478, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveTranslationButton).addComponent(this.openTranslationButton).addComponent(this.defaultTranslationLanguageBox, -2, -1, -2).addComponent(this.defaultTranslationButton)).addContainerGap()));
        this.mainTabPanel.addTab(resourceBundle.getString("DevelopmentTool.translationsPanel.TabConstraints.tabTitle"), this.translationsPanel);
        this.mainMenuBar.setName("mainMenuBar");
        this.programMenu.setText(resourceBundle.getString("DevelopmentTool.programMenu.text"));
        this.programMenu.setName("programMenu");
        this.programLanguageMenu.setText(resourceBundle.getString("DevelopmentTool.programLanguageMenu.text"));
        this.programLanguageMenu.setName("programLanguageMenu");
        this.programMenu.add(this.programLanguageMenu);
        this.programQuitMenuItem.setText(resourceBundle.getString("DevelopmentTool.programQuitMenuItem.text"));
        this.programQuitMenuItem.setName("programQuitMenuItem");
        this.programMenu.add(this.programQuitMenuItem);
        this.mainMenuBar.add(this.programMenu);
        this.setJMenuBar(this.mainMenuBar);
        GroupLayout groupLayout6 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout6.createSequentialGroup().addContainerGap().addComponent(this.mainTabPanel, -1, 741, Short.MAX_VALUE).addContainerGap()));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addComponent(this.mainTabPanel, -1, 560, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    public static void main(String[] stringArray) {
        File file = null;
        try {
            file = OpenEstateUtils.initLogging();
            if (file == null) {
                LOGGER.fatal((Object)"Failed to init logging-environment!");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            System.setErr(new PrintStream(new FileOutputStream(file.getPath() + File.separator + "openestate_error.log")));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not setup error-logging!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        resourceLocales = new HashMap<String, Locale>();
        for (Locale locale : Locale.getAvailableLocales()) {
            URL uRL;
            if (resourceLocales.containsKey(locale.getLanguage()) || (uRL = DevelopmentTool.class.getResource("/com/openindex/openestate/impl/utils/resources/DevelopmentTool_" + locale.getLanguage() + ".properties")) == null) continue;
            resourceLocales.put(locale.getLanguage(), locale);
        }
        try {
            String string = System.getProperty("os.name");
            if (string != null && string.toLowerCase().startsWith("windows")) {
                UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
            } else {
                UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not setup look&feel!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new DevelopmentTool().setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(-1);
                }
            }
        });
    }

    static {
        ATTRIBS_COLUMN_NAMES.put(0, "col.attribs.group");
        ATTRIBS_COLUMN_NAMES.put(1, "col.attribs.attrib");
        ATTRIBS_COLUMN_NAMES.put(2, "col.attribs.translation");
        ATTRIBS_COLUMN_NAMES.put(3, "col.attribs.type");
        ATTRIBS_COLUMN_NAMES.put(4, "col.attribs.options");
        ATTRIBS_COLUMN_NAMES.put(5, "col.attribs.required");
        ATTRIBS_COLUMN_NAMES.put(6, "col.attribs.multiple");
        ATTRIBS_COLUMN_CLASSES = new HashMap<Integer, Class>();
        ATTRIBS_COLUMN_CLASSES.put(0, String.class);
        ATTRIBS_COLUMN_CLASSES.put(1, String.class);
        ATTRIBS_COLUMN_CLASSES.put(2, String.class);
        ATTRIBS_COLUMN_CLASSES.put(3, String.class);
        ATTRIBS_COLUMN_CLASSES.put(4, String.class);
        ATTRIBS_COLUMN_CLASSES.put(5, Boolean.class);
        ATTRIBS_COLUMN_CLASSES.put(6, Boolean.class);
    }

    private class AttribTableModel
    extends DefaultTableModel {
        public AttribTableModel() {
            this.setColumnCount(ATTRIBS_COLUMN_NAMES.size());
        }

        public void addAttrib(OpenEstateAttrib openEstateAttrib, OpenEstateType openEstateType, String string) {
            this.addRow(this.buildRow(openEstateAttrib, openEstateType, string));
        }

        private Object[] buildRow(OpenEstateAttrib openEstateAttrib, OpenEstateType openEstateType, String string) {
            TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
            treeMap.put(0, openEstateAttrib.getGroup());
            treeMap.put(1, openEstateAttrib.getName());
            treeMap.put(2, OpenEstateUtils.translateAttribute(openEstateAttrib.getGroup(), openEstateAttrib.getName(), estateLocale));
            treeMap.put(5, openEstateType.isAttribRequired(openEstateAttrib, string));
            treeMap.put(6, openEstateAttrib.isComplex());
            if (openEstateAttrib instanceof ComplexEnumAttrib) {
                ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)openEstateAttrib;
                StringBuilder stringBuilder = new StringBuilder();
                for (String string2 : complexEnumAttrib.getOptions()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(string2);
                }
                treeMap.put(3, "xsd:enumeration");
                treeMap.put(4, stringBuilder.toString());
            } else if (openEstateAttrib instanceof SimpleBooleanAttrib) {
                treeMap.put(3, "xsd:boolean");
                treeMap.put(4, "");
            } else if (openEstateAttrib instanceof SimpleEnumAttrib) {
                SimpleEnumAttrib simpleEnumAttrib = (SimpleEnumAttrib)openEstateAttrib;
                StringBuilder stringBuilder = new StringBuilder();
                for (String string3 : simpleEnumAttrib.getOptions()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(string3);
                }
                treeMap.put(3, "xsd:enumeration");
                treeMap.put(4, stringBuilder.toString());
            } else if (openEstateAttrib instanceof SimpleNumericAttrib) {
                SimpleNumericAttrib simpleNumericAttrib = (SimpleNumericAttrib)openEstateAttrib;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("precision=" + simpleNumericAttrib.getPrecision());
                if (simpleNumericAttrib.getMaximum() != null) {
                    arrayList.add("max=" + simpleNumericAttrib.getMaximum());
                }
                if (simpleNumericAttrib.getMinimum() != null) {
                    arrayList.add("min=" + simpleNumericAttrib.getMinimum());
                }
                if (simpleNumericAttrib.getUnit() != null) {
                    arrayList.add("unit=" + simpleNumericAttrib.getUnit());
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (String string4 : arrayList) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(string4);
                }
                treeMap.put(3, "xsd:decimal");
                treeMap.put(4, stringBuilder.toString());
            } else if (openEstateAttrib instanceof SimpleStringAttrib) {
                SimpleStringAttrib simpleStringAttrib = (SimpleStringAttrib)openEstateAttrib;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("maxLength=" + simpleStringAttrib.getMaxLength());
                StringBuilder stringBuilder = new StringBuilder();
                for (String string5 : arrayList) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(string5);
                }
                treeMap.put(3, "xsd:string");
                treeMap.put(4, stringBuilder.toString());
            } else if (openEstateAttrib instanceof SimpleTimeAttrib) {
                SimpleTimeAttrib simpleTimeAttrib = (SimpleTimeAttrib)openEstateAttrib;
                if (simpleTimeAttrib.isDate()) {
                    treeMap.put(3, "xsd:date");
                } else if (simpleTimeAttrib.isTime()) {
                    treeMap.put(3, "xsd:time");
                } else if (simpleTimeAttrib.isDateTime()) {
                    treeMap.put(3, "xsd:dateTime");
                } else {
                    treeMap.put(3, "???");
                }
                treeMap.put(4, "");
            } else {
                treeMap.put(3, "???");
                treeMap.put(4, "???");
            }
            return treeMap.values().toArray(new Object[treeMap.size()]);
        }

        public void clear() {
            while (this.getRowCount() > 0) {
                this.removeRow(0);
            }
        }

        public Class getColumnClass(int n) {
            return ATTRIBS_COLUMN_CLASSES.containsKey(n) ? (Class)ATTRIBS_COLUMN_CLASSES.get(n) : null;
        }

        @Override
        public String getColumnName(int n) {
            return ATTRIBS_COLUMN_NAMES.containsKey(n) ? DevelopmentTool.this.getResourceValue((String)ATTRIBS_COLUMN_NAMES.get(n)) : null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

