/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.GeoCountryImpl;
import com.openindex.openestate.impl.GeoImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.apache.log4j.Logger;

public class IS24GeoBuilder {
    private static final Logger LOGGER = Logger.getLogger(IS24GeoBuilder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoImpl build(File file) throws IOException, NoSuchAlgorithmException {
        GeoImpl geoImpl = new GeoImpl();
        geoImpl.setBuildTime(new Date());
        geoImpl.setName("is24");
        geoImpl.setProvider("ImmobilienScout24.de");
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("cp1252")));
            String string = ((LineNumberReader)bufferedReader).readLine();
            GeoCountryImpl geoCountryImpl = null;
            while (string != null) {
                Object object;
                if (((LineNumberReader)bufferedReader).getLineNumber() <= 1) {
                    string = ((LineNumberReader)bufferedReader).readLine();
                    continue;
                }
                if (string.trim().length() <= 0) {
                    string = ((LineNumberReader)bufferedReader).readLine();
                    continue;
                }
                String[] stringArray = string.split("\\|");
                if (stringArray.length != 3) {
                    string = ((LineNumberReader)bufferedReader).readLine();
                    continue;
                }
                String string2 = stringArray[0].trim();
                String string3 = stringArray[1].trim();
                String string4 = stringArray[2].trim();
                if (geoCountryImpl == null || !geoCountryImpl.getProviderId().equals(string3)) {
                    if (geoCountryImpl != null && geoCountryImpl.getIsoCode() != null) {
                        geoImpl.getCountries().add(geoCountryImpl);
                    }
                    geoCountryImpl = new GeoCountryImpl();
                    geoCountryImpl.setProviderId(string3);
                    geoCountryImpl.setName(string2);
                    object = OpenEstateUtils.convertToIso2Country(string3);
                    if (object != null) {
                        geoCountryImpl.setIsoCode((String)object);
                        geoCountryImpl.setId(OpenEstateUtils.hash(geoCountryImpl.getIsoCode()));
                    } else {
                        LOGGER.warn((Object)("WARN: Can't convert '" + string3 + "' (" + string2 + ") to an ISO-2 country code!"));
                        geoCountryImpl.setId(null);
                        geoCountryImpl.setIsoCode(null);
                    }
                }
                if (geoCountryImpl.getIsoCode() != null) {
                    object = new GeoAreaImpl();
                    ((GeoAreaImpl)object).setId(OpenEstateUtils.hash(geoCountryImpl.getId() + "-" + string4));
                    ((GeoAreaImpl)object).setName(string4);
                    ((GeoAreaImpl)object).setLevel("REGION");
                    geoCountryImpl.getAreas().add((GeoAreaImpl)object);
                }
                string = ((LineNumberReader)bufferedReader).readLine();
            }
            if (geoCountryImpl != null && geoCountryImpl.getIsoCode() != null) {
                geoImpl.getCountries().add(geoCountryImpl);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return geoImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length <= 1) {
            System.out.println("no input- and output-file was provided!");
            System.exit(1);
        }
        if (!(file = new File(stringArray[0])).isFile()) {
            System.out.println("input-file is invalid!");
            System.exit(1);
        }
        IS24GeoBuilder iS24GeoBuilder = new IS24GeoBuilder();
        GeoImpl geoImpl = null;
        try {
            geoImpl = iS24GeoBuilder.build(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        File file2 = new File(stringArray[1]);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file2);
            OpenEstateUtils.serializeToXML(geoImpl, fileWriter, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

