/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;

public class JEstateTypeTreeNode
extends DefaultMutableTreeNode {
    private Locale nodeLocale = OpenEstateUtils.DEFAULT_LOCALE;

    public JEstateTypeTreeNode() throws OpenEstateException {
        this(OpenEstateUtils.DEFAULT_LOCALE);
    }

    public JEstateTypeTreeNode(Locale locale) throws OpenEstateException {
        super(null);
        this.nodeLocale = locale;
        for (OpenEstateType openEstateType : OpenEstateUtils.getEstateTypesOnRoot()) {
            this.add(new JEstateTypeTreeNode(openEstateType, this.nodeLocale));
        }
    }

    public JEstateTypeTreeNode(OpenEstateType openEstateType, Locale locale) throws OpenEstateException {
        super(openEstateType);
        if (openEstateType.hasChildren()) {
            for (String string : openEstateType.getChildren()) {
                this.add(new JEstateTypeTreeNode(OpenEstateType.newInstance(string), locale));
            }
        }
    }

    public OpenEstateType getEstateType() {
        return (OpenEstateType)(this.getUserObject() != null ? this.getUserObject() : null);
    }

    public void setLocale(Locale locale) {
        this.nodeLocale = locale;
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((JEstateTypeTreeNode)this.getChildAt(i)).setLocale(locale);
        }
    }

    @Override
    public String toString() {
        return this.getEstateType() != null ? OpenEstateUtils.translateEstate(this.getEstateType().getName(), this.nodeLocale) : "root";
    }
}

