/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.openindex.openestate.impl.OpenEstateUtils;
import java.awt.Component;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class OpenEstateLocaleComboBox
extends JComboBox {
    public OpenEstateLocaleComboBox(boolean bl) {
        this(bl, OpenEstateUtils.getAvailableLocales());
    }

    public OpenEstateLocaleComboBox(boolean bl, Locale[] localeArray) {
        this.setRenderer(new Renderer());
        this.setModel(new Model());
        if (bl) {
            ((Model)this.getModel()).addLocale(null);
        }
        for (Locale locale : localeArray) {
            ((Model)this.getModel()).addLocale(locale);
        }
    }

    public Locale getLocaleAt(int n) {
        return ((Model)this.getModel()).getLocaleAt(n);
    }

    public Locale getSelectedLocale() {
        return this.getLocaleAt(this.getSelectedIndex());
    }

    public void setSelectedLocale(Locale locale) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (this.getItemAt(i) == null || !locale.toString().equals(this.getItemAt(i).toString())) continue;
            this.setSelectedIndex(i);
            return;
        }
        this.setSelectedIndex(this.getItemAt(0) == null ? 0 : -1);
    }

    public static class Renderer
    extends JLabel
    implements ListCellRenderer {
        public Renderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Locale) {
                Locale locale = (Locale)object;
                this.setIcon(OpenEstateUtils.getFlagIcon(locale));
                this.setText(locale.getDisplayLanguage(locale) + " / " + locale.getDisplayLanguage());
            } else {
                this.setIcon(null);
                this.setText(" ");
            }
            return this;
        }
    }

    public static class Model
    extends DefaultComboBoxModel {
        public void addLocale(Locale locale) {
            this.addElement(locale);
        }

        public Locale getLocaleAt(int n) {
            return (Locale)this.getElementAt(n);
        }
    }
}

