/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.openindex.openestate.impl.OpenEstateActions;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroups;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleNumericAttrib;
import com.openindex.openestate.impl.attribs.SimpleStringAttrib;
import com.openindex.openestate.impl.attribs.SimpleTimeAttrib;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;

public class SqlGenerator {
    private static final Logger LOGGER = Logger.getLogger(SqlGenerator.class);
    public static final int MAJOR_VERSION = 0;
    public static final int MINOR_VERSION = 2;
    public static final int BUILD_VERSION = 1;
    private final Map<String, Long> actionIds = new HashMap<String, Long>();
    private final Map<String, Long> attribIds = new HashMap<String, Long>();
    private final Map<String, Long> groupIds = new HashMap<String, Long>();
    private long translationId = 0L;
    private long typeAttribId = 0L;
    private long typeId = 0L;

    /*
     * WARNING - void declaration
     */
    public synchronized void generate(Writer writer) throws IOException, OpenEstateException {
        Object object;
        Object object2;
        String string = "-- -----------------------------------------------------" + SystemUtils.LINE_SEPARATOR;
        writer.write(string);
        writer.write("-- OpenEstate-SQL, Daten zur Spezifikation" + SystemUtils.LINE_SEPARATOR);
        writer.write("-- Version : 0.2.1" + SystemUtils.LINE_SEPARATOR);
        writer.write("-- Stand   : " + new Date().toString() + SystemUtils.LINE_SEPARATOR);
        writer.write("-- Lizenz  : LGPL" + SystemUtils.LINE_SEPARATOR);
        writer.write("-- http://www.openestate.org" + SystemUtils.LINE_SEPARATOR);
        writer.write(string + SystemUtils.LINE_SEPARATOR);
        this.translationId = 0L;
        this.typeAttribId = 0L;
        this.typeId = 0L;
        this.actionIds.clear();
        this.attribIds.clear();
        this.groupIds.clear();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        writer.write(SystemUtils.LINE_SEPARATOR);
        writer.write(string);
        writer.write("-- Vermarktungsarten" + SystemUtils.LINE_SEPARATOR);
        writer.write(string + SystemUtils.LINE_SEPARATOR);
        for (String object4 : OpenEstateActions.getValues()) {
            this.actionIds.put(object4, ++l);
            writer.write("INSERT INTO openestate_actions (id, name) VALUES (" + l + ", " + "'" + StringEscapeUtils.escapeSql((String)object4) + "'" + ");" + SystemUtils.LINE_SEPARATOR);
            object2 = new StringBuilder();
            for (Locale locale : OpenEstateUtils.getAvailableLocales()) {
                if (((StringBuilder)object2).length() > 0) {
                    ((StringBuilder)object2).append(",");
                }
                ((StringBuilder)object2).append(SystemUtils.LINE_SEPARATOR).append("  (");
                ((StringBuilder)object2).append(++this.translationId).append(", ");
                ((StringBuilder)object2).append(l).append(", ");
                ((StringBuilder)object2).append("'").append(locale.getLanguage()).append("', ");
                ((StringBuilder)object2).append("'").append(StringEscapeUtils.escapeSql((String)OpenEstateUtils.translateAction(object4, locale)));
                ((StringBuilder)object2).append("')");
            }
            if (((StringBuilder)object2).length() <= 0) continue;
            writer.write("INSERT INTO openestate_translations (id, action_id, language, translation) VALUES " + ((StringBuilder)object2).toString() + ";" + SystemUtils.LINE_SEPARATOR);
        }
        writer.write(SystemUtils.LINE_SEPARATOR);
        writer.write(SystemUtils.LINE_SEPARATOR);
        writer.write(string);
        writer.write("-- Attribut-Gruppen" + SystemUtils.LINE_SEPARATOR);
        writer.write(string + SystemUtils.LINE_SEPARATOR);
        l5 = 0L;
        for (String string2 : OpenEstateAttribGroups.getValues()) {
            this.groupIds.put(string2, ++l4);
            writer.write("INSERT INTO openestate_groups (id, name, ordering) VALUES (" + l4 + ", " + "'" + StringEscapeUtils.escapeSql((String)string2) + "', " + ++l5 + ");" + SystemUtils.LINE_SEPARATOR);
            object2 = new StringBuilder();
            for (Locale locale : OpenEstateUtils.getAvailableLocales()) {
                if (((StringBuilder)object2).length() > 0) {
                    ((StringBuilder)object2).append(",");
                }
                ((StringBuilder)object2).append(SystemUtils.LINE_SEPARATOR).append("  (");
                ((StringBuilder)object2).append(++this.translationId).append(", ");
                ((StringBuilder)object2).append(l4).append(", ");
                ((StringBuilder)object2).append("'").append(locale.getLanguage()).append("', ");
                ((StringBuilder)object2).append("'").append(StringEscapeUtils.escapeSql((String)OpenEstateUtils.translateAttribute(string2, locale)));
                ((StringBuilder)object2).append("')");
            }
            if (((StringBuilder)object2).length() <= 0) continue;
            writer.write("INSERT INTO openestate_translations (id, group_id, language, translation) VALUES " + ((StringBuilder)object2).toString() + ";" + SystemUtils.LINE_SEPARATOR);
        }
        writer.write(SystemUtils.LINE_SEPARATOR);
        OpenEstateUtils.getEstateTypesOnRoot();
        writer.write(SystemUtils.LINE_SEPARATOR);
        writer.write(string);
        writer.write("-- Attribute" + SystemUtils.LINE_SEPARATOR);
        writer.write(string + SystemUtils.LINE_SEPARATOR);
        l5 = 0L;
        for (String string3 : OpenEstateUtils.getAvailableAttributes()) {
            int n;
            void var21_68;
            void var18_36;
            Object object3;
            object2 = OpenEstateUtils.getAvailableAttribute(string3);
            if (!this.groupIds.containsKey(((OpenEstateAttrib)object2).getGroup())) {
                LOGGER.warn((Object)("unknown attribute-group: " + ((OpenEstateAttrib)object2).getGroup()));
                continue;
            }
            Object var18_27 = null;
            String[] stringArray = null;
            String string4 = "";
            String string5 = "";
            if (object2 instanceof SimpleBooleanAttrib) {
                String string6 = "boolean";
            } else if (object2 instanceof ComplexEnumAttrib) {
                String string7 = "select_multiple";
                object3 = (ComplexEnumAttrib)object2;
                stringArray = ((ComplexEnumAttrib)object3).getOptions();
            } else if (object2 instanceof SimpleEnumAttrib) {
                String string8 = "select_simple";
                object3 = (SimpleEnumAttrib)object2;
                stringArray = ((SimpleEnumAttrib)object3).getOptions();
            } else if (object2 instanceof SimpleNumericAttrib) {
                void var21_59;
                void var21_55;
                object3 = (SimpleNumericAttrib)object2;
                String string9 = "AREA".equals(((SimpleNumericAttrib)object3).getUnit()) ? "currency" : "numeric";
                string4 = string4 + ", numeric_unit, numeric_maximum, numeric_minimum";
                String string10 = string5 + ", ";
                if ("AREA".equals(((SimpleNumericAttrib)object3).getUnit())) {
                    String string11 = string10 + "'m\u00b2'";
                } else if ("LENGTH".equals(((SimpleNumericAttrib)object3).getUnit())) {
                    String string12 = string10 + "'m'";
                } else {
                    String string13 = string10 + "NULL";
                }
                String string14 = (String)var21_55 + ", ";
                if (((SimpleNumericAttrib)object3).getMaximum() != null) {
                    String string15 = string14 + ((SimpleNumericAttrib)object3).getMaximum().toString();
                } else {
                    String string16 = string14 + "NULL";
                }
                String string17 = (String)var21_59 + ", ";
                if (((SimpleNumericAttrib)object3).getMinimum() != null) {
                    String string18 = string17 + ((SimpleNumericAttrib)object3).getMinimum().toString();
                } else {
                    String string19 = string17 + "NULL";
                }
            } else if (object2 instanceof SimpleStringAttrib) {
                object3 = (SimpleStringAttrib)object2;
                String string20 = ((SimpleStringAttrib)object3).getMaxLength() > 255 ? "text" : "string";
                string4 = string4 + ", string_maxlength";
                String string21 = string5 + ", ";
                if (((SimpleStringAttrib)object3).getMaxLength() > 0) {
                    String string22 = string21 + ((SimpleStringAttrib)object3).getMaxLength();
                } else {
                    String string23 = string21 + "255";
                }
            } else if (object2 instanceof SimpleTimeAttrib) {
                object3 = (SimpleTimeAttrib)object2;
                if (0 == ((SimpleTimeAttrib)object3).getType()) {
                    String string24 = "date";
                } else if (1 == ((SimpleTimeAttrib)object3).getType()) {
                    String string25 = "time";
                } else if (2 == ((SimpleTimeAttrib)object3).getType()) {
                    String string26 = "datetime";
                }
            }
            if (var18_36 == null) {
                LOGGER.warn((Object)("unknown attribute-type for: " + ((OpenEstateAttrib)object2).getKey()));
                LOGGER.warn((Object)("> " + object2.getClass().getName()));
                continue;
            }
            this.attribIds.put(string3, ++l2);
            writer.write("INSERT INTO openestate_attribs (id, group_id, name, type, ordering, translatable" + string4 + ") VALUES (" + l2 + ", " + this.groupIds.get(((OpenEstateAttrib)object2).getGroup()) + ", " + "'" + StringEscapeUtils.escapeSql((String)((OpenEstateAttrib)object2).getName()) + "', " + "'" + StringEscapeUtils.escapeSql((String)var18_36) + "', " + ++l5 + ", " + Boolean.valueOf(((OpenEstateAttrib)object2).isManuallyTranslated()).toString() + (String)var21_68 + ");" + SystemUtils.LINE_SEPARATOR);
            object3 = new StringBuilder();
            Object[] objectArray = OpenEstateUtils.getAvailableLocales();
            int n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                if (((StringBuilder)object3).length() > 0) {
                    ((StringBuilder)object3).append(",");
                }
                ((StringBuilder)object3).append(SystemUtils.LINE_SEPARATOR).append("  (");
                ((StringBuilder)object3).append(++this.translationId).append(", ");
                ((StringBuilder)object3).append(l2).append(", ");
                ((StringBuilder)object3).append("'").append(((Locale)object).getLanguage()).append("', ");
                ((StringBuilder)object3).append("'").append(StringEscapeUtils.escapeSql((String)OpenEstateUtils.translateAttribute(((OpenEstateAttrib)object2).getGroup(), ((OpenEstateAttrib)object2).getName(), (Locale)object)));
                ((StringBuilder)object3).append("')");
            }
            if (((StringBuilder)object3).length() > 0) {
                writer.write("INSERT INTO openestate_translations (id, attrib_id, language, translation) VALUES " + ((StringBuilder)object3).toString() + ";" + SystemUtils.LINE_SEPARATOR);
            }
            if (stringArray == null || stringArray.length == 0) continue;
            objectArray = stringArray;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                writer.write("INSERT INTO openestate_attrib_options (id, attrib_id, name) VALUES (" + ++l3 + ", " + l2 + ", " + "'" + StringEscapeUtils.escapeSql((String)object) + "'" + ");" + SystemUtils.LINE_SEPARATOR);
                object3 = new StringBuilder();
                for (Locale locale : OpenEstateUtils.getAvailableLocales()) {
                    if (((StringBuilder)object3).length() > 0) {
                        ((StringBuilder)object3).append(",");
                    }
                    ((StringBuilder)object3).append(SystemUtils.LINE_SEPARATOR).append("  (");
                    ((StringBuilder)object3).append(++this.translationId).append(", ");
                    ((StringBuilder)object3).append(l3).append(", ");
                    ((StringBuilder)object3).append("'").append(locale.getLanguage()).append("', ");
                    ((StringBuilder)object3).append("'").append(StringEscapeUtils.escapeSql((String)OpenEstateUtils.translateAttribute(((OpenEstateAttrib)object2).getGroup(), ((OpenEstateAttrib)object2).getName(), (String)object, locale)));
                    ((StringBuilder)object3).append("')");
                }
                if (((StringBuilder)object3).length() <= 0) continue;
                writer.write("INSERT INTO openestate_translations (id, attrib_option_id, language, translation) VALUES " + ((StringBuilder)object3).toString() + ";" + SystemUtils.LINE_SEPARATOR);
            }
        }
        writer.write(SystemUtils.LINE_SEPARATOR);
        writer.write(SystemUtils.LINE_SEPARATOR);
        writer.write(string);
        writer.write("-- Immobilienarten" + SystemUtils.LINE_SEPARATOR);
        writer.write(string + SystemUtils.LINE_SEPARATOR);
        l5 = 0L;
        for (OpenEstateType openEstateType : OpenEstateUtils.getEstateTypesOnRoot()) {
            this.generate(writer, openEstateType, 0L, ++l5);
        }
        writer.write(SystemUtils.LINE_SEPARATOR);
        writer.write(string);
        writer.write("-- L\u00e4ndercodes und Landesnamen" + SystemUtils.LINE_SEPARATOR);
        writer.write(string + SystemUtils.LINE_SEPARATOR);
        long l6 = 0L;
        Locale.setDefault(Locale.ENGLISH);
        for (String string27 : Locale.getISOCountries()) {
            ++l6;
            Locale locale = new Locale("", string27.toUpperCase());
            String string28 = locale.getDisplayCountry(Locale.getDefault());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(SystemUtils.LINE_SEPARATOR);
            stringBuilder.append("  (");
            stringBuilder.append(l6).append(", ");
            stringBuilder.append("'").append(string27).append("', ");
            stringBuilder.append("null, ");
            stringBuilder.append("'").append(StringEscapeUtils.escapeSql((String)locale.getDisplayCountry(locale))).append("' ");
            stringBuilder.append(")");
            for (String string29 : Locale.getISOLanguages()) {
                object = new Locale(string29.toLowerCase());
                Locale[] localeArray = locale.getDisplayCountry((Locale)object);
                if (localeArray == null || !string29.equals(Locale.getDefault().getLanguage()) && string28.equals(localeArray)) continue;
                ++l6;
                stringBuilder.append(",");
                stringBuilder.append(SystemUtils.LINE_SEPARATOR);
                stringBuilder.append("  (");
                stringBuilder.append(l6).append(", ");
                stringBuilder.append("'").append(string27).append("', ");
                stringBuilder.append("'").append(string29).append("', ");
                stringBuilder.append("'").append(StringEscapeUtils.escapeSql((String)locale.getDisplayCountry((Locale)object))).append("' ");
                stringBuilder.append(")");
            }
            if (stringBuilder.length() <= 0) continue;
            writer.write("INSERT INTO openestate_countries (id, country, language, translation) VALUES " + stringBuilder.toString() + ";" + SystemUtils.LINE_SEPARATOR);
        }
    }

    private void generate(Writer writer, OpenEstateType openEstateType, long l, long l2) throws IOException, OpenEstateException {
        long l3;
        ++this.typeId;
        writer.write("INSERT INTO openestate_types (id, parent_id, name, ordering) VALUES (" + this.typeId + ", " + (l <= 0L ? "null" : Long.valueOf(l)) + ", " + "'" + StringEscapeUtils.escapeSql((String)openEstateType.getName()) + "', " + l2 + ");" + SystemUtils.LINE_SEPARATOR);
        StringBuilder stringBuilder = new StringBuilder();
        for (Locale locale : OpenEstateUtils.getAvailableLocales()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(SystemUtils.LINE_SEPARATOR).append("  (");
            stringBuilder.append(++this.translationId).append(", ");
            stringBuilder.append(this.typeId).append(", ");
            stringBuilder.append("'").append(locale.getLanguage()).append("', ");
            stringBuilder.append("'").append(StringEscapeUtils.escapeSql((String)OpenEstateUtils.translateEstate(openEstateType.getName(), locale)));
            stringBuilder.append("')");
        }
        if (stringBuilder.length() > 0) {
            writer.write("INSERT INTO openestate_translations (id, type_id, language, translation) VALUES " + stringBuilder.toString() + ";" + SystemUtils.LINE_SEPARATOR);
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String object : openEstateType.getActions()) {
            if (!this.actionIds.containsKey(object)) {
                LOGGER.warn((Object)("unknown action: " + object));
                continue;
            }
            l3 = this.actionIds.get(object);
            writer.write("INSERT INTO openestate_type_actions (type_id, action_id) VALUES (" + this.typeId + ", " + l3 + ");" + SystemUtils.LINE_SEPARATOR);
            for (OpenEstateAttrib openEstateAttrib : openEstateType.getAttribs(object)) {
                if (openEstateType.isAttribGeneral(openEstateAttrib)) continue;
                if (!this.attribIds.containsKey(openEstateAttrib.getKey())) {
                    LOGGER.warn((Object)("unknown attribute: " + openEstateAttrib.getKey()));
                    continue;
                }
                long l4 = this.attribIds.get(openEstateAttrib.getKey());
                if (stringBuilder2.length() > 0) {
                    stringBuilder2.append(",");
                }
                stringBuilder2.append(SystemUtils.LINE_SEPARATOR).append("  (");
                stringBuilder2.append(++this.typeAttribId).append(", ");
                stringBuilder2.append(this.typeId).append(", ");
                stringBuilder2.append(l4).append(", ");
                stringBuilder2.append(l3).append(", ");
                stringBuilder2.append(openEstateType.isAttribRequired(openEstateAttrib, object));
                stringBuilder2.append(")");
            }
        }
        for (OpenEstateAttrib openEstateAttrib : openEstateType.getAttribs(null)) {
            if (!this.attribIds.containsKey(openEstateAttrib.getKey())) {
                LOGGER.warn((Object)("unknown attribute: " + openEstateAttrib.getKey()));
                continue;
            }
            l3 = this.attribIds.get(openEstateAttrib.getKey());
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(",");
            }
            stringBuilder2.append(SystemUtils.LINE_SEPARATOR).append("  (");
            stringBuilder2.append(++this.typeAttribId).append(", ");
            stringBuilder2.append(this.typeId).append(", ");
            stringBuilder2.append(l3).append(", ");
            stringBuilder2.append("null, ");
            stringBuilder2.append(openEstateType.isAttribRequired(openEstateAttrib, null));
            stringBuilder2.append(")");
        }
        if (stringBuilder2.length() > 0) {
            writer.write("INSERT INTO openestate_type_attribs (id, type_id, attrib_id, action_id, required) VALUES " + stringBuilder2.toString() + ";" + SystemUtils.LINE_SEPARATOR);
        }
        long l5 = this.typeId;
        long l6 = 0L;
        for (String string : openEstateType.getChildren()) {
            OpenEstateType openEstateType2 = OpenEstateType.newInstance(string);
            this.generate(writer, openEstateType2, l5, ++l6);
        }
    }
}

