/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class UTF8ResourceBundle {
    private static final Map<ClassLoader, Map<String, Map<Locale, ResourceBundle>>> bundleByClassLoaderByBaseNameByLocale = new HashMap<ClassLoader, Map<String, Map<Locale, ResourceBundle>>>();

    public static ResourceBundle getBundle(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        return UTF8ResourceBundle.createUtf8PropertyResourceBundle(resourceBundle);
    }

    public static ResourceBundle getBundle(String string, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
        return UTF8ResourceBundle.createUtf8PropertyResourceBundle(resourceBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) {
        Map<String, Map<Locale, ResourceBundle>> map;
        Map<Locale, ResourceBundle> map2 = null;
        ResourceBundle resourceBundle = null;
        Map<Object, Object> map3 = bundleByClassLoaderByBaseNameByLocale;
        synchronized (map3) {
            map = bundleByClassLoaderByBaseNameByLocale.get(classLoader);
            if (map == null) {
                map = new HashMap<String, Map<Locale, ResourceBundle>>();
                bundleByClassLoaderByBaseNameByLocale.put(classLoader, map);
            }
        }
        map3 = map;
        synchronized (map3) {
            map2 = map.get(string);
            if (map2 == null) {
                map2 = new HashMap<Locale, ResourceBundle>();
                map.put(string, map2);
            }
        }
        map3 = map2;
        synchronized (map3) {
            resourceBundle = map2.get(locale);
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(string, locale);
                resourceBundle = UTF8ResourceBundle.createUtf8PropertyResourceBundle(resourceBundle);
                map2.put(locale, resourceBundle);
            }
        }
        return resourceBundle;
    }

    public static ResourceBundle createUtf8PropertyResourceBundle(ResourceBundle resourceBundle) {
        if (!(resourceBundle instanceof PropertyResourceBundle)) {
            throw new RuntimeException("only UTF-8 property files are supported");
        }
        return new PropertyResourceBundleUtf8((PropertyResourceBundle)resourceBundle);
    }

    public static class PropertyResourceBundleUtf8
    extends ResourceBundle {
        private final Map<String, String> valueByKey = new HashMap<String, String>();

        public PropertyResourceBundleUtf8(PropertyResourceBundle propertyResourceBundle) {
            this.loadEntries(propertyResourceBundle, this.valueByKey);
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(this.valueByKey.keySet());
        }

        private void loadEntries(PropertyResourceBundle propertyResourceBundle, Map<String, String> map) {
            Enumeration<String> enumeration = propertyResourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2 = enumeration.nextElement();
                String string3 = propertyResourceBundle.getString(string2);
                try {
                    string = new String(string3.getBytes("ISO-8859-1"), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException("could not load UTF-8 property resource bundle [" + propertyResourceBundle + "]", unsupportedEncodingException);
                }
                if (map.put(string2, string) == null) continue;
                throw new RuntimeException("duplicate key [" + string2 + "] in UTF-8 property resource bundle [" + propertyResourceBundle + "]");
            }
        }

        @Override
        protected Object handleGetObject(String string) {
            return this.valueByKey.get(string);
        }
    }
}

