/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.GeoCountryImpl;
import com.openindex.openestate.impl.GeoImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Locale;

public class WisITGeoBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoImpl build(File file) throws IOException, NoSuchAlgorithmException {
        GeoImpl geoImpl = new GeoImpl();
        geoImpl.setBuildTime(new Date());
        geoImpl.setName("wis_it");
        geoImpl.setProvider("wohnen-in-suedtirol.it");
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("cp1252")));
            String string = ((LineNumberReader)bufferedReader).readLine();
            GeoCountryImpl geoCountryImpl = new GeoCountryImpl();
            geoCountryImpl.setIsoCode(Locale.ITALY.getCountry());
            geoCountryImpl.setId(OpenEstateUtils.hash(geoCountryImpl.getIsoCode()));
            geoCountryImpl.setName(Locale.ITALY.getDisplayCountry(Locale.ITALY));
            while (string != null) {
                String string2 = string.trim();
                if (string2.length() <= 0) {
                    string = ((LineNumberReader)bufferedReader).readLine();
                    continue;
                }
                GeoAreaImpl geoAreaImpl = new GeoAreaImpl();
                geoAreaImpl.setId(OpenEstateUtils.hash(geoCountryImpl.getId() + "-" + string2));
                geoAreaImpl.setName(string2);
                geoAreaImpl.setLevel("REGION");
                geoCountryImpl.getAreas().add(geoAreaImpl);
                string = ((LineNumberReader)bufferedReader).readLine();
            }
            if (geoCountryImpl != null && geoCountryImpl.getIsoCode() != null) {
                geoImpl.getCountries().add(geoCountryImpl);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return geoImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length <= 1) {
            System.out.println("no input- and output-file was provided!");
            System.exit(1);
        }
        if (!(file = new File(stringArray[0])).isFile()) {
            System.out.println("input-file is invalid!");
            System.exit(1);
        }
        WisITGeoBuilder wisITGeoBuilder = new WisITGeoBuilder();
        GeoImpl geoImpl = null;
        try {
            geoImpl = wisITGeoBuilder.build(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        File file2 = new File(stringArray[1]);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file2);
            OpenEstateUtils.serializeToXML(geoImpl, fileWriter, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

