/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateConverter;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.PersonAdressImpl;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.SimpleAdressImpl;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.xml.IS24XmlUtils;
import com.openindex.openestate.impl.xml.is24.AdresseBaseTyp;
import com.openindex.openestate.impl.xml.is24.AktionsTyp;
import com.openindex.openestate.impl.xml.is24.Anlageobjekt;
import com.openindex.openestate.impl.xml.is24.AnlageobjekteKategorieTyp;
import com.openindex.openestate.impl.xml.is24.ApiSuchfelderTyp;
import com.openindex.openestate.impl.xml.is24.AusstattungsqualitaetsTyp;
import com.openindex.openestate.impl.xml.is24.BauphaseTyp;
import com.openindex.openestate.impl.xml.is24.BebaubarNachTyp;
import com.openindex.openestate.impl.xml.is24.BefeuerungsArtTyp;
import com.openindex.openestate.impl.xml.is24.BodenbelagTyp;
import com.openindex.openestate.impl.xml.is24.BodenbelagWohnenTyp;
import com.openindex.openestate.impl.xml.is24.BueroPraxis;
import com.openindex.openestate.impl.xml.is24.BueroPraxisKategorienTyp;
import com.openindex.openestate.impl.xml.is24.DatenVerkabelungsTyp;
import com.openindex.openestate.impl.xml.is24.Einzelhandel;
import com.openindex.openestate.impl.xml.is24.EinzelhandelKategorienTyp;
import com.openindex.openestate.impl.xml.is24.EnergieausweisTyp;
import com.openindex.openestate.impl.xml.is24.EnergieausweistypTyp;
import com.openindex.openestate.impl.xml.is24.ErschliessungszustandTyp;
import com.openindex.openestate.impl.xml.is24.GarageKauf;
import com.openindex.openestate.impl.xml.is24.GarageMiete;
import com.openindex.openestate.impl.xml.is24.GaragenKategorieTyp;
import com.openindex.openestate.impl.xml.is24.GastroKategorieTyp;
import com.openindex.openestate.impl.xml.is24.Gastronomie;
import com.openindex.openestate.impl.xml.is24.GenehmigungTyp;
import com.openindex.openestate.impl.xml.is24.GeschlechtTyp;
import com.openindex.openestate.impl.xml.is24.GrundstueckGewerbe;
import com.openindex.openestate.impl.xml.is24.GrundstueckGewerbeEmpfohleneNutzung;
import com.openindex.openestate.impl.xml.is24.GrundstueckGewerbeKategorienTyp;
import com.openindex.openestate.impl.xml.is24.GrundstueckWohnenEmpfohleneNutzung;
import com.openindex.openestate.impl.xml.is24.GrundstueckWohnenKauf;
import com.openindex.openestate.impl.xml.is24.GrundstueckWohnenMiete;
import com.openindex.openestate.impl.xml.is24.HalleProduktion;
import com.openindex.openestate.impl.xml.is24.HalleProduktionKategorieTyp;
import com.openindex.openestate.impl.xml.is24.HausKategorienTyp;
import com.openindex.openestate.impl.xml.is24.HausKauf;
import com.openindex.openestate.impl.xml.is24.HausMiete;
import com.openindex.openestate.impl.xml.is24.HebeanlageTyp;
import com.openindex.openestate.impl.xml.is24.HeizungsartTyp;
import com.openindex.openestate.impl.xml.is24.ISOLaenderCodeTyp;
import com.openindex.openestate.impl.xml.is24.ImmobilieBaseTyp;
import com.openindex.openestate.impl.xml.is24.ImmobilienTransferTyp;
import com.openindex.openestate.impl.xml.is24.JaNeinVereinbarungTyp;
import com.openindex.openestate.impl.xml.is24.LageartTyp;
import com.openindex.openestate.impl.xml.is24.MMAnhangArtenTyp;
import com.openindex.openestate.impl.xml.is24.MieteEinheitTyp;
import com.openindex.openestate.impl.xml.is24.MobilarTyp;
import com.openindex.openestate.impl.xml.is24.MultimediaAnhangTyp;
import com.openindex.openestate.impl.xml.is24.ObjektZustandTyp;
import com.openindex.openestate.impl.xml.is24.RauchenTyp;
import com.openindex.openestate.impl.xml.is24.SonstigeGewerbe;
import com.openindex.openestate.impl.xml.is24.SonstigeGewerbeKategorieTyp;
import com.openindex.openestate.impl.xml.is24.StellplatzKategorieTyp;
import com.openindex.openestate.impl.xml.is24.TVAnschlussTyp;
import com.openindex.openestate.impl.xml.is24.VermarktungGewerbeTyp;
import com.openindex.openestate.impl.xml.is24.VermarktungGewerbeTyp2;
import com.openindex.openestate.impl.xml.is24.VermarktungGrundstueckGewerbeTyp;
import com.openindex.openestate.impl.xml.is24.VermarktungGrundstueckWohnenKaufTyp;
import com.openindex.openestate.impl.xml.is24.VermarktungGrundstueckWohnenMieteTyp;
import com.openindex.openestate.impl.xml.is24.WAZ;
import com.openindex.openestate.impl.xml.is24.WGZimmer;
import com.openindex.openestate.impl.xml.is24.WGZimmerGeschlechtTyp;
import com.openindex.openestate.impl.xml.is24.WazKategorienTyp;
import com.openindex.openestate.impl.xml.is24.WazObjektZustandTyp;
import com.openindex.openestate.impl.xml.is24.WazZeiteinheitenTyp;
import com.openindex.openestate.impl.xml.is24.WohnungKategorienTyp;
import com.openindex.openestate.impl.xml.is24.WohnungKauf;
import com.openindex.openestate.impl.xml.is24.WohnungMiete;
import com.openindex.openestate.impl.xml.is24.ZulieferungTyp;
import com.openindex.openestate.impl.xml.is24.Zwangsversteigerung;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IS24XmlReader
extends OpenEstateConverter {
    private static final Logger LOGGER = Logger.getLogger(IS24XmlReader.class);
    public static final int CONVERT_TO_AGENCY = 0;
    public static final int CONVERT_TO_TRANSFER = 1;

    public IS24XmlReader() {
    }

    public IS24XmlReader(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    protected AgentImpl convertAnbieter(ImmobilienTransferTyp.Anbieter anbieter) {
        AgentImpl agentImpl = this.createEmptyAgent();
        agentImpl.getCustomValues().putCustomValue("is24.agent.id", anbieter.getScoutKundenID(), 5);
        return agentImpl;
    }

    protected EstateImpl convertImmobilie(ImmobilieBaseTyp immobilieBaseTyp, Map<String, AgentContactImpl> map) throws OpenEstateException {
        Iterator<MultimediaAnhangTyp> iterator;
        EstateImpl estateImpl = this.createEmptyEstate();
        estateImpl.setTitle(immobilieBaseTyp.getUeberschrift(), this.getOpenEstateLanguage());
        estateImpl.setId(immobilieBaseTyp.getAnbieterObjektID());
        estateImpl.getAdress().setAdressPublished(immobilieBaseTyp.isAdressdruck());
        if (immobilieBaseTyp.getAdresse() != null) {
            iterator = immobilieBaseTyp.getAdresse();
            estateImpl.getAdress().setStreetNr(((AdresseBaseTyp)((Object)iterator)).getHausnummer());
            estateImpl.getAdress().setCity(((AdresseBaseTyp)((Object)iterator)).getOrt());
            estateImpl.getAdress().setPostalCode(((AdresseBaseTyp)((Object)iterator)).getPostleitzahl());
            estateImpl.getAdress().setStreet(((AdresseBaseTyp)((Object)iterator)).getStrasse());
            ISOLaenderCodeTyp object2 = ((AdresseBaseTyp)((Object)iterator)).getLaenderkennzeichen();
            if (object2 != null) {
                estateImpl.getAdress().setCountry(OpenEstateUtils.convertToIso2Country(object2.toString()));
            }
        }
        if (immobilieBaseTyp.getKontaktperson() != null) {
            iterator = new AgentContactImpl();
            ((PersonAdressImpl)((Object)iterator)).setPersonMail(immobilieBaseTyp.getKontaktperson().getEMail());
            ((SimpleAdressImpl)((Object)iterator)).setStreetNr(immobilieBaseTyp.getKontaktperson().getHausnummer());
            ((PersonAdressImpl)((Object)iterator)).setPersonMobilePhone(immobilieBaseTyp.getKontaktperson().getMobiltelefon());
            ((PersonAdressImpl)((Object)iterator)).setPersonLastName(immobilieBaseTyp.getKontaktperson().getNachname());
            ((SimpleAdressImpl)((Object)iterator)).setCity(immobilieBaseTyp.getKontaktperson().getOrt());
            ((SimpleAdressImpl)((Object)iterator)).setPostalCode(immobilieBaseTyp.getKontaktperson().getPostleitzahl());
            ((SimpleAdressImpl)((Object)iterator)).setStreet(immobilieBaseTyp.getKontaktperson().getStrasse());
            ((PersonAdressImpl)((Object)iterator)).setPersonFax(immobilieBaseTyp.getKontaktperson().getTelefax());
            ((PersonAdressImpl)((Object)iterator)).setPersonPhone(immobilieBaseTyp.getKontaktperson().getTelefon());
            ((PersonAdressImpl)((Object)iterator)).setPersonFirstName(immobilieBaseTyp.getKontaktperson().getVorname());
            String string = immobilieBaseTyp.getKontaktperson().getAnrede();
            if (string == null) {
                ((PersonAdressImpl)((Object)iterator)).setPersonGender(null);
            } else if (string.trim().toLowerCase().contains("frau") || string.trim().equalsIgnoreCase("FEMALE")) {
                ((PersonAdressImpl)((Object)iterator)).setPersonGender("FEMALE");
            } else if (string.trim().toLowerCase().contains("herr") || string.trim().equalsIgnoreCase("MALE")) {
                ((PersonAdressImpl)((Object)iterator)).setPersonGender("MALE");
            }
            if (immobilieBaseTyp.getKontaktperson().getLaenderkennzeichen() != null) {
                ((SimpleAdressImpl)((Object)iterator)).setCountry(OpenEstateUtils.convertToIso2Country(immobilieBaseTyp.getKontaktperson().getLaenderkennzeichen().toString()));
            }
        }
        if (immobilieBaseTyp.getWaehrung() != null) {
            try {
                estateImpl.setCurrency(Currency.getInstance(immobilieBaseTyp.getWaehrung().toString()));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"W\u00e4hrung konnte nicht \u00fcbernommen werden!");
                LOGGER.warn((Object)("> " + immobilieBaseTyp.getWaehrung().toString()));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        if (immobilieBaseTyp instanceof Anlageobjekt.Type) {
            this.convertImmobilie((Anlageobjekt.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof BueroPraxis.Type) {
            this.convertImmobilie((BueroPraxis.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof Einzelhandel.Type) {
            this.convertImmobilie((Einzelhandel.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof GarageKauf.Type) {
            this.convertImmobilie((GarageKauf.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof GarageMiete.Type) {
            this.convertImmobilie((GarageMiete.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof Gastronomie.Type) {
            this.convertImmobilie((Gastronomie.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof GrundstueckGewerbe.Type) {
            this.convertImmobilie((GrundstueckGewerbe.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof GrundstueckWohnenKauf.Type) {
            this.convertImmobilie((GrundstueckWohnenKauf.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof GrundstueckWohnenMiete.Type) {
            this.convertImmobilie((GrundstueckWohnenMiete.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof HalleProduktion.Type) {
            this.convertImmobilie((HalleProduktion.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof HausKauf.Type) {
            this.convertImmobilie((HausKauf.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof HausMiete.Type) {
            this.convertImmobilie((HausMiete.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof SonstigeGewerbe.Type) {
            this.convertImmobilie((SonstigeGewerbe.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof WAZ.Type) {
            this.convertImmobilie((WAZ.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof WGZimmer.Type) {
            this.convertImmobilie((WGZimmer.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof WohnungKauf.Type) {
            this.convertImmobilie((WohnungKauf.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof WohnungMiete.Type) {
            this.convertImmobilie((WohnungMiete.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof Zwangsversteigerung.Type) {
            this.convertImmobilie((Zwangsversteigerung.Type)immobilieBaseTyp, estateImpl);
        } else {
            throw new OpenEstateException("Unbekannte Immobilienart: " + immobilieBaseTyp.getClass().getName());
        }
        estateImpl.getCustomValues().putCustomValue("nr", immobilieBaseTyp.getAnbieterObjektID(), 5);
        estateImpl.getCustomValues().putCustomValue("nr_intern", immobilieBaseTyp.getScoutObjektID(), 5);
        if (immobilieBaseTyp.getProvision() != null) {
            if (Boolean.FALSE.equals(immobilieBaseTyp.isProvisionspflichtig())) {
                this.putEstateValue("PREISE", "COURTAGE_INNEN", immobilieBaseTyp.getProvision(), estateImpl);
            } else {
                this.putEstateValue("PREISE", "COURTAGE_AUSSEN", immobilieBaseTyp.getProvision(), estateImpl);
            }
        }
        this.putEstateValue("FREITEXTE", "AUSSTATT_BESCHR", immobilieBaseTyp.getAusstattung(), estateImpl);
        this.putEstateValue("FREITEXTE", "LAGE_BESCHR", immobilieBaseTyp.getLage(), estateImpl);
        this.putEstateValue("FREITEXTE", "OBJEKT_BESCHR", immobilieBaseTyp.getObjektbeschreibung(), estateImpl);
        this.putEstateValue("FREITEXTE", "PROVISION_BESCHR", immobilieBaseTyp.getProvisionshinweis(), estateImpl);
        this.putEstateValue("FREITEXTE", "SONSTIGE_ANGABEN", immobilieBaseTyp.getSonstigeAngaben(), estateImpl);
        for (MultimediaAnhangTyp multimediaAnhangTyp : immobilieBaseTyp.getMultimediaAnhang()) {
            String string;
            MMAnhangArtenTyp mMAnhangArtenTyp = multimediaAnhangTyp.getAnhangArt();
            if (!MMAnhangArtenTyp.BILD.equals((Object)mMAnhangArtenTyp) && !MMAnhangArtenTyp.GRUNDRISS_BILD.equals((Object)mMAnhangArtenTyp)) continue;
            EstateAttachmentImpl estateAttachmentImpl = new EstateAttachmentImpl();
            if (MMAnhangArtenTyp.BILD.equals((Object)mMAnhangArtenTyp)) {
                estateAttachmentImpl.setType("IMAGE");
            } else if (MMAnhangArtenTyp.GRUNDRISS_BILD.equals((Object)mMAnhangArtenTyp)) {
                estateAttachmentImpl.setType("IMAGE_GROUNDPLAN");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!StringUtils.isBlank((String)multimediaAnhangTyp.getDateityp())) {
                string = multimediaAnhangTyp.getDateityp().trim();
                if (!string.startsWith(".")) {
                    string = "." + string;
                }
                arrayList.add(string);
            }
            if (!StringUtils.isBlank((String)multimediaAnhangTyp.getDateiname()) && multimediaAnhangTyp.getDateiname().contains(".")) {
                string = StringUtils.substringAfterLast((String)multimediaAnhangTyp.getDateiname(), (String)".").trim();
                if (!string.startsWith(".")) {
                    string = "." + string;
                }
                arrayList.add(string);
            }
            string = null;
            for (String string2 : arrayList) {
                if (".AVI".equalsIgnoreCase(string2)) {
                    string = "video/x-msvideo";
                } else if (".BMP".equalsIgnoreCase(string2)) {
                    string = "image/bmp";
                } else if (".GIF".equalsIgnoreCase(string2)) {
                    string = "image/gif";
                } else if (".JPG".equalsIgnoreCase(string2)) {
                    string = "image/jpeg";
                } else if (".MOV".equalsIgnoreCase(string2)) {
                    string = "video/quicktime";
                } else if (".MP4".equalsIgnoreCase(string2)) {
                    string = "video/mp4";
                } else if (".MPE".equalsIgnoreCase(string2)) {
                    string = "video/mpeg";
                } else if (".MPEG".equalsIgnoreCase(string2)) {
                    string = "video/mpeg";
                } else if (".MPG".equalsIgnoreCase(string2)) {
                    string = "video/mpeg";
                } else if (".PDF".equalsIgnoreCase(string2)) {
                    string = "application/pdf";
                } else if (".PNG".equalsIgnoreCase(string2)) {
                    string = "image/png";
                } else if (".QT".equalsIgnoreCase(string2)) {
                    string = "video/quicktime";
                } else if (".QTL".equalsIgnoreCase(string2)) {
                    string = "video/quicktime";
                } else if (".RM".equalsIgnoreCase(string2)) {
                    string = "application/vnd.rn-realmedia";
                } else if (".RV".equalsIgnoreCase(string2)) {
                    string = "video/vnd.rn-realvideo";
                } else if (".WMV".equalsIgnoreCase(string2)) {
                    string = "video/x-ms-wmv";
                }
                if (StringUtils.isBlank((String)string)) continue;
                break;
            }
            if (StringUtils.isBlank((String)string)) {
                LOGGER.warn((Object)"Can't find MIME type for attachment!");
                LOGGER.warn((Object)("> Dateiname : '" + multimediaAnhangTyp.getDateiname() + "'"));
                LOGGER.warn((Object)("> Dateityp  : '" + multimediaAnhangTyp.getDateityp() + "'"));
                continue;
            }
            estateAttachmentImpl.setTitle(multimediaAnhangTyp.getTitel(), this.getOpenEstateLanguage());
            estateAttachmentImpl.setFile(multimediaAnhangTyp.getDateiname());
            estateAttachmentImpl.setMimeType(string);
            estateImpl.getAttachments().add(estateAttachmentImpl);
        }
        iterator = immobilieBaseTyp.getApiSuchfelder();
        if (iterator != null) {
            if (((ApiSuchfelderTyp)iterator.getValue()).getApiSuchfeld1() != null) {
                estateImpl.getCustomValues().putCustomValue("is24.api.search1", ((ApiSuchfelderTyp)iterator.getValue()).getApiSuchfeld1().getValue(), 5);
            }
            if (((ApiSuchfelderTyp)iterator.getValue()).getApiSuchfeld2() != null) {
                estateImpl.getCustomValues().putCustomValue("is24.api.search2", ((ApiSuchfelderTyp)iterator.getValue()).getApiSuchfeld2().getValue(), 5);
            }
            if (((ApiSuchfelderTyp)iterator.getValue()).getApiSuchfeld3() != null) {
                estateImpl.getCustomValues().putCustomValue("is24.api.search3", ((ApiSuchfelderTyp)iterator.getValue()).getApiSuchfeld3().getValue(), 5);
            }
        }
        return estateImpl;
    }

    protected void convertImmobilie(Anlageobjekt.Type type, EstateImpl estateImpl) throws OpenEstateException {
        AnlageobjekteKategorieTyp anlageobjekteKategorieTyp = type.getObjektkategorie2();
        String string = AnlageobjekteKategorieTyp.BUEROGEBAEUDE.equals((Object)anlageobjekteKategorieTyp) ? "BUEROHAUS" : (AnlageobjekteKategorieTyp.EIGENTUMSWOHNUNG.equals((Object)anlageobjekteKategorieTyp) ? "WOHNUNG" : (AnlageobjekteKategorieTyp.EINFAMILIENHAUS.equals((Object)anlageobjekteKategorieTyp) ? "EFH" : (AnlageobjekteKategorieTyp.EINKAUFSZENTRUM.equals((Object)anlageobjekteKategorieTyp) ? "EINKAUFSZENTRUM" : (AnlageobjekteKategorieTyp.FREIZEITANLAGE.equals((Object)anlageobjekteKategorieTyp) ? "FREIZEIT_SPORT" : (AnlageobjekteKategorieTyp.GASTSTAETTE.equals((Object)anlageobjekteKategorieTyp) ? "BAR" : (AnlageobjekteKategorieTyp.GESCHAEFTSHAUS.equals((Object)anlageobjekteKategorieTyp) ? "WOHN_GESCHAEFTSHAUS" : (AnlageobjekteKategorieTyp.GEWERBEANWESEN.equals((Object)anlageobjekteKategorieTyp) ? "GEWERBEZENTRUM" : (AnlageobjekteKategorieTyp.GEWERBEEINHEIT.equals((Object)anlageobjekteKategorieTyp) ? "MAIN_GEWERBE" : (AnlageobjekteKategorieTyp.HALLE_LAGER.equals((Object)anlageobjekteKategorieTyp) ? "HALLE_LAGER" : (AnlageobjekteKategorieTyp.HOTEL.equals((Object)anlageobjekteKategorieTyp) ? "HOTEL" : (AnlageobjekteKategorieTyp.INDUSTRIEANWESEN.equals((Object)anlageobjekteKategorieTyp) ? "INDUSTRIEANLAGE" : (AnlageobjekteKategorieTyp.LADEN_VERKAUFSFLAECHE.equals((Object)anlageobjekteKategorieTyp) ? "VERKAUFSFLAECHE" : (AnlageobjekteKategorieTyp.MEHRFAMILIENHAUS.equals((Object)anlageobjekteKategorieTyp) ? "MFH" : (AnlageobjekteKategorieTyp.SERVICECENTER.equals((Object)anlageobjekteKategorieTyp) ? "SERVICECENTER" : (AnlageobjekteKategorieTyp.SONSTIGE.equals((Object)anlageobjekteKategorieTyp) ? "MAIN_GEWERBE" : (AnlageobjekteKategorieTyp.SUPERMARKT.equals((Object)anlageobjekteKategorieTyp) ? "VERBRAUCHERMARKT" : (AnlageobjekteKategorieTyp.WOHNANLAGE.equals((Object)anlageobjekteKategorieTyp) ? "WOHNANLAGE" : (AnlageobjekteKategorieTyp.WOHN_GESCHAEFTSHAUS.equals((Object)anlageobjekteKategorieTyp) ? "WOHN_GESCHAEFTSHAUS" : "MAIN_GEWERBE"))))))))))))))))));
        estateImpl.setType(string, "KAUF");
        this.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", type.getAnzahlParkflaechen(), estateImpl);
        this.putEstateValue("ZUSTAND", "BAUJAHR", type.getBaujahr(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", type.getEtagen(), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_AUTOBAHN", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitBAB()), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_BHF", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitBHf()), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_FLUG", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitFlughafen()), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_BUS", IS24XmlUtils.getFusswegDistanz(type.getFusswegOeNV()), estateImpl);
        this.putEstateValue("FLAECHEN", "GESAMTFLAECHE", type.getGesamtflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GEWERBEFLAECHE", type.getGewerbeFlaechen(), estateImpl);
        this.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", type.getGrundstuecksFlaeche(), estateImpl);
        this.putEstateValue("ZUSTAND", "SANIERUNG", type.getJahrLetzteModernisierung(), estateImpl);
        this.putEstateValue("PREISE", "KAUFPREIS", type.getKaufpreis(), estateImpl);
        this.putEstateValue("PREISE", "KAUFPREIS_QM", type.getKaufpreisProQm(), estateImpl);
        this.putEstateValue("PREISE", "MIETEINNAHMEN_IST", type.getMietEinnahmePaIst(), estateImpl);
        this.putEstateValue("PREISE", "MIETEINNAHMEN_SOLL", type.getMietEinnahmePaSoll(), estateImpl);
        this.putEstateValue("PREISE", "STELLPLATZ_PREIS", type.getPreisProParkflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "SONSTFLAECHE", type.getSonstigeFlaechen(), estateImpl);
        this.putEstateValue("FLAECHEN", "VERMIETBARE_FLAECHE", type.getVermietbareFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "WOHNFLAECHE", type.getWohnFlaechen(), estateImpl);
        this.putEstateValue("PREISE", "X_FACHE", type.getXFacheMiete(), estateImpl);
        this.putEstateValue("VERWALTUNG", "DENKMALGESCHUETZT", type.isDenkmalschutzobjekt(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "PERS_LIFT", type.isPersonenaufzug(), estateImpl);
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
    }

    protected void convertImmobilie(BueroPraxis.Type type, EstateImpl estateImpl) throws OpenEstateException {
        String string;
        VermarktungGewerbeTyp vermarktungGewerbeTyp = type.getVermarktung();
        if (vermarktungGewerbeTyp.getKauf() != null) {
            string = "KAUF";
        } else if (vermarktungGewerbeTyp.getMiete() != null) {
            string = "MIETE";
        } else {
            throw new OpenEstateException("Unbekannte Vermarktungsart!");
        }
        BueroPraxisKategorienTyp bueroPraxisKategorienTyp = type.getObjektkategorie2();
        String string2 = BueroPraxisKategorienTyp.ATELIER.equals((Object)bueroPraxisKategorienTyp) ? "ATELIERWOHNUNG" : (BueroPraxisKategorienTyp.BUERO.equals((Object)bueroPraxisKategorienTyp) ? "BUERO" : (BueroPraxisKategorienTyp.BUEROHAUS.equals((Object)bueroPraxisKategorienTyp) ? "BUEROHAUS" : (BueroPraxisKategorienTyp.BUEROZENTRUM.equals((Object)bueroPraxisKategorienTyp) ? "BUEROZENTRUM" : (BueroPraxisKategorienTyp.BUERO_ETAGE.equals((Object)bueroPraxisKategorienTyp) ? "BUEROETAGE" : (BueroPraxisKategorienTyp.BUERO_UND_GESCHAEFTSGEBAEUDE.equals((Object)bueroPraxisKategorienTyp) ? "BUERO_GESCHAEFTSHAUS" : (BueroPraxisKategorienTyp.BUERO_UND_LAGER_GEBAEUDE.equals((Object)bueroPraxisKategorienTyp) ? "BUERO_GESCHAEFTSHAUS" : (BueroPraxisKategorienTyp.GEWERBE_ZENTRUM.equals((Object)bueroPraxisKategorienTyp) ? "GEWERBEZENTRUM" : (BueroPraxisKategorienTyp.KEINE_ANGABE.equals((Object)bueroPraxisKategorienTyp) ? "BUERO_PRAXIS" : (BueroPraxisKategorienTyp.LOFT.equals((Object)bueroPraxisKategorienTyp) ? "LOFTWOHNUNG" : (BueroPraxisKategorienTyp.PRAXIS.equals((Object)bueroPraxisKategorienTyp) ? "PRAXIS" : (BueroPraxisKategorienTyp.PRAXIS_ETAGE.equals((Object)bueroPraxisKategorienTyp) ? "PRAXISETAGE" : (BueroPraxisKategorienTyp.PRAXIS_HAUS.equals((Object)bueroPraxisKategorienTyp) ? "PRAXISHAUS" : (BueroPraxisKategorienTyp.WOHN_UND_GESCHAEFTSGEBAEUDE.equals((Object)bueroPraxisKategorienTyp) ? "WOHN_GESCHAEFTSHAUS" : "BUERO_PRAXIS")))))))))))));
        estateImpl.setType(string2, string);
        this.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", type.getAnzahlParkflaechen(), estateImpl);
        this.putEstateValue("ZUSTAND", "BAUJAHR", type.getBaujahr(), estateImpl);
        this.putEstateValue("FLAECHEN", "BUEROFLAECHE", type.getBueroPraxisFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GEWERBEFLAECHE", type.getBueroPraxisFlaeche(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", type.getEtagen(), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_AUTOBAHN", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitBAB()), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_BHF", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitBHf()), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_FLUG", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitFlughafen()), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", type.getFreiAb(), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_BUS", IS24XmlUtils.getFusswegDistanz(type.getFusswegOeNV()), estateImpl);
        this.putEstateValue("FLAECHEN", "GESAMTFLAECHE", type.getGesamtflaeche(), estateImpl);
        this.putEstateValue("ZUSTAND", "SANIERUNG", type.getJahrLetzteModernisierung(), estateImpl);
        this.putEstateValue("FLAECHEN", "SONSTFLAECHE", type.getNebenflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "TEILBAR_AB", type.getTeilbarAb(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "BARRIEREFREI", type.isBarrierefrei(), estateImpl);
        this.putEstateValue("VERWALTUNG", "DENKMALGESCHUETZT", type.isDenkmalschutzobjekt(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "KANTINE_CAFETERIA", type.isKantine(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "KELLER", type.isKeller(), estateImpl);
        if (Boolean.TRUE.equals(type.isKuecheVorhanden())) {
            this.putEstateValue("AUSSTATTUNG", "KUECHE", "EINBAUKUECHE", estateImpl);
        }
        this.putEstateValue("AUSSTATTUNG", "PERS_LIFT", type.isPersonenaufzug(), estateImpl);
        if (Boolean.TRUE.equals(type.isStarkstrom())) {
            this.putEstateValue("AUSSTATTUNG", "TECHNIK", "STARKSTROM", estateImpl);
        }
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readBodenBelag(type.getBodenbelag(), estateImpl);
        this.readDatenVerkabelung(type.getDatenVerkabelung(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readKlimaanlage(type.getKlimaanlage(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
    }

    protected void convertImmobilie(Einzelhandel.Type type, EstateImpl estateImpl) throws OpenEstateException {
        String string;
        VermarktungGewerbeTyp vermarktungGewerbeTyp = type.getVermarktung();
        if (vermarktungGewerbeTyp.getKauf() != null) {
            string = "KAUF";
        } else if (vermarktungGewerbeTyp.getMiete() != null) {
            string = "MIETE";
        } else {
            throw new OpenEstateException("Unbekannte Vermarktungsart!");
        }
        EinzelhandelKategorienTyp einzelhandelKategorienTyp = type.getObjektkategorie2();
        String string2 = EinzelhandelKategorienTyp.AUSSTELLUNGSFLAECHE.equals((Object)einzelhandelKategorienTyp) ? "AUSSTELLUNGSFLAECHE" : (EinzelhandelKategorienTyp.EINKAUFSZENTRUM.equals((Object)einzelhandelKategorienTyp) ? "EINKAUFSZENTRUM" : (EinzelhandelKategorienTyp.FACTORY_OUTLET.equals((Object)einzelhandelKategorienTyp) ? "EINZELHANDEL" : (EinzelhandelKategorienTyp.KAUFHAUS.equals((Object)einzelhandelKategorienTyp) ? "KAUFHAUS" : (EinzelhandelKategorienTyp.KEINE_ANGABE.equals((Object)einzelhandelKategorienTyp) ? "EINZELHANDEL" : (EinzelhandelKategorienTyp.KIOSK.equals((Object)einzelhandelKategorienTyp) ? "KIOSK" : (EinzelhandelKategorienTyp.LADEN.equals((Object)einzelhandelKategorienTyp) ? "LADEN" : (EinzelhandelKategorienTyp.SB_MARKT.equals((Object)einzelhandelKategorienTyp) ? "SB_MARKT" : (EinzelhandelKategorienTyp.VERKAUFSFLAECHE.equals((Object)einzelhandelKategorienTyp) ? "VERKAUFSFLAECHE" : (EinzelhandelKategorienTyp.VERKAUFSHALLE.equals((Object)einzelhandelKategorienTyp) ? "VERKAUFSHALLE" : "EINZELHANDEL")))))))));
        estateImpl.setType(string2, string);
        this.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", type.getAnzahlParkflaechen(), estateImpl);
        this.putEstateValue("ZUSTAND", "BAUJAHR", type.getBaujahr(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "DECKENLAST", type.getDeckenlast(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", type.getEtagen(), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_AUTOBAHN", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitBAB()), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_BHF", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitBHf()), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_FLUG", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitFlughafen()), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", type.getFreiAb(), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_BUS", IS24XmlUtils.getFusswegDistanz(type.getFusswegOeNV()), estateImpl);
        this.putEstateValue("FLAECHEN", "GESAMTFLAECHE", type.getGesamtflaeche(), estateImpl);
        this.putEstateValue("ZUSTAND", "SANIERUNG", type.getJahrLetzteModernisierung(), estateImpl);
        this.putEstateValue("FLAECHEN", "SONSTFLAECHE", type.getNebenflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "FENSTERFRONT_M", type.getSchaufensterfront(), estateImpl);
        this.putEstateValue("FLAECHEN", "TEILBAR_AB", type.getTeilbarAb(), estateImpl);
        this.putEstateValue("FLAECHEN", "VERKAUFSFLAECHE", type.getVerkaufsflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GEWERBEFLAECHE", type.getVerkaufsflaeche(), estateImpl);
        this.putEstateValue("VERWALTUNG", "DENKMALGESCHUETZT", type.isDenkmalschutzobjekt(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "KELLER", type.isKeller(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "PERS_LIFT", type.isPersonenaufzug(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "RAMPE", type.isRampe(), estateImpl);
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readBodenBelag(type.getBodenbelag(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readLageArt(type.getLageart(), estateImpl);
        if (type.getLastenaufzug() != null) {
            this.readLastenaufzug((HebeanlageTyp)type.getLastenaufzug().getValue(), estateImpl);
        }
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
        this.readObjektZulieferung(type.getZulieferung(), estateImpl);
    }

    protected void convertImmobilie(GarageKauf.Type type, EstateImpl estateImpl) throws OpenEstateException {
        GaragenKategorieTyp garagenKategorieTyp = type.getObjektKategorie2();
        String string = GaragenKategorieTyp.AUSSENSTELLPLATZ.equals((Object)garagenKategorieTyp) ? "AUSSENSTELLPLATZ" : (GaragenKategorieTyp.CARPORT.equals((Object)garagenKategorieTyp) ? "CARPORT" : (GaragenKategorieTyp.DUPLEX.equals((Object)garagenKategorieTyp) ? "DUPLEX" : (GaragenKategorieTyp.GARAGE.equals((Object)garagenKategorieTyp) ? "GARAGE" : (GaragenKategorieTyp.KEINE_ANGABE.equals((Object)garagenKategorieTyp) ? "MAIN_STELLPLATZ" : (GaragenKategorieTyp.PARKHAUS.equals((Object)garagenKategorieTyp) ? "PARKHAUS" : (GaragenKategorieTyp.TIEFGARAGE.equals((Object)garagenKategorieTyp) ? "TIEFGARAGE" : "MAIN_STELLPLATZ"))))));
        estateImpl.setType(string, "KAUF");
        this.putEstateValue("ZUSTAND", "BAUJAHR", type.getBaujahr(), estateImpl);
        this.putEstateValue("FLAECHEN", "BREITE", type.getBreite(), estateImpl);
        this.putEstateValue("FLAECHEN", "STELLPLATZFLAECHE", type.getFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GESAMTFLAECHE", type.getFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "HOEHE", type.getHoehe(), estateImpl);
        this.putEstateValue("ZUSTAND", "SANIERUNG", type.getJahrLetzteModernisierung(), estateImpl);
        this.putEstateValue("FLAECHEN", "LAENGE", type.getLaenge(), estateImpl);
        if (type.getKaufpreise() != null) {
            this.putEstateValue("PREISE", "KAUFPREIS", type.getKaufpreise().getKaufpreis(), estateImpl);
        }
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
    }

    protected void convertImmobilie(GarageMiete.Type type, EstateImpl estateImpl) throws OpenEstateException {
        GaragenKategorieTyp garagenKategorieTyp = type.getObjektKategorie2();
        String string = GaragenKategorieTyp.AUSSENSTELLPLATZ.equals((Object)garagenKategorieTyp) ? "AUSSENSTELLPLATZ" : (GaragenKategorieTyp.CARPORT.equals((Object)garagenKategorieTyp) ? "CARPORT" : (GaragenKategorieTyp.DUPLEX.equals((Object)garagenKategorieTyp) ? "DUPLEX" : (GaragenKategorieTyp.GARAGE.equals((Object)garagenKategorieTyp) ? "GARAGE" : (GaragenKategorieTyp.KEINE_ANGABE.equals((Object)garagenKategorieTyp) ? "MAIN_STELLPLATZ" : (GaragenKategorieTyp.PARKHAUS.equals((Object)garagenKategorieTyp) ? "PARKHAUS" : (GaragenKategorieTyp.TIEFGARAGE.equals((Object)garagenKategorieTyp) ? "TIEFGARAGE" : "MAIN_STELLPLATZ"))))));
        estateImpl.setType(string, "MIETE");
        this.putEstateValue("ZUSTAND", "BAUJAHR", type.getBaujahr(), estateImpl);
        this.putEstateValue("FLAECHEN", "BREITE", type.getBreite(), estateImpl);
        this.putEstateValue("FLAECHEN", "STELLPLATZFLAECHE", type.getFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GESAMTFLAECHE", type.getFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "HOEHE", type.getHoehe(), estateImpl);
        this.putEstateValue("ZUSTAND", "SANIERUNG", type.getJahrLetzteModernisierung(), estateImpl);
        this.putEstateValue("FLAECHEN", "LAENGE", type.getLaenge(), estateImpl);
        if (type.getMietpreise() != null) {
            this.putEstateValue("PREISE", "KALTMIETE", type.getMietpreise().getMiete(), estateImpl);
        }
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
    }

    protected void convertImmobilie(Gastronomie.Type type, EstateImpl estateImpl) throws OpenEstateException {
        String string;
        VermarktungGewerbeTyp2 vermarktungGewerbeTyp2 = type.getVermarktung();
        if (vermarktungGewerbeTyp2.getKauf() != null) {
            string = "KAUF";
        } else if (vermarktungGewerbeTyp2.getMiete() != null) {
            string = "MIETE";
        } else {
            throw new OpenEstateException("Unbekannte Vermarktungsart!");
        }
        GastroKategorieTyp gastroKategorieTyp = type.getObjektkategorie2();
        String string2 = GastroKategorieTyp.BARBETRIEB.equals((Object)gastroKategorieTyp) ? "BAR" : (GastroKategorieTyp.CAFFEE.equals((Object)gastroKategorieTyp) ? "BISTRO" : (GastroKategorieTyp.DISKOTHEK.equals((Object)gastroKategorieTyp) ? "DISKO" : (GastroKategorieTyp.FERIENBUNGALOW.equals((Object)gastroKategorieTyp) ? "BUNGALOW" : (GastroKategorieTyp.GAESTEHAUS.equals((Object)gastroKategorieTyp) ? "GAST" : (GastroKategorieTyp.GASTSTAETTE.equals((Object)gastroKategorieTyp) ? "BAR" : (GastroKategorieTyp.HOTEL.equals((Object)gastroKategorieTyp) ? "HOTEL" : (GastroKategorieTyp.HOTELANWESEN.equals((Object)gastroKategorieTyp) ? "HOTEL" : (GastroKategorieTyp.HOTEL_GARNI.equals((Object)gastroKategorieTyp) ? "HOTEL" : (GastroKategorieTyp.PENSION.equals((Object)gastroKategorieTyp) ? "PENSION" : (GastroKategorieTyp.RESTAURANT.equals((Object)gastroKategorieTyp) ? "RESTAURANT" : "GAST"))))))))));
        estateImpl.setType(string2, string);
        this.putEstateValue("FLAECHEN", "ANZ_BETTEN", type.getAnzahlBetten(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", type.getAnzahlParkflaechen(), estateImpl);
        this.putEstateValue("ZUSTAND", "BAUJAHR", type.getBaujahr(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", type.getEtagen(), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_AUTOBAHN", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitBAB()), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_BHF", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitBHf()), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_FLUG", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitFlughafen()), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", type.getFreiAb(), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_BUS", IS24XmlUtils.getFusswegDistanz(type.getFusswegOeNV()), estateImpl);
        this.putEstateValue("FLAECHEN", "GASTRAUMFLAECHE", type.getGastraumFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_GAESTEZIMMER", type.getGastraumPlaetze(), estateImpl);
        this.putEstateValue("FLAECHEN", "GESAMTFLAECHE", type.getGesamtflaeche(), estateImpl);
        this.putEstateValue("ZUSTAND", "SANIERUNG", type.getJahrLetzteModernisierung(), estateImpl);
        this.putEstateValue("FLAECHEN", "SONSTFLAECHE", type.getNebenflaeche(), estateImpl);
        this.putEstateValue("VERWALTUNG", "DENKMALGESCHUETZT", type.isDenkmalschutzobjekt(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "KELLER", type.isKeller(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "PERS_LIFT", type.isPersonenaufzug(), estateImpl);
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
    }

    protected void convertImmobilie(GrundstueckGewerbe.Type type, EstateImpl estateImpl) throws OpenEstateException {
        String string;
        VermarktungGrundstueckGewerbeTyp vermarktungGrundstueckGewerbeTyp = type.getVermarktung();
        if (vermarktungGrundstueckGewerbeTyp.getErbpacht() != null) {
            string = "ERBPACHT";
        } else if (vermarktungGrundstueckGewerbeTyp.getKauf() != null) {
            string = "KAUF";
        } else if (vermarktungGrundstueckGewerbeTyp.getMiete() != null) {
            string = "MIETE";
        } else if (vermarktungGrundstueckGewerbeTyp.getPacht() != null) {
            string = "PACHT";
        } else {
            throw new OpenEstateException("Unbekannte Vermarktungsart!");
        }
        GrundstueckGewerbeKategorienTyp grundstueckGewerbeKategorienTyp = type.getObjektkategorie2();
        String string2 = GrundstueckGewerbeKategorienTyp.FREIZEIT.equals((Object)grundstueckGewerbeKategorienTyp) ? "FREIZEITGRUND" : (GrundstueckGewerbeKategorienTyp.GEWERBE.equals((Object)grundstueckGewerbeKategorienTyp) ? "GEWERBEGRUND" : (GrundstueckGewerbeKategorienTyp.LAND_FORSTWIRTSCHAFT.equals((Object)grundstueckGewerbeKategorienTyp) ? "LAND_FORSTGRUND" : "GEWERBEGRUND"));
        estateImpl.setType(string2, string);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", type.getFreiAb(), estateImpl);
        this.putEstateValue("FLAECHEN", "GFZ", type.getGFZ(), estateImpl);
        this.putEstateValue("FLAECHEN", "GRZ", type.getGRZ(), estateImpl);
        this.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", type.getGrundstuecksFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GESAMTFLAECHE", type.getGrundstuecksFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "TEILBAR_AB", type.getTeilbarAb(), estateImpl);
        this.putEstateValue("VERWALTUNG", "ABRISS", type.isAbrissErforderlich(), estateImpl);
        this.putEstateValue("VERWALTUNG", "BAUGENEHMIGUNG", type.isBaugenehmigungVorhanden(), estateImpl);
        this.putEstateValue("VERWALTUNG", "BEBAUBAR_KURZ", type.isKurzfristigBebaubar(), estateImpl);
        this.readBebaubarMit(type.getBebaubarMit(), estateImpl);
        this.readBebaubarNach(type.getBebaubarNach(), estateImpl);
        this.readErschliessungZustand(type.getErschliessungszustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
    }

    protected void convertImmobilie(GrundstueckWohnenKauf.Type type, EstateImpl estateImpl) throws OpenEstateException {
        String string;
        VermarktungGrundstueckWohnenKaufTyp vermarktungGrundstueckWohnenKaufTyp = type.getVermarktung();
        if (vermarktungGrundstueckWohnenKaufTyp.getErbpacht() != null) {
            string = "ERBPACHT";
        } else if (vermarktungGrundstueckWohnenKaufTyp.getKauf() != null) {
            string = "KAUF";
        } else {
            throw new OpenEstateException("Unbekannte Vermarktungsart!");
        }
        String string2 = "WOHNGRUND";
        estateImpl.setType(string2, string);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", type.getFreiAb(), estateImpl);
        this.putEstateValue("FLAECHEN", "GFZ", type.getGFZ(), estateImpl);
        this.putEstateValue("FLAECHEN", "GRZ", type.getGRZ(), estateImpl);
        this.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", type.getGrundstuecksFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GESAMTFLAECHE", type.getGrundstuecksFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "TEILBAR_AB", type.getTeilbarAb(), estateImpl);
        this.putEstateValue("VERWALTUNG", "ABRISS", type.isAbrissErforderlich(), estateImpl);
        this.putEstateValue("VERWALTUNG", "BAUGENEHMIGUNG", type.isBaugenehmigungVorhanden(), estateImpl);
        this.putEstateValue("VERWALTUNG", "BEBAUBAR_KURZ", type.isKurzfristigBebaubar(), estateImpl);
        this.readBebaubarMit(type.getBebaubarMit(), estateImpl);
        this.readBebaubarNach(type.getBebaubarNach(), estateImpl);
        this.readErschliessungZustand(type.getErschliessungszustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
    }

    protected void convertImmobilie(GrundstueckWohnenMiete.Type type, EstateImpl estateImpl) throws OpenEstateException {
        String string;
        VermarktungGrundstueckWohnenMieteTyp vermarktungGrundstueckWohnenMieteTyp = type.getVermarktung();
        if (vermarktungGrundstueckWohnenMieteTyp.getMiete() != null) {
            string = "MIETE";
        } else if (vermarktungGrundstueckWohnenMieteTyp.getPacht() != null) {
            string = "PACHT";
        } else {
            throw new OpenEstateException("Unbekannte Vermarktungsart!");
        }
        String string2 = "WOHNGRUND";
        estateImpl.setType(string2, string);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", type.getFreiAb(), estateImpl);
        this.putEstateValue("FLAECHEN", "GFZ", type.getGFZ(), estateImpl);
        this.putEstateValue("FLAECHEN", "GRZ", type.getGRZ(), estateImpl);
        this.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", type.getGrundstuecksFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GESAMTFLAECHE", type.getGrundstuecksFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "TEILBAR_AB", type.getTeilbarAb(), estateImpl);
        this.putEstateValue("VERWALTUNG", "ABRISS", type.isAbrissErforderlich(), estateImpl);
        this.putEstateValue("VERWALTUNG", "BAUGENEHMIGUNG", type.isBaugenehmigungVorhanden(), estateImpl);
        this.putEstateValue("VERWALTUNG", "BEBAUBAR_KURZ", type.isKurzfristigBebaubar(), estateImpl);
        this.readBebaubarMit(type.getBebaubarMit(), estateImpl);
        this.readBebaubarNach(type.getBebaubarNach(), estateImpl);
        this.readErschliessungZustand(type.getErschliessungszustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
    }

    protected void convertImmobilie(HalleProduktion.Type type, EstateImpl estateImpl) throws OpenEstateException {
        String string;
        VermarktungGewerbeTyp vermarktungGewerbeTyp = type.getVermarktung();
        if (vermarktungGewerbeTyp.getKauf() != null) {
            string = "KAUF";
        } else if (vermarktungGewerbeTyp.getMiete() != null) {
            string = "MIETE";
        } else {
            throw new OpenEstateException("Unbekannte Vermarktungsart!");
        }
        HalleProduktionKategorieTyp halleProduktionKategorieTyp = type.getObjektkategorie2();
        String string2 = HalleProduktionKategorieTyp.AUSSTELLUNGSFLAECHE.equals((Object)halleProduktionKategorieTyp) ? "AUSSTELLUNGSFLAECHE" : (HalleProduktionKategorieTyp.HALLE.equals((Object)halleProduktionKategorieTyp) ? "HALLE_LAGER" : (HalleProduktionKategorieTyp.HOCHREGALLAGER.equals((Object)halleProduktionKategorieTyp) ? "HOCHREGALLAGER" : (HalleProduktionKategorieTyp.INDUSTRIEHALLE.equals((Object)halleProduktionKategorieTyp) ? "INDUSTRIEHALLE" : (HalleProduktionKategorieTyp.INDUSTRIEHALLE_MIT_FREIFLAECHE.equals((Object)halleProduktionKategorieTyp) ? "INDUSTRIEHALLE_FREIFLAECHE" : (HalleProduktionKategorieTyp.KEINE_ANGABE.equals((Object)halleProduktionKategorieTyp) ? "HALLE_LAGER" : (HalleProduktionKategorieTyp.KUEHLHAUS.equals((Object)halleProduktionKategorieTyp) ? "KUEHLHAUS" : (HalleProduktionKategorieTyp.KUEHLREGALLAGER.equals((Object)halleProduktionKategorieTyp) ? "KUEHLREGALLAGER" : (HalleProduktionKategorieTyp.LAGERFLAECHE.equals((Object)halleProduktionKategorieTyp) ? "LAGERFLAECHE" : (HalleProduktionKategorieTyp.LAGERHALLE.equals((Object)halleProduktionKategorieTyp) ? "LAGERHALLE" : (HalleProduktionKategorieTyp.LAGER_MIT_FREIFLAECHE.equals((Object)halleProduktionKategorieTyp) ? "LAGERFLAECHE" : (HalleProduktionKategorieTyp.SERVICEFLAECHE.equals((Object)halleProduktionKategorieTyp) ? "SERVICEFLAECHE" : (HalleProduktionKategorieTyp.SPEDITIONSLAGER.equals((Object)halleProduktionKategorieTyp) ? "SPEDITION" : (HalleProduktionKategorieTyp.WERKSTATT.equals((Object)halleProduktionKategorieTyp) ? "WERKSTATT" : "HALLE_LAGER")))))))))))));
        estateImpl.setType(string2, string);
        this.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", type.getAnzahlParkflaechen(), estateImpl);
        this.putEstateValue("ZUSTAND", "BAUJAHR", type.getBaujahr(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "BODENBELASTUNG", type.getBodenbelastung(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", type.getEtagen(), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_AUTOBAHN", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitBAB()), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_BHF", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitBHf()), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_FLUG", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitFlughafen()), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", type.getFreiAb(), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_BUS", IS24XmlUtils.getFusswegDistanz(type.getFusswegOeNV()), estateImpl);
        this.putEstateValue("FLAECHEN", "GESAMTFLAECHE", type.getGesamtflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", type.getGrundstuecksFlaeche(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "HALLENHOEHE", type.getHallenhoehe(), estateImpl);
        this.putEstateValue("ZUSTAND", "SANIERUNG", type.getJahrLetzteModernisierung(), estateImpl);
        this.putEstateValue("FLAECHEN", "LAGERFLAECHE", type.getLagerProduktionsFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "SONSTFLAECHE", type.getNebenflaeche(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "STROMANSCHLUSSWERT", type.getStromanschlusswert(), estateImpl);
        this.putEstateValue("FLAECHEN", "TEILBAR_AB", type.getTeilbarAb(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "HEBEBUEHNE", type.isHebebuehne(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "PERS_LIFT", type.isPersonenaufzug(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "RAMPE", type.isRampe(), estateImpl);
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readBodenBelag(type.getBodenbelag(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readKranbahn(type.getKranbahn(), estateImpl);
        this.readLastenaufzug(type.getLastenaufzug(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
    }

    protected void convertImmobilie(HausKauf.Type type, EstateImpl estateImpl) throws OpenEstateException {
        HausKategorienTyp hausKategorienTyp = type.getHausKategorie();
        String string = HausKategorienTyp.BAUERNHAUS.equals((Object)hausKategorienTyp) ? "BAUERNHAUS" : (HausKategorienTyp.BESONDERE_IMMOBILIE.equals((Object)hausKategorienTyp) ? "BESONDERES_HAUS" : (HausKategorienTyp.BUNGALOW.equals((Object)hausKategorienTyp) ? "BUNGALOW" : (HausKategorienTyp.BURG_SCHLOSS.equals((Object)hausKategorienTyp) ? "BURG" : (HausKategorienTyp.DOPPELHAUSHAELFTE.equals((Object)hausKategorienTyp) ? "DOPPELHAUSHAELFTE" : (HausKategorienTyp.EINFAMILIENHAUS.equals((Object)hausKategorienTyp) ? "EFH" : (HausKategorienTyp.MEHRFAMILIENHAUS.equals((Object)hausKategorienTyp) ? "MFH" : (HausKategorienTyp.REIHENECKHAUS.equals((Object)hausKategorienTyp) ? "REIHENECKHAUS" : (HausKategorienTyp.REIHENHAUS.equals((Object)hausKategorienTyp) ? "REIHENHAUS" : (HausKategorienTyp.REIHENMITTELHAUS.equals((Object)hausKategorienTyp) ? "REIHENMITTELHAUS" : (HausKategorienTyp.SONSTIGES.equals((Object)hausKategorienTyp) ? "HAUS" : (HausKategorienTyp.VILLA.equals((Object)hausKategorienTyp) ? "VILLA" : (HausKategorienTyp.ZWEIFAMILIENHAUS.equals((Object)hausKategorienTyp) ? "ZFH" : "HAUS"))))))))))));
        estateImpl.setType(string, "KAUF");
        this.putEstateValue("FLAECHEN", "ANZ_BADEZIMMER", type.getAnzahlBadezimmer(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", type.getAnzahlGaragenStellplaetze(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_SCHLAFZIMMER", type.getAnzahlSchlafzimmer(), estateImpl);
        this.putEstateValue("ZUSTAND", "BAUJAHR", type.getBaujahr(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", type.getEtagenzahl(), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", type.getFreiAb(), estateImpl);
        this.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", type.getGrundstuecksFlaeche(), estateImpl);
        this.putEstateValue("ZUSTAND", "SANIERUNG", type.getJahrLetzteModernisierung(), estateImpl);
        if (type.getKaufpreise() != null) {
            this.putEstateValue("PREISE", "KAUFPREIS", type.getKaufpreise().getKaufpreis(), estateImpl);
            this.putEstateValue("PREISE", "MIETEINNAHMEN_PRO_MONAT", type.getKaufpreise().getMieteinnahmenProMonat(), estateImpl);
            this.putEstateValue("PREISE", "STELLPLATZ_PREIS", type.getKaufpreise().getStellplatzKaufpreis(), estateImpl);
            this.putEstateValue("PREISE", "HAUSGELD", type.getKaufpreise().getWohngeld(), estateImpl);
        }
        this.putEstateValue("FLAECHEN", "NUTZFLAECHE", type.getNutzflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "WOHNFLAECHE", type.getWohnflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_ZIMMER", type.getZimmer(), estateImpl);
        this.putEstateValue("VERWALTUNG", "ALS_FERIEN", type.isAlsFerienwohnungGeeignet(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "BARRIEREFREI", type.isBarrierefrei(), estateImpl);
        this.putEstateValue("VERWALTUNG", "DENKMALGESCHUETZT", type.isDenkmalschutzobjekt(), estateImpl);
        if (Boolean.TRUE.equals(type.isGaesteWC())) {
            this.putEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl);
        }
        this.putEstateValue("AUSSTATTUNG", "KELLER", type.isKeller(), estateImpl);
        this.putEstateValue("VERWALTUNG", "EINLIEGERWOHNUNG", type.isMitEinliegerwohnung(), estateImpl);
        if (Boolean.TRUE.equals(type.isRollstuhlgerecht())) {
            this.putEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl);
        }
        this.putEstateValue("AUSSTATTUNG", "VERMIETET", type.isVermietet(), estateImpl);
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBauphase(type.getBauphase(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readStellplatz(type.getParkplatz(), estateImpl);
    }

    protected void convertImmobilie(HausMiete.Type type, EstateImpl estateImpl) throws OpenEstateException {
        HausKategorienTyp hausKategorienTyp = type.getHausKategorie();
        String string = HausKategorienTyp.BAUERNHAUS.equals((Object)hausKategorienTyp) ? "BAUERNHAUS" : (HausKategorienTyp.BESONDERE_IMMOBILIE.equals((Object)hausKategorienTyp) ? "BESONDERES_HAUS" : (HausKategorienTyp.BUNGALOW.equals((Object)hausKategorienTyp) ? "BUNGALOW" : (HausKategorienTyp.BURG_SCHLOSS.equals((Object)hausKategorienTyp) ? "BURG" : (HausKategorienTyp.DOPPELHAUSHAELFTE.equals((Object)hausKategorienTyp) ? "DOPPELHAUSHAELFTE" : (HausKategorienTyp.EINFAMILIENHAUS.equals((Object)hausKategorienTyp) ? "EFH" : (HausKategorienTyp.MEHRFAMILIENHAUS.equals((Object)hausKategorienTyp) ? "MFH" : (HausKategorienTyp.REIHENECKHAUS.equals((Object)hausKategorienTyp) ? "REIHENECKHAUS" : (HausKategorienTyp.REIHENHAUS.equals((Object)hausKategorienTyp) ? "REIHENHAUS" : (HausKategorienTyp.REIHENMITTELHAUS.equals((Object)hausKategorienTyp) ? "REIHENMITTELHAUS" : (HausKategorienTyp.SONSTIGES.equals((Object)hausKategorienTyp) ? "HAUS" : (HausKategorienTyp.VILLA.equals((Object)hausKategorienTyp) ? "VILLA" : (HausKategorienTyp.ZWEIFAMILIENHAUS.equals((Object)hausKategorienTyp) ? "ZFH" : "HAUS"))))))))))));
        estateImpl.setType(string, "MIETE");
        this.putEstateValue("FLAECHEN", "ANZ_BADEZIMMER", type.getAnzahlBadezimmer(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", type.getAnzahlGaragenStellplaetze(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_SCHLAFZIMMER", type.getAnzahlSchlafzimmer(), estateImpl);
        this.putEstateValue("ZUSTAND", "BAUJAHR", type.getBaujahr(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", type.getEtagenzahl(), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", type.getFreiAb(), estateImpl);
        this.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", type.getGrundstuecksFlaeche(), estateImpl);
        this.putEstateValue("ZUSTAND", "SANIERUNG", type.getJahrLetzteModernisierung(), estateImpl);
        if (type.getMietpreise() != null) {
            this.putEstateValue("PREISE", "HEIZKOSTEN", type.getMietpreise().getHeizkosten(), estateImpl);
            this.putEstateValue("PREISE", "KALTMIETE", type.getMietpreise().getKaltmiete(), estateImpl);
            this.putEstateValue("PREISE", "KAUTION", type.getMietpreise().getKaution(), estateImpl);
            this.putEstateValue("PREISE", "NEBENKOSTEN", type.getMietpreise().getNebenkosten(), estateImpl);
            this.putEstateValue("PREISE", "STELLPLATZ_MIETE", type.getMietpreise().getStellplatzMiete(), estateImpl);
            this.putEstateValue("PREISE", "WARMMIETE", type.getMietpreise().getWarmmiete(), estateImpl);
            this.putEstateValue("PREISE", "NEBENKOSTEN_INKL_HEIZKOSTEN", type.getMietpreise().isHeizkostenInWarmmieteEnthalten(), estateImpl);
        }
        this.putEstateValue("FLAECHEN", "NUTZFLAECHE", type.getNutzflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "WOHNFLAECHE", type.getWohnflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_ZIMMER", type.getZimmer(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "BARRIEREFREI", type.isBarrierefrei(), estateImpl);
        if (Boolean.TRUE.equals(type.isBetreutesWohnen())) {
            this.putEstateValue("AUSSTATTUNG", "SERVICELEISTUNGEN", "BETREUTES_WOHNEN", estateImpl);
        }
        if (Boolean.TRUE.equals(type.isEinbaukueche())) {
            this.putEstateValue("AUSSTATTUNG", "KUECHE", "EINBAUKUECHE", estateImpl);
        }
        if (Boolean.TRUE.equals(type.isGaesteWC())) {
            this.putEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl);
        }
        this.putEstateValue("AUSSTATTUNG", "KELLER", type.isKeller(), estateImpl);
        if (Boolean.TRUE.equals(type.isRollstuhlgerecht())) {
            this.putEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl);
        }
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHaustiere(type.getHaustiere(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readStellplatz(type.getParkplatz(), estateImpl);
    }

    protected void convertImmobilie(SonstigeGewerbe.Type type, EstateImpl estateImpl) throws OpenEstateException {
        String string;
        VermarktungGewerbeTyp2 vermarktungGewerbeTyp2 = type.getVermarktung();
        if (vermarktungGewerbeTyp2.getKauf() != null) {
            string = "KAUF";
        } else if (vermarktungGewerbeTyp2.getMiete() != null) {
            string = "MIETE";
        } else {
            throw new OpenEstateException("Unbekannte Vermarktungsart!");
        }
        SonstigeGewerbeKategorieTyp sonstigeGewerbeKategorieTyp = type.getObjektkategorie2();
        String string2 = SonstigeGewerbeKategorieTyp.ANWESEN.equals((Object)sonstigeGewerbeKategorieTyp) ? "MAIN_GEWERBE" : (SonstigeGewerbeKategorieTyp.BAUERNHOF.equals((Object)sonstigeGewerbeKategorieTyp) ? "BAUERNHOF" : (SonstigeGewerbeKategorieTyp.FREIZEITANLAGE.equals((Object)sonstigeGewerbeKategorieTyp) ? "FREIZEIT_SPORT" : (SonstigeGewerbeKategorieTyp.GEWERBEFLAECHE.equals((Object)sonstigeGewerbeKategorieTyp) ? "MAIN_GEWERBE" : (SonstigeGewerbeKategorieTyp.GEWERBEPARK.equals((Object)sonstigeGewerbeKategorieTyp) ? "MAIN_GEWERBE" : (SonstigeGewerbeKategorieTyp.REITERHOF.equals((Object)sonstigeGewerbeKategorieTyp) ? "REITERHOF" : (SonstigeGewerbeKategorieTyp.SPEZIALOBJEKT.equals((Object)sonstigeGewerbeKategorieTyp) ? "MAIN_GEWERBE" : (SonstigeGewerbeKategorieTyp.WEINGUT.equals((Object)sonstigeGewerbeKategorieTyp) ? "WEINBAU" : (SonstigeGewerbeKategorieTyp.WERKSTATT.equals((Object)sonstigeGewerbeKategorieTyp) ? "WERKSTATT" : "MAIN_GEWERBE"))))))));
        estateImpl.setType(string2, string);
        this.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", type.getAnzahlParkflaechen(), estateImpl);
        this.putEstateValue("ZUSTAND", "BAUJAHR", type.getBaujahr(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", type.getEtagen(), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_AUTOBAHN", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitBAB()), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_BHF", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitBHf()), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_FLUG", IS24XmlUtils.getFahrtwegDistanz(type.getFahrzeitFlughafen()), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", type.getFreiAb(), estateImpl);
        this.putEstateValue("UMFELD", "DISTANZ_BUS", IS24XmlUtils.getFusswegDistanz(type.getFusswegOeNV()), estateImpl);
        this.putEstateValue("FLAECHEN", "GESAMTFLAECHE", type.getGesamtflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", type.getGrundstuecksFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GEWERBEFLAECHE", type.getHauptflaeche(), estateImpl);
        this.putEstateValue("ZUSTAND", "SANIERUNG", type.getJahrLetzteModernisierung(), estateImpl);
        this.putEstateValue("FLAECHEN", "SONSTFLAECHE", type.getNebenflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "TEILBAR_AB", type.getTeilbarAb(), estateImpl);
        this.putEstateValue("VERWALTUNG", "DENKMALGESCHUETZT", type.isDenkmalschutzobjekt(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "KELLER", type.isKeller(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "PERS_LIFT", type.isPersonenaufzug(), estateImpl);
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readBodenBelag(type.getBodenbelag(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
    }

    protected void convertImmobilie(WAZ.Type type, EstateImpl estateImpl) throws OpenEstateException {
        WazKategorienTyp wazKategorienTyp = type.getWazKategorie();
        String string = WazKategorienTyp.APPARTMENT.equals((Object)wazKategorienTyp) ? "APPARTMENTWOHNUNG" : (WazKategorienTyp.HAUS.equals((Object)wazKategorienTyp) ? "HAUS" : (WazKategorienTyp.WOHNUNG.equals((Object)wazKategorienTyp) ? "WOHNUNG" : (WazKategorienTyp.ZIMMER.equals((Object)wazKategorienTyp) ? "ZIMMER" : "MAIN_WOHNEN")));
        estateImpl.setType(string, "WAZ");
        this.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", type.getAnzahlGaragenStellplaetze(), estateImpl);
        this.putEstateValue("VERWALTUNG", "MAX_PERSONEN", type.getAnzahlPersonen(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE", type.getEtage(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", type.getEtagenzahl(), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", type.getFreiAb(), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_BISDATE", type.getFreiBis(), estateImpl);
        this.putEstateValue("PREISE", "KAUTION", type.getKaution(), estateImpl);
        this.putEstateValue("VERWALTUNG", "MAX_MIETDAUER", type.getMaximalmietdauer(), estateImpl);
        this.putEstateValue("VERWALTUNG", "MIN_MIETDAUER", type.getMidestmietdauer(), estateImpl);
        if (type.getMonatsmiete() != null) {
            this.putEstateValue("PREISE", "KALTMIETE", type.getMonatsmiete().getKaltmiete(), estateImpl);
            this.putEstateValue("PREISE", "NEBENKOSTEN", type.getMonatsmiete().getNebenkosten(), estateImpl);
        }
        this.putEstateValue("PREISE", "STELLPLATZ_MIETE", type.getParkplatzmiete(), estateImpl);
        if (type.getPauschalmiete() != null) {
            this.putEstateValue("PREISE", "PAUSCHALMIETE", type.getPauschalmiete().getMietePauschal(), estateImpl);
            if (WazZeiteinheitenTyp.MONAT.equals((Object)type.getPauschalmiete().getMietePro())) {
                this.putEstateValue("PREISE", "MIETE_PRO", "MONAT", estateImpl);
            } else if (WazZeiteinheitenTyp.TAG.equals((Object)type.getPauschalmiete().getMietePro())) {
                this.putEstateValue("PREISE", "MIETE_PRO", "TAG", estateImpl);
            } else if (WazZeiteinheitenTyp.WOCHE.equals((Object)type.getPauschalmiete().getMietePro())) {
                this.putEstateValue("PREISE", "MIETE_PRO", "WOCHE", estateImpl);
            }
        }
        this.putEstateValue("FLAECHEN", "WOHNFLAECHE", type.getWohnflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_ZIMMER", type.getZimmer(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "PERS_LIFT", type.isAufzug(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "BALKON_TERRASSE", type.isBalkonTerrasse(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "BARRIEREFREI", type.isBarrierefrei(), estateImpl);
        if (Boolean.TRUE.equals(type.isGaesteWC())) {
            this.putEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl);
        }
        this.putEstateValue("AUSSTATTUNG", "GARTENNUTZUNG", type.isGartenBenutzung(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "KELLER", type.isKeller(), estateImpl);
        if (Boolean.TRUE.equals(type.isRollstuhlgerecht())) {
            this.putEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl);
        }
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readGeschlecht(type.getGeschlecht(), estateImpl);
        this.readHaustiere(type.getHaustiere(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readMoebliert(type.isMobilar(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readRaucher(type.isRaucherOk(), estateImpl);
        this.readStellplatz(type.getParkplatz(), estateImpl);
    }

    protected void convertImmobilie(WGZimmer.Type type, EstateImpl estateImpl) throws OpenEstateException {
        String string = "MIETE";
        String string2 = "WG";
        estateImpl.setType(string2, string);
        this.putEstateValue("FLAECHEN", "ANZ_BADEZIMMER", type.getAnzahlBadezimmer(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE", type.getEtage(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", type.getEtagenzahl(), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", type.getFreiAb(), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_BISDATE", type.getFreiBis(), estateImpl);
        this.putEstateValue("FLAECHEN", "GESAMTFLAECHE", type.getGesamtflaeche(), estateImpl);
        this.putEstateValue("FREITEXTE", "LAGE_BESCHR", type.getLage(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_ZIMMER", type.getZimmer(), estateImpl);
        this.putEstateValue("FLAECHEN", "WOHNFLAECHE", type.getZimmerflaeche(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "PERS_LIFT", type.isAufzug(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "BALKON_TERRASSE", type.isBalkonTerrasse(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "BARRIEREFREI", type.isBarrierefrei(), estateImpl);
        if (Boolean.TRUE.equals(type.isGaesteWC())) {
            this.putEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl);
        }
        this.putEstateValue("AUSSTATTUNG", "GARTENNUTZUNG", type.isGartenBenutzung(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "KELLER", type.isKeller(), estateImpl);
        if (type.getMietpreise() != null) {
            this.putEstateValue("PREISE", "HEIZKOSTEN", type.getMietpreise().getHeizkosten(), estateImpl);
            this.putEstateValue("PREISE", "KALTMIETE", type.getMietpreise().getKaltmiete(), estateImpl);
            this.putEstateValue("PREISE", "KAUTION", type.getMietpreise().getKaution(), estateImpl);
            this.putEstateValue("VERWALTUNG", "MIN_MIETDAUER", (Object)type.getMietpreise().getMindestmietdauer(), estateImpl);
            this.putEstateValue("PREISE", "NEBENKOSTEN", type.getMietpreise().getNebenkosten(), estateImpl);
            this.putEstateValue("PREISE", "WARMMIETE", type.getMietpreise().getWarmmiete(), estateImpl);
            this.putEstateValue("PREISE", "NEBENKOSTEN_INKL_HEIZKOSTEN", type.getMietpreise().isHeizkostenInWarmmieteEnthalten(), estateImpl);
        }
        this.readBodenBelag(type.getBodenbelag(), estateImpl);
        this.readGeschlecht(type.getGeschlechtGesuchterBewohner(), estateImpl);
        this.readHaustiere(type.getHaustiere(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readMoebliert(type.getMobilar(), estateImpl);
        this.readRaucher(type.getRauchen(), estateImpl);
        this.readTvAnschluss(type.getTVAnschluss(), estateImpl);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Boolean.TRUE.equals(type.isBadewanne())) {
            arrayList.add("WANNE");
        }
        if (Boolean.TRUE.equals(type.isDusche())) {
            arrayList.add("DUSCHE");
        }
        if (Boolean.TRUE.equals(type.isWaschmaschine())) {
            arrayList.add("ANSCHLUSS_WASCHMASCHINE");
        }
        if (!arrayList.isEmpty()) {
            this.putEstateValue("AUSSTATTUNG", "BAD", arrayList.toArray(new String[arrayList.size()]), estateImpl);
        }
    }

    protected void convertImmobilie(WohnungKauf.Type type, EstateImpl estateImpl) throws OpenEstateException {
        WohnungKategorienTyp wohnungKategorienTyp = type.getWohnungKategorie();
        String string = WohnungKategorienTyp.DACHGESCHOSS.equals((Object)wohnungKategorienTyp) ? "DACHWOHNUNG" : (WohnungKategorienTyp.ERDGESCHOSS.equals((Object)wohnungKategorienTyp) ? "ERDGESCHOSSWOHNUNG" : (WohnungKategorienTyp.ETAGENWOHNUNG.equals((Object)wohnungKategorienTyp) ? "ETAGENWOHNUNG" : (WohnungKategorienTyp.HOCHPARTERRE.equals((Object)wohnungKategorienTyp) ? "HOCHPARTERRE" : (WohnungKategorienTyp.LOFT.equals((Object)wohnungKategorienTyp) ? "LOFTWOHNUNG" : (WohnungKategorienTyp.MAISONETTE.equals((Object)wohnungKategorienTyp) ? "MAISONETTWOHNUNG" : (WohnungKategorienTyp.PENTHOUSE.equals((Object)wohnungKategorienTyp) ? "PENTHOUSEWOHNUNG" : (WohnungKategorienTyp.SONSTIGE.equals((Object)wohnungKategorienTyp) ? "WOHNUNG" : (WohnungKategorienTyp.SOUTERRAIN.equals((Object)wohnungKategorienTyp) ? "SOUTERRAINWOHNUNG" : (WohnungKategorienTyp.TERRASSENWOHNUNG.equals((Object)wohnungKategorienTyp) ? "TERRASSENWOHNUNG" : "WOHNUNG")))))))));
        estateImpl.setType(string, "KAUF");
        this.putEstateValue("FLAECHEN", "ANZ_BADEZIMMER", type.getAnzahlBadezimmer(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", type.getAnzahlGaragenStellplaetze(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_SCHLAFZIMMER", type.getAnzahlSchlafzimmer(), estateImpl);
        this.putEstateValue("ZUSTAND", "BAUJAHR", type.getBaujahr(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE", type.getEtage(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", type.getEtagenzahl(), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", type.getFreiAb(), estateImpl);
        this.putEstateValue("ZUSTAND", "SANIERUNG", type.getJahrLetzteModernisierung(), estateImpl);
        if (type.getKaufpreise() != null) {
            this.putEstateValue("PREISE", "KAUFPREIS", type.getKaufpreise().getKaufpreis(), estateImpl);
            this.putEstateValue("PREISE", "MIETEINNAHMEN_PRO_MONAT", type.getKaufpreise().getMieteinnahmenProMonat(), estateImpl);
            this.putEstateValue("PREISE", "STELLPLATZ_PREIS", type.getKaufpreise().getStellplatzKaufpreis(), estateImpl);
            this.putEstateValue("PREISE", "HAUSGELD", type.getKaufpreise().getWohngeld(), estateImpl);
        }
        this.putEstateValue("FLAECHEN", "NUTZFLAECHE", type.getNutzflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "WOHNFLAECHE", type.getWohnflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_ZIMMER", type.getZimmer(), estateImpl);
        this.putEstateValue("VERWALTUNG", "ALS_FERIEN", type.isAlsFerienwohnungGeeignet(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "PERS_LIFT", type.isAufzug(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "BALKON_TERRASSE", type.isBalkonTerrasse(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "BARRIEREFREI", type.isBarrierefrei(), estateImpl);
        if (Boolean.TRUE.equals(type.isBetreutesWohnen())) {
            this.putEstateValue("AUSSTATTUNG", "SERVICELEISTUNGEN", "BETREUTES_WOHNEN", estateImpl);
        }
        this.putEstateValue("VERWALTUNG", "DENKMALGESCHUETZT", type.isDenkmalschutzobjekt(), estateImpl);
        if (Boolean.TRUE.equals(type.isEinbaukueche())) {
            this.putEstateValue("AUSSTATTUNG", "KUECHE", "EINBAUKUECHE", estateImpl);
        }
        if (Boolean.TRUE.equals(type.isGaesteWC())) {
            this.putEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl);
        }
        this.putEstateValue("AUSSTATTUNG", "GARTENNUTZUNG", type.isGartenBenutzung(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "KELLER", type.isKeller(), estateImpl);
        if (Boolean.TRUE.equals(type.isRollstuhlgerecht())) {
            this.putEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl);
        }
        this.putEstateValue("AUSSTATTUNG", "VERMIETET", type.isVermietet(), estateImpl);
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readStellplatz(type.getParkplatz(), estateImpl);
    }

    protected void convertImmobilie(WohnungMiete.Type type, EstateImpl estateImpl) throws OpenEstateException {
        WohnungKategorienTyp wohnungKategorienTyp = type.getWohnungKategorie();
        String string = WohnungKategorienTyp.DACHGESCHOSS.equals((Object)wohnungKategorienTyp) ? "DACHWOHNUNG" : (WohnungKategorienTyp.ERDGESCHOSS.equals((Object)wohnungKategorienTyp) ? "ERDGESCHOSSWOHNUNG" : (WohnungKategorienTyp.ETAGENWOHNUNG.equals((Object)wohnungKategorienTyp) ? "ETAGENWOHNUNG" : (WohnungKategorienTyp.HOCHPARTERRE.equals((Object)wohnungKategorienTyp) ? "HOCHPARTERRE" : (WohnungKategorienTyp.LOFT.equals((Object)wohnungKategorienTyp) ? "LOFTWOHNUNG" : (WohnungKategorienTyp.MAISONETTE.equals((Object)wohnungKategorienTyp) ? "MAISONETTWOHNUNG" : (WohnungKategorienTyp.PENTHOUSE.equals((Object)wohnungKategorienTyp) ? "PENTHOUSEWOHNUNG" : (WohnungKategorienTyp.SONSTIGE.equals((Object)wohnungKategorienTyp) ? "WOHNUNG" : (WohnungKategorienTyp.SOUTERRAIN.equals((Object)wohnungKategorienTyp) ? "SOUTERRAINWOHNUNG" : (WohnungKategorienTyp.TERRASSENWOHNUNG.equals((Object)wohnungKategorienTyp) ? "TERRASSENWOHNUNG" : "WOHNUNG")))))))));
        estateImpl.setType(string, "MIETE");
        this.putEstateValue("FLAECHEN", "ANZ_BADEZIMMER", type.getAnzahlBadezimmer(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", type.getAnzahlGaragenStellplaetze(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_SCHLAFZIMMER", type.getAnzahlSchlafzimmer(), estateImpl);
        this.putEstateValue("ZUSTAND", "BAUJAHR", type.getBaujahr(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE", type.getEtage(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", type.getEtagenzahl(), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", type.getFreiAb(), estateImpl);
        this.putEstateValue("ZUSTAND", "SANIERUNG", type.getJahrLetzteModernisierung(), estateImpl);
        if (type.getMietpreise() != null) {
            this.putEstateValue("PREISE", "HEIZKOSTEN", type.getMietpreise().getHeizkosten(), estateImpl);
            this.putEstateValue("PREISE", "KALTMIETE", type.getMietpreise().getKaltmiete(), estateImpl);
            this.putEstateValue("PREISE", "KAUTION", type.getMietpreise().getKaution(), estateImpl);
            this.putEstateValue("PREISE", "NEBENKOSTEN", type.getMietpreise().getNebenkosten(), estateImpl);
            this.putEstateValue("PREISE", "STELLPLATZ_MIETE", type.getMietpreise().getStellplatzMiete(), estateImpl);
            this.putEstateValue("PREISE", "WARMMIETE", type.getMietpreise().getWarmmiete(), estateImpl);
            this.putEstateValue("PREISE", "NEBENKOSTEN_INKL_HEIZKOSTEN", type.getMietpreise().isHeizkostenInWarmmieteEnthalten(), estateImpl);
        }
        this.putEstateValue("FLAECHEN", "NUTZFLAECHE", type.getNutzflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "WOHNFLAECHE", type.getWohnflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_ZIMMER", type.getZimmer(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "PERS_LIFT", type.isAufzug(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "BALKON_TERRASSE", type.isBalkonTerrasse(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "BARRIEREFREI", type.isBarrierefrei(), estateImpl);
        if (Boolean.TRUE.equals(type.isBetreutesWohnen())) {
            this.putEstateValue("AUSSTATTUNG", "SERVICELEISTUNGEN", "BETREUTES_WOHNEN", estateImpl);
        }
        if (Boolean.TRUE.equals(type.isEinbaukueche())) {
            this.putEstateValue("AUSSTATTUNG", "KUECHE", "EINBAUKUECHE", estateImpl);
        }
        this.putEstateValue("VERWALTUNG", "WBS_SOZIALWOHNUNG", type.isFoerderung(), estateImpl);
        if (Boolean.TRUE.equals(type.isGaesteWC())) {
            this.putEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl);
        }
        this.putEstateValue("AUSSTATTUNG", "GARTENNUTZUNG", type.isGartenBenutzung(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "KELLER", type.isKeller(), estateImpl);
        if (Boolean.TRUE.equals(type.isRollstuhlgerecht())) {
            this.putEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl);
        }
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHaustiere(type.getHaustiere(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readStellplatz(type.getParkplatz(), estateImpl);
    }

    protected void convertImmobilie(Zwangsversteigerung.Type type, EstateImpl estateImpl) throws OpenEstateException {
        throw new OpenEstateException("'Zwangsversteigerung' is not supported at the moment!");
    }

    protected AgentImpl createEmptyAgent() {
        return new AgentImpl();
    }

    protected EstateImpl createEmptyEstate() {
        return new EstateImpl();
    }

    public SerializableXmlElement read(ImmobilienTransferTyp immobilienTransferTyp, int n) {
        switch (n) {
            case 0: {
                return this.readAgency(immobilienTransferTyp);
            }
            case 1: {
                return this.readTransfer(immobilienTransferTyp);
            }
        }
        throw new IllegalArgumentException("invalid convert-mode: " + n);
    }

    public AgencyImpl readAgency(ImmobilienTransferTyp immobilienTransferTyp) {
        this.getErrorMap().clear();
        if (immobilienTransferTyp.getAnbieter() == null) {
            throw new IllegalArgumentException("anbieter is missing!");
        }
        AgencyImpl agencyImpl = new AgencyImpl();
        AgentImpl agentImpl = this.convertAnbieter(immobilienTransferTyp.getAnbieter());
        agentImpl.setId("Agent.1");
        agencyImpl.setAgent(agentImpl);
        HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
        for (JAXBElement<?> object : immobilienTransferTyp.getAnbieter().getImmobilien()) {
            if (object.getValue() instanceof ImmobilieBaseTyp) {
                try {
                    EstateImpl estateImpl = this.convertImmobilie((ImmobilieBaseTyp)object.getValue(), hashMap);
                    if (estateImpl == null) continue;
                    estateImpl.getCustomValues().putCustomValue("is24.agent.id", immobilienTransferTyp.getAnbieter().getScoutKundenID(), 5);
                    agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not read agency-estate!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                continue;
            }
            LOGGER.warn((Object)"unsupported xml-item!");
            LOGGER.warn((Object)("> " + object.getName().toString()));
            LOGGER.warn((Object)("> " + object.getDeclaredType().toString()));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            agencyImpl.getContacts().put((String)entry.getKey(), (AgentContactImpl)entry.getValue());
        }
        return agencyImpl;
    }

    protected void readAustattungsQualitaet(AusstattungsqualitaetsTyp ausstattungsqualitaetsTyp, EstateImpl estateImpl) {
        String string;
        if (ausstattungsqualitaetsTyp == null) {
            return;
        }
        if (AusstattungsqualitaetsTyp.EINFACH.equals((Object)ausstattungsqualitaetsTyp)) {
            string = "EINFACH";
        } else if (AusstattungsqualitaetsTyp.GEHOBEN.equals((Object)ausstattungsqualitaetsTyp)) {
            string = "GEHOBEN";
        } else if (AusstattungsqualitaetsTyp.LUXUS.equals((Object)ausstattungsqualitaetsTyp)) {
            string = "LUXUS";
        } else if (AusstattungsqualitaetsTyp.NORMAL.equals((Object)ausstattungsqualitaetsTyp)) {
            string = "NORMAL";
        } else {
            return;
        }
        this.putEstateValue("AUSSTATTUNG", "AUSSTATTUNG_ART", string, estateImpl);
    }

    protected void readBauphase(BauphaseTyp bauphaseTyp, EstateImpl estateImpl) {
        String string;
        if (bauphaseTyp == null) {
            return;
        }
        if (BauphaseTyp.HAUS_FERTIG_GESTELLT.equals((Object)bauphaseTyp)) {
            string = "ABGESCHLOSSEN";
        } else if (BauphaseTyp.HAUS_IM_BAU.equals((Object)bauphaseTyp)) {
            string = "IM_BAU";
        } else if (BauphaseTyp.HAUS_IN_PLANUNG.equals((Object)bauphaseTyp)) {
            string = "IN_PLANUNG";
        } else {
            return;
        }
        this.putEstateValue("ZUSTAND", "BAUPHASE", string, estateImpl);
    }

    protected void readBebaubarMit(GrundstueckGewerbeEmpfohleneNutzung grundstueckGewerbeEmpfohleneNutzung, EstateImpl estateImpl) {
        if (grundstueckGewerbeEmpfohleneNutzung == null) {
            return;
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getAckerland() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "ACKER", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getBauerwartungsland() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "BAUERWARTUNG", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getBootsstaende() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "BOOTSSTAENDE", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getBuero() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "BUERO", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getCamping() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "CAMPING", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getDoppelhaus() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "DOPPELHAUS", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getEinfamilienhaus() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "EFH", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getEinzelhandelGross() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "EINZELHANDEL_GROSS", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getEinzelhandelKlein() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "EINZELHANDEL_KLEIN", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getGaragen() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "GARAGE", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getGarten() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "GARTEN", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getGastronomie() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "GASTRONOMIE", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getGewerbe() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "GEWERBE", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getHotel() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "HOTEL", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getIndustrie() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "INDUSTRIE", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getKeineBebauung() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "KEINE_BEBAUUNG", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getKleingewerbe() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "KLEINGEWERBE", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getLager() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "LAGER", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getMehrfamilienhaus() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "MFH", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getObstpflanzung() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "OBSTPFLANZUNG", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getParkhaus() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "PARKHAUS", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getProduktion() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "PRODUKTION", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getReihenhaus() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "REIHENHAUS", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getStellplaetze() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "STELLPLAETZE", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getVilla() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "VILLA", estateImpl);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getWald() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "WALD", estateImpl);
        }
    }

    protected void readBebaubarMit(GrundstueckWohnenEmpfohleneNutzung grundstueckWohnenEmpfohleneNutzung, EstateImpl estateImpl) {
        if (grundstueckWohnenEmpfohleneNutzung == null) {
            return;
        }
        if (grundstueckWohnenEmpfohleneNutzung.getAckerland() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "ACKER", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getBauerwartungsland() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "BAUERWARTUNG", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getBootsstaende() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "BOOTSSTAENDE", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getBuero() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "BUERO", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getCamping() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "CAMPING", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getDoppelhaus() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "DOPPELHAUS", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getEinfamilienhaus() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "EFH", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getEinzelhandelGross() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "EINZELHANDEL_GROSS", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getEinzelhandelKlein() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "EINZELHANDEL_KLEIN", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getGaragen() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "GARAGE", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getGarten() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "GARTEN", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getGastronomie() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "GASTRONOMIE", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getGewerbe() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "GEWERBE", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getHotel() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "HOTEL", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getIndustrie() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "INDUSTRIE", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getKeineBebauung() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "KEINE_BEBAUUNG", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getKleingewerbe() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "KLEINGEWERBE", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getLager() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "LAGER", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getMehrfamilienhaus() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "MFH", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getObstpflanzung() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "OBSTPFLANZUNG", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getParkhaus() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "PARKHAUS", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getProduktion() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "PRODUKTION", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getReihenhaus() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "REIHENHAUS", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getStellplaetze() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "STELLPLAETZE", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getVilla() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "VILLA", estateImpl);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getWald() != null) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "WALD", estateImpl);
        }
    }

    protected void readBebaubarNach(BebaubarNachTyp bebaubarNachTyp, EstateImpl estateImpl) {
        String string;
        if (bebaubarNachTyp == null) {
            return;
        }
        if (BebaubarNachTyp.BAUGB_30.equals((Object)bebaubarNachTyp)) {
            string = "BEBAUUNGSPLAN";
        } else if (BebaubarNachTyp.BAUGB_34.equals((Object)bebaubarNachTyp)) {
            string = "NACHBARBEBAUUNG";
        } else if (BebaubarNachTyp.BAUGB_35.equals((Object)bebaubarNachTyp)) {
            string = "AUSSENGEBIET";
        } else {
            return;
        }
        this.putEstateValue("VERWALTUNG", "BEBAUBAR_NACH", string, estateImpl);
    }

    protected void readBefeuerungsArt(BefeuerungsArtTyp befeuerungsArtTyp, EstateImpl estateImpl) {
        if (befeuerungsArtTyp == null) {
            return;
        }
        if (befeuerungsArtTyp.getErdwaerme() != null) {
            this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "ERDWAERME", estateImpl);
        }
        if (befeuerungsArtTyp.getFernwaerme() != null) {
            this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "FERNWAERME", estateImpl);
        }
        if (befeuerungsArtTyp.getGas() != null) {
            this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "GAS", estateImpl);
        }
        if (befeuerungsArtTyp.getKohle() != null) {
            this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "KOHLE", estateImpl);
        }
        if (befeuerungsArtTyp.getOel() != null) {
            this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "OEL", estateImpl);
        }
        if (befeuerungsArtTyp.getPelletheizung() != null) {
            this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "PELLETS", estateImpl);
        }
        if (befeuerungsArtTyp.getSolarheizung() != null) {
            this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "SOLAR", estateImpl);
        }
        if (befeuerungsArtTyp.getStrom() != null) {
            this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "ELEKTRO", estateImpl);
        }
    }

    protected void readBodenBelag(BodenbelagTyp bodenbelagTyp, EstateImpl estateImpl) {
        String string;
        if (bodenbelagTyp == null) {
            return;
        }
        if (BodenbelagTyp.BETON.equals((Object)bodenbelagTyp)) {
            string = "BETON";
        } else if (BodenbelagTyp.DIELEN.equals((Object)bodenbelagTyp)) {
            string = "DIELEN";
        } else if (BodenbelagTyp.EPOXIDHARZ.equals((Object)bodenbelagTyp)) {
            string = "EPOXIDHARZ";
        } else if (BodenbelagTyp.FLIESEN.equals((Object)bodenbelagTyp)) {
            string = "FLIESEN";
        } else if (BodenbelagTyp.LAMINAT.equals((Object)bodenbelagTyp)) {
            string = "LAMINAT";
        } else if (BodenbelagTyp.NACH_WUNSCH.equals((Object)bodenbelagTyp)) {
            string = "NACH_WUNSCH";
        } else if (BodenbelagTyp.PARKETT.equals((Object)bodenbelagTyp)) {
            string = "PARKETT";
        } else if (BodenbelagTyp.PVC.equals((Object)bodenbelagTyp)) {
            string = "PVC";
        } else if (BodenbelagTyp.STEIN.equals((Object)bodenbelagTyp)) {
            string = "STEIN";
        } else if (BodenbelagTyp.TEPPICHBODEN.equals((Object)bodenbelagTyp)) {
            string = "TEPPICH";
        } else if (BodenbelagTyp.TEPPICHBODEN_ANTISTATISCH.equals((Object)bodenbelagTyp)) {
            string = "TEPPICH_ANTISTAT";
        } else if (BodenbelagTyp.TEPPICHFLIESEN_STUHLROLLENFEST.equals((Object)bodenbelagTyp)) {
            string = "TEPPICH";
        } else {
            return;
        }
        this.putEstateValue("AUSSTATTUNG", "BODENBELAG", string, estateImpl);
    }

    protected void readBodenBelag(BodenbelagWohnenTyp bodenbelagWohnenTyp, EstateImpl estateImpl) {
        String string;
        if (bodenbelagWohnenTyp == null) {
            return;
        }
        if (BodenbelagWohnenTyp.DIELEN.equals((Object)bodenbelagWohnenTyp)) {
            string = "DIELEN";
        } else if (BodenbelagWohnenTyp.FLIESEN.equals((Object)bodenbelagWohnenTyp)) {
            string = "FLIESEN";
        } else if (BodenbelagWohnenTyp.LAMINAT.equals((Object)bodenbelagWohnenTyp)) {
            string = "LAMINAT";
        } else if (BodenbelagWohnenTyp.PARKETT.equals((Object)bodenbelagWohnenTyp)) {
            string = "PARKETT";
        } else if (BodenbelagWohnenTyp.PVC.equals((Object)bodenbelagWohnenTyp)) {
            string = "PVC";
        } else if (BodenbelagWohnenTyp.TEPPICHBODEN.equals((Object)bodenbelagWohnenTyp)) {
            string = "TEPPICH";
        } else {
            return;
        }
        this.putEstateValue("AUSSTATTUNG", "BODENBELAG", string, estateImpl);
    }

    protected void readDatenVerkabelung(DatenVerkabelungsTyp datenVerkabelungsTyp, EstateImpl estateImpl) {
        if (datenVerkabelungsTyp == null) {
            return;
        }
        if (!DatenVerkabelungsTyp.JA.equals((Object)datenVerkabelungsTyp) && !DatenVerkabelungsTyp.TRUE.equals((Object)datenVerkabelungsTyp)) {
            return;
        }
        this.putEstateValue("AUSSTATTUNG", "TECHNIK", "DV_VERKABELUNG", estateImpl);
    }

    protected void readEnergieAusweis(EnergieausweisTyp energieausweisTyp, EstateImpl estateImpl) {
        if (energieausweisTyp == null) {
            return;
        }
        Double d = energieausweisTyp.getEnergieverbrauchskennwert();
        boolean bl = false;
        if (d != null && EnergieausweistypTyp.ENDENERGIEBEDARF.equals((Object)energieausweisTyp.getEnergieausweistyp())) {
            bl = true;
            this.putEstateValue("ENERGIEPASS", "ART", "BEDARF", estateImpl);
            this.putEstateValue("ENERGIEPASS", "BEDARF_GESAMT", d, estateImpl);
        } else if (d != null && EnergieausweistypTyp.ENERGIEVERBRAUCHSKENNWERT.equals((Object)energieausweisTyp.getEnergieausweistyp())) {
            bl = true;
            this.putEstateValue("ENERGIEPASS", "ART", "VERBRAUCH", estateImpl);
            this.putEstateValue("ENERGIEPASS", "VERBRAUCH_GESAMT", d, estateImpl);
            this.putEstateValue("ENERGIEPASS", "VERBRAUCH_INKL_WARMWASSER", energieausweisTyp.isWarmwasserEnthalten(), estateImpl);
        }
        this.putEstateValue("ENERGIEPASS", "VORHANDEN", bl, estateImpl);
        if (bl && estateImpl.getAdress() != null) {
            this.putEstateValue("ENERGIEPASS", "KLASSE", OpenEstateUtils.getEnergyCertificateClass(d, estateImpl.getAdress().getCountry()), estateImpl);
        }
    }

    protected void readErschliessungZustand(ErschliessungszustandTyp erschliessungszustandTyp, EstateImpl estateImpl) {
        String string;
        if (erschliessungszustandTyp == null) {
            return;
        }
        if (ErschliessungszustandTyp.ERSCHLOSSEN.equals((Object)erschliessungszustandTyp)) {
            string = "VOLLERSCHLOSSEN";
        } else if (ErschliessungszustandTyp.TEILERSCHLOSSEN.equals((Object)erschliessungszustandTyp)) {
            string = "TEILERSCHLOSSEN";
        } else if (ErschliessungszustandTyp.UNERSCHLOSSEN.equals((Object)erschliessungszustandTyp)) {
            string = "UNERSCHLOSSEN";
        } else {
            return;
        }
        this.putEstateValue("ZUSTAND", "ERSCHLIESSUNG", string, estateImpl);
    }

    protected void readGeschlecht(GeschlechtTyp geschlechtTyp, EstateImpl estateImpl) {
        String string;
        if (geschlechtTyp == null) {
            return;
        }
        if (GeschlechtTyp.KEINE_EINSCHRAENKUNG.equals((Object)geschlechtTyp)) {
            string = "EGAL";
        } else if (GeschlechtTyp.NUR_FRAUEN.equals((Object)geschlechtTyp)) {
            string = "FRAU";
        } else if (GeschlechtTyp.NUR_MAENNER.equals((Object)geschlechtTyp)) {
            string = "MANN";
        } else {
            return;
        }
        this.putEstateValue("VERWALTUNG", "GESCHLECHT", string, estateImpl);
    }

    protected void readGeschlecht(WGZimmerGeschlechtTyp wGZimmerGeschlechtTyp, EstateImpl estateImpl) {
        String string;
        if (wGZimmerGeschlechtTyp == null) {
            return;
        }
        if (WGZimmerGeschlechtTyp.MAENNLICH_ODER_WEIBLICH.equals((Object)wGZimmerGeschlechtTyp)) {
            string = "EGAL";
        } else if (WGZimmerGeschlechtTyp.WEIBLICH.equals((Object)wGZimmerGeschlechtTyp)) {
            string = "FRAU";
        } else if (WGZimmerGeschlechtTyp.MAENNLICH.equals((Object)wGZimmerGeschlechtTyp)) {
            string = "MANN";
        } else {
            return;
        }
        this.putEstateValue("VERWALTUNG", "GESCHLECHT", string, estateImpl);
    }

    protected void readHaustiere(GenehmigungTyp genehmigungTyp, EstateImpl estateImpl) {
        String string;
        if (genehmigungTyp == null) {
            return;
        }
        if (GenehmigungTyp.ERLAUBT.equals((Object)genehmigungTyp)) {
            string = "JA";
        } else if (GenehmigungTyp.NACH_VEREINBARUNG.equals((Object)genehmigungTyp)) {
            string = "VEREINBARUNG";
        } else if (GenehmigungTyp.VERBOTEN.equals((Object)genehmigungTyp)) {
            string = "NEIN";
        } else {
            return;
        }
        this.putEstateValue("VERWALTUNG", "HAUSTIERE", string, estateImpl);
    }

    protected void readHeizungsArt(HeizungsartTyp heizungsartTyp, EstateImpl estateImpl) {
        String string;
        if (heizungsartTyp == null) {
            return;
        }
        if (HeizungsartTyp.ETAGENHEIZUNG.equals((Object)heizungsartTyp)) {
            string = "ETAGE";
        } else if (HeizungsartTyp.OFENHEIZUNG.equals((Object)heizungsartTyp)) {
            string = "OFEN";
        } else if (HeizungsartTyp.ZENTRALHEIZUNG.equals((Object)heizungsartTyp)) {
            string = "ZENTRAL";
        } else {
            return;
        }
        this.putEstateValue("AUSSTATTUNG", "HEIZUNGSART", string, estateImpl);
    }

    protected void readKlimaanlage(JaNeinVereinbarungTyp jaNeinVereinbarungTyp, EstateImpl estateImpl) {
        Boolean bl;
        if (jaNeinVereinbarungTyp == null) {
            return;
        }
        if (JaNeinVereinbarungTyp.JA.equals((Object)jaNeinVereinbarungTyp)) {
            bl = Boolean.TRUE;
        } else if (JaNeinVereinbarungTyp.NEIN.equals((Object)jaNeinVereinbarungTyp)) {
            bl = Boolean.FALSE;
        } else {
            return;
        }
        this.putEstateValue("AUSSTATTUNG", "KLIMATISIERT", bl, estateImpl);
    }

    protected void readKranbahn(HebeanlageTyp hebeanlageTyp, EstateImpl estateImpl) {
        if (hebeanlageTyp == null) {
            return;
        }
        this.putEstateValue("AUSSTATTUNG", "KRAN", Boolean.TRUE, estateImpl);
        this.putEstateValue("AUSSTATTUNG", "KRAN_GEWICHT", hebeanlageTyp.getTragkraft(), estateImpl);
    }

    protected void readLageArt(LageartTyp lageartTyp, EstateImpl estateImpl) {
        String string;
        if (lageartTyp == null) {
            return;
        }
        if (LageartTyp.A_LAGE.equals((Object)lageartTyp)) {
            string = "A_LAGE";
        } else if (LageartTyp.B_LAGE.equals((Object)lageartTyp)) {
            string = "B_LAGE";
        } else if (LageartTyp.EINKAUFSZENTRUM.equals((Object)lageartTyp)) {
            string = "EINKAUFSZENTRUM";
        } else {
            return;
        }
        this.putEstateValue("UMFELD", "LAGE_GEWERBE", string, estateImpl);
    }

    protected void readLastenaufzug(HebeanlageTyp hebeanlageTyp, EstateImpl estateImpl) {
        if (hebeanlageTyp == null) {
            return;
        }
        this.putEstateValue("AUSSTATTUNG", "LAST_LIFT", Boolean.TRUE, estateImpl);
        this.putEstateValue("AUSSTATTUNG", "LAST_LIFT_GEWICHT", hebeanlageTyp.getTragkraft(), estateImpl);
    }

    protected void readMoebliert(Boolean bl, EstateImpl estateImpl) {
        String string;
        if (bl == null) {
            return;
        }
        if (Boolean.TRUE.equals(bl)) {
            string = "JA";
        } else if (Boolean.FALSE.equals(bl)) {
            string = "NEIN";
        } else {
            return;
        }
        this.putEstateValue("AUSSTATTUNG", "MOEBLIERT", string, estateImpl);
    }

    protected void readMoebliert(MobilarTyp mobilarTyp, EstateImpl estateImpl) {
        String string;
        if (mobilarTyp == null) {
            return;
        }
        if (MobilarTyp.JA.equals((Object)mobilarTyp)) {
            string = "JA";
        } else if (MobilarTyp.NEIN.equals((Object)mobilarTyp)) {
            string = "NEIN";
        } else {
            return;
        }
        this.putEstateValue("AUSSTATTUNG", "MOEBLIERT", string, estateImpl);
    }

    protected void readObjektZulieferung(ZulieferungTyp zulieferungTyp, EstateImpl estateImpl) {
        String string;
        if (zulieferungTyp == null) {
            return;
        }
        if (ZulieferungTyp.DIREKTER_ZUGANG.equals((Object)zulieferungTyp)) {
            string = "DIREKT";
        } else if (ZulieferungTyp.GANZTAEGIG.equals((Object)zulieferungTyp)) {
            string = "GANZTAEGIG";
        } else if (ZulieferungTyp.KEINE_DIREKTE_ANFAHRT.equals((Object)zulieferungTyp)) {
            string = "NICHT_DIREKT";
        } else if (ZulieferungTyp.PKW_ZUFAHRT.equals((Object)zulieferungTyp)) {
            string = "PKW_ZUFAHRT";
        } else if (ZulieferungTyp.VON_HINTEN.equals((Object)zulieferungTyp)) {
            string = "VON_HINTEN";
        } else if (ZulieferungTyp.VON_VORN.equals((Object)zulieferungTyp)) {
            string = "VON_VORN";
        } else if (ZulieferungTyp.VORMITTAGS.equals((Object)zulieferungTyp)) {
            string = "VORMITTAGS";
        } else {
            return;
        }
        this.putEstateValue("UMFELD", "ZULIEFERUNG", string, estateImpl);
    }

    protected void readObjektZustand(ObjektZustandTyp objektZustandTyp, EstateImpl estateImpl) {
        String string;
        if (objektZustandTyp == null) {
            return;
        }
        if (ObjektZustandTyp.ABBRUCHREIF.equals((Object)objektZustandTyp)) {
            string = "ABRISSOBJEKT";
        } else if (ObjektZustandTyp.ERSTBEZUG.equals((Object)objektZustandTyp)) {
            string = "ERSTBEZUG";
        } else if (ObjektZustandTyp.ERSTBEZUG_NACH_SANIERUNG.equals((Object)objektZustandTyp)) {
            string = "ERSTBEZUG_NACH_SANIERUNG";
        } else if (ObjektZustandTyp.GEPFLEGT.equals((Object)objektZustandTyp)) {
            string = "GEPFLEGT";
        } else if (ObjektZustandTyp.MODERNISIERT.equals((Object)objektZustandTyp)) {
            string = "MODERNISIERT";
        } else if (ObjektZustandTyp.NACH_VEREINBARUNG.equals((Object)objektZustandTyp)) {
            string = "NACH_VEREINBARUNG";
        } else if (ObjektZustandTyp.NEUWERTIG.equals((Object)objektZustandTyp)) {
            string = "NEUWERTIG";
        } else if (ObjektZustandTyp.RENOVIERUNGSBEDUERFTIG.equals((Object)objektZustandTyp)) {
            string = "RENOVIERT_TEIL";
        } else if (ObjektZustandTyp.SANIERT.equals((Object)objektZustandTyp)) {
            string = "SANIERT_VOLL";
        } else if (ObjektZustandTyp.UNRENOVIERT.equals((Object)objektZustandTyp)) {
            string = "RENOVIERUNGSBEDARF_VOLL";
        } else if (ObjektZustandTyp.VOLLSTAENDIG_REONVIERT.equals((Object)objektZustandTyp)) {
            string = "RENOVIERT_VOLL";
        } else {
            return;
        }
        this.putEstateValue("ZUSTAND", "ZUSTAND", string, estateImpl);
    }

    protected void readObjektZustand(WazObjektZustandTyp wazObjektZustandTyp, EstateImpl estateImpl) {
        String string;
        if (wazObjektZustandTyp == null) {
            return;
        }
        if (WazObjektZustandTyp.ABBRUCHREIF.equals((Object)wazObjektZustandTyp)) {
            string = "ABRISSOBJEKT";
        } else if (WazObjektZustandTyp.ERSTBEZUG.equals((Object)wazObjektZustandTyp)) {
            string = "ERSTBEZUG";
        } else if (WazObjektZustandTyp.ERSTBEZUG_NACH_SANIERUNG.equals((Object)wazObjektZustandTyp)) {
            string = "ERSTBEZUG_NACH_SANIERUNG";
        } else if (WazObjektZustandTyp.GEPFLEGT.equals((Object)wazObjektZustandTyp)) {
            string = "GEPFLEGT";
        } else if (WazObjektZustandTyp.MODERNISIERT.equals((Object)wazObjektZustandTyp)) {
            string = "MODERNISIERT";
        } else if (WazObjektZustandTyp.NACH_VEREINBARUNG.equals((Object)wazObjektZustandTyp)) {
            string = "NACH_VEREINBARUNG";
        } else if (WazObjektZustandTyp.NEUWERTIG.equals((Object)wazObjektZustandTyp)) {
            string = "NEUWERTIG";
        } else if (WazObjektZustandTyp.RENOVIERUNGSBEDUERFTIG.equals((Object)wazObjektZustandTyp)) {
            string = "RENOVIERT_TEIL";
        } else if (WazObjektZustandTyp.SANIERT.equals((Object)wazObjektZustandTyp)) {
            string = "SANIERT_VOLL";
        } else if (WazObjektZustandTyp.UNRENOVIERT.equals((Object)wazObjektZustandTyp)) {
            string = "RENOVIERUNGSBEDARF_VOLL";
        } else if (WazObjektZustandTyp.VOLLSTAENDIG_RENOVIERT.equals((Object)wazObjektZustandTyp)) {
            string = "RENOVIERT_VOLL";
        } else {
            return;
        }
        this.putEstateValue("ZUSTAND", "ZUSTAND", string, estateImpl);
    }

    protected void readRaucher(Boolean bl, EstateImpl estateImpl) {
        String string;
        if (bl == null) {
            return;
        }
        if (Boolean.TRUE.equals(bl)) {
            string = "NEIN";
        } else if (Boolean.FALSE.equals(bl)) {
            string = "JA";
        } else {
            return;
        }
        this.putEstateValue("VERWALTUNG", "NICHTRAUCHER", string, estateImpl);
    }

    protected void readRaucher(RauchenTyp rauchenTyp, EstateImpl estateImpl) {
        String string;
        if (rauchenTyp == null) {
            return;
        }
        if (RauchenTyp.ERLAUBT.equals((Object)rauchenTyp)) {
            string = "NEIN";
        } else if (RauchenTyp.UNERWUENSCHT.equals((Object)rauchenTyp)) {
            string = "JA";
        } else {
            return;
        }
        this.putEstateValue("VERWALTUNG", "NICHTRAUCHER", string, estateImpl);
    }

    protected void readStellplatz(StellplatzKategorieTyp stellplatzKategorieTyp, EstateImpl estateImpl) {
        String string;
        if (stellplatzKategorieTyp == null) {
            return;
        }
        if (StellplatzKategorieTyp.AUSSEN_STELLPLATZ.equals((Object)stellplatzKategorieTyp)) {
            string = "AUSSEN";
        } else if (StellplatzKategorieTyp.CARPORT.equals((Object)stellplatzKategorieTyp)) {
            string = "CARPORT";
        } else if (StellplatzKategorieTyp.DUPLEX.equals((Object)stellplatzKategorieTyp)) {
            string = "DUPLEX";
        } else if (StellplatzKategorieTyp.GARAGE.equals((Object)stellplatzKategorieTyp)) {
            string = "GARAGE";
        } else if (StellplatzKategorieTyp.PARKHAUS.equals((Object)stellplatzKategorieTyp)) {
            string = "PARKHAUS";
        } else if (StellplatzKategorieTyp.TIEFGARAGE.equals((Object)stellplatzKategorieTyp)) {
            string = "TIEFGARAGE";
        } else if (StellplatzKategorieTyp.TRUE.equals((Object)stellplatzKategorieTyp)) {
            string = "STELLPLATZ";
        } else {
            return;
        }
        this.putEstateValue("FLAECHEN", "STELLPLATZART", string, estateImpl);
    }

    public TransferImpl readTransfer(ImmobilienTransferTyp immobilienTransferTyp) {
        this.getErrorMap().clear();
        if (immobilienTransferTyp.getAnbieter() == null) {
            throw new IllegalArgumentException("anbieter is missing!");
        }
        TransferImpl transferImpl = new TransferImpl();
        transferImpl.setSenderSoftwareName(immobilienTransferTyp.getErstellerSoftware());
        transferImpl.setSenderSoftwareVersion(immobilienTransferTyp.getErstellerSoftwareVersion());
        TransferAgencyImpl transferAgencyImpl = new TransferAgencyImpl();
        transferAgencyImpl.setRemoveUnmodifiedEstates(false);
        transferAgencyImpl.setAgent(this.convertAnbieter(immobilienTransferTyp.getAnbieter()));
        transferAgencyImpl.getAgent().setId("Agent.1");
        HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
        for (JAXBElement<?> object : immobilienTransferTyp.getAnbieter().getImmobilien()) {
            if (object.getValue() instanceof ImmobilieBaseTyp) {
                Object object2;
                ImmobilieBaseTyp immobilieBaseTyp = (ImmobilieBaseTyp)object.getValue();
                if (AktionsTyp.LOESCHEN.equals((Object)immobilieBaseTyp.getImportmodus())) {
                    object2 = StringUtils.trimToNull((String)immobilieBaseTyp.getAnbieterObjektID());
                    if (object2 == null) {
                        LOGGER.warn((Object)"Can't read estate-id for deletion!");
                        continue;
                    }
                    if (transferAgencyImpl.getEstateIdsToRemove().contains(object2)) {
                        LOGGER.warn((Object)"Estate-id for deletion is defined more then once!");
                        continue;
                    }
                    transferAgencyImpl.getEstateIdsToRemove().add((String)object2);
                    continue;
                }
                try {
                    object2 = this.convertImmobilie(immobilieBaseTyp, hashMap);
                    if (object2 == null) continue;
                    ((EstateImpl)object2).getCustomValues().putCustomValue("is24.agent.id", immobilienTransferTyp.getAnbieter().getScoutKundenID(), 5);
                    transferAgencyImpl.getEstatesToSave().add((EstateImpl)object2);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not read transfer-estate!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                continue;
            }
            LOGGER.warn((Object)"unsupported xml-item!");
            LOGGER.warn((Object)("> " + object.getName().toString()));
            LOGGER.warn((Object)("> " + object.getDeclaredType().toString()));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            transferAgencyImpl.getContacts().put((String)entry.getKey(), (AgentContactImpl)entry.getValue());
        }
        transferImpl.getAgencies().add(transferAgencyImpl);
        return transferImpl;
    }

    protected void readTvAnschluss(TVAnschlussTyp tVAnschlussTyp, EstateImpl estateImpl) {
        String string;
        if (tVAnschlussTyp == null) {
            return;
        }
        if (TVAnschlussTyp.KABEL.equals((Object)tVAnschlussTyp)) {
            string = "KABEL_TV";
        } else if (TVAnschlussTyp.KABEL_UND_SATELLIT.equals((Object)tVAnschlussTyp)) {
            string = "KABEL_SAT_TV";
        } else if (TVAnschlussTyp.SATELLIT.equals((Object)tVAnschlussTyp)) {
            string = "SAT_TV";
        } else {
            return;
        }
        this.putEstateValue("AUSSTATTUNG", "TECHNIK", string, estateImpl);
    }

    protected void readVermarktung(VermarktungGewerbeTyp vermarktungGewerbeTyp, EstateImpl estateImpl) {
        if (vermarktungGewerbeTyp == null) {
            return;
        }
        if (vermarktungGewerbeTyp.getKauf() != null) {
            this.putEstateValue("PREISE", "STELLPLATZ_PREIS", vermarktungGewerbeTyp.getPreisParkflaeche(), estateImpl);
            VermarktungGewerbeTyp.Kauf kauf = (VermarktungGewerbeTyp.Kauf)vermarktungGewerbeTyp.getKauf().getValue();
            if (kauf != null) {
                this.putEstateValue("PREISE", "KAUFPREIS", kauf.getPreis(), estateImpl);
            }
        } else if (vermarktungGewerbeTyp.getMiete() != null) {
            this.putEstateValue("PREISE", "STELLPLATZ_MIETE", vermarktungGewerbeTyp.getPreisParkflaeche(), estateImpl);
            VermarktungGewerbeTyp.Miete miete = (VermarktungGewerbeTyp.Miete)vermarktungGewerbeTyp.getMiete().getValue();
            if (miete != null) {
                this.putEstateValue("PREISE", "KAUTION", miete.getKaution(), estateImpl);
                this.putEstateValue("PREISE", MieteEinheitTyp.QUADRATMETER.equals((Object)miete.getPro()) ? "KALTMIETE_QM" : "KALTMIETE", miete.getKaltmiete(), estateImpl);
            }
        }
        this.putEstateValue("PREISE", "NEBENKOSTEN", vermarktungGewerbeTyp.getNebenkosten(), estateImpl);
    }

    protected void readVermarktung(VermarktungGewerbeTyp2 vermarktungGewerbeTyp2, EstateImpl estateImpl) {
        if (vermarktungGewerbeTyp2 == null) {
            return;
        }
        if (vermarktungGewerbeTyp2.getKauf() != null) {
            this.putEstateValue("PREISE", "KAUFPREIS", vermarktungGewerbeTyp2.getPreis(), estateImpl);
            this.putEstateValue("PREISE", "STELLPLATZ_PREIS", vermarktungGewerbeTyp2.getPreisProParkflaeche(), estateImpl);
        } else if (vermarktungGewerbeTyp2.getMiete() != null) {
            this.putEstateValue("PREISE", "KALTMIETE", vermarktungGewerbeTyp2.getPreis(), estateImpl);
            this.putEstateValue("PREISE", "STELLPLATZ_MIETE", vermarktungGewerbeTyp2.getPreisProParkflaeche(), estateImpl);
            VermarktungGewerbeTyp2.Miete miete = vermarktungGewerbeTyp2.getMiete();
            if (miete != null) {
                this.putEstateValue("PREISE", "KAUTION", miete.getKaution(), estateImpl);
            }
        }
        this.putEstateValue("PREISE", "NEBENKOSTEN", vermarktungGewerbeTyp2.getNebenkosten(), estateImpl);
    }

    protected void readVermarktung(VermarktungGrundstueckGewerbeTyp vermarktungGrundstueckGewerbeTyp, EstateImpl estateImpl) {
        if (vermarktungGrundstueckGewerbeTyp == null) {
            return;
        }
        if (vermarktungGrundstueckGewerbeTyp.getErbpacht() != null) {
            this.putEstateValue("PREISE", "PACHT", vermarktungGrundstueckGewerbeTyp.getPreis(), estateImpl);
            this.putEstateValue("VERWALTUNG", "ERBPACHT_DAUER", vermarktungGrundstueckGewerbeTyp.getErbpacht().getValue() != null ? ((VermarktungGrundstueckGewerbeTyp.Erbpacht)vermarktungGrundstueckGewerbeTyp.getErbpacht().getValue()).getDauerInJahren() : null, estateImpl);
        } else if (vermarktungGrundstueckGewerbeTyp.getKauf() != null) {
            this.putEstateValue("PREISE", "KAUFPREIS", vermarktungGrundstueckGewerbeTyp.getPreis(), estateImpl);
        } else if (vermarktungGrundstueckGewerbeTyp.getMiete() != null) {
            this.putEstateValue("PREISE", "KALTMIETE", vermarktungGrundstueckGewerbeTyp.getPreis(), estateImpl);
        } else if (vermarktungGrundstueckGewerbeTyp.getPacht() != null) {
            this.putEstateValue("PREISE", "PACHT", vermarktungGrundstueckGewerbeTyp.getPreis(), estateImpl);
        }
    }

    protected void readVermarktung(VermarktungGrundstueckWohnenKaufTyp vermarktungGrundstueckWohnenKaufTyp, EstateImpl estateImpl) {
        if (vermarktungGrundstueckWohnenKaufTyp == null) {
            return;
        }
        if (vermarktungGrundstueckWohnenKaufTyp.getErbpacht() != null) {
            this.putEstateValue("PREISE", "PACHT", vermarktungGrundstueckWohnenKaufTyp.getPreis(), estateImpl);
            this.putEstateValue("VERWALTUNG", "ERBPACHT_DAUER", vermarktungGrundstueckWohnenKaufTyp.getErbpacht().getValue() != null ? ((VermarktungGrundstueckWohnenKaufTyp.Erbpacht)vermarktungGrundstueckWohnenKaufTyp.getErbpacht().getValue()).getDauerInJahren() : null, estateImpl);
        } else if (vermarktungGrundstueckWohnenKaufTyp.getKauf() != null) {
            this.putEstateValue("PREISE", "KAUFPREIS", vermarktungGrundstueckWohnenKaufTyp.getPreis(), estateImpl);
        }
    }

    protected void readVermarktung(VermarktungGrundstueckWohnenMieteTyp vermarktungGrundstueckWohnenMieteTyp, EstateImpl estateImpl) {
        if (vermarktungGrundstueckWohnenMieteTyp == null) {
            return;
        }
        if (vermarktungGrundstueckWohnenMieteTyp.getMiete() != null) {
            this.putEstateValue("PREISE", "KALTMIETE", vermarktungGrundstueckWohnenMieteTyp.getPreis(), estateImpl);
        } else if (vermarktungGrundstueckWohnenMieteTyp.getPacht() != null) {
            this.putEstateValue("PREISE", "PACHT", vermarktungGrundstueckWohnenMieteTyp.getPreis(), estateImpl);
        }
    }
}

