/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.xml.is24.ObjectFactory;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IS24XmlUtils {
    private static final Logger LOGGER = Logger.getLogger(IS24XmlUtils.class);
    public static final String NAMESPACE = "http://www.immobilienscout24.de/immobilientransfer";
    public static final String PACKAGE = "com.openindex.openestate.impl.xml.is24";
    public static final String VERSION = "189438";
    private static final ObjectFactory FACTORY = new ObjectFactory();
    private static JAXBContext JAXB = null;

    private IS24XmlUtils() {
    }

    public static Marshaller createMarshaller() throws JAXBException {
        return IS24XmlUtils.createMarshaller(Charset.defaultCharset().name(), true);
    }

    public static Marshaller createMarshaller(String string, boolean bl) throws JAXBException {
        Marshaller marshaller = IS24XmlUtils.getContext().createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)string);
        marshaller.setProperty("jaxb.formatted.output", (Object)bl);
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        return IS24XmlUtils.getContext().createUnmarshaller();
    }

    public static JAXBContext getContext() throws JAXBException {
        if (JAXB == null) {
            JAXB = JAXBContext.newInstance((String)PACKAGE);
        }
        return JAXB;
    }

    public static ObjectFactory getFactory() {
        return FACTORY;
    }

    public static Double getFahrtwegDistanz(Long l) {
        if (l == null || l <= 0L) {
            return null;
        }
        return l.doubleValue() / 60.0 * 50.0;
    }

    public static Long getFahrtwegZeit(Double d) {
        if (d == null || d <= 0.0) {
            return null;
        }
        return ((Number)(d / 50.0 * 60.0)).longValue();
    }

    public static Double getFusswegDistanz(Long l) {
        if (l == null || l <= 0L) {
            return null;
        }
        return l.doubleValue() / 60.0 * 3.6;
    }

    public static Long getFusswegZeit(Double d) {
        if (d == null || d <= 0.0) {
            return null;
        }
        return ((Number)(d / 3.6 * 60.0)).longValue();
    }

    public static Double parsePreisAufAnfrage(String string) {
        return IS24XmlUtils.parseZahl(string, 15, 2, -0.01, 1.0E13);
    }

    public static String parseEmail(String string) {
        return string != null && string.length() <= 150 && string.matches(".*@.*\\..*") ? string : null;
    }

    private static String parseText(String string, int n) {
        return string;
    }

    public static String parseText4(String string) {
        return IS24XmlUtils.parseText(string, 4);
    }

    public static String parseText15(String string) {
        return IS24XmlUtils.parseText(string, 15);
    }

    public static String parseText20(String string) {
        return IS24XmlUtils.parseText(string, 20);
    }

    public static String parseText30(String string) {
        return IS24XmlUtils.parseText(string, 30);
    }

    public static String parseText40(String string) {
        return IS24XmlUtils.parseText(string, 40);
    }

    public static String parseText50(String string) {
        return IS24XmlUtils.parseText(string, 50);
    }

    public static String parseText80(String string) {
        return IS24XmlUtils.parseText(string, 80);
    }

    public static String parseText100(String string) {
        return IS24XmlUtils.parseText(string, 100);
    }

    public static String parseText150(String string) {
        return IS24XmlUtils.parseText(string, 150);
    }

    public static String parseText200(String string) {
        return IS24XmlUtils.parseText(string, 200);
    }

    public static String parseText255(String string) {
        return IS24XmlUtils.parseText(string, 255);
    }

    public static String parseText300(String string) {
        return IS24XmlUtils.parseText(string, 300);
    }

    public static String parseText500(String string) {
        return IS24XmlUtils.parseText(string, 500);
    }

    public static String parseText2000(String string) {
        return IS24XmlUtils.parseText(string, 2000);
    }

    public static URL parseWebUrl(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        try {
            return !string.toLowerCase().startsWith("http://") && !string.toLowerCase().startsWith("https://") ? new URL("http://" + string) : new URL(string);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)exception.getLocalizedMessage());
            return null;
        }
    }

    private static Long parseZahl(String string, int n) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMaximumIntegerDigits(n);
        try {
            Number number = numberFormat.parse(string);
            if (number.longValue() < 0L) {
                return null;
            }
            return number.longValue();
        }
        catch (Exception exception) {
            LOGGER.warn((Object)exception.getLocalizedMessage());
            return null;
        }
    }

    private static Double parseZahl(String string, int n, int n2, Double d, Double d2) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(n2);
        numberFormat.setMaximumIntegerDigits(n - n2);
        try {
            Number number = numberFormat.parse(string);
            if (d != null && number.doubleValue() <= d) {
                return null;
            }
            if (d2 != null && number.doubleValue() >= d2) {
                return null;
            }
            return number.doubleValue();
        }
        catch (Exception exception) {
            LOGGER.warn((Object)exception.getLocalizedMessage());
            return null;
        }
    }

    public static Long parseZahl2(String string) {
        return IS24XmlUtils.parseZahl(string, 2);
    }

    public static Long parseZahl3(String string) {
        return IS24XmlUtils.parseZahl(string, 3);
    }

    public static Long parseZahl4(String string) {
        return IS24XmlUtils.parseZahl(string, 4);
    }

    public static Long parseZahl5(String string) {
        return IS24XmlUtils.parseZahl(string, 5);
    }

    public static Long parseZahl8(String string) {
        return IS24XmlUtils.parseZahl(string, 8);
    }

    public static Long parseZahl10(String string) {
        return IS24XmlUtils.parseZahl(string, 10);
    }

    public static Long parseZahl20(String string) {
        return IS24XmlUtils.parseZahl(string, 20);
    }

    public static Double parseZahl31(String string) {
        return IS24XmlUtils.parseZahl(string, 3, 1, 0.0, 100.0);
    }

    public static Double parseZahl32(String string) {
        return IS24XmlUtils.parseZahl(string, 3, 2, 0.0, 10.0);
    }

    public static Double parseZahl42(String string) {
        return IS24XmlUtils.parseZahl(string, 4, 2, 0.0, 100.0);
    }

    public static Double parseZahl52(String string) {
        return IS24XmlUtils.parseZahl(string, 5, 2, 0.0, 1000.0);
    }

    public static Double parseZahl62(String string) {
        return IS24XmlUtils.parseZahl(string, 6, 2, 0.0, 10000.0);
    }

    public static Double parseZahl72(String string) {
        return IS24XmlUtils.parseZahl(string, 7, 2, 0.0, 100000.0);
    }

    public static Double parseZahl102(String string) {
        return IS24XmlUtils.parseZahl(string, 10, 2, 0.0, 1.0E8);
    }

    public static Double parseZahl152(String string) {
        return IS24XmlUtils.parseZahl(string, 15, 2, 0.0, 1.0E13);
    }

    public static Double parseZimmeranzahl(String string) {
        Double d = IS24XmlUtils.parseZahl62(string);
        if (d != null && d >= 0.5 && d <= 9999.0) {
            return d;
        }
        return null;
    }

    public static String printDate(Calendar calendar) {
        return calendar != null ? OpenEstateUtils.getXsdDateFormat().format(calendar.getTime()) : null;
    }

    public static String printEmail(String string) {
        return string != null && string.length() <= 150 && string.matches(".*@.*\\..*") ? string : null;
    }

    public static String printPreisAufAnfrage(Double d) {
        return IS24XmlUtils.printZahl(d, 15, 2, -0.01, 1.0E13);
    }

    private static String printText(String string, int n) {
        int n2 = (string = StringUtils.trimToEmpty((String)string)).length();
        if (n2 <= 0) {
            return null;
        }
        if (n2 <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String printText4(String string) {
        return IS24XmlUtils.printText(string, 4);
    }

    public static String printText15(String string) {
        return IS24XmlUtils.printText(string, 15);
    }

    public static String printText20(String string) {
        return IS24XmlUtils.printText(string, 20);
    }

    public static String printText30(String string) {
        return IS24XmlUtils.printText(string, 30);
    }

    public static String printText40(String string) {
        return IS24XmlUtils.printText(string, 40);
    }

    public static String printText50(String string) {
        return IS24XmlUtils.printText(string, 50);
    }

    public static String printText80(String string) {
        return IS24XmlUtils.printText(string, 80);
    }

    public static String printText100(String string) {
        return IS24XmlUtils.printText(string, 100);
    }

    public static String printText150(String string) {
        return IS24XmlUtils.printText(string, 150);
    }

    public static String printText200(String string) {
        return IS24XmlUtils.printText(string, 200);
    }

    public static String printText255(String string) {
        return IS24XmlUtils.printText(string, 255);
    }

    public static String printText300(String string) {
        return IS24XmlUtils.printText(string, 300);
    }

    public static String printText500(String string) {
        return IS24XmlUtils.printText(string, 500);
    }

    public static String printText2000(String string) {
        return IS24XmlUtils.printText(string, 2000);
    }

    public static String printWebUrl(URL uRL) {
        return uRL != null && uRL.getHost() != null && uRL.getHost().length() > 0 ? uRL.toString() : null;
    }

    private static String printZahl(Long l, int n) {
        if (l == null) {
            return null;
        }
        double d = Math.pow(10.0, n);
        if ((double)l.longValue() >= d) {
            return null;
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMaximumIntegerDigits(n);
        try {
            return numberFormat.format(l);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)exception.getLocalizedMessage());
            return null;
        }
    }

    private static String printZahl(Double d, int n, int n2, Double d2, Double d3) {
        if (d == null) {
            return null;
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(n2);
        numberFormat.setMaximumIntegerDigits(n - n2);
        try {
            double d4 = d;
            if (d2 != null && d4 <= d2) {
                return null;
            }
            if (d3 != null && d4 > d3) {
                return null;
            }
            return numberFormat.format(d4);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)exception.getLocalizedMessage());
            return null;
        }
    }

    public static String printZahl2(Long l) {
        if (l == null || l <= 0L) {
            return null;
        }
        return IS24XmlUtils.printZahl(l, 2);
    }

    public static String printZahl2Including0(Long l) {
        if (l == null || l < 0L) {
            return null;
        }
        return IS24XmlUtils.printZahl(l, 2);
    }

    public static String printZahl3(Long l) {
        if (l == null || l <= 0L) {
            return null;
        }
        return IS24XmlUtils.printZahl(l, 3);
    }

    public static String printZahl3Including0(Long l) {
        if (l == null || l < 0L) {
            return null;
        }
        return IS24XmlUtils.printZahl(l, 3);
    }

    public static String printZahl4(Long l) {
        if (l == null || l <= 0L) {
            return null;
        }
        return IS24XmlUtils.printZahl(l, 4);
    }

    public static String printZahl5(Long l) {
        if (l == null || l <= 0L) {
            return null;
        }
        return IS24XmlUtils.printZahl(l, 5);
    }

    public static String printZahl8(Long l) {
        if (l == null || l <= 0L) {
            return null;
        }
        return IS24XmlUtils.printZahl(l, 8);
    }

    public static String printZahl10(Long l) {
        if (l == null || l <= 0L) {
            return null;
        }
        return IS24XmlUtils.printZahl(l, 10);
    }

    public static String printZahl20(Long l) {
        if (l == null || l <= 0L) {
            return null;
        }
        return IS24XmlUtils.printZahl(l, 20);
    }

    public static String printZahl31(Double d) {
        if (d == null || d <= 0.0) {
            return null;
        }
        return IS24XmlUtils.printZahl(d, 3, 1, 0.0, 100.0);
    }

    public static String printZahl32(Double d) {
        if (d == null || d <= 0.0) {
            return null;
        }
        return IS24XmlUtils.printZahl(d, 3, 2, 0.0, 10.0);
    }

    public static String printZahl42(Double d) {
        if (d == null || d <= 0.0) {
            return null;
        }
        return IS24XmlUtils.printZahl(d, 4, 2, 0.0, 100.0);
    }

    public static String printZahl52(Double d) {
        if (d == null || d <= 0.0) {
            return null;
        }
        return IS24XmlUtils.printZahl(d, 5, 2, 0.0, 1000.0);
    }

    public static String printZahl62(Double d) {
        if (d == null || d <= 0.0) {
            return null;
        }
        return IS24XmlUtils.printZahl(d, 6, 2, 0.0, 10000.0);
    }

    public static String printZahl72(Double d) {
        if (d == null || d <= 0.0) {
            return null;
        }
        return IS24XmlUtils.printZahl(d, 7, 2, 0.0, 100000.0);
    }

    public static String printZahl102(Double d) {
        if (d == null || d <= 0.0) {
            return null;
        }
        return IS24XmlUtils.printZahl(d, 10, 2, 0.0, 1.0E8);
    }

    public static String printZahl152(Double d) {
        if (d == null || d <= 0.0) {
            return null;
        }
        return IS24XmlUtils.printZahl(d, 15, 2, 0.0, 1.0E13);
    }

    public static String printZimmeranzahl(Double d) {
        return d != null && d >= 0.5 && d <= 9999.0 ? IS24XmlUtils.printZahl62(d) : null;
    }
}

