/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateConverter;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.xml.IS24XmlUtils;
import com.openindex.openestate.impl.xml.is24.AktionsTyp;
import com.openindex.openestate.impl.xml.is24.Anlageobjekt;
import com.openindex.openestate.impl.xml.is24.AnlageobjekteKategorieTyp;
import com.openindex.openestate.impl.xml.is24.AusstattungsqualitaetsTyp;
import com.openindex.openestate.impl.xml.is24.BauphaseTyp;
import com.openindex.openestate.impl.xml.is24.BebaubarNachTyp;
import com.openindex.openestate.impl.xml.is24.BefeuerungsArtTyp;
import com.openindex.openestate.impl.xml.is24.BodenbelagTyp;
import com.openindex.openestate.impl.xml.is24.BodenbelagWohnenTyp;
import com.openindex.openestate.impl.xml.is24.BueroPraxis;
import com.openindex.openestate.impl.xml.is24.BueroPraxisKategorienTyp;
import com.openindex.openestate.impl.xml.is24.DatenVerkabelungsTyp;
import com.openindex.openestate.impl.xml.is24.Einzelhandel;
import com.openindex.openestate.impl.xml.is24.EinzelhandelKategorienTyp;
import com.openindex.openestate.impl.xml.is24.EnergieausweisTyp;
import com.openindex.openestate.impl.xml.is24.EnergieausweistypTyp;
import com.openindex.openestate.impl.xml.is24.ErschliessungszustandTyp;
import com.openindex.openestate.impl.xml.is24.GarageKauf;
import com.openindex.openestate.impl.xml.is24.GarageMiete;
import com.openindex.openestate.impl.xml.is24.GaragenKategorieTyp;
import com.openindex.openestate.impl.xml.is24.GastroKategorieTyp;
import com.openindex.openestate.impl.xml.is24.Gastronomie;
import com.openindex.openestate.impl.xml.is24.GenehmigungTyp;
import com.openindex.openestate.impl.xml.is24.GeschlechtTyp;
import com.openindex.openestate.impl.xml.is24.GrundstueckGewerbe;
import com.openindex.openestate.impl.xml.is24.GrundstueckGewerbeEmpfohleneNutzung;
import com.openindex.openestate.impl.xml.is24.GrundstueckGewerbeKategorienTyp;
import com.openindex.openestate.impl.xml.is24.GrundstueckWohnenEmpfohleneNutzung;
import com.openindex.openestate.impl.xml.is24.GrundstueckWohnenKategorienTyp;
import com.openindex.openestate.impl.xml.is24.GrundstueckWohnenKauf;
import com.openindex.openestate.impl.xml.is24.GrundstueckWohnenMiete;
import com.openindex.openestate.impl.xml.is24.HalleProduktion;
import com.openindex.openestate.impl.xml.is24.HalleProduktionKategorieTyp;
import com.openindex.openestate.impl.xml.is24.HausKategorienTyp;
import com.openindex.openestate.impl.xml.is24.HausKauf;
import com.openindex.openestate.impl.xml.is24.HausMiete;
import com.openindex.openestate.impl.xml.is24.HebeanlageTyp;
import com.openindex.openestate.impl.xml.is24.HeizungsartTyp;
import com.openindex.openestate.impl.xml.is24.IS24ImmobilienTransfer;
import com.openindex.openestate.impl.xml.is24.ISOLaenderCodeTyp;
import com.openindex.openestate.impl.xml.is24.ImmobilieBaseTyp;
import com.openindex.openestate.impl.xml.is24.ImmobilienTransferTyp;
import com.openindex.openestate.impl.xml.is24.JaNeinVereinbarungTyp;
import com.openindex.openestate.impl.xml.is24.LageartTyp;
import com.openindex.openestate.impl.xml.is24.MMAnhangArtenTyp;
import com.openindex.openestate.impl.xml.is24.MieteEinheitTyp;
import com.openindex.openestate.impl.xml.is24.MobilarTyp;
import com.openindex.openestate.impl.xml.is24.MultimediaAnhangTyp;
import com.openindex.openestate.impl.xml.is24.ObjektZustandTyp;
import com.openindex.openestate.impl.xml.is24.RauchenTyp;
import com.openindex.openestate.impl.xml.is24.SonstigeGewerbe;
import com.openindex.openestate.impl.xml.is24.SonstigeGewerbeKategorieTyp;
import com.openindex.openestate.impl.xml.is24.StatusTyp;
import com.openindex.openestate.impl.xml.is24.StellplatzKategorieTyp;
import com.openindex.openestate.impl.xml.is24.TVAnschlussTyp;
import com.openindex.openestate.impl.xml.is24.VermarktungGewerbeTyp;
import com.openindex.openestate.impl.xml.is24.VermarktungGewerbeTyp2;
import com.openindex.openestate.impl.xml.is24.VermarktungGrundstueckGewerbeTyp;
import com.openindex.openestate.impl.xml.is24.VermarktungGrundstueckWohnenKaufTyp;
import com.openindex.openestate.impl.xml.is24.VermarktungGrundstueckWohnenMieteTyp;
import com.openindex.openestate.impl.xml.is24.WAZ;
import com.openindex.openestate.impl.xml.is24.WGZimmer;
import com.openindex.openestate.impl.xml.is24.WGZimmerGeschlechtTyp;
import com.openindex.openestate.impl.xml.is24.WGZimmerKategorienTyp;
import com.openindex.openestate.impl.xml.is24.WaehrungTyp;
import com.openindex.openestate.impl.xml.is24.WazKategorienTyp;
import com.openindex.openestate.impl.xml.is24.WazObjektZustandTyp;
import com.openindex.openestate.impl.xml.is24.WazTyp;
import com.openindex.openestate.impl.xml.is24.WazZeiteinheitenTyp;
import com.openindex.openestate.impl.xml.is24.WohnungKategorienTyp;
import com.openindex.openestate.impl.xml.is24.WohnungKauf;
import com.openindex.openestate.impl.xml.is24.WohnungMiete;
import com.openindex.openestate.impl.xml.is24.ZulieferungTyp;
import com.openindex.openestate.impl.xml.is24.Zwangsversteigerung;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IS24XmlWriter
extends OpenEstateConverter {
    private static final Logger LOGGER = Logger.getLogger(IS24XmlWriter.class);
    private boolean energyCertificateAppendedToDescription = false;

    public IS24XmlWriter() {
    }

    public IS24XmlWriter(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    protected ImmobilienTransferTyp.Anbieter convertAgent(AgentImpl agentImpl) {
        ImmobilienTransferTyp.Anbieter anbieter = new ImmobilienTransferTyp.Anbieter();
        anbieter.setScoutKundenID(!StringUtils.isEmpty((String)agentImpl.getId()) ? agentImpl.getId().trim() : "0");
        return anbieter;
    }

    protected JAXBElement convertEstate(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) throws OpenEstateException {
        Object object;
        String string;
        String string2 = estateImpl.getAction();
        if (string2 == null) {
            throw new OpenEstateException("unbekannte Vermaktungsart!");
        }
        OpenEstateType openEstateType = estateImpl.getType();
        if (openEstateType == null) {
            throw new OpenEstateException("unbekannte Immobilienart!");
        }
        List<String> list2 = Arrays.asList(OpenEstateUtils.getEstateTypePath(openEstateType));
        List<String> list3 = this.getEstateValueAsList("VERWALTUNG", "NUTZUNGSART", estateImpl);
        ImmobilieBaseTyp immobilieBaseTyp = null;
        if (list3.contains("ANLAGE") && "KAUF".equals(string2) && (list2.contains("MAIN_GEWERBE") || list2.contains("MAIN_WOHNEN"))) {
            immobilieBaseTyp = IS24XmlUtils.getFactory().createAnlageobjektType();
        } else if ("WAZ".equals(string2)) {
            if (list2.contains("MAIN_WOHNEN")) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createWAZType();
            }
        } else if ("MIETE".equals(string2) && list2.contains("WG")) {
            immobilieBaseTyp = IS24XmlUtils.getFactory().createWGZimmerType();
        } else if (list2.contains("WOHNUNG")) {
            if ("KAUF".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createWohnungKaufType();
            } else if ("MIETE".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createWohnungMieteType();
            } else if ("PACHT".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createWohnungMieteType();
            }
        } else if (list2.contains("HAUS")) {
            if ("KAUF".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createHausKaufType();
            } else if ("MIETE".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createHausMieteType();
            } else if ("PACHT".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createHausMieteType();
            }
        } else if (list2.contains("WOHNGRUND")) {
            if ("ERBPACHT".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createGrundstueckWohnenKaufType();
            } else if ("KAUF".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createGrundstueckWohnenKaufType();
            } else if ("MIETE".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createGrundstueckWohnenMieteType();
            } else if ("PACHT".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createGrundstueckWohnenMieteType();
            }
        } else if (list2.contains("MAIN_GRUND")) {
            if ("ERBPACHT".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createGrundstueckGewerbeType();
            } else if ("KAUF".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createGrundstueckGewerbeType();
            } else if ("MIETE".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createGrundstueckGewerbeType();
            } else if ("PACHT".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createGrundstueckGewerbeType();
            }
        } else if (list2.contains("BUERO_PRAXIS")) {
            if ("KAUF".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createBueroPraxisType();
            } else if ("MIETE".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createBueroPraxisType();
            } else if ("PACHT".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createBueroPraxisType();
            }
        } else if (list2.contains("EINZELHANDEL")) {
            if ("KAUF".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createEinzelhandelType();
            } else if ("MIETE".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createEinzelhandelType();
            } else if ("PACHT".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createEinzelhandelType();
            }
        } else if (list2.contains("GASTRONOMIE") || list2.contains("GAST")) {
            if ("KAUF".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createGastronomieType();
            } else if ("MIETE".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createGastronomieType();
            } else if ("PACHT".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createGastronomieType();
            }
        } else if (list2.contains("PRODUKTION") || list2.contains("HALLE_LAGER")) {
            if ("KAUF".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createHalleProduktionType();
            } else if ("MIETE".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createHalleProduktionType();
            } else if ("PACHT".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createHalleProduktionType();
            }
        } else if (list2.contains("MAIN_GEWERBE") || list2.contains("MAIN_LANDWIRTSCHAFT")) {
            if ("KAUF".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createSonstigeGewerbeType();
            } else if ("MIETE".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createSonstigeGewerbeType();
            } else if ("PACHT".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createSonstigeGewerbeType();
            }
        } else if (list2.contains("MAIN_STELLPLATZ")) {
            if ("KAUF".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createGarageKaufType();
            } else if ("MIETE".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createGarageMieteType();
            } else if ("PACHT".equals(string2)) {
                immobilieBaseTyp = IS24XmlUtils.getFactory().createGarageMieteType();
            }
        } else if ("KAUF".equals(string2)) {
            immobilieBaseTyp = IS24XmlUtils.getFactory().createAnlageobjektType();
        }
        if (immobilieBaseTyp == null) {
            LOGGER.warn((Object)("kein xml-schema gefunden f\u00fcr immobilie #" + estateImpl.getId() + " / " + openEstateType.getName() + " / " + string2));
            list.add("Von IS24-XML nicht unterst\u00fctzt: " + openEstateType.getName() + " / " + string2);
            return null;
        }
        immobilieBaseTyp.setAnbieterObjektID(estateImpl.getId());
        if (StringUtils.isEmpty((String)immobilieBaseTyp.getAnbieterObjektID())) {
            list.add("IS24-Pflichtfeld 'AnbieterObjektID' nicht angegeben!");
        }
        immobilieBaseTyp.setAdressdruck(estateImpl.getAdress().isAdressPublished());
        immobilieBaseTyp.setAdresse(IS24XmlUtils.getFactory().createImmobilienAdresseTyp());
        immobilieBaseTyp.getAdresse().setHausnummer(estateImpl.getAdress().getStreetNr());
        immobilieBaseTyp.getAdresse().setOrt(estateImpl.getAdress().getCity());
        immobilieBaseTyp.getAdresse().setPostleitzahl(estateImpl.getAdress().getPostalCode());
        immobilieBaseTyp.getAdresse().setStrasse(estateImpl.getAdress().getStreet());
        try {
            string = estateImpl.getAdress().getCountry();
            if (!StringUtils.isEmpty((String)string) && !StringUtils.isEmpty((String)(object = OpenEstateUtils.convertToIso3Country(string)))) {
                immobilieBaseTyp.getAdresse().setLaenderkennzeichen(ISOLaenderCodeTyp.fromValue(((String)object).toUpperCase()));
            }
        }
        catch (Exception exception) {
            list.add("IS24-Pflichtfeld 'Land' nicht angegeben!");
            LOGGER.warn((Object)("Land der Immobilie konnte nicht \u00fcbernommen werden (" + estateImpl.getAdress().getCountry() + ")!"));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        if (StringUtils.isEmpty((String)immobilieBaseTyp.getAdresse().getPostleitzahl())) {
            list.add("IS24-Pflichtfeld 'Postleitzahl' nicht angegeben!");
        }
        if (StringUtils.isEmpty((String)immobilieBaseTyp.getAdresse().getOrt())) {
            list.add("IS24-Pflichtfeld 'Ort' nicht angegeben!");
        }
        if (immobilieBaseTyp.getAdresse().getLaenderkennzeichen() == null) {
            list.add("IS24-Pflichtfeld 'Laenderkennzeichen' nicht angegeben!");
        }
        immobilieBaseTyp.setKontaktperson(IS24XmlUtils.getFactory().createKontaktAdresseTyp());
        if (agentContactImpl != null) {
            if (agentContactImpl.isFemale()) {
                immobilieBaseTyp.getKontaktperson().setAnrede("Frau");
            } else if (agentContactImpl.isMale()) {
                immobilieBaseTyp.getKontaktperson().setAnrede("Herr");
            }
            immobilieBaseTyp.getKontaktperson().setEMail(agentContactImpl.getPersonMail());
            immobilieBaseTyp.getKontaktperson().setHausnummer(agentContactImpl.getStreetNr());
            immobilieBaseTyp.getKontaktperson().setMobiltelefon(agentContactImpl.getPersonMobilePhone());
            immobilieBaseTyp.getKontaktperson().setNachname(agentContactImpl.getPersonLastName());
            immobilieBaseTyp.getKontaktperson().setOrt(agentContactImpl.getCity());
            immobilieBaseTyp.getKontaktperson().setPostleitzahl(agentContactImpl.getPostalCode());
            immobilieBaseTyp.getKontaktperson().setStrasse(agentContactImpl.getStreet());
            immobilieBaseTyp.getKontaktperson().setTelefax(agentContactImpl.getPersonFax());
            immobilieBaseTyp.getKontaktperson().setTelefon(agentContactImpl.getPersonPhone());
            if (StringUtils.isEmpty((String)immobilieBaseTyp.getKontaktperson().getTelefon())) {
                immobilieBaseTyp.getKontaktperson().setTelefon(agentContactImpl.getPersonMobilePhone());
            }
            immobilieBaseTyp.getKontaktperson().setVorname(agentContactImpl.getPersonFirstName());
            try {
                string = agentContactImpl.getCountry();
                if (!StringUtils.isEmpty((String)string) && !StringUtils.isEmpty((String)(object = OpenEstateUtils.convertToIso3Country(string)))) {
                    immobilieBaseTyp.getKontaktperson().setLaenderkennzeichen(ISOLaenderCodeTyp.fromValue(((String)object).toUpperCase()));
                }
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Land des Ansprechpartners konnte nicht \u00fcbernommen werden!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        immobilieBaseTyp.getKontaktperson().setHomepage(agentImpl.getCompany().getCompanyWebsite());
        if (StringUtils.isEmpty((String)immobilieBaseTyp.getKontaktperson().getEMail())) {
            immobilieBaseTyp.getKontaktperson().setEMail(agentImpl.getCompany().getCompanyMail());
        }
        if (StringUtils.isEmpty((String)immobilieBaseTyp.getKontaktperson().getTelefax())) {
            immobilieBaseTyp.getKontaktperson().setTelefax(agentImpl.getCompany().getCompanyFax());
        }
        if (StringUtils.isEmpty((String)immobilieBaseTyp.getKontaktperson().getTelefon())) {
            immobilieBaseTyp.getKontaktperson().setTelefon(agentImpl.getCompany().getCompanyPhone());
        }
        immobilieBaseTyp.setAusstattung(StringUtils.abbreviate((String)this.getEstateValueAsNonEmptyString("FREITEXTE", "AUSSTATT_BESCHR", estateImpl), (int)2000));
        immobilieBaseTyp.setLage(StringUtils.abbreviate((String)this.getEstateValueAsNonEmptyString("FREITEXTE", "LAGE_BESCHR", estateImpl), (int)2000));
        immobilieBaseTyp.setObjektbeschreibung(StringUtils.abbreviate((String)this.getEstateValueAsNonEmptyString("FREITEXTE", "OBJEKT_BESCHR", estateImpl), (int)2000));
        immobilieBaseTyp.setProvisionshinweis(StringUtils.abbreviate((String)this.getEstateValueAsNonEmptyString("FREITEXTE", "PROVISION_BESCHR", estateImpl), (int)2000));
        immobilieBaseTyp.setSonstigeAngaben(StringUtils.abbreviate((String)this.getEstateValueAsNonEmptyString("FREITEXTE", "SONSTIGE_ANGABEN", estateImpl), (int)2000));
        if (this.isEnergyCertificateAppendedToDescription() && !StringUtils.isBlank((String)(string = OpenEstateUtils.writeEstateEnergyCertificate(estateImpl, this.getOpenEstateLanguage(), this.getXmlLineSeparator())))) {
            immobilieBaseTyp.setSonstigeAngaben(OpenEstateUtils.appendTextToDescription(immobilieBaseTyp.getSonstigeAngaben(), string, this.getXmlLineSeparator(), 2000, true));
        }
        if (estateImpl.hasAttribute("PREISE.COURTAGE_AUSSEN")) {
            string = this.getEstateValueAsString("PREISE", "COURTAGE_AUSSEN", estateImpl);
            if (string != null) {
                string = string.trim();
            }
            immobilieBaseTyp.setProvisionspflichtig(!StringUtils.isBlank((String)string) && !string.equalsIgnoreCase("keine") && !string.equalsIgnoreCase("nein") && !string.equalsIgnoreCase("frei") && !string.equalsIgnoreCase("provisionsfrei"));
            immobilieBaseTyp.setProvision(!StringUtils.isBlank((String)string) ? string : null);
        } else {
            immobilieBaseTyp.setProvisionspflichtig(false);
            immobilieBaseTyp.setProvision(this.getEstateValueAsNonEmptyString("PREISE", "COURTAGE_INNEN", estateImpl));
        }
        immobilieBaseTyp.setImportmodus(AktionsTyp.AKTUALISIEREN);
        immobilieBaseTyp.setStatusHP(StatusTyp.AKTIV);
        immobilieBaseTyp.setStatusIS24(StatusTyp.AKTIV);
        immobilieBaseTyp.setStatusVBM(StatusTyp.AKTIV);
        string = estateImpl.getTitle(this.getOpenEstateLanguage());
        immobilieBaseTyp.setUeberschrift(!StringUtils.isEmpty((String)string) ? string.trim() : OpenEstateUtils.translateEstate(estateImpl.getType().getName()));
        if (StringUtils.isEmpty((String)immobilieBaseTyp.getUeberschrift())) {
            list.add("IS24-Pflichtfeld 'Ueberschrift' nicht angegeben!");
        }
        try {
            immobilieBaseTyp.setWaehrung(WaehrungTyp.fromValue(estateImpl.getCurrency().getCurrencyCode()));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"W\u00e4hrung konnte nicht \u00fcbernommen werden!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
            if (immobilieBaseTyp.getMultimediaAnhang().size() >= 15) break;
            if (!estateAttachmentImpl.isName() && !estateAttachmentImpl.isUrl()) continue;
            MultimediaAnhangTyp multimediaAnhangTyp = IS24XmlUtils.getFactory().createMultimediaAnhangTyp();
            if (estateAttachmentImpl.isName()) {
                multimediaAnhangTyp.setDateiname(estateAttachmentImpl.getFileAsName());
                if (estateAttachmentImpl.getMimeType().equalsIgnoreCase("application/pdf")) {
                    if ("IMAGE_GROUNDPLAN".equals(estateAttachmentImpl.getType())) {
                        multimediaAnhangTyp.setAnhangArt(MMAnhangArtenTyp.GRUNDRISS_PDF);
                    } else {
                        multimediaAnhangTyp.setAnhangArt(MMAnhangArtenTyp.VIDEO);
                    }
                } else if (estateAttachmentImpl.getMimeType().toLowerCase().startsWith("image/")) {
                    if ("IMAGE_GROUNDPLAN".equals(estateAttachmentImpl.getType())) {
                        multimediaAnhangTyp.setAnhangArt(MMAnhangArtenTyp.GRUNDRISS_BILD);
                    } else {
                        multimediaAnhangTyp.setAnhangArt(MMAnhangArtenTyp.BILD);
                    }
                } else {
                    if (!estateAttachmentImpl.getMimeType().toLowerCase().startsWith("video/")) continue;
                    multimediaAnhangTyp.setAnhangArt(MMAnhangArtenTyp.VIDEO);
                }
            } else {
                if (!estateAttachmentImpl.isUrl()) continue;
                multimediaAnhangTyp.setDateiname(estateAttachmentImpl.getFileAsUrl().toString());
                multimediaAnhangTyp.setAnhangArt(MMAnhangArtenTyp.LINK);
            }
            if (StringUtils.isEmpty((String)multimediaAnhangTyp.getDateiname()) || multimediaAnhangTyp.getAnhangArt() == null) {
                LOGGER.warn((Object)"incomplete attachment...");
                continue;
            }
            String[] stringArray = multimediaAnhangTyp.getDateiname().split("\\.");
            multimediaAnhangTyp.setDateityp(stringArray[stringArray.length - 1].trim().toUpperCase());
            multimediaAnhangTyp.setTitel(estateAttachmentImpl.getTitle(this.getOpenEstateLanguage()));
            immobilieBaseTyp.getMultimediaAnhang().add(multimediaAnhangTyp);
        }
        if (immobilieBaseTyp instanceof Anlageobjekt.Type) {
            return this.convertEstate(estateImpl, (Anlageobjekt.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof BueroPraxis.Type) {
            return this.convertEstate(estateImpl, (BueroPraxis.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof Einzelhandel.Type) {
            return this.convertEstate(estateImpl, (Einzelhandel.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof GarageKauf.Type) {
            return this.convertEstate(estateImpl, (GarageKauf.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof GarageMiete.Type) {
            return this.convertEstate(estateImpl, (GarageMiete.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof Gastronomie.Type) {
            return this.convertEstate(estateImpl, (Gastronomie.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof GrundstueckGewerbe.Type) {
            return this.convertEstate(estateImpl, (GrundstueckGewerbe.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof GrundstueckWohnenKauf.Type) {
            return this.convertEstate(estateImpl, (GrundstueckWohnenKauf.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof GrundstueckWohnenMiete.Type) {
            return this.convertEstate(estateImpl, (GrundstueckWohnenMiete.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof HalleProduktion.Type) {
            return this.convertEstate(estateImpl, (HalleProduktion.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof HausKauf.Type) {
            return this.convertEstate(estateImpl, (HausKauf.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof HausMiete.Type) {
            return this.convertEstate(estateImpl, (HausMiete.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof SonstigeGewerbe.Type) {
            return this.convertEstate(estateImpl, (SonstigeGewerbe.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof WAZ.Type) {
            return this.convertEstate(estateImpl, (WAZ.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof WGZimmer.Type) {
            return this.convertEstate(estateImpl, (WGZimmer.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof WohnungKauf.Type) {
            return this.convertEstate(estateImpl, (WohnungKauf.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof WohnungMiete.Type) {
            return this.convertEstate(estateImpl, (WohnungMiete.Type)immobilieBaseTyp, list2, list);
        }
        if (immobilieBaseTyp instanceof Zwangsversteigerung.Type) {
            return this.convertEstate(estateImpl, (Zwangsversteigerung.Type)immobilieBaseTyp, list2, list);
        }
        list.add("Keine Immobilienart zur Verarbeitung gefunden!");
        return null;
    }

    protected Anlageobjekt convertEstate(EstateImpl estateImpl, Anlageobjekt.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        type.setAnzahlParkflaechen(this.getEstateValueAsLong("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBaujahr(this.getEstateValueAsLong("ZUSTAND", "BAUJAHR", estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setDenkmalschutzobjekt(this.getEstateValueAsBoolean("VERWALTUNG", "DENKMALGESCHUETZT", estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagen(this.getEstateValueAsNonEmptyString("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl));
        type.setFahrzeitBAB(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_AUTOBAHN", estateImpl)));
        type.setFahrzeitBHf(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_BHF", estateImpl)));
        type.setFahrzeitFlughafen(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_FLUG", estateImpl)));
        type.setFusswegOeNV(IS24XmlUtils.getFusswegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_BUS", estateImpl)));
        if (type.getFusswegOeNV() == null || type.getFusswegOeNV() <= 0L) {
            type.setFusswegOeNV(IS24XmlUtils.getFusswegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_NAHBHF", estateImpl)));
        }
        type.setGesamtflaeche(this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl));
        type.setGewerbeFlaechen(this.getEstateValueAsDouble("FLAECHEN", "GEWERBEFLAECHE", estateImpl));
        type.setGrundstuecksFlaeche(this.getEstateValueAsDouble("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(this.getEstateValueAsLong("ZUSTAND", "SANIERUNG", estateImpl));
        type.setKaufpreis(this.getEstateValueAsDouble("PREISE", "KAUFPREIS", estateImpl));
        type.setKaufpreisProQm(this.getEstateValueAsDouble("PREISE", "KAUFPREIS_QM", estateImpl));
        type.setMietEinnahmePaIst(this.getEstateValueAsDouble("PREISE", "MIETEINNAHMEN_IST", estateImpl));
        type.setMietEinnahmePaSoll(this.getEstateValueAsDouble("PREISE", "MIETEINNAHMEN_SOLL", estateImpl));
        type.setObjektkategorie2(this.writeKategorieAnlage(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setPersonenaufzug(this.getEstateValueAsBoolean("AUSSTATTUNG", "PERS_LIFT", estateImpl));
        type.setPreisProParkflaeche(this.getEstateValueAsDouble("PREISE", "STELLPLATZ_PREIS", estateImpl));
        type.setSonstigeFlaechen(this.getEstateValueAsDouble("FLAECHEN", "SONSTFLAECHE", estateImpl));
        type.setWohnFlaechen(this.getEstateValueAsDouble("FLAECHEN", "WOHNFLAECHE", estateImpl));
        type.setXFacheMiete(this.getEstateValueAsDouble("PREISE", "X_FACHE", estateImpl));
        Double d = this.getEstateValueAsDouble("FLAECHEN", "VERMIETBARE_FLAECHE", estateImpl);
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "WOHNFLAECHE", estateImpl);
        }
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GEWERBEFLAECHE", estateImpl);
        }
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "NUTZFLAECHE", estateImpl);
        }
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        type.setVermietbareFlaeche(d);
        if (type.getObjektkategorie2() == null) {
            list2.add("IS24-Pflichtfeld 'Objektkategorie2' nicht angegeben (f\u00fcr Anlageobjekt)!");
        }
        if (type.getVermietbareFlaeche() == null || type.getVermietbareFlaeche() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'VermietbareFlaeche' nicht angegeben (f\u00fcr Anlageobjekt)!");
        }
        if (type.getKaufpreis() == null || type.getKaufpreis() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'Kaufpreis' nicht angegeben (f\u00fcr Anlageobjekt)!");
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createAnlageobjekt(type) : null;
    }

    protected BueroPraxis convertEstate(EstateImpl estateImpl, BueroPraxis.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        type.setAnzahlParkflaechen(this.getEstateValueAsLong("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBarrierefrei(this.getEstateValueAsBoolean("AUSSTATTUNG", "BARRIEREFREI", estateImpl));
        type.setBaujahr(this.getEstateValueAsLong("ZUSTAND", "BAUJAHR", estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setBodenbelag(this.writeBodenbelag(estateImpl));
        type.setDatenVerkabelung(this.writeDatenverkabelung(estateImpl));
        type.setDenkmalschutzobjekt(this.getEstateValueAsBoolean("VERWALTUNG", "DENKMALGESCHUETZT", estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagen(this.getEstateValueAsNonEmptyString("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl));
        type.setFahrzeitBAB(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_AUTOBAHN", estateImpl)));
        type.setFahrzeitBHf(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_BHF", estateImpl)));
        type.setFahrzeitFlughafen(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_FLUG", estateImpl)));
        type.setFreiAb(this.getEstateValueAsNonEmptyString("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl));
        if (StringUtils.isEmpty((String)type.getFreiAb())) {
            type.setFreiAb(this.getFormattedEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        }
        type.setFusswegOeNV(IS24XmlUtils.getFusswegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_BUS", estateImpl)));
        if (type.getFusswegOeNV() == null || type.getFusswegOeNV() <= 0L) {
            type.setFusswegOeNV(IS24XmlUtils.getFusswegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_NAHBHF", estateImpl)));
        }
        type.setGesamtflaeche(this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(this.getEstateValueAsLong("ZUSTAND", "SANIERUNG", estateImpl));
        type.setKantine(this.getEstateValueAsBoolean("AUSSTATTUNG", "KANTINE_CAFETERIA", estateImpl));
        type.setKeller(this.getEstateValueAsBoolean("AUSSTATTUNG", "KELLER", estateImpl));
        type.setKlimaanlage(this.writeKlimatisiert(estateImpl));
        type.setKuecheVorhanden(this.writeKueche(estateImpl));
        type.setNebenflaeche(this.getEstateValueAsDouble("FLAECHEN", "SONSTFLAECHE", estateImpl));
        type.setObjektkategorie2(this.writeKategorieBueroPraxis(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setPersonenaufzug(this.getEstateValueAsBoolean("AUSSTATTUNG", "PERS_LIFT", estateImpl));
        type.setTeilbarAb(this.getEstateValueAsDouble("FLAECHEN", "TEILBAR_AB", estateImpl));
        type.setVermarktung(this.writeVermarktungGewerbe(estateImpl));
        Double d = this.getEstateValueAsDouble("FLAECHEN", "BUEROFLAECHE", estateImpl);
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GEWERBEFLAECHE", estateImpl);
        }
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        type.setBueroPraxisFlaeche(d);
        if (type.getBueroPraxisFlaeche() == null || type.getBueroPraxisFlaeche() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'BueroPraxisFlaeche' nicht angegeben (f\u00fcr BueroPraxis)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr BueroPraxis)!");
        } else if (type.getVermarktung().getMiete() != null) {
            Double d2 = ((VermarktungGewerbeTyp.Miete)type.getVermarktung().getMiete().getValue()).getKaltmiete();
            if (d2 == null || d2 < 0.0) {
                ((VermarktungGewerbeTyp.Miete)type.getVermarktung().getMiete().getValue()).setKaltmiete(0.0);
            }
        } else if (type.getVermarktung().getKauf() != null) {
            Double d3 = ((VermarktungGewerbeTyp.Kauf)type.getVermarktung().getKauf().getValue()).getPreis();
            if (d3 == null || d3 < 0.0) {
                ((VermarktungGewerbeTyp.Kauf)type.getVermarktung().getKauf().getValue()).setPreis(0.0);
            }
        } else {
            list2.add("IS24-Pflichtfeld unvollst\u00e4ndig, weder 'Vermarktung/Miete' noch 'Vermarktung/Kauf' sind angegeben (f\u00fcr BueroPraxis)!");
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createBueroPraxis(type) : null;
    }

    protected Einzelhandel convertEstate(EstateImpl estateImpl, Einzelhandel.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        type.setAnzahlParkflaechen(this.getEstateValueAsLong("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBaujahr(this.getEstateValueAsLong("ZUSTAND", "BAUJAHR", estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setBodenbelag(this.writeBodenbelag(estateImpl));
        type.setDeckenlast(this.getEstateValueAsDouble("AUSSTATTUNG", "DECKENLAST", estateImpl));
        type.setDenkmalschutzobjekt(this.getEstateValueAsBoolean("VERWALTUNG", "DENKMALGESCHUETZT", estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagen(this.getEstateValueAsNonEmptyString("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl));
        type.setFahrzeitBAB(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_AUTOBAHN", estateImpl)));
        type.setFahrzeitBHf(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_BHF", estateImpl)));
        type.setFahrzeitFlughafen(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_FLUG", estateImpl)));
        type.setFreiAb(this.getEstateValueAsNonEmptyString("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl));
        if (StringUtils.isEmpty((String)type.getFreiAb())) {
            type.setFreiAb(this.getFormattedEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        }
        type.setFusswegOeNV(IS24XmlUtils.getFusswegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_BUS", estateImpl)));
        if (type.getFusswegOeNV() == null || type.getFusswegOeNV() <= 0L) {
            type.setFusswegOeNV(IS24XmlUtils.getFusswegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_NAHBHF", estateImpl)));
        }
        type.setGesamtflaeche(this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(this.getEstateValueAsLong("ZUSTAND", "SANIERUNG", estateImpl));
        type.setKeller(this.getEstateValueAsBoolean("AUSSTATTUNG", "KELLER", estateImpl));
        type.setLageart(this.writeLageArt(estateImpl));
        HebeanlageTyp hebeanlageTyp = this.writeLastenaufzug(estateImpl);
        if (hebeanlageTyp != null) {
            type.setLastenaufzug((JAXBElement<HebeanlageTyp>)new JAXBElement(new QName("http://www.immobilienscout24.de/immobilientransfer", "Lastenaufzug"), HebeanlageTyp.class, (Object)hebeanlageTyp));
        }
        type.setNebenflaeche(this.getEstateValueAsDouble("FLAECHEN", "SONSTFLAECHE", estateImpl));
        type.setObjektkategorie2(this.writeKategorieEinzelhandel(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setPersonenaufzug(this.getEstateValueAsBoolean("AUSSTATTUNG", "PERS_LIFT", estateImpl));
        type.setRampe(this.getEstateValueAsBoolean("AUSSTATTUNG", "RAMPE", estateImpl));
        type.setSchaufensterfront(this.getEstateValueAsDouble("FLAECHEN", "FENSTERFRONT_M", estateImpl));
        type.setObjektkategorie2(this.writeKategorieEinzelhandel(list));
        type.setTeilbarAb(this.getEstateValueAsDouble("FLAECHEN", "TEILBAR_AB", estateImpl));
        type.setVermarktung(this.writeVermarktungGewerbe(estateImpl));
        type.setZulieferung(this.writeZulieferung(estateImpl));
        Double d = this.getEstateValueAsDouble("FLAECHEN", "VERKAUFSFLAECHE", estateImpl);
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GEWERBEFLAECHE", estateImpl);
        }
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        type.setVerkaufsflaeche(d);
        if (type.getVerkaufsflaeche() == null || type.getVerkaufsflaeche() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'Verkaufsflaeche' nicht angegeben (f\u00fcr Einzelhandel)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr Einzelhandel)!");
        } else if (type.getVermarktung().getMiete() != null) {
            Double d2 = ((VermarktungGewerbeTyp.Miete)type.getVermarktung().getMiete().getValue()).getKaltmiete();
            if (d2 == null || d2 < 0.0) {
                ((VermarktungGewerbeTyp.Miete)type.getVermarktung().getMiete().getValue()).setKaltmiete(0.0);
            }
        } else if (type.getVermarktung().getKauf() != null) {
            Double d3 = ((VermarktungGewerbeTyp.Kauf)type.getVermarktung().getKauf().getValue()).getPreis();
            if (d3 == null || d3 < 0.0) {
                ((VermarktungGewerbeTyp.Kauf)type.getVermarktung().getKauf().getValue()).setPreis(0.0);
            }
        } else {
            list2.add("IS24-Pflichtfeld unvollst\u00e4ndig, weder 'Vermarktung/Miete' noch 'Vermarktung/Kauf' sind angegeben (f\u00fcr Einzelhandel)!");
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createEinzelhandel(type) : null;
    }

    protected GarageKauf convertEstate(EstateImpl estateImpl, GarageKauf.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        type.setBaujahr(this.getEstateValueAsLong("ZUSTAND", "BAUJAHR", estateImpl));
        type.setBreite(this.getEstateValueAsDouble("FLAECHEN", "BREITE", estateImpl));
        type.setFlaeche(this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl));
        type.setHoehe(this.getEstateValueAsDouble("FLAECHEN", "HOEHE", estateImpl));
        type.setJahrLetzteModernisierung(this.getEstateValueAsLong("ZUSTAND", "SANIERUNG", estateImpl));
        type.setKaufpreise(IS24XmlUtils.getFactory().createVermarktungGarageKaufTyp());
        type.getKaufpreise().setKaufpreis(this.getEstateValueAsDouble("PREISE", "KAUFPREIS", estateImpl));
        type.setLaenge(this.getEstateValueAsDouble("FLAECHEN", "LAENGE", estateImpl));
        type.setObjektKategorie2(this.writeKategorieGarage(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        if (type.getKaufpreise() == null) {
            list2.add("IS24-Pflichtfeld 'Kaufpreise' nicht angegeben (f\u00fcr GarageKauf)!");
        } else {
            Double d = type.getKaufpreise().getKaufpreis();
            if (d == null || d <= 0.0) {
                list2.add("IS24-Pflichtfeld 'Kaufpreise/Kaufpreis' nicht angegeben (f\u00fcr GarageKauf)!");
            }
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createGarageKauf(type) : null;
    }

    protected GarageMiete convertEstate(EstateImpl estateImpl, GarageMiete.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        type.setBaujahr(this.getEstateValueAsLong("ZUSTAND", "BAUJAHR", estateImpl));
        type.setBreite(this.getEstateValueAsDouble("FLAECHEN", "BREITE", estateImpl));
        type.setFlaeche(this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl));
        type.setHoehe(this.getEstateValueAsDouble("FLAECHEN", "HOEHE", estateImpl));
        type.setJahrLetzteModernisierung(this.getEstateValueAsLong("ZUSTAND", "SANIERUNG", estateImpl));
        type.setMietpreise(IS24XmlUtils.getFactory().createVermarktungGarageMieteTyp());
        type.getMietpreise().setMiete(this.getEstateValueAsDouble("PREISE", "KALTMIETE", estateImpl));
        type.setLaenge(this.getEstateValueAsDouble("FLAECHEN", "LAENGE", estateImpl));
        type.setObjektKategorie2(this.writeKategorieGarage(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        if (type.getMietpreise() == null) {
            list2.add("IS24-Pflichtfeld 'Mietpreise' nicht angegeben (f\u00fcr GarageMiete)!");
        } else {
            Double d = type.getMietpreise().getMiete();
            if (d == null || d <= 0.0) {
                list2.add("IS24-Pflichtfeld 'Mietpreise/Miete' nicht angegeben (f\u00fcr GarageMiete)!");
            }
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createGarageMiete(type) : null;
    }

    protected Gastronomie convertEstate(EstateImpl estateImpl, Gastronomie.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        type.setAnzahlBetten(this.getEstateValueAsLong("FLAECHEN", "ANZ_BETTEN", estateImpl));
        type.setAnzahlParkflaechen(this.getEstateValueAsLong("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBaujahr(this.getEstateValueAsLong("ZUSTAND", "BAUJAHR", estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setDenkmalschutzobjekt(this.getEstateValueAsBoolean("VERWALTUNG", "DENKMALGESCHUETZT", estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagen(this.getEstateValueAsNonEmptyString("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl));
        type.setFahrzeitBAB(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_AUTOBAHN", estateImpl)));
        type.setFahrzeitBHf(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_BHF", estateImpl)));
        type.setFahrzeitFlughafen(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_FLUG", estateImpl)));
        type.setFreiAb(this.getEstateValueAsNonEmptyString("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl));
        if (StringUtils.isEmpty((String)type.getFreiAb())) {
            type.setFreiAb(this.getFormattedEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        }
        type.setFusswegOeNV(IS24XmlUtils.getFusswegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_BUS", estateImpl)));
        if (type.getFusswegOeNV() == null || type.getFusswegOeNV() <= 0L) {
            type.setFusswegOeNV(IS24XmlUtils.getFusswegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_NAHBHF", estateImpl)));
        }
        type.setGastraumPlaetze(this.getEstateValueAsLong("FLAECHEN", "ANZ_GAESTEZIMMER", estateImpl));
        type.setGesamtflaeche(this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(this.getEstateValueAsLong("ZUSTAND", "SANIERUNG", estateImpl));
        type.setKeller(this.getEstateValueAsBoolean("AUSSTATTUNG", "KELLER", estateImpl));
        type.setNebenflaeche(this.getEstateValueAsDouble("FLAECHEN", "SONSTFLAECHE", estateImpl));
        type.setObjektkategorie2(this.writeKategorieGastronomie(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setPersonenaufzug(this.getEstateValueAsBoolean("AUSSTATTUNG", "PERS_LIFT", estateImpl));
        type.setVermarktung(this.writeVermarktungGewerbe2(estateImpl));
        Double d = this.getEstateValueAsDouble("FLAECHEN", "GASTRAUMFLAECHE", estateImpl);
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GEWERBEFLAECHE", estateImpl);
        }
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        type.setGastraumFlaeche(d);
        if (type.getGastraumFlaeche() == null || type.getGastraumFlaeche() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'GastraumFlaeche' nicht angegeben (f\u00fcr Gastronomie)!");
        }
        if (type.getObjektkategorie2() == null) {
            list2.add("IS24-Pflichtfeld 'Objektkategorie2' nicht angegeben (f\u00fcr Gastronomie)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr Gastronomie)!");
        } else {
            Double d2 = type.getVermarktung().getPreis();
            if (d2 == null || d2 < 0.0) {
                type.getVermarktung().setPreis(0.0);
            }
            if (type.getVermarktung().getMiete() == null && type.getVermarktung().getKauf() == null) {
                list2.add("IS24-Pflichtfeld unvollst\u00e4ndig, weder 'Vermarktung/Miete' noch 'Vermarktung/Kauf' sind angegeben (f\u00fcr Gastronomie)!");
            }
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createGastronomie(type) : null;
    }

    protected GrundstueckGewerbe convertEstate(EstateImpl estateImpl, GrundstueckGewerbe.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        type.setAbrissErforderlich(this.getEstateValueAsBoolean("VERWALTUNG", "ABRISS", estateImpl));
        type.setBaugenehmigungVorhanden(this.getEstateValueAsBoolean("VERWALTUNG", "BAUGENEHMIGUNG", estateImpl));
        type.setBebaubarMit(this.writeBebaubarMitGewerbe(estateImpl));
        type.setBebaubarNach(this.writeBebaubarNach(estateImpl));
        type.setErschliessungszustand(this.writeErschliessungszustand(estateImpl));
        type.setFreiAb(this.getEstateValueAsNonEmptyString("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl));
        if (StringUtils.isEmpty((String)type.getFreiAb())) {
            type.setFreiAb(this.getFormattedEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        }
        type.setGFZ(this.getEstateValueAsDouble("FLAECHEN", "GFZ", estateImpl));
        type.setGRZ(this.getEstateValueAsDouble("FLAECHEN", "GRZ", estateImpl));
        type.setKurzfristigBebaubar(this.getEstateValueAsBoolean("VERWALTUNG", "BEBAUBAR_KURZ", estateImpl));
        type.setObjektkategorie2(this.writeKategorieGrundstueckGewerbe(list));
        type.setTeilbarAb(this.getEstateValueAsLong("FLAECHEN", "TEILBAR_AB", estateImpl));
        type.setVermarktung(this.writeVermarktungGrundstueckGewerbe(estateImpl));
        Double d = this.getEstateValueAsDouble("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl);
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        type.setGrundstuecksFlaeche(d);
        if (type.getGrundstuecksFlaeche() == null || type.getGrundstuecksFlaeche() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'GrundstuecksFlaeche' nicht angegeben (f\u00fcr GrundstueckGewerbe)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr GrundstueckGewerbe)!");
        } else {
            Double d2 = type.getVermarktung().getPreis();
            if (d2 == null || d2 < 0.0) {
                type.getVermarktung().setPreis(0.0);
            }
            if (type.getVermarktung().getErbpacht() != null && ((VermarktungGrundstueckGewerbeTyp.Erbpacht)type.getVermarktung().getErbpacht().getValue()).getDauerInJahren() == null) {
                list2.add("IS24-Pflichtfeld 'Vermarktung/Erbpacht/DauerInJahren' nicht angegeben (f\u00fcr GrundstueckGewerbe)!");
            }
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createGrundstueckGewerbe(type) : null;
    }

    protected GrundstueckWohnenKauf convertEstate(EstateImpl estateImpl, GrundstueckWohnenKauf.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        type.setAbrissErforderlich(this.getEstateValueAsBoolean("VERWALTUNG", "ABRISS", estateImpl));
        type.setBaugenehmigungVorhanden(this.getEstateValueAsBoolean("VERWALTUNG", "BAUGENEHMIGUNG", estateImpl));
        type.setBebaubarMit(this.writeBebaubarMitWohnen(estateImpl));
        type.setBebaubarNach(this.writeBebaubarNach(estateImpl));
        type.setErschliessungszustand(this.writeErschliessungszustand(estateImpl));
        type.setFreiAb(this.getEstateValueAsNonEmptyString("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl));
        if (StringUtils.isEmpty((String)type.getFreiAb())) {
            type.setFreiAb(this.getFormattedEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        }
        type.setGFZ(this.getEstateValueAsDouble("FLAECHEN", "GFZ", estateImpl));
        type.setGRZ(this.getEstateValueAsDouble("FLAECHEN", "GRZ", estateImpl));
        type.setKurzfristigBebaubar(this.getEstateValueAsBoolean("VERWALTUNG", "BEBAUBAR_KURZ", estateImpl));
        type.setObjektkategorie2(GrundstueckWohnenKategorienTyp.WOHNEN);
        type.setTeilbarAb(this.getEstateValueAsLong("FLAECHEN", "TEILBAR_AB", estateImpl));
        type.setVermarktung(this.writeVermarktungGrundstueckWohnenKauf(estateImpl));
        Double d = this.getEstateValueAsDouble("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl);
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        type.setGrundstuecksFlaeche(d);
        if (type.getGrundstuecksFlaeche() == null || type.getGrundstuecksFlaeche() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'GrundstuecksFlaeche' nicht angegeben (f\u00fcr GrundstueckWohnenKauf)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr GrundstueckWohnenKauf)!");
        } else {
            Double d2 = type.getVermarktung().getPreis();
            if (d2 == null || d2 < 0.0) {
                type.getVermarktung().setPreis(0.0);
            }
            if (type.getVermarktung().getErbpacht() != null && ((VermarktungGrundstueckWohnenKaufTyp.Erbpacht)type.getVermarktung().getErbpacht().getValue()).getDauerInJahren() == null) {
                list2.add("IS24-Pflichtfeld 'Vermarktung/Erbpacht/DauerInJahren' nicht angegeben (f\u00fcr GrundstueckWohnenKauf)!");
            }
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createGrundstueckWohnenKauf(type) : null;
    }

    protected GrundstueckWohnenMiete convertEstate(EstateImpl estateImpl, GrundstueckWohnenMiete.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        type.setAbrissErforderlich(this.getEstateValueAsBoolean("VERWALTUNG", "ABRISS", estateImpl));
        type.setBaugenehmigungVorhanden(this.getEstateValueAsBoolean("VERWALTUNG", "BAUGENEHMIGUNG", estateImpl));
        type.setBebaubarMit(this.writeBebaubarMitWohnen(estateImpl));
        type.setBebaubarNach(this.writeBebaubarNach(estateImpl));
        type.setErschliessungszustand(this.writeErschliessungszustand(estateImpl));
        type.setFreiAb(this.getEstateValueAsNonEmptyString("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl));
        if (StringUtils.isEmpty((String)type.getFreiAb())) {
            type.setFreiAb(this.getFormattedEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        }
        type.setGFZ(this.getEstateValueAsDouble("FLAECHEN", "GFZ", estateImpl));
        type.setGRZ(this.getEstateValueAsDouble("FLAECHEN", "GRZ", estateImpl));
        type.setKurzfristigBebaubar(this.getEstateValueAsBoolean("VERWALTUNG", "BEBAUBAR_KURZ", estateImpl));
        type.setObjektkategorie2(GrundstueckWohnenKategorienTyp.WOHNEN);
        type.setTeilbarAb(this.getEstateValueAsLong("FLAECHEN", "TEILBAR_AB", estateImpl));
        type.setVermarktung(this.writeVermarktungGrundstueckWohnenMiete(estateImpl));
        Double d = this.getEstateValueAsDouble("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl);
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        type.setGrundstuecksFlaeche(d);
        if (type.getGrundstuecksFlaeche() == null || type.getGrundstuecksFlaeche() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'GrundstuecksFlaeche' nicht angegeben (f\u00fcr GrundstueckWohnenMiete)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr GrundstueckWohnenMiete)!");
        } else {
            Double d2 = type.getVermarktung().getPreis();
            if (d2 == null || d2 < 0.0) {
                type.getVermarktung().setPreis(0.0);
            }
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createGrundstueckWohnenMiete(type) : null;
    }

    protected HalleProduktion convertEstate(EstateImpl estateImpl, HalleProduktion.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        type.setAnzahlParkflaechen(this.getEstateValueAsLong("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBaujahr(this.getEstateValueAsLong("ZUSTAND", "BAUJAHR", estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setBodenbelag(this.writeBodenbelag(estateImpl));
        type.setBodenbelastung(this.getEstateValueAsDouble("AUSSTATTUNG", "BODENBELASTUNG", estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagen(this.getEstateValueAsNonEmptyString("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl));
        type.setFahrzeitBAB(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_AUTOBAHN", estateImpl)));
        type.setFahrzeitBHf(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_BHF", estateImpl)));
        type.setFahrzeitFlughafen(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_FLUG", estateImpl)));
        type.setFreiAb(this.getEstateValueAsNonEmptyString("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl));
        if (StringUtils.isEmpty((String)type.getFreiAb())) {
            type.setFreiAb(this.getFormattedEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        }
        type.setFusswegOeNV(IS24XmlUtils.getFusswegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_BUS", estateImpl)));
        if (type.getFusswegOeNV() == null || type.getFusswegOeNV() <= 0L) {
            type.setFusswegOeNV(IS24XmlUtils.getFusswegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_NAHBHF", estateImpl)));
        }
        type.setGesamtflaeche(this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl));
        type.setGrundstuecksFlaeche(this.getEstateValueAsDouble("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl));
        type.setHallenhoehe(this.getEstateValueAsDouble("AUSSTATTUNG", "HALLENHOEHE", estateImpl));
        type.setHebebuehne(this.getEstateValueAsBoolean("AUSSTATTUNG", "HEBEBUEHNE", estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(this.getEstateValueAsLong("ZUSTAND", "SANIERUNG", estateImpl));
        type.setKranbahn(this.writeKranbahn(estateImpl));
        type.setLastenaufzug(this.writeLastenaufzug(estateImpl));
        type.setNebenflaeche(this.getEstateValueAsDouble("FLAECHEN", "SONSTFLAECHE", estateImpl));
        type.setObjektkategorie2(this.writeKategorieHalleProduktion(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setPersonenaufzug(this.getEstateValueAsBoolean("AUSSTATTUNG", "PERS_LIFT", estateImpl));
        type.setRampe(this.getEstateValueAsBoolean("AUSSTATTUNG", "RAMPE", estateImpl));
        type.setStromanschlusswert(this.getEstateValueAsLong("AUSSTATTUNG", "STROMANSCHLUSSWERT", estateImpl));
        type.setTeilbarAb(this.getEstateValueAsDouble("FLAECHEN", "TEILBAR_AB", estateImpl));
        type.setVermarktung(this.writeVermarktungGewerbe(estateImpl));
        Double d = this.getEstateValueAsDouble("FLAECHEN", "LAGERFLAECHE", estateImpl);
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GEWERBEFLAECHE", estateImpl);
        }
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        type.setLagerProduktionsFlaeche(d);
        if (type.getLagerProduktionsFlaeche() == null || type.getLagerProduktionsFlaeche() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'LagerProduktionsFlaeche' nicht angegeben (f\u00fcr HalleProduktion)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr HalleProduktion)!");
        } else if (type.getVermarktung().getMiete() != null) {
            Double d2 = ((VermarktungGewerbeTyp.Miete)type.getVermarktung().getMiete().getValue()).getKaltmiete();
            if (d2 == null || d2 < 0.0) {
                ((VermarktungGewerbeTyp.Miete)type.getVermarktung().getMiete().getValue()).setKaltmiete(0.0);
            }
        } else if (type.getVermarktung().getKauf() != null) {
            Double d3 = ((VermarktungGewerbeTyp.Kauf)type.getVermarktung().getKauf().getValue()).getPreis();
            if (d3 == null || d3 < 0.0) {
                ((VermarktungGewerbeTyp.Kauf)type.getVermarktung().getKauf().getValue()).setPreis(0.0);
            }
        } else {
            list2.add("IS24-Pflichtfeld unvollst\u00e4ndig, weder 'Vermarktung/Miete' noch 'Vermarktung/Kauf' sind angegeben (f\u00fcr HalleProduktion)!");
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createHalleProduktion(type) : null;
    }

    protected HausKauf convertEstate(EstateImpl estateImpl, HausKauf.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        type.setAlsFerienwohnungGeeignet(this.getEstateValueAsBoolean("VERWALTUNG", "ALS_FERIEN", estateImpl));
        type.setAnzahlBadezimmer(this.getEstateValueAsLong("FLAECHEN", "ANZ_BADEZIMMER", estateImpl));
        type.setAnzahlGaragenStellplaetze(this.getEstateValueAsLong("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl));
        type.setAnzahlSchlafzimmer(this.getEstateValueAsLong("FLAECHEN", "ANZ_SCHLAFZIMMER", estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBarrierefrei(this.getEstateValueAsBoolean("AUSSTATTUNG", "BARRIEREFREI", estateImpl));
        type.setBaujahr(this.getEstateValueAsLong("ZUSTAND", "BAUJAHR", estateImpl));
        type.setBauphase(this.writeBauphase(estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setDenkmalschutzobjekt(this.getEstateValueAsBoolean("VERWALTUNG", "DENKMALGESCHUETZT", estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagenzahl(this.getEstateValueAsLong("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl));
        type.setFreiAb(this.getEstateValueAsNonEmptyString("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl));
        if (StringUtils.isEmpty((String)type.getFreiAb())) {
            type.setFreiAb(this.getFormattedEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        }
        type.setGaesteWC(this.hasEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl));
        type.setGrundstuecksFlaeche(this.getEstateValueAsDouble("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl));
        type.setHausKategorie(this.writeKategorieHaus(list));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(this.getEstateValueAsLong("ZUSTAND", "SANIERUNG", estateImpl));
        type.setKaufpreise(IS24XmlUtils.getFactory().createVermarktungWohnKaufTyp());
        type.getKaufpreise().setKaufpreis(this.getEstateValueAsDouble("PREISE", "KAUFPREIS", estateImpl));
        type.getKaufpreise().setMieteinnahmenProMonat(this.getEstateValueAsDouble("PREISE", "MIETEINNAHMEN_PRO_MONAT", estateImpl));
        type.getKaufpreise().setStellplatzKaufpreis(this.getEstateValueAsDouble("PREISE", "STELLPLATZ_PREIS", estateImpl));
        type.getKaufpreise().setWohngeld(this.getEstateValueAsDouble("PREISE", "HAUSGELD", estateImpl));
        type.setKeller(this.getEstateValueAsBoolean("AUSSTATTUNG", "KELLER", estateImpl));
        type.setMitEinliegerwohnung(this.getEstateValueAsBoolean("VERWALTUNG", "EINLIEGERWOHNUNG", estateImpl));
        type.setNutzflaeche(this.getEstateValueAsDouble("FLAECHEN", "NUTZFLAECHE", estateImpl));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setParkplatz(this.writeStellplatzKategorie(estateImpl));
        type.setRollstuhlgerecht(this.hasEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl));
        type.setVermietet(this.getEstateValueAsBoolean("VERWALTUNG", "VERMIETET", estateImpl));
        type.setZimmer(this.getEstateValueAsDouble("FLAECHEN", "ANZ_ZIMMER", estateImpl));
        Double d = this.getEstateValueAsDouble("FLAECHEN", "WOHNFLAECHE", estateImpl);
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        type.setWohnflaeche(d);
        if (type.getWohnflaeche() == null || type.getWohnflaeche() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'Wohnflaeche' nicht angegeben (f\u00fcr HausKauf)!");
        }
        if (type.getZimmer() == null || type.getZimmer() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'Zimmer' nicht angegeben (f\u00fcr HausKauf)!");
        }
        if (type.getKaufpreise() == null) {
            list2.add("IS24-Pflichtfeld 'Kaufpreise' nicht angegeben (f\u00fcr HausKauf)!");
        } else if (type.getKaufpreise().getKaufpreis() == null || type.getKaufpreise().getKaufpreis() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'Kaufpreise/Kaufpreis' nicht angegeben (f\u00fcr HausKauf)!");
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createHausKauf(type) : null;
    }

    protected HausMiete convertEstate(EstateImpl estateImpl, HausMiete.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        type.setAnzahlBadezimmer(this.getEstateValueAsLong("FLAECHEN", "ANZ_BADEZIMMER", estateImpl));
        type.setAnzahlGaragenStellplaetze(this.getEstateValueAsLong("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl));
        type.setAnzahlSchlafzimmer(this.getEstateValueAsLong("FLAECHEN", "ANZ_SCHLAFZIMMER", estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBarrierefrei(this.getEstateValueAsBoolean("AUSSTATTUNG", "BARRIEREFREI", estateImpl));
        type.setBaujahr(this.getEstateValueAsLong("ZUSTAND", "BAUJAHR", estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setBetreutesWohnen(this.hasEstateValue("AUSSTATTUNG", "SERVICELEISTUNGEN", "BETREUTES_WOHNEN", estateImpl));
        type.setEinbaukueche(this.hasEstateValue("AUSSTATTUNG", "KUECHE", "EINBAUKUECHE", estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagenzahl(this.getEstateValueAsLong("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl));
        type.setFreiAb(this.getEstateValueAsNonEmptyString("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl));
        if (StringUtils.isEmpty((String)type.getFreiAb())) {
            type.setFreiAb(this.getFormattedEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        }
        type.setGaesteWC(this.hasEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl));
        type.setGrundstuecksFlaeche(this.getEstateValueAsDouble("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl));
        type.setHausKategorie(this.writeKategorieHaus(list));
        type.setHaustiere(this.writeHaustiere(estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(this.getEstateValueAsLong("ZUSTAND", "SANIERUNG", estateImpl));
        type.setKeller(this.getEstateValueAsBoolean("AUSSTATTUNG", "KELLER", estateImpl));
        type.setMietpreise(IS24XmlUtils.getFactory().createVermarktungWohnMieteTyp());
        type.getMietpreise().setKaltmiete(this.getEstateValueAsDouble("PREISE", "KALTMIETE", estateImpl));
        type.getMietpreise().setKaution(this.getEstateValueAsNonEmptyString("PREISE", "KAUTION", estateImpl));
        if (StringUtils.isEmpty((String)type.getMietpreise().getKaution())) {
            type.getMietpreise().setKaution(this.getFormattedEstateValue("PREISE", "KAUTION_BETRAG", estateImpl));
        }
        type.getMietpreise().setNebenkosten(this.getEstateValueAsDouble("PREISE", "NEBENKOSTEN", estateImpl));
        type.getMietpreise().setStellplatzMiete(this.getEstateValueAsDouble("PREISE", "STELLPLATZ_MIETE", estateImpl));
        type.getMietpreise().setWarmmiete(this.getEstateValueAsDouble("PREISE", "WARMMIETE", estateImpl));
        Boolean bl = this.getEstateValueAsBoolean("PREISE", "NEBENKOSTEN_INKL_HEIZKOSTEN", estateImpl);
        type.getMietpreise().setHeizkostenInWarmmieteEnthalten(bl);
        Double d = this.getEstateValueAsDouble("PREISE", "HEIZKOSTEN", estateImpl);
        if (d != null && d.longValue() > 0L && bl != null) {
            type.getMietpreise().setHeizkosten(d);
        }
        type.setNutzflaeche(this.getEstateValueAsDouble("FLAECHEN", "NUTZFLAECHE", estateImpl));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setParkplatz(this.writeStellplatzKategorie(estateImpl));
        type.setRollstuhlgerecht(this.hasEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl));
        type.setZimmer(this.getEstateValueAsDouble("FLAECHEN", "ANZ_ZIMMER", estateImpl));
        Double d2 = this.getEstateValueAsDouble("FLAECHEN", "WOHNFLAECHE", estateImpl);
        if (d2 == null || d2 <= 0.0) {
            d2 = this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        type.setWohnflaeche(d2);
        if (type.getWohnflaeche() == null || type.getWohnflaeche() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'Wohnflaeche' nicht angegeben (f\u00fcr HausMiete)!");
        }
        if (type.getZimmer() == null || type.getZimmer() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'Zimmer' nicht angegeben (f\u00fcr HausMiete)!");
        }
        if (type.getMietpreise() == null) {
            list2.add("IS24-Pflichtfeld 'Mietpreise' nicht angegeben (f\u00fcr HausMiete)!");
        } else if (type.getMietpreise().getKaltmiete() == null || type.getMietpreise().getKaltmiete() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'Mietpreise/Kaltmiete' nicht angegeben (f\u00fcr HausMiete)!");
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createHausMiete(type) : null;
    }

    protected SonstigeGewerbe convertEstate(EstateImpl estateImpl, SonstigeGewerbe.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        type.setAnzahlParkflaechen(this.getEstateValueAsLong("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBaujahr(this.getEstateValueAsLong("ZUSTAND", "BAUJAHR", estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setBodenbelag(this.writeBodenbelag(estateImpl));
        type.setDenkmalschutzobjekt(this.getEstateValueAsBoolean("VERWALTUNG", "DENKMALGESCHUETZT", estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagen(this.getEstateValueAsNonEmptyString("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl));
        type.setFahrzeitBAB(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_AUTOBAHN", estateImpl)));
        type.setFahrzeitBHf(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_BHF", estateImpl)));
        type.setFahrzeitFlughafen(IS24XmlUtils.getFahrtwegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_FLUG", estateImpl)));
        type.setFreiAb(this.getEstateValueAsNonEmptyString("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl));
        if (StringUtils.isEmpty((String)type.getFreiAb())) {
            type.setFreiAb(this.getFormattedEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        }
        type.setFusswegOeNV(IS24XmlUtils.getFusswegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_BUS", estateImpl)));
        if (type.getFusswegOeNV() == null || type.getFusswegOeNV() <= 0L) {
            type.setFusswegOeNV(IS24XmlUtils.getFusswegZeit(this.getEstateValueAsDouble("UMFELD", "DISTANZ_NAHBHF", estateImpl)));
        }
        type.setGesamtflaeche(this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl));
        type.setGrundstuecksFlaeche(this.getEstateValueAsDouble("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(this.getEstateValueAsLong("ZUSTAND", "SANIERUNG", estateImpl));
        type.setKeller(this.getEstateValueAsBoolean("AUSSTATTUNG", "KELLER", estateImpl));
        type.setNebenflaeche(this.getEstateValueAsDouble("FLAECHEN", "SONSTFLAECHE", estateImpl));
        type.setObjektkategorie2(this.writeKategorieSonstigesGewerbe(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setPersonenaufzug(this.getEstateValueAsBoolean("AUSSTATTUNG", "PERS_LIFT", estateImpl));
        type.setTeilbarAb(this.getEstateValueAsDouble("FLAECHEN", "TEILBAR_AB", estateImpl));
        type.setVermarktung(this.writeVermarktungGewerbe2(estateImpl));
        Double d = this.getEstateValueAsDouble("FLAECHEN", "NUTZFLAECHE", estateImpl);
        if (d == null || d <= 0.0) {
            type.setHauptflaeche(this.getEstateValueAsDouble("FLAECHEN", "GEWERBEFLAECHE", estateImpl));
        }
        if (d == null || d <= 0.0) {
            type.setHauptflaeche(this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl));
        }
        type.setHauptflaeche(d);
        if (type.getObjektkategorie2() == null) {
            list2.add("IS24-Pflichtfeld 'Objektkategorie2' nicht angegeben (f\u00fcr SonstigeGewerbe)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr SonstigeGewerbe)!");
        } else {
            Double d2 = type.getVermarktung().getPreis();
            if (d2 == null || d2 < 0.0) {
                type.getVermarktung().setPreis(0.0);
            }
            if (type.getVermarktung().getMiete() == null && type.getVermarktung().getKauf() == null) {
                list2.add("IS24-Pflichtfeld unvollst\u00e4ndig, weder 'Vermarktung/Miete' noch 'Vermarktung/Kauf' sind angegeben (f\u00fcr SonstigeGewerbe)!");
            }
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createSonstigeGewerbe(type) : null;
    }

    protected WAZ convertEstate(EstateImpl estateImpl, WAZ.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        Object object;
        type.setAnzahlGaragenStellplaetze(this.getEstateValueAsLong("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl));
        type.setAnzahlPersonen(this.getEstateValueAsLong("VERWALTUNG", "MAX_PERSONEN", estateImpl));
        type.setAufzug(this.getEstateValueAsBoolean("AUSSTATTUNG", "PERS_LIFT", estateImpl));
        type.setBalkonTerrasse(this.getEstateValueAsBoolean("AUSSTATTUNG", "BALKON_TERRASSE", estateImpl));
        type.setBarrierefrei(this.getEstateValueAsBoolean("AUSSTATTUNG", "BARRIEREFREI", estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtage(this.getEstateValueAsLong("AUSSTATTUNG", "ETAGE", estateImpl));
        type.setEtagenzahl(this.getEstateValueAsLong("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl));
        type.setFreiAb(this.getEstateValueAsCalendar("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        type.setFreiBis(this.getEstateValueAsCalendar("VERWALTUNG", "VERFUEGBAR_BISDATE", estateImpl));
        type.setGaesteWC(this.hasEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl));
        type.setGartenBenutzung(this.getEstateValueAsBoolean("AUSSTATTUNG", "GARTENNUTZUNG", estateImpl));
        type.setGeschlecht(this.writeGeschlecht(estateImpl));
        type.setHaustiere(this.writeHaustiere(estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setKaution(this.getEstateValueAsNonEmptyString("PREISE", "KAUTION", estateImpl));
        if (StringUtils.isEmpty((String)type.getKaution())) {
            type.setKaution(this.getFormattedEstateValue("PREISE", "KAUTION_BETRAG", estateImpl));
        }
        type.setKeller(this.getEstateValueAsBoolean("AUSSTATTUNG", "KELLER", estateImpl));
        type.setMaximalmietdauer(this.getEstateValueAsDouble("VERWALTUNG", "MAX_MIETDAUER", estateImpl));
        type.setMidestmietdauer(this.getEstateValueAsDouble("VERWALTUNG", "MIN_MIETDAUER", estateImpl));
        type.setMobilar(this.hasEstateValue("AUSSTATTUNG", "MOEBLIERT", "JA", estateImpl));
        type.setObjektzustand(this.writeObjektZustandWaz(estateImpl));
        type.setParkplatz(this.writeStellplatzKategorie(estateImpl));
        type.setParkplatzmiete(this.getEstateValueAsDouble("PREISE", "STELLPLATZ_MIETE", estateImpl));
        type.setRaucherOk(this.writeRaucherOk(estateImpl));
        type.setRollstuhlgerecht(this.hasEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl));
        type.setWazKategorie(this.writeKategorieWaz(list));
        type.setZimmer(this.getEstateValueAsDouble("FLAECHEN", "ANZ_ZIMMER", estateImpl));
        Double d = this.getEstateValueAsDouble("FLAECHEN", "WOHNFLAECHE", estateImpl);
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        type.setWohnflaeche(d);
        if (estateImpl.hasAttribute("PREISE", "KALTMIETE")) {
            type.setMonatsmiete(new WazTyp.Monatsmiete());
            type.getMonatsmiete().setKaltmiete(this.getEstateValueAsDouble("PREISE", "KALTMIETE", estateImpl));
            type.getMonatsmiete().setNebenkosten(this.getEstateValueAsDouble("PREISE", "NEBENKOSTEN", estateImpl));
        } else if (estateImpl.hasAttribute("PREISE", "PAUSCHALMIETE")) {
            type.setPauschalmiete(new WazTyp.Pauschalmiete());
            type.getPauschalmiete().setMietePauschal(this.getEstateValueAsDouble("PREISE", "PAUSCHALMIETE", estateImpl));
            object = this.getEstateValueAsNonEmptyString("PREISE", "MIETE_PRO", estateImpl);
            if ("MONAT".equals(object)) {
                type.getPauschalmiete().setMietePro(WazZeiteinheitenTyp.MONAT);
            } else if ("WOCHE".equals(object)) {
                type.getPauschalmiete().setMietePro(WazZeiteinheitenTyp.WOCHE);
            } else if ("TAG".equals(object)) {
                type.getPauschalmiete().setMietePro(WazZeiteinheitenTyp.TAG);
            }
        }
        if (type.getWazKategorie() == null) {
            list2.add("IS24-Pflichtfeld 'WazKategorie' nicht angegeben (f\u00fcr WAZ)!");
        }
        if (type.getWohnflaeche() == null || type.getWohnflaeche() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'Wohnflaeche' nicht angegeben (f\u00fcr WAZ)!");
        }
        if (type.getZimmer() == null || type.getZimmer() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'Zimmer' nicht angegeben (f\u00fcr WAZ)!");
        }
        if (type.getFreiAb() == null) {
            list2.add("IS24-Pflichtfeld 'FreiAb' nicht angegeben (f\u00fcr WAZ)!");
        }
        if (type.getPauschalmiete() == null) {
            list2.add("IS24-Pflichtfeld 'Pauschalmiete' nicht angegeben (f\u00fcr WAZ)!");
        } else {
            object = type.getPauschalmiete().getMietePauschal();
            if (object == null || (Double)object <= 0.0) {
                list2.add("IS24-Pflichtfeld 'Pauschalmiete/MietePauschal' nicht angegeben (f\u00fcr WAZ)!");
            }
            if (type.getPauschalmiete().getMietePro() == null) {
                list2.add("IS24-Pflichtfeld 'Pauschalmiete/MietePro' nicht angegeben (f\u00fcr WAZ)!");
            }
        }
        if (type.getMonatsmiete() != null && (type.getMonatsmiete().getKaltmiete() == null || type.getMonatsmiete().getKaltmiete() <= 0.0)) {
            list2.add("IS24-Pflichtfeld 'Monatsmiete/Kaltmiete' nicht angegeben (f\u00fcr WAZ)!");
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createWAZ(type) : null;
    }

    protected WGZimmer convertEstate(EstateImpl estateImpl, WGZimmer.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        Serializable serializable;
        Double d;
        type.setAnzahlBadezimmer(this.getEstateValueAsLong("FLAECHEN", "ANZ_BADEZIMMER", estateImpl));
        type.setAufzug(this.getEstateValueAsBoolean("AUSSTATTUNG", "PERS_LIFT", estateImpl));
        type.setBadewanne(this.hasEstateValue("AUSSTATTUNG", "BAD", "WANNE", estateImpl));
        type.setBalkonTerrasse(this.getEstateValueAsBoolean("AUSSTATTUNG", "BALKON_TERRASSE", estateImpl));
        type.setBarrierefrei(this.getEstateValueAsBoolean("AUSSTATTUNG", "BARRIEREFREI", estateImpl));
        type.setBodenbelag(this.writeBodenbelagWohnen(estateImpl));
        type.setDusche(this.hasEstateValue("AUSSTATTUNG", "BAD", "DUSCHE", estateImpl));
        type.setEtage(this.getEstateValueAsLong("AUSSTATTUNG", "ETAGE", estateImpl));
        type.setEtagenzahl(this.getEstateValueAsLong("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl));
        type.setFreiAb(this.getEstateValueAsCalendar("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        type.setFreiBis(this.getEstateValueAsCalendar("VERWALTUNG", "VERFUEGBAR_BISDATE", estateImpl));
        type.setGaesteWC(this.hasEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl));
        type.setGartenBenutzung(this.getEstateValueAsBoolean("AUSSTATTUNG", "GARTENNUTZUNG", estateImpl));
        type.setGesamtflaeche(this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl));
        type.setGeschlechtGesuchterBewohner(this.writeGeschlechtWG(estateImpl));
        type.setHaustiere(this.writeHaustiere(estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setKeller(this.getEstateValueAsBoolean("AUSSTATTUNG", "KELLER", estateImpl));
        type.setMobilar(this.writeMobilar(estateImpl));
        type.setRauchen(this.writeRauchen(estateImpl));
        type.setTVAnschluss(this.writeTvAnschluss(estateImpl));
        type.setWGZimmerKategorie(WGZimmerKategorienTyp.KEINE_ANGABE);
        type.setWaschmaschine(this.hasEstateValue("AUSSTATTUNG", "BAD", "ANSCHLUSS_WASCHMASCHINE", estateImpl));
        type.setZimmer(this.getEstateValueAsDouble("FLAECHEN", "ANZ_ZIMMER", estateImpl));
        type.setMietpreise(IS24XmlUtils.getFactory().createVermarktungWGZimmerTyp());
        type.getMietpreise().setKaltmiete(this.getEstateValueAsDouble("PREISE", "KALTMIETE", estateImpl));
        type.getMietpreise().setKaution(this.getEstateValueAsNonEmptyString("PREISE", "KAUTION", estateImpl));
        if (StringUtils.isEmpty((String)type.getMietpreise().getKaution())) {
            type.getMietpreise().setKaution(this.getFormattedEstateValue("PREISE", "KAUTION_BETRAG", estateImpl));
        }
        type.getMietpreise().setNebenkosten(this.getEstateValueAsDouble("PREISE", "NEBENKOSTEN", estateImpl));
        type.getMietpreise().setWarmmiete(this.getEstateValueAsDouble("PREISE", "WARMMIETE", estateImpl));
        Boolean bl = this.getEstateValueAsBoolean("PREISE", "NEBENKOSTEN_INKL_HEIZKOSTEN", estateImpl);
        type.getMietpreise().setHeizkostenInWarmmieteEnthalten(bl);
        Double d2 = this.getEstateValueAsDouble("PREISE", "HEIZKOSTEN", estateImpl);
        if (d2 != null && d2.longValue() > 0L && bl != null) {
            type.getMietpreise().setHeizkosten(d2);
        }
        if ((d = this.getEstateValueAsDouble("FLAECHEN", "WOHNFLAECHE", estateImpl)) == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        type.setZimmerflaeche(d);
        if (StringUtils.isEmpty((String)type.getSonstigeAngaben())) {
            serializable = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)type.getObjektbeschreibung())) {
                serializable.add(type.getObjektbeschreibung().trim());
            }
            if (!StringUtils.isEmpty((String)type.getLage())) {
                serializable.add(type.getLage().trim());
            }
            if (!StringUtils.isEmpty((String)type.getAusstattung())) {
                serializable.add(type.getAusstattung().trim());
            }
            if (!serializable.isEmpty()) {
                type.setSonstigeAngaben(StringUtils.join(serializable, (String)(this.getXmlLineSeparator() + this.getXmlLineSeparator())).trim());
            }
        }
        type.setAusstattung(null);
        type.setLage(null);
        type.setObjektbeschreibung(null);
        if (type.getZimmerflaeche() == null || type.getZimmerflaeche() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'Zimmerflaeche' nicht angegeben (f\u00fcr WGZimmer)!");
        }
        if (type.getFreiAb() == null) {
            list2.add("IS24-Pflichtfeld 'FreiAb' nicht angegeben (f\u00fcr WGZimmer)!");
        }
        if (type.getMietpreise() == null) {
            list2.add("IS24-Pflichtfeld 'Mietpreise' nicht angegeben (f\u00fcr WGZimmer)!");
        } else {
            serializable = type.getMietpreise().getKaltmiete();
            if (serializable == null || (Double)serializable <= 0.0) {
                list2.add("IS24-Pflichtfeld 'Mietpreise/Kaltmiete' nicht angegeben (f\u00fcr WGZimmer)!");
            }
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createWGZimmer(type) : null;
    }

    protected WohnungKauf convertEstate(EstateImpl estateImpl, WohnungKauf.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        type.setAlsFerienwohnungGeeignet(this.getEstateValueAsBoolean("VERWALTUNG", "ALS_FERIEN", estateImpl));
        type.setAnzahlBadezimmer(this.getEstateValueAsLong("FLAECHEN", "ANZ_BADEZIMMER", estateImpl));
        type.setAnzahlGaragenStellplaetze(this.getEstateValueAsLong("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl));
        type.setAnzahlSchlafzimmer(this.getEstateValueAsLong("FLAECHEN", "ANZ_SCHLAFZIMMER", estateImpl));
        type.setAufzug(this.getEstateValueAsBoolean("AUSSTATTUNG", "PERS_LIFT", estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBalkonTerrasse(this.getEstateValueAsBoolean("AUSSTATTUNG", "BALKON_TERRASSE", estateImpl));
        type.setBarrierefrei(this.getEstateValueAsBoolean("AUSSTATTUNG", "BARRIEREFREI", estateImpl));
        type.setBaujahr(this.getEstateValueAsLong("ZUSTAND", "BAUJAHR", estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setBetreutesWohnen(this.hasEstateValue("AUSSTATTUNG", "SERVICELEISTUNGEN", "BETREUTES_WOHNEN", estateImpl));
        type.setDenkmalschutzobjekt(this.getEstateValueAsBoolean("VERWALTUNG", "DENKMALGESCHUETZT", estateImpl));
        type.setEinbaukueche(this.hasEstateValue("AUSSTATTUNG", "KUECHE", "EINBAUKUECHE", estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtage(this.getEstateValueAsLong("AUSSTATTUNG", "ETAGE", estateImpl));
        type.setEtagenzahl(this.getEstateValueAsLong("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl));
        type.setFreiAb(this.getEstateValueAsNonEmptyString("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl));
        if (StringUtils.isEmpty((String)type.getFreiAb())) {
            type.setFreiAb(this.getFormattedEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        }
        type.setGaesteWC(this.hasEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl));
        type.setGartenBenutzung(this.getEstateValueAsBoolean("AUSSTATTUNG", "GARTENNUTZUNG", estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(this.getEstateValueAsLong("ZUSTAND", "SANIERUNG", estateImpl));
        type.setKaufpreise(IS24XmlUtils.getFactory().createVermarktungWohnKaufTyp());
        type.getKaufpreise().setKaufpreis(this.getEstateValueAsDouble("PREISE", "KAUFPREIS", estateImpl));
        type.getKaufpreise().setMieteinnahmenProMonat(this.getEstateValueAsDouble("PREISE", "MIETEINNAHMEN_PRO_MONAT", estateImpl));
        type.getKaufpreise().setStellplatzKaufpreis(this.getEstateValueAsDouble("PREISE", "STELLPLATZ_PREIS", estateImpl));
        type.getKaufpreise().setWohngeld(this.getEstateValueAsDouble("PREISE", "HAUSGELD", estateImpl));
        type.setKeller(this.getEstateValueAsBoolean("AUSSTATTUNG", "KELLER", estateImpl));
        type.setNutzflaeche(this.getEstateValueAsDouble("FLAECHEN", "NUTZFLAECHE", estateImpl));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setParkplatz(this.writeStellplatzKategorie(estateImpl));
        type.setRollstuhlgerecht(this.hasEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl));
        type.setVermietet(this.getEstateValueAsBoolean("VERWALTUNG", "VERMIETET", estateImpl));
        type.setWohnungKategorie(this.writeKategorieWohnung(list));
        type.setZimmer(this.getEstateValueAsDouble("FLAECHEN", "ANZ_ZIMMER", estateImpl));
        Double d = this.getEstateValueAsDouble("FLAECHEN", "WOHNFLAECHE", estateImpl);
        if (d == null || d <= 0.0) {
            d = this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        type.setWohnflaeche(d);
        if (type.getWohnflaeche() == null || type.getWohnflaeche() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'Wohnflaeche' nicht angegeben (f\u00fcr WohnungKauf)!");
        }
        if (type.getZimmer() == null || type.getZimmer() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'Zimmer' nicht angegeben (f\u00fcr WohnungKauf)!");
        }
        if (type.getKaufpreise() == null) {
            list2.add("IS24-Pflichtfeld 'Kaufpreise' nicht angegeben (f\u00fcr WohnungKauf)!");
        } else {
            Double d2 = type.getKaufpreise().getKaufpreis();
            if (d2 == null || d2 <= 0.0) {
                list2.add("IS24-Pflichtfeld 'Kaufpreise/Kaufpreis' nicht angegeben (f\u00fcr WohnungKauf)!");
            }
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createWohnungKauf(type) : null;
    }

    protected WohnungMiete convertEstate(EstateImpl estateImpl, WohnungMiete.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        type.setAnzahlBadezimmer(this.getEstateValueAsLong("FLAECHEN", "ANZ_BADEZIMMER", estateImpl));
        type.setAnzahlGaragenStellplaetze(this.getEstateValueAsLong("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl));
        type.setAnzahlSchlafzimmer(this.getEstateValueAsLong("FLAECHEN", "ANZ_SCHLAFZIMMER", estateImpl));
        type.setAufzug(this.getEstateValueAsBoolean("AUSSTATTUNG", "PERS_LIFT", estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBalkonTerrasse(this.getEstateValueAsBoolean("AUSSTATTUNG", "BALKON_TERRASSE", estateImpl));
        type.setBarrierefrei(this.getEstateValueAsBoolean("AUSSTATTUNG", "BARRIEREFREI", estateImpl));
        type.setBaujahr(this.getEstateValueAsLong("ZUSTAND", "BAUJAHR", estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setBetreutesWohnen(this.hasEstateValue("AUSSTATTUNG", "SERVICELEISTUNGEN", "BETREUTES_WOHNEN", estateImpl));
        type.setEinbaukueche(this.hasEstateValue("AUSSTATTUNG", "KUECHE", "EINBAUKUECHE", estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtage(this.getEstateValueAsLong("AUSSTATTUNG", "ETAGE", estateImpl));
        type.setEtagenzahl(this.getEstateValueAsLong("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl));
        type.setFoerderung(this.getEstateValueAsBoolean("VERWALTUNG", "WBS_SOZIALWOHNUNG", estateImpl));
        type.setFreiAb(this.getEstateValueAsNonEmptyString("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl));
        if (StringUtils.isEmpty((String)type.getFreiAb())) {
            type.setFreiAb(this.getFormattedEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        }
        type.setGaesteWC(this.hasEstateValue("AUSSTATTUNG", "RAEUME", "GAESTE_WC", estateImpl));
        type.setGartenBenutzung(this.getEstateValueAsBoolean("AUSSTATTUNG", "GARTENNUTZUNG", estateImpl));
        type.setHaustiere(this.writeHaustiere(estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(this.getEstateValueAsLong("ZUSTAND", "SANIERUNG", estateImpl));
        type.setKeller(this.getEstateValueAsBoolean("AUSSTATTUNG", "KELLER", estateImpl));
        type.setMietpreise(IS24XmlUtils.getFactory().createVermarktungWohnMieteTyp());
        type.getMietpreise().setKaltmiete(this.getEstateValueAsDouble("PREISE", "KALTMIETE", estateImpl));
        type.getMietpreise().setKaution(this.getEstateValueAsNonEmptyString("PREISE", "KAUTION", estateImpl));
        if (StringUtils.isEmpty((String)type.getMietpreise().getKaution())) {
            type.getMietpreise().setKaution(this.getFormattedEstateValue("PREISE", "KAUTION_BETRAG", estateImpl));
        }
        type.getMietpreise().setNebenkosten(this.getEstateValueAsDouble("PREISE", "NEBENKOSTEN", estateImpl));
        type.getMietpreise().setStellplatzMiete(this.getEstateValueAsDouble("PREISE", "STELLPLATZ_MIETE", estateImpl));
        type.getMietpreise().setWarmmiete(this.getEstateValueAsDouble("PREISE", "WARMMIETE", estateImpl));
        Boolean bl = this.getEstateValueAsBoolean("PREISE", "NEBENKOSTEN_INKL_HEIZKOSTEN", estateImpl);
        type.getMietpreise().setHeizkostenInWarmmieteEnthalten(bl);
        Double d = this.getEstateValueAsDouble("PREISE", "HEIZKOSTEN", estateImpl);
        if (d != null && d.longValue() > 0L && bl != null) {
            type.getMietpreise().setHeizkosten(d);
        }
        type.setNutzflaeche(this.getEstateValueAsDouble("FLAECHEN", "NUTZFLAECHE", estateImpl));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setParkplatz(this.writeStellplatzKategorie(estateImpl));
        type.setRollstuhlgerecht(this.hasEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl));
        type.setWohnungKategorie(this.writeKategorieWohnung(list));
        type.setZimmer(this.getEstateValueAsDouble("FLAECHEN", "ANZ_ZIMMER", estateImpl));
        Double d2 = this.getEstateValueAsDouble("FLAECHEN", "WOHNFLAECHE", estateImpl);
        if (d2 == null || d2 <= 0.0) {
            d2 = this.getEstateValueAsDouble("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        type.setWohnflaeche(d2);
        if (type.getWohnflaeche() == null || type.getWohnflaeche() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'Wohnflaeche' nicht angegeben (f\u00fcr WohnungMiete)!");
        }
        if (type.getZimmer() == null || type.getZimmer() <= 0.0) {
            list2.add("IS24-Pflichtfeld 'Zimmer' nicht angegeben (f\u00fcr WohnungMiete)!");
        }
        if (type.getMietpreise() == null) {
            list2.add("IS24-Pflichtfeld 'Mietpreise' nicht angegeben (f\u00fcr WohnungMiete)!");
        } else {
            Double d3 = type.getMietpreise().getKaltmiete();
            if (d3 == null || d3 <= 0.0) {
                list2.add("IS24-Pflichtfeld 'Mietpreise/Kaltmiete' nicht angegeben (f\u00fcr WohnungMiete)!");
            }
        }
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createWohnungMiete(type) : null;
    }

    protected Zwangsversteigerung convertEstate(EstateImpl estateImpl, Zwangsversteigerung.Type type, List<String> list, List<String> list2) throws OpenEstateException {
        list2.add("'Zwangsversteigerung' wird derzeit nicht unterst\u00fctzt!");
        return list2.isEmpty() ? IS24XmlUtils.getFactory().createZwangsversteigerung(type) : null;
    }

    protected ImmobilienTransferTyp createRoot() {
        ImmobilienTransferTyp immobilienTransferTyp = IS24XmlUtils.getFactory().createImmobilienTransferTyp();
        immobilienTransferTyp.setAnbieter(new ImmobilienTransferTyp.Anbieter());
        immobilienTransferTyp.setEmailBeiFehler("webmaster@immobilienscout24.de");
        immobilienTransferTyp.setErstellerSoftware("OpenEstate-DevUtils");
        immobilienTransferTyp.setErstellerSoftwareVersion("1.0");
        return immobilienTransferTyp;
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    public IS24ImmobilienTransfer write(SerializableXmlElement serializableXmlElement) {
        if (serializableXmlElement instanceof AgencyImpl) {
            return this.write((AgencyImpl)serializableXmlElement);
        }
        if (serializableXmlElement instanceof TransferImpl) {
            return this.write((TransferImpl)serializableXmlElement);
        }
        throw new IllegalArgumentException("unsupported src-class: " + (serializableXmlElement != null ? serializableXmlElement.getClass().getName() : "null"));
    }

    public IS24ImmobilienTransfer write(AgencyImpl agencyImpl) {
        this.getErrorMap().clear();
        ImmobilienTransferTyp immobilienTransferTyp = this.createRoot();
        if (agencyImpl == null) {
            LOGGER.warn((Object)"no agency was provided!");
        } else {
            ImmobilienTransferTyp.Anbieter anbieter = this.convertAgent(agencyImpl.getAgent());
            for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
                try {
                    String string = estateImpl.getContactId();
                    AgentContactImpl agentContactImpl = string != null && agencyImpl.getContacts().containsKey(string) ? agencyImpl.getContacts().get(string) : new AgentContactImpl();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    JAXBElement jAXBElement = this.convertEstate(estateImpl, agencyImpl.getAgent(), agentContactImpl, arrayList);
                    if (!arrayList.isEmpty()) {
                        this.putErrors(estateImpl.getId(), arrayList);
                        continue;
                    }
                    ((ImmobilieBaseTyp)jAXBElement.getValue()).setImportmodus(AktionsTyp.AKTUALISIEREN);
                    anbieter.getImmobilien().add(jAXBElement);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Fehler beim Parsen der Immobilie!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
            immobilienTransferTyp.setAnbieter(anbieter);
        }
        return IS24XmlUtils.getFactory().createIS24ImmobilienTransfer(immobilienTransferTyp);
    }

    public IS24ImmobilienTransfer write(TransferImpl transferImpl) {
        this.getErrorMap().clear();
        ImmobilienTransferTyp immobilienTransferTyp = this.createRoot();
        if (transferImpl == null) {
            LOGGER.warn((Object)"no transfer was provided!");
        } else if (transferImpl.getAgencies().isEmpty()) {
            LOGGER.warn((Object)"no transferable agent found!");
        } else {
            JAXBElement jAXBElement;
            ArrayList<String> arrayList;
            Object object;
            Object exception;
            TransferAgencyImpl transferAgencyImpl = transferImpl.getAgencies().get(0);
            ImmobilienTransferTyp.Anbieter anbieter = this.convertAgent(transferAgencyImpl.getAgent());
            for (EstateImpl object3 : transferAgencyImpl.getEstatesToSave()) {
                try {
                    exception = object3.getContactId();
                    object = transferAgencyImpl.getContacts().containsKey(exception) ? transferAgencyImpl.getContacts().get(exception) : new AgentContactImpl();
                    arrayList = new ArrayList<String>();
                    jAXBElement = this.convertEstate(object3, transferAgencyImpl.getAgent(), (AgentContactImpl)object, arrayList);
                    if (!arrayList.isEmpty()) {
                        this.putErrors(object3.getId(), arrayList);
                        continue;
                    }
                    ((ImmobilieBaseTyp)jAXBElement.getValue()).setImportmodus(AktionsTyp.AKTUALISIEREN);
                    anbieter.getImmobilien().add(jAXBElement);
                }
                catch (Exception exception2) {
                    LOGGER.error((Object)"Fehler beim Parsen der Immobilie!");
                    LOGGER.error((Object)("> " + exception2.getLocalizedMessage()), (Throwable)exception2);
                }
            }
            for (String string : transferAgencyImpl.getEstateIdsToRemove()) {
                try {
                    exception = new EstateImpl();
                    ((EstateImpl)exception).setId(string);
                    ((EstateImpl)exception).setCurrency(Currency.getInstance(Locale.GERMANY));
                    ((EstateImpl)exception).getAdress().setPostalCode("13125");
                    ((EstateImpl)exception).getAdress().setCity("Berlin");
                    ((EstateImpl)exception).getAdress().setCountry(Locale.GERMANY.getCountry());
                    ((EstateImpl)exception).setType("MAIN_STELLPLATZ", "KAUF");
                    object = ((EstateImpl)exception).getType().getAttrib("PREISE", "KAUFPREIS");
                    ((EstateImpl)exception).putAttribute((OpenEstateAttrib)object, ((OpenEstateAttrib)object).createValue(Float.valueOf(1.0f)));
                    arrayList = new ArrayList();
                    jAXBElement = this.convertEstate((EstateImpl)exception, transferAgencyImpl.getAgent(), null, arrayList);
                    if (!arrayList.isEmpty()) {
                        this.putErrors(((EstateImpl)exception).getId(), arrayList);
                        continue;
                    }
                    ((ImmobilieBaseTyp)jAXBElement.getValue()).setImportmodus(AktionsTyp.LOESCHEN);
                    ((ImmobilieBaseTyp)jAXBElement.getValue()).setStatusHP(StatusTyp.INAKTIV);
                    ((ImmobilieBaseTyp)jAXBElement.getValue()).setStatusIS24(StatusTyp.INAKTIV);
                    ((ImmobilieBaseTyp)jAXBElement.getValue()).setStatusVBM(StatusTyp.INAKTIV);
                    anbieter.getImmobilien().add(jAXBElement);
                }
                catch (Exception exception3) {
                    LOGGER.error((Object)"Fehler beim Parsen der Immobilie!");
                    LOGGER.error((Object)("> " + exception3.getLocalizedMessage()), (Throwable)exception3);
                }
            }
            immobilienTransferTyp.setAnbieter(anbieter);
        }
        return IS24XmlUtils.getFactory().createIS24ImmobilienTransfer(immobilienTransferTyp);
    }

    protected AusstattungsqualitaetsTyp writeAustattungsQualitaet(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        String string = this.getEstateValueAsNonEmptyString("AUSSTATTUNG", "AUSSTATTUNG_ART", estateImpl);
        if ("EINFACH".equals(string)) {
            return AusstattungsqualitaetsTyp.EINFACH;
        }
        if ("GEHOBEN".equals(string)) {
            return AusstattungsqualitaetsTyp.GEHOBEN;
        }
        if ("LUXUS".equals(string)) {
            return AusstattungsqualitaetsTyp.LUXUS;
        }
        if ("NORMAL".equals(string)) {
            return AusstattungsqualitaetsTyp.NORMAL;
        }
        return null;
    }

    protected BauphaseTyp writeBauphase(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        String string = this.getEstateValueAsNonEmptyString("ZUSTAND", "BAUPHASE", estateImpl);
        if ("ABGESCHLOSSEN".equals(string)) {
            return BauphaseTyp.HAUS_FERTIG_GESTELLT;
        }
        if ("IM_BAU".equals(string)) {
            return BauphaseTyp.HAUS_IM_BAU;
        }
        if ("IN_PLANUNG".equals(string)) {
            return BauphaseTyp.HAUS_IN_PLANUNG;
        }
        return BauphaseTyp.KEINE_ANGABE;
    }

    protected GrundstueckGewerbeEmpfohleneNutzung writeBebaubarMitGewerbe(EstateImpl estateImpl) {
        String[] stringArray;
        if (estateImpl == null) {
            return null;
        }
        GrundstueckGewerbeEmpfohleneNutzung grundstueckGewerbeEmpfohleneNutzung = IS24XmlUtils.getFactory().createGrundstueckGewerbeEmpfohleneNutzung();
        if (!estateImpl.hasAttribute("VERWALTUNG.BEBAUBAR_MIT")) {
            return null;
        }
        for (String string : stringArray = (String[])estateImpl.getAttribute("VERWALTUNG.BEBAUBAR_MIT").getValueObject()) {
            if ("ACKER".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setAckerland(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungAckerland(null));
                continue;
            }
            if ("BAUERWARTUNG".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setBauerwartungsland(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungBauerwartungsland(null));
                continue;
            }
            if ("BOOTSSTAENDE".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setBootsstaende(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungBootsstaende(null));
                continue;
            }
            if ("BUERO".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setBuero(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungBuero(null));
                continue;
            }
            if ("CAMPING".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setCamping(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungCamping(null));
                continue;
            }
            if ("EINZELHANDEL_GROSS".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setEinzelhandelGross(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungEinzelhandelGross(null));
                continue;
            }
            if ("EINZELHANDEL_KLEIN".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setEinzelhandelKlein(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungEinzelhandelKlein(null));
                continue;
            }
            if ("GARAGE".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setGaragen(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungGaragen(null));
                continue;
            }
            if ("GARTEN".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setGarten(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungGarten(null));
                continue;
            }
            if ("GASTRONOMIE".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setGastronomie(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungGastronomie(null));
                continue;
            }
            if ("GEWERBE".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setGewerbe(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungGewerbe(null));
                continue;
            }
            if ("HOTEL".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setHotel(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungHotel(null));
                continue;
            }
            if ("INDUSTRIE".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setIndustrie(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungIndustrie(null));
                continue;
            }
            if ("KEINE_BEBAUUNG".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setKeineBebauung(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungKeineBebauung(null));
                continue;
            }
            if ("KLEINGEWERBE".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setKleingewerbe(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungKleingewerbe(null));
                continue;
            }
            if ("LAGER".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setLager(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungLager(null));
                continue;
            }
            if ("OBSTPFLANZUNG".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setObstpflanzung(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungObstpflanzung(null));
                continue;
            }
            if ("PARKHAUS".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setParkhaus(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungParkhaus(null));
                continue;
            }
            if ("PRODUKTION".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setProduktion(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungProduktion(null));
                continue;
            }
            if ("STELLPLAETZE".equals(string)) {
                grundstueckGewerbeEmpfohleneNutzung.setStellplaetze(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungStellplaetze(null));
                continue;
            }
            if (!"WALD".equals(string)) continue;
            grundstueckGewerbeEmpfohleneNutzung.setWald(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungWald(null));
        }
        return grundstueckGewerbeEmpfohleneNutzung;
    }

    protected GrundstueckWohnenEmpfohleneNutzung writeBebaubarMitWohnen(EstateImpl estateImpl) {
        String[] stringArray;
        if (estateImpl == null) {
            return null;
        }
        GrundstueckWohnenEmpfohleneNutzung grundstueckWohnenEmpfohleneNutzung = IS24XmlUtils.getFactory().createGrundstueckWohnenEmpfohleneNutzung();
        if (!estateImpl.hasAttribute("VERWALTUNG.BEBAUBAR_MIT")) {
            return null;
        }
        for (String string : stringArray = (String[])estateImpl.getAttribute("VERWALTUNG.BEBAUBAR_MIT").getValueObject()) {
            if ("BAUERWARTUNG".equals(string)) {
                grundstueckWohnenEmpfohleneNutzung.setBauerwartungsland(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungBauerwartungsland(null));
                continue;
            }
            if ("DOPPELHAUS".equals(string)) {
                grundstueckWohnenEmpfohleneNutzung.setDoppelhaus(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungDoppelhaus(null));
                continue;
            }
            if ("EFH".equals(string)) {
                grundstueckWohnenEmpfohleneNutzung.setEinfamilienhaus(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungEinfamilienhaus(null));
                continue;
            }
            if ("GARAGE".equals(string)) {
                grundstueckWohnenEmpfohleneNutzung.setGaragen(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungGaragen(null));
                continue;
            }
            if ("GARTEN".equals(string)) {
                grundstueckWohnenEmpfohleneNutzung.setGarten(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungGarten(null));
                continue;
            }
            if ("KEINE_BEBAUUNG".equals(string)) {
                grundstueckWohnenEmpfohleneNutzung.setKeineBebauung(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungKeineBebauung(null));
                continue;
            }
            if ("MFH".equals(string)) {
                grundstueckWohnenEmpfohleneNutzung.setMehrfamilienhaus(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungMehrfamilienhaus(null));
                continue;
            }
            if ("OBSTPFLANZUNG".equals(string)) {
                grundstueckWohnenEmpfohleneNutzung.setObstpflanzung(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungObstpflanzung(null));
                continue;
            }
            if ("REIHENHAUS".equals(string)) {
                grundstueckWohnenEmpfohleneNutzung.setReihenhaus(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungReihenhaus(null));
                continue;
            }
            if ("STELLPLAETZE".equals(string)) {
                grundstueckWohnenEmpfohleneNutzung.setStellplaetze(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungStellplaetze(null));
                continue;
            }
            if ("VILLA".equals(string)) {
                grundstueckWohnenEmpfohleneNutzung.setVilla(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungVilla(null));
                continue;
            }
            if (!"WALD".equals(string)) continue;
            grundstueckWohnenEmpfohleneNutzung.setWald(IS24XmlUtils.getFactory().createGrundstueckEmpfohleneNutzungWald(null));
        }
        return grundstueckWohnenEmpfohleneNutzung;
    }

    protected BebaubarNachTyp writeBebaubarNach(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        String string = this.getEstateValueAsNonEmptyString("VERWALTUNG", "BEBAUBAR_NACH", estateImpl);
        if ("BEBAUUNGSPLAN".equals(string)) {
            return BebaubarNachTyp.BAUGB_30;
        }
        if ("NACHBARBEBAUUNG".equals(string)) {
            return BebaubarNachTyp.BAUGB_34;
        }
        if ("AUSSENGEBIET".equals(string)) {
            return BebaubarNachTyp.BAUGB_35;
        }
        return null;
    }

    protected BefeuerungsArtTyp writeBefeuerung(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        BefeuerungsArtTyp befeuerungsArtTyp = IS24XmlUtils.getFactory().createBefeuerungsArtTyp();
        if (!estateImpl.hasAttribute("AUSSTATTUNG.BEFEUERUNG")) {
            befeuerungsArtTyp.setKeineAngabe(IS24XmlUtils.getFactory().createBefeuerungsArtTypKeineAngabe(null));
        } else {
            String[] stringArray;
            for (String string : stringArray = (String[])estateImpl.getAttribute("AUSSTATTUNG.BEFEUERUNG").getValueObject()) {
                if ("ELEKTRO".equals(string)) {
                    befeuerungsArtTyp.setStrom(IS24XmlUtils.getFactory().createBefeuerungsArtTypStrom(null));
                    continue;
                }
                if ("ERDWAERME".equals(string)) {
                    befeuerungsArtTyp.setErdwaerme(IS24XmlUtils.getFactory().createBefeuerungsArtTypErdwaerme(null));
                    continue;
                }
                if ("FERNWAERME".equals(string)) {
                    befeuerungsArtTyp.setFernwaerme(IS24XmlUtils.getFactory().createBefeuerungsArtTypFernwaerme(null));
                    continue;
                }
                if ("GAS".equals(string)) {
                    befeuerungsArtTyp.setGas(IS24XmlUtils.getFactory().createBefeuerungsArtTypGas(null));
                    continue;
                }
                if ("KOHLE".equals(string)) {
                    befeuerungsArtTyp.setKohle(IS24XmlUtils.getFactory().createBefeuerungsArtTypKohle(null));
                    continue;
                }
                if ("OEL".equals(string)) {
                    befeuerungsArtTyp.setOel(IS24XmlUtils.getFactory().createBefeuerungsArtTypOel(null));
                    continue;
                }
                if ("PELLETS".equals(string)) {
                    befeuerungsArtTyp.setPelletheizung(IS24XmlUtils.getFactory().createBefeuerungsArtTypPelletheizung(null));
                    continue;
                }
                if (!"SOLAR".equals(string)) continue;
                befeuerungsArtTyp.setSolarheizung(IS24XmlUtils.getFactory().createBefeuerungsArtTypSolarheizung(null));
            }
            if (befeuerungsArtTyp.getErdwaerme() == null && befeuerungsArtTyp.getFernwaerme() == null && befeuerungsArtTyp.getGas() == null && befeuerungsArtTyp.getKohle() == null && befeuerungsArtTyp.getOel() == null && befeuerungsArtTyp.getPelletheizung() == null && befeuerungsArtTyp.getSolarheizung() == null && befeuerungsArtTyp.getStrom() == null) {
                befeuerungsArtTyp.setKeineAngabe(IS24XmlUtils.getFactory().createBefeuerungsArtTypKeineAngabe(null));
            }
        }
        return befeuerungsArtTyp;
    }

    protected BodenbelagTyp writeBodenbelag(EstateImpl estateImpl) {
        String[] stringArray;
        if (estateImpl == null) {
            return null;
        }
        if (!estateImpl.hasAttribute("AUSSTATTUNG.BODENBELAG")) {
            return null;
        }
        for (String string : stringArray = (String[])estateImpl.getAttribute("AUSSTATTUNG.BODENBELAG").getValueObject()) {
            if ("BETON".equals(string)) {
                return BodenbelagTyp.BETON;
            }
            if ("DIELEN".equals(string) || "DIELEN_GESCHLIFFEN".equals(string)) {
                return BodenbelagTyp.DIELEN;
            }
            if ("EPOXIDHARZ".equals(string)) {
                return BodenbelagTyp.EPOXIDHARZ;
            }
            if ("FLIESEN".equals(string) || "KERAMIK".equals(string) || "TERRAKOTTA".equals(string)) {
                return BodenbelagTyp.FLIESEN;
            }
            if ("LAMINAT".equals(string)) {
                return BodenbelagTyp.LAMINAT;
            }
            if ("PARKETT".equals(string)) {
                return BodenbelagTyp.PARKETT;
            }
            if ("PVC".equals(string)) {
                return BodenbelagTyp.PVC;
            }
            if ("STEIN".equals(string) || "GRANIT".equals(string) || "MARMOR".equals(string) || "SCHIEFER".equals(string)) {
                return BodenbelagTyp.STEIN;
            }
            if ("TEPPICH".equals(string)) {
                return BodenbelagTyp.TEPPICHBODEN;
            }
            if (!"TEPPICH_ANTISTAT".equals(string)) continue;
            return BodenbelagTyp.TEPPICHBODEN_ANTISTATISCH;
        }
        return BodenbelagTyp.KEINE_ANGABE;
    }

    protected BodenbelagWohnenTyp writeBodenbelagWohnen(EstateImpl estateImpl) {
        String[] stringArray;
        if (estateImpl == null) {
            return null;
        }
        if (!estateImpl.hasAttribute("AUSSTATTUNG.BODENBELAG")) {
            return null;
        }
        for (String string : stringArray = (String[])estateImpl.getAttribute("AUSSTATTUNG.BODENBELAG").getValueObject()) {
            if ("DIELEN".equals(string) || "DIELEN_GESCHLIFFEN".equals(string)) {
                return BodenbelagWohnenTyp.DIELEN;
            }
            if ("FLIESEN".equals(string) || "KERAMIK".equals(string) || "TERRAKOTTA".equals(string)) {
                return BodenbelagWohnenTyp.FLIESEN;
            }
            if ("LAMINAT".equals(string)) {
                return BodenbelagWohnenTyp.LAMINAT;
            }
            if ("PARKETT".equals(string)) {
                return BodenbelagWohnenTyp.PARKETT;
            }
            if ("PVC".equals(string)) {
                return BodenbelagWohnenTyp.PVC;
            }
            if (!"TEPPICH".equals(string)) continue;
            return BodenbelagWohnenTyp.TEPPICHBODEN;
        }
        return BodenbelagWohnenTyp.KEINE_ANGABE;
    }

    protected DatenVerkabelungsTyp writeDatenverkabelung(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        Boolean bl = this.hasEstateValue("AUSSTATTUNG", "TECHNIK", "DV_VERKABELUNG", estateImpl);
        if (Boolean.TRUE.equals(bl)) {
            return DatenVerkabelungsTyp.JA;
        }
        if (Boolean.FALSE.equals(bl)) {
            return DatenVerkabelungsTyp.NEIN;
        }
        return DatenVerkabelungsTyp.KEINE_ANGABE;
    }

    protected EnergieausweisTyp writeEnergieausweis(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        EnergieausweisTyp energieausweisTyp = IS24XmlUtils.getFactory().createEnergieausweisTyp();
        energieausweisTyp.setEnergieausweistyp(EnergieausweistypTyp.KEINE_ANGABE);
        String string = this.getEstateValueAsNonEmptyString("ENERGIEPASS", "ART", estateImpl);
        if ("BEDARF".equals(string)) {
            energieausweisTyp.setEnergieausweistyp(EnergieausweistypTyp.ENDENERGIEBEDARF);
            energieausweisTyp.setEnergieverbrauchskennwert(this.getEstateValueAsDouble("ENERGIEPASS", "BEDARF_GESAMT", estateImpl));
        } else if ("VERBRAUCH".equals(string)) {
            energieausweisTyp.setEnergieausweistyp(EnergieausweistypTyp.ENERGIEVERBRAUCHSKENNWERT);
            energieausweisTyp.setEnergieverbrauchskennwert(this.getEstateValueAsDouble("ENERGIEPASS", "VERBRAUCH_GESAMT", estateImpl));
            energieausweisTyp.setWarmwasserEnthalten(this.getEstateValueAsBoolean("ENERGIEPASS", "VERBRAUCH_INKL_WARMWASSER", estateImpl));
        } else {
            Double d = this.getEstateValueAsDouble("ENERGIEPASS", "VERBRAUCH_GESAMT", estateImpl);
            Boolean bl = this.getEstateValueAsBoolean("ENERGIEPASS", "VORHANDEN", estateImpl);
            if (Boolean.TRUE.equals(bl) && d != null && d > 0.0) {
                energieausweisTyp.setEnergieausweistyp(EnergieausweistypTyp.ENERGIEVERBRAUCHSKENNWERT);
                energieausweisTyp.setEnergieverbrauchskennwert(d);
                energieausweisTyp.setWarmwasserEnthalten(null);
            }
        }
        return energieausweisTyp;
    }

    protected ErschliessungszustandTyp writeErschliessungszustand(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        String string = this.getEstateValueAsNonEmptyString("ZUSTAND", "ERSCHLIESSUNG", estateImpl);
        if ("TEILERSCHLOSSEN".equals(string)) {
            return ErschliessungszustandTyp.TEILERSCHLOSSEN;
        }
        if ("UNERSCHLOSSEN".equals(string)) {
            return ErschliessungszustandTyp.UNERSCHLOSSEN;
        }
        if ("VOLLERSCHLOSSEN".equals(string)) {
            return ErschliessungszustandTyp.ERSCHLOSSEN;
        }
        return ErschliessungszustandTyp.UNBEKANNT;
    }

    protected GeschlechtTyp writeGeschlecht(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        String string = this.getEstateValueAsNonEmptyString("VERWALTUNG", "GESCHLECHT", estateImpl);
        if ("FRAU".equals(string)) {
            return GeschlechtTyp.NUR_FRAUEN;
        }
        if ("MANN".equals(string)) {
            return GeschlechtTyp.NUR_MAENNER;
        }
        return null;
    }

    protected WGZimmerGeschlechtTyp writeGeschlechtWG(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        String string = this.getEstateValueAsNonEmptyString("VERWALTUNG", "GESCHLECHT", estateImpl);
        if ("FRAU".equals(string)) {
            return WGZimmerGeschlechtTyp.WEIBLICH;
        }
        if ("MANN".equals(string)) {
            return WGZimmerGeschlechtTyp.MAENNLICH;
        }
        return null;
    }

    protected GenehmigungTyp writeHaustiere(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        String string = this.getEstateValueAsNonEmptyString("VERWALTUNG", "HAUSTIERE", estateImpl);
        if ("JA".equals(string)) {
            return GenehmigungTyp.ERLAUBT;
        }
        if ("NEIN".equals(string)) {
            return GenehmigungTyp.VERBOTEN;
        }
        if ("VEREINBARUNG".equals(string)) {
            return GenehmigungTyp.NACH_VEREINBARUNG;
        }
        return GenehmigungTyp.KEINE_ANGABE;
    }

    protected HeizungsartTyp writeHeizungsart(EstateImpl estateImpl) {
        String[] stringArray;
        if (estateImpl == null) {
            return null;
        }
        if (!estateImpl.hasAttribute("AUSSTATTUNG.HEIZUNGSART")) {
            return null;
        }
        for (String string : stringArray = (String[])estateImpl.getAttribute("AUSSTATTUNG.HEIZUNGSART").getValueObject()) {
            if ("ETAGE".equals(string)) {
                return HeizungsartTyp.ETAGENHEIZUNG;
            }
            if ("OFEN".equals(string)) {
                return HeizungsartTyp.OFENHEIZUNG;
            }
            if (!"ZENTRAL".equals(string)) continue;
            return HeizungsartTyp.ZENTRALHEIZUNG;
        }
        return HeizungsartTyp.KEINE_ANGABE;
    }

    protected AnlageobjekteKategorieTyp writeKategorieAnlage(List<String> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            String string = list.get(i);
            if ("BUEROHAUS".equals(string)) {
                return AnlageobjekteKategorieTyp.BUEROGEBAEUDE;
            }
            if ("WOHNUNG".equals(string)) {
                return AnlageobjekteKategorieTyp.EIGENTUMSWOHNUNG;
            }
            if ("EFH".equals(string)) {
                return AnlageobjekteKategorieTyp.EINFAMILIENHAUS;
            }
            if ("EINKAUFSZENTRUM".equals(string)) {
                return AnlageobjekteKategorieTyp.EINKAUFSZENTRUM;
            }
            if ("FREIZEIT_SPORT".equals(string)) {
                return AnlageobjekteKategorieTyp.FREIZEITANLAGE;
            }
            if ("GASTRONOMIE".equals(string)) {
                return AnlageobjekteKategorieTyp.GASTSTAETTE;
            }
            if ("GESCHAEFTSHAUS".equals(string)) {
                return AnlageobjekteKategorieTyp.GESCHAEFTSHAUS;
            }
            if ("GEWERBEZENTRUM".equals(string)) {
                return AnlageobjekteKategorieTyp.GEWERBEANWESEN;
            }
            if ("HALLE_LAGER".equals(string)) {
                return AnlageobjekteKategorieTyp.HALLE_LAGER;
            }
            if ("HOSTEL".equals(string)) {
                return AnlageobjekteKategorieTyp.HOTEL;
            }
            if ("HOTEL".equals(string)) {
                return AnlageobjekteKategorieTyp.HOTEL;
            }
            if ("PRODUKTION".equals(string)) {
                return AnlageobjekteKategorieTyp.INDUSTRIEANWESEN;
            }
            if ("EINZELHANDEL".equals(string)) {
                return AnlageobjekteKategorieTyp.LADEN_VERKAUFSFLAECHE;
            }
            if ("MFH".equals(string)) {
                return AnlageobjekteKategorieTyp.MEHRFAMILIENHAUS;
            }
            if ("SERVICECENTER".equals(string)) {
                return AnlageobjekteKategorieTyp.SERVICECENTER;
            }
            if ("MAIN_GEWERBE".equals(string)) {
                return AnlageobjekteKategorieTyp.SONSTIGE;
            }
            if ("VERBRAUCHERMARKT".equals(string)) {
                return AnlageobjekteKategorieTyp.SUPERMARKT;
            }
            if ("WOHNANLAGE".equals(string)) {
                return AnlageobjekteKategorieTyp.WOHNANLAGE;
            }
            if (!"WOHN_GESCHAEFTSHAUS".equals(string)) continue;
            return AnlageobjekteKategorieTyp.WOHN_GESCHAEFTSHAUS;
        }
        return AnlageobjekteKategorieTyp.SONSTIGE;
    }

    protected BueroPraxisKategorienTyp writeKategorieBueroPraxis(List<String> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            String string = list.get(i);
            if ("ATELIERWOHNUNG".equals(string)) {
                return BueroPraxisKategorienTyp.ATELIER;
            }
            if ("BUERO".equals(string)) {
                return BueroPraxisKategorienTyp.BUERO;
            }
            if ("BUEROHAUS".equals(string)) {
                return BueroPraxisKategorienTyp.BUEROHAUS;
            }
            if ("BUEROZENTRUM".equals(string)) {
                return BueroPraxisKategorienTyp.BUEROZENTRUM;
            }
            if ("BUEROETAGE".equals(string)) {
                return BueroPraxisKategorienTyp.BUERO_ETAGE;
            }
            if ("BUERO_GESCHAEFTSHAUS".equals(string)) {
                return BueroPraxisKategorienTyp.BUERO_UND_GESCHAEFTSGEBAEUDE;
            }
            if ("GEWERBEZENTRUM".equals(string)) {
                return BueroPraxisKategorienTyp.GEWERBE_ZENTRUM;
            }
            if ("LOFTWOHNUNG".equals(string)) {
                return BueroPraxisKategorienTyp.LOFT;
            }
            if ("PRAXIS".equals(string)) {
                return BueroPraxisKategorienTyp.PRAXIS;
            }
            if ("PRAXISETAGE".equals(string)) {
                return BueroPraxisKategorienTyp.PRAXIS_ETAGE;
            }
            if ("PRAXISHAUS".equals(string)) {
                return BueroPraxisKategorienTyp.PRAXIS_HAUS;
            }
            if (!"WOHN_GESCHAEFTSHAUS".equals(string)) continue;
            return BueroPraxisKategorienTyp.WOHN_UND_GESCHAEFTSGEBAEUDE;
        }
        return BueroPraxisKategorienTyp.KEINE_ANGABE;
    }

    protected EinzelhandelKategorienTyp writeKategorieEinzelhandel(List<String> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            String string = list.get(i);
            if ("AUSSTELLUNGSFLAECHE".equals(string)) {
                return EinzelhandelKategorienTyp.AUSSTELLUNGSFLAECHE;
            }
            if ("EINKAUFSZENTRUM".equals(string)) {
                return EinzelhandelKategorienTyp.EINKAUFSZENTRUM;
            }
            if ("KAUFHAUS".equals(string)) {
                return EinzelhandelKategorienTyp.KAUFHAUS;
            }
            if ("KIOSK".equals(string)) {
                return EinzelhandelKategorienTyp.KIOSK;
            }
            if ("LADEN".equals(string) || "LADENLOKAL".equals(string) || "GESCHAEFTSLOKAL".equals(string)) {
                return EinzelhandelKategorienTyp.LADEN;
            }
            if ("SB_MARKT".equals(string)) {
                return EinzelhandelKategorienTyp.SB_MARKT;
            }
            if ("VERKAUFSFLAECHE".equals(string)) {
                return EinzelhandelKategorienTyp.VERKAUFSFLAECHE;
            }
            if (!"VERKAUFSHALLE".equals(string)) continue;
            return EinzelhandelKategorienTyp.VERKAUFSHALLE;
        }
        return EinzelhandelKategorienTyp.KEINE_ANGABE;
    }

    protected GaragenKategorieTyp writeKategorieGarage(List<String> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            String string = list.get(i);
            if ("AUSSENSTELLPLATZ".equals(string)) {
                return GaragenKategorieTyp.AUSSENSTELLPLATZ;
            }
            if ("CARPORT".equals(string)) {
                return GaragenKategorieTyp.CARPORT;
            }
            if ("DUPLEX".equals(string)) {
                return GaragenKategorieTyp.DUPLEX;
            }
            if ("GARAGE".equals(string)) {
                return GaragenKategorieTyp.GARAGE;
            }
            if ("PARKHAUS".equals(string)) {
                return GaragenKategorieTyp.PARKHAUS;
            }
            if (!"TIEFGARAGE".equals(string)) continue;
            return GaragenKategorieTyp.TIEFGARAGE;
        }
        return GaragenKategorieTyp.KEINE_ANGABE;
    }

    protected GastroKategorieTyp writeKategorieGastronomie(List<String> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            String string = list.get(i);
            if ("BAR".equals(string)) {
                return GastroKategorieTyp.BARBETRIEB;
            }
            if ("BISTRO".equals(string)) {
                return GastroKategorieTyp.CAFFEE;
            }
            if ("DISKO".equals(string)) {
                return GastroKategorieTyp.DISKOTHEK;
            }
            if ("BUNGALOW".equals(string)) {
                return GastroKategorieTyp.FERIENBUNGALOW;
            }
            if ("GAST".equals(string)) {
                return GastroKategorieTyp.GAESTEHAUS;
            }
            if ("HOSTEL".equals(string)) {
                return GastroKategorieTyp.HOTEL;
            }
            if ("HOTEL".equals(string)) {
                return GastroKategorieTyp.HOTEL;
            }
            if ("PENSION".equals(string)) {
                return GastroKategorieTyp.PENSION;
            }
            if (!"RESTAURANT".equals(string)) continue;
            return GastroKategorieTyp.RESTAURANT;
        }
        return GastroKategorieTyp.GASTSTAETTE;
    }

    protected GrundstueckGewerbeKategorienTyp writeKategorieGrundstueckGewerbe(List<String> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            String string = list.get(i);
            if ("FREIZEITGRUND".equals(string)) {
                return GrundstueckGewerbeKategorienTyp.FREIZEIT;
            }
            if ("GEWERBEGRUND".equals(string)) {
                return GrundstueckGewerbeKategorienTyp.GEWERBE;
            }
            if (!"LAND_FORSTGRUND".equals(string)) continue;
            return GrundstueckGewerbeKategorienTyp.LAND_FORSTWIRTSCHAFT;
        }
        return GrundstueckGewerbeKategorienTyp.GEWERBE;
    }

    protected HalleProduktionKategorieTyp writeKategorieHalleProduktion(List<String> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            String string = list.get(i);
            if ("AUSSTELLUNGSFLAECHE".equals(string)) {
                return HalleProduktionKategorieTyp.AUSSTELLUNGSFLAECHE;
            }
            if ("HALLE_LAGER".equals(string)) {
                return HalleProduktionKategorieTyp.HALLE;
            }
            if ("HOCHREGALLAGER".equals(string)) {
                return HalleProduktionKategorieTyp.HOCHREGALLAGER;
            }
            if ("INDUSTRIEHALLE".equals(string)) {
                return HalleProduktionKategorieTyp.INDUSTRIEHALLE;
            }
            if ("INDUSTRIEHALLE_FREIFLAECHE".equals(string)) {
                return HalleProduktionKategorieTyp.INDUSTRIEHALLE_MIT_FREIFLAECHE;
            }
            if ("KUEHLHAUS".equals(string)) {
                return HalleProduktionKategorieTyp.KUEHLHAUS;
            }
            if ("KUEHLREGALLAGER".equals(string)) {
                return HalleProduktionKategorieTyp.KUEHLREGALLAGER;
            }
            if ("LAGERFLAECHE".equals(string)) {
                return HalleProduktionKategorieTyp.LAGERFLAECHE;
            }
            if ("LAGERHALLE".equals(string)) {
                return HalleProduktionKategorieTyp.LAGERHALLE;
            }
            if ("SERVICEFLAECHE".equals(string)) {
                return HalleProduktionKategorieTyp.SERVICEFLAECHE;
            }
            if ("SPEDITION".equals(string)) {
                return HalleProduktionKategorieTyp.SPEDITIONSLAGER;
            }
            if (!"WERKSTATT".equals(string)) continue;
            return HalleProduktionKategorieTyp.WERKSTATT;
        }
        return HalleProduktionKategorieTyp.KEINE_ANGABE;
    }

    protected HausKategorienTyp writeKategorieHaus(List<String> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            String string = list.get(i);
            if ("BAUERNHAUS".equals(string)) {
                return HausKategorienTyp.BAUERNHAUS;
            }
            if ("BESONDERES_HAUS".equals(string)) {
                return HausKategorienTyp.BESONDERE_IMMOBILIE;
            }
            if ("BUNGALOW".equals(string)) {
                return HausKategorienTyp.BUNGALOW;
            }
            if ("BURG".equals(string) || "SCHLOSS".equals(string)) {
                return HausKategorienTyp.BURG_SCHLOSS;
            }
            if ("DOPPELHAUSHAELFTE".equals(string)) {
                return HausKategorienTyp.DOPPELHAUSHAELFTE;
            }
            if ("EFH".equals(string)) {
                return HausKategorienTyp.EINFAMILIENHAUS;
            }
            if ("MFH".equals(string)) {
                return HausKategorienTyp.MEHRFAMILIENHAUS;
            }
            if ("REIHENECKHAUS".equals(string)) {
                return HausKategorienTyp.REIHENECKHAUS;
            }
            if ("REIHENHAUS".equals(string)) {
                return HausKategorienTyp.REIHENHAUS;
            }
            if ("REIHENMITTELHAUS".equals(string)) {
                return HausKategorienTyp.REIHENMITTELHAUS;
            }
            if ("HAUS".equals(string)) {
                return HausKategorienTyp.SONSTIGES;
            }
            if ("VILLA".equals(string)) {
                return HausKategorienTyp.VILLA;
            }
            if (!"ZFH".equals(string) && !"DOPPELHAUS".equals(string)) continue;
            return HausKategorienTyp.ZWEIFAMILIENHAUS;
        }
        return HausKategorienTyp.KEINE_ANGABE;
    }

    protected SonstigeGewerbeKategorieTyp writeKategorieSonstigesGewerbe(List<String> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            String string = list.get(i);
            if ("BAUERNHOF".equals(string)) {
                return SonstigeGewerbeKategorieTyp.BAUERNHOF;
            }
            if ("FREIZEIT_SPORT".equals(string)) {
                return SonstigeGewerbeKategorieTyp.FREIZEITANLAGE;
            }
            if ("MAIN_GEWERBE".equals(string)) {
                return SonstigeGewerbeKategorieTyp.GEWERBEFLAECHE;
            }
            if ("REITERHOF".equals(string)) {
                return SonstigeGewerbeKategorieTyp.REITERHOF;
            }
            if ("WEINBAU".equals(string)) {
                return SonstigeGewerbeKategorieTyp.WEINGUT;
            }
            if (!"WERKSTATT".equals(string)) continue;
            return SonstigeGewerbeKategorieTyp.WERKSTATT;
        }
        return SonstigeGewerbeKategorieTyp.GEWERBEFLAECHE;
    }

    protected WazKategorienTyp writeKategorieWaz(List<String> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            String string = list.get(i);
            if ("APPARTMENTWOHNUNG".equals(string)) {
                return WazKategorienTyp.APPARTMENT;
            }
            if ("HAUS".equals(string)) {
                return WazKategorienTyp.HAUS;
            }
            if ("WOHNUNG".equals(string)) {
                return WazKategorienTyp.WOHNUNG;
            }
            if (!"ZIMMER".equals(string)) continue;
            return WazKategorienTyp.ZIMMER;
        }
        return WazKategorienTyp.WOHNUNG;
    }

    protected WohnungKategorienTyp writeKategorieWohnung(List<String> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            String string = list.get(i);
            if ("DACHWOHNUNG".equals(string)) {
                return WohnungKategorienTyp.DACHGESCHOSS;
            }
            if ("ERDGESCHOSSWOHNUNG".equals(string)) {
                return WohnungKategorienTyp.ERDGESCHOSS;
            }
            if ("ETAGENWOHNUNG".equals(string)) {
                return WohnungKategorienTyp.ETAGENWOHNUNG;
            }
            if ("HOCHPARTERRE".equals(string)) {
                return WohnungKategorienTyp.HOCHPARTERRE;
            }
            if ("LOFTWOHNUNG".equals(string)) {
                return WohnungKategorienTyp.LOFT;
            }
            if ("MAISONETTWOHNUNG".equals(string)) {
                return WohnungKategorienTyp.MAISONETTE;
            }
            if ("PENTHOUSEWOHNUNG".equals(string)) {
                return WohnungKategorienTyp.PENTHOUSE;
            }
            if ("WOHNUNG".equals(string)) {
                return WohnungKategorienTyp.SONSTIGE;
            }
            if (!"TERRASSENWOHNUNG".equals(string)) continue;
            return WohnungKategorienTyp.TERRASSENWOHNUNG;
        }
        return WohnungKategorienTyp.KEINE_ANGABE;
    }

    protected JaNeinVereinbarungTyp writeKlimatisiert(EstateImpl estateImpl) {
        Boolean bl = this.getEstateValueAsBoolean("AUSSTATTUNG", "KLIMATISIERT", estateImpl);
        if (Boolean.TRUE.equals(bl)) {
            return JaNeinVereinbarungTyp.JA;
        }
        if (Boolean.FALSE.equals(bl)) {
            return JaNeinVereinbarungTyp.NEIN;
        }
        return JaNeinVereinbarungTyp.KEINE_ANGABE;
    }

    protected HebeanlageTyp writeKranbahn(EstateImpl estateImpl) {
        Boolean bl = this.getEstateValueAsBoolean("AUSSTATTUNG", "KRAN", estateImpl);
        if (!Boolean.TRUE.equals(bl)) {
            return null;
        }
        HebeanlageTyp hebeanlageTyp = IS24XmlUtils.getFactory().createHebeanlageTyp();
        hebeanlageTyp.setTragkraft(this.getEstateValueAsDouble("AUSSTATTUNG", "KRAN_GEWICHT", estateImpl));
        return hebeanlageTyp;
    }

    protected Boolean writeKueche(EstateImpl estateImpl) {
        return estateImpl.hasAttribute("AUSSTATTUNG", "KUECHE") ? Boolean.TRUE : null;
    }

    protected LageartTyp writeLageArt(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        String string = this.getEstateValueAsNonEmptyString("UMFELD", "LAGE_GEWERBE", estateImpl);
        if ("A_LAGE".equalsIgnoreCase(string) || "1A_LAGE".equalsIgnoreCase(string) || "2A_LAGE".equalsIgnoreCase(string)) {
            return LageartTyp.A_LAGE;
        }
        if ("B_LAGE".equalsIgnoreCase(string) || "1B_LAGE".equalsIgnoreCase(string) || "2B_LAGE".equalsIgnoreCase(string)) {
            return LageartTyp.B_LAGE;
        }
        if ("EINKAUFSZENTRUM".equalsIgnoreCase(string)) {
            return LageartTyp.EINKAUFSZENTRUM;
        }
        return LageartTyp.KEINE_ANGABE;
    }

    protected HebeanlageTyp writeLastenaufzug(EstateImpl estateImpl) {
        Boolean bl = this.getEstateValueAsBoolean("AUSSTATTUNG", "LAST_LIFT", estateImpl);
        if (!Boolean.TRUE.equals(bl)) {
            return null;
        }
        HebeanlageTyp hebeanlageTyp = IS24XmlUtils.getFactory().createHebeanlageTyp();
        hebeanlageTyp.setTragkraft(this.getEstateValueAsDouble("AUSSTATTUNG", "LAST_LIFT_GEWICHT", estateImpl));
        return hebeanlageTyp;
    }

    protected MobilarTyp writeMobilar(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        String string = this.getEstateValueAsNonEmptyString("AUSSTATTUNG", "MOEBLIERT", estateImpl);
        if ("JA".equals(string)) {
            return MobilarTyp.JA;
        }
        if ("NEIN".equals(string)) {
            return MobilarTyp.NEIN;
        }
        return MobilarTyp.KEINE_ANGABE;
    }

    protected ObjektZustandTyp writeObjektZustand(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        String string = this.getEstateValueAsNonEmptyString("ZUSTAND", "ZUSTAND", estateImpl);
        if (string == null) {
            return null;
        }
        HashMap<String, ObjektZustandTyp> hashMap = new HashMap<String, ObjektZustandTyp>();
        hashMap.put("ABRISSOBJEKT", ObjektZustandTyp.ABBRUCHREIF);
        hashMap.put("AUSGEZEICHNET", ObjektZustandTyp.GEPFLEGT);
        hashMap.put("ERSTBEZUG", ObjektZustandTyp.ERSTBEZUG);
        hashMap.put("ERSTBEZUG_NACH_SANIERUNG", ObjektZustandTyp.ERSTBEZUG_NACH_SANIERUNG);
        hashMap.put("GEPFLEGT", ObjektZustandTyp.GEPFLEGT);
        hashMap.put("GUT", ObjektZustandTyp.GEPFLEGT);
        hashMap.put("MODERNISIERT", ObjektZustandTyp.MODERNISIERT);
        hashMap.put("NACH_VEREINBARUNG", ObjektZustandTyp.NACH_VEREINBARUNG);
        hashMap.put("NEUWERTIG", ObjektZustandTyp.NEUWERTIG);
        hashMap.put("RENOVIERT_VOLL", ObjektZustandTyp.VOLLSTAENDIG_REONVIERT);
        hashMap.put("RENOVIERUNGSBEDARF_TEIL", ObjektZustandTyp.RENOVIERUNGSBEDUERFTIG);
        hashMap.put("RENOVIERUNGSBEDARF_VOLL", ObjektZustandTyp.RENOVIERUNGSBEDUERFTIG);
        hashMap.put("SANIERT_VOLL", ObjektZustandTyp.SANIERT);
        return hashMap.containsKey(string) ? (ObjektZustandTyp)((Object)hashMap.get(string)) : ObjektZustandTyp.KEINE_ANGABE;
    }

    protected WazObjektZustandTyp writeObjektZustandWaz(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        String string = this.getEstateValueAsNonEmptyString("ZUSTAND", "ZUSTAND", estateImpl);
        if (string == null) {
            return null;
        }
        HashMap<String, WazObjektZustandTyp> hashMap = new HashMap<String, WazObjektZustandTyp>();
        hashMap.put("ABRISSOBJEKT", WazObjektZustandTyp.ABBRUCHREIF);
        hashMap.put("AUSGEZEICHNET", WazObjektZustandTyp.GEPFLEGT);
        hashMap.put("ERSTBEZUG", WazObjektZustandTyp.ERSTBEZUG);
        hashMap.put("ERSTBEZUG_NACH_SANIERUNG", WazObjektZustandTyp.ERSTBEZUG_NACH_SANIERUNG);
        hashMap.put("GEPFLEGT", WazObjektZustandTyp.GEPFLEGT);
        hashMap.put("GUT", WazObjektZustandTyp.GEPFLEGT);
        hashMap.put("MODERNISIERT", WazObjektZustandTyp.MODERNISIERT);
        hashMap.put("NACH_VEREINBARUNG", WazObjektZustandTyp.NACH_VEREINBARUNG);
        hashMap.put("NEUWERTIG", WazObjektZustandTyp.NEUWERTIG);
        hashMap.put("RENOVIERT_TEIL", WazObjektZustandTyp.UNRENOVIERT);
        hashMap.put("RENOVIERT_VOLL", WazObjektZustandTyp.VOLLSTAENDIG_RENOVIERT);
        hashMap.put("RENOVIERUNGSBEDARF_TEIL", WazObjektZustandTyp.RENOVIERUNGSBEDUERFTIG);
        hashMap.put("RENOVIERUNGSBEDARF_VOLL", WazObjektZustandTyp.RENOVIERUNGSBEDUERFTIG);
        hashMap.put("SANIERT_VOLL", WazObjektZustandTyp.SANIERT);
        return hashMap.containsKey(string) ? (WazObjektZustandTyp)((Object)hashMap.get(string)) : WazObjektZustandTyp.UNBEKANNT;
    }

    protected StellplatzKategorieTyp writeStellplatzKategorie(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        String[] stringArray = (String[])this.getEstateValue("FLAECHEN", "STELLPLATZART", estateImpl);
        if (stringArray == null) {
            return StellplatzKategorieTyp.KEINE_ANGABE;
        }
        for (String string : stringArray) {
            if ("AUSSEN".equals(string)) {
                return StellplatzKategorieTyp.AUSSEN_STELLPLATZ;
            }
            if ("CARPORT".equals(string)) {
                return StellplatzKategorieTyp.CARPORT;
            }
            if ("DUPLEX".equals(string)) {
                return StellplatzKategorieTyp.DUPLEX;
            }
            if ("GARAGE".equals(string)) {
                return StellplatzKategorieTyp.GARAGE;
            }
            if ("PARKHAUS".equals(string)) {
                return StellplatzKategorieTyp.PARKHAUS;
            }
            if (!"TIEFGARAGE".equals(string)) continue;
            return StellplatzKategorieTyp.TIEFGARAGE;
        }
        return stringArray.length > 0 ? StellplatzKategorieTyp.TRUE : StellplatzKategorieTyp.KEINE_ANGABE;
    }

    protected RauchenTyp writeRauchen(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        String string = this.getEstateValueAsNonEmptyString("VERWALTUNG", "NICHTRAUCHER", estateImpl);
        if ("JA".equals(string)) {
            return RauchenTyp.UNERWUENSCHT;
        }
        if ("NEIN".equals(string)) {
            return RauchenTyp.ERLAUBT;
        }
        return RauchenTyp.KEINE_ANGABE;
    }

    protected Boolean writeRaucherOk(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        String string = this.getEstateValueAsNonEmptyString("VERWALTUNG", "NICHTRAUCHER", estateImpl);
        if ("JA".equals(string)) {
            return false;
        }
        if ("EGAL".equals(string)) {
            return true;
        }
        if ("NEIN".equals(string)) {
            return true;
        }
        return null;
    }

    protected TVAnschlussTyp writeTvAnschluss(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        List<String> list = this.getEstateValueAsList("AUSSTATTUNG", "TECHNIK", estateImpl);
        if (list.contains("KABEL_SAT_TV")) {
            return TVAnschlussTyp.KABEL_UND_SATELLIT;
        }
        if (list.contains("KABEL_TV")) {
            return TVAnschlussTyp.KABEL;
        }
        if (list.contains("SAT_TV")) {
            return TVAnschlussTyp.SATELLIT;
        }
        return TVAnschlussTyp.KEINE_ANGABE;
    }

    protected VermarktungGewerbeTyp writeVermarktungGewerbe(EstateImpl estateImpl) {
        VermarktungGewerbeTyp vermarktungGewerbeTyp = IS24XmlUtils.getFactory().createVermarktungGewerbeTyp();
        vermarktungGewerbeTyp.setNebenkosten(this.getEstateValueAsDouble("PREISE", "NEBENKOSTEN", estateImpl));
        if ("KAUF".equals(estateImpl.getAction())) {
            VermarktungGewerbeTyp.Kauf kauf = IS24XmlUtils.getFactory().createVermarktungGewerbeTypKauf();
            if (estateImpl.isHiddenPrices()) {
                kauf.setPreis(0.0);
            } else {
                kauf.setPreis(this.getEstateValueAsDouble("PREISE", "KAUFPREIS", estateImpl));
            }
            vermarktungGewerbeTyp.setKauf(IS24XmlUtils.getFactory().createVermarktungGewerbeTypKauf(kauf));
        } else if ("MIETE".equals(estateImpl.getAction())) {
            VermarktungGewerbeTyp.Miete miete = IS24XmlUtils.getFactory().createVermarktungGewerbeTypMiete();
            miete.setKaution(this.getEstateValueAsNonEmptyString("PREISE", "KAUTION", estateImpl));
            if (StringUtils.isEmpty((String)miete.getKaution())) {
                miete.setKaution(this.getFormattedEstateValue("PREISE", "KAUTION_BETRAG", estateImpl));
            }
            if (estateImpl.isHiddenPrices()) {
                miete.setPro(MieteEinheitTyp.MONAT);
                miete.setKaltmiete(0.0);
            } else if (estateImpl.hasAttribute("PREISE", "KALTMIETE")) {
                miete.setPro(MieteEinheitTyp.MONAT);
                miete.setKaltmiete(this.getEstateValueAsDouble("PREISE", "KALTMIETE", estateImpl));
            } else if (estateImpl.hasAttribute("PREISE", "KALTMIETE_QM")) {
                miete.setPro(MieteEinheitTyp.QUADRATMETER);
                miete.setKaltmiete(this.getEstateValueAsDouble("PREISE", "KALTMIETE_QM", estateImpl));
            }
            vermarktungGewerbeTyp.setMiete(IS24XmlUtils.getFactory().createVermarktungGewerbeTypMiete(miete));
        } else if ("PACHT".equals(estateImpl.getAction()) || "ERBPACHT".equals(estateImpl.getAction())) {
            VermarktungGewerbeTyp.Miete miete = IS24XmlUtils.getFactory().createVermarktungGewerbeTypMiete();
            miete.setKaution(this.getEstateValueAsNonEmptyString("PREISE", "KAUTION", estateImpl));
            if (StringUtils.isEmpty((String)miete.getKaution())) {
                miete.setKaution(this.getFormattedEstateValue("PREISE", "KAUTION_BETRAG", estateImpl));
            }
            if (estateImpl.isHiddenPrices()) {
                miete.setPro(MieteEinheitTyp.MONAT);
                miete.setKaltmiete(0.0);
            } else if (estateImpl.hasAttribute("PREISE", "PACHT")) {
                miete.setPro(MieteEinheitTyp.MONAT);
                miete.setKaltmiete(this.getEstateValueAsDouble("PREISE", "PACHT", estateImpl));
            } else if (estateImpl.hasAttribute("PREISE", "PACHT_QM")) {
                miete.setPro(MieteEinheitTyp.QUADRATMETER);
                miete.setKaltmiete(this.getEstateValueAsDouble("PREISE", "PACHT_QM", estateImpl));
            }
            vermarktungGewerbeTyp.setMiete(IS24XmlUtils.getFactory().createVermarktungGewerbeTypMiete(miete));
        }
        return vermarktungGewerbeTyp;
    }

    protected VermarktungGewerbeTyp2 writeVermarktungGewerbe2(EstateImpl estateImpl) {
        VermarktungGewerbeTyp2 vermarktungGewerbeTyp2 = IS24XmlUtils.getFactory().createVermarktungGewerbeTyp2();
        vermarktungGewerbeTyp2.setNebenkosten(this.getEstateValueAsDouble("PREISE", "NEBENKOSTEN", estateImpl));
        if ("KAUF".equals(estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGewerbeTyp2.setPreis(0.0);
            } else {
                vermarktungGewerbeTyp2.setPreis(this.getEstateValueAsDouble("PREISE", "KAUFPREIS", estateImpl));
                vermarktungGewerbeTyp2.setPreisProParkflaeche(this.getEstateValueAsDouble("PREISE", "STELLPLATZ_PREIS", estateImpl));
            }
            vermarktungGewerbeTyp2.setKauf(IS24XmlUtils.getFactory().createVermarktungGewerbeTyp2Kauf(null));
        } else if ("MIETE".equals(estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGewerbeTyp2.setPreis(0.0);
            } else {
                vermarktungGewerbeTyp2.setPreis(this.getEstateValueAsDouble("PREISE", "KALTMIETE", estateImpl));
                vermarktungGewerbeTyp2.setPreisProParkflaeche(this.getEstateValueAsDouble("PREISE", "STELLPLATZ_MIETE", estateImpl));
            }
            VermarktungGewerbeTyp2.Miete miete = IS24XmlUtils.getFactory().createVermarktungGewerbeTyp2Miete();
            miete.setKaution(this.getEstateValueAsNonEmptyString("PREISE", "KAUTION", estateImpl));
            if (StringUtils.isEmpty((String)miete.getKaution())) {
                miete.setKaution(this.getFormattedEstateValue("PREISE", "KAUTION_BETRAG", estateImpl));
            }
            vermarktungGewerbeTyp2.setMiete(miete);
        } else if ("PACHT".equals(estateImpl.getAction()) || "ERBPACHT".equals(estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGewerbeTyp2.setPreis(0.0);
            } else {
                vermarktungGewerbeTyp2.setPreis(this.getEstateValueAsDouble("PREISE", "PACHT", estateImpl));
                vermarktungGewerbeTyp2.setPreisProParkflaeche(this.getEstateValueAsDouble("PREISE", "STELLPLATZ_MIETE", estateImpl));
            }
            VermarktungGewerbeTyp2.Miete miete = IS24XmlUtils.getFactory().createVermarktungGewerbeTyp2Miete();
            miete.setKaution(this.getEstateValueAsNonEmptyString("PREISE", "KAUTION", estateImpl));
            if (StringUtils.isEmpty((String)miete.getKaution())) {
                miete.setKaution(this.getFormattedEstateValue("PREISE", "KAUTION_BETRAG", estateImpl));
            }
            vermarktungGewerbeTyp2.setMiete(miete);
        }
        return vermarktungGewerbeTyp2;
    }

    protected VermarktungGrundstueckGewerbeTyp writeVermarktungGrundstueckGewerbe(EstateImpl estateImpl) {
        VermarktungGrundstueckGewerbeTyp vermarktungGrundstueckGewerbeTyp = IS24XmlUtils.getFactory().createVermarktungGrundstueckGewerbeTyp();
        if ("ERBPACHT".equals(estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckGewerbeTyp.setPreis(0.0);
            } else {
                vermarktungGrundstueckGewerbeTyp.setPreis(this.getEstateValueAsDouble("PREISE", "PACHT", estateImpl));
            }
            VermarktungGrundstueckGewerbeTyp.Erbpacht erbpacht = IS24XmlUtils.getFactory().createVermarktungGrundstueckGewerbeTypErbpacht();
            erbpacht.setDauerInJahren(this.getEstateValueAsLong("VERWALTUNG", "ERBPACHT_DAUER", estateImpl));
            vermarktungGrundstueckGewerbeTyp.setErbpacht(IS24XmlUtils.getFactory().createVermarktungGrundstueckGewerbeTypErbpacht(erbpacht));
        } else if ("KAUF".equals(estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckGewerbeTyp.setPreis(0.0);
            } else {
                vermarktungGrundstueckGewerbeTyp.setPreis(this.getEstateValueAsDouble("PREISE", "KAUFPREIS", estateImpl));
            }
            VermarktungGrundstueckGewerbeTyp.Kauf kauf = IS24XmlUtils.getFactory().createVermarktungGrundstueckGewerbeTypKauf();
            vermarktungGrundstueckGewerbeTyp.setKauf(IS24XmlUtils.getFactory().createVermarktungGrundstueckGewerbeTypKauf(kauf));
        } else if ("MIETE".equals(estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckGewerbeTyp.setPreis(0.0);
            } else {
                vermarktungGrundstueckGewerbeTyp.setPreis(this.getEstateValueAsDouble("PREISE", "KALTMIETE", estateImpl));
            }
            VermarktungGrundstueckGewerbeTyp.Miete miete = IS24XmlUtils.getFactory().createVermarktungGrundstueckGewerbeTypMiete();
            vermarktungGrundstueckGewerbeTyp.setMiete(IS24XmlUtils.getFactory().createVermarktungGrundstueckGewerbeTypMiete(miete));
        } else if ("PACHT".equals(estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckGewerbeTyp.setPreis(0.0);
            } else {
                vermarktungGrundstueckGewerbeTyp.setPreis(this.getEstateValueAsDouble("PREISE", "PACHT", estateImpl));
            }
            VermarktungGrundstueckGewerbeTyp.Pacht pacht = IS24XmlUtils.getFactory().createVermarktungGrundstueckGewerbeTypPacht();
            vermarktungGrundstueckGewerbeTyp.setPacht(IS24XmlUtils.getFactory().createVermarktungGrundstueckGewerbeTypPacht(pacht));
        }
        return vermarktungGrundstueckGewerbeTyp;
    }

    protected VermarktungGrundstueckWohnenKaufTyp writeVermarktungGrundstueckWohnenKauf(EstateImpl estateImpl) {
        VermarktungGrundstueckWohnenKaufTyp vermarktungGrundstueckWohnenKaufTyp = IS24XmlUtils.getFactory().createVermarktungGrundstueckWohnenKaufTyp();
        if ("ERBPACHT".equals(estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckWohnenKaufTyp.setPreis(0.0);
            } else {
                vermarktungGrundstueckWohnenKaufTyp.setPreis(this.getEstateValueAsDouble("PREISE", "PACHT", estateImpl));
            }
            VermarktungGrundstueckWohnenKaufTyp.Erbpacht erbpacht = IS24XmlUtils.getFactory().createVermarktungGrundstueckWohnenKaufTypErbpacht();
            erbpacht.setDauerInJahren(this.getEstateValueAsLong("VERWALTUNG", "ERBPACHT_DAUER", estateImpl));
            vermarktungGrundstueckWohnenKaufTyp.setErbpacht(IS24XmlUtils.getFactory().createVermarktungGrundstueckWohnenKaufTypErbpacht(erbpacht));
        } else if ("KAUF".equals(estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckWohnenKaufTyp.setPreis(0.0);
            } else {
                vermarktungGrundstueckWohnenKaufTyp.setPreis(this.getEstateValueAsDouble("PREISE", "KAUFPREIS", estateImpl));
            }
            VermarktungGrundstueckWohnenKaufTyp.Kauf kauf = IS24XmlUtils.getFactory().createVermarktungGrundstueckWohnenKaufTypKauf();
            vermarktungGrundstueckWohnenKaufTyp.setKauf(IS24XmlUtils.getFactory().createVermarktungGrundstueckWohnenKaufTypKauf(kauf));
        }
        return vermarktungGrundstueckWohnenKaufTyp;
    }

    protected VermarktungGrundstueckWohnenMieteTyp writeVermarktungGrundstueckWohnenMiete(EstateImpl estateImpl) {
        VermarktungGrundstueckWohnenMieteTyp vermarktungGrundstueckWohnenMieteTyp = IS24XmlUtils.getFactory().createVermarktungGrundstueckWohnenMieteTyp();
        if ("MIETE".equals(estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckWohnenMieteTyp.setPreis(0.0);
            } else {
                vermarktungGrundstueckWohnenMieteTyp.setPreis(this.getEstateValueAsDouble("PREISE", "KALTMIETE", estateImpl));
            }
            VermarktungGrundstueckWohnenMieteTyp.Miete miete = IS24XmlUtils.getFactory().createVermarktungGrundstueckWohnenMieteTypMiete();
            vermarktungGrundstueckWohnenMieteTyp.setMiete(IS24XmlUtils.getFactory().createVermarktungGrundstueckWohnenMieteTypMiete(miete));
        } else if ("PACHT".equals(estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckWohnenMieteTyp.setPreis(0.0);
            } else {
                vermarktungGrundstueckWohnenMieteTyp.setPreis(this.getEstateValueAsDouble("PREISE", "PACHT", estateImpl));
            }
            VermarktungGrundstueckWohnenMieteTyp.Pacht pacht = IS24XmlUtils.getFactory().createVermarktungGrundstueckWohnenMieteTypPacht();
            vermarktungGrundstueckWohnenMieteTyp.setPacht(IS24XmlUtils.getFactory().createVermarktungGrundstueckWohnenMieteTypPacht(pacht));
        }
        return vermarktungGrundstueckWohnenMieteTyp;
    }

    protected ZulieferungTyp writeZulieferung(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        String string = this.getEstateValueAsNonEmptyString("UMFELD", "ZULIEFERUNG", estateImpl);
        if ("DIREKT".equals(string)) {
            return ZulieferungTyp.DIREKTER_ZUGANG;
        }
        if ("GANZTAEGIG".equals(string)) {
            return ZulieferungTyp.GANZTAEGIG;
        }
        if ("NICHT_DIREKT".equals(string)) {
            return ZulieferungTyp.KEINE_DIREKTE_ANFAHRT;
        }
        if ("PKW_ZUFAHRT".equals(string)) {
            return ZulieferungTyp.PKW_ZUFAHRT;
        }
        if ("VON_HINTEN".equals(string)) {
            return ZulieferungTyp.VON_HINTEN;
        }
        if ("VON_VORN".equals(string)) {
            return ZulieferungTyp.VON_VORN;
        }
        if ("VORMITTAGS".equals(string)) {
            return ZulieferungTyp.VORMITTAGS;
        }
        return ZulieferungTyp.KEINE_ANGABE;
    }
}

